#!/usr/bin/perl 
#use strict;
#use warnings;

# default path to astguiclient configuration file:
$PATHconf =     '/etc/astguiclient.conf';

open(conf, "$PATHconf") || die "can't open $PATHconf: $!\n";
@conf = <conf>;
close(conf);
$i=0;
foreach(@conf)
    {
    $line = $conf[$i];
    $line =~ s/ |>|\n|\r|\t|\#.*|;.*//gi;
    if ( ($line =~ /^PATHhome/) && ($CLIhome < 1) )
        {$PATHhome = $line;   $PATHhome =~ s/.*=//gi;}
    if ( ($line =~ /^PATHlogs/) && ($CLIlogs < 1) )
        {$PATHlogs = $line;   $PATHlogs =~ s/.*=//gi;}
    if ( ($line =~ /^PATHagi/) && ($CLIagi < 1) )
        {$PATHagi = $line;   $PATHagi =~ s/.*=//gi;}
    if ( ($line =~ /^PATHweb/) && ($CLIweb < 1) )
        {$PATHweb = $line;   $PATHweb =~ s/.*=//gi;}
    if ( ($line =~ /^PATHsounds/) && ($CLIsounds < 1) )
        {$PATHsounds = $line;   $PATHsounds =~ s/.*=//gi;}
    if ( ($line =~ /^PATHmonitor/) && ($CLImonitor < 1) )
        {$PATHmonitor = $line;   $PATHmonitor =~ s/.*=//gi;}
    if ( ($line =~ /^VARserver_ip/) && ($CLIserver_ip < 1) )
        {$VARserver_ip = $line;   $VARserver_ip =~ s/.*=//gi;}
    if ( ($line =~ /^VARDB_server/) && ($CLIDB_server < 1) )
        {$VARDB_server = $line;   $VARDB_server =~ s/.*=//gi;}
    if ( ($line =~ /^VARDB_database/) && ($CLIDB_database < 1) )
        {$VARDB_database = $line;   $VARDB_database =~ s/.*=//gi;}
    if ( ($line =~ /^VARDB_user/) && ($CLIDB_user < 1) )
        {$VARDB_user = $line;   $VARDB_user =~ s/.*=//gi;}
    if ( ($line =~ /^VARDB_pass/) && ($CLIDB_pass < 1) )
        {$VARDB_pass = $line;   $VARDB_pass =~ s/.*=//gi;}
    if ( ($line =~ /^VARDB_port/) && ($CLIDB_port < 1) )
        {$VARDB_port = $line;   $VARDB_port =~ s/.*=//gi;}
    if ( ($line =~ /^VARREPORT_host/) && ($CLIREPORT_host < 1) )
        {$VARREPORT_host = $line;   $VARREPORT_host =~ s/.*=//gi;}
    if ( ($line =~ /^VARREPORT_user/) && ($CLIREPORT_user < 1) )
        {$VARREPORT_user = $line;   $VARREPORT_user =~ s/.*=//gi;}
    if ( ($line =~ /^VARREPORT_pass/) && ($CLIREPORT_pass < 1) )
        {$VARREPORT_pass = $line;   $VARREPORT_pass =~ s/.*=//gi;}
    if ( ($line =~ /^VARREPORT_port/) && ($CLIREPORT_port < 1) )
        {$VARREPORT_port = $line;   $VARREPORT_port =~ s/.*=//gi;}
    if ( ($line =~ /^VARREPORT_dir/) && ($CLIREPORT_dir < 1) )
        {$VARREPORT_dir = $line;   $VARREPORT_dir =~ s/.*=//gi;}
    $i++;
    }

if (!$VARDB_port) {$VARDB_port='3306';}


use DBI;

my $dbh = DBI->connect("DBI:mysql:$VARDB_database:$VARDB_server:$VARDB_port", "$VARDB_user", "$VARDB_pass")
 or die "Couldn't connect to database: " . DBI->errstr;

# my $dbh = DBI->connect("DBI:mysql:asterisk;host=localhost", 'cron', '1234')
#     || die "Could not connect to database: $DBI::errstr";

my $sth = $dbh->prepare("select VARIABLE_VALUE from information_schema.SESSION_STATUS where VARIABLE_NAME = 'Uptime'");
$sth->execute();
my $uptime = $sth->fetch();
$sth->finish();

my $qry = $dbh->prepare("SELECT `ip`, if(`deleted` IS NULL, 1, 0) AS 'active' FROM `tbl_firewall` WHERE `deleted` IS NULL OR `deleted` > DATE_SUB(`deleted`, INTERVAL @$uptime SECOND)");
$qry->execute();

#print "SELECT `ip`, if(`deleted` IS NULL, 1, 0) AS 'active' FROM `tbl_firewall` WHERE `deleted` IS NULL OR `deleted` > DATE_SUB(`deleted`, INTERVAL @$uptime SECOND)";

while (my @row = $qry->fetchrow_array()) {
#    my $ipcheck = `/usr/sbin/iptables-save | grep '$row[0]/32'`;
    my $ipcheck = `/usr/sbin/iptables-save | grep '$row[0]'`;
    $ipcheck =~ s/^\s+//;
    $ipcheck =~ s/\s+$//;
    print "IP IS >> $ipcheck----$row[1]";
    print "\n";
    if ($ipcheck eq "")
    {
        if ($row[1] == 1)
        {
            print "IP to insert: $row[0]\n";
            `/usr/sbin/iptables -A INPUT -s $row[0]  -p tcp -m multiport --dport 80,443,8088,8089 -j ACCEPT`;
	    `/usr/sbin/iptables -A INPUT -s $row[0]  -p udp -m udp --dport 1024:65535 -j ACCEPT`;
        }
        else
        {
            print "IP already removed: $row[0]\n";
        }
    }
    else
    {
        if ($row[1] == 0)
        {
            print "IP to remove: $row[0]\n";
            `/usr/sbin/iptables -D INPUT -s $row[0]  -p tcp -m multiport --dport 80,443,8088,8089 -j ACCEPT`;
            `/usr/sbin/iptables -D INPUT -s $row[0]  -p udp -m udp --dport 1024:65535 -j ACCEPT`;
        }
        else
        {
            print "IP already added: $row[0]\n";
        }
    }
}

$qry->finish();
$dbh->disconnect();
