CREATE TABLE `tbl_firewall` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `ip` varchar(15) COLLATE utf8_unicode_ci NOT NULL,
  `notes` text COLLATE utf8_unicode_ci,
  `userId` int(11) unsigned NOT NULL,
  `created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `deleted` timestamp NULL DEFAULT NULL,
  `user_group` varchar(20) COLLATE utf8_unicode_ci DEFAULT NULL,
  `portal_user` varchar(20) COLLATE utf8_unicode_ci DEFAULT NULL,
  `reset` varchar(20) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `deleted` (`deleted`)
) ENGINE=MyISAM AUTO_INCREMENT=82 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

CREATE TABLE `tbl_branding` (
`branding_id` int(11) NOT NULL AUTO_INCREMENT,
`slogan` text COLLATE utf8_unicode_ci NOT NULL,
`company_email` varchar(30) COLLATE utf8_unicode_ci DEFAULT NULL,
`phone_number` varchar(30) COLLATE utf8_unicode_ci NOT NULL,
`domain_name` varchar(50) COLLATE utf8_unicode_ci NOT NULL,
`favicon` blob NOT NULL,
`logo` blob NOT NULL,
`company_name` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
`branding_color` varchar(10) COLLATE utf8_unicode_ci DEFAULT NULL,
PRIMARY KEY (`branding_id`)
) ENGINE=MyISAM AUTO_INCREMENT=19 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;


CREATE TABLE `tbl_gateway` (
  `id` int(11) NOT NULL,
  `gateway_id` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `name` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `host` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `auth_type` enum('USER','IP') COLLATE utf8_unicode_ci NOT NULL DEFAULT 'USER',
  `username` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `secret` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `status` enum('Y','N') COLLATE utf8_unicode_ci NOT NULL DEFAULT 'N',
  `tech_prefix` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `dtmf_type` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `user_group` varchar(255) COLLATE utf8_unicode_ci NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

ALTER TABLE `tbl_gateway`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `id` (`id`);

ALTER TABLE `tbl_gateway`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=1000;

Alter Table tbl_gateway ADD COLUMN random_caller_id VARCHAR(50) DEFAULT "NO";
Alter Table tbl_gateway ADD COLUMN random_caller_id_prefix VARCHAR(50) DEFAULT "NO";
Alter Table tbl_gateway ADD COLUMN random_caller_id_trim_digits VARCHAR(50) DEFAULT NULL;
Alter Table tbl_gateway ADD COLUMN call_recording VARCHAR(50) DEFAULT "YES";
Alter Table tbl_gateway ADD COLUMN rotating_clis TEXT DEFAULT NULL;
Alter Table tbl_gateway ADD COLUMN account_entry_custom TEXT DEFAULT NULL;
Alter Table tbl_gateway ADD COLUMN dialplan_entry_custom TEXT DEFAULT NULL;


ALTER TABLE vicidial_campaigns Add COLUMN soundboard_id VARCHAR(255) DEFAULT NULL;
ALTER TABLE vicidial_campaigns Add COLUMN sales_target INT(11) DEFAULT 0;

ALTER TABLE vicidial_avatar_audio ADD id INT AUTO_INCREMENT PRIMARY KEY;
ALTER TABLE `vicidial_avatar_audio` ADD `color` VARCHAR(255) NULL DEFAULT '#3eb4c1';

ALTER TABLE vicidial_users ADD COLUMN portal_name varchar(255) DEFAULT 'NONE';
ALTER TABLE vicidial_users ADD COLUMN portal_user varchar(255) DEFAULT NULL;
ALTER TABLE vicidial_users ADD COLUMN portal_pass varchar(255) DEFAULT NULL;
ALTER TABLE vicidial_users ADD COLUMN permissions TEXT DEFAULT NULL;

Alter Table vicidial_dnc ADD COLUMN user VARCHAR(20) DEFAULT NULL;
Alter Table vicidial_dnc ADD COLUMN created_date timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP;

Alter Table vicidial_campaign_dnc ADD COLUMN user VARCHAR(20) DEFAULT NULL;
Alter Table vicidial_campaign_dnc ADD COLUMN created_date timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP;

ALTER TABLE vicidial_dnc CHANGE COLUMN created_date created_date TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP;
ALTER TABLE vicidial_campaign_dnc CHANGE COLUMN created_date created_date TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP;

ALTER TABLE vicidial_dnc add COLUMN updated_by varchar(20) DEFAULT NULL;
ALTER TABLE vicidial_campaign_dnc add COLUMN updated_by varchar(20) DEFAULT NULL;

ALTER TABLE vicidial_campaign_dnc ADD COLUMN updated_date timestamp NULL ON UPDATE current_timestamp();
ALTER TABLE vicidial_dnc ADD COLUMN updated_date timestamp NULL ON UPDATE current_timestamp();


Alter Table vicidial_filter_phone_numbers ADD COLUMN user VARCHAR(20) DEFAULT NULL;
Alter Table vicidial_filter_phone_numbers ADD COLUMN created_date timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP;
ALTER TABLE vicidial_filter_phone_numbers CHANGE COLUMN created_date created_date TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP;
ALTER TABLE vicidial_filter_phone_numbers add COLUMN updated_by varchar(20) DEFAULT NULL;
ALTER TABLE vicidial_filter_phone_numbers ADD COLUMN updated_date timestamp NULL ON UPDATE current_timestamp();



ALTER TABLE audio_store_details ADD COLUMN user_group varchar(20) DEFAULT NULL;
ALTER TABLE audio_store_details ADD COLUMN real_file_name varchar(255) DEFAULT NULL;
ALTER TABLE audio_store_details ADD id INT AUTO_INCREMENT PRIMARY KEY;
ALTER table audio_store_details add UNIQUE(id);
ALTER TABLE audio_store_details ADD COLUMN created_date TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP;
ALTER TABLE audio_store_details DROP INDEX audio_filename;

DELETE FROM phones WHERE extension='callin';
DELETE FROM phones WHERE extension='gs102';

ALTER TABLE vicidial_lead_filters ADD COLUMN lead_filter_json TEXT DEFAULT NULL;
ALTER table vicidial_user_groups add concurrent varchar(10) DEFAULT '0';
UPDATE vicidial_user_groups set group_name='ADMINISTRATORS' where group_name='VICIDIAL ADMINISTRATORS';

CREATE TABLE `vicidial_agent_sales_log` (
  `agent_log_id` int(9) unsigned NOT NULL,
  `user` varchar(20) COLLATE utf8_unicode_ci DEFAULT NULL,
  `server_ip` varchar(15) COLLATE utf8_unicode_ci NOT NULL,
  `event_time` datetime DEFAULT NULL,
  `lead_id` int(9) unsigned DEFAULT NULL,
  `campaign_id` varchar(8) COLLATE utf8_unicode_ci DEFAULT NULL,
  `pause_epoch` int(10) unsigned DEFAULT NULL,
  `pause_sec` smallint(5) unsigned DEFAULT 0,
  `wait_epoch` int(10) unsigned DEFAULT NULL,
  `wait_sec` smallint(5) unsigned DEFAULT 0,
  `talk_epoch` int(10) unsigned DEFAULT NULL,
  `talk_sec` smallint(5) unsigned DEFAULT 0,
  `dispo_epoch` int(10) unsigned DEFAULT NULL,
  `dispo_sec` smallint(5) unsigned DEFAULT 0,
  `status` varchar(6) COLLATE utf8_unicode_ci DEFAULT NULL,
  `user_group` varchar(20) COLLATE utf8_unicode_ci DEFAULT NULL,
  `comments` varchar(20) COLLATE utf8_unicode_ci DEFAULT NULL,
  `sub_status` varchar(6) COLLATE utf8_unicode_ci DEFAULT NULL,
  `dead_epoch` int(10) unsigned DEFAULT NULL,
  `dead_sec` smallint(5) unsigned DEFAULT 0,
  `processed` enum('Y','N') COLLATE utf8_unicode_ci DEFAULT 'N',
  `uniqueid` varchar(20) COLLATE utf8_unicode_ci DEFAULT '',
  `pause_type` enum('UNDEFINED','SYSTEM','AGENT','API','ADMIN') COLLATE utf8_unicode_ci DEFAULT 'UNDEFINED',
  PRIMARY KEY (`agent_log_id`),
  KEY `lead_id` (`lead_id`),
  KEY `user` (`user`),
  KEY `event_time` (`event_time`),
  KEY `time_user` (`event_time`,`user`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;


UPDATE system_settings SET custom_fields_enabled='1',agent_push_events="1",agent_push_url="/agent/events/index.php?user=--A--user--B--&event=--A--event--B--&message=--A--message--B--&lead_id=--A--lead_id--B--&epoch=--A--epoch--B--&agent_log_id=--A--agent_log_id--B--&counter=--A--counter--B--&campaign=--A--campaign--B--";



-- set global query_cache_type='OFF';
-- set global query_cache_size=0;
-- set global key_buffer_size = 1073741824;
-- set global max_connections = 2000;
-- set global max_heap_table_size = 67108864;
-- set global table_open_cache = 8192;

-- zypper install php-mcrypt

-- mysql -uroot -f -p asterisk --verbose < /usr/local/src/dialer/admin_build/install/logs.sql