<?php 
require_once "../../../theme.php";
header("Content-type: text/css; charset:UTF-8"); 
?>
@font-face {
    font-family: 'Roboto';
    src: url('fonts/roboto-thin-webfont.woff2') format('woff2'),
         url('fonts/roboto-thin-webfont.woff') format('woff'),
         url('fonts/roboto-thin-webfont.svg#robotothin') format('svg');
    font-weight: 200;
    font-style: normal;

}


@font-face {
    font-family: 'Roboto';
    src: url('fonts/roboto-light-webfont.woff2') format('woff2'),
         url('fonts/roboto-light-webfont.woff') format('woff'),
         url('fonts/roboto-light-webfont.svg#robotolight') format('svg');
    font-weight: 300;
    font-style: normal;

}


@font-face {
    font-family: 'Roboto';
    src: url('fonts/roboto-regular-webfont.woff2') format('woff2'),
         url('fonts/roboto-regular-webfont.woff') format('woff'),
         url('fonts/roboto-regular-webfont.svg#robotoregular') format('svg');
    font-weight: 400;
    font-style: normal;

}


@font-face {
    font-family: 'Roboto';
    src: url('fonts/roboto-medium-webfont.woff2') format('woff2'),
         url('fonts/roboto-medium-webfont.woff') format('woff'),
         url('fonts/roboto-medium-webfont.svg#robotomedium') format('svg');
    font-weight: 500;
    font-style: normal;

}

@font-face {
    font-family: 'Roboto';
    src: url('fonts/roboto-black-webfont.woff2') format('woff2'),
         url('fonts/roboto-black-webfont.woff') format('woff'),
         url('fonts/roboto-black-webfont.svg#robotoblack') format('svg');
    font-weight: 600;
    font-style: normal;

}

@font-face {
    font-family: 'Roboto';
    src: url('fonts/roboto-bold-webfont.woff2') format('woff2'),
         url('fonts/roboto-bold-webfont.woff') format('woff'),
         url('fonts/roboto-bold-webfont.svg#robotobold') format('svg');
    font-weight: 700;
    font-style: normal;

}

/* flat-icon */


@font-face {
  font-family: "Flaticon";
  src: url("flat-icon/Flaticon.eot");
  src: url("flat-icon/Flaticon.eot?#iefix") format("embedded-opentype"),
       url("flat-icon/Flaticon.woff2") format("woff2"),
       url("flat-icon/Flaticon.woff") format("woff"),
       url("flat-icon/Flaticon.ttf") format("truetype"),
       url("flat-icon/Flaticon.svg#Flaticon") format("svg");
  font-weight: normal;
  font-style: normal;
}



@media screen and (-webkit-min-device-pixel-ratio:0) {
  @font-face {
    font-family: "Flaticon";
    src: url("./Flaticon.svg#Flaticon") format("svg");
  }
}


[class^="flaticon-"]:before, [class*=" flaticon-"]:before,
[class^="flaticon-"]:after, [class*=" flaticon-"]:after {   
  font-family: Flaticon;
      
font-style: normal;

}

.flaticon-mail-black-envelope-symbol:before { content: "\f100"; }
.flaticon-support:before { content: "\f101"; }
.flaticon-microphone-of-voice:before { content: "\f102"; }
.flaticon-play-button:before { content: "\f103"; }
.flaticon-volume-up-interface-symbol:before { content: "\f104"; }
.flaticon-house-black-silhouette-without-door:before { content: "\f105"; }
.flaticon-stop:before { content: "\f106"; }
.flaticon-quaver-outline:before { content: "\f107"; }
.flaticon-tiles:before { content: "\f108"; }
.flaticon-telephone-handle-silhouette:before { content: "\f109"; }
.flaticon-power:before { content: "\f10a"; }
.flaticon-search:before { content: "\f10b"; }
.flaticon-programming-code:before { content: "\f10c"; }
.flaticon-speak:before { content: "\f10d"; }
.flaticon-user:before { content: "\f10e"; }
.flaticon-checked:before { content: "\f10f"; }
.flaticon-settings-work-tool:before { content: "\f110"; }
.flaticon-restore-screen:before { content: "\f111"; }
.flaticon-full-screen:before { content: "\f112"; }
.flaticon-clock:before { content: "\f113"; }
.flaticon-phone-receiver:before { content: "\f114"; }
.flaticon-phone-receiver-1:before { content: "\f115"; }
.flaticon-call:before { content: "\f116"; }
.flaticon-call-1:before { content: "\f117"; }
.flaticon-telephone:before { content: "\f118"; }
.flaticon-phone-receiver-2:before { content: "\f119"; }
.flaticon-call-2:before { content: "\f11a"; }

.flaticon-transfer:before { content: "\f11b"; }
.flaticon-phone-receiver-3:before { content: "\f11c"; }
.flaticon-phone:before { content: "\f11d"; }
.flaticon-telephone-1:before { content: "\f11e"; }
.flaticon-call-3:before { content: "\f11f"; }
.flaticon-call-4:before { content: "\f120"; }
.flaticon-cancel:before { content: "\f121"; }
.flaticon-phone-1:before { content: "\f122"; }
.flaticon-call-5:before { content: "\f123"; }
.flaticon-phone-2:before { content: "\f124"; }
.flaticon-copy:before { content: "\f125"; }
.flaticon-document:before { content: "\f126"; }

/* new */

.flaticon1-refresh:before { content: "\f100"; }
.flaticon1-pause-sign:before { content: "\f101"; }
.flaticon1-mic:before { content: "\f102"; }
.flaticon1-mic-1:before { content: "\f103"; }
.flaticon1-info:before { content: "\f104"; }
.flaticon1-customer-service:before { content: "\f105"; }
.flaticon1-call:before { content: "\f106"; }
.flaticon1-call-1:before { content: "\f107"; }
.flaticon1-phone:before { content: "\f108"; }
.flaticon1-call-2:before { content: "\f109"; }
.flaticon1-headset:before { content: "\f10a"; }
.flaticon1-support:before { content: "\f10b"; }
.flaticon1-call-3:before { content: "\f10c"; }
.flaticon1-call-4:before { content: "\f10d"; }
.flaticon1-phone-1:before { content: "\f10e"; }
.flaticon1-external-link:before { content: "\f10f"; }
.flaticon1-call-5:before { content: "\f110"; }
.flaticon1-support-1:before { content: "\f111"; }
.flaticon1-support-2:before { content: "\f112"; }
.flaticon1-call-6:before { content: "\f113"; }
.flaticon1-call-7:before { content: "\f114"; }
.flaticon1-call-8:before { content: "\f115"; }
.flaticon1-telephone-call:before { content: "\f116"; }
.flaticon1-end-call:before { content: "\f117"; }
.flaticon1-call-9:before { content: "\f118"; }
.flaticon1-end:before { content: "\f119"; }
.flaticon1-ringtone:before { content: "\f11a"; }
.flaticon1-telephone:before { content: "\f11b"; }
.flaticon1-close:before { content: "\f11c"; }
.flaticon1-problem:before { content: "\f11d"; }
.flaticon1-insect:before { content: "\f11e"; }
.flaticon1-error:before { content: "\f11f"; }
.flaticon1-error-1:before { content: "\f120"; }
@font-face {
  font-family: "Flaticon1";
  src: url("flat-icon/icon1/Flaticon.eot");
  src: url("flat-icon/icon1/Flaticon.eot?#iefix") format("embedded-opentype"),
       url("flat-icon/icon1/Flaticon.woff2") format("woff2"),
       url("flat-icon/icon1/Flaticon.woff") format("woff"),
       url("flat-icon/icon1/Flaticon.ttf") format("truetype"),
       url("flat-icon/icon1/Flaticon.svg#Flaticon") format("svg");
  font-weight: normal;
  font-style: normal;
}

@media screen and (-webkit-min-device-pixel-ratio:0) {
  @font-face {
    font-family: "Flaticon1";
    src: url("flat-icon/1/Flaticon.svg#Flaticon") format("svg");
  }
}

[class^="flaticon1-"]:before, [class*=" flaticon1-"]:before,
[class^="flaticon1-"]:after, [class*=" flaticon1-"]:after {   
  font-family: Flaticon1;
font-style: normal;
/*font-size: 20px;*/
/*margin-left: 20px;*/
}


body {
    margin: 0;
    padding: 0;
    font-family: 'Roboto';
    font-weight: 400;
    min-width: 320px;
}

h1,
h2,
h3,
h4,
h5,
h6,
li,
ul,
p {
    margin: 0;
    padding: 0;
    list-style: none;
    font-weight: normal;
}

h1 {
    font-size: 18px;
}
h2 {
    font-size: 17px;
}

h3 {
    font-size: 16px;
}

h4 {
    font-size: 15px;
}
h5 {
    font-size: 14px;
}
h6 {
    font-size: 13px;
}

p {
    font-size: 14px;
}

a:focus,
a:hover {
    color: inherit;
   
    text-decoration: none;
}
a:focus, a:active, button, input[type="submit"] {
     outline: none !important;
}
a {
    color: inherit;
}
#wrapper {
    position: relative;
    overflow: hidden;
}
img {
    outline: none;
    border: none;
    margin: 0;
    padding: 0;
}

a {
    text-decoration: none;
}

.clear {
    clear: both;
}

.left {
    float: left;
}

.right {
    float: right;
}
.logo{
	
	display: block;

	
}

#chat_request_span table{

	background-color: rgba(255,255,255,1);
padding: 15px 20px;
	height: 100vh;
	float: right;
}
#chat_request_span tr td{
	display: block;
	width: 100%;
	font-size: 15px;
	font-weight: 300;
	color: #000;
	text-align: left;
	padding-left: 20px;
	padding-right: 20px;
}
.queue_text_red{
	background-color: #fff;
	padding: 5px;
	width: 100%;
	display: block;
}
#chat_request_span tr th{
	display: block;
	width: 100%;

	padding-left: 20px;
	padding-right: 20px;
}

#chat_request_span tr td input{
	background-color: #fff;
border-radius: 0px !important;
padding: 10px;
height: 44px;
color: rgba(0,0,0, 1) !important;
border: 1px solid rgba(0,0,0,0.4);
    height: 44px;
font-size: 13px;
margin-bottom: 15px;
font-style: normal;
}
#chat_request_span{
	width: 100%;
	display: block;
	height: 100vh;
	background-image: url(img/bg6.jpg);
	background-size: cover;
	background-repeat: no-repeat;
/*	padding-top: 7%;*/
}
.body_small_bold{
	    color: #000;
    border: none;
    font-size: 14px;
    font-weight: 500;
    border-radius: 0 !important;
    padding: 0px 20px 15px 20px;
	text-align: center;
	text-transform: uppercase;
}
.blue_btn_chat{
	width: 100%;
    color: #fff !important;
    border: none;
    cursor: pointer;
    /* margin-top: 15px; */
    width: 100%;
    height: 51px !important;
    background-color:  <?= $brandColor; ?> !important;    font-size: 15px !important;
    font-weight: normal !important;
	margin-bottom: 15px;
    text-transform: uppercase;
    border: none !important;

}
.blue_btn_chat:hover {
    background-color:  <?= $brandColorHover; ?> !important;
}
.chat_window{
	background-color: #fff;
	border: none !important;
}
.chat-text-area{
overflow: hidden;
	background-color: #fff;
	padding: 10px 5px;
}
#chat_message{
		background-color: #f1f1f4;
    width: 100%;
    border: none;
   
    font-size: 12px;
/*    border-radius: 5px;*/
    resize: none;
/*    margin-top: 5px;*/
	display: block;height: 40px;
	border: none;
	padding: 0 20px;	background-color: #f1f1f4;
	border-radius: 50px;
	padding-top: 10px;
}

.chat-section-send-message{

/*	position: relative;*/
}
.chat_message_send{
/*
	position: absolute;
	top: 10px;
	right: 10px;
*/
	background: url(img/send-msg.png)center 5px no-repeat;
	height: 20px;
	width: 20px;
	margin-right: 17px;
margin-top: -35px;
	float: right;
	
}
.send-btns-msg{
border: none !important;
	background-color: transparent !important;
}


/* on off button */


/* onoff */

.microph-wrp{
	padding-top: 13px;
	overflow: hidden;
	clear: both;
	
	padding-right: 5px;
	float: left;
	width: 170px;
	
/*	margin-bottom: 5px;*/
}
.microph-wrp h3{
	float: left;
	font-size: 15px;
	font-weight: 300;
	color: #000;
	
	
}
.microph-wrp .switch {
  position: relative;
  display: inline-block;
  width: 38px;
  height: 12px;
	float: right;
	margin-top: 6px;
}

/* Hide default HTML checkbox */
.microph-wrp .switch input {
  opacity: 0;
  width: 0;
  height: 0;
}

/* The slider */
.microph-wrp .slider {
  position: absolute;
  cursor: pointer;
  top: 0;
  left: 0;
  right: 0;
  bottom: 0;
  background-color: #374b5e;
  -webkit-transition: .4s;
  transition: .4s;
}

.microph-wrp .slider:before {
  position: absolute;
  content: "";
  height: 17px;
  width: 17px;
  left: 0;
  bottom: -2px;
  background-color: white;
  -webkit-transition: .4s;
  transition: .4s;
	border: 1px solid #374b5e;
}

.microph-wrp input:checked + .slider {
  background-color: <?= $brandColor; ?>;
}

.microph-wrp input:focus + .slider {
  box-shadow: 0 0 1px <?= $brandColor; ?>;
}

.microph-wrp input:checked + .slider:before {
  -webkit-transform: translateX(26px);
  -ms-transform: translateX(26px);
  transform: translateX(26px);
}

/* Rounded sliders */
.microph-wrp .slider.round {
  border-radius: 2px;
}

.microph-wrp .slider.round:before {
  border-radius: 0;
}



.microph-wrp input:checked + .slider:before {
	left: 0;
	right: 4px;
}
.top-header{
	background-color: #fff;padding: 6px 20px 0 20px;
    display: block;    height: 45px;
	box-shadow: 15px 10px 25px rgb(0 0 0 / 10%);
	
}
.chat_status_wrp h2{
	font-size: 15px;
text-transform: uppercase;
float: left;
color: #000;font-weight: 400;
padding-top: 8px;
margin-right: 10px;
}
#ChatActiveStatus{
	font-size: 11px;
background-color: #f1f1f4;
padding: 1px 9px;
    padding-bottom: 1px;
border-radius: 90px;
display: block;
float: left;
margin-top: 7px;
font-weight: 400;
padding-bottom: 2px;
}
.chat_status_wrp{
	float: left;
	width: 80%;
}
.logo-right{
	width: 120px;margin-top: 2px;
	float: right;
}
.logo-right img{
	width: 100%;
}
.button-status
{
	float: right;
	text-align: right;
	width: 40%;
	margin-top: 10px;
}
.button-status span{
	display: inline-block;
	text-align: right;
}
.leavebtn{
	padding: 5px 18px;
	border: none !important;
	background-color: #F33 !important;
	font-size: 13px !important;
	overflow: hidden;display: inline-block;border-radius: 50px;
	color: #fff;
	cursor: pointer;
	
}
.clear-btn{
	padding: 5px 18px;
	border: none !important;
	background-color: #62b1ee !important;
	font-size: 13px !important;
	overflow: hidden;display: inline-block;width: 110px !important;
	border-radius: 50px;width: 110px !important;
	color: #fff;
	cursor: pointer;
}
.clear-btn:hover{
	background-color: #2a3948;
}
.leavebtn:hover{
	
	background-color: #2a3948;
}
#first_name{
	width: 47%;
}
#last_name{
	width: 47%;
	margin-left: 17px;
}
#phone_number{
	width: 100%;
}
#chat_request_span .body_small{
	margin-bottom: 8px !important;
	
}
.logo_main img{
	width: 100%;
}
.logo_main{
	width: 50%;
	margin: 15px auto;
	
}

#group_id{
	width: 100%;
	height: 40px;
	margin-bottom: 10px !important;
	
border: 1px solid rgba(0,0,0,0.4);
}
#ChatDisplay{
	height: calc(100vh - 160px) !important;
	overflow-x: hidden;
}


/* model */

/* only for model */



.model-container{
	display: table;
    position: absolute;
    top: 0;
    left: 0;
    height: 100%;
    width: 100%;
/*	background-color: rgba(0,0,0, 0.8);*/
	background-color: rgba(34,46,58, 0.9) !important;
	z-index: 9999999999;
	
}
.model-container .model-wrp{
  
    display: table-cell;
    vertical-align: middle;
	
}

.model-container .model-wrp .model-wrp-centre{

	  margin-left: auto;
    margin-right: auto;
    width: 500px;
	height: 190px;
	background-color: #fff;
/*	animation: fadeIn 1s ease-in both;*/
	overflow: hidden;
	padding: 15px;
}

.model-contents{
	padding: 15px;
	overflow: hidden;
	background-color: #fff;

}
.model-footerss{
	padding: 10px;
	border-top: 1px solid #efefef;
	
	clear: both;
	display: block;
		float: right;
	background-color: #fff;
	width: 100%;
	text-align: right;
}
.model-footerss button {
    height: 38px;
    border: none !important;
    border-radius: 0 !important;
    text-transform: uppercase;
    font-size: 14px;
    font-weight: 400;
    color: #fff;
    margin-left: 10px;
    width: 112px;
}
.model-footerss .btn-clr {
    background-color: <?= $brandColor; ?>;
}
.model-footerss .btn-clr:hover {
    background-color: #1ba88b;
	color: #fff;
}

.modal-small .model-wrp .model-wrp-centre{
	    width: 400px;
	animation: fadeIn 1s ease-in both;
}
.modal-medium .model-wrp .model-wrp-centre{
	    width: 800px;
	animation: fadeIn 1s ease-in both;
}
.modal-large .model-wrp .model-wrp-centre{
	    width: 90%;
	animation: fadeIn 1s ease-in both;
}
/*

@keyframes fadeIn {
	from {
		opacity: 0;
		transform: translate3d(0, -100%, 0);
	}
	to {
		opacity: 1;
		transform: translate3d(0, 0, 0);
	}
}
*/
.modal-headers1
{
	display: -ms-flexbox;
    display: flex;
    align-items: flex-start;
    justify-content: space-between;
	padding: 0;
   padding-left: 10px;
	background-color: #003b77 !important;
	background: #003b77 !important;
	height: 39px;
	display: block;
	clear: both;
	width: 100%;
}
.modal-headers1 h2{
	font-size: 14px;
    text-transform: uppercase;
    font-weight: 500;
	float: left;
	color: #fff;
	padding: 0;
	margin: 0;
		
  font-family: 'robotolight';
	padding-top: 10px;
}
/* end model */

.model-buttons a:hover{
	
    border: 1px solid #<?= $brandColor; ?>;
    background-color: #<?= $brandColor; ?>;
}
.model-buttons a{
		border-radius: 0;
    /* float: left; */
    background-color: #303030;
    border: 1px solid #303030;
    padding: 5px 10px;
    font-weight: 300;
    font-size: 15px;
    font-weight: normal;
    box-sizing: border-box;
    color: #fff;
    margin: 0 auto;
    text-decoration: none;
    display: block;
    overflow: hidden;
    width: 196px;
	
}
.model-buttons{
display: block;
	overflow: hidden;
	text-align: center;float: right;
}
.model-wrp-height .chat-txt{
/*	margin-top: 55px;*/
/*	background: url(img/close-chat.png) center top no-repeat;*/
	
/*	padding-top: 99px;*/
	margin-bottom: 30px;
	color: #27292a;
	font-size: 15px;
	text-align: left;
}
.model-wrp-height{
	height: 160px;
	width: 100%;
	border: 1px solid #ebebeb;
	padding: 20px;
	position: relative;
	padding-left: 160px;
	box-sizing: border-box;
	padding-top: 33px;
}
.model-wrp-height::before{
width: 116px;
height: 116px;
background-color: #1ba88b;
background: url(img/close-chat.png) center 26px no-repeat #ff6258;
position: absolute;
left: 20px;
top: 20px;
content: "";
}

.cutomer-chatnotification .chat_title {
/*
       background-color: #f1fbf9;
    border: 1px solid #eee;
*/
	background-color: #fbf1f1;
    border: 1px solid #f6d0d0;
    font-size: 14px;
    padding: 10px 15px;
    display: block;
    box-sizing: border-box;
    margin: 15px 15px 15px 10px;
    /* color: #7e7e7e; */
    border-radius: 30px;
    font-weight: 400;border-left: 5px solid #f6d0d0;
}
.cutomer-chatnotification .chat_title font {
    font-weight: 600;
    font-size: 15px;
}
.chat-send-wrp{
	position: relative;
}
#ChatDisplay {
    position: relative;
    display: block;
    width: 100%;
    /* height: 500px; */
    /* overflow-y: auto; */
    overflow-x: hidden;
    z-index: 0;
    max-height: calc(100vh - 160px);
    overflow-y: auto;
}


/* chat section */

/* chat */


.customer-chat-responce{
	
	display: block;
	width: 100%;
	background-color: #fff !important;
}

.my-chat-responce{
	
	display: block;
	width: 100%;
	background-color: #fff !important;
}
.customer-chat-responce li {
	min-width: 70%;
	max-width: 70%;
	float: left;
	list-style: none;
	position: relative;
	padding-left: 28px;
	overflow: hidden;
    display: block;
	padding-top: 6px;
}

.my-chat-responce li {
	width: 70%;
	float: right;
	
	position: relative;
	list-style: none;
	text-align: right;
	padding-right: 28px;
	overflow: hidden;
    display: block;
	padding-top: 6px;
	
}

.my-chat-responce li::before {
    content: "";
    width: 12px;
    height: 12px;
    border-radius: 100px;
    right: 7px;
    top: 9px;
    position: absolute;
/*    background: url(../images/user-avatars11.png) no-repeat;*/
    background-size: cover;
    border: 1px solid #94c2ed;
	background-color: #94c2ed;
}
.customer-chat-responce li::before {
    content: "";
    width: 12px;
    height: 12px;
    border-radius: 100px;
    left: 7px;
    top: 9px;
    position: absolute;
/*    background: url(../images/user-avatars.png) no-repeat;*/
    background-size: cover;
    border: 1px solid #86bb71;
	background-color: #86bb71;
	font-weight: 400;
}

.customer-chat-responce li .popup-chat-box{
	clear: both;
    background-color: #86bb71 !important;
    border-radius: 5px 5px 5px 5px;
    padding:7px 10px;
    margin-bottom: 10px;
    color: #fff !important;
    font-size: 15px !important;
    font-weight: normal;
	float: left;
	position: relative;
	margin-left: 0;
	margin-top: 20px;
	    word-break: break-word;
	font-weight: 400;
	
	font-size: 14px !important;
}
.customer-chat-responce li .popup-chat-box::before {
    bottom: 100%;
    left: 26px;
    border: solid transparent;
    content: " ";
    height: 0;
    width: 0;
    position: absolute;
    pointer-events: none;
    border-bottom-color: #86bb71;
    border-width: 10px;
    margin-left: -20px;
}
.customer-chat-responce li .chat_names{
	float: left;
	color: #000;
	font-size: 12px;
/*	opacity: 0.7;*/
	    text-transform: capitalize;
  
	font-weight: 400;
}
.customer-chat-responce li .chat-time-date{
	float: left;
	color: #000;
	font-size: 12px;
	opacity: 0.7;
	    text-transform: capitalize;
  
	font-weight: 400;
	margin-left: 10px;
}



.my-chat-responce li .popup-chat-box{
	
	font-size: 14px !important;
	clear: both;
/*    background-color: #eff1f0 !important;*/
    border-radius: 5px 5px 5px 5px;
    padding:7px 10px;
    margin-bottom: 10px;
    color: #fff !important;
    font-size: 15px !important;
    font-weight: normal;
	float: right;
	position: relative;
	margin-right: 0;
	margin-top: 10px;
	background-color: #94c2ed;
	word-break: break-word;
	font-weight: 400;

}
.my-chat-responce li .popup-chat-box::before {
       bottom: 100%;
    left: 26px;
    border: solid transparent;
    content: " ";
    height: 0;
    width: 0;
    position: absolute;
    pointer-events: none;
    border-bottom-color: #94c2ed;
    border-width: 10px;
    margin-left: -20px;
}
.my-chat-responce li .chat_names{
	float: right;
	color: #000;
	font-size: 12px;
/*	opacity: 0.7;*/
	    text-transform: capitalize;
	font-weight: 400;
}
.my-chat-responce li .chat-time-date{
	float: right;
	color: #000;
	font-size: 12px;
	opacity: 0.7;
	    text-transform: capitalize;
	font-weight: 400;
	margin-right: 10px;
}