<?php $this->load->view('layouts/header'); ?>
<div class="row wrapper border-bottom white-bg page-heading">
    <div class="col-lg-6">
        <h2><?= $this->Model_lib->_QXZ("Settings Compare Utility"); ?></h2>
        <ol class="breadcrumb">
            <li class="breadcrumb-item">
                <a href="<?= base_url('dashboard'); ?>"><?= $this->Model_lib->_QXZ("Home"); ?></a>
            </li>
            <li class="breadcrumb-item">
                <a href="<?= base_url('utilities'); ?>"><?= $this->Model_lib->_QXZ("Utilities"); ?></a>
            </li>
            <li class="breadcrumb-item active">
                <strong id="_page_header"><?= $this->Model_lib->_QXZ("Settings Compare"); ?></strong>
            </li>
        </ol>
    </div>    
</div>

<!-- BEGIN CONTAINER -->
<div class="page-container">
    <!-- BEGIN CONTENT -->
    <div class="page-content-wrapper">
        <!-- BEGIN CONTENT BODY -->
        <div class="page-content">
            <!-- BEGIN PAGE BASE CONTENT -->
            <div class="row">
                <div class="col-md-12">
                    <!-- BEGIN PROFILE CONTENT -->
                    <div class="profile-content">
                        <div class="row">
                            <div class="col-md-12">
                                <div class="portlet light bordered">                                    
                                    <div class="portlet-body">
                                        <div class="tab-content">
                                            <!-- PERSONAL INFO TAB -->
                                            <div class="tab-pane active" id="tab_1_1">
                                                <form  role="form" method="post" id="compare_form" enctype="multipart/form-data" action="<?=base_url('utilities/settings_compare'); ?>">

                                                	<input type="hidden" id="csrf_hash" name="<?= $data['csrf']['name']; ?>" value="<?= $data['csrf']['hash']; ?>" />

                                                	<div class="row">
                                                        <div class="form-group col-md-4">
                                                            <label class="control-label"><?= $this->Model_lib->_QXZ("Settings Type"); ?><span class="required">*</span></label>
                                                            
<?php
   echo "<select class=\"form-control\" name=\"stage\" onchange=\"loadIds(this);\">";
   echo "<option SELECTED value=''>".$this->Model_lib->_QXZ("--NONE--")."</option>";
   echo "<option value='CAMPAIGNS'>".$this->Model_lib->_QXZ("CAMPAIGNS")."</option>";
   echo "<option value='LISTS'>".$this->Model_lib->_QXZ("LISTS")."</option>";
   echo "<option value='IN-GROUPS'>".$this->Model_lib->_QXZ("IN-GROUPS")."</option>";
   echo "<option value='DIDS'>".$this->Model_lib->_QXZ("DIDS")."</option>";
   echo "<option value='CALLMENUS'>".$this->Model_lib->_QXZ("CALLMENUS")."</option>";
   echo "<option value='USERS'>".$this->Model_lib->_QXZ("USERS")."</option>";
   echo "<option value='USER-GROUPS'>".$this->Model_lib->_QXZ("USER-GROUPS")."</option>";
   echo "<option value='PHONES'>".$this->Model_lib->_QXZ("PHONES")."</option>";
   echo "<option value='SERVERS'>".$this->Model_lib->_QXZ("SERVERS")."</option>";
   echo "<option value='SHIFTS'>".$this->Model_lib->_QXZ("SHIFTS")."</option>";
   echo "</select>";
?>

                                                        </div>

                                                        <div class="form-group col-md-4">
                                                        	<label class="control-label"><?= $this->Model_lib->_QXZ("Source"); ?><span class="required">*</span></label>
                                                        	<select class="form-control" size=1 name=first_id id="first_id_menu">
                                                        	</select>	
                                                        </div>

                                                        <div class="form-group col-md-4">
                                                        	<label class="control-label"><?= $this->Model_lib->_QXZ("Target"); ?><span class="required">*</span></label>
                                                        	<select class="form-control" size=1 name=second_id id="second_id_menu">
                                                        	</select>
                                                        </div>
                                                        	
                                                    </div>

                                                    <div class="margiv-top-10">
                                                        <button type="submit" class="btn green"> <?= $this->Model_lib->_QXZ("Continue"); ?> </button>
                                                        <a href="<?= base_url('utilities/settings_compare'); ?>" class="btn default"> <?= $this->Model_lib->_QXZ("Cancel"); ?> </a>
                                                    </div> 
                                                    
                                                </form>
                                            </div>
                                            <!-- END PERSONAL INFO TAB -->
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- END PROFILE CONTENT -->
                </div>


            </div>
            <!-- END PAGE BASE CONTENT -->



        </div>
    </div>


    <div class="page-content-wrapper">
    		<div class="page-content">
    				<div class="row">
    					<div class="col-md-12">
    						<div class="portlet light bordered">
    							<div class="portlet-body">
    									<div class="tab-pane active">
    										<p id="differ"></p>
    									</div>	
    							</div>	
    						</div>	
    					</div>	
    				</div>	
    		</div>	
    </div>	

</div>


<?php $this->load->view('layouts/footer'); ?>

<STYLE type="text/css">

   .green {color: white; background-color: green}
   .red {color: white; background-color: red}
   .blue {color: white; background-color: blue}
   .purple {color: white; background-color: purple}


	.diff table{
	margin          : 1px 1px 1px 1px;
	border-collapse : collapse;
	border-spacing  : 0;
	}

	.diff td{
	vertical-align : top;
	font-family    : monospace;
	font-size      : 9;
	}
	.diff span{
	display:block;
	min-height:1pm;
	margin-top:-1px;
	padding:1px 1px 1px 1px;
	}

	* html .diff span{
	height:1px;
	}

	.diff span:first-child{
	margin-top:1px;
	}

	.diffDeleted span{
	border:1px solid rgb(255,51,0);
	background:rgb(255,173,153);
	}

	.diffInserted span{
	border:1px solid rgb(51,204,51);
	background:rgb(102,255,51);
	}

	#differ table {
    width: 100%;
    margin-bottom: 1rem;
    color: #212529;border: 1px dashed #dee2e6;
	
	    border-collapse: collapse;border-collapse: separate;
    text-indent: initial;
    border-spacing: 2px;
	    border-spacing: initial;
}

#differ table td, #differ th {
    padding: .75rem;
    vertical-align: top;
    border-top: 1px dashed #dee2e6;
}
#differ td, #differ th {
    border: 1px dashed #dee2e6;
}

 </STYLE>

<script type="text/javascript">

	function loadIds(ctrl){
		$("#loaders").show();
		var stage=$(ctrl).val();
		var Formaction = "<?= base_url('utilities/getids'); ?>";
   		$.ajax({
            url: Formaction,
            type: 'GET',
            data: "stage="+stage,
            contentType:false,
            cache:false,
            processData:false,            
            error: function (x, status, error) {
                $("#loaders").hide();
                swal("Error!", "your session has expired. Please login again to continue.", "error");
                $("#loaders").hide();
            },
            success: function (data) {                
                data = JSON.parse(data);
                $("#csrf_hash").val(data.csrf.hash);
                $("#first_id_menu").html(data.first_id_menu);
                $("#second_id_menu").html(data.second_id_menu);
                $("#loaders").hide();
            }
        });
	}

	$("#compare_form").on("submit",function(e){
   		e.preventDefault();   		
   		var Formaction = $(this).attr('action');
   		$("#loaders").show();
   		$.ajax({
            url: Formaction,
            type: 'POST',
            data: new FormData(this),
            contentType:false,
            cache:false,
            processData:false,            
            error: function (x, status, error) {
                $("#loaders").hide();
                swal("Error!", "your session has expired. Please login again to continue.", "error");
                $("#loaders").hide();
            },
            success: function (data) {                
                data = JSON.parse(data);
                $("#csrf_hash").val(data.csrf.hash);
                $("#differ").html(data.differ);
                $("#loaders").hide();
            }
        });
   });  
</script>  