<?php
error_reporting(0);
require("dbconnect_mysqli.php");
require("functions.php");
$report_name = 'Dashboard';
$db_source   = 'M';
##### Hangup Cause Dictionary #####
$hangup_cause_dictionary = array(
	0   => "Unspecified. No other cause codes applicable.",
	1   => "Unallocated (unassigned) number.",
	2   => "No route to specified transit network (national use).",
	3   => "No route to destination.",
	6   => "Channel unacceptable.",
	7   => "Call awarded, being delivered in an established channel.",
	16  => "Normal call clearing.",
	17  => "User busy.",
	18  => "No user responding.",
	19  => "No answer from user (user alerted).",
	20  => "Subscriber absent.",
	21  => "Call rejected.",
	22  => "Number changed.",
	23  => "Redirection to new destination.",
	25  => "Exchange routing error.",
	27  => "Destination out of order.",
	28  => "Invalid number format (address incomplete).",
	29  => "Facilities rejected.",
	30  => "Response to STATUS INQUIRY.",
	31  => "Normal, unspecified.",
	34  => "No circuit/channel available.",
	38  => "Network out of order.",
	41  => "Temporary failure.",
	42  => "Switching equipment congestion.",
	43  => "Access information discarded.",
	44  => "Requested circuit/channel not available.",
	50  => "Requested facility not subscribed.",
	52  => "Outgoing calls barred.",
	54  => "Incoming calls barred.",
	57  => "Bearer capability not authorized.",
	58  => "Bearer capability not presently available.",
	63  => "Service or option not available, unspecified.",
	65  => "Bearer capability not implemented.",
	66  => "Channel type not implemented.",
	69  => "Requested facility not implemented.",
	79  => "Service or option not implemented, unspecified.",
	81  => "Invalid call reference value.",
	88  => "Incompatible destination.",
	95  => "Invalid message, unspecified.",
	96  => "Mandatory information element is missing.",
	97  => "Message type non-existent or not implemented.",
	98  => "Message not compatible with call state or message type non-existent or not implemented.",
	99  => "Information element / parameter non-existent or not implemented.",
	100 => "Invalid information element contents.",
	101 => "Message not compatible with call state.",
	102 => "Recovery on timer expiry.",
	103 => "Parameter non-existent or not implemented - passed on (national use).",
	111 => "Protocol error, unspecified.",
	127 => "Interworking, unspecified."
);

##### SIP Hangup Cause Dictionary #####
$sip_hangup_cause_dictionary = array(
301 => "Moved Permanently.",
400 => "Not Found.",
401 => "Unauthorized.",
402 => "Payment Required.",
403 => "Forbidden.",
404 => "Not Found.",
405 => "Method Not Allowed.",
406 => "Not Acceptable.",
407 => "Proxy Authentication Required.",
408 => "Request Timeout.",
409 => "Conflict.",
410 => "Gone.",
411 => "Length Required.",
412 => "Conditional Request Failed.",
413 => "Request Entity Too Large.",
414 => "Request-URI Too Long.",
415 => "Unsupported Media Type.",
416 => "Unsupported URI Scheme.",
417 => "Unknown Resource-Priority.",
420 => "Bad Extension.",
421 => "Extension Required.",
422 => "Session Interval Too Small.",
423 => "Interval Too Brief.",
424 => "Bad Location Information.",
428 => "Use Identity Header.",
429 => "Provide Referrer Identity.",
433 => "Anonymity Disallowed.",
436 => "Bad Identity-Info.",
437 => "Unsupported Certificate.",
438 => "Invalid Identity Header.",
470 => "Consent Needed.",
480 => "Temporarily Unavailable.",
481 => "Call/Transaction Does Not Exist.",
482 => "Loop Detected..",
483 => "Too Many Hops.",
484 => "Address Incomplete.",
485 => "Ambiguous.",
486 => "Busy.",
487 => "Request Terminated.",
488 => "Not Acceptable Here.",
489 => "Bad Event.",
491 => "Request Pending.",
493 => "Undecipherable.",
494 => "Security Agreement Required.",
500 => "Internal Server Error.",
501 => "Not Implemented.",
502 => "Bad Gateway.",
503 => "Service Unavailable.",
504 => "Gateway Timeout.",
505 => "Version Not Supported.",
510 => "Not Implemented.",
513 => "Message Too Large.",
580 => "Precondition Failure.",
600 => "Busy Everywhere.",
603 => "Forbidden.",
604 => "Does Not Exist Anywhere.",
606 => "Not Acceptable."
);

#############################################
##### START SYSTEM_SETTINGS LOOKUP #####
$stmt        = "SELECT use_non_latin,outbound_autodial_active,slave_db_server,reports_use_slave_db,enable_languages,language_method,report_default_format FROM system_settings;";
$rslt        = mysql_to_mysqli($stmt, $link);

$qm_conf_ct = mysqli_num_rows($rslt);
if ($qm_conf_ct > 0) {
    $row                      = mysqli_fetch_row($rslt);
    $non_latin                = $row[0];
    $outbound_autodial_active = $row[1];
    $slave_db_server          = $row[2];
    $reports_use_slave_db     = $row[3];
    $SSenable_languages       = $row[4];
    $SSlanguage_method        = $row[5];
    $SSreport_default_format  = $row[6];
}
##### END SETTINGS LOOKUP #####
###########################################

if ((strlen($slave_db_server) > 5) and (preg_match("/$report_name/", $reports_use_slave_db))) {
    mysqli_close($link);
    $use_slave_server = 1;
    $db_source        = 'S';
    require("dbconnect_mysqli.php");
    $HTML_text .= "<!-- Using slave server $slave_db_server $db_source -->\n";
}

$PHP_AUTH_USER = $userdata['user'];
$PHP_AUTH_PW   = $userdata['pass'];
$ADMIN         = "admin";
$user_level_SQL=0;
$stmt          = "SELECT user_group,user_level from vicidial_users where user='$PHP_AUTH_USER'";
$rslt          = mysql_to_mysqli($stmt, $link);
$row           = mysqli_fetch_row($rslt);
if (sizeof($row)) {
    $group_SQL = $row[0];
    $user_level_SQL = $row[1];
}
if (trim($_POST['event_type']) == "queue_reset") {
    $selected_id = $_POST['selected_id'];
    queue_reset($selected_id);
    exit();
} else if (trim($_POST['event_type']) == "logout") {
    $selected_id = $_POST['selected_id'];
    campaign_logout($selected_id);
    exit();
} else if (trim($_POST['event_type']) == "change_auto_dial_level") {
    $type        = $_POST['type'];
    $level       = $_POST['level'];
    $campaign_id = $_POST['campaign_id'];
    $result      = getAutoDialLevel($type, $level, $campaign_id);
    print_r($result);
    exit();
} else if(trim($_POST['event_type'])=="campaignStats"){
    define("USER_GROUP", $group_SQL);
    $CampaignSql = get_allowed_campaigns($link,$group_SQL);
    define('ALLOWED_CAMPAIGNS',$CampaignSql);
    $GroupsSql=get_allowed_user_groups($link, $group_SQL);
    define('ALLOWED_USERGROUPS',$GroupsSql);
    $CloserSQL=get_inbound_groups($link, $group_SQL);
    define('ALLOWED_CLOSER',$CloserSQL);
    $campaignStats=campaignStats();
    exit(json_encode($campaignStats));
} else if(trim($_POST['event_type'])=="change_campaign_status"){
    change_campaign_status($_POST['campaign_id'],$_POST['active']);
    exit();
} else if(trim($_POST['event_type'])=="global_search"){
    global_search();
	exit();
} else if(trim($_POST['event_type'])=="outbound_call_activity"){
    $CampaignSql = get_allowed_campaigns($link,$group_SQL);
    get_cli_asr($CampaignSql);
    exit();
} else if(trim($_POST['event_type'])=="get_carrier_stats"){
	$CampaignSql = get_allowed_campaigns($link,$group_SQL);
    get_carrier_stats($CampaignSql);
    exit();
} else if(trim($_POST['event_type'])=="get_carriers_stats"){
    $CampaignSql = get_allowed_campaigns($link,$group_SQL);   
    get_carriers_stats($CampaignSql,$link);
    exit();
} else if(trim($_POST['event_type'])=="add_limits"){
    $CampaignSql = get_allowed_campaigns($link,$group_SQL);   
    get_carriers_stats($CampaignSql,$link);
    exit();
} else if(trim($_POST['event_type'])=="get_users_limit"){
	 $users="0";
	 $action="2";
 	execute_cx_api($group_SQL,$users,$action,$PHP_AUTH_USER);
 	exit();
} else if(trim($_POST['event_type'])=="submit_seats"){
	 $seats=$_POST['seats'];
     $users=$_POST['num'];
	 $action=$_POST['action'];

     if(strval($action)=="0"){
        $users=abs($users);
     }

	if(strval($seats)<=0){
		$array=array("status"=>false,"message"=>"User limit can't be zero or less than zero - server");
		exit(json_encode($array));
	}
    if(strval($user_level_SQL)<8)
    {
        $array=array("status"=>false,"message"=>"You don't have permission");
        exit(json_encode($array));
    }
 	execute_cx_api($group_SQL,$users,$action,$PHP_AUTH_USER);
 	exit();
} else if(trim($_POST['event_type'])=="google_2fa"){
    $user=$_POST['user'];
    if($PHP_AUTH_USER!=$user)
    {
        exit();
    }
    $google_2fa_response = google_2fa($link,$user); 
    exit(); 
} else if(trim($_POST['event_type'])=="submit_qrcode"){
    $user=$_POST['qrcode_user'];
    if($PHP_AUTH_USER!=$user)
    {
        exit();
    }
    $code=$_POST['qrcode_number'];
    $secret=$_POST['qrcode_secret'];
    $google_2fa_response = submit_qrcode($link,$user,$secret,$code); 
    exit(); 
} else if(trim($_POST['event_type'])=="disabled_google_2fa"){
    $user=$_POST['user'];
    if($PHP_AUTH_USER!=$user)
    {
        exit();
    }
    $google_2fa_response = disabled_google_2fa($link,$user); 
    exit(); 
} else if(trim($_POST['event_type'])=="frm_destination"){
    //echo "<pre>";
    frm_destination($_POST,$PHP_AUTH_USER);
    exit(); 
}

$GLOBALS['link']=$link;

define("USER_GROUP", $group_SQL);
$CampaignSql = get_allowed_campaigns($link,$group_SQL);
define('ALLOWED_CAMPAIGNS',$CampaignSql);
$GroupsSql=get_allowed_user_groups($link, $group_SQL);
define('ALLOWED_USERGROUPS',$GroupsSql);
$CloserSQL=get_inbound_groups($link, $group_SQL);
define('ALLOWED_CLOSER',$CloserSQL);
getlive_stats();


function get_all_user_groups($link) {
    $all_user_groups = "'---ALL---',";
    
    $stmt     = "SELECT user_group FROM vicidial_user_groups ORDER BY user_group;";
    $rslt     = mysql_to_mysqli($stmt, $link);
    $num_rows = mysqli_num_rows($rslt);
    if ($num_rows > 0) {
        while ($row = mysqli_fetch_assoc($rslt)) {
            $all_user_groups .= "'".$row['user_group']."',";
        }
    }
    $all_user_groups = rtrim($all_user_groups, ',');
    
    return $all_user_groups;
}


function get_all_campaigns($link, $active = '', $qc_enabled = '', $mode = '') {
    $all_campaigns = '';
    
    $qc_enabled_sql = '';
    $where_qc_enabled_sql = '';
    if($qc_enabled == 'Y') {
        $qc_enabled_sql       = " AND qc_enabled='Y' AND active='Y'";
        $where_qc_enabled_sql = " WHERE qc_enabled='Y' AND active='Y'";
    }
    $qc_enabled_sql = $where_qc_enabled_sql;

    $active_sql = '';
    if($qc_enabled == '' && $active != '' ) {
        $active_sql = "WHERE active='".$active."'";
    }

    $stmt     = "SELECT campaign_id,campaign_name,active FROM vicidial_campaigns $qc_enabled_sql $active_sql ORDER BY campaign_id;";
    $rslt     = mysql_to_mysqli($stmt, $link);
    $num_rows = mysqli_num_rows($rslt);
    $admin_viewable_campaigns_arr = array();
    if ($num_rows > 0) {
        while ($row = mysqli_fetch_assoc($rslt)) {
            $all_campaigns .= "'".$row['campaign_id']."',";
            $admin_viewable_campaigns_arr['campaign_id'][]   = $row['campaign_id'];
            $admin_viewable_campaigns_arr['campaign_name'][] = $row['campaign_name'];
            $admin_viewable_campaigns_arr['active'][]        = $row['active'];
        }
        $all_campaigns = rtrim($all_campaigns, ',');
    }

    if($mode == 'array') {
        return $admin_viewable_campaigns_arr;
    }
    
    return $all_campaigns;
}


function get_inbound_groups($link, $user_group) {
    $admin_viewable_groups_csv = get_allowed_user_groups($link, $user_group);

    $stmt = "SELECT group_id,group_name FROM vicidial_inbound_groups WHERE user_group IN($admin_viewable_groups_csv) ORDER BY group_id;";
    $rslt = mysql_to_mysqli($stmt, $link);
    
    $num_rows  = mysqli_num_rows($rslt);
    $vi_groups = '';
    if ($num_rows > 0) {
        while ($row = mysqli_fetch_assoc($rslt)) {
            $vi_groups .= "'".$row['group_id']."',";
        }
        $vi_groups = rtrim($vi_groups, ",");
    }
    
    return $vi_groups;
}


function get_allowed_user_groups($link, $user_group, $where_clause = '') {
    $stmt = "SELECT admin_viewable_groups FROM vicidial_user_groups WHERE user_group='$user_group';";
    $rslt = mysql_to_mysqli($stmt, $link);
    $row  = mysqli_fetch_row($rslt);
    $admin_viewable_groups = $row[0];
    
    // Allowed admin viewable groups
    $raw_admin_viewable_groups = '';
    $admin_viewable_groups_csv = '';
    if ((!preg_match('/\-\-ALL\-\-/i', $admin_viewable_groups)) and (strlen($admin_viewable_groups) > 3)) {
        $raw_admin_viewable_groups = preg_replace("/ -/", '', $admin_viewable_groups);
        $admin_viewable_groups_csv = preg_replace("/ /", "','", $raw_admin_viewable_groups);
        $admin_viewable_groups_csv = "'---ALL---','$admin_viewable_groups_csv'";
    } elseif(preg_match('/\-ALL/i', $admin_viewable_groups)) {
        $admin_viewable_groups_csv = get_all_user_groups($link);
    } else {
        // Do Nothing
    }

    if ($where_clause == 'where') {
        $where_admin_viewable_groups = "WHERE user_group IN($admin_viewable_groups_csv)";
        return $where_admin_viewable_groups;
    }
    
    return $admin_viewable_groups_csv;
}


function get_allowed_campaigns($link, $user_group, $active = '', $qc_enabled = '', $where_clause = '', $mode = '') {
    $qc_enabled_sql       = '';
    $where_qc_enabled_sql = '';
    if($qc_enabled == 'Y') {
        $qc_enabled_sql = " AND qc_enabled='Y' AND active='Y'";
        $where_qc_enabled_sql = " WHERE qc_enabled='Y' AND active='Y'";
    }

    $stmt = "SELECT allowed_campaigns,admin_viewable_groups FROM vicidial_user_groups WHERE user_group='$user_group';";
    $rslt = mysql_to_mysqli($stmt, $link);
    $row  = mysqli_fetch_row($rslt);

    $allowed_campaigns     = $row[0];
    $admin_viewable_groups = $row[1];
   
    // Allowed admin viewable groups
    $raw_admin_viewable_groups   = '';
    $admin_viewable_groups_csv   = '';
    $where_admin_viewable_groups = '';
    if ((!preg_match('/\-\-ALL\-\-/i', $admin_viewable_groups)) and (strlen($admin_viewable_groups) > 3)) {
        $raw_admin_viewable_groups = preg_replace("/ -/", '', $admin_viewable_groups);
        $admin_viewable_groups_csv = preg_replace("/ /", "','", $raw_admin_viewable_groups);
        $admin_viewable_groups_csv = "'---ALL---','$admin_viewable_groups_csv'";
        $where_admin_viewable_groups = "WHERE user_group IN($admin_viewable_groups_csv)";
    } else {
        $where_admin_viewable_groups = '';
        $qc_enabled_sql = $where_qc_enabled_sql;
    }

    // $where_admin_viewable_groups = preg_replace("/,''/", '', $where_admin_viewable_groups);
    
    $active_sql = '';
    if($qc_enabled == '' && $active != '' ) {
        $active_sql = "AND active='".$active."'";
    }

    $allowed_campaigns_csv = '';
    $admin_viewable_campaigns_csv = '';
    $admin_viewable_campaigns_arr = array();
    $stmt = "SELECT campaign_id,campaign_name,active FROM vicidial_campaigns $where_admin_viewable_groups $qc_enabled_sql $active_sql ORDER BY campaign_id;";
    $rslt = mysql_to_mysqli($stmt, $link);
    while($row  = mysqli_fetch_row($rslt)) {
        $admin_viewable_campaigns_csv .= $row[0] . ",";
        $admin_viewable_campaigns_arr['campaign_id'][]   = $row[0];
        $admin_viewable_campaigns_arr['campaign_name'][] = $row[1];
        $admin_viewable_campaigns_arr['active'][]        = $row[2];
    }
    $admin_viewable_campaigns_csv = rtrim($admin_viewable_campaigns_csv, ',');

    // Allowed Campaigns
    $final_allowed_campaigns_csv = '';
    $raw_allowed_campaigns = '';
    if ((!preg_match('/\-ALL/i', $allowed_campaigns))) {

        $raw_allowed_campaigns = preg_replace("/ -/", '', $allowed_campaigns);
        $raw_allowed_campaigns = preg_replace("/ /", ",", $raw_allowed_campaigns);
    
    } elseif(preg_match('/\-ALL/i', $allowed_campaigns)) {
        
        if($mode == 'array') {
            return get_all_campaigns($link, $active, $qc_enabled, $mode);
        }

        // Remove single quotes from prepared csv
        // 'UKinjur','UKenergy' => UKinjur,UKenergy
        $raw_allowed_campaigns = str_replace("'", '', get_all_campaigns($link, $active, $qc_enabled));
    } else {
        // Do Nothing
    }
    
    $exploded_admin_viewable_campaigns = explode(',', $admin_viewable_campaigns_csv);
    $exploded_allowed_campaigns = explode(',', $raw_allowed_campaigns);
    
    $final_allowed_campaigns_arr = array();
    foreach($exploded_admin_viewable_campaigns as $camp) {
        if(in_array($camp, $exploded_allowed_campaigns)) {
            $final_allowed_campaigns_arr[] = $camp;
        }
    }
    $final_allowed_campaigns_csv = "'";
    $final_allowed_campaigns_csv .= implode("','", $final_allowed_campaigns_arr) . "'";

    if ($where_clause == 'where') {
        if($qc_enabled == 'Y') {
            $qc_enabled_sql = " AND qc_enabled='Y' AND active='Y'";
        }
        
        $where_allowed_campaigns = "WHERE campaign_id IN($final_allowed_campaigns_csv) $qc_enabled_sql";
        return $where_allowed_campaigns;
    }

    return $final_allowed_campaigns_csv;
}


function getlive_stats()
{
    $NOW_TIME  = date("Y-m-d H:i:s");
    $NOW_DAY   = date("Y-m-d");
    $NOW_HOUR  = date("H:i:s");
    $STARTtime = date("U");
    $CAMPAIGNS = "";
    if (isset($_POST['campaign_id'])) {
        $CAMPAIGNS = trim($_POST['campaign_id']);
    }

    if ($CAMPAIGNS == "") {
        $CAMPAIGNS   = "";
        $campaign_id = "";
    } else {
        $campaign_id = trim($_POST['campaign_id']);
        $CAMPAIGNS   = $campaign_id;
    }
    $cols  = "b.extension,b.user,b.conf_exten,b.status,b.server_ip,UNIX_TIMESTAMP(b.last_call_time) as last_call_time,b.last_call_time as Xlast_call_time,UNIX_TIMESTAMP(b.last_call_finish) as last_call_finish,(select campaign_name from vicidial_campaigns where campaign_id=b.campaign_id) as campaign_name,b.campaign_id,a.full_name,b.comments,b.calls_today,b.callerid,b.lead_id,UNIX_TIMESTAMP(b.last_state_change) as last_state_change,b.on_hook_agent,b.ring_callerid,b.agent_log_id,a.user_group,b.pause_code";

if(trim($CAMPAIGNS)==""){
    $query = "select $cols from vicidial_users a , vicidial_live_agents b where a.user=b.user and b.campaign_id IN(" . ALLOWED_CAMPAIGNS . ") order by b.status";
}else{
    $query = "select $cols from vicidial_users a , vicidial_live_agents b where a.user=b.user and b.campaign_id ='$campaign_id' order by b.status";
}
    



    $agent_loggedin = 0;
    $agnet_incall   = 0;
    $agent_wait     = 0;
    $agent_paused   = 0;
    $agent_dead     = 0;
    $ringing        = 0;
    $agent_dispo    = 0;

    $result = mysqli_query($GLOBALS['link'], $query);
    while (($row[] = mysqli_fetch_assoc($result)) || array_pop($row));
    $data       = null;
    $sort_order = "Z";
    for ($i = 0; $i < sizeof($row); $i++) {
        $pause_code        = $row[$i]['pause_code'];
        $extension         = $row[$i]['extension'];
        $extension         = str_replace("Ext", "", $extension);
        $extension         = str_replace(":", "", $extension);
        $extension         = trim($extension);
        $user              = $row[$i]['user'];
        $conf_exten        = $row[$i]['conf_exten'];
        $status            = $row[$i]['status'];
        $last_call_time    = $row[$i]['last_call_time'];
        $last_call_finish  = $row[$i]['last_call_finish'];
        $campaign_id       = $row[$i]['campaign_id'];
        $full_name         = $row[$i]['full_name'];
        $comments          = $row[$i]['comments'];
        $calls_today       = $row[$i]['calls_today'];
        $callerid          = $row[$i]['callerid'];
        $lead_id           = $row[$i]['lead_id'];
        $last_state_change = $row[$i]['last_state_change'];
        $on_hook_agent     = $row[$i]['on_hook_agent'];
        $ring_callerid     = $row[$i]['ring_callerid'];
        $agent_log_id      = $row[$i]['agent_log_id'];
        $server_ip         = $row[$i]['server_ip'];
        $user_group_id     = $row[$i]['user_group'];
        $conf_exten        = $row[$i]['conf_exten'];
        $campaign_name     = $row[$i]['campaign_name'];
        $Xlast_call_time    = $row[$i]['Xlast_call_time'];
        //Code from "TWO LEGAL CLINET.
        $customer_name     = '';
        if ($lead_id > 0) {

            $query_customer  = "select DISTINCT first_name,last_name,phone_number,email from vicidial_list where lead_id=$lead_id";
            $result_customer = mysqli_query($GLOBALS['link'], $query_customer);
            while (($resultArray_customer[] = mysqli_fetch_assoc($result_customer)) || array_pop($resultArray_customer));

            if (sizeof($resultArray_customer) > 0) {
                $customer_first_name = $resultArray_customer[0]['first_name'];
                $customer_last_name  = $resultArray_customer[0]['last_name'];
                if (trim($customer_first_name) == '') {
                    $customer_name = $customer_last_name;
                } else {
                    if (trim($customer_last_name) != '') {
                        $customer_name = $customer_first_name . ' ' . $customer_last_name;
                    } else {
                        $customer_name = $customer_first_name;
                    }
                }
                $customer_name = "";
                if (trim($customer_name) == '') {
                    $customer_name = $resultArray_customer[0]['phone_number'];
                }
            }
        }

        if ($on_hook_agent == 'Y') {
            if (strlen($ring_callerid[$i]) > 18) {
                $status = "RING";
                $ringing++;
            }
        }

        ### 3-WAY Check ###
        if ($lead_id != 0) {
            $threewaystmt = "select UNIX_TIMESTAMP(last_call_time) from vicidial_live_agents where lead_id='$lead_id' and status='INCALL' order by UNIX_TIMESTAMP(last_call_time) desc";
            $threewayrslt = mysqli_query($GLOBALS['link'], $threewaystmt);
            if (mysqli_num_rows($threewayrslt) > 1) {
                $status          = "3-WAY";
                $srow            = mysqli_fetch_row($threewayrslt);
                $call_mostrecent = $srow[0];
            }
        }

        $Xcallerids    = '';
        $pausecode     = '';
        $stmt          = "select callerid,lead_id,phone_number from vicidial_auto_calls;";
        $rslt          = mysqli_query($GLOBALS['link'], $stmt);
        $calls_to_list = mysqli_num_rows($rslt);
        if ($calls_to_list > 0) {
            $ix = 0;
            while ($ix < $calls_to_list) {
                $Xrow = mysqli_fetch_row($rslt);
                $Xcallerids .= "$Xrow[0]|";
                $ix++;
            }
        }

        /*if ($calls_to_list > 0) {
        $ix = 0;
        while ($ix < $calls_to_list) {
        $Xrow = mysql_fetch_row($rslt);
        $Xcallerids.="$Xrow[0]|";
        $ix++;
        }
        }*/

        if (preg_match("/READY|PAUSED/", $status)) {
            $last_call_time = $last_state_change;
            if ($lead_id > 0) {
                $status = 'DISPO';
            }
        }

        if (preg_match("/INCALL/", $status)) {
            if (!preg_match("$callerid\|", $Xcallerids)) {
                $last_call_time = $last_state_change;
                $status         = 'INCALL';
            }
            if ((preg_match("/AUTO/", $comments)) or (strlen($comments) < 1)) {
                $CM = 'A';
            } else {
                if (preg_match("/INBOUND/", $comments)) {
                    $CM = 'I';
                } else {
                    $CM = 'M';
                }
            }
        } else {
            $CM = '';
        }

        if (!preg_match("/INCALL|QUEUE|PARK|3-WAY/", $status)) {
            $call_time_S = ($STARTtime - $last_state_change);
        } else if (preg_match("/3-WAY/", $status)) {
            $call_time_S = ($STARTtime - $call_mostrecent);
        } else {
            $call_time_S = ($STARTtime - $last_call_time);
        }

        $sort_call_time_S = strval($call_time_S);
        $call_time_MS     = sec_convert_fun($call_time_S, 'H');
        $call_time_MS     = sprintf("%8s", $call_time_MS);
        $call_time_MS     = trim($call_time_MS);

        if ($status == 'INCALL') {
            $status = "TALKING";
            $agnet_incall++;
            $sort_order = "A";
            if ($call_time_MS > 5) {
                $backgroundcolor = "oncall_5m";
            } else if ($call_time_MS > 1) {
                $backgroundcolor = "oncall_1m";
            } else {
                $backgroundcolor = "oncall";
            }
        } else if ($status == 'DEAD') {
            $status     = "DEAD";
            $sort_order = "E";
            //$customer_name='';
            $agent_dead++;
            $backgroundcolor = "dead";
        } else if ($status == 'DISPO') {
            $status     = "DISPO";
            $sort_order = "C";
            $agent_dispo++;
            //$customer_name='';
            if ($call_time_MS > 5) {
                $backgroundcolor = "dispo_5m";
            } else if ($call_time_MS > 1) {
                $backgroundcolor = "dispo_1m";
            } else {
                $backgroundcolor = "dispo";
            }
        } else if ($status == 'READY' || $status == 'CLOSER') {
            $status     = "WAITING";
            $sort_order = "B";
            $agent_wait++;
            //$customer_name='';
            if ($call_time_MS > 5) {
                $backgroundcolor = "wait_5m";
            } else if ($call_time_MS > 1) {
                $backgroundcolor = "wait_1m";
            } else {
                $backgroundcolor = "wait";
            }
        } else if ($status == 'PAUSED') {
            //$customer_name='';
            $sort_order = "C";
            $agent_paused++;
            if ($call_time_MS > 5) {
                $backgroundcolor = "pause_5m";
            } else if ($call_time_MS > 1) {
                $backgroundcolor = "pause_1m";
            } else {
                $backgroundcolor = "pause";
            }
        } else if ($status == '3-WAY') {
            $sort_order      = "D";
            //$customer_name='';
            $backgroundcolor = "way3";
        } else {
            //$customer_name='';
        }
        $today_user_sales = 0;
        $full_name        = str_replace(' ', ' ', $full_name);

        $inbound_sale  = sale_inbound_today($campaign_id,$user);
        $outbound_sale = sale_outbound_today($campaign_id,$user);

        $inbound_calls  = "";
        $outbound_calls = "";

        $agent_loggedin++;

        $data[] = array(
            'sort_order'       => $sort_order,
            'extension'        => $extension,
            'server_ip'        => $server_ip,
            'user'             => $user,
            'full_name'        => $full_name,
            'status'           => $status ."( ". $pause_code. " )",
            'call_time_ms'     => $call_time_MS,
            'campaign_id'      => $campaign_id,
            'calls_today'      => $calls_today,
            'bgcolor'          => "bg-".$backgroundcolor,
            'inbound_sale'     => $inbound_sale,
            'outbound_sale'    => $outbound_sale,
            'customer_name'    => $customer_name,
            'campaign_id'      => $campaign_id,
            'user_group'       => $user_group_id,
            'conf_exten'       => $conf_exten,
            'call_type'        => $CM,
            'campaign_name'    => $campaign_name,
            'sort_call_time_S' => $sort_call_time_S,
            "inbound_calls"    => $inbound_calls,
            "outbound_calls"   => $outbound_calls,
            "Xlast_call_time"  => $Xlast_call_time,
            "avg_wait_time"    => avg_wait_time($campaign_id,$user),
            "avg_talk_time"    => avg_talk_time($campaign_id,$user),
            "avg_pause_time"   => avg_pause_time($campaign_id,$user)
        );

    }
    $campaign_id = "";
    if (isset($_POST['campaign_id'])) {
        $campaign_id = trim($_POST['campaign_id']);
    }
    $data                           = array_msort($data, array(
        'sort_order' => SORT_ASC,
        'sort_call_time_S' => SORT_DESC
    ));
    $sales_details                  = "";
    $calls_details                  = getextra($campaign_id);
    $inbound_outbound_sales_details = "";
    $avg_wait_time                  = avg_wait_time($campaign_id);
    $avg_talk_time                  = avg_talk_time($campaign_id);
    $avg_pause_time                 = avg_pause_time($campaign_id);
    $long_talk_time                 = long_talk_time($campaign_id);
    $long_wait_time                 = long_wait_time($campaign_id);


    $callplaced     = $calls_details['calls_today'];  //getCallPlaced($campaign_id);
    $callconnected  = $calls_details['answers_today']; //getCallConntected($campaign_id);
    $connected_rate = $calls_details['connectrate']; //connected_rate($callplaced, $callconnected);
    $call_types=array();
    $total_outbound_calls=$calls_details['out_calls_today'];
    $total_inbound_calls=$calls_details['in_calls_today'];

    

    if (sizeof($data) > 0) {
        $data = array_values(array_filter($data));
    }

    if ($data == null) {
        $data = array();
    }

    $active_rinings_calls = get_ringing_calls($campaign_id);

    $stats = array(
        "login"   => $agent_loggedin,
        "incall"  => $agnet_incall,
        "dead"    => $agent_dead,
        "paused"  => $agent_paused,
        "wait"    => $agent_wait,
        "ringing" => $active_rinings_calls['ringing_calls'],
        "active"  => $active_rinings_calls['active_calls'],
        "dispo"   => $agent_dispo,
        "live_in" => live_in($campaign_id),
        "live_out" => live_out($campaign_id),
        "waitting_in" => waitting_in($campaign_id),
        "waitting_out" => waitting_out($campaign_id)
    );

    $inbound_sale  = sale_inbound_today($_POST['campaign_id']);
    $inbound_sale_sph = number_format($inbound_sale / 8, 2, '.', '');   

    $outbound_sale = sale_outbound_today($_POST['campaign_id']);
    $outbound_sale_sph = number_format($outbound_sale / 8, 2, '.', ''); 

    $total_sales      = strval($inbound_sale) + strval($outbound_sale);
    $sales_conversion = sales_conversion($callconnected, $inbound_sale, $outbound_sale);
    
    $sales_ration     = strval($total_sales)/strval($callconnected);
    $sales_ration     =round($sales_ration,2);


    $call_types[]=["type"=>"In Calls","total_calls"=>$total_inbound_calls];
    $call_types[]=["type"=>"Out Calls","total_calls"=>$total_outbound_calls];
    $call_types[]=["type"=>"In Sales","total_calls"=>$inbound_sale];
    $call_types[]=["type"=>"Out Sales","total_calls"=>$outbound_sale];

    #$weekly_sales_outbound=get_weekly_sales_outbound($campaign_id);
    #$weekly_sales_inbound=get_weekly_sales_inbound($campaign_id);
    #$top_ten_sales_agents=top_ten_sales_agents($campaign_id);

    $inbound_groups_details=inbound_groups_details($campaign_id);
    $campaigns_details=campaigns_details($campaign_id);

    $calls_status=get_calls_status($campaign_id);

    $callbacks_calls=callbacks_calls($campaign_id);
    $callbacks_ration = strval($callbacks_calls)/strval($callconnected);
    $callbacks_ration     =round($callbacks_ration,2);
    $leads_in_buffer     =leads_in_buffer($campaign_id);
    $get_now_calls       =get_now_calls($campaign_id);
    $data = array(
        "real_time"                      => $data,
        "calls_details"                  => $calls_details,
        "stats"                          => $stats,
        "avg_wait_time"                  => $avg_wait_time,
        "avg_talk_time"                  => $avg_talk_time,
        "avg_pause_time"                 => $avg_pause_time,
        "callplaced"                     => $callplaced,
        "callconnected"                  => $callconnected,
        "connected_rate"                 => $connected_rate,
        "total_sales"                    => $total_sales,
        "sales_conversion"               => $sales_conversion,
        "inbound_sale"                   => $inbound_sale,
        "outbound_sale"                  => $outbound_sale,
        "outbound_sale_sph"              => $outbound_sale_sph,
        "inbound_sale_sph"               => $inbound_sale_sph,
        "sales_ration"                   => $sales_ration,
        "daily_sales_outbound"           => $weekly_sales_outbound,
        "daily_sales_inbound"            => $weekly_sales_inbound,
        "top_ten_sales_agents"           => $top_ten_sales_agents,
        "calls_status"                   => $calls_status,
        "total_outbound_calls"           => $total_outbound_calls,
        "total_inbound_calls"            => $total_inbound_calls,
        "inbound_groups_details"         => $inbound_groups_details,
        "campaigns_details"              => $campaigns_details,
        "callbacks_calls"                => $callbacks_calls,
        "callbacks_ration"               => $callbacks_ration,
        "leads_in_buffer"                => $leads_in_buffer,
        "get_now_calls"                  => $get_now_calls,
        "long_wait_time"                 => $long_wait_time,
        "long_talk_time"                 => $long_talk_time,
        "call_types"                     => $call_types
    );
    $json = json_encode($data);
    echo $json;
    exit();
}

function get_now_calls($campaign_id) 
{   
    if ($campaign_id != "") {
        $campaign = " campaign_id='$campaign_id'";
    } else {
        $campaign = " campaign_id IN(" . ALLOWED_CAMPAIGNS . ")";
    }

    $stmt="select count(call_type) as total,call_type,DATE_FORMAT(time(now()),\"%r\") as timenow from vicidial_auto_calls where $campaign and call_time=now() group by call_type";
    $result = mysqli_query($GLOBALS['link'], $stmt);
    while (($row[] = mysqli_fetch_assoc($result)) || array_pop($row));
    if(sizeof($row)>0){
        $return=['row'=>$row];
    }else{
        $return=['row'=>$row,"timenow"=>date("h:i A", time())];
    }
    //$return=['row'=>$row,"timenow"=>date("h:i A", time())];
    return $return;
}

function leads_in_buffer($campaign_id){
    if ($campaign_id != "") {
        $campaign = "AND campaign_id='$campaign_id'";
    } else {
        $campaign = "AND campaign_id IN(" . ALLOWED_CAMPAIGNS . ")";
    }
    $stmt="SELECT count(*) FROM vicidial_hopper where status IN('READY') $campaign;";
    $rslt=mysqli_query($GLOBALS['link'], $stmt);
    $rowx=mysqli_fetch_row($rslt);
    $hopper_leads = "$rowx[0]";

    return $hopper_leads;
}

function submit_qrcode($link,$user,$secret,$code)
{       
        ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);    
        require_once 'GoogleAuthenticator/vendor/autoload.php';
        $gaobj = new PHPGangsta_GoogleAuthenticator();
        $checkResult = $gaobj->verifyCode($secret, $code, 2);
        if ($checkResult) 
        {
            $stmt = "UPDATE vicidial_users SET google_auth_code='$secret',auth='1' WHERE user='$user'";
            $rslt = mysqli_query($GLOBALS['link'], $stmt);
            $response=array("status"=>true,"message"=>"google authenticator successfully done");
        } else {            
            $response=array("status"=>false,"message"=>"google authenticator failed");
        }
        $json = json_encode($response);
        echo $json;
        exit();
}

function frm_destination($post,$PHP_AUTH_USER)
{
    $did=$post['did'];
    $call_routing=$post['call_routing'];
    $selected_route=$post[$call_routing];
    $email=$post['EMAIL'];

    $message="";
    if(trim($did)==""){
        $message="Please Select DID";
    }else if (trim($call_routing)=="") {
        $message="Please Select Call Rourting";
    }else if (trim($selected_route)=="") {
        $message="Please Select Call Rourting Type";
    }else if (trim($email)=="") {
        $message="Please Enter Email";
    }

    if(trim($message)!=""){
        $array=array("status"=>false,"message"=>$message);
        exit(json_encode($array));
    }

    if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
        $message = "Invalid email format";
         $array=array("status"=>false,"message"=>$message);
        exit(json_encode($array));
    }

    if ($call_routing=="PHONE")
    {
        $call_routing="FORWARD";
    }
    if ($call_routing=="IN_GROUP")
    {
        $call_routing="INBOUND GROUP";
    }

    if(trim($_POST['NOTES']))
    {
        $NOTES=$_POST['NOTES'];
    }else{
        $NOTES="";
    }

    $HTTP_HOST=$_SERVER['HTTP_HOST'];
    $body="<p><b>SERVER/DOMAIN:</b> $HTTP_HOST</p>";
    $body.="<p><b>SELECTED DID:</b> $did</p>";
    $body.="<p><b>DID Route:</b> $call_routing</p>";
    $body.="<p><b>DID Route 2:</b> $selected_route</p>";
    if($NOTES!=""){
        $body.="<p><b>NEW</b> YES</p>";            
    }else{
        $body.="<p><b>NEW</b> NO</p>";    
    }    
    $body.="<p><b>Email:</b> $email</p>";
    $body.="<p><b>User:</b> $PHP_AUTH_USER</p>";
    if($NOTES!=""){
        $body.="<p><b>Additional Notes:</b> $NOTES</p>";        
    }
   
    $from="api@XXXXXXXXXX.com";
    $to="support@XXXXXXXXXX.com";
    $Subject="Inbound Destination";
    $sarray = array(
             'from' => $from,
             'to' => $to,
             'subject' => $Subject,
             'body' => $body
            );
    $url="http://XXXXXXXXXX/signup/sendemail.php"; 
    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $sarray);
    $response = curl_exec($ch);
    curl_close($ch);   
    if($response){
        $message = "email successfully sent";
        $array=array("status"=>true,"message"=>$message);
    }else{
        $message = "unable to send email";
        $array=array("status"=>false,"message"=>$message);
    }
    exit(json_encode($array));    
}

function disabled_google_2fa($link,$user)
{
    $stmt = "UPDATE vicidial_users SET google_auth_code='',auth='0' WHERE user='$user'";
    $rslt = mysqli_query($GLOBALS['link'], $stmt);
}

function google_2fa($link,$user)
{
    $HTTP_HOST=$_SERVER['HTTP_HOST'];
    require_once 'GoogleAuthenticator/vendor/autoload.php';
    $gaobj     =  new PHPGangsta_GoogleAuthenticator();
    $secret    = $gaobj->createSecret();
    $qrCodeUrl = $gaobj->getQRCodeGoogleUrl($HTTP_HOST, $secret, $user_name);
    $data      = array(
        "qrCodeUrl" => $qrCodeUrl,
        "user" => $user,
        "secret" => $secret
    );
    $json = json_encode($data);    
    print_r($json);
    exit();
}

function execute_cx_api($group,$users,$action,$username)
{
	$key="d53e6ef9c64af3e28da29901f4553ce8";
	$method="POST";
	$ip=gethostbyname($_SERVER['HTTP_HOST']);
	$UserIP=$_SERVER['REMOTE_ADDR'];
	$post=array("Key"=>$key,"IP"=>$ip,"Group"=>$group,"Users"=>$users,"Action"=>$action,"Username"=>$username,"UserIP"=>$UserIP);
	//print_r($post);
	$url="https://api.XXXXXXXXXX.com/api/v1/cclimit";	
  	$ch = curl_init($url);
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
	curl_setopt($ch, CURLOPT_POSTFIELDS, $post);
	$response = curl_exec($ch);
	curl_close($ch);    
    print_r($response);
    exit();
}

function GetBalance()
{
    $host = $_SERVER['HTTP_HOST'];
    $url  = "http://$host/admin/balance.php";
    $ch   = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
    $result = curl_exec($ch);
    curl_close($ch);
    return $result;
}

function waitting_out($campaign_id) {

    if ($campaign_id != "") {
        $campaign = "AND campaign_id='$campaign_id'";
    } else {
        $campaign = "AND campaign_id IN(" . ALLOWED_CLOSER . ")";
    }

   $stmt="select count(*) as queue from vicidial_auto_calls where status NOT IN('XFER') and call_type IN('OUT','OUTBALANCE') $campaign";
    $result = mysqli_query($GLOBALS['link'], $stmt);
    while (($row[] = mysqli_fetch_assoc($result)) || array_pop($row));
    $return=0;
    if(sizeof($row)>0){
        $return  = $row[0]['queue'];
    }    
    return $return;
}
    
function waitting_in($campaign_id) {

    if ($campaign_id != "") {
        $campaign = "AND campaign_id='$campaign_id'";
    } else {
        $campaign = "AND campaign_id IN(" . ALLOWED_CAMPAIGNS . ")";
    }

    $stmt="select count(*) as queue from vicidial_auto_calls where status NOT IN('XFER') and call_type='IN' $campaign";
    $result = mysqli_query($GLOBALS['link'], $stmt);
    while (($row[] = mysqli_fetch_assoc($result)) || array_pop($row));
    $return=0;
    if(sizeof($row)>0){
        $return  = $row[0]['queue'];
    }    
    return $return;
}

function array_msort($array, $cols)
{
    if (sizeof($array) == 0) {
        return $array;
    }
    $colarr = array();
    foreach ($cols as $col => $order) {
        $colarr[$col] = array();
        foreach ($array as $k => $row) {
            $colarr[$col]['_' . $k] = strtolower($row[$col]);
        }
    }
    $eval = 'array_multisort(';
    foreach ($cols as $col => $order) {
        $eval .= '$colarr[\'' . $col . '\'],' . $order . ',';
    }
    $eval = substr($eval, 0, -1) . ');';
    eval($eval);
    $ret = array();
    foreach ($colarr as $col => $arr) {
        foreach ($arr as $k => $v) {
            $k = substr($k, 1);
            if (!isset($ret[$k]))
                $ret[$k] = $array[$k];
            $ret[$k][$col] = $array[$k][$col];
        }
    }
    return $ret;
}

function get_ringing_calls($campaign_id)
{
    if ($campaign_id != "") {
        $campaign = "AND campaign_id='$campaign_id'";
    } else {
        $campaign = "AND campaign_id IN(" . ALLOWED_CAMPAIGNS . ")";
    }
    $stmt = "SELECT status from vicidial_auto_calls where status NOT IN('XFER') and (call_type='OUT' OR call_type='IN') $campaign";

    $row    = null;
    $result = mysqli_query($GLOBALS['link'], $stmt);
    while (($row[] = mysqli_fetch_assoc($result)) || array_pop($row));
    $active_calls  = sizeof($row);
    $ringing_calls = 0;
    if ($active_calls > 0) {
        for ($i = 0; $i < sizeof($row); $i++) {
            if (!preg_match("/LIVE|CLOSER/i", $row[$i]['status'])) {
                $ringing_calls++;
            }
        }
    }
    $array = array(
        "active_calls" => $active_calls,
        "ringing_calls" => $ringing_calls
    );
    return $array;
}

function live_in($campaign_id) {
    if ($campaign_id != "") {
        $campaign = "AND campaign_id='$campaign_id'";
    } else {
        $campaign = "AND campaign_id IN(" . ALLOWED_CAMPAIGNS . ")";
    }
    $stmt = "select count(*) AS inbound from vicidial_live_agents as vla,vicidial_users as vu where vla.user=vu.user and status = 'INCALL' and comments = 'INBOUND' $campaign";
        $row    = null;
        $result = mysqli_query($GLOBALS['link'], $stmt);
        while (($row[] = mysqli_fetch_assoc($result)) || array_pop($row));
        $inboundRows  = sizeof($row);  
        $inbound=0;      
        if ($inboundRows > 0) {
           $inbound=$row[0]['inbound'];
        }
        return $inbound;
}

    function live_out($campaign_id) {
        
    if ($campaign_id != "") {
        $campaign = "AND campaign_id='$campaign_id'";
    } else {
        $campaign = "AND campaign_id IN(" . ALLOWED_CAMPAIGNS . ")";
    }
    $stmt = "select count(*) AS outbound from vicidial_live_agents as vla,vicidial_users as vu where vla.user=vu.user and status = 'INCALL' AND comments IN ('MANUAL','AUTO') $campaign";
        $row    = null;
        $result = mysqli_query($GLOBALS['link'], $stmt);
        while (($row[] = mysqli_fetch_assoc($result)) || array_pop($row));
        $outbound=0;      
        $outboundRows  = sizeof($row);
        if ($outboundRows > 0) {
           $outbound=$row[0]['outbound'];
        }
        return $outbound;
    }


    

function sale_outbound_today($campaign_id,$user="")
{
    $sales      = 0;
    $query_date = date('Y-m-d');
    if ($campaign_id != "") {
        $campaign = "AND campaign_id='$campaign_id'";
    } else {       
        $campaign = "AND campaign_id IN(" . ALLOWED_CAMPAIGNS . ")";
    }
    
    $SqlUser="";
    if(trim($user)!="")
    {
        $SqlUser=" AND user='$user'";
    }

    $sql1="SELECT count(1) AS insale FROM vicidial_agent_log WHERE status IN(SELECT status FROM vicidial_campaign_statuses WHERE sale='Y' $campaign_for_status) AND (comments='MANUAL' OR comments IS NULL) AND event_time BETWEEN '$query_date 00:00:00' AND '$query_date 23:59:59' $campaign $SqlUser";

    $sql2="SELECT count(1) AS insale FROM vicidial_agent_log WHERE status IN(SELECT status FROM vicidial_statuses WHERE sale='Y') AND (comments='MANUAL' OR comments IS NULL) AND  event_time BETWEEN '$query_date 00:00:00' AND '$query_date 23:59:59' $campaign $SqlUser";

    
    $row    = null;
    $sql=$sql1." union all ".$sql2;
    $result = mysqli_query($GLOBALS['link'], $sql);
    while (($array[] = mysqli_fetch_assoc($result)) || array_pop($array));
    if (sizeof($array) > 0) {
        $sales = strval($array[0]['insale']) + strval($array[1]['insale']);
    } else {
        $sales = 0;
    }
    return $sales;
}

function sale_inbound_today($campaign_id,$user="")
{
    $sales      = 0;
    $query_date = date('Y-m-d');


    if ($campaign_id != "") {
        $campaign = "AND campaign_id='$campaign_id'";
    } else {
        $campaign = "AND campaign_id IN(" . ALLOWED_CAMPAIGNS . ")";
    }
   
    $SqlUser="";
    if(trim($user)!="")
    {
        $SqlUser=" AND user='$user'";
    }

    $sql1="SELECT count(1) AS insale FROM vicidial_agent_log WHERE status IN(SELECT status FROM vicidial_campaign_statuses WHERE sale='Y' $campaign_for_status) AND comments='INBOUND' AND event_time BETWEEN '$query_date 00:00:00' AND '$query_date 23:59:59' $campaign $SqlUser";

    $sql2="SELECT count(1) AS insale FROM vicidial_agent_log WHERE status IN(SELECT status FROM vicidial_statuses WHERE sale='Y') AND comments='INBOUND' AND  event_time BETWEEN '$query_date 00:00:00' AND '$query_date 23:59:59' $campaign $SqlUser";
    

    $row    = null;
    $sql=$sql1." union all ".$sql2;
    $result = mysqli_query($GLOBALS['link'], $sql);
    while (($array[] = mysqli_fetch_assoc($result)) || array_pop($array));
    if (sizeof($array) > 0) {
        $sales = strval($array[0]['insale']) + strval($array[1]['insale']);
    } else {
        $sales = 0;
    }
    return $sales;
}

function get_user_name($user)
{
    $query  = "SELECT full_name FROM vicidial_users WHERE user='$user'";
    $row    = null;
    $result = mysqli_query($GLOBALS['link'], $query);
    while (($array[] = mysqli_fetch_assoc($result)) || array_pop($array));
    if (sizeof($resultArray) > 0) {
        $full_name = $resultArray[0]['full_name'];
    } else {
        $full_name = "";
    }
    return $full_name;
}

function queue_calls($campaign_id)
{
    $campaign = "";
    if (trim($campaign_id) != "") {
        $campaign = " AND campaign_id='$campaign_id'";
    } else {        
        $campaign = "AND campaign_id IN(" . ALLOWED_CAMPAIGNS . ")";
    }

    $query  = "select count(uniqueid) as qresult from vicidial_auto_calls where status IN ('LIVE') $campaign";
    $row    = null;
    $result = mysqli_query($GLOBALS['link'], $query);
    while (($array[] = mysqli_fetch_assoc($result)) || array_pop($array));
    $qresult = 0;
    if (sizeof($array) > 0) {
        $qresult = $array[0]['qresult'];
    }
    return $qresult;
}

function get_percent_dialable_leads($campaign_id) {
    $campaign = "";
    if (trim($campaign_id) != "") {
        $campaign = "WHERE campaign_id='$campaign_id'";
    } else {
        $campaign = "WHERE campaign_id IN(" . ALLOWED_CAMPAIGNS . ")";
    }

    $whereLOGadmin_viewable_groupsSQL = get_allowed_user_groups($GLOBALS['link'], USER_GROUP, $where_clause = 'where');
    ##### get filters listing for dynamic pulldown
    $stmt = "SELECT lead_filter_id,lead_filter_name,lead_filter_sql from vicidial_lead_filters $whereLOGadmin_viewable_groupsSQL order by lead_filter_id;";
    $rslt = mysql_to_mysqli($stmt, $GLOBALS['link']);
    $filters_to_print = mysqli_num_rows($rslt);
    $o = 0;
    while ($filters_to_print > $o) {
        $rowx = mysqli_fetch_row($rslt);
        $filtersql_list["$rowx[0]"] = "$rowx[2]";
        $o++;
    }

    $stmtA = "SELECT hopper_level,local_call_time,dial_statuses,drop_lockout_time,call_count_limit,lead_filter_id FROM vicidial_campaigns $campaign;";
    $rsltA = mysql_to_mysqli($stmtA, $GLOBALS['link']);
    $rowA  = mysqli_fetch_assoc($rsltA);

    $lead_filter_id    = $rowA['lead_filter_id'];
    $hopper_level      = $rowA['hopper_level'];
    $local_call_time   = $rowA['local_call_time'];
    $dial_statuses     = $rowA['dial_statuses'];
    $drop_lockout_time = $rowA['drop_lockout_time'];
    $call_count_limit  = $rowA['call_count_limit'];
    
    if ($lead_filter_id == '') {
        $lead_filter_id = 'NONE';
    }

    $dial_statuses = preg_replace("/ -$/", "", $dial_statuses);

    // Get active lists.
    $stmtB = "SELECT list_id from vicidial_lists $campaign AND active='Y';";
    $rsltB           = mysql_to_mysqli($stmtB, $GLOBALS['link']);
    $lists_to_print = mysqli_num_rows($rsltB);
    $o   = 0;
    while ($lists_to_print > $o) {
        $camp_lists .= "'$row[0]',";
        $o++;
    }

    $camp_lists = preg_replace('/.$/i', '', $camp_lists);
    $DB            = 0;
    $single_status = 1;
    
    $filterSQL = $filtersql_list[$lead_filter_id];
    $filterSQL = preg_replace("/\\\\/", "", $filterSQL);
    $filterSQL = preg_replace('/^and|and$|^or|or$/i', '', $filterSQL);
    if (strlen($filterSQL) > 4) {
        $fSQL = "and ($filterSQL)";
    } else {
        $fSQL = '';
    }

    $dialable_leads = get_dialable_leads($DB, $GLOBALS['link'], $local_call_time, $dial_statuses, $camp_lists, $drop_lockout_time, $call_count_limit, $single_status, $fSQL);

    $dialable_leads = intval($dialable_leads);// if string is returned then convert it into int.

    $percent_dialable_leads = 100;
    if($dialable_leads < $hopper_level) {
        $percent_dialable_leads = intval(($dialable_leads*100)/$hopper_level);
    }

    $array=array("dialable_per"=>$percent_dialable_leads,"dialable_leads"=>$dialable_leads);
    
    return $array;
}



function callbacks_calls($campaign_id)
{
    $campaign = "";
    if (trim($campaign_id) != "") {
        $campaign = " AND campaign_id='$campaign_id'";
    } else {        
        $campaign = " AND campaign_id IN(" . ALLOWED_CAMPAIGNS . ")";
    }
    $query  = "select count(*) as qresult from vicidial_callbacks where date(modify_date)=date(now()) $campaign";
    $row    = null;
    $result = mysqli_query($GLOBALS['link'], $query);
    while (($array[] = mysqli_fetch_assoc($result)) || array_pop($array));
    $qresult = 0;
    if (sizeof($array) > 0) {
        $qresult = $array[0]['qresult'];
    }
    return $qresult;
}

function talking_calls($campaign_id)
{
    $campaign = "";
    if (trim($campaign_id) != "") {
        $campaign = " AND campaign_id='$campaign_id'";
    } else {        
        $campaign = "AND campaign_id IN(" . ALLOWED_CAMPAIGNS . ")";
    }
    $query  = "select count(lead_id) as qresult from vicidial_live_agents where status IN ('INCALL') $campaign";
    $row    = null;
    $result = mysqli_query($GLOBALS['link'], $query);
    while (($array[] = mysqli_fetch_assoc($result)) || array_pop($array));
    $qresult = 0;
    if (sizeof($array) > 0) {
        $qresult = $array[0]['qresult'];
    }
    return $qresult;
}

function waiting_calls($campaign_id)
{
    $campaign = "";
    if (trim($campaign_id) != "") {
        $campaign = " AND campaign_id='$campaign_id'";
    } else {
       
        $campaign = "AND campaign_id IN(" .ALLOWED_CAMPAIGNS . ")";

    }
    $query  = "select count(lead_id) as qresult from vicidial_live_agents where status IN ('READY','CLOSER') $campaign";
    $row    = null;
    $result = mysqli_query($GLOBALS['link'], $query);
    while (($array[] = mysqli_fetch_assoc($result)) || array_pop($array));
    $qresult = 0;
    if (sizeof($array) > 0) {
        $qresult = $array[0]['qresult'];
    }
    return $qresult;
}

function wrap_calls($campaign_id)
{
    $campaign = "";
    if (trim($campaign_id) != "") {
        $campaign = " AND campaign_id='$campaign_id'";
    } else {        
        $campaign = "AND campaign_id IN(" . ALLOWED_CAMPAIGNS . ")";
    }
    $query  = "select count(lead_id) as qresult from vicidial_live_agents where status IN ('DISPO') $campaign";
    $row    = null;
    $result = mysqli_query($GLOBALS['link'], $query);
    while (($array[] = mysqli_fetch_assoc($result)) || array_pop($array));
    $qresult = 0;
    if (sizeof($array) > 0) {
        $qresult = $array[0]['qresult'];
    }
    return $qresult;
}

function pause_calls($campaign_id)
{
    $campaign = "";
    if (trim($campaign_id) != "") {
        $campaign = " AND campaign_id='$campaign_id'";
    } else {       
        $campaign = "AND campaign_id IN(" .ALLOWED_CAMPAIGNS. ")";

    }
    $query  = "select count(lead_id) as qresult from vicidial_live_agents where status IN ('PAUSED') $campaign";
    $row    = null;
    $result = mysqli_query($GLOBALS['link'], $query);
    while (($array[] = mysqli_fetch_assoc($result)) || array_pop($array));
    $qresult = 0;
    if (sizeof($array) > 0) {
        $qresult = $array[0]['qresult'];
    }
    return $qresult;
}



function avg_wait_time($campaign_id,$user="")
{
    $date_skrg = date("Y-m-d");
    if ($campaign_id != "") {
        $campaign = "AND campaign_id='$campaign_id'";
    } else {       
        $campaign = "AND campaign_id IN(" . ALLOWED_CAMPAIGNS . ")";
    }

    $SqlUser="";
    if(trim($user)!="")
    {
        $SqlUser=" AND user='$user'";
    }

    $stmt = "select avg(wait_sec) as wait_time from vicidial_agent_log where event_time >= '" . $date_skrg . " 00:00' and event_time <= '" . $date_skrg . " 23:59' and pause_sec<65000 and wait_sec<65000 and talk_sec<65000 and dispo_sec<65000 $campaign $SqlUser;";

    $row    = null;
    $result = mysqli_query($GLOBALS['link'], $stmt);
    while (($array[] = mysqli_fetch_assoc($result)) || array_pop($array));

    $AVGwait    = $array[0]['wait_time'];
    $AVGwait_MS = sec_convert_fun($AVGwait, 'H');
    $AVGwait    = $AVGwait_MS;
    return $AVGwait;
}

function long_wait_time($campaign_id,$user="")
{
    $date_skrg = date("Y-m-d");
    if ($campaign_id != "") {
        $campaign = "AND campaign_id='$campaign_id'";
    } else {       
        $campaign = "AND campaign_id IN(" . ALLOWED_CAMPAIGNS . ")";
    }

    $SqlUser="";
    if(trim($user)!="")
    {
        $SqlUser=" AND user='$user'";
    }

    $stmt = "SELECT wait_sec from vicidial_agent_log where event_time >= '" . $date_skrg . " 00:00:00' and event_time <= '" . $date_skrg . " 23:59:59' $campaign $SqlUser order by wait_sec desc limit 1;";

    $row    = null;
    $result = mysqli_query($GLOBALS['link'], $stmt);
    while (($array[] = mysqli_fetch_assoc($result)) || array_pop($array));

    $LONGwait    = $array[0]['wait_sec'];
    $LONGwait_MS = sec_convert_fun($LONGwait, 'H');
    return $LONGwait_MS;
}

function long_talk_time($campaign_id,$user="")
{
    $date_skrg = date("Y-m-d");
    if ($campaign_id != "") {
        $campaign = "AND campaign_id='$campaign_id'";
    } else {       
        $campaign = "AND campaign_id IN(" . ALLOWED_CAMPAIGNS . ")";
    }

    $SqlUser="";
    if(trim($user)!="")
    {
        $SqlUser=" AND user='$user'";
    }

    $stmt = "SELECT talk_sec from vicidial_agent_log where event_time >= '" . $date_skrg . " 00:00:00' and event_time <= '" . $date_skrg . " 23:59:59' $campaign $SqlUser order by talk_sec desc limit 1;";

    $row    = null;
    $result = mysqli_query($GLOBALS['link'], $stmt);
    while (($array[] = mysqli_fetch_assoc($result)) || array_pop($array));

    $LONGwait    = $array[0]['talk_sec'];
    $LONGwait_MS = sec_convert_fun($LONGwait, 'H');
    return $LONGwait_MS;
}

function getextra($campaign_id)
{
    $inboundgroups = getInboundGroups($campaign_id);
    $campaign      = "";
    if (trim($campaign_id) != "") {
        $campaign = " AND a.campaign_id='$campaign_id'";
    } else {        
        $campaign = "AND a.campaign_id IN(" . ALLOWED_CAMPAIGNS . ")";
    }
     $query1="select a.dialable_leads,a.calls_today,a.answers_today,a.drops_today,IF(round(a.drops_today/(a.answers_today)*100,2) IS NULL,0.00,round(a.drops_today/(a.answers_today)*100,2)) as drop_rate,'outbound' as calltype from vicidial_campaign_stats a,vicidial_campaigns b where a.campaign_id=b.campaign_id and b.active='Y' $campaign union all "; 

    

        
        $query2="select a.dialable_leads,a.calls_today,a.answers_today,a.drops_today,IF(round(a.drops_today/a.answers_today*100,2) IS NULL,0.00,round(a.drops_today/a.answers_today*100,2)) as drop_rate,'inbound' as calltype from vicidial_campaign_stats a,vicidial_inbound_groups b where a.campaign_id=b.group_id and b.group_id in(".ALLOWED_CLOSER.") and b.active='Y'";

    $sql    = $query1 . "" . $query2;



    $row    = null;
    $result = mysqli_query($GLOBALS['link'], $sql);
    while (($array[] = mysqli_fetch_assoc($result)) || array_pop($array));

    


    $in_calls_today=0;
    $in_answers_today=0;
    $in_drops_today=0;
    $in_drop_rate=0;
    
    $out_calls_today=0;
    $out_answers_today=0;
    $out_drops_today=0;
    $out_drop_rate=0;       
    $in_dialable_leads=0;
    $out_dialable_leads=0;

    for($i=0;$i<sizeof($array);$i++)
                {
      $calltype=trim($array[$i]['calltype']);
      if($calltype=="inbound"){
        $in_calls_today=strval($in_calls_today)+strval($array[$i]['calls_today']);
        $in_answers_today=strval($in_answers_today)+strval($array[$i]['answers_today']);
        $in_drops_today=strval($in_drops_today)+strval($array[$i]['drops_today']);
        $in_drop_rate=strval($in_drop_rate)+strval($array[$i]['drop_rate']);
        $in_dialable_leads=strval($array[$i]['dialable_leads']);        
      }else{
        $out_calls_today=strval($out_calls_today)+strval($array[$i]['calls_today']);
        $out_answers_today=strval($out_answers_today)+strval($array[$i]['answers_today']);
        $out_drops_today=strval($out_drops_today)+strval($array[$i]['drops_today']);
        $out_drop_rate=strval($out_drop_rate)+strval($array[$i]['drop_rate']);
        $out_dialable_leads=strval($array[$i]['dialable_leads']);      
      } 
    }
    
    $calls_today=strval($in_calls_today)+strval($out_calls_today);                
    $answers_today=strval($in_answers_today)+strval($out_answers_today);
    $drops_today=strval($in_drops_today)+strval($out_drops_today);
    $dialable_leads=strval($in_dialable_leads)+strval($out_dialable_leads);
    if($drops_today=="0" || $answers_today=="0"){
        $drop_rate=0;
    }else{
        $drop_rate=strval($drops_today)/strval($answers_today)*100;
    }    
    $drop_rate=round($drop_rate,2);

    if($answers_today=="0" || $calls_today=="0"){
        $connectrate= 0;
    }else{
        $connectrate=  strval($answers_today)/strval($calls_today)*100;
    }

    // $connectrate=  strval($answers_today)/strval($calls_today)*100;
    $connectrate=round($connectrate,2); 

    $array=array("calls_today"=>$calls_today,"answers_today"=>$answers_today,"drops_today"=>$drops_today,"drop_rate"=>$drop_rate,'connectrate'=>$connectrate,"in_drops_today" => $in_drops_today,"out_drops_today" => $out_drops_today,"in_calls_today"=>$in_calls_today,"out_calls_today"=>$out_calls_today,"dialable_leads"=>$dialable_leads);
        return $array;
}

function sec_convert_fun($sec, $precision)
{
    $sec = round($sec, 0);

    if ($sec < 1) {
        return "0:00";
    } else {
        if ($sec < 3600) {
            $precision = 'M';
        }

        if ($precision == 'H') {
            $Fhours_H     = ($sec / 3600);
            $Fhours_H_int = floor($Fhours_H);
            $Fhours_H_int = intval("$Fhours_H_int");
            $Fhours_M     = ($Fhours_H - $Fhours_H_int);
            $Fhours_M     = ($Fhours_M * 60);
            $Fhours_M_int = floor($Fhours_M);
            $Fhours_M_int = intval("$Fhours_M_int");
            $Fhours_S     = ($Fhours_M - $Fhours_M_int);
            $Fhours_S     = ($Fhours_S * 60);
            $Fhours_S     = round($Fhours_S, 0);
            if ($Fhours_S < 10) {
                $Fhours_S = "0$Fhours_S";
            }
            if ($Fhours_M_int < 10) {
                $Fhours_M_int = "0$Fhours_M_int";
            }
            $Ftime = "$Fhours_H_int:$Fhours_M_int:$Fhours_S";
        }
        if ($precision == 'M') {
            $Fminutes_M     = ($sec / 60);
            $Fminutes_M_int = floor($Fminutes_M);
            $Fminutes_M_int = intval("$Fminutes_M_int");
            $Fminutes_S     = ($Fminutes_M - $Fminutes_M_int);
            $Fminutes_S     = ($Fminutes_S * 60);
            $Fminutes_S     = round($Fminutes_S, 0);
            if ($Fminutes_S < 10) {
                $Fminutes_S = "0$Fminutes_S";
            }
            $Ftime = "$Fminutes_M_int:$Fminutes_S";
        }
        if ($precision == 'S') {
            $Ftime = $sec;
        }
        return "$Ftime";
    }
}

function avg_pause_time($campaign_id,$user="")
{
    if ($campaign_id != "") {
        $campaign = "AND campaign_id='$campaign_id'";
    } else {
       
        $campaign = "AND campaign_id IN(" . ALLOWED_CAMPAIGNS . ")";
    }

    $SqlUser="";
    if(trim($user)!="")
    {
        $SqlUser=" AND user='$user'";
    }

    $date_skrg = date("Y-m-d");
    $stmt      = "select avg(pause_sec) as pause_time from vicidial_agent_log where event_time >= '" . $date_skrg . " 00:00' and event_time <= '" . $date_skrg . " 23:59' and talk_sec<65000 and wait_sec<65000 and wait_sec<65000 and dispo_sec<65000 $campaign $SqlUser;";

    $row    = null;
    $result = mysqli_query($GLOBALS['link'], $stmt);
    while (($array[] = mysqli_fetch_assoc($result)) || array_pop($array));

    $AVGtalk    = $array[0]['pause_time'];
    $AVGtalk_MS = sec_convert_fun($AVGtalk, 'H');
    $AVGtalk    = $AVGtalk_MS;
    return $AVGtalk;
}

function avg_talk_time($campaign_id,$user="")
{
    if ($campaign_id != "") {
        $campaign = "AND campaign_id='$campaign_id'";
    } else {
       
        $campaign = "AND campaign_id IN(" . ALLOWED_CAMPAIGNS . ")";
    }

    $SqlUser="";
    if(trim($user)!="")
    {
        $SqlUser=" AND user='$user'";
    }

    $date_skrg = date("Y-m-d");
    $stmt      = "select avg(talk_sec) as talk_time from vicidial_agent_log where event_time >= '" . $date_skrg . " 00:00' and event_time <= '" . $date_skrg . " 23:59' and pause_sec<65000 and wait_sec<65000 and wait_sec<65000 and dispo_sec<65000 $campaign $SqlUser;";

    $row    = null;
    $result = mysqli_query($GLOBALS['link'], $stmt);
    while (($array[] = mysqli_fetch_assoc($result)) || array_pop($array));

    $AVGtalk    = $array[0]['talk_time'];
    $AVGtalk_MS = sec_convert_fun($AVGtalk, 'H');
    $AVGtalk    = $AVGtalk_MS;
    return $AVGtalk;
}

function getCallPlaced($campaign_id)
{
    if ($campaign_id != "") {
        $campaign = "AND campaign_id='$campaign_id'";
    } else {        
        $campaign = "AND campaign_id IN(" . ALLOWED_CAMPAIGNS . ")";
    }

    $calls     = 0;
    $calls_out = 0;
    $calls_in  = 0;
    $date_skrg = date("Y-m-d");
    $sql       = "select count(lead_id) as call_placed from vicidial_log where call_date >= '" . $date_skrg . " 00:00' and call_date <= '" . $date_skrg . " 23:59' $campaign;";
    $row       = null;
    $result    = mysqli_query($GLOBALS['link'], $sql);
    while (($array[] = mysqli_fetch_assoc($result)) || array_pop($array));
    if (sizeof($array) > 0) {
        $calls_out = $array[0]['call_placed'];
    }

    $inboundgroups = getInboundGroups($campaign_id);
    $sql           = "select count(lead_id) as call_placed from vicidial_closer_log where call_date >= '" . $date_skrg . " 00:00' and call_date <= '" . $date_skrg . " 23:59' AND campaign_id in($inboundgroups);";
    $row           = null;
    $result        = mysqli_query($GLOBALS['link'], $sql);
    while (($array[] = mysqli_fetch_assoc($result)) || array_pop($array));
    if (sizeof($array) > 0) {
        $calls_in = $array[0]['call_placed'];
    }

    $calls = strval($calls_out) + strval($calls_in);

    return $calls;
}

function getCallConntected($campaign_id)
{
    if ($campaign_id != "") {
        $campaign = "AND campaign_id='$campaign_id'";
    } else {        
        $campaign = "AND campaign_id IN(" . ALLOWED_CAMPAIGNS . ")";
    }
    $calls     = 0;
    $date_skrg = date("Y-m-d");

    $sql1 = "select count(lead_id) as call_conntected from vicidial_agent_log where event_time >= '" . $date_skrg . " 00:00' and event_time <= '" . $date_skrg . " 23:59' and status IN (SELECT STATUS FROM vicidial_statuses) $campaign";
    $sql2 = "select count(lead_id) as call_conntected  from vicidial_agent_log where event_time >= '" . $date_skrg . " 00:00' and event_time <= '" . $date_skrg . " 23:59' and status IN ( SELECT STATUS FROM vicidial_campaign_statuses WHERE human_answered='Y'  $campaign) $campaign";

    $sql    = $sql1 . " union " . $sql2;
    $row    = null;
    $result = mysqli_query($GLOBALS['link'], $sql);
    while (($array[] = mysqli_fetch_assoc($result)) || array_pop($array));

    if (sizeof($array) > 0) {
        $calls_vicidial_statuses          = $array[0]['call_conntected'];
        $calls_vicidial_campaign_statuses = $array[1]['call_conntected'];
    }
    $calls = strval($calls_vicidial_statuses) + strval($calls_vicidial_campaign_statuses);

    return $calls;
}

function connected_rate($total, $conntected)
{
    $connected_rate = 0;
    if (strval($total) > 0) {
        $connected_rate = strval($conntected) / strval($total) * 100;
    }
    $connected_rate = round($connected_rate, 2);
    return $connected_rate;
}

function getInboundGroups($campaign_id)
{
    if ($campaign_id != '') {
        $stmt = "select closer_campaigns from vicidial_campaigns where active='Y' and campaign_id='$campaign_id'";
    } else {
        $stmt = "select closer_campaigns from vicidial_campaigns where active='Y'".LOGadmin_viewable_groupsSQL;
    }

    $row    = null;
    $result = mysqli_query($GLOBALS['link'], $stmt);
    while (($array[] = mysqli_fetch_assoc($result)) || array_pop($array));
    $closer_campaigns = "";
    for ($i = 0; $i < sizeof($array); $i++) {
        $closer_campaigns .= $array[$i]['closer_campaigns'];
    }
    $closer_campaigns    = preg_replace("/^ | -$/", "", $closer_campaigns);
    $closer_campaigns    = preg_replace("/ - /", " ", $closer_campaigns);
    $closer_campaigns    = preg_replace("/ /", "','", $closer_campaigns);
    $closer_campaignsSQL = "'$closer_campaigns'";
    return $closer_campaignsSQL;
}


function campaignStats()
{
    $campaign_id = trim($_POST['campaign_id']);
    if (trim($campaign_id) != "") {
        $sql = "SELECT campaign_id,campaign_name,active,auto_dial_level,dial_method FROM vicidial_campaigns WHERE campaign_id='$campaign_id'";
    } else {
        $sql = "SELECT campaign_id,campaign_name,active,auto_dial_level,dial_method FROM vicidial_campaigns WHERE campaign_id IN(" . ALLOWED_CAMPAIGNS . ")";
    }
    $row    = null;
    $result = mysqli_query($GLOBALS['link'], $sql);
    while (($array[] = mysqli_fetch_assoc($result)) || array_pop($array));
    $campaignStats = array();
    for ($i = 0; $i < sizeof($array); $i++) {
        $avg_wait         = avg_wait_time($array[$i]['campaign_id']);
        $total_leads      = total_leads($array[$i]['campaign_id']);
        $total_contacts   = total_contacts($array[$i]['campaign_id']);
        $inbound_sale     = sale_inbound_today($array[$i]['campaign_id']);
        $outbound_sale    = sale_outbound_today($array[$i]['campaign_id']);
        $total_connected  = getCallConntected($array[$i]['campaign_id']);
        $sales_conversion = sales_conversion($total_connected, $inbound_sale, $outbound_sale);
        $talking_calls    = talking_calls($array[$i]['campaign_id']);
        $waiting_calls    = waiting_calls($array[$i]['campaign_id']);
        $wrap_calls       = wrap_calls($array[$i]['campaign_id']);
        $pause_calls      = pause_calls($array[$i]['campaign_id']);
        $leads_inqueue    = leads_inqueue($array[$i]['campaign_id']);
        $queue_calls      = queue_calls($array[$i]['campaign_id']);


        $dialable_percent = get_percent_dialable_leads($array[$i]['campaign_id']);

      
    $dialable_leads =$dialable_percent['dialable_leads'];

        $dialable_percent =$dialable_percent['dialable_per'];
        


        $campaign_recall  = $array[$i]['dial_method'];
        $total_login      = get_total_login($array[$i]['campaign_id']);
        

        $campaignStats[] = array(
            "campaign_id"      => $array[$i]['campaign_id'],
            "campaign_name"    => $array[$i]['campaign_name'],
            "active"           => $array[$i]['active'],
            "auto_dial_level"  => $array[$i]['auto_dial_level'],
            "avg_wait"         => $avg_wait,
            "total_leads"      => $total_leads,
            "total_contacts"   => $total_contacts,
            "inbound_sale"     => $inbound_sale,
            "outbound_sale"    => $outbound_sale,
            "total_connected"  => $total_connected,
            "sales_conversion" => $sales_conversion,
            "talking_calls"    => $talking_calls,
            "waiting_calls"    => $waiting_calls,
            "wrap_calls"       => $wrap_calls,
            "pause_calls"      => $pause_calls,
            "leads_inqueue"    => $leads_inqueue,
            "queue_calls"      => $queue_calls,
            "dialable_percent" => $dialable_percent,
            "campaign_recall"  => str_replace("_"," ",$array[$i]['dial_method']),
            "total_login"      => $total_login,
            "dialable_leads"   => $dialable_leads
        );
    }
    return $campaignStats;
}

function get_campaign_recall($campaignId){        
        $total=0;
        $recall=0;
        $result=0;
        $array=null;
        $sql="select count(*) as total from vicidial_hopper where campaign_id='$campaignId'";
        $result = mysqli_query($GLOBALS['link'], $sql);
        while (($array[] = mysqli_fetch_assoc($result)) || array_pop($array));    
        if(sizeof($array)>0){
            $total=$array[0]['total'];            
            $array=null;
            $sql="select count(*) as recall from vicidial_hopper where campaign_id='$campaignId' and source='R'";
            $result = mysqli_query($GLOBALS['link'], $sql);
            while (($array[] = mysqli_fetch_assoc($result)) || array_pop($array));
            if(sizeof($array)>0){
                $recall=$array[0]['recall'];
            }
            $result=strval($recall)/strval($total);
            $result=number_format($result, 2);
        }
        return $result."%";
    }


function total_leads($campaign_id)
{
    if ($campaign_id != "") {
        $campaign = "AND campaign_id='$campaign_id'";
    } else {        
        $campaign = "AND campaign_id IN(" . ALLOWED_CAMPAIGNS . ")";
    }

    $leads  = 0;
    $stmt   = "SELECT count(vl.lead_id) as leads from vicidial_list vl,vicidial_lists vls where vls.list_id=vl.list_id $campaign";
    $row    = null;
    $result = mysqli_query($GLOBALS['link'], $stmt);
    while (($array[] = mysqli_fetch_assoc($result)) || array_pop($array));
    if (sizeof($array) > 0) {
        $leads = $array[0]['leads'];
    }
    return $leads;
}

function total_contacts($campaign_id)
{
    if ($campaign_id != "") {
        $campaign = "AND campaign_id='$campaign_id'";
    } else {
       
        $campaign = "AND campaign_id IN(" . ALLOWED_CAMPAIGNS . ")";
    }

    $query  = "select count(vl.list_id) qresult from vicidial_lists as vls,vicidial_list as vl where vl.status='NEW' AND vl.list_id=vls.list_id and active='Y' $campaign";
    $row    = null;
    $result = mysqli_query($GLOBALS['link'], $query);
    while (($array[] = mysqli_fetch_assoc($result)) || array_pop($array));
    $qresult = 0;
    if (sizeof($array) > 0) {
        $qresult = $array[0]['qresult'];
    }
    return $qresult;
}

function sales_conversion($total_connected, $inbound_sale, $outbound_sale)
{
    $total_sales = strval($inbound_sale) + strval($outbound_sale);
    $conversion  = 0;
    if (strval($total_connected) > 0) {
        $conversion = strval($total_sales) / strval($total_connected) * 100;
    }
    $conversion = round($conversion, 2);
    return $conversion;
}

function leads_inqueue($campaign_id)
{
    if ($campaign_id != "") {
        $campaign = "WHERE campaign_id='$campaign_id'";
    } else {       
        $campaign = "WHERE campaign_id IN(" . ALLOWED_CAMPAIGNS . ")";
    }
    $query  = "select count(lead_id) qresult from vicidial_hopper $campaign";
    $row    = null;
    $result = mysqli_query($GLOBALS['link'], $query);
    while (($array[] = mysqli_fetch_assoc($result)) || array_pop($array));
    $qresult = 0;
    if (sizeof($array) > 0) {
        $qresult = $array[0]['qresult'];
    }
    return $qresult;
}

function strtoInt($val)
{
    return (int) $val;
}

function campaign_logout($campaign_id)
{
    $DB = 0;
    if (strlen($campaign_id) < 2) {
        echo "<br>" . "AGENTS NOT LOGGED OUT OF CAMPAIGN - Please go back and look at the data you entered" . "\n";
        echo "<br>Campaign_id " . "must be at least 2 characters in length" . "\n";
    } else {
        $stmtLOG = '';
        $stmt    = "SELECT count(campaign_id) from vicidial_campaigns where campaign_id='$campaign_id';";
        $rslt    = mysqli_query($GLOBALS['link'], $stmt);
        $row     = mysqli_fetch_row($rslt);
        if ($row[0] < 1) {
            echo "<br>" . "CAMPAIGN NOT FOUND" . ": $campaign_id\n";
        } else {
            $now_date_epoch = date('U');
            $inactive_epoch = ($now_date_epoch - 60);
            $stmt           = "SELECT user,campaign_id,UNIX_TIMESTAMP(last_update_time),extension from vicidial_live_agents where campaign_id='$campaign_id';";
            $rslt           = mysqli_query($GLOBALS['link'], $stmt);
            if ($DB) {
                echo "<BR>$stmt\n";
            }
            $vla_ct = mysqli_num_rows($rslt);
            $k      = 0;
            while ($vla_ct > $k) {
                $row                 = mysqli_fetch_row($rslt);
                $VLA_user[$k]        = $row[0];
                $VLA_campaign_id[$k] = $row[1];
                $VLA_update_time[$k] = $row[2];
                $VLA_extension[$k]   = $row[3];
                $k++;
            }

            $k = 0;
            while ($vla_ct > $k) {
                if ($VLA_update_time[$k] > $inactive_epoch) {
                    $lead_active = 0;
                    $stmt        = "SELECT agent_log_id,user,server_ip,event_time,lead_id,campaign_id,pause_epoch,pause_sec,wait_epoch,wait_sec,talk_epoch,talk_sec,dispo_epoch,dispo_sec,status,user_group,comments,sub_status,dead_epoch,dead_sec from vicidial_agent_log where user='$VLA_user[$k]' order by agent_log_id desc LIMIT 1;";
                    $rslt        = mysqli_query($GLOBALS['link'], $stmt);
                    if ($DB) {
                        echo "<BR>$stmt\n";
                    }
                    $val_ct = mysqli_num_rows($rslt);
                    if ($val_ct > 0) {
                        $row              = mysqli_fetch_row($rslt);
                        $VAL_agent_log_id = $row[0];
                        $VAL_user         = $row[1];
                        $VAL_server_ip    = $row[2];
                        $VAL_event_time   = $row[3];
                        $VAL_lead_id      = $row[4];
                        $VAL_campaign_id  = $row[5];
                        $VAL_pause_epoch  = $row[6];
                        $VAL_pause_sec    = $row[7];
                        $VAL_wait_epoch   = $row[8];
                        $VAL_wait_sec     = $row[9];
                        $VAL_talk_epoch   = $row[10];
                        $VAL_talk_sec     = $row[11];
                        $VAL_dispo_epoch  = $row[12];
                        $VAL_dispo_sec    = $row[13];
                        $VAL_status       = $row[14];
                        $VAL_user_group   = $row[15];
                        $VAL_comments     = $row[16];
                        $VAL_sub_status   = $row[17];
                        $VAL_dead_epoch   = $row[18];
                        $VAL_dead_sec     = $row[19];

                        if ($DB) {
                            echo "\n<BR>" . "VAL VALUES" . ": $VAL_agent_log_id|$VAL_status|$VAL_lead_id\n";
                        }

                        if (($VAL_wait_epoch < 1) or (($VAL_status == 'PAUSE') and ($VAL_dispo_epoch < 1))) {
                            $VAL_pause_sec = (($now_date_epoch - $VAL_pause_epoch) + $VAL_pause_sec);
                            $stmt          = "UPDATE vicidial_agent_log SET wait_epoch='$now_date_epoch', pause_sec='$VAL_pause_sec', pause_type='ADMIN' where agent_log_id='$VAL_agent_log_id';";
                            $stmtLOG .= "$stmt|";
                        } else {
                            if ($VAL_talk_epoch < 1) {
                                $VAL_wait_sec = (($now_date_epoch - $VAL_wait_epoch) + $VAL_wait_sec);
                                $stmt         = "UPDATE vicidial_agent_log SET talk_epoch='$now_date_epoch', wait_sec='$VAL_wait_sec' where agent_log_id='$VAL_agent_log_id';";
                                $stmtLOG .= "$stmt|";
                            } else {
                                $lead_active++;
                                $status_update_SQL = '';
                                if (((strlen($VAL_status) < 1) or ($VAL_status == 'NULL')) and ($VAL_lead_id > 0)) {
                                    $status_update_SQL = ", status='PU'";
                                    $stmt              = "UPDATE vicidial_list SET status='PU' where lead_id='$VAL_lead_id';";
                                    if ($DB) {
                                        echo "<BR>$stmt\n";
                                    }
                                    $rslt = mysqli_query($GLOBALS['link'], $stmt);
                                    $stmtLOG .= "$stmt|";
                                }
                                if ($VAL_dispo_epoch < 1) {
                                    $VAL_talk_sec = ($now_date_epoch - $VAL_talk_epoch);
                                    $stmt         = "UPDATE vicidial_agent_log SET dispo_epoch='$now_date_epoch', talk_sec='$VAL_talk_sec'$status_update_SQL where agent_log_id='$VAL_agent_log_id';";
                                    $stmtLOG .= "$stmt|";
                                } else {
                                    if ($VAL_dispo_sec < 1) {
                                        $VAL_dispo_sec = ($now_date_epoch - $VAL_dispo_epoch);
                                        $stmt          = "UPDATE vicidial_agent_log SET dispo_sec='$VAL_dispo_sec' where agent_log_id='$VAL_agent_log_id';";
                                        $stmtLOG .= "$stmt|";
                                    }
                                }
                            }
                        }

                        if ($DB) {
                            echo "<BR>$stmt\n";
                        }
                        $rslt = mysqli_query($GLOBALS['link'], $stmt);
                    }
                }

                $stmt = "DELETE from vicidial_live_agents where user='$VLA_user[$k]';";
                if ($DB) {
                    echo "<BR>$stmt\n";
                }
                $rslt = mysqli_query($GLOBALS['link'], $stmt);
                $stmtLOG .= "$stmt|";

                if (strlen($VAL_user_group) < 1) {
                    $stmt = "SELECT user_group FROM vicidial_users where user='$VLA_user[$k]' $LOGadmin_viewable_groupsSQL;";
                    $rslt = mysqli_query($GLOBALS['link'], $stmt);
                    if ($DB) {
                        echo "<BR>$stmt\n";
                    }
                    $val_ct = mysqli_num_rows($rslt);
                    if ($val_ct > 0) {
                        $row            = mysqli_fetch_row($rslt);
                        $VAL_user_group = $row[0];
                    }
                }

                $stmt = "INSERT INTO vicidial_user_log (user,event,campaign_id,event_date,event_epoch,user_group) values('$VLA_user[$k]','LOGOUT','$VLA_campaign_id[$k]','$SQLdate','$now_date_epoch','$VAL_user_group');";
                if ($DB) {
                    echo "<BR>$stmt\n";
                }
                $rslt = mysqli_query($GLOBALS['link'], $stmt);
                $stmtLOG .= "$stmt|";


                #############################################
                ##### START QUEUEMETRICS LOGGING LOOKUP #####
                $stmt = "SELECT enable_queuemetrics_logging,queuemetrics_server_ip,queuemetrics_dbname,queuemetrics_login,queuemetrics_pass,queuemetrics_log_id,queuemetrics_loginout,queuemetrics_addmember_enabled,queuemetrics_dispo_pause,queuemetrics_pe_phone_append,queuemetrics_pause_type FROM system_settings;";
                $rslt = mysqli_query($GLOBALS['link'], $stmt);
                if ($DB) {
                    echo "<BR>$stmt\n";
                }
                $qm_conf_ct = mysqli_num_rows($rslt);
                if ($qm_conf_ct > 0) {
                    $row                            = mysqli_fetch_row($rslt);
                    $enable_queuemetrics_logging    = $row[0];
                    $queuemetrics_server_ip         = $row[1];
                    $queuemetrics_dbname            = $row[2];
                    $queuemetrics_login             = $row[3];
                    $queuemetrics_pass              = $row[4];
                    $queuemetrics_log_id            = $row[5];
                    $queuemetrics_loginout          = $row[6];
                    $queuemetrics_addmember_enabled = $row[7];
                    $queuemetrics_dispo_pause       = $row[8];
                    $queuemetrics_pe_phone_append   = $row[9];
                    $queuemetrics_pause_type        = $row[10];
                }
                ##### END QUEUEMETRICS LOGGING LOOKUP #####
                ###########################################
                if ($enable_queuemetrics_logging > 0) {
                    $QM_LOGOFF = 'AGENTLOGOFF';
                    if ($queuemetrics_loginout == 'CALLBACK') {
                        $QM_LOGOFF = 'AGENTCALLBACKLOGOFF';
                    }

                    $linkB = mysqli_connect("$queuemetrics_server_ip", "$queuemetrics_login", "$queuemetrics_pass", "$queuemetrics_dbname");
                    if (!$linkB) {
                        die('MySQL ' . "connect ERROR" . ': ' . mysqli_connect_error());
                    }
                    $agents          = '@agents';
                    $agent_logged_in = '';
                    $time_logged_in  = '0';

                    $stmtB = "SELECT agent,time_id,data1 FROM queue_log where agent='Agent/$VLA_user[$k]' and verb IN('AGENTLOGIN','AGENTCALLBACKLOGIN') and time_id > $check_time order by time_id desc limit 1;";
                    $rsltB = mysqli_query($GLOBALS['link'], $stmtB);
                    if ($DB) {
                        echo "<BR>$stmtB\n";
                    }
                    $qml_ct = mysqli_num_rows($rsltB);
                    if ($qml_ct > 0) {
                        $row               = mysqli_fetch_row($rsltB);
                        $agent_logged_in   = $row[0];
                        $time_logged_in    = $row[1];
                        $RAWtime_logged_in = $row[1];
                        $phone_logged_in   = $row[2];
                    }

                    $time_logged_in = ($now_date_epoch - $time_logged_in);
                    if ($time_logged_in > 1000000) {
                        $time_logged_in = 1;
                    }

                    if ($queuemetrics_loginout == 'NONE') {
                        $pause_typeSQL = '';
                        if ($queuemetrics_pause_type > 0) {
                            $pause_typeSQL = ",data5='ADMIN'";
                        }
                        $stmt = "INSERT INTO queue_log SET `partition`='P01',time_id='$now_date_epoch',call_id='NONE',queue='NONE',agent='Agent/$VLA_user[$k]',verb='PAUSEREASON',serverid='$queuemetrics_log_id',data1='LOGOFF'$pause_typeSQL;";
                        if ($DB) {
                            echo "$stmt\n";
                        }
                        $rslt          = mysqli_query($GLOBALS['link'], $stmt);
                        $affected_rows = mysqli_affected_rows($linkB);
                    }

                    if ($queuemetrics_addmember_enabled > 0) {
                        $queuemetrics_phone_environment = '';
                        $stmt                           = "SELECT queuemetrics_phone_environment FROM vicidial_campaigns where campaign_id='$VLA_campaign_id[$k]';";
                        $rslt                           = mysqli_query($GLOBALS['link'], $stmt);
                        if ($DB) {
                            echo "<BR>$stmt\n";
                        }
                        $cqpe_ct = mysqli_num_rows($rslt);
                        if ($cqpe_ct > 0) {
                            $row                            = mysqli_fetch_row($rslt);
                            $queuemetrics_phone_environment = $row[0];
                        }

                        if (($time_logged_in < 1) or ($queuemetrics_loginout == 'NONE')) {
                            $stmtB = "SELECT agent,time_id,data3 FROM queue_log where agent='Agent/$VLA_user[$k]' and verb='PAUSEREASON' and data1='LOGIN' order by time_id desc limit 1;";
                            $rsltB = mysqli_query($GLOBALS['link'], $stmtB);
                            if ($DB) {
                                echo "<BR>$stmtB\n";
                            }
                            $qml_ct = mysqli_num_rows($rsltB);
                            if ($qml_ct > 0) {
                                $row               = mysqli_fetch_row($rsltB);
                                $agent_logged_in   = $row[0];
                                $time_logged_in    = $row[1];
                                $RAWtime_logged_in = $row[1];
                                $phone_logged_in   = $row[2];
                            }
                            $time_logged_in = ($now_date_epoch - $time_logged_in);
                            if ($time_logged_in > 1000000) {
                                $time_logged_in = 1;
                            }
                        }
                        $stmt = "SELECT distinct queue FROM queue_log where time_id >= $RAWtime_logged_in and agent='$agent_logged_in' and verb IN('ADDMEMBER','ADDMEMBER2')  and queue != '$VLA_campaign_id[$k]' order by time_id desc;";
                        $rslt = mysqli_query($GLOBALS['link'], $stmt);
                        if ($DB) {
                            echo "$stmt\n";
                        }
                        $amq_conf_ct = mysqli_num_rows($rslt);
                        $i           = 0;
                        while ($i < $amq_conf_ct) {
                            $row         = mysqli_fetch_row($rslt);
                            $AMqueue[$i] = $row[0];
                            $i++;
                        }

                        ### add the logged-in campaign as well
                        $AMqueue[$i] = $VLA_campaign_id[$k];
                        $i++;
                        $amq_conf_ct++;

                        $i = 0;
                        while ($i < $amq_conf_ct) {
                            $pe_append = '';
                            if (($queuemetrics_pe_phone_append > 0) and (strlen($queuemetrics_phone_environment) > 0)) {
                                $qm_extension = explode('/', $phone_logged_in);
                                $pe_append    = "-$qm_extension[1]";
                            }
                            $stmt          = "INSERT INTO queue_log SET `partition`='P01',time_id='$now_date_epoch',call_id='NONE',queue='$AMqueue[$i]',agent='$agent_logged_in',verb='REMOVEMEMBER',data1='$phone_logged_in',serverid='$queuemetrics_log_id',data4='$queuemetrics_phone_environment$pe_append';";
                            $rslt          = mysqli_query($GLOBALS['link'], $stmt);
                            $affected_rows = mysqli_affected_rows($linkB);
                            $i++;
                        }
                    }

                    if ($queuemetrics_loginout != 'NONE') {
                        $stmtB = "INSERT INTO queue_log SET `partition`='P01',time_id='$now_date_epoch',call_id='NONE',queue='NONE',agent='$agent_logged_in',verb='$QM_LOGOFF',serverid='$queuemetrics_log_id',data1='$phone_logged_in',data2='$time_logged_in';";
                        if ($DB) {
                            echo "<BR>$stmtB\n";
                        }
                        $rsltB = mysqli_query($GLOBALS['link'], $stmtB);
                    }
                }

                echo "<!-- Agent $VLA_user[$k] has been emergency logged out, make sure they close their web browser<BR> -->\n";

                $k++;
            }
            echo "SUCCESS:<br><B>" . "AGENT LOGOUT COMPLETED" . ": $campaign_id</B>\n";
            echo "<br><br>\n";
        }
    }
}

function queue_reset($campaign_id)
{
    $stmt = "DELETE from vicidial_hopper where campaign_id='$campaign_id' and status IN('READY','QUEUE','DONE');";
    $rslt = mysqli_query($GLOBALS['link'], $stmt);
    if ($rslt) {
        echo "SUCCESS:<br>RESETTING QUEUE<br><br>";
        echo "<br>Please. Wait 1 minute before dialing next number<br><br>";
    } else {
        echo "<br>UNABLE RESETTING QUEUE<br><br>";
    }
}

function getAutoDialLevel($type, $current, $campaign_id)
{
    $sql = "SELECT auto_dial_limit from system_settings;";
    $row = null;
    $res = mysqli_query($GLOBALS['link'], $sql);
    while (($result[] = mysqli_fetch_assoc($res)) || array_pop($result));
    $auto_dial_limit = $result[0]['auto_dial_limit'];
    if (strval($$current) >= strval($auto_dial_limit)) {
        $return = $auto_dial_limit;
    } else {
        $levels = getLevels();
        $key    = array_search($current, $levels);
        if ($type == "plus") {
            $key = strval($key) + 1;
        } else {
            $key = strval($key) - 1;
        }
        $return = $levels[$key];
    }
    if (strval($return) <= 0) {
        $return = 0;
    }
    $auto_dial_limit = get_auto_dial_limit();
    if (strval($return) > $auto_dial_limit) {
        $return = $auto_dial_limit;
    }
    $sql = "UPDATE vicidial_campaigns set auto_dial_level='$return' where campaign_id='$campaign_id'";
    $res = mysqli_query($GLOBALS['link'], $sql);
    return $return;
}

function get_auto_dial_limit()
{
    $stmt = "SELECT auto_dial_limit from system_settings;";
    $rslt = mysqli_query($GLOBALS['link'], $stmt);
    $row  = mysqli_fetch_row($rslt);
    return $row[0];
}

function getLevels()
{
    $auto_dial_levels   = array();
    $auto_dial_levels[] = 1;
    $auto_dial_levels[] = 1.1;
    $auto_dial_levels[] = 1.2;
    $auto_dial_levels[] = 1.3;
    $auto_dial_levels[] = 1.4;
    $auto_dial_levels[] = 1.5;
    $auto_dial_levels[] = 1.6;
    $auto_dial_levels[] = 1.7;
    $auto_dial_levels[] = 1.8;
    $auto_dial_levels[] = 1.9;
    $auto_dial_levels[] = 2;
    $auto_dial_levels[] = 2.1;
    $auto_dial_levels[] = 2.2;
    $auto_dial_levels[] = 2.3;
    $auto_dial_levels[] = 2.4;
    $auto_dial_levels[] = 2.5;
    $auto_dial_levels[] = 2.6;
    $auto_dial_levels[] = 2.7;
    $auto_dial_levels[] = 2.8;
    $auto_dial_levels[] = 2.9;
    $auto_dial_levels[] = 3;
    $auto_dial_levels[] = 3.25;
    $auto_dial_levels[] = 3.5;
    $auto_dial_levels[] = 3.75;
    $auto_dial_levels[] = 4;
    $auto_dial_levels[] = 4.5;
    $auto_dial_levels[] = 5;
    $auto_dial_levels[] = 6;
    $auto_dial_levels[] = 7;
    $auto_dial_levels[] = 8;
    $auto_dial_levels[] = 9;
    $auto_dial_levels[] = 10;
    $auto_dial_levels[] = 12;
    $auto_dial_levels[] = 14;
    $auto_dial_levels[] = 16;
    $auto_dial_levels[] = 18;
    $auto_dial_levels[] = 20;
    $auto_dial_levels[] = 25;
    $auto_dial_levels[] = 30;
    $auto_dial_levels[] = 35;
    $auto_dial_levels[] = 40;
    $auto_dial_levels[] = 50;
    $auto_dial_levels[] = 60;
    $auto_dial_levels[] = 70;
    $auto_dial_levels[] = 80;
    $auto_dial_levels[] = 90;
    $auto_dial_levels[] = 100;
    $auto_dial_levels[] = 110;
    $auto_dial_levels[] = 120;
    $auto_dial_levels[] = 130;
    $auto_dial_levels[] = 140;
    $auto_dial_levels[] = 150;
    $auto_dial_levels[] = 160;
    $auto_dial_levels[] = 170;
    $auto_dial_levels[] = 180;
    $auto_dial_levels[] = 190;
    $auto_dial_levels[] = 200;
    $auto_dial_levels[] = 250;
    $auto_dial_levels[] = 300;
    $auto_dial_levels[] = 350;
    $auto_dial_levels[] = 400;
    $auto_dial_levels[] = 500;
    $auto_dial_levels[] = 600;
    $auto_dial_levels[] = 700;
    $auto_dial_levels[] = 800;
    $auto_dial_levels[] = 900;
    $auto_dial_levels[] = 1000;
    return $auto_dial_levels;
}


function top_ten_sales_agents($campaign_id)
{
    if ($campaign_id != "") {
        $campaign = " WHERE campaign_id='$campaign_id'";
    } else {       
        $campaign = " WHERE campaign_id IN(" . ALLOWED_CAMPAIGNS . ")";
    }

    if ($campaign_id != "") {
        $campaignsIN = " campaign_id='$campaign_id'";
    } else {       
        $campaignsIN = " campaign_id IN(" . ALLOWED_CAMPAIGNS . ")";
    }

    $query="SELECT count(lead_id) AS sales,user,(select full_name from vicidial_users where user=vicidial_agent_log.user) as full_name FROM vicidial_agent_log
  $campaign AND (STATUS IN(SELECT status FROM vicidial_statuses WHERE sale='Y') OR STATUS IN(SELECT status FROM vicidial_campaign_statuses WHERE sale='Y' AND $campaignsIN)) AND date(event_time)=date(now()) GROUP BY user order by sales desc limit 10;";
    $result = mysqli_query($GLOBALS['link'], $query);
    while (($array[] = mysqli_fetch_assoc($result)) || array_pop($array));
    $details="";
    for($i=0;$i<sizeof($array);$i++){
        $details.="<tr>";
            $details.="<td>".$array[$i]['user']."</td>";
            $details.="<td>".$array[$i]['full_name']."</td>";
            $details.="<td>".$array[$i]['sales']."</td>";
        $details.="</tr>";
    }
    return $details;
}

function campaigns_details($campaign_id){
    
    if ($campaign_id != "") {
        $campaign = " WHERE campaign_id='$campaign_id'";
    } else {       
        $campaign = " WHERE campaign_id IN(" . ALLOWED_CAMPAIGNS . ")";
    }

    $query="select campaign_id,(select campaign_name from vicidial_campaigns where campaign_id=vicidial_campaign_stats.campaign_id) as  campaign_name,(select active from vicidial_campaigns where campaign_id=vicidial_campaign_stats.campaign_id) as  active,update_time,dialable_leads,calls_today,answers_today,drops_today,(answers_today/calls_today)*100 connected_today from vicidial_campaign_stats $campaign order by calls_today desc";

    $result = mysqli_query($GLOBALS['link'], $query);
    while (($array[] = mysqli_fetch_assoc($result)) || array_pop($array));
    $details="";
    for($i=0;$i<sizeof($array);$i++)
    {
        $details.="<tr>";
            $details.="<td>".$array[$i]['campaign_id']."</td>";
            $details.="<td>".$array[$i]['campaign_name']."</td>";
            $details.="<td>".$array[$i]['dialable_leads']."</td>";
            $details.="<td>".$array[$i]['calls_today']."</td>";
            $details.="<td>".$array[$i]['answers_today']."</td>";
            $details.="<td>".$array[$i]['drops_today']."</td>";
            if(is_null($array[$i]['drops_today']))
            {
                $array[$i]['connected_today']=0;
            }
            $array[$i]['connected_today']=round($array[$i]['connected_today'])."%";
            $details.="<td>".$array[$i]['connected_today']."</td>";
        $details.="</tr>";
    }
    return $details;
}

function inbound_groups_details($campaign_id){
    
    $campaign=getInboundGroups($campaign_id);

    $query="select campaign_id,(select group_name from vicidial_inbound_groups where group_id=vicidial_campaign_stats.campaign_id) as  campaign_name,update_time,dialable_leads,calls_today,answers_today,drops_today,(answers_today/calls_today)*100 connected_today from vicidial_campaign_stats where campaign_id IN($campaign)  order by calls_today desc";


    $result = mysqli_query($GLOBALS['link'], $query);
    while (($array[] = mysqli_fetch_assoc($result)) || array_pop($array));
    $details="";
    for($i=0;$i<sizeof($array);$i++)
    {
        $details.="<tr>";
            $details.="<td>".$array[$i]['campaign_id']."</td>";
            $details.="<td>".$array[$i]['campaign_name']."</td>";
            // $details.="<td>".$array[$i]['dialable_leads']."</td>";
            $details.="<td>".$array[$i]['calls_today']."</td>";
            $details.="<td>".$array[$i]['answers_today']."</td>";
            $details.="<td>".$array[$i]['drops_today']."</td>";
            if(is_null($array[$i]['drops_today']))
            {
                $array[$i]['connected_today']=0;
            }
            $array[$i]['connected_today']=round($array[$i]['connected_today'])."%";
            $details.="<td>".$array[$i]['connected_today']."</td>";
        $details.="</tr>";
    }
    return $details;
}



function get_weekly_sales_outbound($campaign_id)
{
    if ($campaign_id != "") {
        $campaign = " WHERE campaign_id='$campaign_id'";
    } else {       
        $campaign = " WHERE campaign_id IN(" . ALLOWED_CAMPAIGNS . ")";
    }

    if ($campaign_id != "") {
        $campaignsIN = " campaign_id='$campaign_id'";
    } else {       
        $campaignsIN = " campaign_id IN(" . ALLOWED_CAMPAIGNS . ")";
    }

    //$query  = "select count(lead_id) qresult from vicidial_hopper $campaign";
    
//     $query ="select 
// DAYNAME(Date(t1.attempt_date)) as weekday,
// coalesce(SUM(t1.attempt_count+t2.attempt_count), 0) AS total_sales
// from
// (
//   select DATE_FORMAT(a.Date,'%Y/%m/%d') as attempt_date,
//   '0' as  attempt_count
//   from (
//     select curdate() - INTERVAL (a.a + (10 * b.a) + (100 * c.a)) DAY as Date
//     from (select 0 as a union all select 1 union all select 2 union all select 3 union all select 4 union all select 5 union all select 6 union all select 7 union all select 8 union all select 9) as a
//     cross join (select 0 as a union all select 1 union all select 2 union all select 3 union all select 4 union all select 5 union all select 6 union all select 7 union all select 8 union all select 9) as b
//     cross join (select 0 as a union all select 1 union all select 2 union all select 3 union all select 4 union all select 5 union all select 6 union all select 7 union all select 8 union all select 9) as c
//   ) a
//   where a.Date BETWEEN NOW() - INTERVAL 7 DAY AND NOW()
// )t1
// left join
// (
//   SELECT DATE_FORMAT(event_time,'%Y/%m/%d') AS attempt_date, 
//   COUNT(*) AS attempt_count
//   FROM vicidial_agent_log
//   $campaign and (comments='MANUAL' OR comments IS NULL) and (STATUS IN(SELECT status FROM vicidial_statuses WHERE sale='Y') OR STATUS IN(SELECT status FROM vicidial_campaign_statuses WHERE sale='Y' AND $campaignsIN)) and DATE_SUB(event_time, INTERVAL 1 DAY) > DATE_SUB(DATE(NOW()), INTERVAL 1 WEEK) 
//   GROUP BY DAY(event_time) DESC
// )t2
// on t2.attempt_date = t1.attempt_date
// group by DAY(t1.attempt_date)
// order by t1.attempt_date asc;";


//     $query="SELECT h.theHour as weekday
//      , COUNT(event_time) AS total_sales
//   FROM ( SELECT 0 AS theHour
//          UNION ALL SELECT 1
//          UNION ALL SELECT 2
//          UNION ALL SELECT 3
//          UNION ALL SELECT 4
//          UNION ALL SELECT 5
//          UNION ALL SELECT 6
//          UNION ALL SELECT 7
//          UNION ALL SELECT 8
//          UNION ALL SELECT 9
//          UNION ALL SELECT 10
//          UNION ALL SELECT 11
//          UNION ALL SELECT 12
//          UNION ALL SELECT 13
//          UNION ALL SELECT 14
//          UNION ALL SELECT 15
//          UNION ALL SELECT 16
//          UNION ALL SELECT 17
//          UNION ALL SELECT 18
//          UNION ALL SELECT 19
//          UNION ALL SELECT 20
//          UNION ALL SELECT 21
//          UNION ALL SELECT 22
//          UNION ALL SELECT 23 ) AS h
// LEFT OUTER
//   JOIN vicidial_agent_log
//     ON EXTRACT(HOUR FROM vicidial_agent_log.event_time) = h.theHour
//    AND DATE(vicidial_agent_log.event_time) = DATE(now()) AND (STATUS IN(SELECT status FROM vicidial_statuses WHERE sale='Y') OR STATUS IN(SELECT status FROM vicidial_campaign_statuses WHERE sale='Y' AND $campaignsIN)) AND (comments='MANUAL' OR comments IS NULL) AND $campaign
// GROUP
//     BY h.theHour";
        
        $query="SELECT DATE_FORMAT(event_time, '%h:%i %p') AS weekday
     , COUNT(event_time) AS total_sales FROM vicidial_agent_log
  $campaign and (comments='MANUAL' OR comments IS NULL) and (STATUS IN(SELECT status FROM vicidial_statuses WHERE sale='Y') OR STATUS IN(SELECT status FROM vicidial_campaign_statuses WHERE sale='Y' AND $campaignsIN)) AND date(event_time)=date(now()) GROUP by DATE_FORMAT(event_time, '%h:%i %p');";
    $row    = null;
    $result = mysqli_query($GLOBALS['link'], $query);
    while (($array[] = mysqli_fetch_assoc($result)) || array_pop($array));

    return $array;
}

function get_weekly_sales_inbound($campaign_id)
{
    if ($campaign_id != "") {
        $campaign = " WHERE campaign_id='$campaign_id'";
    } else {       
        $campaign = " WHERE campaign_id IN(" . ALLOWED_CAMPAIGNS . ")";
    }    

    if ($campaign_id != "") {
        $campaignsIN = " campaign_id='$campaign_id'";
    } else {       
        $campaignsIN = " campaign_id IN(" . ALLOWED_CAMPAIGNS . ")";
    }

     $query="SELECT DATE_FORMAT(event_time, '%h:%i %p') AS weekday
     , COUNT(event_time) AS total_sales FROM vicidial_agent_log
  $campaign and (comments='INBOUND') and (STATUS IN(SELECT status FROM vicidial_statuses WHERE sale='Y') OR STATUS IN(SELECT status FROM vicidial_campaign_statuses WHERE sale='Y' AND $campaignsIN)) AND date(event_time)=date(now()) GROUP by DATE_FORMAT(event_time, '%h:%i %p');";

//     $query ="select 
// DAYNAME(Date(t1.attempt_date)) as weekday,
// coalesce(SUM(t1.attempt_count+t2.attempt_count), 0) AS total_sales
// from
// (
//   select DATE_FORMAT(a.Date,'%Y/%m/%d') as attempt_date,
//   '0' as  attempt_count
//   from (
//     select curdate() - INTERVAL (a.a + (10 * b.a) + (100 * c.a)) DAY as Date
//     from (select 0 as a union all select 1 union all select 2 union all select 3 union all select 4 union all select 5 union all select 6 union all select 7 union all select 8 union all select 9) as a
//     cross join (select 0 as a union all select 1 union all select 2 union all select 3 union all select 4 union all select 5 union all select 6 union all select 7 union all select 8 union all select 9) as b
//     cross join (select 0 as a union all select 1 union all select 2 union all select 3 union all select 4 union all select 5 union all select 6 union all select 7 union all select 8 union all select 9) as c
//   ) a
//   where a.Date BETWEEN NOW() - INTERVAL 7 DAY AND NOW()
// )t1
// left join
// (
//   SELECT DATE_FORMAT(event_time,'%Y/%m/%d') AS attempt_date, 
//   COUNT(*) AS attempt_count
//   FROM vicidial_agent_log
//   $campaign and comments='INBOUND' and (STATUS IN(SELECT status FROM vicidial_statuses WHERE sale='Y') OR STATUS IN(SELECT status FROM vicidial_campaign_statuses WHERE sale='Y' AND $campaignsIN)) and DATE_SUB(event_time, INTERVAL 1 DAY) > DATE_SUB(DATE(NOW()), INTERVAL 1 WEEK) 
//   GROUP BY DAY(event_time) DESC
// )t2
// on t2.attempt_date = t1.attempt_date
// group by DAY(t1.attempt_date)
// order by t1.attempt_date asc;";



    
//     $query="SELECT h.theHour as weekday
//      , COUNT(event_time) AS total_sales
//   FROM ( SELECT 0 AS theHour
//          UNION ALL SELECT 1
//          UNION ALL SELECT 2
//          UNION ALL SELECT 3
//          UNION ALL SELECT 4
//          UNION ALL SELECT 5
//          UNION ALL SELECT 6
//          UNION ALL SELECT 7
//          UNION ALL SELECT 8
//          UNION ALL SELECT 9
//          UNION ALL SELECT 10
//          UNION ALL SELECT 11
//          UNION ALL SELECT 12
//          UNION ALL SELECT 13
//          UNION ALL SELECT 14
//          UNION ALL SELECT 15
//          UNION ALL SELECT 16
//          UNION ALL SELECT 17
//          UNION ALL SELECT 18
//          UNION ALL SELECT 19
//          UNION ALL SELECT 20
//          UNION ALL SELECT 21
//          UNION ALL SELECT 22
//          UNION ALL SELECT 23 ) AS h
// LEFT OUTER
//   JOIN vicidial_agent_log
//     ON EXTRACT(HOUR FROM vicidial_agent_log.event_time) = h.theHour
//    AND DATE(vicidial_agent_log.event_time) = DATE(now()) AND (STATUS IN(SELECT status FROM vicidial_statuses WHERE sale='Y') OR STATUS IN(SELECT status FROM vicidial_campaign_statuses WHERE sale='Y' AND $campaignsIN)) AND comments='INBOUND' AND $campaign
// GROUP
//     BY h.theHour";

    $row    = null;
    $result = mysqli_query($GLOBALS['link'], $query);
    while (($array[] = mysqli_fetch_assoc($result)) || array_pop($array));
    return $array;
}

function get_calls_status($campaign_id){

    if ($campaign_id != "") {
        $campaign = "WHERE campaign_id='$campaign_id'";
    } else {       
        $campaign = "WHERE campaign_id IN(" . ALLOWED_CAMPAIGNS . ")";
    }
    $query="SELECT status,IFNULL((select status_name from vicidial_statuses where status=vicidial_agent_log.status),status) as status_name,count(*) as total_calls FROM vicidial_agent_log $campaign and date(event_time)=date(now()) and status is not null group by status";
    $row    = null;
    $result = mysqli_query($GLOBALS['link'], $query);
    while (($array[] = mysqli_fetch_assoc($result)) || array_pop($array));
    $status=[];
    for($i=0;$i<sizeof($array);$i++){
        $status[]=array("status"=>$array[$i]['status'],"total_calls"=>$array[$i]['total_calls'],"status_name"=>$array[$i]['status_name']);
    }
    return $status;
}

function change_campaign_status($campaign_id,$active){
    $query="UPDATE vicidial_campaigns set active='$active' where campaign_id='$campaign_id'";
     $result = mysqli_query($GLOBALS['link'], $query);
     echo "Affected rows: " . mysqli_affected_rows($GLOBALS['link']);
}

function get_total_login($campaign_id){
    $query="SELECT count(*) total FROM vicidial_live_agents WHERE campaign_id='$campaign_id'";
    $array=null;
    $result=null;
    $result = mysqli_query($GLOBALS['link'], $query);    
    while (($array[] = mysqli_fetch_assoc($result)) || array_pop($array));
    return strval($array[0]['total']);    
}

function global_search(){
	//search all fields
	$searchphrase = trim($_POST['text']);
	if(strlen($searchphrase)<3){
		$array=array("status"=>false,"msg"=>"Search text length atlest 3 digits");
		exit(json_encode($array));
	}
	$table = "vicidial_list";
	$sql_search = "select * from ".$table." where ";
	$sql_search_fields = Array();
	$sql = "SHOW COLUMNS FROM ".$table;
	$rs = mysqli_query($GLOBALS['link'],$sql);
	    while($r = mysqli_fetch_array($rs)){
	        $colum = $r[0];
	        $sql_search_fields[] = $colum." like('%".$searchphrase."%')";
	    }
	$sql_search .= implode(" OR ", $sql_search_fields);
    $sql_search .= " Limit 50";
	$rs2 = mysqli_query($GLOBALS['link'],$sql_search);
	  $array=null;
    $html="<div class=\"table-box\"><table width=\"100%\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\">";
    $html.="<tbody>";
		$html.="<tr>";
			$html.="<th>Lead ID</th>";
		$html.="<th>List ID</th>";
		$html.="<th>Entery Date</th>";
		$html.="<th>Modify Date</th>";
	
		$html.="<th>Status</th>";
		$html.="<th>First Name</th>";
		$html.="<th>Last Name</th>";
		$html.="<th>Phone Number</th>";
		$html.="<th>Email</th>";
		
		$html.="<tr>";
	


	while (($array[] = mysqli_fetch_assoc($rs2)) || array_pop($array));
	$out = mysqli_num_rows($rs2)."\n";
		


	for($i=0;$i<sizeof($array);$i++)
	{
		$html.="<tr>";
		$html.="<td><a target=\"_blank\" href=\"admin_modify_lead.php?lead_id=".$array[$i]['lead_id']."&archive_search=No&archive_log=0\">".$array[$i]['lead_id']."</a></td>";
		$html.="<td>".$array[$i]['list_id']."</td>";
		$html.="<td>".$array[$i]['entry_date']."</td>";
		$html.="<td>".$array[$i]['modify_date']."</td>";
		
		
		$html.="<td>".$array[$i]['status']."</td>";
		$html.="<td>".$array[$i]['first_name']."</td>";
		$html.="<td>".$array[$i]['last_name']."</td>";
		$html.="<td>".$array[$i]['phone_number']."</td>";
		$html.="<td>".$array[$i]['email']."</td>";
		
		$html.="<tr>";
	}
	$html.="</tbody></table></div>";
	$array=array("status"=>true,"table"=>$html,"records"=>$out);
	exit(json_encode($array));
}


function get_connected_asr($campaign_id,$caller_id){
    $query='Select count(*) connected  from vicidial_carrier_log a,vicidial_dial_log b where a.caller_code=b.caller_code and a.dialstatus="ANSWER" and  date(a.call_date)=date(now()) and (select campaign_id from vicidial_log where uniqueid=a.uniqueid)="'.$campaign_id.'" and REPLACE(REPLACE(SUBSTRING_INDEX(b.outbound_cid," ",-1),"<",""),">","")="'.$caller_id.'";';

    $result = mysqli_query($GLOBALS['link'], $query);    
    while (($array[] = mysqli_fetch_assoc($result)) || array_pop($array));
    $connected=0;
    if(sizeof($array)>0){
        $connected=$array[0]['connected'];
    }
    return $connected;
}

function get_cli_asr($CampaignSql)
{
    $CampaignSql=str_replace("'", "", $CampaignSql);    
    $Campaigns=explode(",", $CampaignSql);
    $query='Select count(*) total_calls,(select campaign_id from vicidial_log where uniqueid=a.uniqueid) as campaign_id,REPLACE(REPLACE(SUBSTRING_INDEX(b.outbound_cid," ",-1),"<",""),">","") as caller_id from vicidial_carrier_log a,vicidial_dial_log b where a.caller_code=b.caller_code and date(a.call_date)=date(now()) group by campaign_id,caller_id order by total_calls desc;';
    $result = mysqli_query($GLOBALS['link'], $query);    
    while (($array[] = mysqli_fetch_assoc($result)) || array_pop($array));
    $asr="<tr>
      <th scope=\"col\">Campaign ID</th>  
      <th scope=\"col\">Caller ID</th>
      <th scope=\"col\">Attempts</th>
      <th scope=\"col\">Connected</th>
      <th scope=\"col\">ASR</th>
    </tr>";
    for($i=0;$i<sizeof($array);$i++){

     // $campaign_id_check=$array[$i]['campaign_id'];
     //     echo $campaign_id_check;
     //     exit();

     if (in_array(strtolower($array[$i]['campaign_id']),array_map("strtolower", $Campaigns))){
            $connected=get_connected_asr($array[$i]['campaign_id'],$array[$i]['caller_id']);
            $asr.="<tr>";
                $asr.="<td>".$array[$i]['campaign_id']."</td>";
                $asr.="<td>".$array[$i]['caller_id']."</td>";
                $asr.="<td>".$array[$i]['total_calls']."</td>";
                $asr.="<td>".$connected."</td>";
                $connected_asr=(strval($connected)/strval($array[$i]['total_calls']))*100;            
            	$connected_asr=round($connected_asr,2);
		    $asr.="<td>".$connected_asr."%</td>";
            $asr.="</tr>";           
        }
    }
    echo $asr;
}

function get_carrier_stats($CampaignSql){
	$html="";

 			$html.="<div class=\"latst_carrier_stats\"><h1>"._QXZ("Last 30 mins carrier log details.")."</h1><span><a href=\"javascript:void(0);\" onclick=\"close_carrier_stats();\"><i class=\"fa fa-close\"></i></a></span></div><div class=\"call-response\"><table width=\"100%\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\">";
 			$html.="<tbody><tr>";	        
	        $html.="<tr>";
	        $html.="<th>CAMPAIGN</th>";
	        $html.="<th>REASON</th>";
	        $html.="<th>CALLS</th>";	        
	        $html.="</tr>";
    $found=false;
	$stmt  = "select a.sip_hangup_cause,b.campaign_id,a.hangup_cause,count( * ) as total_calls from vicidial_carrier_log a,vicidial_log b where a.uniqueid=b.uniqueid and a.call_date>=date_sub(now(), interval 6000000 minute) and campaign_id IN($CampaignSql) group by a.sip_hangup_cause,b.campaign_id,a.hangup_cause order by total_calls desc;";

	
	    $rslt  = mysql_to_mysqli($stmt, $GLOBALS['link']);
	    while ($row = mysqli_fetch_row($rslt)) 
	    {	$found=true;
	        $sip_hangup_cause=$row[0];
	        $campaign_id=$row[1];
	        $hangup_cause=$row[2];
	        $total_calls=$row[3];
	        $sip_hangup_text=sip_hangup_cause_description_dialer($sip_hangup_cause);
	        $hangup_cause_text=hangup_cause_description_dialer($hangup_cause);
	            $html.="<tr>";
	       		if(trim($sip_hangup_text)!=""){
	     			$response_text=$sip_hangup_text;
	     		}else if(trim($hangup_cause_text)!=""){
	     			$response_text=$hangup_cause_text;
	     		}
	     		$html.="<td>$campaign_id</td>";
	      		$html.="<td>$response_text</td>";	      
	      		$html.="<td>$total_calls</td>";
	      		$html.="</tr>";
	    }
	    if($found==false){
	    	$html.="<tr>";
	    		$html.="<td style=\"text-align:center;\" colspan=\"2\">"._QXZ("Records Not Found.")."</td>";
	    	$html.="</tr>";
	    }
	    $html.=" </tbody></table></div>";	   
	    echo $html;
	    exit();
}

##### Hangup Cause Description Map  #####
function hangup_cause_description_dialer($code)
{
    global $hangup_cause_dictionary;
    if (array_key_exists($code, $hangup_cause_dictionary)) {
        return $hangup_cause_dictionary[$code];
    } else {
        return "";
    }
}

##### SIP Hangup Cause Description Map  #####
function sip_hangup_cause_description_dialer($sip_code)
{
    global $sip_hangup_cause_dictionary;
    if (array_key_exists($sip_code, $sip_hangup_cause_dictionary)) {
        return $sip_hangup_cause_dictionary[$sip_code];
    } else {
        return "";
    }
}

function MathZDC_FUN($dividend, $divisor, $quotient = 0)
{
    if ($divisor == 0) {
        return $quotient;
    } else if ($dividend == 0) {
        return 0;
    } else {
        return ($dividend / $divisor);
    }
}

function get_carriers_stats($campaigns){        
                $NOW_TIME = date("Y-m-d H:i:s");
                $NOW_DAY = date("Y-m-d");
                $NOW_HOUR = date("H:i:s");
                $STARTtime = date("U");
                $epochONEminuteAGO = ($STARTtime - 60);
                $timeONEminuteAGO = date("Y-m-d H:i:s",$epochONEminuteAGO);
                $epochFIVEminutesAGO = ($STARTtime - 300);
                $timeFIVEminutesAGO = date("Y-m-d H:i:s",$epochFIVEminutesAGO);
                $epochFIFTEENminutesAGO = ($STARTtime - 900);
                $timeFIFTEENminutesAGO = date("Y-m-d H:i:s",$epochFIFTEENminutesAGO);
                $epochONEhourAGO = ($STARTtime - 3600);
                $timeONEhourAGO = date("Y-m-d H:i:s",$epochONEhourAGO);
                $epochSIXhoursAGO = ($STARTtime - 21600);
                $timeSIXhoursAGO = date("Y-m-d H:i:s",$epochSIXhoursAGO);
                $epochTWENTYFOURhoursAGO = ($STARTtime - 86400);
                $timeTWENTYFOURhoursAGO = date("Y-m-d H:i:s",$epochTWENTYFOURhoursAGO);
                $DB="";
                $CARRIERstatsHTML='';
                $ONEhour_total="";
                $dialstatuses="";
                $FIVEminute_total="";
                $FTminute_total="";
                $ONEminute_total="";
                $TFhour_total="";
                $SIXhour_total="";
                $SIXhour_count="";


                $CASED="CASE WHEN status LIKE 'AA' THEN 'A'            
            WHEN status LIKE 'AB' THEN 'B'            
            WHEN status LIKE 'ADC' THEN 'DC'          
            WHEN status LIKE 'NA' THEN 'N'
            WHEN status LIKE 'NA' THEN 'N'              
            ELSE status END";

                //$stmtB="SELECT a.dialstatus,count(*) from vicidial_carrier_log a,vicidial_log b where a.uniqueid=b.uniqueid and campaign_id IN($campaigns) and  a.call_date >= \"$timeTWENTYFOURhoursAGO\" group by a.dialstatus;";

                //$stmtB="SELECT status,count(*) from vicidial_log WHERE campaign_id IN($campaigns) and  call_date >= \"$timeTWENTYFOURhoursAGO\" group by status;";


//                 $stmtB="SELECT status,COUNT(*) FROM(SELECT status=CASE search_status WHEN 'A' THEN 'A' WHEN 'AA' THEN 'A' ELSE search_status END FROM vicidial_log) campaign_id IN($campaigns) and  call_date >= \"$timeTWENTYFOURhoursAGO\"GROUP BY status";


            $stmtB="SELECT ($CASED) as status, COUNT(*) as total_count
FROM vicidial_log WHERE campaign_id IN($campaigns) and  call_date >= \"$timeTWENTYFOURhoursAGO\"
GROUP by ($CASED) ORDER by total_count DESC;";
             
            



                if ($DB > 0) {echo "\n|$stmtB|\n";}
                $rslt=mysqli_query($GLOBALS['link'],$stmtB);
                $car_to_print = mysqli_num_rows($rslt);
                $ctp=0;
                while ($car_to_print > $ctp)
                    {
                    $row=mysqli_fetch_row($rslt);
                    $TFhour_status[$ctp] =  $row[0];
                    $TFhour_count[$ctp] =   $row[1];
                    $TFhour_total+=$row[1];
                    $dialstatuses .=        "'$row[0]',";
                    $ctp++;
                    }



                $dialstatuses = preg_replace("/,$/",'',$dialstatuses);
                $CARRIERstatsHTML .= "<TABLE class=\"table table-bordered table-striped table-condensed flip-content\">";
                $CARRIERstatsHTML .= "<theader class=\"flip-content\"><TR>";
                //$CARRIERstatsHTML .= "<TD ALIGN=LEFT>CARRIER STATS: &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; </font></TD>";
                $CARRIERstatsHTML .= "<TH>HANGUP STATUS &nbsp; </font></TD>";
                $CARRIERstatsHTML .= "<TH>24 HOURS</TH>";
                $CARRIERstatsHTML .= "<TH>6 HOURS</TH>";
                $CARRIERstatsHTML .= "<TH>1 HOUR</TH>";
                $CARRIERstatsHTML .= "<TH>15 MIN</TH>";
                $CARRIERstatsHTML .= "<TH>5 MIN</TH>";
                $CARRIERstatsHTML .= "<TH>1 MIN</TH>";
                $CARRIERstatsHTML .= "</TR></theader><tbody>";

        if (strlen($dialstatuses) > 1)
            {
         
                             
                           //$stmtB="SELECT a.dialstatus,count(*) from vicidial_carrier_log a,vicidial_log b where a.uniqueid=b.uniqueid and campaign_id IN($campaigns) and  a.call_date >= \"$timeSIXhoursAGO\" group by a.dialstatus;";

                           //$stmtB="SELECT status,count(*) from vicidial_log WHERE campaign_id IN($campaigns) and  call_date >= \"$timeSIXhoursAGO\" group by status;";


                $stmtB="SELECT ($CASED) as status, COUNT(*) as total_count
FROM vicidial_log WHERE campaign_id IN($campaigns) and  call_date >= \"$timeSIXhoursAGO\"
GROUP by ($CASED)  ORDER by total_count DESC;";
                       
                        
                        if ($DB > 0) {echo "\n|$stmtB|\n";}
            $rslt=mysqli_query($GLOBALS['link'],$stmtB);
            $scar_to_print = mysqli_num_rows($rslt);
            $print_sctp=0;
            while ($scar_to_print > $print_sctp)
                {
                $row=mysqli_fetch_row($rslt);
                $SIXhour_total+=$row[1];
                $print_ctp=0;
                while ($print_ctp < $ctp)
                    {
                    if ($TFhour_status[$print_ctp] == $row[0])
                        {$SIXhour_count[$print_ctp] = $row[1];}
                    $print_ctp++;
                    }
                $print_sctp++;
                }

            
       
                         //$stmtB="SELECT a.dialstatus,count(*) from vicidial_carrier_log a,vicidial_log b where a.uniqueid=b.uniqueid and campaign_id IN($campaigns) and  a.call_date >= \"$timeONEhourAGO\" group by a.dialstatus;";

                //$stmtB="SELECT status,count(*) from vicidial_log WHERE campaign_id IN($campaigns) and  call_date >= \"$timeONEhourAGO\" group by status;";


                  $stmtB="SELECT ($CASED) as status, COUNT(*) as total_count
FROM vicidial_log WHERE campaign_id IN($campaigns) and  call_date >= \"$timeONEhourAGO\"
GROUP by ($CASED)  ORDER by total_count DESC;";
                       
                        if ($DB > 0) {echo "\n|$stmtB|\n";}
            $rslt=mysqli_query($GLOBALS['link'],$stmtB);
            $scar_to_print = mysqli_num_rows($rslt);
            $print_sctp=0;
            while ($scar_to_print > $print_sctp)
                {
                $row=mysqli_fetch_row($rslt);
                $ONEhour_total+=$row[1];
                $print_ctp=0;
                while ($print_ctp < $ctp)
                    {
                    if ($TFhour_status[$print_ctp] == $row[0])
                        {$ONEhour_count[$print_ctp] = $row[1];}
                    $print_ctp++;
                    }
                $print_sctp++;
                }

           
       
                           //$stmtB="SELECT a.dialstatus,count(*) from vicidial_carrier_log a,vicidial_log b where a.uniqueid=b.uniqueid and campaign_id IN($campaigns) and  a.call_date >= \"$timeFIFTEENminutesAGO\" group by a.dialstatus;";

                             //$stmtB="SELECT status,count(*) from vicidial_log WHERE campaign_id IN($campaigns) and  call_date >= \"$timeFIFTEENminutesAGO\" group by status;";


               $stmtB="SELECT ($CASED) as status, COUNT(*) as total_count
FROM vicidial_log WHERE campaign_id IN($campaigns) and  call_date >= \"$timeFIFTEENminutesAGO\"
GROUP by ($CASED)  ORDER by total_count DESC;";
                       
                       
                        if ($DB > 0) {echo "\n|$stmtB|\n";}
            $rslt=mysqli_query($GLOBALS['link'],$stmtB);
            $scar_to_print = mysqli_num_rows($rslt);
            $print_sctp=0;
            while ($scar_to_print > $print_sctp)
                {
                $row=mysqli_fetch_row($rslt);
                $FTminute_total+=$row[1];
                $print_ctp=0;
                while ($print_ctp < $ctp)
                    {
                    if ($TFhour_status[$print_ctp] == $row[0])
                        {$FTminute_count[$print_ctp] = $row[1];}
                        $print_ctp++;
                    }
                $print_sctp++;
                }

    
                           //$stmtB="SELECT a.dialstatus,count(*) from vicidial_carrier_log a,vicidial_log b where a.uniqueid=b.uniqueid and campaign_id IN($campaigns) and  a.call_date >= \"$timeFIVEminutesAGO\" group by a.dialstatus;";

                           //$stmtB="SELECT status,count(*) from vicidial_log WHERE campaign_id IN($campaigns) and  call_date >= \"$timeFIVEminutesAGO\" group by status;";

$stmtB="SELECT ($CASED) as status, COUNT(*) as total_count
FROM vicidial_log WHERE campaign_id IN($campaigns) and  call_date >= \"$timeFIVEminutesAGO\"
GROUP by ($CASED)  ORDER by total_count DESC;";
                       
                       
                        if ($DB > 0) {echo "\n|$stmtB|\n";}
            $rslt=mysqli_query($GLOBALS['link'],$stmtB);
            $scar_to_print = mysqli_num_rows($rslt);
            $print_sctp=0;
            while ($scar_to_print > $print_sctp)
                {
                $row=mysqli_fetch_row($rslt);
                $FIVEminute_total+=$row[1];
                $print_ctp=0;
                while ($print_ctp < $ctp)
                    {
                    if ($TFhour_status[$print_ctp] == $row[0])
                        {$FIVEminute_count[$print_ctp] = $row[1];}
                    $print_ctp++;
                    }
                $print_sctp++;
                }
      
                           // $stmtB="SELECT a.dialstatus,count(*) from vicidial_carrier_log a,vicidial_log b where a.uniqueid=b.uniqueid and campaign_id IN($campaigns) and  a.call_date >= \"$timeONEminuteAGO\" group by a.dialstatus;";
                            
                            //$stmtB="SELECT status,count(*) from vicidial_log WHERE campaign_id IN($campaigns) and  call_date >= \"$timeONEminuteAGO\" group by status;";


                $stmtB="SELECT ($CASED) as status, COUNT(*) as total_count
FROM vicidial_log WHERE campaign_id IN($campaigns) and  call_date >= \"$timeONEminuteAGO\"
GROUP by ($CASED)  ORDER by total_count DESC;";

                       
                        if ($DB > 0) {echo "\n|$stmtB|\n";}
            $rslt=mysqli_query($GLOBALS['link'],$stmtB);
            $scar_to_print = mysqli_num_rows($rslt);
            $print_sctp=0;
            while ($scar_to_print > $print_sctp)
                {
                $row=mysqli_fetch_row($rslt);
                $ONEminute_total+=$row[1];
                $print_ctp=0;
                while ($print_ctp < $ctp)
                    {
                    if ($TFhour_status[$print_ctp] == $row[0])
                        {$ONEminute_count[$print_ctp] = $row[1];}
                    $print_ctp++;
                    }
                $print_sctp++;
                }


            $print_ctp=0;
            while ($print_ctp < $ctp)
                {
                if (strlen($TFhour_count[$print_ctp])<1) {$TFhour_count[$print_ctp]=0;}
                if (strlen($SIXhour_count[$print_ctp])<1) {$SIXhour_count[$print_ctp]=0;}
                if (strlen($ONEhour_count[$print_ctp])<1) {$ONEhour_count[$print_ctp]=0;}
                if (strlen($FTminute_count[$print_ctp])<1) {$FTminute_count[$print_ctp]=0;}
                if (strlen($FIVEminute_count[$print_ctp])<1) {$FIVEminute_count[$print_ctp]=0;}
                if (strlen($ONEminute_count[$print_ctp])<1) {$ONEminute_count[$print_ctp]=0;}
                
                $TFhour_pct = (100*MathZDC_FUN($TFhour_count[$print_ctp], $TFhour_total));
                $SIXhour_pct = (100*MathZDC_FUN($SIXhour_count[$print_ctp], $SIXhour_total));
                $ONEhour_pct = (100*MathZDC_FUN($ONEhour_count[$print_ctp], $ONEhour_total));
                $TFminute_pct = (100*MathZDC_FUN($FTminute_count[$print_ctp], $FTminute_total));
                $FIVEminute_pct = (100*MathZDC_FUN($FIVEminute_count[$print_ctp], $FIVEminute_total));
                $ONEminute_pct = (100*MathZDC_FUN($ONEminute_count[$print_ctp], $ONEminute_total));

                $CARRIERstatsHTML .= "<TR>";
                //$CARRIERstatsHTML .= "<TD BGCOLOR=white><font class='top_settings_val'>&nbsp;</TD>";

                $vicidial_statuses=GetStatus($TFhour_status[$print_ctp]);
                $status_name=$vicidial_statuses['status_name'];
                $status=$vicidial_statuses['status'];

                $CARRIERstatsHTML .= "<TD><font class='top_settings_val'>&nbsp; &nbsp; $status_name </TD>";
                $CARRIERstatsHTML .= "<TD><font class='top_settings_val'> $TFhour_count[$print_ctp] </font>&nbsp;<font size=1 color='#990000'>".sprintf("%01.1f", $TFhour_pct)."%</font></TD>";
                $CARRIERstatsHTML .= "<TD><font class='top_settings_val'> $SIXhour_count[$print_ctp] </font>&nbsp;<font size=1 color='#990000'>".sprintf("%01.1f", $SIXhour_pct)."%</font></TD>";
                $CARRIERstatsHTML .= "<TD><font class='top_settings_val'> $ONEhour_count[$print_ctp] </font>&nbsp;<font size=1 color='#990000'>".sprintf("%01.1f", $ONEhour_pct)."%</font></TD>";
                $CARRIERstatsHTML .= "<TD><font class='top_settings_val'> $FTminute_count[$print_ctp] </font>&nbsp;<font size=1 color='#990000'>".sprintf("%01.1f", $TFminute_pct)."%</font></TD>";
                $CARRIERstatsHTML .= "<TD><font class='top_settings_val'> $FIVEminute_count[$print_ctp] </font>&nbsp;<font size=1 color='#990000'>".sprintf("%01.1f", $FIVEminute_pct)."%</font></TD>";
                $CARRIERstatsHTML .= "<TD><font class='top_settings_val'> $ONEminute_count[$print_ctp] </font>&nbsp;<font size=1 color='#990000'>".sprintf("%01.1f", $ONEminute_pct)."%</font></TD>";
                $CARRIERstatsHTML .= "</TR>";
                $print_ctp++;
                }
            $CARRIERstatsHTML .= "<TR>";
            //$CARRIERstatsHTML .= "<TD BGCOLOR=white><font class='top_settings_val'>&nbsp;</TD>";
            $CARRIERstatsHTML .= "<TH>&nbsp; &nbsp;TOTALS</font></TD>";
            $CARRIERstatsHTML .= "<TH>".($TFhour_total+0)."</TH>";
            $CARRIERstatsHTML .= "<TH>".($SIXhour_total+0)."</TH>";
            $CARRIERstatsHTML .= "<TH>".($ONEhour_total+0)."</TH>";
            $CARRIERstatsHTML .= "<TH>".($FTminute_total+0)."</TH>";
            $CARRIERstatsHTML .= "<TH>".($FIVEminute_total+0)."</TH>";
            $CARRIERstatsHTML .= "<TH>".($ONEminute_total+0)."</TH>";
            $CARRIERstatsHTML .= "</TR>";

            }
        else
            {
            $CARRIERstatsHTML .= "<TR><TD BGCOLOR=white colspan=7 align=Center>******* NO RECORD FOUND*******</TD></TR>";
            }
        $CARRIERstatsHTML .= "</tbody></TABLE>";
        
        
    echo $CARRIERstatsHTML;
    }

    function GetStatus($status){
        $stmt="SELECT status,status_name,human_answered FROM vicidial_statuses WHERE status='$status' LIMIT 1;";
        $rslt=mysqli_query($GLOBALS['link'],$stmt);
        $row = mysqli_fetch_array($rslt);
        if(sizeof($row)>0)
        {
            $array=array("status"=>$row['status'] ,"status_name"=> $status ." - " . $row['status_name'],"human_answered"=>$row['human_answered']);
        }else{
            $array=array("status"=>$status,"status_name"=>$status,"human_answered"=>"N");
        }
        return $array;
    }