<?php
defined('BASEPATH') OR exit('No direct script access allowed');
?>
<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?=  DOMAIN_COMPANY_NAME; ?> | Login</title>
    <link href="<?php echo base_url(); ?>assets/css/bootstrap.min.css" rel="stylesheet">
    <link href="<?php echo base_url(); ?>assets/font-awesome/css/font-awesome.css" rel="stylesheet">
    <!-- Ladda style -->
    <link href="<?php echo base_url(); ?>assets/css/plugins/ladda/ladda-themeless.min.css" rel="stylesheet">
    <link href="<?php echo base_url(); ?>assets/css/animate.css" rel="stylesheet">
    <link href="<?php echo base_url(); ?>assets/css/style.php" rel="stylesheet">

    <link rel="shortcut icon" href="<?= DOMAIN_FAVICON; ?>" /> </head>
</head>

<!-- class="gray-bg" style="background-image: url(assets/img/background.jpg);background-size: cover;background-repeat: no-repeat;" -->

<body>

    
    <div class="login-wrapper">
        <div class="login-wrp-middle animated fadeInDown">            
            <div class="middle-box text-center loginscreen">
            	<!-- <div class="left-area fadeInRight animated"><a href="../agent">Agent</a></div> -->
            	<div class="login-containers">
            <div>

                <img class="logo-name" src="<?= DOMAIN_LOGO; ?>" />

            </div>
            <h3>Welcome to <?=  str_replace("Call", "", DOMAIN_COMPANY_NAME); ?> Dialer</h3>            
            <form class="m-t" id="login-form" role="form" action="<?php echo base_url('login/auth'); ?>" method="post">
                <input type="hidden" id="csrf_token" name="<?= $csrf['name']; ?>" value="<?= $csrf['hash']; ?>" />

               
                    <div class="form-group" id="error_box" style="display: none;">
                        <div class="alert alert-danger alert-danger-wrp">
                            <button class="close" data-close="alert"></button>
                            <span id="error_msg"></span>
                        </div>
                    </div>
                
                <div class="form-group">
                    <input type="text" class="form-control" placeholder="Username" id="username" name="username" required="">
                </div>
                <div class="form-group">
                    <input type="password" class="form-control" placeholder="Password" id="password" name="password" required="">
                </div>
                <!-- <button type="submit" class="btn btn-primary block full-width m-b">Login</button> -->

                <!-- <button type="submit" id="login-button" class="ladda-button ladda-button-demo btn btn-primary block full-width m-b" data-style="expand-left"><span class="ladda-label">Login</span><span class="ladda-spinner"></span></button> -->

                <button type="submit" class="ladda-button ladda-button-demo btn btn-primary block full-width m-b" data-style="zoom-in">Login</button>
                
                
            </form>
            <p class="m-t"> <small>© <?= date('Y'); ?> <?= DOMAIN_COMPANY_NAME; ?>. All rights reserved.</small> </p>
            </div>
        </div>
    </div>
    </div>

    <form action="agent/index.php" method="post" id="frmAgent" style="display: none;">
        <input type="text" name="VD_login" value="" id="VDUser" />
        <input type="text" name="VD_pass" value="" id="VDPass" />
        <input type="text" name="VD_campaign" value="" id="VDCampaign" />
    </form>

    <!-- Mainly scripts -->
    <script src="<?php echo base_url(); ?>assets/js/jquery-3.1.1.min.js"></script>
    <script src="<?php echo base_url(); ?>assets/js/popper.min.js"></script>
    <script src="<?php echo base_url(); ?>assets/js/bootstrap.js"></script>

    <!-- Ladda -->
    <script src="<?php echo base_url(); ?>assets/js/plugins/ladda/spin.min.js"></script>
    <script src="<?php echo base_url(); ?>assets/js/plugins/ladda/ladda.min.js"></script>
    <script src="<?php echo base_url(); ?>assets/js/plugins/ladda/ladda.jquery.min.js"></script>

    <script type="text/javascript">
        $(document).ready(function (){

           

$('#login-form').keypress(function (e) {
  if (e.which == 13) {
    $('.ladda-button-demo').click();
    return false;    //<---- Add this line
  }
});


        var l = $( '.ladda-button-demo' ).ladda();
        l.click(function(e){
            e.preventDefault();
            var Formdata = $("#login-form").serialize();
            var Formaction = $("#login-form").attr('action');
            l.ladda('start');
            $("#error_msg").html('');
            $("#error_box").hide();
            $.ajax({
                url: Formaction,
                type: 'POST',
                data: Formdata,
                error: function (x, status, error) {
                    l.ladda('stop');
                },
                success: function (data) {
                    data = JSON.parse(data);
                    $("#csrf_token").val(data.csrf.hash);
                    if(data.status==true && data.isagent==false){
                        window.location="<?php echo base_url('dashboard'); ?>";
                    }else if(data.status==true && data.isagent==true){
                        var VDUser=$("#username").val();
                        var VDPass=$("#password").val();
                        $("#VDUser").val(VDUser);
                        $("#VDPass").val(VDPass);
                        $("#frmAgent").submit();                     
                    }else{
                        $("#error_msg").html(data.msg);
                        $("#error_box").show();
                        l.ladda('stop');
                    }
                }
            });

        });
    });
    </script>
</body>

</html>
