<?php 
$this->load->view('layouts/header'); 
?>  


<div class="row wrapper border-bottom white-bg page-heading">
    <div class="col-lg-6">
        <h2><?= $this->Model_lib->_QXZ("Datasets"); ?></h2>
        <ol class="breadcrumb">
            <li class="breadcrumb-item">
                <a href="<?= base_url('dashboard'); ?>"><?= $this->Model_lib->_QXZ("Home"); ?></a>
            </li>
            <li class="breadcrumb-item">
                <a href="<?= base_url('data'); ?>"><?= $this->Model_lib->_QXZ("Data"); ?></a>
            </li>
            <li class="breadcrumb-item active">
                <strong id="_page_header"><?= $this->Model_lib->_QXZ("View Data") ?> :<?= $data['list_id']; ?></strong>
            </li>
        </ol>
    </div>
    <div class="col-lg-6">

       <div class="title-action">



                    <a  class="btn btn-white" href="<?= base_url('data/add'); ?>" title="<?= $this->Model_lib->_QXZ("Add New"); ?>">
                        <i class="fa fa-plus"></i>
                        <span><?= $this->Model_lib->_QXZ("Add New"); ?></span>                        
                    </a>
               
            
                    <?php  $encrypted_list_id = $this->uri->segment(3); ?>
                    <a class="btn btn-white" href="<?= base_url("data/download_list/".$encrypted_list_id); ?>" title="<?= $this->Model_lib->_QXZ("Download Leads"); ?>" class="nav-link ">        
                        <i class=" fa fa-cloud-download"></i>                    
                        <span class="title"><?= $this->Model_lib->_QXZ("Download Leads"); ?></span>
                    </a>
               

        </div>

    </div>
</div>
<div class="page-container">
<div class="page-content-wrapper">
<div class="page-content">



<div class="row">
<div class="col-md-12">
<!-- BEGIN EXAMPLE TABLE PORTLET-->
<div class="portlet light bordered">

<div class="portlet-body">
<table class="table table-striped table-bordered table-hover" id="leads_table">
<thead>
    <tr>
     
        <th><?= $this->Model_lib->_QXZ("Lead ID"); ?></th>
        <th><?= $this->Model_lib->_QXZ("Created Date"); ?></th>
        <th><?= $this->Model_lib->_QXZ("Changed Date"); ?></th>
        <th><?= $this->Model_lib->_QXZ("First Name"); ?></th>
        <th><?= $this->Model_lib->_QXZ("Last Name"); ?></th>
        <th><?= $this->Model_lib->_QXZ("Email"); ?></th>
        <th><?= $this->Model_lib->_QXZ("Phone Number"); ?></th>
        <th><?= $this->Model_lib->_QXZ("Status"); ?></th>
    </tr>
</thead>
</table>
</div>
</div>
<!-- END EXAMPLE TABLE PORTLET-->
</div>
</div>


</div>
</div>
</div>
<?php $this->load->view('layouts/footer'); ?>     
<script type="text/javascript">
GetLeads();
function GetLeads(){
 var url = "<?php echo base_url('lists/get_leads'); ?>";

    $('#leads_table').DataTable({
            'processing': true,
            'serverSide': true,
            'serverMethod': 'get',
            'retrieve': true,
            'destroy': true,
            'searching':true,
            'aaSorting': [],
            'ajax': {
                'url': url,
                'data': function(data){
                        // Read values
                        var list_id = "<?php echo $data['list_id']; ?>";
                        // Append to data
                        data.list_id = list_id;
                    }
                
            },
            'columns': [             
                { data: 'lead_id' },
                { data: 'entry_date' },
                { data: 'modify_date' },
                { data: 'first_name' },
                { data: 'last_name' },
                { data: 'email' },
                { data: 'phone_number' },
                { data: 'status' }
]
    });
}





</script>