<?php
defined('BASEPATH') OR exit('No direct script access allowed');
class Model_lib extends CI_Model {
    var $skey   = "bishmillahallahhuakbar";
    var $link   = null;
    var $custom = null;
    var $mysql_reserved_words="";
    var $vicidial_list_field="";
    function __construct()
    {       
        $this->custom = $this->load->database('custom', TRUE);

        $this->vicidial_list_fields = '|lead_id|vendor_lead_code|source_id|list_id|gmt_offset_now|called_since_last_reset|phone_code|phone_number|title|first_name|middle_initial|last_name|address1|address2|address3|city|state|province|postal_code|country_code|gender|date_of_birth|alt_phone|email|security_phrase|comments|called_count|last_local_call_time|rank|owner|status|entry_date|entry_list_id|modify_date|user|';

        $this->mysql_reserved_words = '|accessible|action|add|after|against|aggregate|algorithm|all|alter|analyse|analyze|and|any|as|asc|ascii|asensitive|at|authors|auto_increment|autoextend_size|avg|avg_row_length|backup|before|begin|between|bigint|binary|binlog|bit|blob|block|bool|boolean|both|btree|by|byte|cache|call|cascade|cascaded|case|catalog_name|chain|change|changed|char|character|charset|check|checksum|cipher|class_origin|client|close|coalesce|code|collate|collation|column|column_format|column_name|columns|comment|commit|committed|compact|completion|compressed|concurrent|condition|connection|consistent|constraint|constraint_catalog|constraint_name|constraint_schema|contains|context|continue|contributors|convert|cpu|create|cross|cube|current|current_date|current_time|current_timestamp|current_user|cursor|cursor_name|data|database|databases|datafile|date|datetime|day|day_hour|day_microsecond|day_minute|day_second|deallocate|dec|decimal|declare|default|default_auth|definer|delay_key_write|delayed|delete|des_key_file|desc|describe|deterministic|diagnostics|directory|disable|discard|disk|distinct|distinctrow|div|do|double|drop|dual|dumpfile|duplicate|dynamic|each|else|elseif|enable|enclosed|end|ends|engine|engines|enum|error|errors|escape|escaped|event|events|every|exchange|execute|exists|exit|expansion|expire|explain|export|extended|extent_size|false|fast|faults|fetch|fields|file|first|fixed|float|float4|float8|flush|for|force|foreign|format|found|from|full|fulltext|function|general|geometry|geometrycollection|get|get_format|global|grant|grants|group|handler|hash|having|help|high_priority|host|hosts|hour|hour_microsecond|hour_minute|hour_second|identified|if|ignore|ignore_server_ids|import|in|index|indexes|infile|initial_size|inner|inout|insensitive|insert|insert_method|install|int|int1|int2|int3|int4|int8|integer|interval|into|invoker|io|io_after_gtids|io_before_gtids|io_thread|ipc|is|isolation|issuer|iterate|join|key|key_block_size|keys|kill|language|last|leading|leave|leaves|left|less|level|like|limit|linear|lines|linestring|list|load|local|localtime|localtimestamp|lock|locks|logfile|logs|long|longblob|longtext|loop|low_priority|master|master_auto_position|master_bind|master_connect_retry|master_delay|master_heartbeat_period|master_host|master_log_file|master_log_pos|master_password|master_port|master_retry_count|master_server_id|master_ssl|master_ssl_ca|master_ssl_capath|master_ssl_cert|master_ssl_cipher|master_ssl_crl|master_ssl_crlpath|master_ssl_key|master_ssl_verify_server_cert|master_user|match|max_connections_per_hour|max_queries_per_hour|max_rows|max_size|max_updates_per_hour|max_user_connections|maxvalue|medium|mediumblob|mediumint|mediumtext|memory|merge|message_text|microsecond|middleint|migrate|min_rows|minute|minute_microsecond|minute_second|mod|mode|modifies|modify|month|multilinestring|multipoint|multipolygon|mutex|mysql|mysql_errno|name|names|national|natural|nchar|ndb|ndbcluster|new|next|no|no_wait|no_write_to_binlog|nodegroup|none|not|null|number|numeric|nvarchar|offset|old_password|on|one|one_shot|only|open|optimize|option|optionally|options|or|order|out|outer|outfile|owner|pack_keys|page|parser|partial|partition|partitioning|partitions|password|phase|plugin|plugin_dir|plugins|point|polygon|port|precision|prepare|preserve|prev|primary|privileges|procedure|processlist|profile|profiles|proxy|purge|quarter|query|quick|range|read|read_only|read_write|reads|real|rebuild|recover|recursive|redo_buffer_size|redofile|redundant|references|regexp|relay|relay_log_file|relay_log_pos|relay_thread|relaylog|release|reload|remove|rename|reorganize|repair|repeat|repeatable|replace|replication|require|reset|resignal|restore|restrict|resume|return|returned_sqlstate|returned_sqlstate|returning|returns|reverse|revoke|right|rlike|rollback|rollup|routine|row|row_count|row_count|row_format|rows|rtree|savepoint|schedule|schema|schema_name|schemas|second|second_microsecond|security|select|sensitive|separator|serial|serializable|server|session|set|share|show|shutdown|signal|signed|simple|slave|slow|slow|smallint|snapshot|socket|some|soname|sounds|source|spatial|specific|sql|sql_after_gtids|sql_after_gtids|sql_after_mts_gaps|sql_after_mts_gaps|sql_before_gtids|sql_before_gtids|sql_big_result|sql_buffer_result|sql_cache|sql_calc_found_rows|sql_no_cache|sql_small_result|sql_thread|sql_tsi_day|sql_tsi_hour|sql_tsi_minute|sql_tsi_month|sql_tsi_quarter|sql_tsi_second|sql_tsi_week|sql_tsi_year|sqlexception|sqlstate|sqlwarning|ssl|start|starting|starts|stats_auto_recalc|stats_auto_recalc|stats_persistent|stats_persistent|stats_sample_pages|stats_sample_pages|status|stop|storage|straight_join|string|subclass_origin|subject|subpartition|subpartitions|super|suspend|swaps|switches|table|table_checksum|table_name|tables|tablespace|temporary|temptable|terminated|text|than|then|time|timestamp|timestampadd|timestampdiff|tinyblob|tinyint|tinytext|to|trailing|transaction|trigger|triggers|true|truncate|type|types|uncommitted|undefined|undo|undo_buffer_size|undofile|unicode|uninstall|union|unique|unknown|unlock|unsigned|until|update|upgrade|usage|use|use_frm|user_resources|using|utc_date|utc_time|utc_timestamp|value|values|varbinary|varchar|varcharacter|variables|varying|view|wait|warnings|week|weight_string|when|where|while|window|with|work|wrapper|write|x509|xa|xml|xor|year|year_month|zerofill|lead_id|user|';
    }


    public function allowed_modules()
    {     
          $modules=array();
          $modules[]=["name"=>"dashboard","text"=>"Dashboard","icon"=>"fa fa-th-large","sub"=>[]];    

          $modules[]=["name"=>"user","text"=>"User Management","icon"=>"fa fa-user","sub"=>[
            ["name"=>"users","hash"=>"","text"=>"Users","icon"=>""],
            ["name"=>"groups","hash"=>"","text"=>"User Groups","icon"=>""]
          ]];
      
          $modules[]=["name"=>"campaigns","text"=>"Campaigns","icon"=>"fa fa-bullhorn","sub"=>[

            ["name"=>"","hash"=>"","text"=>"Campaigns","icon"=>""],
            ["name"=>"scripts","hash"=>"","text"=>"Script","icon"=>""]

          ]];

          
          $modules[]=["name"=>"data","text"=>"Data","icon"=>"fa fa-database","sub"=>[        
            ["name"=>"","hash"=>"","text"=>"Data","icon"=>""],
            ["name"=>"import","hash"=>"","text"=>"Load Data","icon"=>""],
            ["name"=>"search","hash"=>"","text"=>"Search Data","icon"=>""],                        
          ]];

        
          $modules[]=["name"=>"inbound","text"=>"Inbound","icon"=>"fa fa-arrow-down","sub"=>[
            ["name"=>"groups_manage","hash"=>"","text"=>"Groups","icon"=>""],
            ["name"=>"did_manage","hash"=>"","text"=>"DIDs","icon"=>""],
            ["name"=>"ivr_manage","hash"=>"","text"=>"Call Menus","icon"=>""],
            ["name"=>"remote_manage","hash"=>"","text"=>"Remote Agents","icon"=>""],
            ["name"=>"dnc_groups","hash"=>"","text"=>"DNC Groups","icon"=>""],
          ]];

          $modules[]=["name"=>"filter","text"=>"SQL Filter","icon"=>"fa fa-filter","sub"=>[
            ["name"=>"","hash"=>"","text"=>"SQL Filter","icon"=>""]
          ]];

          $modules[]=["name"=>"soundboard","text"=>"Soundboard","icon"=>"fa fa-volume-up","sub"=>[
            ["name"=>"","hash"=>"","text"=>"Soundboard","icon"=>""]
          ]];
          
          $modules[]=["name"=>"calltimes","text"=>"Call Times","icon"=>"fa fa-clock-o","sub"=>[
            ["name"=>"","hash"=>"","text"=>"Call Times","icon"=>""]
          ]];


          $modules[]=["name"=>"agent_reports","text"=>"Agent Reports","icon"=>"fa fa-list","sub"=>[
            ["name"=>"realtime","hash"=>"","text"=>"Real Time","icon"=>""],
            ["name"=>"agent_time_detail","hash"=>"","text"=>"Agents Time","icon"=>""],
            ["name"=>"agent_status_detail","hash"=>"","text"=>"Agents Stats","icon"=>""],
            ["name"=>"agent_performance_detail","hash"=>"","text"=>"Agents Performance","icon"=>""],
            ["name"=>"team_performance_detail","hash"=>"","text"=>"Team Performance","icon"=>""]
          ]];
          

          $modules[]=["name"=>"data_reports","text"=>"Data Reports","icon"=>"fa fa-list","sub"=>[            
            ["name"=>"recordings","hash"=>"","text"=>"Recordings","icon"=>""],
            ["name"=>"outbound","hash"=>"","text"=>"Outbound Calls","icon"=>""],
            ["name"=>"lead_export","hash"=>"","text"=>"Export Leads","icon"=>""],
            ["name"=>"call_connectivity","hash"=>"","text"=>"Call Connectivity","icon"=>""],
          ]];


           $modules[]=["name"=>"contact_reports","text"=>"Contact Reports","icon"=>"fa fa-list","sub"=>[
            ["name"=>"call_export","hash"=>"","text"=>"Export Calls","icon"=>""],
            ["name"=>"inbound","hash"=>"","text"=>"Inbound Calls","icon"=>""],
            ["name"=>"campaign_status_list","hash"=>"","text"=>"Campaign Status List","icon"=>""],
          ]];
          


          // $modules[]=["name"=>"reports","text"=>"Reports","icon"=>"fa fa-list","sub"=>[



          //   ["name"=>"realtime","hash"=>"","text"=>"Real Time","icon"=>""],
          //   ["name"=>"recordings","hash"=>"","text"=>"Recordings","icon"=>""],
          //   ["name"=>"agent_time_detail","hash"=>"","text"=>"Agents Time","icon"=>""],
          //   ["name"=>"agent_status_detail","hash"=>"","text"=>"Agents Stats","icon"=>""],
          //   ["name"=>"agent_performance_detail","hash"=>"","text"=>"Agents Performance","icon"=>""],
          //   ["name"=>"team_performance_detail","hash"=>"","text"=>"Team Performance","icon"=>""],
          //   ["name"=>"outbound","hash"=>"","text"=>"Outbound Calls","icon"=>""],
          //   ["name"=>"call_export","hash"=>"","text"=>"Export Calls","icon"=>""],
          //   ["name"=>"lead_export","hash"=>"","text"=>"Export Leads","icon"=>""],
          //   ["name"=>"fronter_closer","hash"=>"","text"=>"Fronter Closer","icon"=>""],
          //   ["name"=>"inbound","hash"=>"","text"=>"Inbound Calls","icon"=>""],
          //   ["name"=>"inbound_did","hash"=>"","text"=>"Inbound DIDs","icon"=>""],
          //   ["name"=>"campaign_status_list","hash"=>"","text"=>"Campaign Status List","icon"=>""],
          // ]];


          $modules[]=["name"=>"settings","text"=>"Settings","icon"=>"fa fa-cog","sub"=>[          
            ["name"=>"phones","hash"=>"","text"=>"Phones","icon"=>""],
            ["name"=>"voicemail","hash"=>"","text"=>"Voicemail","icon"=>""],
            ["name"=>"outbound_dnc","hash"=>"","text"=>"Outbound DNC","icon"=>""],
            ["name"=>"inbound_dnc","hash"=>"","text"=>"Inbound DNC","icon"=>""],
            ["name"=>"audio_files","hash"=>"","text"=>"Audio Files","icon"=>""],
            ["name"=>"statuses","hash"=>"","text"=>"System Statuses","icon"=>""],
            ["name"=>"branding","hash"=>"","text"=>"Branding","icon"=>""],
            ["name"=>"gateway","hash"=>"","text"=>"Gateway","icon"=>""],
            // ["name"=>"firewall","hash"=>"","text"=>"Firewall","icon"=>""],
          ]];

          $modules[]=["name"=>"utilities","text"=>"Utilities","icon"=>"fa fa-wrench","sub"=>[          
            ["name"=>"settings_compare","hash"=>"","text"=>"Settings Compare","icon"=>""],
          ]];

          

          return $modules;
    }

    public function Get_loggedin_user()
    {

       $username = $this->session->userdata('username');
       $password = $this->session->userdata('password');

       $pass_hash='';
       $bcrypt=0;
       $password = preg_replace("/\||`|&|\'|\"|\\\\|;| /","",$password);
       $passSQL = "pass='$password'";
       if (SSpass_hash_enabled > 0)
        {
        if ($bcrypt < 1)
          {
          $pass_hash = exec("../agent/bp.pl --pass='$password'");
          $pass_hash = preg_replace("/PHASH: |\n|\r|\t| /",'',$pass_hash);
          }
        else
          {$pass_hash = $password;}
          $passSQL = "pass_hash='$pass_hash'";
        }

       $sql="SELECT * FROM vicidial_users WHERE user_level>7 AND user='$username' AND $passSQL LIMIT 1";
       $query=$this->db->query($sql);
       $result=$query->result_array()[0];
       return $result;
    }

    public function getWebPhoneUrl()
    {   $webphone_content="";
        $webphone_url="";
        $webphone_dialpad_override="";
        $webphone_width="";
        $webphone_height="";
        $system_key="";
        $userdata=$this->Get_loggedin_user();
        $monitor_phone=$userdata['phone_login'];
        $stmt="SELECT extension,dialplan_number,server_ip,login,pass,protocol,conf_secret,is_webphone,use_external_server_ip,codecs_list,webphone_dialpad,outbound_cid,webphone_auto_answer from phones where login='$monitor_phone' and active = 'Y';";
          $rslt=$this->mysql_to_mysqli($stmt, $this->link);
          $Mph_ct = mysqli_num_rows($rslt);
  if ($Mph_ct > 0)
   {
   $row=mysqli_fetch_row($rslt);
   $extension =        $row[0];
   $dialplan_number =      $row[1];
   $webphone_server_ip =   $row[2];
   $login =          $row[3];
   $pass =           $row[4];
   $protocol =         $row[5];
   $conf_secret =        $row[6];
   $is_webphone =        $row[7];
   $use_external_server_ip = $row[8];
   $codecs_list =        $row[9];
   $webphone_dialpad =     $row[10];
   $outbound_cid =       $row[11];
   $webphone_auto_answer =   $row[12];

   //echo $is_webphone;
   


   if ($is_webphone == 'Y')
     {
     ### build Iframe variable content for webphone here
     $codecs_list = preg_replace("/ /",'',$codecs_list);
     $codecs_list = preg_replace("/-/",'',$codecs_list);
     $codecs_list = preg_replace("/&/",'',$codecs_list);

     $stmt="SELECT asterisk_version,web_socket_url,external_web_socket_url from servers where server_ip='$webphone_server_ip' LIMIT 1;";
     $rslt=$this->mysql_to_mysqli($stmt, $this->link);
     $row=mysqli_fetch_row($rslt);
     $asterisk_version =     $row[0];
     $web_socket_url =     $row[1];
     $external_web_socket_url =  $row[2];
     if ( ($use_external_server_ip=='Y') and (strlen($external_web_socket_url) > 5) )
       {$web_socket_url = $external_web_socket_url;}

     if ($use_external_server_ip=='Y')
       {
       ##### find external_server_ip if enabled for this phone account
       $stmt="SELECT external_server_ip FROM servers where server_ip='$webphone_server_ip' LIMIT 1;";
       $rslt=$this->mysql_to_mysqli($stmt, $this->link);
       $exip_ct = mysqli_num_rows($rslt);
       if ($exip_ct > 0)
         {
         $row=mysqli_fetch_row($rslt);
         $webphone_server_ip = $row[0];
         }
       }
     if (strlen($webphone_url) < 6)
       {
       ##### find webphone_url in system_settings and generate IFRAME code for it #####
       $stmt="SELECT webphone_url FROM system_settings LIMIT 1;";
       $rslt=$this->mysql_to_mysqli($stmt, $this->link);
       $wu_ct = mysqli_num_rows($rslt);
       if ($wu_ct > 0)
         {
         $row=mysqli_fetch_row($rslt);
         $webphone_url = $row[0];
         }
       }
     if (strlen($system_key) < 1)
       {
       ##### find system_key in system_settings if populated #####
       $stmt="SELECT webphone_systemkey FROM system_settings LIMIT 1;";
       $rslt=$this->mysql_to_mysqli($stmt, $this->link);
       $wsk_ct = mysqli_num_rows($rslt);
       if ($wsk_ct > 0)
         {
         $row=mysqli_fetch_row($rslt);
         $system_key = $row[0];
         }
       }
   # echo "<!-- debug: $webphone_dialpad|$webphone_dialpad_override|$monitor_phone|$extension -->";
     if ( ($webphone_dialpad_override != 'DISABLED') and (strlen($webphone_dialpad_override) > 0) )
       {$webphone_dialpad = $webphone_dialpad_override;}
     $webphone_options='INITIAL_LOAD';
     if ($webphone_dialpad == 'Y') {$webphone_options .= "--DIALPAD_Y";}
     if ($webphone_dialpad == 'N') {$webphone_options .= "--DIALPAD_N";}
     if ($webphone_dialpad == 'TOGGLE') {$webphone_options .= "--DIALPAD_TOGGLE";}
     if ($webphone_dialpad == 'TOGGLE_OFF') {$webphone_options .= "--DIALPAD_OFF_TOGGLE";}
     if ($webphone_auto_answer == 'Y') {$webphone_options .= "--AUTOANSWER_Y";}
     if ($webphone_auto_answer == 'N') {$webphone_options .= "--AUTOANSWER_N";}
     if (strlen($web_socket_url) > 5) {$webphone_options .= "--WEBSOCKETURL$web_socket_url";}
    

     $session_name='RTS01234561234567890';

     ### base64 encode variables
     $b64_phone_login =    base64_encode($extension);
     $b64_phone_pass =   base64_encode($conf_secret);
     $b64_session_name =   base64_encode($session_name);
     $b64_server_ip =    base64_encode($webphone_server_ip);
     $b64_callerid =     base64_encode($outbound_cid);
     $b64_protocol =     base64_encode($protocol);
     $b64_codecs =     base64_encode($codecs_list);
     $b64_options =      base64_encode($webphone_options);
     $b64_system_key =   base64_encode($system_key);

     $WebPhonEurl = "$webphone_url?phone_login=$b64_phone_login&phone_login=$b64_phone_login&phone_pass=$b64_phone_pass&server_ip=$b64_server_ip&callerid=$b64_callerid&protocol=$b64_protocol&codecs=$b64_codecs&options=$b64_options&system_key=$b64_system_key";
     $webphone_content = "<iframe  src=\"$WebPhonEurl\" style=\"display:none;width:" . $webphone_width . ";height:" . $webphone_height . ";background-color:transparent;z-index:17;\" scrolling=\"auto\" frameborder=\"0\" allowtransparency=\"true\" id=\"webphone\" name=\"webphone\" width=\"" . $webphone_width . "\" height=\"" . $webphone_height . "\" allow=\"microphone *; speakers *;\"> </iframe>";
     }
   
   }
          

          return $webphone_content;
    }

    public function exclude_permissions(){
          $array=array("dashboard",'dashboard-',"dashboard-manage","changepassword","logout","permissions",'profile','data-add');
          return $array;
    }

    public function getlocation($location){
        if (strlen($location)>2)
                {
                $URLserver_ip = $location;
                $URLserver_ip = preg_replace('/http:\/\//i', '',$URLserver_ip);
                $URLserver_ip = preg_replace('/https:\/\//i', '',$URLserver_ip);
                $URLserver_ip = preg_replace('/\/.*/i', '',$URLserver_ip);
                $stmt="SELECT count(*) from servers where server_ip='$URLserver_ip';";
                $rsltx=$this->Model_lib->mysql_to_mysqli($stmt, $this->Model_lib->link);
                $rowx=mysqli_fetch_row($rsltx);                
                if ($rowx[0] > 0)
                    {
                    $stmt="SELECT recording_web_link,alt_server_ip,external_server_ip from servers where server_ip='$URLserver_ip';";
                    $rsltx=$this->Model_lib->mysql_to_mysqli($stmt, $this->Model_lib->link);
                    $rowx=mysqli_fetch_row($rsltx);
                    
                    if (preg_match("/ALT_IP/i",$rowx[0]))
                        {
                        $location = preg_replace("/$URLserver_ip/i", "$rowx[1]", $location);
                        }
                    if (preg_match("/EXTERNAL_IP/i",$rowx[0]))
                        {
                        $location = preg_replace("/$URLserver_ip/i", "$rowx[2]", $location);
                        }
                    }
                }
                return $location;
    }

    public function getPermissionsNodes(){
      
          $array[]=array("id"=>"phones","text"=>"Phones");
          $array[]=array("id"=>"user","text"=>"Users");
          $array[]=array("id"=>"campaigns","text"=>"Campaigns");
          $array[]=array("id"=>"lists","text"=>"Lists");
          $array[]=array("id"=>"dnc","text"=>"Dnc");
          $array[]=array("id"=>"sounds","text"=>"Sounds");
          $array[]=array("id"=>"queue","text"=>"Queue");
          $array[]=array("id"=>"numbers","text"=>"Numbers");
          $array[]=array("id"=>"remote","text"=>"Remote Agents");
          $array[]=array("id"=>"callmenu","text"=>"Call Menu");
          $array[]=array("id"=>"script","text"=>"Script");

          $array[]=array("id"=>"search_lead","text"=>"Seach Leads");
          $array[]=array("id"=>"call_log","text"=>"Recording Call Log");
          $array[]=array("id"=>"realtime","text"=>"Realtime Report");
          $array[]=array("id"=>"inbound","text"=>"Inbound Report");
          $array[]=array("id"=>"inbound_did","text"=>"Inbound Number Report");
          $array[]=array("id"=>"outbound","text"=>"Outbound Report");
          $array[]=array("id"=>"fronter_closer","text"=>"Fronter Closer Report");
          $array[]=array("id"=>"campaign_status_list","text"=>"Campaign Status List Report");
          $array[]=array("id"=>"agent_time_detail","text"=>"Agent Time Detail Report");
          $array[]=array("id"=>"agent_status_detail","text"=>"Agent Status Detail Report");
          $array[]=array("id"=>"agent_performance_detail","text"=>"Agent Performance Detail Report");
          $array[]=array("id"=>"team_performance_detail","text"=>"Team Performance Detail Report");
          $array[]=array("id"=>"call_export","text"=>"Call export");
          $array[]=array("id"=>"lead_export","text"=>"Lead export");


          $array[]=array("id"=>"groups","text"=>"Groups");  
          $array[]=array("id"=>"firewall","text"=>"Firewall");
          $array[]=array("id"=>"branding","text"=>"Branding");
          $array[]=array("id"=>"permissions","text"=>"Permissions");
          

      
      return $array;      
    }

    public function CheckStatus($status){
      $result = $this -> db
            -> select('*')
            -> where('status', $status)
            -> get('vicidial_statuses')
            -> result_array();
      if(sizeof($result)>0){
          return true;
      }else{
          return false;
      }
    }

    
    public function CheckSCRIPTID($script_id,$csrf)
    {       $script_id=$this->DecryptionId($script_id);
            $result = $this -> db
            -> select('*')
            -> where('script_id', $script_id)
            -> get('vicidial_scripts')
            -> result_array();
             if(sizeof($result)==0)
                    {
                        $errors=array("error"=>$this->_QXZ("Not a valid script id selection"));
                        $data=array("status"=>false,"csrf"=>$csrf,"errors"=>$errors);
                        exit(json_encode($data));
                    }
            return $script_id;
    }

    public function CheckGroup($user_group,$csrf)
    {       $user_group=$this->DecryptionId($user_group);
            $result = $this -> db
            -> select('*')
            -> where('user_group', $user_group)
            -> get('vicidial_user_groups')
            -> result_array();
             if(sizeof($result)==0)
                    {
                        $errors=array("error"=>$this->_QXZ("Not a valid user group selection"));
                        $data=array("status"=>false,"csrf"=>$csrf,"errors"=>$errors);
                        exit(json_encode($data));
                    }
            return $user_group;
    }

    public function CheckDIDID($did_id,$csrf)
    {       $did_id=$this->DecryptionId($did_id);
            $result = $this -> db
            -> select('*')
            -> where('did_id', $did_id)
            -> get('vicidial_inbound_dids')
            -> result_array();
             if(sizeof($result)==0)
                    {
                        $errors=array("error"=>$this->_QXZ("Not a valid inbound number selection"));
                        $data=array("status"=>false,"csrf"=>$csrf,"errors"=>$errors);
                        exit(json_encode($data));
                    }
            return $did_id;
    }


    public function CheckUser($user,$csrf)
    {       $user=$this->DecryptionId($user);
            $result = $this -> db
            -> select('*')
            -> where('user', $user)
            -> get('vicidial_users')
            -> result_array();
             if(sizeof($result)==0)
                    {
                        $errors=array("error"=>$this->_QXZ("Not a valid user selection"));
                        $data=array("status"=>false,"csrf"=>$csrf,"errors"=>$errors);
                        exit(json_encode($data));
                    }
            return $user;
    }

    public function getUserDetails($username,$password)
    {
       $pass_hash='';
       $bcrypt=0;
       $password = preg_replace("/\||`|&|\'|\"|\\\\|;| /","",$password);
       $passSQL = "pass='$password'";
       if (SSpass_hash_enabled > 0)
        {
        if ($bcrypt < 1)
          {
          $pass_hash = exec("../agent/bp.pl --pass='$password'");
          $pass_hash = preg_replace("/PHASH: |\n|\r|\t| /",'',$pass_hash);
          }
        else
          {$pass_hash = $password;}
          $passSQL = "pass_hash='$pass_hash'";
        }
       $sql="SELECT * FROM vicidial_users WHERE user='$username' AND $passSQL LIMIT 1";
       $query=$this->db->query($sql);
       $result=$query->result_array()[0];
       return $result;
    }

    public function CheckUserId($user_id,$csrf){
            $user_id=$this->DecryptionId($user_id);
            $result = $this -> db
            -> select('*')
            -> where('user_id', $user_id)
            -> get('vicidial_users')
            -> result_array();
             if(sizeof($result)==0)
                    {
                        $errors=array("error"=>$this->_QXZ("Not a valid user selection"));
                        $data=array("status"=>false,"csrf"=>$csrf,"errors"=>$errors);
                        exit(json_encode($data));
                    }
            return $user_id;
    }

    public function CheckPhoneExtension($extension,$csrf){
            $extension=$this->DecryptionId($extension);
            $result = $this -> db
            -> select('*')
            -> where('extension', $extension)
            -> get('phones')
            -> result_array();
             if(sizeof($result)==0)
                    {
                        $errors=array("error"=>$this->_QXZ("Not a valid phone selection"));
                        $data=array("status"=>false,"csrf"=>$csrf,"errors"=>$errors);
                        exit(json_encode($data));
                    }
            return $extension;
    }


    public function CheckFilterID($lead_filter_id,$csrf){
            $lead_filter_id=$this->DecryptionId($lead_filter_id);
            $result = $this -> db
            -> select('*')
            -> where('lead_filter_id', $lead_filter_id)
            -> get('vicidial_lead_filters')
            -> result_array();
             if(sizeof($result)==0)
                    {
                        $errors=array("error"=>$this->_QXZ("Not a valid filter id selection"));
                        $data=array("status"=>false,"csrf"=>$csrf,"errors"=>$errors);
                        exit(json_encode($data));
                    }
            return $lead_filter_id;
    }

    public function CheckSoundboardID($avatar_id,$csrf){
            $avatar_id=$this->DecryptionId($avatar_id);
            $result = $this -> db
            -> select('*')
            -> where('avatar_id', $avatar_id)
            -> get('vicidial_avatars')
            -> result_array();
             if(sizeof($result)==0)
                    {
                        $errors=array("error"=>$this->_QXZ("Not a valid soundboard id selection"));
                        $data=array("status"=>false,"csrf"=>$csrf,"errors"=>$errors);
                        exit(json_encode($data));
                    }
            return $avatar_id;
    }

    public function CheckRemoteID($remote_agent_id,$csrf){
            $remote_agent_id=$this->DecryptionId($remote_agent_id);
            $result = $this -> db
            -> select('*')
            -> where('remote_agent_id', $remote_agent_id)
            -> get('vicidial_remote_agents')
            -> result_array();
             if(sizeof($result)==0)
                    {
                        $errors=array("error"=>$this->_QXZ("Not a valid remote agent id selection"));
                        $data=array("status"=>false,"csrf"=>$csrf,"errors"=>$errors);
                        exit(json_encode($data));
                    }
            return $remote_agent_id;
    }
    
    public function CheckQueueID($group_id,$csrf){
            $group_id=$this->DecryptionId($group_id);
            $result = $this -> db
            -> select('*')
            -> where('group_id', $group_id)
            -> get('vicidial_inbound_groups')
            -> result_array();
             if(sizeof($result)==0)
                    {
                        $errors=array("error"=>$this->_QXZ("Not a valid queue id selection"));
                        $data=array("status"=>false,"csrf"=>$csrf,"errors"=>$errors);
                        exit(json_encode($data));
                    }
            return $group_id;
    }
    
    public function CheckCampaignID($campaign_id,$csrf){
            $campaign_id=$this->DecryptionId($campaign_id);
            $result = $this -> db
            -> select('*')
            -> where('campaign_id', $campaign_id)
            -> get('vicidial_campaigns')
            -> result_array();
             if(sizeof($result)==0)
                    {
                        $errors=array("error"=>$this->_QXZ("Not a valid campaign_id selection"));
                        $data=array("status"=>false,"csrf"=>$csrf,"errors"=>$errors);
                        exit(json_encode($data));
                    }
            return $campaign_id;
    }

    public function AdminLog($event_section="",$event_type="",$record_id="",$event_code="",$SQL_log="",$event_notes="")
    {
      $PHP_AUTH_USER=LOGuser;
      $SQLdate = date("Y-m-d H:i:s");
      $ip = getenv("REMOTE_ADDR");       
      $stmt="INSERT INTO vicidial_admin_log set event_date='$SQLdate', user='$PHP_AUTH_USER', ip_address='$ip', event_section=\"$event_section\", event_type=\"$event_type\", record_id=\"$record_id\", event_code=\"$event_code\", event_sql=\"$SQL_log\", event_notes=\"$event_notes\";";
        $rslt=$this->mysql_to_mysqli($stmt, $this->link);
    }

    public function Is_login()
    {  $username = $this->session->userdata('username');
       $password = $this->session->userdata('password');
        $this->link=mysqli_connect($this->db->hostname,$this->db->username,$this->db->password,$this->db->database); 
        if (mysqli_connect_errno())
          {
            echo "Failed to connect to MySQL: " . mysqli_connect_error();
          }
       $this->getBranding();
       if(empty($username) && empty($password)){
           return false;
       }else{
           $this->getvicidial_settins_array();
           return true;
       }
    }

   public function sec_convert($sec,$precision)
  {
  $sec = round($sec,0);

  if ($sec < 1)
    {
    if ($precision == 'HF' || $precision == 'H')
      {return "0:00:00";}
    elseif ($precision == 'S')
      {return "0";}
    else
      {return "0:00";}
    }

  if ($precision == 'HF')
    {$precision='H';}
  else
    {
    # if ( ($sec < 3600) and ($precision != 'S') ) {$precision='M';}
    }

  if ($precision == 'H')
    {
    $hours = floor($sec / 3600);
    $hours_sec = $hours * 3600;
    $seconds = $sec - $hours_sec;
    $minutes = floor($seconds / 60);
    $seconds -= ($minutes * 60);
    $Ftime = sprintf('%s:%s:%s',
      $hours,
      str_pad($minutes,2,'0',STR_PAD_LEFT),
      str_pad($seconds,2,'0',STR_PAD_LEFT)
    );
    }
  elseif ($precision == 'M')
    {
    $minutes = floor($sec / 60);
    $seconds = $sec - ($minutes * 60);
    $Ftime = sprintf('%s:%s',
      $minutes,
      str_pad($seconds,2,'0',STR_PAD_LEFT)
    );
    }
  else 
    {
    $Ftime = $sec;
    }
  return "$Ftime";
  }

    public function getBranding(){
        $domain_name   = $_SERVER['SERVER_NAME'];
        $logo=base_url()."/assets/img/logo.png";
        $favicon=base_url()."/assets/img/favicon.ico";
        $company_name="Dialer21";
        $slogan="";
        $company_email="hello@dialer21.com";
        $phone_number="XXXXXXXXXX";
        $branding_color=""; //"##222e3a !important"; //"#00226e !important";

        $stmt="SELECT * from tbl_branding where domain_name='$domain_name' limit 1;";

        $query = $this->db->query($stmt)->result_array();


        if(sizeof($query)>0)
        {
          $query=$query[0];
          if(!empty($query['slogan'])){
            $slogan        = $query['slogan'];  
          }

          if(!empty($query['company_email'])){
            $company_email = $query['company_email']; 
          }

          if(!empty($query['phone_number'])){
            $phone_number = $query['phone_number']; 
          }
          
          if(!empty($query['favicon'])){
             $favicon = 'data:image/jpg/jpeg/png;base64,'.$query['favicon'];
          }        

          if(!empty($query['logo'])){
             $logo = 'data:image/jpg/jpeg/png;base64,'.$query['logo'];
          }        
            
          if(!empty($query['company_name'])){
             $company_name  = $query['company_name'];
          }

          if(!empty($query['branding_color'])){
             $branding_color =$query['branding_color']." !important;";
          }

          
      }


        define("DOMAIN_SLOGAN",$slogan);
        define("DOMAIN_COMPANY_EMAIL",$company_email);
        define("DOMAIN_PHONE_NUMBER",$phone_number);
        define("DOMAIN_NAME",$domain_name);
        define("DOMAIN_FAVICON",$favicon);
        define("DOMAIN_LOGO",$logo);
        define("DOMAIN_COMPANY_NAME",$company_name);
        define("DOMAIN_HEADER_COLOR",$branding_color);

    }

    public function Is_lock()
    {
        return false;
    }
    
    public function Is_blocked($action="")
    {   

        $action=rtrim($action,"-");
        $userinfo=$this->GetCurrentUserInfo();
        $user_id=$userinfo['user_id'];

        if ($userinfo['user_level']>=9)
        {
            return true;
        }

        $stmt="SELECT permissions from vicidial_users where user_id='$user_id';";
        $query = $this->db->query($stmt);
        $result=$query->result_array();
        $permissions="";
        if(sizeof($result)>0)
        {
          $permissions=strval($result[0]['permissions']);
        }
        if(trim($permissions)==""){
          return true;
        }

        $haystack=$this->exclude_permissions();
        if(in_array($action, $haystack))
        {
           return true;
        }

        $regex  = "/$action/";

        if(preg_match($regex, $permissions, $match)) 
        {
           return true;
        } 
        else 
        {
           return false;
        }
    }

    public function Is_allowed($action="",$user_id=""){
        $stmt="SELECT permissions from vicidial_users where user_id='$user_id';";
        $query = $this->db->query($stmt);
        $result=$query->result_array();
        $permissions="";
        if(sizeof($result)>0)
        {
          $permissions=strval($result[0]['permissions']);
        }
        $regex  = "/$action/";
        if(preg_match($regex, $permissions, $match)) 
        {
          return "SELECTED";
        } 
        else 
        {
          return "";
        }
    }

    public function parse_array($array){
                        
                        $postkeys=array_keys($array);
                        $data=array();
                        for($i=0;$i<sizeof($postkeys);$i++){                            
                            $data[$postkeys[$i]]=$this->input->post($postkeys[$i]);
                        }

                        return $data;
    }
  
    
     public  function safe_b64encode($string) {
  
        $data = base64_encode($string);
        $data = str_replace(array('+','/','='),array('-','_',''),$data);
        return $data;
    }

  public function safe_b64decode($string) {
        $data = str_replace(array('-','_'),array('+','/'),$string);
        $mod4 = strlen($data) % 4;
        if ($mod4) {
            $data .= substr('====', $mod4);
        }
        return base64_decode($data);
    }
  
    public  function EncryptionId($value){ 
    
      if(!$value){return false;}
        $text = $value;
        $iv_size = mcrypt_get_iv_size(MCRYPT_RIJNDAEL_256, MCRYPT_MODE_ECB);
        $iv = mcrypt_create_iv($iv_size, MCRYPT_RAND);
        $crypttext = mcrypt_encrypt(MCRYPT_RIJNDAEL_256, $this->skey, $text, MCRYPT_MODE_ECB, $iv);
        return trim($this->safe_b64encode($crypttext)); 
    }
    
    public function DecryptionId($value){
    
        if(!$value){return false;}
        $crypttext = $this->safe_b64decode($value); 
        $iv_size = mcrypt_get_iv_size(MCRYPT_RIJNDAEL_256, MCRYPT_MODE_ECB);
        $iv = mcrypt_create_iv($iv_size, MCRYPT_RAND);
        $decrypttext = mcrypt_decrypt(MCRYPT_RIJNDAEL_256, $this->skey, $crypttext, MCRYPT_MODE_ECB, $iv);
        return trim($decrypttext);
    }
    
    public function Get_usergroups(){
      
        $stmt="SELECT * from vicidial_user_groups ".whereLOGadmin_viewable_groupsSQL." order by user_group;";
        $query = $this->db->query($stmt)->result_array();
        return $query;
      
    }
    
    public function Get_sounds(){
       //$stmt="SELECT * from audio_store_details order by audio_epoch;";
        $stmt="SELECT * from audio_store_details ".whereLOGadmin_viewable_groupsSQL." order by user_group;";
        $query = $this->db->query($stmt)->result_array();
        return $query;
    }

    public function Get_mod(){      
        $stmt="SELECT moh_id,moh_name,random from vicidial_music_on_hold where active='Y' ".LOGadmin_viewable_groupsSQL." order by moh_id";
        //$stmt="SELECT * from audio_store_details ".whereLOGadmin_viewable_groupsSQL." order by user_group;";
        $query = $this->db->query($stmt)->result_array();
        return $query;
    }
    
    public function GetgroupInfo($group_id){
        if($group_id=="" || $group_id=="---ALL---"){
            $group_id="ADMIN";
        }
        $result = $this -> db
       -> select('*')
       -> where('user_group', $group_id)       
       -> limit(1)
       -> get('vicidial_user_groups')
       -> result_array();
        
        if(isset($result[0])){
            return $result[0];
        }else{
            $result[0]=array("user_group"=>$group_id,"group_name"=>$group_id,"allowed_campaigns"=>"");
            return $result[0];
        }
    }
    
    public function GetCurrentUserInfo(){
       $username = $this->session->userdata('username');
       $password = $this->session->userdata('password');

       $pass_key='pass';
       $pass_hash='';
       $bcrypt=0;
       $password = preg_replace("/\||`|&|\'|\"|\\\\|;| /","",$password);
       $passSQL = $password;
       if (SSpass_hash_enabled > 0)
        {
        if ($bcrypt < 1)
          {
          $pass_hash = exec("../agent/bp.pl --pass='$password'");
          $pass_hash = preg_replace("/PHASH: |\n|\r|\t| /",'',$pass_hash);
          }
        else
          {$pass_hash = $password;}
          $passSQL = $pass_hash;
          $pass_key='pass_hash';
        }

       $result = $this -> db
       -> select('*')
       -> where('user', $username)
       -> where($pass_key, $passSQL)
       -> limit(1)
       -> get('vicidial_users')
       -> result_array();

       if(sizeof($result)>0){
          return $result[0];
       }else{
          redirect(base_url('user/logout'));
       }
    }
    
    public function GetCurrentUserGroupId()
    {
       $username = $this->session->userdata('username');
       $password = $this->session->userdata('password');
       $result = $this -> db
       -> select('user_group')
       -> where('user', $username)
       -> where('pass', $password)
       -> limit(1)
       -> get('vicidial_users')
       -> result_array()[0]['user_group'];
       return $result;
    }    
    
    public function Session_unset(){
        $user_data = $this->session->all_userdata();       
        foreach ($user_data as $key => $value) {
            if ($key != 'session_id' && $key != 'ip_address' && $key != 'user_agent' && $key != 'last_activity') {
                $this->session->unset_userdata($key);
            }
        }
        $this->session->sess_destroy();    
        redirect(base_url().'login');
    }
    
    public function Get_session(){
        $user_data =  $this->session->userdata();
        return $user_data;
    }
    
    public function Put_session($key,$value){
        $session_data=$this->session->userdata();
        $session_data=array_merge($session_data,array($key=>$value));
        $this->session->set_userdata($session_data);        
    }
    
    public function Unset_session($key){
        $this->session->unset_userdata($key);
    }
    
    public function GetCampaigns($user_group){
        $camp_group_SQL = LOGadmin_viewable_groupsSQL;
        if (strlen(whereLOGallowed_campaignsSQL) < 6)
          {$camp_group_SQL = whereLOGadmin_viewable_groupsSQL;}
        $stmt="SELECT * from vicidial_campaigns ".whereLOGallowed_campaignsSQL. " $camp_group_SQL order by campaign_id;";       
        $query = $this->db->query($stmt)->result_array();
        return $query;
    }

    public function GetAllowedInUserGroup($user_group){
      $stmt="SELECT allowed_campaigns,qc_allowed_campaigns,qc_allowed_inbound_groups from vicidial_user_groups where user_group='$user_group' ".LOGadmin_viewable_groupsSQL.";";
        $rslt=$this->mysql_to_mysqli($stmt, $this->link);
        $row=mysqli_fetch_row($rslt);
        $allowed_campaigns =      $row[0];
        $qc_allowed_campaigns =     $row[1];
        $qc_allowed_inbound_groups =  $row[2];

        $allowed_campaigns = preg_replace("/ -$/","",$allowed_campaigns);
        $campaigns = explode(" ", $allowed_campaigns);

        $qc_allowed_campaigns = preg_replace("/ -$/","",$qc_allowed_campaigns);
        $qc_campaigns = explode(" ", $qc_allowed_campaigns);

        $qc_allowed_inbound_groups = preg_replace("/ -$/","",$qc_allowed_inbound_groups);
        $qc_groups = explode(" ", $qc_allowed_inbound_groups);

        $array=['campaigns'=>$campaigns,'qc_campaigns'=>$qc_campaigns,'qc_groups'=>$qc_groups];
        return $array;

    }

    public function SwitchCampiagnIntoUserGroup($campaign_id,$LOGuser_group,$LOGuser_groupOld){
        $user_group_result=$this->GetgroupInfo($LOGuser_groupOld);
        $LOGallowed_campaigns=$user_group_result['allowed_campaigns'];
        
        $SearchIT=" $campaign_id -";
        $UPDATEallowed_campaigns=str_replace($SearchIT, "", $LOGallowed_campaigns);

        $SearchIT=" $campaign_id";
        $UPDATEallowed_campaigns=str_replace($SearchIT, "", $UPDATEallowed_campaigns);
        
        if(trim($UPDATEallowed_campaigns)!=""){
                $UPDATEallowed_campaigns=" $UPDATEallowed_campaigns -";
        }
        
        $stmt="UPDATE vicidial_user_groups SET allowed_campaigns='$UPDATEallowed_campaigns' where user_group='$LOGuser_groupOld';";
              $this->db->query($stmt);
        $this->UpdateCampaignIntoUserGroup($campaign_id,$LOGuser_group,false);
    }



    public function UpdateCampaignIntoUserGroup($campaign_id,$LOGuser_group,$inserted=true){
      $user_group_result=$this->GetgroupInfo($LOGuser_group);
      $LOGallowed_campaigns=$user_group_result['allowed_campaigns'];
      if ( (!preg_match('/\-ALL/i', $LOGallowed_campaigns)) )
              {
            $UPDATEallowed_campaigns =  $LOGallowed_campaigns;
            $UPDATEallowed_campaigns = preg_replace("/ -$/"," $campaign_id -",$UPDATEallowed_campaigns);
            if(trim($UPDATEallowed_campaigns)==""){
              $UPDATEallowed_campaigns=" $campaign_id -";
            }
              $stmt="UPDATE vicidial_user_groups SET allowed_campaigns='$UPDATEallowed_campaigns' where user_group='$LOGuser_group';";
              $this->db->query($stmt);
            }

            if($inserted){
                $stmtA="INSERT INTO vicidial_campaign_stats (campaign_id) values('$campaign_id');";
              $this->db->query($stmtA);
            }
    }
    
    public function cleanID($id){
        $id = preg_replace('/[^-_0-9a-zA-Z]/','',$id);
        return $id;
    }
    
    public function cleanNames($name){
        $name = preg_replace('/[^- \.\,\_0-9a-zA-Z]/','',$name);
        return $name;
    }


    public function SetDialPrefix($campaign_id,$id)
    {
      $stmt="UPDATE vicidial_campaigns SET dial_prefix='$id',manual_dial_prefix='$id' where campaign_id='$campaign_id';";
      $this->db->query($stmt);
    }

    function GetServerIP(){
       $result = $this -> db
       -> select('server_ip')
       -> where('active_agent_login_server','Y')
       -> get('servers')
       -> result_array();
        return $result;
    }

    function GetPhoneDetails($extension){
      $result = $this -> db
       -> select('*')
       -> where('extension',$extension)
       -> get('phones')
       -> result_array();
        return $result;
    } 

    function GetUserGroupDetails($user_group){
      $result = $this -> db
       -> select('*')
       -> where('user_group',$user_group)
       -> get('vicidial_user_groups')
       -> result_array();
        return $result;
    }

    function GetPhoneTemplates(){
       $result = $this -> db
       -> select('template_id,template_name')
       -> where('user_group','---ALL---')
       -> get('vicidial_conf_templates')
       -> result_array();
        return $result;
    }
    

    public function CreateCampaignUsers($campaign_id,$user_group,$pass,$remote_agent_status)
    {   
        $result = $this -> db
       -> select('id,server_ip,number_of_lines,distribute_lines')
       -> where('campaign_id', $campaign_id)    
       -> limit(1)
       -> get('vicidial_campaigns')
       -> result_array()[0];
        $id=trim($result['id']);  
        $server_ip=trim($result['server_ip']);
        $number_of_lines=trim($result['number_of_lines']);
        $distribute_lines=trim($result['distribute_lines']);
        $user_level="4";
        $user=$id;
        $full_name=$user;       
        $number_of_lines_len=strval($number_of_lines)+strval($id);
        for($i=$id;$i<strval($number_of_lines_len);$i++)
        {
          $vuuser=$i;
          $vupass=$i;
          $full_name=$i;
          $stmt="INSERT INTO vicidial_users (user,pass,full_name,user_level,user_group) values('$vuuser','$vupass','$full_name','$user_level','$user_group');";
          $this->db->query($stmt);
        }

        $user_start=$user;        
        $conf_exten=$user;       
        if($remote_agent_status=="Y")
      {
        $status="ACTIVE";
      }else{
        $status="INACTIVE";
      }        

      $stmt="DELETE FROM vicidial_remote_agents WHERE campaign_id='$campaign_id'";
      $this->db->query($stmt);

        $stmt="INSERT INTO vicidial_remote_agents (user_start,number_of_lines,server_ip,conf_exten,status,campaign_id) values('$user_start','$number_of_lines','$server_ip','$conf_exten','$status','$campaign_id');";
        $this->db->query($stmt);

        if($distribute_lines=="Y")
        {
            $this->auto_adjust_lines_on_multi_servers($campaign_id,$status);
        }        
    }

  public function update_remote_agent_status($campaign_id,$status,$server_ip,$number_of_lines)
  {

        $result = $this -> db
       -> select('id,user_group,number_of_lines,distribute_lines')
       -> where('campaign_id', $campaign_id)    
       -> limit(1)
       -> get('vicidial_campaigns')
       -> result_array()[0];
        $id=trim($result['id']);
        $number_of_lines_before=trim($result['number_of_lines']);
        $user_group=trim($result['user_group']);
        $distribute_lines=trim($result['distribute_lines']);
        $user_level="4";
        $number_of_lines_before=255+strval($id);
        for($i=$id;$i<=$number_of_lines_before;$i++)
        {
          $vuuser=$i;          
          $stmt="DELETE FROM vicidial_users WHERE user='$vuuser';";
          $this->db->query($stmt);
          //echo $stmt;
        }

        $number_of_lines_len=strval($number_of_lines)+strval($id);
        for($i=$id;$i<strval($number_of_lines_len);$i++)
        {
          $vuuser=$i;
          $vupass=$i;
          $full_name=$i;
          $stmt="INSERT INTO vicidial_users (user,pass,full_name,user_level,user_group) values('$vuuser','$vupass','$full_name','$user_level','$user_group');";
          $this->db->query($stmt);
        }

      
      $stmt="DELETE FROM vicidial_remote_agents WHERE campaign_id='$campaign_id'";
      $this->db->query($stmt);

      //$stmt="UPDATE vicidial_remote_agents set status='$status',server_ip='$server_ip',number_of_lines='$number_of_lines' where campaign_id='$campaign_id'";
      //$this->db->query($stmt);
      $user_start=$id;
      $conf_exten=$id;
      $stmt="INSERT INTO vicidial_remote_agents (user_start,number_of_lines,server_ip,conf_exten,status,campaign_id) values('$user_start','$number_of_lines','$server_ip','$conf_exten','$status','$campaign_id');";
        $this->db->query($stmt);


      if($distribute_lines=="Y")
      {
        $this->auto_adjust_lines_on_multi_servers($campaign_id,$status);
      }      
  }

  public function auto_adjust_lines_on_multi_servers($campaign_id,$status){
      
      $stmt="DELETE FROM vicidial_remote_agents WHERE campaign_id='$campaign_id'";
      $this->db->query($stmt);
      $servers=$this->GetServerIP();
      $no_of_servers=sizeof($servers);
      $result = $this -> db
       -> select('id,user_group,number_of_lines,server_ip')
       -> where('campaign_id', $campaign_id)    
       -> limit(1)
       -> get('vicidial_campaigns')
       -> result_array()[0];
        $id=trim($result['id']);
        $number_of_lines=trim($result['number_of_lines']);
        $user_group=trim($result['user_group']);
        $server_ip=trim($result['server_ip']);

        $echo_server_lines=strval($number_of_lines)/strval($no_of_servers);
        $echo_server_lines=round($echo_server_lines);
        $max_line_len=strval($id)+strval($number_of_lines);

            if(strval($number_of_lines)<strval($no_of_servers))
            {
                $user_start=$id;
                $conf_exten=$id;
                $stmt="INSERT INTO vicidial_remote_agents (user_start,number_of_lines,server_ip,conf_exten,status,campaign_id) values('$user_start','$number_of_lines','$server_ip','$conf_exten','$status','$campaign_id');";
                $this->db->query($stmt);
                return;
            }

            $base_id=$id;
            for($s=0;$s<sizeof($servers);$s++)
            {   
                $server_ip=$servers[$s]['server_ip'];
                $user_start=$base_id;
                $conf_exten=$base_id;
                $stmt="INSERT INTO vicidial_remote_agents (user_start,number_of_lines,server_ip,conf_exten,status,campaign_id) values('$user_start','$echo_server_lines','$server_ip','$conf_exten','$status','$campaign_id');";
                $this->db->query($stmt); 
                $base_id=strval($base_id)+strval($echo_server_lines);              
            }      

  }

  public function update_campaign_status($campaign_id,$active)
  {      
      if($active=="Y")
      {
        $stmt="UPDATE vicidial_campaigns set active='$active' where campaign_id='$campaign_id'";
      }else{
        $stmt="UPDATE vicidial_campaigns set active='$active' where campaign_id='$campaign_id'";
      }
      return $this->db->query($stmt);                
  }
  
  public function get_call_times(){
        ##### get call_times listing for dynamic pulldown
    $call_times_list="";
      $stmt="SELECT call_time_id,call_time_name from vicidial_call_times order by call_time_id;";
      $rslt=mysqli_query($this->link,$stmt);
      $times_to_print = mysqli_num_rows($rslt);
      $o=0;
      while ($times_to_print > $o)
        {
        $rowx=mysqli_fetch_row($rslt);
        $call_times_list .= "<option value=\"$rowx[0]\">$rowx[0] - $rowx[1]</option>\n";
        $call_timename_list["$rowx[0]"] = "$rowx[1]";
        $o++;
        }
      
      return $call_times_list;
  }

  public function delete_campaigns_user_remoteagents($campaign_id)
  {
       $result = $this -> db
       -> select('id','')
       -> where('campaign_id', $campaign_id)    
       -> limit(1)
       -> get('vicidial_campaigns')
       -> result_array()[0];
        $id=$result['id'];
        $number_of_lines=trim($result['number_of_lines']);        
        $strlen=strlen($id);
        
        $number_of_lines_len=255+strval($id);
        for($i=$id;$i<=strval($number_of_lines_len);$i++)
        {
            $stmt="DELETE FROM vicidial_users where user='$i'";
            $this->db->query($stmt);
        }   
        
        $stmt="DELETE FROM vicidial_remote_agents where campaign_id='$campaign_id'";
        $this->db->query($stmt);
        
        $stmt="DELETE FROM vicidial_campaign_stats where campaign_id='$campaign_id'";
        $this->db->query($stmt);

  }

    public function getvicidial_settins_array(){
      $username = $this->session->userdata('username');
            
        
          $stmt = "SELECT use_non_latin,enable_queuemetrics_logging,enable_vtiger_integration,qc_features_active,outbound_autodial_active,sounds_central_control_active,enable_second_webform,user_territories_active,custom_fields_enabled,admin_web_directory,webphone_url,first_login_trigger,hosted_settings,default_phone_registration_password,default_phone_login_password,default_server_password,test_campaign_calls,active_voicemail_server,voicemail_timezones,default_voicemail_timezone,default_local_gmt,campaign_cid_areacodes_enabled,pllb_grouping_limit,did_ra_extensions_enabled,expanded_list_stats,contacts_enabled,alt_log_server_ip,alt_log_dbname,alt_log_login,alt_log_pass,tables_use_alt_log_db,call_menu_qualify_enabled,admin_list_counts,allow_voicemail_greeting,svn_revision,allow_emails,level_8_disable_add,pass_key,pass_hash_enabled,disable_auto_dial,country_code_list_stats,frozen_server_call_clear,active_modules,allow_chats,enable_languages,language_method,meetme_enter_login_filename,meetme_enter_leave3way_filename,enable_did_entry_list_id,enable_third_webform,default_language,user_hide_realtime_enabled,log_recording_access,alt_ivr_logging,admin_row_click,admin_screen_colors,ofcom_uk_drop_calc,agent_screen_colors,script_remove_js,manual_auto_next,user_new_lead_limit,agent_xfer_park_3way,agent_soundboards,web_loader_phone_length,agent_script,enable_auto_reports,enable_pause_code_limits,enable_drop_lists,allow_ip_lists,system_ip_blacklist,hide_inactive_lists,allow_manage_active_lists,expired_lists_inactive,did_system_filter,enable_gdpr_download_deletion,mute_recordings,user_admin_redirect,list_status_modification_confirmation,sip_event_logging,call_quota_lead_ranking,auto_dial_limit,enable_second_script FROM system_settings;";
$rslt=mysqli_query($this->link,$stmt);
$qm_conf_ct = mysqli_num_rows($rslt);
if ($qm_conf_ct > 0)
  {
  $row=mysqli_fetch_row($rslt);
  $non_latin =              $row[0];
  define("non_latin",$non_latin);

  $SSenable_queuemetrics_logging =    $row[1];
  define("SSenable_queuemetrics_logging",$SSenable_queuemetrics_logging);

  $SSenable_vtiger_integration =      $row[2];
  define("SSenable_vtiger_integration",$SSenable_vtiger_integration);

  $SSqc_features_active =         $row[3];
  define("SSqc_features_active",$SSqc_features_active);

  $SSoutbound_autodial_active =     $row[4];
  define("SSoutbound_autodial_active",$SSoutbound_autodial_active);

  $SSsounds_central_control_active =    $row[5];
  define("SSsounds_central_control_active",$SSsounds_central_control_active);

  $SSenable_second_webform =        $row[6];
  define("SSenable_second_webform",$SSenable_second_webform);

  $SSuser_territories_active =      $row[7];
  define("SSuser_territories_active",$SSuser_territories_active);

  $SScustom_fields_enabled =        $row[8];
  define("SScustom_fields_enabled",$SScustom_fields_enabled);

  $SSadmin_web_directory =        $row[9];
  define("SSadmin_web_directory",$SSadmin_web_directory);

  $SSwebphone_url =           $row[10];
  define("SSwebphone_url",$SSwebphone_url);

  $SSfirst_login_trigger =        $row[11];
  define("SSfirst_login_trigger",$SSfirst_login_trigger);

  $SShosted_settings =          $row[12];
  define("SShosted_settings",$SShosted_settings);

  $SSdefault_phone_registration_password =$row[13];
  define("SSdefault_phone_registration_password",$SSdefault_phone_registration_password);

  $SSdefault_phone_login_password =   $row[14];
  define("SSdefault_phone_login_password",$SSdefault_phone_login_password);

  $SSdefault_server_password =      $row[15];
  define("SSdefault_server_password",$SSdefault_server_password);

  $SStest_campaign_calls =        $row[16];
  define("SStest_campaign_calls",$SStest_campaign_calls);

  $SSactive_voicemail_server =      $row[17];
  define("SSactive_voicemail_server",$SSactive_voicemail_server);

  $SSvoicemail_timezones =        $row[18];
  define("SSvoicemail_timezones",$SSvoicemail_timezones);

  $SSdefault_voicemail_timezone =     $row[19];
  define("SSdefault_voicemail_timezone",$SSdefault_voicemail_timezone);

  $SSdefault_local_gmt =          $row[20];
  define("SSdefault_local_gmt",$SSdefault_local_gmt);

  $SScampaign_cid_areacodes_enabled =   $row[21];
  define("SScampaign_cid_areacodes_enabled",$SScampaign_cid_areacodes_enabled);

  $SSpllb_grouping_limit =        $row[22];
  define("SSpllb_grouping_limit",$SSpllb_grouping_limit);

  $SSdid_ra_extensions_enabled =      $row[23];
  define("SSdid_ra_extensions_enabled",$SSdid_ra_extensions_enabled);

  $SSexpanded_list_stats =        $row[24];
  define("SSexpanded_list_stats",$SSexpanded_list_stats);

  $SScontacts_enabled =         $row[25];
  define("SScontacts_enabled",$SScontacts_enabled);

  $SSalt_log_server_ip =          $row[26];
  define("SSalt_log_server_ip",$SSalt_log_server_ip);

  $SSalt_log_dbname =           $row[27];
  define("SSalt_log_dbname",$SSalt_log_dbname);

  $SSalt_log_login =            $row[28];
  define("SSalt_log_login",$SSalt_log_login);

  $SSalt_log_pass =           $row[29];
  define("SSalt_log_pass",$SSalt_log_pass);

  $SStables_use_alt_log_db =        $row[30];
  define("SStables_use_alt_log_db",$SStables_use_alt_log_db);

  $SScall_menu_qualify_enabled =      $row[31];
  define("SScall_menu_qualify_enabled",$SScall_menu_qualify_enabled);

  $SSadmin_list_counts =          $row[32];
  define("SSadmin_list_counts",$SSadmin_list_counts);

  $SSallow_voicemail_greeting =     $row[33];
  define("SSallow_voicemail_greeting",$SSallow_voicemail_greeting);

  $SSsvn_revision =           $row[34];
  define("SSsvn_revision",$SSsvn_revision);

  $SSallow_emails =           $row[35];
  define("SSallow_emails",$SSallow_emails);  

  $SSlevel_8_disable_add =        $row[36];
  define("SSlevel_8_disable_add",$SSlevel_8_disable_add);

  $SSpass_key =             $row[37];
  define("SSpass_key",$SSpass_key);

  $SSpass_hash_enabled =          $row[38];
  define("SSpass_hash_enabled",$SSpass_hash_enabled);

  $SSdisable_auto_dial =          $row[39];
  define("SSdisable_auto_dial",$SSdisable_auto_dial);

  $SScountry_code_list_stats =      $row[40];
  define("SScountry_code_list_stats",$SScountry_code_list_stats);

  $SSfrozen_server_call_clear =     $row[41];
  define("SSfrozen_server_call_clear",$SSfrozen_server_call_clear);

  $SSactive_modules =           $row[42];
  define("SSactive_modules",$SSactive_modules);

  $SSallow_chats =            $row[43];
  define("SSallow_chats",$SSallow_chats);

  $SSenable_languages =         $row[44];
  define("SSenable_languages",$SSenable_languages);

  $SSlanguage_method =          $row[45];
  define("SSlanguage_method",$SSlanguage_method);

  $SSmeetme_enter_login_filename =    $row[46];
  define("SSmeetme_enter_login_filename",$SSmeetme_enter_login_filename);

  $SSmeetme_enter_leave3way_filename =  $row[47];
  define("SSmeetme_enter_leave3way_filename",$SSmeetme_enter_leave3way_filename);

  $SSenable_did_entry_list_id =     $row[48];
  define("SSenable_did_entry_list_id",$SSenable_did_entry_list_id);

  $SSenable_third_webform =       $row[49];
  define("SSenable_third_webform",$SSenable_third_webform);

  $SSdefault_language =         $row[50];
  define("SSdefault_language",$SSdefault_language);

  $SSuser_hide_realtime_enabled =     $row[51];
  define("SSuser_hide_realtime_enabled",$SSuser_hide_realtime_enabled);

  $SSlog_recording_access =       $row[52];
  define("SSlog_recording_access",$SSlog_recording_access);

  $SSalt_ivr_logging =          $row[53];
  define("SSalt_ivr_logging",$SSalt_ivr_logging);

  $SSadmin_row_click =          $row[54];
  define("SSadmin_row_click",$SSadmin_row_click);

  $SSadmin_screen_colors =        $row[55];
  define("SSadmin_screen_colors",$SSadmin_screen_colors);

  $SSofcom_uk_drop_calc =         $row[56];
  define("SSofcom_uk_drop_calc",$SSofcom_uk_drop_calc);

  $SSagent_screen_colors =        $row[57];
  define("SSagent_screen_colors",$SSagent_screen_colors);

  $SSscript_remove_js =         $row[58];
  define("SSscript_remove_js",$SSscript_remove_js);

  $SSmanual_auto_next =         $row[59];
  define("SSmanual_auto_next",$SSmanual_auto_next);

  $SSuser_new_lead_limit =        $row[60];
  define("SSuser_new_lead_limit",$SSuser_new_lead_limit);

  $SSagent_xfer_park_3way =       $row[61];
  define("SSagent_xfer_park_3way",$SSagent_xfer_park_3way);

  $SSagent_soundboards =          $row[62];
  define("SSagent_soundboards",$SSagent_soundboards);

  $SSweb_loader_phone_length =      $row[63];
  define("SSweb_loader_phone_length",$SSweb_loader_phone_length);

  $SSagent_script =           $row[64];
  define("SSagent_script",$SSagent_script);

  $SSenable_auto_reports =        $row[65];
  define("SSenable_auto_reports",$SSenable_auto_reports);

  $SSenable_pause_code_limits =     $row[66];
  define("SSenable_pause_code_limits",$SSenable_pause_code_limits);

  $SSenable_drop_lists =          $row[67];
  define("SSenable_drop_lists",$SSenable_drop_lists);

  $SSallow_ip_lists =           $row[68];
  define("SSallow_ip_lists",$SSallow_ip_lists);

  $SSsystem_ip_blacklist =        $row[69];
  define("SSsystem_ip_blacklist",$SSsystem_ip_blacklist);

  $SShide_inactive_lists =        $row[70];
  define("SShide_inactive_lists",$SShide_inactive_lists);

  $SSallow_manage_active_lists =      $row[71];
  define("SSallow_manage_active_lists",$SSallow_manage_active_lists);

  $SSexpired_lists_inactive =       $row[72];
  define("SSexpired_lists_inactive",$SSexpired_lists_inactive);

  $SSdid_system_filter =          $row[73];
  define("SSdid_system_filter",$SSdid_system_filter);

  $SSenable_gdpr_download_deletion =    $row[74];
  define("SSenable_gdpr_download_deletion",$SSenable_gdpr_download_deletion);

  $SSmute_recordings =          $row[75];
  define("SSmute_recordings",$SSmute_recordings);

  $SSuser_admin_redirect =        $row[76];
  define("SSuser_admin_redirect",$SSuser_admin_redirect);

  $SSlist_status_modification_confirmation =  $row[77];
  define("SSlist_status_modification_confirmation",$SSlist_status_modification_confirmation);

  $SSsip_event_logging =          $row[78];
  define("SSsip_event_logging",$SSsip_event_logging);

  $SScall_quota_lead_ranking =      $row[79];
  define("SScall_quota_lead_ranking",$SScall_quota_lead_ranking);

  $SSauto_dial_limit =      $row[80];
  define("SSauto_dial_limit",$SSauto_dial_limit);


  $SSenable_second_script =      $row[81];
  define("SSenable_second_script",$SSenable_second_script);

  
  }

$stmt="SELECT user_id,user,pass,full_name,user_level,user_group,phone_login,phone_pass,delete_users,delete_user_groups,delete_lists,delete_campaigns,delete_ingroups,delete_remote_agents,load_leads,campaign_detail,ast_admin_access,ast_delete_phones,delete_scripts,modify_leads,hotkeys_active,change_agent_campaign,agent_choose_ingroups,closer_campaigns,scheduled_callbacks,agentonly_callbacks,agentcall_manual,vicidial_recording,vicidial_transfers,delete_filters,alter_agent_interface_options,closer_default_blended,delete_call_times,modify_call_times,modify_users,modify_campaigns,modify_lists,modify_scripts,modify_filters,modify_ingroups,modify_usergroups,modify_remoteagents,modify_servers,view_reports,vicidial_recording_override,alter_custdata_override,qc_enabled,qc_user_level,qc_pass,qc_finish,qc_commit,add_timeclock_log,modify_timeclock_log,delete_timeclock_log,alter_custphone_override,vdc_agent_api_access,modify_inbound_dids,delete_inbound_dids,active,alert_enabled,download_lists,agent_shift_enforcement_override,manager_shift_enforcement_override,shift_override_flag,export_reports,delete_from_dnc,email,user_code,territory,allow_alerts,callcard_admin,force_change_password,modify_shifts,modify_phones,modify_carriers,modify_labels,modify_statuses,modify_voicemail,modify_audiostore,modify_moh,modify_tts,modify_contacts,modify_same_user_level,alter_admin_interface_options,modify_custom_dialplans,modify_languages,selected_language,user_choose_language,modify_colors,api_only_user,modify_auto_reports,modify_ip_lists,export_gdpr_leads from vicidial_users where user='$username';";

$rslt=mysqli_query($this->link,$stmt);
$row=mysqli_fetch_row($rslt);

$LOGuser_id= $row[0];
define("LOGuser_id",$LOGuser_id);

$LOGuser= $row[1];
define("LOGuser",$LOGuser);

$LOGpass= $row[2];
define("LOGpass",$LOGpass);

$LOGfull_name       =$row[3];
define("LOGfull_name",$LOGfull_name);

$LOGuser_level        =$row[4];
define("LOGuser_level",$LOGuser_level);

$LOGuser_group        =$row[5];
define("LOGuser_group",$LOGuser_group);

$LOGdelete_users      =$row[8];
define("LOGdelete_users",$LOGdelete_users);

$LOGdelete_user_groups    =$row[9];
define("LOGdelete_user_groups",$LOGdelete_user_groups);

$LOGdelete_lists      =$row[10];
define("LOGdelete_lists",$LOGdelete_lists);

$LOGdelete_campaigns    =$row[11];
define("LOGdelete_campaigns",$LOGdelete_campaigns);

$LOGdelete_ingroups     =$row[12];
define("LOGdelete_ingroups",$LOGdelete_ingroups);

$LOGdelete_remote_agents  =$row[13];
define("LOGdelete_remote_agents",$LOGdelete_remote_agents);

$LOGload_leads        =$row[14];
define("LOGload_leads",$LOGload_leads);

$LOGcampaign_detail     =$row[15];
define("LOGcampaign_detail",$LOGcampaign_detail);

$LOGast_admin_access    =$row[16];
define("LOGast_admin_access",$LOGast_admin_access);

$LOGast_delete_phones   =$row[17];
define("LOGast_delete_phones",$LOGast_delete_phones);

$LOGdelete_scripts      =$row[18];
define("LOGdelete_scripts",$LOGdelete_scripts);

$LOGmodify_leads      =$row[19];
define("LOGmodify_leads",$LOGmodify_leads);

$LOGdelete_filters      =$row[29];
define("LOGdelete_filters",$LOGdelete_filters);

$LOGalter_agent_interface =$row[30];
define("LOGalter_agent_interface",$LOGalter_agent_interface);

$LOGdelete_call_times   =$row[32];
define("LOGdelete_call_times",$LOGdelete_call_times);

$LOGmodify_call_times   =$row[33];
define("LOGmodify_call_times",$LOGmodify_call_times);

$LOGmodify_users      =$row[34];
define("LOGmodify_users",$LOGmodify_users);

$LOGmodify_campaigns    =$row[35];
define("LOGmodify_campaigns",$LOGmodify_campaigns);

$LOGmodify_lists      =$row[36];
define("LOGmodify_lists",$LOGmodify_lists);

$LOGmodify_scripts      =$row[37];
define("LOGmodify_scripts",$LOGmodify_scripts);

$LOGmodify_filters      =$row[38];
define("LOGmodify_filters",$LOGmodify_filters);

$LOGmodify_ingroups     =$row[39];
define("LOGmodify_ingroups",$LOGmodify_ingroups);

$LOGmodify_usergroups   =$row[40];
define("LOGmodify_usergroups",$LOGmodify_usergroups);

$LOGmodify_remoteagents   =$row[41];
define("LOGmodify_remoteagents",$LOGmodify_remoteagents);

$LOGmodify_servers      =$row[42];
define("LOGmodify_servers",$LOGmodify_servers);

$LOGview_reports      =$row[43];
define("LOGview_reports",$LOGview_reports);

$LOGmodify_dids       =$row[56];
define("LOGmodify_dids",$LOGmodify_dids);

$LOGdelete_dids       =$row[57];
define("LOGdelete_dids",$LOGdelete_dids);

$LOGmanager_shift_enforcement_override=$row[61];
define("LOGmanager_shift_enforcement_override",$LOGmanager_shift_enforcement_override);

$LOGexport_reports      =$row[64];
define("LOGexport_reports",$LOGexport_reports);

$LOGdelete_from_dnc     =$row[65];
define("LOGdelete_from_dnc",$LOGdelete_from_dnc);

$LOGcallcard_admin      =$row[70];
define("LOGcallcard_admin",$LOGcallcard_admin);

$LOGforce_change_password =$row[71];
define("LOGforce_change_password",$LOGforce_change_password);

$LOGmodify_shifts     =$row[72];
define("LOGmodify_shifts",$LOGmodify_shifts);

$LOGmodify_phones     =$row[73];
define("LOGmodify_phones",$LOGmodify_phones);

$LOGmodify_carriers     =$row[74];
define("LOGmodify_carriers",$LOGmodify_carriers);

$LOGmodify_labels     =$row[75];
define("LOGmodify_labels",$LOGmodify_labels);

$LOGmodify_statuses     =$row[76];
define("LOGmodify_statuses",$LOGmodify_statuses);

$LOGmodify_voicemail    =$row[77];
define("LOGmodify_voicemail",$LOGmodify_voicemail);

$LOGmodify_audiostore   =$row[78];
define("LOGmodify_audiostore",$LOGmodify_audiostore);

$LOGmodify_moh        =$row[79];
define("LOGmodify_moh",$LOGmodify_moh);

$LOGmodify_tts        =$row[80];
define("LOGmodify_tts",$LOGmodify_tts);

$LOGmodify_contacts     =$row[81];
define("LOGmodify_contacts",$LOGmodify_contacts);

$LOGmodify_same_user_level  =$row[82];
define("LOGmodify_same_user_level",$LOGmodify_same_user_level);

$LOGalter_admin_interface =$row[83];
define("LOGalter_admin_interface",$LOGalter_admin_interface);

$LOGmodify_custom_dialplans =$row[84];
define("LOGmodify_custom_dialplans",$LOGmodify_custom_dialplans);

$LOGmodify_languages    =$row[85];
define("LOGmodify_languages",$LOGmodify_languages);

$LOGselected_language   =$row[86];
define("LOGselected_language",$LOGselected_language);

$LOGuser_choose_language  =$row[87];
define("LOGuser_choose_language",$LOGuser_choose_language);

$LOGmodify_colors     =$row[88];
define("LOGmodify_colors",$LOGmodify_colors);

$LOGapi_only_user     =$row[89];
define("LOGapi_only_user",$LOGapi_only_user);

$LOGmodify_auto_reports   =$row[90];
define("LOGmodify_auto_reports",$LOGmodify_auto_reports);

$LOGmodify_ip_lists     =$row[91];
define("LOGmodify_ip_lists",$LOGmodify_ip_lists);

$LOGexport_gdpr_leads   =$row[92];
define("LOGexport_gdpr_leads",$LOGexport_gdpr_leads);

$stmt="SELECT allowed_campaigns,allowed_reports,admin_viewable_groups,admin_viewable_call_times,qc_allowed_campaigns,qc_allowed_inbound_groups from vicidial_user_groups where user_group='$LOGuser_group';";
$rslt=mysqli_query($this->link,$stmt);
$row=mysqli_fetch_row($rslt);
$LOGallowed_campaigns =     $row[0];
$LOGallowed_reports =     $row[1];
$LOGadmin_viewable_groups =   $row[2];
$LOGadmin_viewable_call_times = $row[3];
$LOGqc_allowed_campaigns =    $row[4];
$LOGqc_allowed_inbound_groups = $row[5];

$LOGallowed_campaignsSQL='';
$campLOGallowed_campaignsSQL='';
$whereLOGallowed_campaignsSQL='';
if ( (!preg_match('/\-ALL/i', $LOGallowed_campaigns)) )
  {
  $rawLOGallowed_campaignsSQL = preg_replace("/ -/",'',$LOGallowed_campaigns);
  $rawLOGallowed_campaignsSQL = preg_replace("/ /","','",$rawLOGallowed_campaignsSQL);
  $LOGallowed_campaignsSQL = "and campaign_id IN('$rawLOGallowed_campaignsSQL')";
  $campLOGallowed_campaignsSQL = "and b.campaign_id IN('$rawLOGallowed_campaignsSQL')";
  $whereLOGallowed_campaignsSQL = "where campaign_id IN('$rawLOGallowed_campaignsSQL')";
  }
$regexLOGallowed_campaigns = " $LOGallowed_campaigns ";




if (preg_match("/DRA/",$SShosted_settings))
  {$LOGmodify_remoteagents=0;}

$admin_viewable_groupsALL=0;
$LOGadmin_viewable_groupsSQL='';
$whereLOGadmin_viewable_groupsSQL='';
$valLOGadmin_viewable_groupsSQL='';
$vmLOGadmin_viewable_groupsSQL='';
if ( (!preg_match('/\-\-ALL\-\-/i',$LOGadmin_viewable_groups)) and (strlen($LOGadmin_viewable_groups) > 3) )
  {
  $rawLOGadmin_viewable_groupsSQL = preg_replace("/ -/",'',$LOGadmin_viewable_groups);
  $rawLOGadmin_viewable_groupsSQL = preg_replace("/ /","','",$rawLOGadmin_viewable_groupsSQL);
  $LOGadmin_viewable_groupsSQL = "and user_group IN('---ALL---','$rawLOGadmin_viewable_groupsSQL')";
  $whereLOGadmin_viewable_groupsSQL = "where user_group IN('---ALL---','$rawLOGadmin_viewable_groupsSQL')";
  $valLOGadmin_viewable_groupsSQL = "and val.user_group IN('---ALL---','$rawLOGadmin_viewable_groupsSQL')";
  $vmLOGadmin_viewable_groupsSQL = "and vm.user_group IN('---ALL---','$rawLOGadmin_viewable_groupsSQL')";
  }
else 
  {$admin_viewable_groupsALL=1;}
$regexLOGadmin_viewable_groups = " $LOGadmin_viewable_groups ";

$LOGadmin_viewable_call_timesSQL='';
$whereLOGadmin_viewable_call_timesSQL='';
if ( (!preg_match('/\-\-ALL\-\-/i', $LOGadmin_viewable_call_times)) and (strlen($LOGadmin_viewable_call_times) > 3) )
  {
  $rawLOGadmin_viewable_call_timesSQL = preg_replace("/ -/",'',$LOGadmin_viewable_call_times);
  $rawLOGadmin_viewable_call_timesSQL = preg_replace("/ /","','",$rawLOGadmin_viewable_call_timesSQL);
  $LOGadmin_viewable_call_timesSQL = "and call_time_id IN('---ALL---','$rawLOGadmin_viewable_call_timesSQL')";
  $whereLOGadmin_viewable_call_timesSQL = "where call_time_id IN('---ALL---','$rawLOGadmin_viewable_call_timesSQL')";
  }
$regexLOGadmin_viewable_call_times = " $LOGadmin_viewable_call_times ";

  

    define('LOGallowed_campaignsSQL', $LOGallowed_campaignsSQL);
    define('LOGadmin_viewable_groupsSQL', $LOGadmin_viewable_groupsSQL);
    //define('rawLOGadmin_viewable_call_timesSQL',"'$rawLOGadmin_viewable_call_timesSQL'");
    #define('LOGuser_level',$LOGuser_level);
    define('whereLOGadmin_viewable_groupsSQL', $whereLOGadmin_viewable_groupsSQL);
    define('whereLOGallowed_campaignsSQL',$whereLOGallowed_campaignsSQL);
    #define('SSauto_dial_limit',$SSauto_dial_limit);
    define('whereLOGadmin_viewable_call_timesSQL',$whereLOGadmin_viewable_call_timesSQL);
    #define('LOGuser_group', $LOGuser_group);
    #define('SSdefault_server_password', $SSdefault_server_password);
    #define('SSdefault_local_gmt', $SSdefault_local_gmt);
    define("campLOGallowed_campaignsSQL", $campLOGallowed_campaignsSQL);
    define("LOGallowed_campaigns",$LOGallowed_campaigns);
    $campaigns=$this->get_active_campaigns();
    define("active_campaigns", $campaigns);

    $campaigns=$this->get_active_ingroups();
    define("ACTIVE_INGROUPS", $campaigns);

    define("admin_viewable_groupsALL",$admin_viewable_groupsALL);
    //$rawLOGallowed_campaignsSQL=rtrim(",'")
    //define("rawLOGallowed_campaignsSQL","'$rawLOGallowed_campaignsSQL'");
    #define("SSdefault_voicemail_timezone",$SSdefault_voicemail_timezone);
    #define("SSactive_voicemail_server",$SSactive_voicemail_server);

    }


    function get_active_calls($campaign_id="",$user_group="")
    {
        if(trim($user_group)=="")
         {  $campaigns=ACTIVE_INGROUPS;
            $sql="select count(*) as calls,DATE_FORMAT(time(now()),\"%r\") as timenow from vicidial_auto_calls where call_type='IN' and status IN('SENT','RINGING','LIVE') and campaign_id IN($campaigns);";
        }else{
            $sql="select count(*) as calls,DATE_FORMAT(time(now()),\"%r\") as timenow from vicidial_auto_calls where call_type='IN' and status IN('SENT','RINGING','LIVE') and campaign_id='$user_group';";
        }
        $query=$this->db->query($sql);
        $result=$query->result_array();
        if(sizeof($result)>0){
            $result_inbound=$result[0];
        }else{
            $result_inbound=array("calls"=>0,"timenow"=>date("h:i A", time()));
        }

        if(trim($campaign_id)=="")
         {  $campaigns=active_campaigns;
            $sql="select count(*) as calls,DATE_FORMAT(time(now()),\"%r\") as timenow from vicidial_auto_calls where call_type='OUT' and status IN('SENT','RINGING','LIVE') and campaign_id IN($campaigns);";
        }else{
            $sql="select count(*) as calls,DATE_FORMAT(time(now()),\"%r\") as timenow from vicidial_auto_calls where call_type='OUT' and status IN('SENT','RINGING','LIVE') and campaign_id='$campaign_id';";
        }
        $query=$this->db->query($sql);
        $result=$query->result_array();
        if(sizeof($result)>0){
            $result_outbound=$result[0];
        }else{
            $result_outbound=array("calls"=>0,"timenow"=>date("h:i A", time()));
        }


        if($campaign_id!=""){
            $sql="SELECT status as dialstatus,count(*) calls from vicidial_log where date(call_date)=date(now()) and campaign_id='$campaign_id' group by dialstatus";
        }else{
            $campaigns=active_campaigns;
            $sql="SELECT status as dialstatus,count(*) calls from vicidial_log where date(call_date)=date(now()) and campaign_id IN($campaigns) group by dialstatus";
        }
        $query=$this->db->query($sql);
        $call_stats=$query->result_array();
        

        $result=array("result_inbound"=>$result_inbound,"result_outbound"=>$result_outbound,"call_stats"=>$call_stats);

        return $result;        
    }


    public function get_active_ingroups(){
       $stmt = "SELECT group_id,group_name FROM vicidial_inbound_groups ".whereLOGadmin_viewable_groupsSQL." ORDER BY group_id;";
       $query=$this->db->query($stmt);
       $result=$query->result_array();
       $campaigns="";
       for($i=0;$i<sizeof($result);$i++){
          $campaigns .= "'".$result[$i]['group_id']."',";
       }
       $campaigns = rtrim($campaigns, ",");
       if(trim($campaigns)==""){
        $campaigns="''";
       }
       return $campaigns;
    }

    public function GetCallMenus(){
      $call_menu_list="<option value=\"\">SELECT SURVEY</option>";
      $stmt="SELECT menu_id,menu_name,menu_prompt,menu_timeout,user_group from vicidial_call_menu ".whereLOGadmin_viewable_groupsSQL." order by menu_id;";
      $rslt=mysqli_query($this->link,$stmt);
      $times_to_print = mysqli_num_rows($rslt);
      $o=0;
      while ($times_to_print > $o)
        {
        $rowx=mysqli_fetch_row($rslt);
        $call_menu_list .= "<option value=\"$rowx[0]\">$rowx[0] - $rowx[1]</option>";
       
        $o++;
        }
      
      return $call_menu_list;
    }    
    
    function _QXZ($text) {
        return $text;
    }
    
    function GetOnlyfilename($filename){
        return pathinfo($filename, PATHINFO_FILENAME);
    }
    
    public function called_leads($lists){
        $stmt="SELECT count(*) as total from vicidial_list where list_id IN($lists) and called_since_last_reset='Y';";
        $query = $this->db->query($stmt)->result_array();
        
        if(sizeof($query)>0){
            $result=$query[0]['total'];
        }else{
            $result=0;
        }        
        return $result;
    }
    
    function camp_lists_reutrn($campaign_id){
    $query="SELECT list_id from vicidial_lists where campaign_id='$campaign_id' and active='Y'";
               
                
                $result=mysqli_query($this->link, $query);
    $resultArray_list=NULL;
    while(($resultArray_list[] = mysqli_fetch_assoc($result)) || array_pop($resultArray_list)); 
    $CL="";
    for($l=0;$l<sizeof($resultArray_list);$l++){
      $CL.="'".$resultArray_list[$l]['list_id']."',";
    }       
    $CL=rtrim($CL,",");
                if($CL==""){
                    $CL="''";
                }
    return $CL;
  }

    function expired_lists($camp_lists)
        {
           if($camp_lists==""){$camp_lists="''";}
     $expired_lists='';
     $REPORTdate = date("Y-m-d");
     $stmt="SELECT list_id FROM vicidial_lists where list_id IN($camp_lists) and (active='Y') and (expiration_date < \"$REPORTdate\");";         
     
           $result=mysqli_query($this->link, $stmt);
           $resultArray=NULL;
     while(($resultArray[] = mysqli_fetch_assoc($result)) || array_pop($resultArray));        
     for($i=0;$i<sizeof($resultArray);$i++){
    $expired_lists.="'".$resultArray[$i]['list_id']."',";
     }
     $expired_lists=rtrim($expired_lists,",");
     if(trim($expired_lists)==""){$expired_lists="''";}
     $EXPsql = "and list_id NOT IN($expired_lists)";
     return $EXPsql;
  }


    function get_list_dialables($campaign_id,$list_id){

          $fSQL = '';
          $dialable_total=0;
          if (SSexpanded_list_stats > 0)
            {           
            $stmt="SELECT dial_statuses,local_call_time,lead_filter_id,drop_lockout_time,call_count_limit from vicidial_campaigns where campaign_id='$campaign_id'";
            $rslt=$this->mysql_to_mysqli($stmt, $this->link);
            $row=mysqli_fetch_row($rslt);
            $dial_statuses =        $row[0];
            $local_call_time =      $row[1];
            $lead_filter_id =       $row[2];
            $drop_lockout_time =    $row[3];
            $call_count_limit =     $row[4];
            $stmt="SELECT lead_filter_sql from vicidial_lead_filters where lead_filter_id='$lead_filter_id'";
            $rslt=$this->mysql_to_mysqli($stmt, $this->Model_lib->link);
            $filters_to_print = mysqli_num_rows($rslt);
            if ($filters_to_print > 0) 
                {
                $rowx=mysqli_fetch_row($rslt);
                $filterSQL = $rowx[0];
                $filterSQL = preg_replace("/\\\\/","",$filterSQL);
                $filterSQL = preg_replace('/^and|and$|^or|or$/i', '',$filterSQL);
                if (strlen($filterSQL)>4)
                    {$fSQL = "and ($filterSQL)";}
                else
                    {$fSQL = '';}
                }
            }
       error_reporting(0); // disable errors  
       $single_status=1;
       $dialable_total=$this->dialable_leads("",$this->link,$local_call_time,$dial_statuses,$list_id,$drop_lockout_time,$call_count_limit,$single_status,$fSQL);
       return $dialable_total;
        

    }
        
    function dialableLeads($local_call_time,$dial_statuses,$camp_lists,$drop_lockout_time,$call_count_limit,$single_status,$fSQL)
    { if (isset($camp_lists))
        {
            if (strlen($camp_lists)>1)
            {
                if (strlen($dial_statuses)>2)
                {
                    $g=0;
                    $p='13';
                    $GMT_gmt[0] = '';
                    $GMT_hour[0] = '';
                    $GMT_day[0] = '';
                    while ($p > -13)
                    {
                        $pzone=3600 * $p;
                        $pmin=(gmdate("i", time() + $pzone));
                        $phour=( (gmdate("G", time() + $pzone)) * 100);
                        $pday=gmdate("w", time() + $pzone);
                        $tz = sprintf("%.2f", $p);
                        $GMT_gmt[$g] = "$tz";
                        $GMT_day[$g] = "$pday";
                        $GMT_hour[$g] = ($phour + $pmin);
                        $p = ($p - 0.25);
                        $g++;
                    }

                    $stmt="SELECT call_time_id,call_time_name,call_time_comments,ct_default_start,ct_default_stop,ct_sunday_start,ct_sunday_stop,ct_monday_start,ct_monday_stop,ct_tuesday_start,ct_tuesday_stop,ct_wednesday_start,ct_wednesday_stop,ct_thursday_start,ct_thursday_stop,ct_friday_start,ct_friday_stop,ct_saturday_start,ct_saturday_stop,ct_state_call_times FROM vicidial_call_times where call_time_id='$local_call_time';";
                    $rslt=mysqli_query($this->link, $stmt);
                    $rowx=mysqli_fetch_row($rslt);
                    $Gct_default_start =  "$rowx[3]";
                    $Gct_default_stop =   "$rowx[4]";
                    $Gct_sunday_start =   "$rowx[5]";
                    $Gct_sunday_stop =    "$rowx[6]";
                    $Gct_monday_start =   "$rowx[7]";
                    $Gct_monday_stop =    "$rowx[8]";
                    $Gct_tuesday_start =  "$rowx[9]";
                    $Gct_tuesday_stop =   "$rowx[10]";
                    $Gct_wednesday_start =  "$rowx[11]";
                    $Gct_wednesday_stop = "$rowx[12]";
                    $Gct_thursday_start = "$rowx[13]";
                    $Gct_thursday_stop =  "$rowx[14]";
                    $Gct_friday_start =   "$rowx[15]";
                    $Gct_friday_stop =    "$rowx[16]";
                    $Gct_saturday_start = "$rowx[17]";
                    $Gct_saturday_stop =  "$rowx[18]";
                    $Gct_state_call_times = "$rowx[19]";
                    $state_rules ='';
                    $ct_states = '';
                    $ct_state_gmt_SQL = '';
                    $ct_srs=0;
                    $b=0;
                    if (strlen($Gct_state_call_times)>2)
                    {
                        $state_rules = explode('|',$Gct_state_call_times);
                        $ct_srs = ((count($state_rules)) - 2);
                    }
                    while($ct_srs >= $b)
                    {
                        if(!isset($state_rules[$b])){
                            $state_rules[$b]=0;
                        }
                        if (strlen($state_rules[$b])>1)
                        {
                            $stmt="SELECT state_call_time_id,state_call_time_state,state_call_time_name,state_call_time_comments,sct_default_start,sct_default_stop,sct_sunday_start,sct_sunday_stop,sct_monday_start,sct_monday_stop,sct_tuesday_start,sct_tuesday_stop,sct_wednesday_start,sct_wednesday_stop,sct_thursday_start,sct_thursday_stop,sct_friday_start,sct_friday_stop,sct_saturday_start,sct_saturday_stop from vicidial_state_call_times where state_call_time_id='$state_rules[$b]';";
                            $rslt=mysqli_query($this->link, $stmt);
                            $row=mysqli_fetch_row($rslt);
                            $Gstate_call_time_id =    "$row[0]";
                            $Gstate_call_time_state = "$row[1]";
                            $Gsct_default_start =   "$row[4]";
                            $Gsct_default_stop =    "$row[5]";
                            $Gsct_sunday_start =    "$row[6]";
                            $Gsct_sunday_stop =     "$row[7]";
                            $Gsct_monday_start =    "$row[8]";
                            $Gsct_monday_stop =     "$row[9]";
                            $Gsct_tuesday_start =   "$row[10]";
                            $Gsct_tuesday_stop =    "$row[11]";
                            $Gsct_wednesday_start =   "$row[12]";
                            $Gsct_wednesday_stop =    "$row[13]";
                            $Gsct_thursday_start =    "$row[14]";
                            $Gsct_thursday_stop =   "$row[15]";
                            $Gsct_friday_start =    "$row[16]";
                            $Gsct_friday_stop =     "$row[17]";
                            $Gsct_saturday_start =    "$row[18]";
                            $Gsct_saturday_stop =   "$row[19]";

                            $ct_states .="'$Gstate_call_time_state',";

                            $r=0;
                            $state_gmt='';
                            while($r < $g)
                            {
                                if ($GMT_day[$r]==0)  #### Sunday local time
                                {
                                    if (($Gsct_sunday_start==0) and ($Gsct_sunday_stop==0))
                                    {
                                        if ( ($GMT_hour[$r]>=$Gsct_default_start) and ($GMT_hour[$r]<$Gsct_default_stop) )
                                        {$state_gmt.="'$GMT_gmt[$r]',";}
                                    }
                                    else
                                    {
                                        if ( ($GMT_hour[$r]>=$Gsct_sunday_start) and ($GMT_hour[$r]<$Gsct_sunday_stop) )
                                        {$state_gmt.="'$GMT_gmt[$r]',";}
                                    }
                                }
                                if ($GMT_day[$r]==1)  #### Monday local time
                                {
                                    if (($Gsct_monday_start==0) and ($Gsct_monday_stop==0))
                                    {
                                        if ( ($GMT_hour[$r]>=$Gsct_default_start) and ($GMT_hour[$r]<$Gsct_default_stop) )
                                        {$state_gmt.="'$GMT_gmt[$r]',";}
                                    }
                                    else
                                    {
                                        if ( ($GMT_hour[$r]>=$Gsct_monday_start) and ($GMT_hour[$r]<$Gsct_monday_stop) )
                                        {$state_gmt.="'$GMT_gmt[$r]',";}
                                    }
                                }
                                if ($GMT_day[$r]==2)  #### Tuesday local time
                                {
                                    if (($Gsct_tuesday_start==0) and ($Gsct_tuesday_stop==0))
                                    {
                                        if ( ($GMT_hour[$r]>=$Gsct_default_start) and ($GMT_hour[$r]<$Gsct_default_stop) )
                                        {$state_gmt.="'$GMT_gmt[$r]',";}
                                    }
                                    else
                                    {
                                        if ( ($GMT_hour[$r]>=$Gsct_tuesday_start) and ($GMT_hour[$r]<$Gsct_tuesday_stop) )
                                        {$state_gmt.="'$GMT_gmt[$r]',";}
                                    }
                                }
                                if ($GMT_day[$r]==3)  #### Wednesday local time
                                {
                                    if (($Gsct_wednesday_start==0) and ($Gsct_wednesday_stop==0))
                                    {
                                        if ( ($GMT_hour[$r]>=$Gsct_default_start) and ($GMT_hour[$r]<$Gsct_default_stop) )
                                        {$state_gmt.="'$GMT_gmt[$r]',";}
                                    }
                                    else
                                    {
                                        if ( ($GMT_hour[$r]>=$Gsct_wednesday_start) and ($GMT_hour[$r]<$Gsct_wednesday_stop) )
                                        {$state_gmt.="'$GMT_gmt[$r]',";}
                                    }
                                }
                                if ($GMT_day[$r]==4)  #### Thursday local time
                                {
                                    if (($Gsct_thursday_start==0) and ($Gsct_thursday_stop==0))
                                    {
                                        if ( ($GMT_hour[$r]>=$Gsct_default_start) and ($GMT_hour[$r]<$Gsct_default_stop) )
                                        {$state_gmt.="'$GMT_gmt[$r]',";}
                                    }
                                    else
                                    {
                                        if ( ($GMT_hour[$r]>=$Gsct_thursday_start) and ($GMT_hour[$r]<$Gsct_thursday_stop) )
                                        {$state_gmt.="'$GMT_gmt[$r]',";}
                                    }
                                }
                                if ($GMT_day[$r]==5)  #### Friday local time
                                {
                                    if (($Gsct_friday_start==0) and ($Gsct_friday_stop==0))
                                    {
                                        if ( ($GMT_hour[$r]>=$Gsct_default_start) and ($GMT_hour[$r]<$Gsct_default_stop) )
                                        {$state_gmt.="'$GMT_gmt[$r]',";}
                                    }
                                    else
                                    {
                                        if ( ($GMT_hour[$r]>=$Gsct_friday_start) and ($GMT_hour[$r]<$Gsct_friday_stop) )
                                        {$state_gmt.="'$GMT_gmt[$r]',";}
                                    }
                                }
                                if ($GMT_day[$r]==6)  #### Saturday local time
                                {
                                    if (($Gsct_saturday_start==0) and ($Gsct_saturday_stop==0))
                                    {
                                        if ( ($GMT_hour[$r]>=$Gsct_default_start) and ($GMT_hour[$r]<$Gsct_default_stop) )
                                        {$state_gmt.="'$GMT_gmt[$r]',";}
                                    }
                                    else
                                    {
                                        if ( ($GMT_hour[$r]>=$Gsct_saturday_start) and ($GMT_hour[$r]<$Gsct_saturday_stop) )
                                        {$state_gmt.="'$GMT_gmt[$r]',";}
                                    }
                                }
                                $r++;
                            }
                            $state_gmt = "$state_gmt'99'";
                            $ct_state_gmt_SQL .= "or (state='$Gstate_call_time_state' and gmt_offset_now IN($state_gmt)) ";
                        }

                        $b++;
                    }
                    if (strlen($ct_states)>2)
                    {
                        $ct_states = preg_replace('/,$/i', '',$ct_states);
                        $ct_statesSQL = "and state NOT IN($ct_states)";
                    }
                    else
                    {
                        $ct_statesSQL = "";
                    }

                    $r=0;
                    $default_gmt='';
                    while($r < $g)
                    {
                        if ($GMT_day[$r]==0)  #### Sunday local time
                        {
                            if (($Gct_sunday_start==0) and ($Gct_sunday_stop==0))
                            {
                                if ( ($GMT_hour[$r]>=$Gct_default_start) and ($GMT_hour[$r]<$Gct_default_stop) )
                                {$default_gmt.="'$GMT_gmt[$r]',";}
                            }
                            else
                            {
                                if ( ($GMT_hour[$r]>=$Gct_sunday_start) and ($GMT_hour[$r]<$Gct_sunday_stop) )
                                {$default_gmt.="'$GMT_gmt[$r]',";}
                            }
                        }
                        if ($GMT_day[$r]==1)  #### Monday local time
                        {
                            if (($Gct_monday_start==0) and ($Gct_monday_stop==0))
                            {
                                if ( ($GMT_hour[$r]>=$Gct_default_start) and ($GMT_hour[$r]<$Gct_default_stop) )
                                {$default_gmt.="'$GMT_gmt[$r]',";}
                            }
                            else
                            {
                                if ( ($GMT_hour[$r]>=$Gct_monday_start) and ($GMT_hour[$r]<$Gct_monday_stop) )
                                {$default_gmt.="'$GMT_gmt[$r]',";}
                            }
                        }
                        if ($GMT_day[$r]==2)  #### Tuesday local time
                        {
                            if (($Gct_tuesday_start==0) and ($Gct_tuesday_stop==0))
                            {
                                if ( ($GMT_hour[$r]>=$Gct_default_start) and ($GMT_hour[$r]<$Gct_default_stop) )
                                {$default_gmt.="'$GMT_gmt[$r]',";}
                            }
                            else
                            {
                                if ( ($GMT_hour[$r]>=$Gct_tuesday_start) and ($GMT_hour[$r]<$Gct_tuesday_stop) )
                                {$default_gmt.="'$GMT_gmt[$r]',";}
                            }
                        }
                        if ($GMT_day[$r]==3)  #### Wednesday local time
                        {
                            if (($Gct_wednesday_start==0) and ($Gct_wednesday_stop==0))
                            {
                                if ( ($GMT_hour[$r]>=$Gct_default_start) and ($GMT_hour[$r]<$Gct_default_stop) )
                                {$default_gmt.="'$GMT_gmt[$r]',";}
                            }
                            else
                            {
                                if ( ($GMT_hour[$r]>=$Gct_wednesday_start) and ($GMT_hour[$r]<$Gct_wednesday_stop) )
                                {$default_gmt.="'$GMT_gmt[$r]',";}
                            }
                        }
                        if ($GMT_day[$r]==4)  #### Thursday local time
                        {
                            if (($Gct_thursday_start==0) and ($Gct_thursday_stop==0))
                            {
                                if ( ($GMT_hour[$r]>=$Gct_default_start) and ($GMT_hour[$r]<$Gct_default_stop) )
                                {$default_gmt.="'$GMT_gmt[$r]',";}
                            }
                            else
                            {
                                if ( ($GMT_hour[$r]>=$Gct_thursday_start) and ($GMT_hour[$r]<$Gct_thursday_stop) )
                                {$default_gmt.="'$GMT_gmt[$r]',";}
                            }
                        }
                        if ($GMT_day[$r]==5)  #### Friday local time
                        {
                            if (($Gct_friday_start==0) and ($Gct_friday_stop==0))
                            {
                                if ( ($GMT_hour[$r]>=$Gct_default_start) and ($GMT_hour[$r]<$Gct_default_stop) )
                                {$default_gmt.="'$GMT_gmt[$r]',";}
                            }
                            else
                            {
                                if ( ($GMT_hour[$r]>=$Gct_friday_start) and ($GMT_hour[$r]<$Gct_friday_stop) )
                                {$default_gmt.="'$GMT_gmt[$r]',";}
                            }
                        }
                        if ($GMT_day[$r]==6)  #### Saturday local time
                        {
                            if (($Gct_saturday_start==0) and ($Gct_saturday_stop==0))
                            {
                                if ( ($GMT_hour[$r]>=$Gct_default_start) and ($GMT_hour[$r]<$Gct_default_stop) )
                                {$default_gmt.="'$GMT_gmt[$r]',";}
                            }
                            else
                            {
                                if ( ($GMT_hour[$r]>=$Gct_saturday_start) and ($GMT_hour[$r]<$Gct_saturday_stop) )
                                {$default_gmt.="'$GMT_gmt[$r]',";}
                            }
                        }
                        $r++;
                    }

                    $default_gmt = "$default_gmt'99'";
                    $all_gmtSQL = "(gmt_offset_now IN($default_gmt) $ct_statesSQL) $ct_state_gmt_SQL";

                    $dial_statuses = preg_replace("/ -$/","",$dial_statuses);
                    $Dstatuses = explode(" ", $dial_statuses);
                    $Ds_to_print = (count($Dstatuses) - 0);
                    $Dsql = '';
                    $o=0;
                    while ($Ds_to_print > $o)
                    {
                        $o++;
                        if(!isset($Dstatuses[$o])){
                            $Dstatuses[$o]='';
                        }
                        $Dsql .= "'$Dstatuses[$o]',";
                    }
                    $Dsql = preg_replace("/,$/","",$Dsql);
                    if (strlen($Dsql) < 2) {$Dsql = "''";}

                    $DLTsql='';
                    if ($drop_lockout_time > 0)
                    {
                        $DLseconds = ($drop_lockout_time * 3600);
                        $DLseconds = floor($DLseconds);
                        $DLseconds = intval("$DLseconds");
                        $DLTsql = "and ( ( (status IN('DROP','XDROP')) and (last_local_call_time < CONCAT(DATE_ADD(NOW(), INTERVAL -$DLseconds SECOND),' ',CURTIME()) ) ) or (status NOT IN('DROP','XDROP')) )";
                    }

                    $CCLsql='';
                    if ($call_count_limit > 0)
                    {
                        $CCLsql = "and (called_count < $call_count_limit)";
                    }

                    $EXPsql='';
                    $expired_lists='';
                    $REPORTdate = date("Y-m-d");
                    $stmt="SELECT list_id FROM vicidial_lists where list_id IN($camp_lists) and (active='Y') and (expiration_date < \"$REPORTdate\");";
                    #$DB=1;
                    
                    $rslt=mysqli_query($this->link, $stmt);
                    $rslt_rows = mysqli_num_rows($rslt);
                    $f=0;
                    while ($rslt_rows > $f)
                    {
                        $rowx=mysqli_fetch_row($rslt);
                        $expired_lists .= "'$rowx[0]',";
                        $f++;
                    }
                    $expired_lists = preg_replace("/,$/",'',$expired_lists);
                    if (strlen($expired_lists) < 2) {$expired_lists = "''";}
                    $EXPsql = "and list_id NOT IN($expired_lists)";
$stmt="SELECT count(*) FROM vicidial_list where called_since_last_reset='N' and status IN($Dsql) and list_id IN($camp_lists) and ($all_gmtSQL) $CCLsql $DLTsql $fSQL $EXPsql";
                    #$DB=1;
                  
                    $rslt=mysqli_query($this->link, $stmt);
                    $rslt_rows = mysqli_num_rows($rslt);
                    if ($rslt_rows)
                    {
                        $rowx=mysqli_fetch_row($rslt);
                        $active_leads = "$rowx[0]";
                    }
                    else {$active_leads = '0';}

                    
                    if ($single_status > 0)
                    {return $active_leads;}
                    else
                    {return $active_leads;}
                }
                else
                {
                    return 0;
                }
            }
            else
            {
                return 0;
            }
        }
        else
        {
            return 0;
        }
    }
    
    
    function avilable_hoper_leads($campaign_id){
            if(trim($campaign_id)=="")
            {
                return "0";
            }
            $stmt="SELECT count(*) FROM vicidial_hopper where campaign_id='$campaign_id' ". LOGallowed_campaignsSQL. " and status IN('READY');";
      
      $rslt=mysqli_query($this->link, $stmt);
      $rowx=mysqli_fetch_row($rslt);
      $hopper_leads = "$rowx[0]";
                        
                        return $hopper_leads;
        }

    function GetCampaignHopper($campaign_id){

        $PHP_AUTH_USER=$this->session->userdata('username');
        $stmt="SELECT full_name,user_group,admin_hide_lead_data,admin_hide_phone_data from vicidial_users where user='$PHP_AUTH_USER';";
        $rslt=$this->Model_lib->mysql_to_mysqli($stmt, $this->Model_lib->link);
        $row=mysqli_fetch_row($rslt);
        $LOGfullname =              $row[0];
        $LOGuser_group =            $row[1];
        $LOGadmin_hide_lead_data =  $row[2];
        $LOGadmin_hide_phone_data = $row[3];


        $NOW_DATE = date("Y-m-d");
        $NOW_TIME = date("Y-m-d H:i:s");
        $STARTtime = date("U");
        if (!isset($group)) {$group = '';}
        if (!isset($query_date)) {$query_date = $NOW_DATE;}
        if (!isset($server_ip)) {$server_ip = '10.10.10.15';}
        $isdst = date("I");

        ### Grab Server GMT value from the database
        $SERVER_GMT=-5;
        $stmt="SELECT local_gmt FROM servers where active='Y' limit 1;";
        $rslt=$this->Model_lib->mysql_to_mysqli($stmt, $this->Model_lib->link);
        $gmt_recs = mysqli_num_rows($rslt);
        if ($gmt_recs > 0)
            {
            $row=mysqli_fetch_row($rslt);
            $DBSERVER_GMT       =       $row[0];
            if (strlen($DBSERVER_GMT)>0)    {$SERVER_GMT = $DBSERVER_GMT;}
            if ($isdst) {$SERVER_GMT++;} 
            }
        else
            {
            $SERVER_GMT = date("O");
            $SERVER_GMT = preg_replace("/\+/i","",$SERVER_GMT);
            $SERVER_GMT = ($SERVER_GMT + 0);
            $SERVER_GMT = ($SERVER_GMT / 100);
            }

       $stmt="select vicidial_hopper.lead_id,phone_number,vicidial_hopper.state,vicidial_list.status,called_count,vicidial_hopper.gmt_offset_now,hopper_id,alt_dial,vicidial_hopper.list_id,vicidial_hopper.priority,vicidial_hopper.source,vicidial_hopper.vendor_lead_code, phone_code,UNIX_TIMESTAMP(entry_date),UNIX_TIMESTAMP(last_local_call_time),source_id,vicidial_list.rank from vicidial_hopper,vicidial_list where vicidial_hopper.campaign_id='" . mysqli_real_escape_string($this->Model_lib->link, $campaign_id) . "' and vicidial_hopper.status='READY' and vicidial_hopper.lead_id=vicidial_list.lead_id order by priority desc,hopper_id limit 5000;";

            $rslt=$this->Model_lib->mysql_to_mysqli($stmt, $this->Model_lib->link);
           
            $users_to_print = mysqli_num_rows($rslt);
            $i=0;
            
            while ($i < $users_to_print)
        {
        $row=mysqli_fetch_row($rslt);

        if ($LOGadmin_hide_phone_data != '0')
            {
            
            $phone_temp = $row[1];
            if (strlen($phone_temp) > 0)
                {
                if ($LOGadmin_hide_phone_data == '4_DIGITS')
                    {$row[1] = str_repeat("X", (strlen($phone_temp) - 4)) . substr($phone_temp,-4,4);}
                elseif ($LOGadmin_hide_phone_data == '3_DIGITS')
                    {$row[1] = str_repeat("X", (strlen($phone_temp) - 3)) . substr($phone_temp,-3,3);}
                elseif ($LOGadmin_hide_phone_data == '2_DIGITS')
                    {$row[1] = str_repeat("X", (strlen($phone_temp) - 2)) . substr($phone_temp,-2,2);}
                else
                    {$row[1] = preg_replace("/./",'X',$phone_temp);}
                }
            }
        if ($LOGadmin_hide_lead_data != '0')
            {
            
            if (strlen($row[2]) > 0)
                {$state_temp = $row[2];   $row[2] = preg_replace("/./",'X',$state_temp);}
            if (strlen($row[11]) > 0)
                {$vlc_temp = $row[11];   $row[11] = preg_replace("/./",'X',$vlc_temp);}
            }

        $FMT_i =        $i;
        $lead_id =      $row[0];
        $lead_id_ns =   $row[0];
        $phone_number = $row[1];
        $state =        $row[2];
        $status =       $row[3];
        $count =        $row[4];
        $gmt =          $row[5];
        $hopper_id =    $row[6];
        $alt_dial =     $row[7];
        $list_id =      $row[8];
        $list_id_ns =   $row[8];
        $priority =     $row[9];
        $source =       $row[10];
        $vendor_lead_code = $row[11];
        $phone_code =       $row[12];
        $entry_epoch =      $row[13];
        $last_call_epoch =  $row[14];
        $source_id_TEXT =   $row[15];
        $rank =         $row[16];

        $lead_age = intval(($STARTtime - $entry_epoch) / 86400);
        $lead_age =     sprintf("%-8s", $lead_age);

        $lead_offset = ($gmt - $SERVER_GMT);
        if (($lead_offset > 0) or ($lead_offset < 0))
            {$lead_offset = ($lead_offset * 3600);}
        $last_call_epoch = ($last_call_epoch + $lead_offset);
        $last_call_age = intval(($STARTtime - $last_call_epoch) / 3600);
        
        if ($last_call_age < 24)
            {
            $last_call_age_TEXT = $last_call_age." ".$this->Model_lib->_QXZ("HOURS",6);
            $last_call_age_TEXT = sprintf("%-9s", $last_call_age_TEXT);
            }
        else
            {
            $last_call_age = intval(($last_call_age) / 24);
            if ($last_call_age < 365)
                {
                $last_call_age_TEXT = $last_call_age." ".$this->Model_lib->_QXZ("DAYS",6);
                $last_call_age_TEXT = sprintf("%-9s", $last_call_age_TEXT);
                }
            else
                {
                $last_call_age = intval(($last_call_age) / 365);
                if ($last_call_age < 30)
                    {
                    $last_call_age_TEXT = $last_call_age." ".$this->Model_lib->_QXZ("YEARS",6);
                    $last_call_age_TEXT = sprintf("%-9s", $last_call_age_TEXT);
                    }
                else
                    {
                    $last_call_age_TEXT = $this->Model_lib->_QXZ("NEVER",9);
                    $last_call_age_TEXT = sprintf("%-9s", $last_call_age_TEXT);
                    }
                }
            }
                echo "<tr>";
                //echo "<td>$FMT_i</td>";
                //echo "<td>$priority</td>";

                $href=base_url('reports')."/modify_lead?lead_id=$lead_id&archive_search=No&archive_log=0";

                echo "<td><a href='$href'>$lead_id</a></td>";
                echo "<td>$list_id</td>";
                echo "<td>$phone_number</td>";
                echo "<td>$phone_code</td>";
                echo "<td>$state</td>";
                echo "<td>$status</td>";
                echo "<td>$count</td>";
                echo "<td>$gmt</td>";
                echo "<td>$rank</td>";
                //echo "<td>$alt_dial</td>";
                //echo "<td>$source</td>";
                //echo "<td>$vendor_lead_code</td>";
                //echo "<td>$source_id_TEXT</td>";
                //echo "<td>$lead_age</td>";
                //echo "<td>$last_call_age_TEXT</td>";
                echo "</tr>";
            

        $i++;
        }
        

    }


    
     function avilable_hoper_leads_in_list($list_id){
            
            $stmt="SELECT count(*) FROM vicidial_hopper where list_id='$list_id' and status IN('READY');";
      
      $rslt=mysqli_query($this->link, $stmt);
      $rowx=mysqli_fetch_row($rslt);
      $hopper_leads = "$rowx[0]";
                        
                        return $hopper_leads;
        }

    function total_leads($campaign_id){
    $leads=0;
                if(trim($campaign_id)==""){
                    return $leads;
                }
                $stmt="SELECT count(vl.lead_id) as leads from vicidial_list vl,vicidial_lists vls where vls.list_id=vl.list_id and vls.active='Y' and vl.status NOT IN('DNCL') and campaign_id='$campaign_id'";                               
                $query=$this->db->query($stmt);
                $array = $query->result_array();
        if(sizeof($array)>0){
          $leads=$array[0]['leads'];
        }                
                return $leads;
        }    
        
    function total_leads_in_list($list_id){
        $leads=0;
                $stmt="SELECT count(lead_id) as leads from vicidial_list where list_id='$list_id'";                               
                $query=$this->db->query($stmt);
                $array = $query->result_array();
        if(sizeof($array)>0){
          $leads=$array[0]['leads'];
        }                
                return $leads;
    }    
    
    function total_leads_in_list_archive($list_id){
        $leads=0;
                $stmt="SELECT count(lead_id) as leads from vicidial_list_archive where list_id='$list_id'";
                $query=$this->db->query($stmt);
                $array = $query->result_array();
        if(sizeof($array)>0){
          $leads=$array[0]['leads'];
        }                
        return $leads;
    }   


    function reset_list($campaign_id,$list_id,$lists=false)
    {     
          if($lists){
            $stmt="SELECT daily_reset_limit,resets_today from vicidial_lists where list_id IN($list_id);";
          }else{
            $stmt="SELECT daily_reset_limit,resets_today from vicidial_lists where list_id='$list_id';";
          }
          
          $rslt=$this->mysql_to_mysqli($stmt, $this->link);
          $row=mysqli_fetch_row($rslt);
          if ( ($row[0] > $row[1]) or ($row[0] < 0) )
            {            

            if($lists){
              $message=$this->_QXZ("Resetting lists called status");
              $stmtB="UPDATE vicidial_lists set resets_today=(resets_today + 1) where list_id IN($list_id);";
            }else{
              $message=$this->_QXZ("Resetting list called status");
              $stmtB="UPDATE vicidial_lists set resets_today=(resets_today + 1) where list_id='$list_id';";
            }

            $rslt=$this->mysql_to_mysqli($stmtB, $this->link);

            

            if($lists){
              $stmtC="UPDATE vicidial_list set called_since_last_reset='N' where list_id IN($list_id);";
            }else{
              $stmtC="UPDATE vicidial_list set called_since_last_reset='N' where list_id='$list_id';";
            }

            $rslt=$this->mysql_to_mysqli($stmtC, $this->link);
            $affected_rowsC = mysqli_affected_rows($this->link);
            $row[1] = ($row[1] + 1);
            ### LOG INSERTION Admin Log Table ###
            $SQL_log = "$stmtB|$stmtC|";
            $SQL_log = preg_replace('/;/', '', $SQL_log);
            $SQL_log = addslashes($SQL_log);
            //$stmt="INSERT INTO vicidial_admin_log set event_date='$SQLdate', user='$PHP_AUTH_USER', ip_address='$ip', event_section='LISTS', event_type='RESET', record_id='$list_id', event_code='ADMIN RESET LIST', event_sql=\"$SQL_log\", event_notes='leads reset: $affected_rowsC  list resets today: $row[1]  limit: $row[0]';";            
            $event_notes="'leads reset: $affected_rowsC  list resets today: $row[1]  limit: $row[0]'";
            $this->AdminLog("LISTS","RESET",$list_id,"ADMIN RESET LIST",$SQL_log,$event_notes);
            $result=array("status"=>true,"message"=>$message);
            }
          else
            {
              
              if($lists)
              {
                $message=$this->_QXZ("Can not reset lists, limit reached");
              }else{
                $message=$this->_QXZ("Can not reset list, limit reached");
              }

              $result=array("status"=>false,"message"=>$message);
            }          

            if($lists)
              {
                $stmtC="DELETE from vicidial_hopper where list_id IN($list_id) and campaign_id='$campaign_id';";
              }else{
                $stmtC="DELETE from vicidial_hopper where list_id='$list_id' and campaign_id='$campaign_id';";
              }

          $rslt=$this->mysql_to_mysqli($stmtC, $this->link);
          return $result;
    }

        
    function DialTextCall($csrf,$userdata) {
        $PHP_AUTH_USER=$userdata['user'];
        $date = date("r");
        $ip = getenv("REMOTE_ADDR");
        $browser = getenv("HTTP_USER_AGENT");
        extract($_POST);
        $SQLdate = date("Y-m-d H:i:s");
        $NOW_TIME=date("Y-m-d H:i:s");
        $STARTtime = date("U");
        $SQLdate = date("Y-m-d H:i:s");
        $REPORTdate = date("Y-m-d");
        $EXPtestdate = date("Ymd");
        $CIDdate = date("mdHis");
        while (strlen($CIDdate) > 9) {$CIDdate = substr("$CIDdate", 1);}

        if (strlen($phone_number) < 4) {
            $msg="NOT PLACED, number too small"." - $phone_number";
            $status=false;
        } else {
            ### insert a new lead in the system with this phone number
            $stmtA = "INSERT INTO vicidial_list SET phone_code='$phone_code',phone_number='$phone_number',list_id='$manual_dial_list_id',status='CTCALL',user='VDAD',called_since_last_reset='Y',entry_date='$SQLdate',last_local_call_time='$SQLdate',called_count='1',first_name='Test',last_name='Call',address1='Test Call',address2='2',address3='3',city='Springfield',state='IL',vendor_lead_code='999999',comments='$campaign_id test call placed $SQLdate',rank='99',owner='Test Outbound Call';";

            $rslt = mysqli_query($this->link, $stmtA);
            $affected_rows = mysqli_affected_rows($this->link);
            $lead_id = mysqli_insert_id($this->link);

            ### LOG INSERTION Admin Log Table, for lead ###
            $SQL_log = "$stmtA|";
            $SQL_log = preg_replace('/;/', '', $SQL_log);
            $SQL_log = addslashes($SQL_log);
            $stmt = "INSERT INTO vicidial_admin_log set event_date='$NOW_TIME', user='$PHP_AUTH_USER', ip_address='$ip', event_section='LEADS', event_type='ADD', record_id='$lead_id', event_code='ADMIN ADD TEST LEAD', event_sql=\"$SQL_log\", event_notes='';";
            $rslt = mysqli_query($this->link, $stmt);

            ### gather list_id overrides
            $stmt = "SELECT campaign_cid_override FROM vicidial_lists where list_id='$manual_dial_list_id' ".LOGallowed_campaignsSQL.";";
            $rslt = mysqli_query($this->link, $stmt);

            $CIDor_ct = mysqli_num_rows($rslt);
            $campaign_cid_override = '';
            if ($CIDor_ct > 0) {
                $row = mysqli_fetch_row($rslt);
                $campaign_cid_override = $row[0];
            }

            ### gather server information
            $stmt = "SELECT asterisk_version,routing_prefix FROM servers where server_ip='$old_server_ip';";
            $rslt = mysqli_query($this->link, $stmt);
            $srv_ct = mysqli_num_rows($rslt);
            $asterisk_version = '';
            $routing_prefix = '';
            if ($srv_ct > 0) {
                $row = mysqli_fetch_row($rslt);
                $asterisk_version = $row[0];
                $routing_prefix = $row[1];
            }

            $CCID_on = 0;
            $CCID = '';
            $local_DEF = 'Local/';
            $local_AMP = '@';
            $Local_out_prefix = '9';
            $Local_dial_timeout = '60';
            if ($dial_timeout > 4) {
                $Local_dial_timeout = $dial_timeout;
            }
            $Local_dial_timeout = ($Local_dial_timeout * 1000);
            if (strlen($dial_prefix) > 0) {
                $Local_out_prefix = "$dial_prefix";
            }
            if (strlen($campaign_vdad_exten) > 0) {
                $VDAD_dial_exten = "$campaign_vdad_exten";
            } else {
                $VDAD_dial_exten = "$SSanswer_transfer_agent";
            }
            $major_version = explode('.', $asterisk_version);
            if ($major_version[0] >= 12) {
                $VDAD_dial_exten = "$routing_prefix$VDAD_dial_exten";
            }
            if (strlen($campaign_cid) > 6) {
                $CCID = "$campaign_cid";
                $CCID_on++;
            }
            if (strlen($campaign_cid_override) > 6) {
                $CCID = "$campaign_cid_override";
                $CCID_on++;
            }
            if (preg_match("/x/", $dial_prefix)) {
                $Local_out_prefix = '';
            }$ext_context="";
            if (strlen($ext_context) < 1) {
                $ext_context = 'default';
            }
            if ($omit_phone_code > 0) {
                $Ndialstring = "$Local_out_prefix$phone_number";
            } else {
                $Ndialstring = "$Local_out_prefix$phone_code$phone_number";
            }

            # generate callerID for unique identifier in xfer_log file
            $PADlead_id = sprintf("%010s", $lead_id);
            while (strlen($PADlead_id) > 10) {
                $PADlead_id = substr("$PADlead_id", 1);
            }
            # Create unique calleridname to track the call: VmddhhmmssLLLLLLLLLL
            $VqueryCID = "V$CIDdate$PADlead_id";

            if ($CCID_on) {
                $CIDstring = "\"$VqueryCID\" <$CCID>";
            } else {
                $CIDstring = "$VqueryCID";
            }

            ### insert a NEW record to the vicidial_manager table to be processed
            $stmtB = "INSERT INTO vicidial_manager(uniqueid,entry_date,status,response,server_ip,channel,action,callerid,cmd_line_b,cmd_line_c,cmd_line_d,cmd_line_e,cmd_line_f,cmd_line_g,cmd_line_h,cmd_line_i,cmd_line_j,cmd_line_k) values('','$SQLdate','NEW','N','$old_server_ip','','Originate','$VqueryCID','Exten: $VDAD_dial_exten','Context: $ext_context','Channel: $local_DEF$Ndialstring$local_AMP$ext_context','Priority: 1','Callerid: $CIDstring','Timeout: $Local_dial_timeout','','','','VDACnote: $campaign_id|$lead_id|$phone_code|$phone_number|OUT|MAIN|99')";
            $rslt = mysqli_query($this->link, $stmtB);
            

            ### insert a SENT record to the vicidial_auto_calls table 
            $stmtC = "INSERT INTO vicidial_auto_calls (server_ip,campaign_id,status,lead_id,callerid,phone_code,phone_number,call_time,call_type,alt_dial,queue_priority) values('$old_server_ip','$campaign_id','SENT','$lead_id','$VqueryCID','$phone_code','$phone_number','$SQLdate','OUT','MAIN','99')";
            $rslt = mysqli_query($this->link, $stmtC);
            $uniqueid = mysqli_insert_id($this->link);
            
            ### insert a record in the vicidial_dial_log table 
            $stmtD = "INSERT INTO vicidial_dial_log SET caller_code='$VqueryCID',lead_id='$lead_id',server_ip='$old_server_ip',call_date='$SQLdate',extension='$VDAD_dial_exten',channel='$local_DEF$Ndialstring$local_AMP$ext_context',timeout='$Local_dial_timeout',outbound_cid='$CIDstring',context='$ext_context';";
            $rslt = mysqli_query($this->link, $stmtD);
            

            ### LOG INSERTION Admin Log Table, for campaign ###
            $SQL_log = "$stmtA|$stmtB|$stmtC|";
            $SQL_log = preg_replace('/;/', '', $SQL_log);
            $SQL_log = addslashes($SQL_log);
            
            $stmt = "INSERT INTO vicidial_admin_log set event_date='$SQLdate', user='$PHP_AUTH_USER', ip_address='$ip', event_section='CAMPAIGNS', event_type='OTHER', record_id='$campaign_id', event_code='ADMIN CAMPAIGN TEST CALL', event_sql=\"$SQL_log\", event_notes='VB';";
            $rslt = mysqli_query($this->link, $stmt);
              
            $msg="PLACED TO ".$phone_code ."" .$phone_number;
            $status=true;
        }
        return array("status"=>$status,"msg"=>$msg,"csrf"=>$csrf);
    }
    
    function ServerRebuildConf()
    {
        $servers=$this->GetServerIP();
        for ($i = 0; $i < sizeof($servers); $i++) {
           $server_data=array('rebuild_conf_files'=>"Y");
           $this->db->where('server_ip', $servers[$i]['server_ip']);
           $this->db->update('servers', $server_data);
        }
    }
    
    function GetLists()
    {
        $stmt="SELECT list_id,list_name,list_description,list_lastcalldate,active,campaign_id,reset_time,DATE_FORMAT(expiration_date,'%Y%m%d'),local_call_time from vicidial_lists where 1=1 ".LOGallowed_campaignsSQL;
        $query = $this->db->query($stmt);
        return $query->result_array();
    }

    function getListsofCampaign($campaign_id="")
    {
        if($campaign_id==""){
          $stmt="SELECT list_id from vicidial_lists where 1=1 ".LOGallowed_campaignsSQL;
        }else{
          $stmt="SELECT list_id from vicidial_lists where campaign_id='$campaign_id'";
        }        
        $query = $this->db->query($stmt);
        $result=$query->result_array();
        $lists="";
        for($i=0;$i<sizeof($result);$i++){
          $lists.="'".$result[$i]['list_id']."',";
        }
        $lists=rtrim($lists,",");
        if(trim($lists)=="")
          {
            $lists="''";
          }
        return $lists;
    }
    
    function getLists_filter(){
        $stmt   = "SELECT list_id,list_name FROM vicidial_lists ".whereLOGallowed_campaignsSQL;
        $rslt   = mysqli_query($this->link,$stmt);
        $values = array();
        while ($row = mysqli_fetch_array($rslt, MYSQLI_ASSOC)) {
            $key = $row['list_id'];
            $values[$key] = trim($key) ."-".trim($row['list_name']);
        }
        return $values;
    }

    function getUsers_filter(){
        $stmt   = "SELECT user,full_name FROM vicidial_users ". whereLOGadmin_viewable_groupsSQL;
        $rslt   = mysqli_query($this->link,$stmt);
        $values = array();
        while ($row = mysqli_fetch_array($rslt, MYSQLI_ASSOC)) {
            $key = $row['user'];
            $values[$key] = trim($key)."-".trim($row['full_name']);
        }
        return $values;
    }

    function getStatus_filter(){
        $stmt   = "SELECT status,status_name from vicidial_statuses;";
        $rslt   = mysqli_query($this->link,$stmt);
        $values = array();
        while ($row = mysqli_fetch_array($rslt, MYSQLI_ASSOC)) {
            $key = $row['status'];
            $values[$key] = trim($key) ."-".trim($row['status_name']);
        }
        return $values;
    }
    
    public function get_gateways($prefix=""){        
      $gateways="<option value=\"\" prefix=\"$prefix\">-NONE-</option>";
      $stmt="SELECT id,name,gateway_id from tbl_gateway ".whereLOGadmin_viewable_groupsSQL ." order by id;";       
      $rslt=mysqli_query($this->link,$stmt);
      $times_to_print = mysqli_num_rows($rslt);
      $o=0;
      $match=false;
      while ($times_to_print > $o)
        {
        $rowx=mysqli_fetch_row($rslt);
        if($prefix==$rowx[2])
        { $match=true;
          $gateways .= "<option SELECTED value=\"$rowx[2]\">$rowx[2] - $rowx[1]</option>";       
        }else{
          $gateways .= "<option value=\"$rowx[2]\">$rowx[2] - $rowx[1]</option>";
        }
        $o++;
        }      

        if(!$match){
          $gateways .= "<option selected value=\"$prefix\">$prefix</option>";
        }

      return $gateways;
  }
  
  function get_status_for_reset($campaign_id)
    {
        $camp_lists=$this->camp_lists_reutrn($campaign_id);       
        $stmt="select status from vicidial_list where list_id IN($camp_lists) and status!='NEW' group by status;";
        $query = $this->db->query($stmt);
        $status=$query->result_array();
        $array=array();
        for($i=0;$i<sizeof($status);$i++){
            $array[]=array("status_code"=>$status[$i]['status'],
            "status_name"=>$this->get_status_name($status[$i]['status']));
        }
        return $array;
    }
    
    function get_status_name($status)
    {
        $stmt="SELECT status_name FROM vicidial_statuses where status='$status' LIMIT 1;";
        $query = $this->db->query($stmt);       
        $result=$query->result_array();       
        if(sizeof($result)>0){
            $status=$result[0]['status_name'];
        }
        return $status;
    } 

    function get_recycle_limit($status,$camp_lists,$RECYCLE_count){
      $recycle_limit=0;
      if (strlen($camp_lists) > 2)
          {
          $stmt="SELECT count(*) from vicidial_list where status='$status' and list_id IN($camp_lists) and called_since_last_reset IN($RECYCLE_count);";
          $rslt=$this->mysql_to_mysqli($stmt, $this->link);
          $counts_to_print = mysqli_num_rows($rslt);
          $recycle_limit=0;
          if ($counts_to_print > 0) 
              {
              $rowxx=mysqli_fetch_row($rslt);
              $recycle_limit = $rowxx[0];
              }
          }
          return $recycle_limit;
    }

    function get_dial_statuses($campaign_id){
        $stmt="SELECT dial_statuses from vicidial_campaigns where campaign_id='$campaign_id';";
        $query = $this->db->query($stmt);       
        $result=$query->result_array();    
        return $result;  
    }
    
    function update_dial_statuses($campaign_id,$status){
                
        $dial_statuses_new=" NEW -";        
        $stmt="UPDATE vicidial_campaigns set dial_statuses='$dial_statuses_new' where campaign_id='$campaign_id';";
  $rslt=mysqli_query($this->link,$stmt);
        
        $stmt="SELECT dial_statuses from vicidial_campaigns where campaign_id='$campaign_id';";
  $rslt=mysqli_query($this->link,$stmt);
  $row=mysqli_fetch_row($rslt);

  if (strlen($row[0])<2) {$row[0] = ' -';}
  $dial_statuses = "$status$row[0]";
  $stmt="UPDATE vicidial_campaigns set dial_statuses='$dial_statuses' where campaign_id='$campaign_id';";
  $rslt=mysqli_query($this->link,$stmt);
                
        $stmt="SELECT list_id from vicidial_lists where campaign_id='$campaign_id'";
        $query = $this->db->query($stmt);
        $result=$query->result_array();
        
        $reset_data=array();
        
        for($i=0;$i<sizeof($result);$i++){
            $list_id=$result[$i]['list_id'];
            $stmtB="UPDATE vicidial_lists set resets_today=(resets_today + 1) where list_id='$list_id';";
            $rslt=mysqli_query($this->link,$stmtB);
            $stmtC="UPDATE vicidial_list set called_since_last_reset='N' where list_id='$list_id';";
            $rslt=mysqli_query($this->link,$stmtC);
            $affected_rowsC = mysqli_affected_rows($this->link);            
            $reset_data[]=array("list_id"=>$list_id,"affected_rows"=>$affected_rowsC);
        }         
        
        return $reset_data;
        
    }
    
    
    function get_carriers_stats($campaign_id=""){
        $lists=$this->getListsofCampaign($campaign_id);
        error_reporting(0);
        $NOW_TIME = date("Y-m-d H:i:s");
$NOW_DAY = date("Y-m-d");
$NOW_HOUR = date("H:i:s");
$STARTtime = date("U");
$epochONEminuteAGO = ($STARTtime - 60);
$timeONEminuteAGO = date("Y-m-d H:i:s",$epochONEminuteAGO);
$epochFIVEminutesAGO = ($STARTtime - 300);
$timeFIVEminutesAGO = date("Y-m-d H:i:s",$epochFIVEminutesAGO);
$epochFIFTEENminutesAGO = ($STARTtime - 900);
$timeFIFTEENminutesAGO = date("Y-m-d H:i:s",$epochFIFTEENminutesAGO);
$epochONEhourAGO = ($STARTtime - 3600);
$timeONEhourAGO = date("Y-m-d H:i:s",$epochONEhourAGO);
$epochSIXhoursAGO = ($STARTtime - 21600);
$timeSIXhoursAGO = date("Y-m-d H:i:s",$epochSIXhoursAGO);
$epochTWENTYFOURhoursAGO = ($STARTtime - 86400);
$timeTWENTYFOURhoursAGO = date("Y-m-d H:i:s",$epochTWENTYFOURhoursAGO);
$DB="";
        $CARRIERstatsHTML='';
        $ONEhour_total="";
        $dialstatuses="";
        $FIVEminute_total="";
        $FTminute_total="";
        $ONEminute_total="";
$TFhour_total="";
$SIXhour_total="";
    $SIXhour_count="";
                //$stmtB="SELECT dialstatus,count(*) from vicidial_carrier_log where call_date >= \"$timeTWENTYFOURhoursAGO\" group by dialstatus;";
                if(trim($campaign_id)==""){
                    $stmtB="SELECT a.dialstatus,count(*) from vicidial_carrier_log a,vicidial_log b where a.lead_id=b.lead_id ".campLOGallowed_campaignsSQL." and  a.call_date >= \"$timeTWENTYFOURhoursAGO\" group by a.dialstatus;";
                }else{
                    $stmtB="SELECT a.dialstatus,count(*) from vicidial_carrier_log a,vicidial_log b where a.lead_id=b.lead_id and b.campaign_id='$campaign_id' and  a.call_date >= \"$timeTWENTYFOURhoursAGO\" group by a.dialstatus;";
                }                              

                $stmtB="SELECT dialstatus,count(*) from vicidial_carrier_log where call_date >= \"$timeTWENTYFOURhoursAGO\" and (select list_id from vicidial_list where lead_id=vicidial_carrier_log.lead_id) in($lists) group by dialstatus;";
                if ($DB > 0) {echo "\n|$stmtB|\n";}
    $rslt=mysqli_query($this->link,$stmtB);
    $car_to_print = mysqli_num_rows($rslt);
    $ctp=0;
    while ($car_to_print > $ctp)
      {
      $row=mysqli_fetch_row($rslt);
      $TFhour_status[$ctp] =  $row[0];
      $TFhour_count[$ctp] = $row[1];
      $TFhour_total+=$row[1];
      $dialstatuses .=    "'$row[0]',";
      $ctp++;
      }
    $dialstatuses = preg_replace("/,$/",'',$dialstatuses);

    
    $CARRIERstatsHTML .= "<TABLE class=\"table table-bordered table-striped table-condensed flip-content\">";
    $CARRIERstatsHTML .= "<theader class=\"flip-content\"><TR>";
    //$CARRIERstatsHTML .= "<TD ALIGN=LEFT>CARRIER STATS: &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; </font></TD>";
    $CARRIERstatsHTML .= "<TH>HANGUP STATUS &nbsp; </font></TD>";
    $CARRIERstatsHTML .= "<TH>24 HOURS</TH>";
    $CARRIERstatsHTML .= "<TH>6 HOURS</TH>";
    $CARRIERstatsHTML .= "<TH>1 HOUR</TH>";
    $CARRIERstatsHTML .= "<TH>15 MIN</TH>";
    $CARRIERstatsHTML .= "<TH>5 MIN</TH>";
    $CARRIERstatsHTML .= "<TH>1 MIN</TH>";
    $CARRIERstatsHTML .= "</TR></theader><tbody>";

    if (strlen($dialstatuses) > 1)
      {
      //$stmtB="SELECT dialstatus,count(*) from vicidial_carrier_log where call_date >= \"$timeSIXhoursAGO\" group by dialstatus;";
      if(trim($campaign_id)==""){
                           $stmtB="SELECT a.dialstatus,count(*) from vicidial_carrier_log a,vicidial_log b where a.lead_id=b.lead_id ".campLOGallowed_campaignsSQL." and  a.call_date >= \"$timeSIXhoursAGO\" group by a.dialstatus;";
                       }else{                            
                           $stmtB="SELECT a.dialstatus,count(*) from vicidial_carrier_log a,vicidial_log b where a.lead_id=b.lead_id and b.campaign_id='$campaign_id' and  a.call_date >= \"$timeSIXhoursAGO\" group by a.dialstatus;";
                       }    
                        
                        $stmtB="SELECT dialstatus,count(*) from vicidial_carrier_log where call_date >= \"$timeSIXhoursAGO\" and (select list_id from vicidial_list where lead_id=vicidial_carrier_log.lead_id) in($lists) group by dialstatus;";
                        if ($DB > 0) {echo "\n|$stmtB|\n";}
      $rslt=mysqli_query($this->link,$stmtB);
      $scar_to_print = mysqli_num_rows($rslt);
      $print_sctp=0;
      while ($scar_to_print > $print_sctp)
        {
        $row=mysqli_fetch_row($rslt);
        $SIXhour_total+=$row[1];
        $print_ctp=0;
        while ($print_ctp < $ctp)
          {
          if ($TFhour_status[$print_ctp] == $row[0])
            {$SIXhour_count[$print_ctp] = $row[1];}
          $print_ctp++;
          }
        $print_sctp++;
        }

      //$stmtB="SELECT dialstatus,count(*) from vicidial_carrier_log where call_date >= \"$timeONEhourAGO\" group by dialstatus;";
      if(trim($campaign_id)==""){
                        $stmtB="SELECT a.dialstatus,count(*) from vicidial_carrier_log a,vicidial_log b where a.lead_id=b.lead_id ".campLOGallowed_campaignsSQL." and  a.call_date >= \"$timeONEhourAGO\" group by a.dialstatus;";
                       }else{
                         $stmtB="SELECT a.dialstatus,count(*) from vicidial_carrier_log a,vicidial_log b where a.lead_id=b.lead_id and b.campaign_id='$campaign_id' and  a.call_date >= \"$timeONEhourAGO\" group by a.dialstatus;";
                       }

                       $stmtB="SELECT dialstatus,count(*) from vicidial_carrier_log where call_date >= \"$timeONEhourAGO\" and (select list_id from vicidial_list where lead_id=vicidial_carrier_log.lead_id) in($lists) group by dialstatus;";
                        if ($DB > 0) {echo "\n|$stmtB|\n";}
      $rslt=mysqli_query($this->link,$stmtB);
      $scar_to_print = mysqli_num_rows($rslt);
      $print_sctp=0;
      while ($scar_to_print > $print_sctp)
        {
        $row=mysqli_fetch_row($rslt);
        $ONEhour_total+=$row[1];
        $print_ctp=0;
        while ($print_ctp < $ctp)
          {
          if ($TFhour_status[$print_ctp] == $row[0])
            {$ONEhour_count[$print_ctp] = $row[1];}
          $print_ctp++;
          }
        $print_sctp++;
        }

      //$stmtB="SELECT dialstatus,count(*) from vicidial_carrier_log where call_date >= \"$timeFIFTEENminutesAGO\" group by dialstatus;";
      if(trim($campaign_id)==""){
                           $stmtB="SELECT a.dialstatus,count(*) from vicidial_carrier_log a,vicidial_log b where a.lead_id=b.lead_id ".campLOGallowed_campaignsSQL." and  a.call_date >= \"$timeFIFTEENminutesAGO\" group by a.dialstatus;";
                       }else{
                           $stmtB="SELECT a.dialstatus,count(*) from vicidial_carrier_log a,vicidial_log b where a.lead_id=b.lead_id and b.campaign_id='$campaign_id' and  a.call_date >= \"$timeFIFTEENminutesAGO\" group by a.dialstatus;";
                       
                       }

                       $stmtB="SELECT dialstatus,count(*) from vicidial_carrier_log where call_date >= \"$timeFIFTEENminutesAGO\" and (select list_id from vicidial_list where lead_id=vicidial_carrier_log.lead_id) in($lists) group by dialstatus;";
                        if ($DB > 0) {echo "\n|$stmtB|\n";}
      $rslt=mysqli_query($this->link,$stmtB);
      $scar_to_print = mysqli_num_rows($rslt);
      $print_sctp=0;
      while ($scar_to_print > $print_sctp)
        {
        $row=mysqli_fetch_row($rslt);
        $FTminute_total+=$row[1];
        $print_ctp=0;
        while ($print_ctp < $ctp)
          {
          if ($TFhour_status[$print_ctp] == $row[0])
            {$FTminute_count[$print_ctp] = $row[1];}
          $print_ctp++;
          }
        $print_sctp++;
        }

      //$stmtB="SELECT dialstatus,count(*) from vicidial_carrier_log where call_date >= \"$timeFIVEminutesAGO\" group by dialstatus;";
      if(trim($campaign_id)==""){
                           $stmtB="SELECT a.dialstatus,count(*) from vicidial_carrier_log a,vicidial_log b where a.lead_id=b.lead_id ".campLOGallowed_campaignsSQL." and  a.call_date >= \"$timeFIVEminutesAGO\" group by a.dialstatus;";
                       }else{
                           $stmtB="SELECT a.dialstatus,count(*) from vicidial_carrier_log a,vicidial_log b where a.lead_id=b.lead_id and b.campaign_id='$campaign_id' and  a.call_date >= \"$timeFIVEminutesAGO\" group by a.dialstatus;";
                       
                       }

                        $stmtB="SELECT dialstatus,count(*) from vicidial_carrier_log where call_date >= \"$timeFIVEminutesAGO\" and (select list_id from vicidial_list where lead_id=vicidial_carrier_log.lead_id) in($lists) group by dialstatus;";
                        if ($DB > 0) {echo "\n|$stmtB|\n";}
      $rslt=mysqli_query($this->link,$stmtB);
      $scar_to_print = mysqli_num_rows($rslt);
      $print_sctp=0;
      while ($scar_to_print > $print_sctp)
        {
        $row=mysqli_fetch_row($rslt);
        $FIVEminute_total+=$row[1];
        $print_ctp=0;
        while ($print_ctp < $ctp)
          {
          if ($TFhour_status[$print_ctp] == $row[0])
            {$FIVEminute_count[$print_ctp] = $row[1];}
          $print_ctp++;
          }
        $print_sctp++;
        }

      //$stmtB="SELECT dialstatus,count(*) from vicidial_carrier_log where call_date >= \"$timeONEminuteAGO\" group by dialstatus;";
                       
                       if(trim($campaign_id)=="")
                       {
                           $stmtB="SELECT a.dialstatus,count(*) from vicidial_carrier_log a,vicidial_log b where a.lead_id=b.lead_id ".campLOGallowed_campaignsSQL." and  a.call_date >= \"$timeONEminuteAGO\" group by a.dialstatus;";
                       
                       }else{
                           $stmtB="SELECT a.dialstatus,count(*) from vicidial_carrier_log a,vicidial_log b where a.lead_id=b.lead_id and b.campaign_id='$campaign_id' and  a.call_date >= \"$timeONEminuteAGO\" group by a.dialstatus;";
                       
                       }

                       

                       // $stmtB="SELECT dialstatus,count(*) from vicidial_carrier_log where call_date >= \"$timeONEminuteAGO\" and (select list_id from vicidial_list where lead_id=vicidial_carrier_log.lead_id) in($lists) group by dialstatus;";

                        if ($DB > 0) {echo "\n|$stmtB|\n";}
      $rslt=mysqli_query($this->link,$stmtB);
      $scar_to_print = mysqli_num_rows($rslt);
      $print_sctp=0;
      while ($scar_to_print > $print_sctp)
        {
        $row=mysqli_fetch_row($rslt);
        $ONEminute_total+=$row[1];
        $print_ctp=0;
        while ($print_ctp < $ctp)
          {
          if ($TFhour_status[$print_ctp] == $row[0])
            {$ONEminute_count[$print_ctp] = $row[1];}
          $print_ctp++;
          }
        $print_sctp++;
        }


      $print_ctp=0;
      while ($print_ctp < $ctp)
        {
        if (strlen($TFhour_count[$print_ctp])<1) {$TFhour_count[$print_ctp]=0;}
        if (strlen($SIXhour_count[$print_ctp])<1) {$SIXhour_count[$print_ctp]=0;}
        if (strlen($ONEhour_count[$print_ctp])<1) {$ONEhour_count[$print_ctp]=0;}
        if (strlen($FTminute_count[$print_ctp])<1) {$FTminute_count[$print_ctp]=0;}
        if (strlen($FIVEminute_count[$print_ctp])<1) {$FIVEminute_count[$print_ctp]=0;}
        if (strlen($ONEminute_count[$print_ctp])<1) {$ONEminute_count[$print_ctp]=0;}
        
        $TFhour_pct = (100*$this->MathZDC($TFhour_count[$print_ctp], $TFhour_total));
        $SIXhour_pct = (100*$this->MathZDC($SIXhour_count[$print_ctp], $SIXhour_total));
        $ONEhour_pct = (100*$this->MathZDC($ONEhour_count[$print_ctp], $ONEhour_total));
        $TFminute_pct = (100*$this->MathZDC($FTminute_count[$print_ctp], $FTminute_total));
        $FIVEminute_pct = (100*$this->MathZDC($FIVEminute_count[$print_ctp], $FIVEminute_total));
        $ONEminute_pct = (100*$this->MathZDC($ONEminute_count[$print_ctp], $ONEminute_total));

        $CARRIERstatsHTML .= "<TR>";
        //$CARRIERstatsHTML .= "<TD BGCOLOR=white><font class='top_settings_val'>&nbsp;</TD>";
        $CARRIERstatsHTML .= "<TD><font class='top_settings_val'>&nbsp; &nbsp; $TFhour_status[$print_ctp] </TD>";
        $CARRIERstatsHTML .= "<TD><font class='top_settings_val'> $TFhour_count[$print_ctp] </font>&nbsp;<font size=1 color='#990000'>".sprintf("%01.1f", $TFhour_pct)."%</font></TD>";
        $CARRIERstatsHTML .= "<TD><font class='top_settings_val'> $SIXhour_count[$print_ctp] </font>&nbsp;<font size=1 color='#990000'>".sprintf("%01.1f", $SIXhour_pct)."%</font></TD>";
        $CARRIERstatsHTML .= "<TD><font class='top_settings_val'> $ONEhour_count[$print_ctp] </font>&nbsp;<font size=1 color='#990000'>".sprintf("%01.1f", $ONEhour_pct)."%</font></TD>";
        $CARRIERstatsHTML .= "<TD><font class='top_settings_val'> $FTminute_count[$print_ctp] </font>&nbsp;<font size=1 color='#990000'>".sprintf("%01.1f", $TFminute_pct)."%</font></TD>";
        $CARRIERstatsHTML .= "<TD><font class='top_settings_val'> $FIVEminute_count[$print_ctp] </font>&nbsp;<font size=1 color='#990000'>".sprintf("%01.1f", $FIVEminute_pct)."%</font></TD>";
        $CARRIERstatsHTML .= "<TD><font class='top_settings_val'> $ONEminute_count[$print_ctp] </font>&nbsp;<font size=1 color='#990000'>".sprintf("%01.1f", $ONEminute_pct)."%</font></TD>";
        $CARRIERstatsHTML .= "</TR>";
        $print_ctp++;
        }
      $CARRIERstatsHTML .= "<TR>";
      //$CARRIERstatsHTML .= "<TD BGCOLOR=white><font class='top_settings_val'>&nbsp;</TD>";
      $CARRIERstatsHTML .= "<TH>&nbsp; &nbsp;TOTALS</font></TD>";
      $CARRIERstatsHTML .= "<TH>".($TFhour_total+0)."</TH>";
      $CARRIERstatsHTML .= "<TH>".($SIXhour_total+0)."</TH>";
      $CARRIERstatsHTML .= "<TH>".($ONEhour_total+0)."</TH>";
      $CARRIERstatsHTML .= "<TH>".($FTminute_total+0)."</TH>";
      $CARRIERstatsHTML .= "<TH>".($FIVEminute_total+0)."</TH>";
      $CARRIERstatsHTML .= "<TH>".($ONEminute_total+0)."</TH>";
      $CARRIERstatsHTML .= "</TR>";

      }
    else
      {
      $CARRIERstatsHTML .= "<TR><TD BGCOLOR=white colspan=7 align=Center>******* NO RECORD FOUND*******</TD></TR>";
      }
    $CARRIERstatsHTML .= "</tbody></TABLE>";
    
    
  echo $CARRIERstatsHTML;
    }
            
    function sip_hangup_cause_description($sip_code)
    {
        $sip_hangup_cause_dictionary = array(
400 => "Bad Request.",
401 => "Unauthorized.",
402 => "Payment Required.",
403 => "Forbidden.",
404 => "Not Found.",
405 => "Method Not Allowed.",
406 => "Not Acceptable.",
407 => "Proxy Authentication Required.",
408 => "Request Timeout.",
409 => "Conflict.",
410 => "Gone.",
411 => "Length Required.",
412 => "Conditional Request Failed.",
413 => "Request Entity Too Large.",
414 => "Request-URI Too Long.",
415 => "Unsupported Media Type.",
416 => "Unsupported URI Scheme.",
417 => "Unknown Resource-Priority.",
420 => "Bad Extension.",
421 => "Extension Required.",
422 => "Session Interval Too Small.",
423 => "Interval Too Brief.",
424 => "Bad Location Information.",
428 => "Use Identity Header.",
429 => "Provide Referrer Identity.",
433 => "Anonymity Disallowed.",
436 => "Bad Identity-Info.",
437 => "Unsupported Certificate.",
438 => "Invalid Identity Header.",
470 => "Consent Needed.",
480 => "Temporarily Unavailable.",
481 => "Call/Transaction Does Not Exist.",
482 => "Loop Detected..",
483 => "Too Many Hops.",
484 => "Address Incomplete.",
485 => "Ambiguous.",
486 => "Busy Here.",
487 => "Request Terminated.",
488 => "Not Acceptable Here.",
489 => "Bad Event.",
491 => "Request Pending.",
493 => "Undecipherable.",
494 => "Security Agreement Required.",
500 => "Server Internal Error.",
501 => "Not Implemented.",
502 => "Bad Gateway.",
503 => "Service Unavailable.",
504 => "Server Time-out.",
505 => "Version Not Supported.",
513 => "Message Too Large.",
580 => "Precondition Failure.",
600 => "Busy Everywhere.",
603 => "Decline.",
604 => "Does Not Exist Anywhere.",
606 => "Not Acceptable.",
200 => "Success",
180 =>"Ringing",
0=>"Chanunavail"       
);
        if (array_key_exists($sip_code, $sip_hangup_cause_dictionary)) {
            return $sip_hangup_cause_dictionary[$sip_code];
        } else {
            return "Unidentified SIP Hangup Cause Code.";
        }
    }
    
    function hangup_cause_description($code)
    {
$hangup_cause_dictionary = array(
0 => "Unspecified. No other cause codes applicable.",
1 => "Unallocated (unassigned) number.",
2 => "No route to specified transit network (national use).",
3 => "No route to destination.",
6 => "Channel unacceptable.",
7 => "Call awarded, being delivered in an established channel.",
16 => "Normal call clearing.",
17 => "User busy.",
18 => "No user responding.",
19 => "No answer from user (user alerted).",
20 => "Subscriber absent.",
21 => "Call rejected.",
22 => "Number changed.",
23 => "Redirection to new destination.",
25 => "Exchange routing error.",
27 => "Destination out of order.",
28 => "Invalid number format (address incomplete).",
29 => "Facilities rejected.",
30 => "Response to STATUS INQUIRY.",
31 => "Normal, unspecified.",
34 => "No circuit/channel available.",
38 => "Network out of order.",
41 => "Temporary failure.",
42 => "Switching equipment congestion.",
43 => "Access information discarded.",
44 => "Requested circuit/channel not available.",
50 => "Requested facility not subscribed.",
52 => "Outgoing calls barred.",
54 => "Incoming calls barred.",
57 => "Bearer capability not authorized.",
58 => "Bearer capability not presently available.",
63 => "Service or option not available, unspecified.",
65 => "Bearer capability not implemented.",
66 => "Channel type not implemented.",
69 => "Requested facility not implemented.",
79 => "Service or option not implemented, unspecified.",
81 => "Invalid call reference value.",
88 => "Incompatible destination.",
95 => "Invalid message, unspecified.",
96 => "Mandatory information element is missing.",
97 => "Message type non-existent or not implemented.",
98 => "Message not compatible with call state or message type non-existent or not implemented.",
99 => "Information element / parameter non-existent or not implemented.",
100 => "Invalid information element contents.",
101 => "Message not compatible with call state.",
102 => "Recovery on timer expiry.",
103 => "Parameter non-existent or not implemented - passed on (national use).",
111 => "Protocol error, unspecified.",
127 => "Interworking, unspecified."
);
        if (array_key_exists($code, $hangup_cause_dictionary)) {
            return $hangup_cause_dictionary[$code];
        } else {
            return "Unidentified Hangup Cause Code.";
        }
    }
    
    public function UserAuth()
    {   
        return;
    }
    
    public function get_campaign_specific_carrier_log($campaign){
        $html="";
        $html.="<div class=\"call-response\"><table width=\"100%\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\"><h1>Outbound Carrier Logs</h1>";
  $html.="<tbody><tr>";         
  $html.="<tr>";
  $html.="<th>REASON</th>";
  $html.="<th>CALLS</th>";          
  $html.="</tr>";
        $found=false;
  $stmt  = "select a.sip_hangup_cause,b.campaign_id,a.hangup_cause,count( * ) as total_calls,a.server_ip from vicidial_carrier_log a,vicidial_log b where a.uniqueid=b.uniqueid and a.call_date>=date_sub(now(), interval 1440 minute) and campaign_id='$campaign' group by a.server_ip,a.sip_hangup_cause order by total_calls desc;";
  
        
        $rslt=mysqli_query($this->link,$stmt);
      while ($row = mysqli_fetch_row($rslt)) 
      { $found=true;
          $sip_hangup_cause=$row[0];
          $campaign_id=$row[1];
          $hangup_cause=$row[2];
          $total_calls=$row[3];
                $server_ip=$row[4];
          $sip_hangup_text=$this->sip_hangup_cause_description($sip_hangup_cause);
          $hangup_cause_text=$this->hangup_cause_description($hangup_cause);
              $html.="<tr>";
            if(trim($sip_hangup_text)!=="" || trim($sip_hangup_text)!=="0"){
            $response_text=$sip_hangup_cause.":".$sip_hangup_text;
          }else if(trim($hangup_cause_text)!=""){
            $response_text=$hangup_cause.":".$hangup_cause_text;
          }
            $html.="<td>$response_text "."==="." $server_ip</td>";        
            $html.="<td>$total_calls</td>";
            $html.="</tr>";
      }

      if($found==false){
        $html.="<tr>";
          $html.="<td style=\"text-align:center;\" colspan=\"2\">Records Not Found.</td>";
        $html.="</tr>";
      }
      $html.=" </tbody></table></div>";    
      echo $html;
      exit();
    }
    
    public function get_active_campaigns(){
            $campaigns="";
            $stmt="SELECT campaign_id from vicidial_campaigns where active IN ('Y','N') ".LOGallowed_campaignsSQL;
            $query = $this->db->query($stmt);
            $result=$query->result_array();
            for($i=0;$i<sizeof($result);$i++){
                $campaigns.="'".$result[$i]['campaign_id']."',";
            }
            $campaigns= rtrim($campaigns,",");
            if($campaigns==""){
                $campaigns="''";
            }
            return $campaigns;
    }

    public function GetCampaignName($campaign_id){
            $stmt="SELECT campaign_name from vicidial_campaigns where campaign_id='$campaign_id'";            
            $query = $this->db->query($stmt);
            $result=$query->result_array();
            if(sizeof($result)>0){
              return $result[0]['campaign_name'];
            }
            return "";
    }
    
    function MathZDC($dividend, $divisor, $quotient=0) 
  {
  if ($divisor==0) 
    {
    return $quotient;
    }
  else if ($dividend==0) 
    {
    return 0;
    }
  else 
    {
    return ($dividend/$divisor);
    }
  }
    
    function getStatus()
    {     
        $stmt="SELECT status from vicidial_log_archive where campaign_id in(".active_campaigns.") group by status;";
        $query = $this->db->query($stmt);
        $status=$query->result_array();
        $array=array();
        for($i=0;$i<sizeof($status);$i++){
            $array[]=array("status_code"=>$status[$i]['status'],
            "status_name"=>$this->get_status_name($status[$i]['status']));
        }

        $stmt="SELECT status from vicidial_log where campaign_id in(".active_campaigns.") group by status;";
        $query = $this->db->query($stmt);
        $status=$query->result_array();
        $array=array();
        for($i=0;$i<sizeof($status);$i++){
            $array[]=array("status_code"=>$status[$i]['status'],
            "status_name"=>$this->get_status_name($status[$i]['status']));
        }

        $args=$array;

        $tmp = array();

        foreach($args as $arg)
        {
            $tmp[$arg['status_code']] = $arg['status_name'];
        }

        $output = array();

        foreach($tmp as $type => $labels)
        {
            $output[] = array(
                'status_code' => $type,
                'status_name' => $labels
            );
        }

        return $output;

    }

    public function getBalance($swith="",$user="",$pass="")
    {
      if($swith=="NONE" || $swith==""){
        return "";
      }

      $login=$user;
      $password=$pass;
      $portal="portal.XXXXXXXXXX.com";
      $url = "https://$portal/api/portal/auth/info";
      $ch = curl_init();
      curl_setopt($ch, CURLOPT_URL,$url);
      curl_setopt($ch, CURLOPT_RETURNTRANSFER,1);
      curl_setopt($ch, CURLOPT_HTTPAUTH, CURLAUTH_BASIC);
      curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
      curl_setopt($ch, CURLOPT_USERPWD, "$login:$password");
      $result = curl_exec($ch);
      curl_close($ch);  
      $json = json_decode($result, true);
      if(!isset($json['credit'])){
      
      $balance_div="<span>";
      $balance_div.="Balance: <a data-toggle=\"tooltip\" title=\"Top Up\" class=\"btn-balance\" href=\"https://portal.XXXXXXXXXX.com\" target=\"_blank\">0.00</a>";
      $balance_div.="</span>";

      $balance_div.="<span>";
      $balance_div.="Debit Limit:<a data-toggle=\"tooltip\" title=\"Top Up\" class=\"btn-balance\" href=\"https://portal.XXXXXXXXXX.com\" target=\"_blank\">0.00</a>";
      $balance_div.="</span>";

      $balance_div.="<div class=\"inactive-status-cx\">Status:<h2>None</h2></div>";
      
    }else{
      $balance_div="<span>";
      $balance_div.="Balance: <a data-toggle=\"tooltip\" title=\"Top Up\" target=\"_blank\" class=\"btn-balance\" href=\"https://portal.XXXXXXXXXX.com\" target=\"_blank\">".round($json['credit'],4)." ".$json['currency']."</a>";
      $balance_div.="</span>";

      $balance_div.="<span>";
      $balance_div.="Debit Limit: <a data-toggle=\"tooltip\" title=\"Top Up\" target=\"_blank\" class=\"btn-balance\" href=\"https://portal.XXXXXXXXXX.com\" target=\"_blank\">".round($json['debit_limit'],4)." ".$json['currency']."</a>";
      $balance_div.="</span>";
      
      if($json['status']=="Active"){
        $balance_div.="<div class=\"active-status-cx\">Status:<h2>".$json['status']."</h2></div>";
      }else{
        $balance_div.="<div class=\"inactive-status-cx\">Status:<h2>".$json['status']."</h2></div>";
      }     
    }    
    return $balance_div;  
    }

    public function event_logs($event_section,$event_type,$record_id,$event_code)
    {       
       $PHP_AUTH_USER = $this->session->userdata('username');
       $ip=$this->get_client_ip();
       $SQL_log=$this->db->last_query();
       $SQLdate = date("Y-m-d H:i:s");
       $stmt="INSERT INTO vicidial_admin_log set event_date='$SQLdate', user='$PHP_AUTH_USER', ip_address='$ip', event_section='$event_section', event_type='$event_type', record_id='$record_id', event_code='$event_code', event_sql=\"$SQL_log\", event_notes='';";
       $rslt = mysqli_query($this->link, $stmt);
    }


    public function get_client_ip() {
        $ipaddress = '';
        if (getenv('HTTP_CLIENT_IP'))
            $ipaddress = getenv('HTTP_CLIENT_IP');
        else if(getenv('HTTP_X_FORWARDED_FOR'))
            $ipaddress = getenv('HTTP_X_FORWARDED_FOR');
        else if(getenv('HTTP_X_FORWARDED'))
            $ipaddress = getenv('HTTP_X_FORWARDED');
        else if(getenv('HTTP_FORWARDED_FOR'))
            $ipaddress = getenv('HTTP_FORWARDED_FOR');
        else if(getenv('HTTP_FORWARDED'))
           $ipaddress = getenv('HTTP_FORWARDED');
        else if(getenv('REMOTE_ADDR'))
            $ipaddress = getenv('REMOTE_ADDR');
        else
            $ipaddress = 'UNKNOWN';
        return $ipaddress;
    }

    public function admin_change_log($event_section="",$event_type="",$event_code="",$record_id="")
    {       
            $event_code=$event_type;
            $SQLdate = date("Y-m-d H:i:s");
            $stmt = $this->db->last_query();
            $SQL_log = "$stmt|";
            $SQL_log = preg_replace('/;/', '', $SQL_log);
            $SQL_log = addslashes($SQL_log);
            $this->load->model('Model_login');
            $userdata=$this->Model_login->Get_loggedin_user();
            $PHP_AUTH_USER=$userdata['user'];
            $ip = getenv("REMOTE_ADDR");
            $stmt="INSERT INTO vicidial_admin_log set event_date='$SQLdate', user='$PHP_AUTH_USER', ip_address='$ip', event_section='$event_section', event_type='$event_type', record_id='$record_id', event_code='$event_code', event_sql=\"$SQL_log\", event_notes='VB';";          
            $rslt = mysqli_query($this->link, $stmt);
    }


    public function match_max_trunk($campaign_id,$user_group,$trunks)
    {
        $stmt="SELECT max_trunks from vicidial_user_groups where user_group='$user_group';";
        $query = $this->db->query($stmt);
        $result=$query->result_array();
        $max_trunks=0;
        if(sizeof($result)>0)
        {
           $max_trunks=$result[0]['max_trunks'];
        }
        $stmt="SELECT sum(dedicated_trunks) as dedicated_trunks from vicidial_server_trunks where campaign_id IN(SELECT campaign_id FROM vicidial_campaigns where user_group='$user_group')";

        $query = $this->db->query($stmt);
        $result=$query->result_array();
        $dedicated_trunks=0;
        if(sizeof($result)>0)
        {
           $dedicated_trunks=$result[0]['dedicated_trunks'];
        }
        $dedicated_trunks=strval($dedicated_trunks);
        if(trim($dedicated_trunks)==="")
        {
          $dedicated_trunks=0;
        }

        $dedicated_trunks=strval($dedicated_trunks)+strval($trunks)-strval($this->get_campaign_trunks($campaign_id));


      if(strval($max_trunks)>0)
      {
        if(strval($dedicated_trunks)>strval($max_trunks))
        {
          $array=array("status"=>false,"dedicated_trunks"=>$dedicated_trunks,"max_trunks"=>$max_trunks);
        }else{
          $array=array("status"=>true,"dedicated_trunks"=>$dedicated_trunks,"max_trunks"=>$max_trunks);
        }        
      }else{
        if(strval($trunks)>0)
        {
          $array=array("status"=>false,"dedicated_trunks"=>$trunks,"max_trunks"=>$max_trunks);
        }else{
          $array=array("status"=>true,"dedicated_trunks"=>$trunks,"max_trunks"=>$max_trunks);
        }
        
      }

      return $array;
    }

    public function remove_trunks_limit($campaign_id)
    {
      $stmt="DELETE FROM vicidial_server_trunks where campaign_id='$campaign_id'";
      $query = $this->db->query($stmt);
      $this->ServerRebuildConf();
    }

    public function distribute_trunks_with_servers($campaign_id,$dedicated_trunks=0)
    {
        $stmt="DELETE FROM vicidial_server_trunks where campaign_id='$campaign_id'";
        $query = $this->db->query($stmt);
        $servers=$this->GetServerIP();
        $echo_server_trunk=strval($dedicated_trunks)/sizeof($servers);
        for ($i = 0; $i < sizeof($servers); $i++) 
        {
           $data=array('server_ip'=>$servers[$i]['server_ip'],"campaign_id"=>$campaign_id,'dedicated_trunks'=>$echo_server_trunk,"trunk_restriction"=>"MAXIMUM_LIMIT");
           $this->db->insert('vicidial_server_trunks', $data);
        }
        $this->ServerRebuildConf();
    }

    public function get_campaign_trunks($campaign_id)
    {
       $stmt="SELECT sum(dedicated_trunks) as dedicated_trunks from vicidial_server_trunks where campaign_id='$campaign_id';";
        $query = $this->db->query($stmt);
        $result=$query->result_array();
        $dedicated_trunks=0;
        if(sizeof($result))
        {
            $dedicated_trunks=trim($result[0]['dedicated_trunks']);
        }
        if($dedicated_trunks==""){
          $dedicated_trunks=0;
        }
        return $dedicated_trunks;
    }


    public function group_max_trunks($user_group)
    {
      // $stmt="SELECT max_trunks from vicidial_user_groups where user_group='$user_group';";
     //    $query = $this->db->query($stmt);
     //    $result=$query->result_array();
     //    $max_trunks=0;
     //    if(sizeof($result)>0)
     //    {
     //       $max_trunks=strval($result[0]['max_trunks']);
     //    }
       $max_trunks=0;
        return $max_trunks;
    }


function Get_usergroups_settings($user_group)
{ error_reporting(0);
  $stmt="SELECT allowed_campaigns,qc_allowed_campaigns,qc_allowed_inbound_groups from vicidial_user_groups where user_group='$user_group' ".LOGadmin_viewable_groupsSQL.";";
    $rslt=$this->mysql_to_mysqli($stmt, $this->link);
    $row=mysqli_fetch_row($rslt);
    $allowed_campaigns =      $row[0];
    $qc_allowed_campaigns =     $row[1];
    $qc_allowed_inbound_groups =  $row[2];
    $allowed_campaigns = preg_replace("/ -$/","",$allowed_campaigns);
    $campaigns = explode(" ", $allowed_campaigns);
    $qc_allowed_campaigns = preg_replace("/ -$/","",$qc_allowed_campaigns);
    $qc_campaigns = explode(" ", $qc_allowed_campaigns);
    $qc_allowed_inbound_groups = preg_replace("/ -$/","",$qc_allowed_inbound_groups);
    $qc_groups = explode(" ", $qc_allowed_inbound_groups);
    

  $campaigns_value="";

  if ( (preg_match('/\-ALL/i', LOGallowed_campaigns)) )
    {$campaigns_list='<B><input type="checkbox" name="campaigns[]" value="-ALL-CAMPAIGNS-"';}
  $qc_campaigns_value='';
  $qc_campaigns_list='<B><input type="checkbox" name="qc_campaigns[]" value="-ALL-CAMPAIGNS-"';
  $qc_groups_value='';
  $qc_groups_list='<B><input type="checkbox" name="qc_groups[]" value="-ALL-GROUPS-"';
  $p=0;
  while ($p<2000)
    {
    if (preg_match('/ALL\-CAMPAIGNS/i',$campaigns[$p])) 
      {
      if ( (preg_match('/\-ALL/i', LOGallowed_campaigns)) )
        {
        $campaigns_list.=" CHECKED";
        $campaigns_value .= " -ALL-CAMPAIGNS-";
        }
      }
    if (preg_match('/ALL\-CAMPAIGNS/i',$qc_campaigns[$p])) 
      {
      $qc_campaigns_list.=" CHECKED";
      $qc_campaigns_value .= " -ALL-CAMPAIGNS-";
      }
    if (preg_match('/ALL\-GROUPS/i',$qc_groups[$p])) 
      {
      $qc_groups_list.=" CHECKED";
      $qc_groups_value .= " -ALL-GROUPS-";
      }
    $p++;
    }
  if ( (preg_match('/\-ALL/i', LOGallowed_campaigns)) )
    {$campaigns_list.="> ".$this->_QXZ("ALL-CAMPAIGNS - USERS CAN VIEW ANY CAMPAIGN")."</B><BR>\n";}
  $qc_campaigns_list.="> ".$this->_QXZ("ALL-CAMPAIGNS - USERS CAN QC ANY CAMPAIGN")."</B><BR>\n";
  $qc_groups_list.="> ".$this->_QXZ("ALL-GROUPS - USERS CAN QC ANY INBOUND GROUP")."</B><BR>\n";

  $stmt="SELECT campaign_id,campaign_name from vicidial_campaigns ".whereLOGallowed_campaignsSQL." order by campaign_id;";
  $rslt=$this->mysql_to_mysqli($stmt, $this->link);
  $campaigns_to_print = mysqli_num_rows($rslt);

  $o=0;
  while ($campaigns_to_print > $o)
    {
    $rowx=mysqli_fetch_row($rslt);
    $campaign_id_value = $rowx[0];
    $campaign_name_value = $rowx[1];
    $campaigns_list .= "<input type=\"checkbox\" name=\"campaigns[]\" value=\"$campaign_id_value\"";
    $qc_campaigns_list .= "<input type=\"checkbox\" name=\"qc_campaigns[]\" value=\"$campaign_id_value\"";
    $p=0;
    while ($p<1000)
      {
      if ( ($campaign_id_value === $campaigns[$p]) and (strlen($campaign_id_value) > 1) )
        {
      # echo "<!--  X $p|$campaign_id_value|$campaigns[$p]| -->";
        $campaigns_list .= " CHECKED";
        $campaigns_value .= " $campaign_id_value";
        }
      if ($campaign_id_value === $qc_campaigns[$p]) 
        {
        $qc_campaigns_list .= " CHECKED";
        $qc_campaigns_value .= " $campaign_id_value";
        }
    # echo "<!--  O $p|$campaign_id_value|$campaigns[$p]| -->";
      $p++;
      }
    $campaigns_list .= "> $campaign_id_value - $campaign_name_value<BR>\n";
    $qc_campaigns_list .= "> $campaign_id_value - $campaign_name_value<BR>\n";
    $o++;
    }

  $stmt="SELECT group_id,group_name from vicidial_inbound_groups where group_id NOT IN('AGENTDIRECT') ".LOGadmin_viewable_groupsSQL." order by group_id;";
  $rslt=$this->mysql_to_mysqli($stmt, $this->link);
  $groups_to_print = mysqli_num_rows($rslt);

  $o=0;
  while ($groups_to_print > $o)
    {
    $rowx=mysqli_fetch_row($rslt);
    $group_id_value = $rowx[0];
    $group_name_value = $rowx[1];
    $qc_groups_list .= "<input type=\"checkbox\" name=\"qc_groups[]\" value=\"$group_id_value\"";
    $p=0;
    while ($p<2000)
      {
      if ( ($group_id_value === $qc_groups[$p]) and (strlen($group_id_value) > 1) )
        {
        $qc_groups_list .= " CHECKED";
        $qc_groups_value .= " $group_id_value";
        }
      $p++;
      }
    $qc_groups_list .= "> $group_id_value - $group_name_value<BR>\n";
    $o++;
    }

  if (strlen($campaigns_value)>2) {$campaigns_value .= " -";}
  if (strlen($qc_campaigns_value)>2) {$qc_campaigns_value .= " -";}
  if (strlen($qc_groups_value)>2) {$qc_groups_value .= " -";}


  $rstl=array("campaigns_list"=>$campaigns_list,'campaigns_value'=>$campaigns_value);
  return $rstl;
}  


function mysql_to_mysqli($stmt, $link) 
  {
    $rslt=mysqli_query($link, $stmt);
    return $rslt;
  }



##### DETERMINE IF LEAD IS DIALABLE #####
function dialable_gmt($DB,$link,$local_call_time,$gmt_offset,$state)
  {       
 
  $dialable=0;
  $pzone=3600 * $gmt_offset;
  $pmin=(gmdate("i", time() + $pzone));
  $phour=( (gmdate("G", time() + $pzone)) * 100);
  $pday=gmdate("w", time() + $pzone);
  $tz = sprintf("%.2f", $p);  
  $GMT_gmt = "$tz";
  $GMT_day = "$pday";
  $GMT_hour = ($phour + $pmin);
  $YMD =  date("Y-m-d");  
  
  $stmt="SELECT call_time_id,call_time_name,call_time_comments,ct_default_start,ct_default_stop,ct_sunday_start,ct_sunday_stop,ct_monday_start,ct_monday_stop,ct_tuesday_start,ct_tuesday_stop,ct_wednesday_start,ct_wednesday_stop,ct_thursday_start,ct_thursday_stop,ct_friday_start,ct_friday_stop,ct_saturday_start,ct_saturday_stop,ct_state_call_times,ct_holidays FROM vicidial_call_times where call_time_id='$local_call_time';";
  if ($DB) {echo "$stmt\n";}
  $rslt=$this->Model_lib->mysql_to_mysqli($stmt, $link);
  $rowx=mysqli_fetch_row($rslt);
  $Gct_default_start =  $rowx[3];
  $Gct_default_stop =   $rowx[4];
  $Gct_sunday_start =   $rowx[5];
  $Gct_sunday_stop =    $rowx[6];
  $Gct_monday_start =   $rowx[7];
  $Gct_monday_stop =    $rowx[8];
  $Gct_tuesday_start =  $rowx[9];
  $Gct_tuesday_stop =   $rowx[10];
  $Gct_wednesday_start =  $rowx[11];
  $Gct_wednesday_stop = $rowx[12];
  $Gct_thursday_start = $rowx[13];
  $Gct_thursday_stop =  $rowx[14];
  $Gct_friday_start =   $rowx[15];
  $Gct_friday_stop =    $rowx[16];
  $Gct_saturday_start = $rowx[17];
  $Gct_saturday_stop =  $rowx[18];
  $Gct_state_call_times = $rowx[19];
  $Gct_holidays =     $rowx[20];

  ### BEGIN Check for outbound holiday ###
  $holiday_id = '';
  if (strlen($Gct_holidays)>2)
    {
    $Gct_holidaysSQL = preg_replace("/\|/", "','", "$Gct_holidays");
    $Gct_holidaysSQL = "'".$Gct_holidaysSQL."'";
    
    $stmt = "SELECT holiday_id,holiday_date,holiday_name,ct_default_start,ct_default_stop from vicidial_call_time_holidays where holiday_id IN($Gct_holidaysSQL) and holiday_status='ACTIVE' and holiday_date='$YMD' order by holiday_id;";
    $rslt=$this->Model_lib->mysql_to_mysqli($stmt, $link);
    if ($DB) {echo "$stmt\n";}
    $sthCrows=mysqli_num_rows($rslt);
    if ($sthCrows > 0)
      {
      $aryC=mysqli_fetch_row($rslt);
      $holiday_id =       $aryC[0];
      $holiday_date =       $aryC[1];
      $holiday_name =       $aryC[2];
      if ( ($Gct_default_start < $aryC[3]) && ($Gct_default_stop > 0) )   {$Gct_default_start = $aryC[3];}
      if ( ($Gct_default_stop > $aryC[4]) && ($Gct_default_stop > 0) )    {$Gct_default_stop = $aryC[4];}
      if ( ($Gct_sunday_start < $aryC[3]) && ($Gct_sunday_stop > 0) )     {$Gct_sunday_start = $aryC[3];}
      if ( ($Gct_sunday_stop > $aryC[4]) && ($Gct_sunday_stop > 0) )      {$Gct_sunday_stop = $aryC[4];}
      if ( ($Gct_monday_start < $aryC[3]) && ($Gct_monday_stop > 0) )     {$Gct_monday_start = $aryC[3];}
      if ( ($Gct_monday_stop >  $aryC[4]) && ($Gct_monday_stop > 0) )   {$Gct_monday_stop = $aryC[4];}
      if ( ($Gct_tuesday_start < $aryC[3]) && ($Gct_tuesday_stop > 0) )   {$Gct_tuesday_start = $aryC[3];}
      if ( ($Gct_tuesday_stop > $aryC[4]) && ($Gct_tuesday_stop > 0) )    {$Gct_tuesday_stop = $aryC[4];}
      if ( ($Gct_wednesday_start < $aryC[3]) && ($Gct_wednesday_stop > 0) )   {$Gct_wednesday_start = $aryC[3];}
      if ( ($Gct_wednesday_stop > $aryC[4]) && ($Gct_wednesday_stop > 0) )  {$Gct_wednesday_stop = $aryC[4];}
      if ( ($Gct_thursday_start < $aryC[3]) && ($Gct_thursday_stop > 0) )   {$Gct_thursday_start = $aryC[3];}
      if ( ($Gct_thursday_stop > $aryC[4]) && ($Gct_thursday_stop > 0) )    {$Gct_thursday_stop = $aryC[4];}
      if ( ($Gct_friday_start < $aryC[3]) && ($Gct_friday_stop > 0) )     {$Gct_friday_start = $aryC[3];}
      if ( ($Gct_friday_stop > $aryC[4]) && ($Gct_friday_stop > 0) )      {$Gct_friday_stop = $aryC[4];}
      if ( ($Gct_saturday_start < $aryC[3]) && ($Gct_saturday_stop > 0) )   {$Gct_saturday_start = $aryC[3];}
      if ( ($Gct_saturday_stop > $aryC[4]) && ($Gct_saturday_stop > 0) )    {$Gct_saturday_stop = $aryC[4];}
      if ($DB) {echo "CALL TIME HOLIDAY FOUND!   $local_call_time|$holiday_id|$holiday_date|$holiday_name|$Gct_default_start|$Gct_default_stop|\n";}
      }
    }
  ### END Check for outbound holiday ###
    if( $state != '') 
      {
      $ct_states = '';
      $ct_state_gmt_SQL = '';
      $ct_srs=0;
      $b=0;
      if (strlen($Gct_state_call_times)>2)
        {
        $state_rules = explode('|',$Gct_state_call_times);
        $ct_srs = ((count($state_rules)) - 2);
        }
        while($ct_srs >= $b)
          {
          if (strlen($state_rules[$b])>1)
            {
            $stmt = "SELECT state_call_time_id,state_call_time_state,state_call_time_name,state_call_time_comments,sct_default_start,sct_default_stop,sct_sunday_start,sct_sunday_stop,sct_monday_start,sct_monday_stop,sct_tuesday_start,sct_tuesday_stop,sct_wednesday_start,sct_wednesday_stop,sct_thursday_start,sct_thursday_stop,sct_friday_start,sct_friday_stop,sct_saturday_start,sct_saturday_stop,ct_holidays from vicidial_state_call_times where state_call_time_id='$state_rules[$b]';";
            $rslt=$this->Model_lib->mysql_to_mysqli($stmt, $link);
            if ($DB) {echo "$stmt\n";}
            $sthCrows=mysqli_num_rows($rslt);
            if ($sthCrows > 0)
              {
              $aryC=mysqli_fetch_row($rslt);
              $Gstate_call_time_state = $aryC[1];
              if ($Gstate_call_time_state == $state) 
                {
                $Gstate_call_time_id =    $aryC[0];
                $Gsct_default_start =   $aryC[4];
                $Gsct_default_stop =    $aryC[5];
                $Gsct_sunday_start =    $aryC[6];
                $Gsct_sunday_stop =     $aryC[7];
                $Gsct_monday_start =    $aryC[8];
                $Gsct_monday_stop =     $aryC[9];
                $Gsct_tuesday_start =   $aryC[10];
                $Gsct_tuesday_stop =    $aryC[11];
                $Gsct_wednesday_start =   $aryC[12];
                $Gsct_wednesday_stop =    $aryC[13];
                $Gsct_thursday_start =    $aryC[14];
                $Gsct_thursday_stop =   $aryC[15];
                $Gsct_friday_start =    $aryC[16];
                $Gsct_friday_stop =     $aryC[17];
                $Gsct_saturday_start =    $aryC[18];
                $Gsct_saturday_stop =   $aryC[19];
                $Sct_holidays =       $aryC[20];
                $ct_states .="'$Gstate_call_time_state',";
                
                ### BEGIN Check for outbound state holiday ###
                $Sholiday_id = '';
                if ((strlen($Sct_holidays)>2) or ((strlen($holiday_id)>2) and (strlen($Sholiday_id)<2))) 
                  {
                  # Apply state holiday
                  if (strlen($Sct_holidays)>2)
                    {               
                    $Sct_holidaysSQL = preg_replace("/\|/", "','", "$Sct_holidays");
                    $Sct_holidaysSQL = "'".$Sct_holidaysSQL."'";
                    $stmt = "SELECT holiday_id,holiday_date,holiday_name,ct_default_start,ct_default_stop from vicidial_call_time_holidays where holiday_id IN($Sct_holidaysSQL) and holiday_status='ACTIVE' and holiday_date='$YMD' order by holiday_id;";
                    $holidaytype = "STATE CALL TIME HOLIDAY FOUND!   ";
                    }
                  # Apply call time wide holiday
                  elseif ((strlen($holiday_id)>2) and (strlen($Sholiday_id)<2))
                    {
                    $stmt = "SELECT holiday_id,holiday_date,holiday_name,ct_default_start,ct_default_stop from vicidial_call_time_holidays where holiday_id='$holiday_id' and holiday_status='ACTIVE' and holiday_date='$YMD' order by holiday_id;";
                    $holidaytype = "NO STATE HOLIDAY APPLYING CALL TIME HOLIDAY!   ";
                    }       
                  $rslt=$this->Model_lib->mysql_to_mysqli($stmt, $link);
                  if ($DB) {echo "$stmt\n";}
                  $sthCrows=mysqli_num_rows($rslt);
                  if ($sthCrows > 0)
                    {
                    $aryC=mysqli_fetch_row($rslt);
                    $Sholiday_id =        $aryC[0];
                    $Sholiday_date =      $aryC[1];
                    $Sholiday_name =      $aryC[2];
                    if ( ($Gsct_default_start < $aryC[3]) && ($Gsct_default_stop > 0) )   {$Gsct_default_start = $aryC[3];}
                    if ( ($Gsct_default_stop > $aryC[4]) && ($Gsct_default_stop > 0) )    {$Gsct_default_stop = $aryC[4];}
                    if ( ($Gsct_sunday_start < $aryC[3]) && ($Gsct_sunday_stop > 0) )   {$Gsct_sunday_start = $aryC[3];}
                    if ( ($Gsct_sunday_stop > $aryC[4]) && ($Gsct_sunday_stop > 0) )    {$Gsct_sunday_stop = $aryC[4];}
                    if ( ($Gsct_monday_start < $aryC[3]) && ($Gsct_monday_stop > 0) )   {$Gsct_monday_start = $aryC[3];}
                    if ( ($Gsct_monday_stop > $aryC[4]) && ($Gsct_monday_stop > 0) )    {$Gsct_monday_stop = $aryC[4];}
                    if ( ($Gsct_tuesday_start < $aryC[3]) && ($Gsct_tuesday_stop > 0) )   {$Gsct_tuesday_start = $aryC[3];}
                    if ( ($Gsct_tuesday_stop > $aryC[4]) && ($Gsct_tuesday_stop > 0) )    {$Gsct_tuesday_stop = $aryC[4];}
                    if ( ($Gsct_wednesday_start < $aryC[3]) && ($Gsct_wednesday_stop > 0) ) {$Gsct_wednesday_start = $aryC[3];}
                    if ( ($Gsct_wednesday_stop > $aryC[4]) && ($Gsct_wednesday_stop > 0) )  {$Gsct_wednesday_stop = $aryC[4];}
                    if ( ($Gsct_thursday_start < $aryC[3]) && ($Gsct_thursday_stop > 0) ) {$Gsct_thursday_start = $aryC[3];}
                    if ( ($Gsct_thursday_stop > $aryC[4]) && ($Gsct_thursday_stop > 0) )  {$Gsct_thursday_stop = $aryC[4];}
                    if ( ($Gsct_friday_start < $aryC[3]) && ($Gsct_friday_stop > 0) )   {$Gsct_friday_start = $aryC[3];}
                    if ( ($Gsct_friday_stop > $aryC[4]) && ($Gsct_friday_stop > 0) )    {$Gsct_friday_stop = $aryC[4];}
                    if ( ($Gsct_saturday_start < $aryC[3]) && ($Gsct_saturday_stop > 0) ) {$Gsct_saturday_start = $aryC[3];}
                    if ( ($Gsct_saturday_stop > $aryC[4]) && ($Gsct_saturday_stop > 0) )  {$Gsct_saturday_stop = $aryC[4];}
                    if ($DB) {echo "$holidaytype   |$Gstate_call_time_id|$Gstate_call_time_state|$Sholiday_id|$Sholiday_date|$Sholiday_name|$Gsct_default_start|$Gsct_default_stop|\n";}
                    }
                  }
                }
              }
            }
          $b++;
          }
        }
        ### END Check for outbound state holiday ###
      if(strlen($Gstate_call_time_id)>2){
        # STATE RULES
        if ($GMT_day==0)  #### Sunday local time
          {
          if (($Gsct_sunday_start==0) && ($Gsct_sunday_stop==0))
            {
            if ( ($GMT_hour>=$Gsct_default_start) && ($GMT_hour<$Gsct_default_stop) )
              {$dialable=1;}
            }
          else
            {
            if ( ($GMT_hour>=$Gsct_sunday_start) && ($GMT_hour<$Gsct_sunday_stop) )
              {$dialable=1;}
            }
          }
        if ($GMT_day==1)  #### Monday local time
          {
          if (($Gsct_monday_start==0) && ($Gsct_monday_stop==0))
            {
            if ( ($GMT_hour>=$Gsct_default_start) && ($GMT_hour<$Gsct_default_stop) )
              {$dialable=1;}
            }
          else
            {
            if ( ($GMT_hour>=$Gsct_monday_start) && ($GMT_hour<$Gsct_monday_stop) )
              {$dialable=1;}
            }
          }
        if ($GMT_day==2)  #### Tuesday local time
          {
          if (($Gsct_tuesday_start==0) && ($Gsct_tuesday_stop==0))
            {
            if ( ($GMT_hour>=$Gsct_default_start) && ($GMT_hour<$Gsct_default_stop) )
              {$dialable=1;}
            }
          else
            {
            if ( ($GMT_hour>=$Gsct_tuesday_start) && ($GMT_hour<$Gsct_tuesday_stop) )
              {$dialable=1;}
            }
          }
        if ($GMT_day==3)  #### Wednesday local time
          {
          if (($Gsct_wednesday_start==0) && ($Gsct_wednesday_stop==0))
            {
            if ( ($GMT_hour>=$Gsct_default_start) && ($GMT_hour<$Gsct_default_stop) )
              {$dialable=1;}
            }
          else
            {
            if ( ($GMT_hour>=$Gsct_wednesday_start) && ($GMT_hour<$Gsct_wednesday_stop) )
              {$dialable=1;}
            }
          }
        if ($GMT_day==4)  #### Thursday local time
          {
          if (($Gsct_thursday_start==0) && ($Gsct_thursday_stop==0))
            {
            if ( ($GMT_hour>=$Gsct_default_start) && ($GMT_hour<$Gsct_default_stop) )
              {$dialable=1;}
            }
          else
            {
            if ( ($GMT_hour>=$Gsct_thursday_start) && ($GMT_hour<$Gsct_thursday_stop) )
              {$dialable=1;}
            }
          }
        if ($GMT_day==5)  #### Friday local time
          {
          if (($Gsct_friday_start==0) && ($Gsct_friday_stop==0))
            {
            if ( ($GMT_hour>=$Gsct_default_start) && ($GMT_hour<$Gsct_default_stop) )
              {$dialable=1;}
            }
          else
            {
            if ( ($GMT_hour>=$Gsct_friday_start) && ($GMT_hour<$Gsct_friday_stop) )
              {$dialable=1;}
            }
          }
        if ($GMT_day==6)  #### Saturday local time
          {
          if (($Gsct_saturday_start==0) && ($Gsct_saturday_stop==0))
            {
            if ( ($GMT_hour>=$Gsct_default_start) && ($GMT_hour<$Gsct_default_stop) )
              {$dialable=1;}
            }
          else
            {
            if ( ($GMT_hour>=$Gsct_saturday_start) && ($GMT_hour<$Gsct_saturday_stop) )
              {$dialable=1;}
            }
          }
    } else {    
        #NO STATE RULES
        if ($GMT_day==0)  #### Sunday local time
          {
          if (($Gct_sunday_start==0) and ($Gct_sunday_stop==0))
            {
            if ( ($GMT_hour>=$Gct_default_start) and ($GMT_hour<$Gct_default_stop) )
              {$dialable=1;}
            }
          else
            {
            if ( ($GMT_hour>=$Gct_sunday_start) and ($GMT_hour<$Gct_sunday_stop) )
              {$dialable=1;}
            }
          }
        if ($GMT_day==1)  #### Monday local time
          {
          if (($Gct_monday_start==0) and ($Gct_monday_stop==0))
            {
            if ( ($GMT_hour>=$Gct_default_start) and ($GMT_hour<$Gct_default_stop) )
              {$dialable=1;}
            }
          else
            {
            if ( ($GMT_hour>=$Gct_monday_start) and ($GMT_hour<$Gct_monday_stop) )
              {$dialable=1;}
            }
          }
        if ($GMT_day==2)  #### Tuesday local time
          {
          if (($Gct_tuesday_start==0) and ($Gct_tuesday_stop==0))
            {
            if ( ($GMT_hour>=$Gct_default_start) and ($GMT_hour<$Gct_default_stop) )
              {$dialable=1;}
            }
          else
            {
            if ( ($GMT_hour>=$Gct_tuesday_start) and ($GMT_hour<$Gct_tuesday_stop) )
              {$dialable=1;}
            }
          }
        if ($GMT_day==3)  #### Wednesday local time
          {
          if (($Gct_wednesday_start==0) and ($Gct_wednesday_stop==0))
            {
            if ( ($GMT_hour>=$Gct_default_start) and ($GMT_hour<$Gct_default_stop) )
              {$dialable=1;}
            }
          else
            {
            if ( ($GMT_hour>=$Gct_wednesday_start) and ($GMT_hour<$Gct_wednesday_stop) )
              {$dialable=1;}
            }
          }
        if ($GMT_day==4)  #### Thursday local time
          {
          if (($Gct_thursday_start==0) and ($Gct_thursday_stop==0))
            {
            if ( ($GMT_hour>=$Gct_default_start) and ($GMT_hour<$Gct_default_stop) )
              {$dialable=1;}
            }
          else
            {
            if ( ($GMT_hour>=$Gct_thursday_start) and ($GMT_hour<$Gct_thursday_stop) )
              {$dialable=1;}
            }
          }
        if ($GMT_day==5)  #### Friday local time
          {
          if (($Gct_friday_start==0) and ($Gct_friday_stop==0))
            {
            if ( ($GMT_hour>=$Gct_default_start) and ($GMT_hour<$Gct_default_stop) )
              {$dialable=1;}
            }
          else
            {
            if ( ($GMT_hour>=$Gct_friday_start) and ($GMT_hour<$Gct_friday_stop) )
              {$dialable=1;}
            }
          }
        if ($GMT_day==6)  #### Saturday local time
          {
          if (($Gct_saturday_start==0) and ($Gct_saturday_stop==0))
            {
            if ( ($GMT_hour>=$Gct_default_start) and ($GMT_hour<$Gct_default_stop) )
              {$dialable=1;}
            }
          else
            {
            if ( ($GMT_hour>=$Gct_saturday_start) and ($GMT_hour<$Gct_saturday_stop) )
              {$dialable=1;}
            }
          }
      }
  return $dialable;
  }



##### CALCULATE DIALABLE LEADS #####
function dialable_leads($DB,$link,$local_call_time,$dial_statuses,$camp_lists,$drop_lockout_time,$call_count_limit,$single_status,$fSQL)
{
##### BEGIN calculate what gmt_offset_now values are within the allowed local_call_time setting ###
if (isset($camp_lists))
  {
  if (strlen($camp_lists)>1)
    {
    if (strlen($dial_statuses)>2)
      {
      $g=0;
      $p='13';
      $GMT_gmt[0] = '';
      $GMT_hour[0] = '';
      $GMT_day[0] = '';
      $YMD =  date("Y-m-d");  
      while ($p > -13)
        {
        $pzone=3600 * $p;
        $pmin=(gmdate("i", time() + $pzone));
        $phour=( (gmdate("G", time() + $pzone)) * 100);
        $pday=gmdate("w", time() + $pzone);
        $tz = sprintf("%.2f", $p);  
        $GMT_gmt[$g] = "$tz";
        $GMT_day[$g] = "$pday";
        $GMT_hour[$g] = ($phour + $pmin);
        $p = ($p - 0.25);
        $g++;
        }

      $stmt="SELECT call_time_id,call_time_name,call_time_comments,ct_default_start,ct_default_stop,ct_sunday_start,ct_sunday_stop,ct_monday_start,ct_monday_stop,ct_tuesday_start,ct_tuesday_stop,ct_wednesday_start,ct_wednesday_stop,ct_thursday_start,ct_thursday_stop,ct_friday_start,ct_friday_stop,ct_saturday_start,ct_saturday_stop,ct_state_call_times FROM vicidial_call_times where call_time_id='$local_call_time';";
      if ($DB) {echo "$stmt\n";}
      $rslt=$this->mysql_to_mysqli($stmt, $link);
      $rowx=mysqli_fetch_row($rslt);
      $Gct_default_start =  $rowx[3];
      $Gct_default_stop =   $rowx[4];
      $Gct_sunday_start =   $rowx[5];
      $Gct_sunday_stop =    $rowx[6];
      $Gct_monday_start =   $rowx[7];
      $Gct_monday_stop =    $rowx[8];
      $Gct_tuesday_start =  $rowx[9];
      $Gct_tuesday_stop =   $rowx[10];
      $Gct_wednesday_start =  $rowx[11];
      $Gct_wednesday_stop = $rowx[12];
      $Gct_thursday_start = $rowx[13];
      $Gct_thursday_stop =  $rowx[14];
      $Gct_friday_start =   $rowx[15];
      $Gct_friday_stop =    $rowx[16];
      $Gct_saturday_start = $rowx[17];
      $Gct_saturday_stop =  $rowx[18];
      $Gct_state_call_times = $rowx[19];
      $Gct_holidays =     $rowx[20];

      ### BEGIN Check for outbound holiday ###
      $holiday_id = '';
      if (strlen($Gct_holidays)>2)
        {
        $Gct_holidaysSQL = preg_replace("/\|/", "','", "$Gct_holidays");
        $Gct_holidaysSQL = "'".$Gct_holidaysSQL."'";
        
        $stmt = "SELECT holiday_id,holiday_date,holiday_name,ct_default_start,ct_default_stop from vicidial_call_time_holidays where holiday_id IN($Gct_holidaysSQL) and holiday_status='ACTIVE' and holiday_date='$YMD' order by holiday_id;";
        $rslt=$this->mysql_to_mysqli($stmt, $link);
        if ($DB) {echo "$stmt\n";}
        $sthCrows=mysqli_num_rows($rslt);
        if ($sthCrows > 0)
          {
          $aryC=mysqli_fetch_row($rslt);
          $holiday_id =       $aryC[0];
          $holiday_date =       $aryC[1];
          $holiday_name =       $aryC[2];
          if($Gct_default_start < $aryC[3])   {$Gct_default_start = $aryC[3];}
          if($Gct_default_stop > $aryC[4])    {$Gct_default_stop = $aryC[4];}           
          if($Gct_sunday_start < $aryC[3])    {$Gct_sunday_start = $aryC[3];}
          if($Gct_sunday_stop > $aryC[4])     {$Gct_sunday_stop = $aryC[4];}
          if($Gct_monday_start < $aryC[3])    {$Gct_monday_start = $aryC[3];}
          if($Gct_monday_stop > $aryC[4])   {$Gct_monday_stop = $aryC[4];}
          if($Gct_tuesday_start < $aryC[3])   {$Gct_tuesday_start = $aryC[3];}
          if($Gct_tuesday_stop > $aryC[4])    {$Gct_tuesday_stop = $aryC[4];}
          if($Gct_wednesday_start < $aryC[3])   {$Gct_wednesday_start = $aryC[3];}
          if($Gct_wednesday_stop > $aryC[4])    {$Gct_wednesday_stop = $aryC[4];}
          if($Gct_thursday_start < $aryC[3])    {$Gct_thursday_start = $aryC[3];}
          if($Gct_thursday_stop > $aryC[4])   {$Gct_thursday_stop = $aryC[4];}
          if($Gct_friday_start < $aryC[3])    {$Gct_friday_start = $aryC[3];}
          if($Gct_friday_stop > $aryC[4])     {$Gct_friday_stop = $aryC[4];}
          if($Gct_saturday_start < $aryC[3])    {$Gct_saturday_start = $aryC[3];}
          if($Gct_saturday_stop > $aryC[4])   {$Gct_saturday_stop = $aryC[4];}
          if ($DB) {echo "CALL TIME HOLIDAY FOUND!   $local_call_time|$holiday_id|$holiday_date|$holiday_name|$Gct_default_start|$Gct_default_stop|\n";}
          }
        }
      ### END Check for outbound holiday ###

      $ct_states = '';
      $ct_state_gmt_SQL = '';
      $ct_srs=0;
      $b=0;
      if (strlen($Gct_state_call_times)>2)
        {
        $state_rules = explode('|',$Gct_state_call_times);
        $ct_srs = ((count($state_rules)) - 2);
        }
      while($ct_srs >= $b)
        {
        if (strlen($state_rules[$b])>1)
          {
          $stmt="SELECT state_call_time_id,state_call_time_state,state_call_time_name,state_call_time_comments,sct_default_start,sct_default_stop,sct_sunday_start,sct_sunday_stop,sct_monday_start,sct_monday_stop,sct_tuesday_start,sct_tuesday_stop,sct_wednesday_start,sct_wednesday_stop,sct_thursday_start,sct_thursday_stop,sct_friday_start,sct_friday_stop,sct_saturday_start,sct_saturday_stop from vicidial_state_call_times where state_call_time_id='$state_rules[$b]';";
          $rslt=$this->mysql_to_mysqli($stmt, $link);
          $row=mysqli_fetch_row($rslt);
          $Gstate_call_time_id =    $row[0];
          $Gstate_call_time_state = $row[1];
          $Gsct_default_start =   $row[4];
          $Gsct_default_stop =    $row[5];
          $Gsct_sunday_start =    $row[6];
          $Gsct_sunday_stop =     $row[7];
          $Gsct_monday_start =    $row[8];
          $Gsct_monday_stop =     $row[9];
          $Gsct_tuesday_start =   $row[10];
          $Gsct_tuesday_stop =    $row[11];
          $Gsct_wednesday_start =   $row[12];
          $Gsct_wednesday_stop =    $row[13];
          $Gsct_thursday_start =    $row[14];
          $Gsct_thursday_stop =   $row[15];
          $Gsct_friday_start =    $row[16];
          $Gsct_friday_stop =     $row[17];
          $Gsct_saturday_start =    $row[18];
          $Gsct_saturday_stop =   $row[19];
          $Sct_holidays =       $row[20];
          $ct_states .="'$Gstate_call_time_state',";

          ### BEGIN Check for outbound state holiday ###
          $Sholiday_id = '';
          if ((strlen($Sct_holidays)>2) or ((strlen($holiday_id)>2) and (strlen($Sholiday_id)<2))) 
            {
            # Apply state holiday
            if (strlen($Sct_holidays)>2)
              {               
              $Sct_holidaysSQL = preg_replace("/\|/", "','", "$Sct_holidays");
              $Sct_holidaysSQL = "'".$Sct_holidaysSQL."'";
              $stmt = "SELECT holiday_id,holiday_date,holiday_name,ct_default_start,ct_default_stop from vicidial_call_time_holidays where holiday_id IN($Sct_holidaysSQL) and holiday_status='ACTIVE' and holiday_date='$YMD' order by holiday_id;";
              $holidaytype = "STATE CALL TIME HOLIDAY FOUND!   ";
              }
            # Apply call time wide holiday
            elseif ((strlen($holiday_id)>2) and (strlen($Sholiday_id)<2))
              {
              $stmt = "SELECT holiday_id,holiday_date,holiday_name,ct_default_start,ct_default_stop from vicidial_call_time_holidays where holiday_id='$holiday_id' and holiday_status='ACTIVE' and holiday_date='$YMD' order by holiday_id;";
              $holidaytype = "NO STATE HOLIDAY APPLYING CALL TIME HOLIDAY!   ";
              }       
            $rslt=$this->mysql_to_mysqli($stmt, $link);
            if ($DB) {echo "$stmt\n";}
            $sthCrows=mysqli_num_rows($rslt);
            if ($sthCrows > 0)
              {
              $aryC=mysqli_fetch_row($rslt);
              $Sholiday_id =        $aryC[0];
              $Sholiday_date =      $aryC[1];
              $Sholiday_name =      $aryC[2];
              if ( ($Gsct_default_start < $aryC[3]) && ($Gsct_default_stop > 0) )   {$Gsct_default_start = $aryC[3];}
              if ( ($Gsct_default_stop > $aryC[4]) && ($Gsct_default_stop > 0) )    {$Gsct_default_stop = $aryC[4];}
              if ( ($Gsct_sunday_start < $aryC[3]) && ($Gsct_sunday_stop > 0) )   {$Gsct_sunday_start = $aryC[3];}
              if ( ($Gsct_sunday_stop > $aryC[4]) && ($Gsct_sunday_stop > 0) )    {$Gsct_sunday_stop = $aryC[4];}
              if ( ($Gsct_monday_start < $aryC[3]) && ($Gsct_monday_stop > 0) )   {$Gsct_monday_start = $aryC[3];}
              if ( ($Gsct_monday_stop > $aryC[4]) && ($Gsct_monday_stop > 0) )    {$Gsct_monday_stop = $aryC[4];}
              if ( ($Gsct_tuesday_start < $aryC[3]) && ($Gsct_tuesday_stop > 0) )   {$Gsct_tuesday_start = $aryC[3];}
              if ( ($Gsct_tuesday_stop > $aryC[4]) && ($Gsct_tuesday_stop > 0) )    {$Gsct_tuesday_stop = $aryC[4];}
              if ( ($Gsct_wednesday_start < $aryC[3]) && ($Gsct_wednesday_stop > 0) ) {$Gsct_wednesday_start = $aryC[3];}
              if ( ($Gsct_wednesday_stop > $aryC[4]) && ($Gsct_wednesday_stop > 0) )  {$Gsct_wednesday_stop = $aryC[4];}
              if ( ($Gsct_thursday_start < $aryC[3]) && ($Gsct_thursday_stop > 0) ) {$Gsct_thursday_start = $aryC[3];}
              if ( ($Gsct_thursday_stop > $aryC[4]) && ($Gsct_thursday_stop > 0) )  {$Gsct_thursday_stop = $aryC[4];}
              if ( ($Gsct_friday_start < $aryC[3]) && ($Gsct_friday_stop > 0) )   {$Gsct_friday_start = $aryC[3];}
              if ( ($Gsct_friday_stop > $aryC[4]) && ($Gsct_friday_stop > 0) )    {$Gsct_friday_stop = $aryC[4];}
              if ( ($Gsct_saturday_start < $aryC[3]) && ($Gsct_saturday_stop > 0) ) {$Gsct_saturday_start = $aryC[3];}
              if ( ($Gsct_saturday_stop > $aryC[4]) && ($Gsct_saturday_stop > 0) )  {$Gsct_saturday_stop = $aryC[4];}
              if ($DB) {echo "$holidaytype   |$Gstate_call_time_id|$Gstate_call_time_state|$Sholiday_id|$Sholiday_date|$Sholiday_name|$Gsct_default_start|$Gsct_default_stop|\n";}
              }
            }
          $r=0;
          $state_gmt='';
          while($r < $g)
            {
            if ($GMT_day[$r]==0)  #### Sunday local time
              {
              if (($Gsct_sunday_start==0) and ($Gsct_sunday_stop==0))
                {
                if ( ($GMT_hour[$r]>=$Gsct_default_start) and ($GMT_hour[$r]<$Gsct_default_stop) )
                  {$state_gmt.="'$GMT_gmt[$r]',";}
                }
              else
                {
                if ( ($GMT_hour[$r]>=$Gsct_sunday_start) and ($GMT_hour[$r]<$Gsct_sunday_stop) )
                  {$state_gmt.="'$GMT_gmt[$r]',";}
                }
              }
            if ($GMT_day[$r]==1)  #### Monday local time
              {
              if (($Gsct_monday_start==0) and ($Gsct_monday_stop==0))
                {
                if ( ($GMT_hour[$r]>=$Gsct_default_start) and ($GMT_hour[$r]<$Gsct_default_stop) )
                  {$state_gmt.="'$GMT_gmt[$r]',";}
                }
              else
                {
                if ( ($GMT_hour[$r]>=$Gsct_monday_start) and ($GMT_hour[$r]<$Gsct_monday_stop) )
                  {$state_gmt.="'$GMT_gmt[$r]',";}
                }
              }
            if ($GMT_day[$r]==2)  #### Tuesday local time
              {
              if (($Gsct_tuesday_start==0) and ($Gsct_tuesday_stop==0))
                {
                if ( ($GMT_hour[$r]>=$Gsct_default_start) and ($GMT_hour[$r]<$Gsct_default_stop) )
                  {$state_gmt.="'$GMT_gmt[$r]',";}
                }
              else
                {
                if ( ($GMT_hour[$r]>=$Gsct_tuesday_start) and ($GMT_hour[$r]<$Gsct_tuesday_stop) )
                  {$state_gmt.="'$GMT_gmt[$r]',";}
                }
              }
            if ($GMT_day[$r]==3)  #### Wednesday local time
              {
              if (($Gsct_wednesday_start==0) and ($Gsct_wednesday_stop==0))
                {
                if ( ($GMT_hour[$r]>=$Gsct_default_start) and ($GMT_hour[$r]<$Gsct_default_stop) )
                  {$state_gmt.="'$GMT_gmt[$r]',";}
                }
              else
                {
                if ( ($GMT_hour[$r]>=$Gsct_wednesday_start) and ($GMT_hour[$r]<$Gsct_wednesday_stop) )
                  {$state_gmt.="'$GMT_gmt[$r]',";}
                }
              }
            if ($GMT_day[$r]==4)  #### Thursday local time
              {
              if (($Gsct_thursday_start==0) and ($Gsct_thursday_stop==0))
                {
                if ( ($GMT_hour[$r]>=$Gsct_default_start) and ($GMT_hour[$r]<$Gsct_default_stop) )
                  {$state_gmt.="'$GMT_gmt[$r]',";}
                }
              else
                {
                if ( ($GMT_hour[$r]>=$Gsct_thursday_start) and ($GMT_hour[$r]<$Gsct_thursday_stop) )
                  {$state_gmt.="'$GMT_gmt[$r]',";}
                }
              }
            if ($GMT_day[$r]==5)  #### Friday local time
              {
              if (($Gsct_friday_start==0) and ($Gsct_friday_stop==0))
                {
                if ( ($GMT_hour[$r]>=$Gsct_default_start) and ($GMT_hour[$r]<$Gsct_default_stop) )
                  {$state_gmt.="'$GMT_gmt[$r]',";}
                }
              else
                {
                if ( ($GMT_hour[$r]>=$Gsct_friday_start) and ($GMT_hour[$r]<$Gsct_friday_stop) )
                  {$state_gmt.="'$GMT_gmt[$r]',";}
                }
              }
            if ($GMT_day[$r]==6)  #### Saturday local time
              {
              if (($Gsct_saturday_start==0) and ($Gsct_saturday_stop==0))
                {
                if ( ($GMT_hour[$r]>=$Gsct_default_start) and ($GMT_hour[$r]<$Gsct_default_stop) )
                  {$state_gmt.="'$GMT_gmt[$r]',";}
                }
              else
                {
                if ( ($GMT_hour[$r]>=$Gsct_saturday_start) and ($GMT_hour[$r]<$Gsct_saturday_stop) )
                  {$state_gmt.="'$GMT_gmt[$r]',";}
                }
              }
            $r++;
            }
          $state_gmt = "$state_gmt'99'";
          $ct_state_gmt_SQL .= "or (state='$Gstate_call_time_state' and gmt_offset_now IN($state_gmt)) ";
          }

        $b++;
        }
      if (strlen($ct_states)>2)
        {
        $ct_states = preg_replace('/,$/i', '',$ct_states);
        $ct_statesSQL = "and state NOT IN($ct_states)";
        }
      else
        {
        $ct_statesSQL = "";
        }

      $r=0;
      $default_gmt='';
      while($r < $g)
        {
        if ($GMT_day[$r]==0)  #### Sunday local time
          {
          if (($Gct_sunday_start==0) and ($Gct_sunday_stop==0))
            {
            if ( ($GMT_hour[$r]>=$Gct_default_start) and ($GMT_hour[$r]<$Gct_default_stop) )
              {$default_gmt.="'$GMT_gmt[$r]',";}
            }
          else
            {
            if ( ($GMT_hour[$r]>=$Gct_sunday_start) and ($GMT_hour[$r]<$Gct_sunday_stop) )
              {$default_gmt.="'$GMT_gmt[$r]',";}
            }
          }
        if ($GMT_day[$r]==1)  #### Monday local time
          {
          if (($Gct_monday_start==0) and ($Gct_monday_stop==0))
            {
            if ( ($GMT_hour[$r]>=$Gct_default_start) and ($GMT_hour[$r]<$Gct_default_stop) )
              {$default_gmt.="'$GMT_gmt[$r]',";}
            }
          else
            {
            if ( ($GMT_hour[$r]>=$Gct_monday_start) and ($GMT_hour[$r]<$Gct_monday_stop) )
              {$default_gmt.="'$GMT_gmt[$r]',";}
            }
          }
        if ($GMT_day[$r]==2)  #### Tuesday local time
          {
          if (($Gct_tuesday_start==0) and ($Gct_tuesday_stop==0))
            {
            if ( ($GMT_hour[$r]>=$Gct_default_start) and ($GMT_hour[$r]<$Gct_default_stop) )
              {$default_gmt.="'$GMT_gmt[$r]',";}
            }
          else
            {
            if ( ($GMT_hour[$r]>=$Gct_tuesday_start) and ($GMT_hour[$r]<$Gct_tuesday_stop) )
              {$default_gmt.="'$GMT_gmt[$r]',";}
            }
          }
        if ($GMT_day[$r]==3)  #### Wednesday local time
          {
          if (($Gct_wednesday_start==0) and ($Gct_wednesday_stop==0))
            {
            if ( ($GMT_hour[$r]>=$Gct_default_start) and ($GMT_hour[$r]<$Gct_default_stop) )
              {$default_gmt.="'$GMT_gmt[$r]',";}
            }
          else
            {
            if ( ($GMT_hour[$r]>=$Gct_wednesday_start) and ($GMT_hour[$r]<$Gct_wednesday_stop) )
              {$default_gmt.="'$GMT_gmt[$r]',";}
            }
          }
        if ($GMT_day[$r]==4)  #### Thursday local time
          {
          if (($Gct_thursday_start==0) and ($Gct_thursday_stop==0))
            {
            if ( ($GMT_hour[$r]>=$Gct_default_start) and ($GMT_hour[$r]<$Gct_default_stop) )
              {$default_gmt.="'$GMT_gmt[$r]',";}
            }
          else
            {
            if ( ($GMT_hour[$r]>=$Gct_thursday_start) and ($GMT_hour[$r]<$Gct_thursday_stop) )
              {$default_gmt.="'$GMT_gmt[$r]',";}
            }
          }
        if ($GMT_day[$r]==5)  #### Friday local time
          {
          if (($Gct_friday_start==0) and ($Gct_friday_stop==0))
            {
            if ( ($GMT_hour[$r]>=$Gct_default_start) and ($GMT_hour[$r]<$Gct_default_stop) )
              {$default_gmt.="'$GMT_gmt[$r]',";}
            }
          else
            {
            if ( ($GMT_hour[$r]>=$Gct_friday_start) and ($GMT_hour[$r]<$Gct_friday_stop) )
              {$default_gmt.="'$GMT_gmt[$r]',";}
            }
          }
        if ($GMT_day[$r]==6)  #### Saturday local time
          {
          if (($Gct_saturday_start==0) and ($Gct_saturday_stop==0))
            {
            if ( ($GMT_hour[$r]>=$Gct_default_start) and ($GMT_hour[$r]<$Gct_default_stop) )
              {$default_gmt.="'$GMT_gmt[$r]',";}
            }
          else
            {
            if ( ($GMT_hour[$r]>=$Gct_saturday_start) and ($GMT_hour[$r]<$Gct_saturday_stop) )
              {$default_gmt.="'$GMT_gmt[$r]',";}
            }
          }
        $r++;
        }

      $default_gmt = "$default_gmt'99'";
      $all_gmtSQL = "(gmt_offset_now IN($default_gmt) $ct_statesSQL) $ct_state_gmt_SQL";

      $dial_statuses = preg_replace("/ -$/","",$dial_statuses);
      $Dstatuses = explode(" ", $dial_statuses);
      $Ds_to_print = (count($Dstatuses) - 0);
      $Dsql = '';
      $o=0;
      while ($Ds_to_print > $o) 
        {
        $o++;
        $Dsql .= "'$Dstatuses[$o]',";
        }
      $Dsql = preg_replace("/,$/","",$Dsql);
      if (strlen($Dsql) < 2) {$Dsql = "''";}

      $DLTsql='';
      if ($drop_lockout_time > 0)
        {
        $DLseconds = ($drop_lockout_time * 3600);
        $DLseconds = floor($DLseconds);
        $DLseconds = intval("$DLseconds");
        $DLTsql = "and ( ( (status IN('DROP','XDROP')) and (last_local_call_time < CONCAT(DATE_ADD(NOW(), INTERVAL -$DLseconds SECOND),' ',CURTIME()) ) ) or (status NOT IN('DROP','XDROP')) )";
        }

      $CCLsql='';
      if ($call_count_limit > 0)
        {
        $CCLsql = "and (called_count < $call_count_limit)";
        }

      $EXPsql='';
      $expired_lists='';
      $REPORTdate = date("Y-m-d");
      $stmt="SELECT list_id FROM vicidial_lists where list_id IN($camp_lists) and (active='Y') and (expiration_date < \"$REPORTdate\");";
      #$DB=1;
      if ($DB) {echo "$stmt\n";}
      $rslt=$this->mysql_to_mysqli($stmt, $link);
      $rslt_rows = mysqli_num_rows($rslt);
      $f=0;
      while ($rslt_rows > $f)
        {
        $rowx=mysqli_fetch_row($rslt);
        $expired_lists .= "'$rowx[0]',";
        $f++;
        }
      $expired_lists = preg_replace("/,$/",'',$expired_lists);
      if (strlen($expired_lists) < 2) {$expired_lists = "''";}
      $EXPsql = "and list_id NOT IN($expired_lists)";


      #################################               
      # Camp List
      $stmt="SELECT list_id FROM vicidial_lists where list_id IN($camp_lists) and active='Y';";
      $rslt_list=$this->mysql_to_mysqli($stmt, $link);
      $camplists_ct = mysqli_num_rows($rslt_list);
      if ($DB) {echo "$camplists_ct|$stmt\n";}
      $k=0;
      $camp_lists='';
      while ($camplists_ct > $k)
        {
        $rowA = mysqli_fetch_row($rslt_list);
        $camp_lists .=  "'$rowA[0]',";

        ##### Get Call List call time settings
        ##### BEGIN calculate what gmt_offset_now values are within the allowed local_call_time setting ###
        $g=0;
        $p='13';
        $GMT_gmt[0] = '';
        $GMT_hour[0] = '';
        $GMT_day[0] = '';
        $YMD =  date("Y-m-d");
        while ($p > -13)
          {
          $pzone=3600 * $p;
          $pmin=(gmdate("i", time() + $pzone));
          $phour=( (gmdate("G", time() + $pzone)) * 100);
          $pday=gmdate("w", time() + $pzone);
          $tz = sprintf("%.2f", $p);  
          $GMT_gmt[$g] = "$tz";
          $GMT_day[$g] = "$pday";
          $GMT_hour[$g] = ($phour + $pmin);
          $p = ($p - 0.25);
          $g++;
          }

        # Set List ID Variable
        $cur_list_id = $rowA[0];      
        $list_local_call_time = "";

        # Pull the call times for the lists
        $stmt="SELECT local_call_time FROM vicidial_lists where list_id='$cur_list_id';";
        $rslt=$this->mysql_to_mysqli($stmt, $link);
        $rslt_ct = mysqli_num_rows($rslt);
        if ($rslt_ct > 0)
          {
          #set Cur call_time
          $row=mysqli_fetch_row($rslt);
          $cur_call_time  = $row[0];
          }

        # check that call time exists
        if ($cur_call_time != "campaign") 
          {
          $stmt="SELECT count(*) from vicidial_call_times where call_time_id='$cur_call_time';";
          $rslt=$this->mysql_to_mysqli($stmt, $link);
          $row=mysqli_fetch_row($rslt);
          $call_time_exists  =  $row[0];
          if ($call_time_exists < 1) 
            {$cur_call_time = 'campaign';}
          }

        ##### BEGIN local call time for list set different than campaign #####
        if ($cur_call_time != "campaign")
          {
          ##### BEGIN calculate what gmt_offset_now values are within the allowed local_call_time setting ###
          $stmt = "SELECT call_time_id,call_time_name,call_time_comments,ct_default_start,ct_default_stop,ct_sunday_start,ct_sunday_stop,ct_monday_start,ct_monday_stop,ct_tuesday_start,ct_tuesday_stop,ct_wednesday_start,ct_wednesday_stop,ct_thursday_start,ct_thursday_stop,ct_friday_start,ct_friday_stop,ct_saturday_start,ct_saturday_stop,ct_state_call_times,ct_holidays FROM vicidial_call_times where call_time_id='$cur_call_time';";
          if ($DB) {echo "$stmt\n";}
          $rsltD=$this->mysql_to_mysqli($stmt, $link);
          $aryD=mysqli_fetch_row($rsltD);
          $Gct_default_start =  $aryD[3];
          $Gct_default_stop =   $aryD[4];
          $Gct_sunday_start =   $aryD[5];
          $Gct_sunday_stop =    $aryD[6];
          $Gct_monday_start =   $aryD[7];
          $Gct_monday_stop =    $aryD[8];
          $Gct_tuesday_start =  $aryD[9];
          $Gct_tuesday_stop =   $aryD[10];
          $Gct_wednesday_start =  $aryD[11];
          $Gct_wednesday_stop = $aryD[12];
          $Gct_thursday_start = $aryD[13];
          $Gct_thursday_stop =  $aryD[14];
          $Gct_friday_start =   $aryD[15];
          $Gct_friday_stop =    $aryD[16];
          $Gct_saturday_start = $aryD[17];
          $Gct_saturday_stop =  $aryD[18];
          $Gct_state_call_times = $aryD[19];
          $Gct_holidays =     $aryD[20];

          ### BEGIN Check for outbound holiday ###
          $holiday_id = '';
          if (strlen($Gct_holidays)>2)
            {
            $Gct_holidaysSQL = preg_replace("/\|/", "','", "$Gct_holidays");
            $Gct_holidaysSQL = "'".$Gct_holidaysSQL."'";
            
            $stmt = "SELECT holiday_id,holiday_date,holiday_name,ct_default_start,ct_default_stop from vicidial_call_time_holidays where holiday_id IN($Gct_holidaysSQL) and holiday_status='ACTIVE' and holiday_date='$YMD' order by holiday_id;";
            $rslt=$this->mysql_to_mysqli($stmt, $link);
            $sthCrows=mysqli_num_rows($rslt);
            if ($sthCrows > 0)
              {
              $aryC=mysqli_fetch_row($rslt);
              $holiday_id =       $aryC[0];
              $holiday_date =       $aryC[1];
              $holiday_name =       $aryC[2];
              if ( ($Gct_default_start < $aryC[3]) && ($Gct_default_stop > 0) )   {$Gct_default_start = $aryC[3];}
              if ( ($Gct_default_stop > $aryC[4]) && ($Gct_default_stop > 0) )    {$Gct_default_stop = $aryC[4];}
              if ( ($Gct_sunday_start < $aryC[3]) && ($Gct_sunday_stop > 0) )     {$Gct_sunday_start = $aryC[3];}
              if ( ($Gct_sunday_stop > $aryC[4]) && ($Gct_sunday_stop > 0) )      {$Gct_sunday_stop = $aryC[4];}
              if ( ($Gct_monday_start < $aryC[3]) && ($Gct_monday_stop > 0) )     {$Gct_monday_start = $aryC[3];}
              if ( ($Gct_monday_stop >  $aryC[4]) && ($Gct_monday_stop > 0) )   {$Gct_monday_stop = $aryC[4];}
              if ( ($Gct_tuesday_start < $aryC[3]) && ($Gct_tuesday_stop > 0) )   {$Gct_tuesday_start = $aryC[3];}
              if ( ($Gct_tuesday_stop > $aryC[4]) && ($Gct_tuesday_stop > 0) )    {$Gct_tuesday_stop = $aryC[4];}
              if ( ($Gct_wednesday_start < $aryC[3]) && ($Gct_wednesday_stop > 0) )   {$Gct_wednesday_start = $aryC[3];}
              if ( ($Gct_wednesday_stop > $aryC[4]) && ($Gct_wednesday_stop > 0) )  {$Gct_wednesday_stop = $aryC[4];}
              if ( ($Gct_thursday_start < $aryC[3]) && ($Gct_thursday_stop > 0) )   {$Gct_thursday_start = $aryC[3];}
              if ( ($Gct_thursday_stop > $aryC[4]) && ($Gct_thursday_stop > 0) )    {$Gct_thursday_stop = $aryC[4];}
              if ( ($Gct_friday_start < $aryC[3]) && ($Gct_friday_stop > 0) )     {$Gct_friday_start = $aryC[3];}
              if ( ($Gct_friday_stop > $aryC[4]) && ($Gct_friday_stop > 0) )      {$Gct_friday_stop = $aryC[4];}
              if ( ($Gct_saturday_start < $aryC[3]) && ($Gct_saturday_stop > 0) )   {$Gct_saturday_start = $aryC[3];}
              if ( ($Gct_saturday_stop > $aryC[4]) && ($Gct_saturday_stop > 0) )    {$Gct_saturday_stop = $aryC[4];}
              if ($DB) {echo "LIST CALL TIME HOLIDAY FOUND!   $local_call_time|$holiday_id|$holiday_date|$holiday_name|$Gct_default_start|$Gct_default_stop|\n";}
              }
            }
          ### END Check for outbound holiday ###

          $ct_states = '';
          $ct_state_gmt_SQL = '';
          $ct_srs=0;
          $b=0;
          if (strlen($Gct_state_call_times)>2)
            {
            $state_rules = explode('|',$Gct_state_call_times);
            $ct_srs = ((count($state_rules)) - 2);
            }
          while($ct_srs >= $b)
            {
            if (strlen($state_rules[$b])>1)
              {
              $stmt = "SELECT state_call_time_id,state_call_time_state,state_call_time_name,state_call_time_comments,sct_default_start,sct_default_stop,sct_sunday_start,sct_sunday_stop,sct_monday_start,sct_monday_stop,sct_tuesday_start,sct_tuesday_stop,sct_wednesday_start,sct_wednesday_stop,sct_thursday_start,sct_thursday_stop,sct_friday_start,sct_friday_stop,sct_saturday_start,sct_saturday_stop,ct_holidays from vicidial_state_call_times where state_call_time_id='$state_rules[$b]';";
              $rslt=$this->mysql_to_mysqli($stmt, $link);
              $sthCrows=mysqli_num_rows($rslt);
              if ($sthCrows > 0)
                {
                $aryC=mysqli_fetch_row($rslt);
                $Gstate_call_time_id =    $aryC[0];
                $Gstate_call_time_state = $aryC[1];
                $Gsct_default_start =   $aryC[4];
                $Gsct_default_stop =    $aryC[5];
                $Gsct_sunday_start =    $aryC[6];
                $Gsct_sunday_stop =     $aryC[7];
                $Gsct_monday_start =    $aryC[8];
                $Gsct_monday_stop =     $aryC[9];
                $Gsct_tuesday_start =   $aryC[10];
                $Gsct_tuesday_stop =    $aryC[11];
                $Gsct_wednesday_start =   $aryC[12];
                $Gsct_wednesday_stop =    $aryC[13];
                $Gsct_thursday_start =    $aryC[14];
                $Gsct_thursday_stop =   $aryC[15];
                $Gsct_friday_start =    $aryC[16];
                $Gsct_friday_stop =     $aryC[17];
                $Gsct_saturday_start =    $aryC[18];
                $Gsct_saturday_stop =   $aryC[19];
                $Sct_holidays =       $aryC[20];
                $ct_states .="'$Gstate_call_time_state',";
                }

              ### BEGIN Check for outbound state holiday ###
              $Sholiday_id = '';
              if ((strlen($Sct_holidays)>2) or ((strlen($holiday_id)>2) and (strlen($Sholiday_id)<2))) 
                {
                #Apply state holiday
                if (strlen($Sct_holidays)>2)
                  {               
                  $Sct_holidaysSQL = preg_replace("/\|/", "','", "$Sct_holidays");
                  $Sct_holidaysSQL = "'".$Sct_holidaysSQL."'";
                  $stmt = "SELECT holiday_id,holiday_date,holiday_name,ct_default_start,ct_default_stop from vicidial_call_time_holidays where holiday_id IN($Sct_holidaysSQL) and holiday_status='ACTIVE' and holiday_date='$YMD' order by holiday_id;";
                  $holidaytype = "LIST STATE CALL TIME HOLIDAY FOUND!   ";
                  }
                #Apply call time wide holiday
                elseif ((strlen($holiday_id)>2) and (strlen($Sholiday_id)<2))
                  {
                  $stmt = "SELECT holiday_id,holiday_date,holiday_name,ct_default_start,ct_default_stop from vicidial_call_time_holidays where holiday_id='$holiday_id' and holiday_status='ACTIVE' and holiday_date='$YMD' order by holiday_id;";
                  $holidaytype = "LIST NO STATE HOLIDAY APPLYING CALL TIME HOLIDAY!   ";
                  }       
                $rslt=$this->mysql_to_mysqli($stmt, $link);
                if ($DB) {echo "$stmt\n";}
                $sthCrows=mysqli_num_rows($rslt);
                if ($sthCrows > 0)
                  {
                  $aryC=mysqli_fetch_row($rslt);
                  $Sholiday_id =        $aryC[0];
                  $Sholiday_date =      $aryC[1];
                  $Sholiday_name =      $aryC[2];
                  if ( ($Gsct_default_start < $aryC[3]) && ($Gsct_default_stop > 0) )   {$Gsct_default_start = $aryC[3];}
                  if ( ($Gsct_default_stop > $aryC[4]) && ($Gsct_default_stop > 0) )    {$Gsct_default_stop = $aryC[4];}
                  if ( ($Gsct_sunday_start < $aryC[3]) && ($Gsct_sunday_stop > 0) )   {$Gsct_sunday_start = $aryC[3];}
                  if ( ($Gsct_sunday_stop > $aryC[4]) && ($Gsct_sunday_stop > 0) )    {$Gsct_sunday_stop = $aryC[4];}
                  if ( ($Gsct_monday_start < $aryC[3]) && ($Gsct_monday_stop > 0) )   {$Gsct_monday_start = $aryC[3];}
                  if ( ($Gsct_monday_stop > $aryC[4]) && ($Gsct_monday_stop > 0) )    {$Gsct_monday_stop =  $aryC[4];}
                  if ( ($Gsct_tuesday_start < $aryC[3]) && ($Gsct_tuesday_stop > 0) )   {$Gsct_tuesday_start = $aryC[3];}
                  if ( ($Gsct_tuesday_stop > $aryC[4]) && ($Gsct_tuesday_stop > 0) )    {$Gsct_tuesday_stop = $aryC[4];}
                  if ( ($Gsct_wednesday_start < $aryC[3]) && ($Gsct_wednesday_stop > 0) ) {$Gsct_wednesday_start = $aryC[3];}
                  if ( ($Gsct_wednesday_stop > $aryC[4]) && ($Gsct_wednesday_stop > 0) )  {$Gsct_wednesday_stop = $aryC[4];}
                  if ( ($Gsct_thursday_start < $aryC[3]) && ($Gsct_thursday_stop > 0) ) {$Gsct_thursday_start = $aryC[3];}
                  if ( ($Gsct_thursday_stop > $aryC[4]) && ($Gsct_thursday_stop > 0) )  {$Gsct_thursday_stop = $aryC[4];}
                  if ( ($Gsct_friday_start < $aryC[3]) && ($Gsct_friday_stop > 0) )   {$Gsct_friday_start = $aryC[3];}
                  if ( ($Gsct_friday_stop > $aryC[4]) && ($Gsct_friday_stop > 0) )    {$Gsct_friday_stop = $aryC[4];}
                  if ( ($Gsct_saturday_start < $aryC[3]) && ($Gsct_saturday_stop > 0) ) {$Gsct_saturday_start = $aryC[3];}
                  if ( ($Gsct_saturday_stop > $aryC[4]) && ($Gsct_saturday_stop > 0) )  {$Gsct_saturday_stop = $aryC[4];}
                  if ($DB) {echo "$holidaytype   |$Gstate_call_time_id|$Gstate_call_time_state|$Sholiday_id|$Sholiday_date|$Sholiday_name|$Gsct_default_start|$Gsct_default_stop|\n";}
                  }
                }
              ### END Check for outbound state holiday ###

              $r=0;
              $state_gmt='';
              $del_state_gmt='';
              while($r < $g)
                {
                if ($GMT_day[$r]==0)  #### Sunday local time
                  {
                  if (($Gsct_sunday_start==0) && ($Gsct_sunday_stop==0))
                    {
                    if ( ($GMT_hour[$r]>=$Gsct_default_start) && ($GMT_hour[$r]<$Gsct_default_stop) )
                      {$state_gmt.="'$GMT_gmt[$r]',";}
                    }
                  else
                    {
                    if ( ($GMT_hour[$r]>=$Gsct_sunday_start) && ($GMT_hour[$r]<$Gsct_sunday_stop) )
                      {$state_gmt.="'$GMT_gmt[$r]',";}
                    }
                  }
                if ($GMT_day[$r]==1)  #### Monday local time
                  {
                  if (($Gsct_monday_start==0) && ($Gsct_monday_stop==0))
                    {
                    if ( ($GMT_hour[$r]>=$Gsct_default_start) && ($GMT_hour[$r]<$Gsct_default_stop) )
                      {$state_gmt.="'$GMT_gmt[$r]',";}
                    }
                  else
                    {
                    if ( ($GMT_hour[$r]>=$Gsct_monday_start) && ($GMT_hour[$r]<$Gsct_monday_stop) )
                      {$state_gmt.="'$GMT_gmt[$r]',";}
                    }
                  }
                if ($GMT_day[$r]==2)  #### Tuesday local time
                  {
                  if (($Gsct_tuesday_start==0) && ($Gsct_tuesday_stop==0))
                    {
                    if ( ($GMT_hour[$r]>=$Gsct_default_start) && ($GMT_hour[$r]<$Gsct_default_stop) )
                      {$state_gmt.="'$GMT_gmt[$r]',";}
                    }
                  else
                    {
                    if ( ($GMT_hour[$r]>=$Gsct_tuesday_start) && ($GMT_hour[$r]<$Gsct_tuesday_stop) )
                      {$state_gmt.="'$GMT_gmt[$r]',";}
                    }
                  }
                if ($GMT_day[$r]==3)  #### Wednesday local time
                  {
                  if (($Gsct_wednesday_start==0) && ($Gsct_wednesday_stop==0))
                    {
                    if ( ($GMT_hour[$r]>=$Gsct_default_start) && ($GMT_hour[$r]<$Gsct_default_stop) )
                      {$state_gmt.="'$GMT_gmt[$r]',";}
                    }
                  else
                    {
                    if ( ($GMT_hour[$r]>=$Gsct_wednesday_start) && ($GMT_hour[$r]<$Gsct_wednesday_stop) )
                      {$state_gmt.="'$GMT_gmt[$r]',";}
                    }
                  }
                if ($GMT_day[$r]==4)  #### Thursday local time
                  {
                  if (($Gsct_thursday_start==0) && ($Gsct_thursday_stop==0))
                    {
                    if ( ($GMT_hour[$r]>=$Gsct_default_start) && ($GMT_hour[$r]<$Gsct_default_stop) )
                      {$state_gmt.="'$GMT_gmt[$r]',";}
                    }
                  else
                    {
                    if ( ($GMT_hour[$r]>=$Gsct_thursday_start) && ($GMT_hour[$r]<$Gsct_thursday_stop) )
                      {$state_gmt.="'$GMT_gmt[$r]',";}
                    }
                  }
                if ($GMT_day[$r]==5)  #### Friday local time
                  {
                  if (($Gsct_friday_start==0) && ($Gsct_friday_stop==0))
                    {
                    if ( ($GMT_hour[$r]>=$Gsct_default_start) && ($GMT_hour[$r]<$Gsct_default_stop) )
                      {$state_gmt.="'$GMT_gmt[$r]',";}
                    }
                  else
                    {
                    if ( ($GMT_hour[$r]>=$Gsct_friday_start) && ($GMT_hour[$r]<$Gsct_friday_stop) )
                      {$state_gmt.="'$GMT_gmt[$r]',";}
                    }
                  }
                if ($GMT_day[$r]==6)  #### Saturday local time
                  {
                  if (($Gsct_saturday_start==0) && ($Gsct_saturday_stop==0))
                    {
                    if ( ($GMT_hour[$r]>=$Gsct_default_start) && ($GMT_hour[$r]<$Gsct_default_stop) )
                      {$state_gmt.="'$GMT_gmt[$r]',";}
                    }
                  else
                    {
                    if ( ($GMT_hour[$r]>=$Gsct_saturday_start) && ($GMT_hour[$r]<$Gsct_saturday_stop) )
                      {$state_gmt.="'$GMT_gmt[$r]',";}
                    }
                  }
                $r++;
                }
              $state_gmt = "$state_gmt'99'";
    
              $del_list_state_gmt_SQL .= "or (List_id=\"$cur_list_id\" and state='$Gstate_call_time_state' and gmt_offset_now NOT IN($state_gmt)) ";
              $list_state_gmt_SQL .= "or (List_id=\"$cur_list_id\" and state='$Gstate_call_time_state' and gmt_offset_now IN($state_gmt)) ";
              }

            $b++;
            }
          if (strlen($ct_states)>2)
            {
            $ct_states = preg_replace("/,$/i",'',$ct_states);
            $ct_statesSQL = "and state NOT IN($ct_states)";
            }
          else
            {
            $ct_statesSQL = "";
            }

          $r=0;
          $dgA=0;
          $list_default_gmt='';
          while($r < $g)
            {
            if ($DB > 0) 
              {echo "LCT_gmt: $r|$GMT_day[$r]|$GMT_gmt[$r]|$Gct_sunday_start|$Gct_sunday_stop|$GMT_hour[$r]|$Gct_default_start|$Gct_default_stop\n";}

            if ($GMT_day[$r]==0)  #### Sunday local time
              {
              if (($Gct_sunday_start==0) && ($Gct_sunday_stop==0))
                {
                if ( ($GMT_hour[$r]>=$Gct_default_start) && ($GMT_hour[$r]<$Gct_default_stop) )
                  {}
                else
                  {$list_default_gmt.="'$GMT_gmt[$r]',";}
                }
              else
                {
                if ( ($GMT_hour[$r]>=$Gct_sunday_start) && ($GMT_hour[$r]<$Gct_sunday_stop) )
                  {}
                else
                  {$list_default_gmt.="'$GMT_gmt[$r]',";}
                }
              }
            if ($GMT_day[$r]==1)  #### Monday local time
              {
              if (($Gct_monday_start==0) && ($Gct_monday_stop==0))
                {
                if ( ($GMT_hour[$r]>=$Gct_default_start) && ($GMT_hour[$r]<$Gct_default_stop) )
                  {}
                else
                  {$list_default_gmt.="'$GMT_gmt[$r]',";}
                }
              else
                {
                if ( ($GMT_hour[$r]>=$Gct_monday_start) && ($GMT_hour[$r]<$Gct_monday_stop) )
                  {}
                else
                  {$list_default_gmt.="'$GMT_gmt[$r]',";}
                }
              }
            if ($GMT_day[$r]==2)  #### Tuesday local time
              {
              if (($Gct_tuesday_start==0) && ($Gct_tuesday_stop==0))
                {
                if ( ($GMT_hour[$r]>=$Gct_default_start) && ($GMT_hour[$r]<$Gct_default_stop) )
                  {}
                else
                  {$list_default_gmt.="'$GMT_gmt[$r]',";}
                }
              else
                {
                if ( ($GMT_hour[$r]>=$Gct_tuesday_start) && ($GMT_hour[$r]<$Gct_tuesday_stop) )
                  {}
                else
                  {$list_default_gmt.="'$GMT_gmt[$r]',";}
                }
              }
            if ($GMT_day[$r]==3)  #### Wednesday local time
              {
              if (($Gct_wednesday_start==0) && ($Gct_wednesday_stop==0))
                {
                if ( ($GMT_hour[$r]>=$Gct_default_start) && ($GMT_hour[$r]<$Gct_default_stop) )
                  {}
                else
                  {$list_default_gmt.="'$GMT_gmt[$r]',";}
                }
              else
                {
                if ( ($GMT_hour[$r]>=$Gct_wednesday_start) && ($GMT_hour[$r]<$Gct_wednesday_stop) )
                  {}
                else
                  {$list_default_gmt.="'$GMT_gmt[$r]',";}
                }
              }
            if ($GMT_day[$r]==4)  #### Thursday local time
              {
              if (($Gct_thursday_start==0) && ($Gct_thursday_stop==0))
                {
                if ( ($GMT_hour[$r]>=$Gct_default_start) && ($GMT_hour[$r]<$Gct_default_stop) )
                  {}
                else
                  {$list_default_gmt.="'$GMT_gmt[$r]',";}
                }
              else
                {
                if ( ($GMT_hour[$r]>=$Gct_thursday_start) && ($GMT_hour[$r]<$Gct_thursday_stop) )
                  {}
                else
                  {$list_default_gmt.="'$GMT_gmt[$r]',";}
                }
              }
            if ($GMT_day[$r]==5)  #### Friday local time
              {
              if (($Gct_friday_start==0) && ($Gct_friday_stop==0))
                {
                if ( ($GMT_hour[$r]>=$Gct_default_start) && ($GMT_hour[$r]<$Gct_default_stop) )
                  {}
                else
                  {$list_default_gmt.="'$GMT_gmt[$r]',";}
                }
              else
                {
                if ( ($GMT_hour[$r]>=$Gct_friday_start) && ($GMT_hour[$r]<$Gct_friday_stop) )
                  {}
                else
                  {$list_default_gmt.="'$GMT_gmt[$r]',";}
                }
              }
            if ($GMT_day[$r]==6)  #### Saturday local time
              {
              if (($Gct_saturday_start==0) && ($Gct_saturday_stop==0))
                {
                if ( ($GMT_hour[$r]>=$Gct_default_start) && ($GMT_hour[$r]<$Gct_default_stop) )
                  {}
                else
                  {$list_default_gmt.="'$GMT_gmt[$r]',";}
                }
              else
                {
                if ( ($GMT_hour[$r]>=$Gct_saturday_start) && ($GMT_hour[$r]<$Gct_saturday_stop) )
                  {}
                else
                  {$list_default_gmt.="'$GMT_gmt[$r]',";}
                }
              }
            $r++;
            }

          $list_default_gmt = "$list_default_gmt'99'";
          $LCTlist_id_sql .= " or ((list_id='$cur_list_id' and gmt_offset_now NOT IN($list_default_gmt) $ct_statesSQL) $list_state_gmt_SQL)";
          }
        ##### END local call time for list set different than campaign #####

        else
          {
          if (strlen($list_id_sql) < 3) 
            {
            $list_id_sql = "(list_id IN('$cur_list_id'";
            }
          else 
            {
            $list_id_sql .= ",'$cur_list_id'";
            }
          }

        $k++;
        }
      $camp_lists = preg_replace("/.$/i","",$camp_lists);
      if (strlen($camp_lists) < 4) {$camp_lists="''";}
      if (strlen($list_id_sql) < 4) {$list_id_sql="list_id=''";}
      else {$list_id_sql .= '))';}
      if (strlen($LCTlist_id_sql) > 1) {$list_id_sql .= "$LCTlist_id_sql";}


      $stmt="SELECT count(*) FROM vicidial_list where called_since_last_reset='N' and status IN($Dsql) and list_id IN($camp_lists) and ($list_id_sql) and ($all_gmtSQL) $CCLsql $DLTsql $fSQL $EXPsql";
      #$DB=1;
      if ($DB) {echo "$stmt\n";}
      $rslt=$this->mysql_to_mysqli($stmt, $link);
      $rslt_rows = mysqli_num_rows($rslt);
      if ($rslt_rows)
        {
        $rowx=mysqli_fetch_row($rslt);
        $active_leads = "$rowx[0]";
        }
      else {$active_leads = '0';}

      if ($DB > 0) {echo "|$DB|\n";}
      if ($single_status > 0)
        {return $active_leads;}
      else
        {
          //echo $this->_QXZ("This campaign has")." $active_leads ".$this->_QXZ("leads to be dialed in those lists")."\n";
          return 0;
        }
      }
    else
      {
      //echo $this->_QXZ("no dial statuses selected for this campaign")."\n";
        return 0;
      }
    }
  else
    {
    //echo $this->_QXZ("no active lists selected for this campaign")."\n";
      return 0; 
    }
  }
else
  {
  //echo $this->_QXZ("no active lists selected for this campaign")."\n";
  return 0;
  }
##### END calculate what gmt_offset_now values are within the allowed local_call_time setting ###
}


##### CALCULATE COMPLETE LEADS #####
function complete_leads($DB,$link,$dial_statuses,$camp_lists,$call_count_limit,$single_status,$campaign_id)
{
if (isset($camp_lists))
  {
  if (strlen($camp_lists)>1)
    {
    if (strlen($dial_statuses)>2)
      {
      $dial_statuses = preg_replace("/ -$/","",$dial_statuses);
      $Dstatuses = explode(" ", $dial_statuses);
      $Ds_to_print = (count($Dstatuses) - 0);
      $Dsql = '';
      $o=0;
      while ($Ds_to_print > $o) 
        {
        $o++;
        $Dsql .= "'$Dstatuses[$o]',";
        }
      $Dsql = preg_replace("/,$/","",$Dsql);
      if (strlen($Dsql) < 2) {$Dsql = "''";}

      $CCLsql = "(called_count < 0) or";
      if ($call_count_limit > 0)
        {$CCLsql = "(called_count >= $call_count_limit) or";}

      $complete_statuses='';
      $stmt="SELECT status from vicidial_statuses where completed='Y';";
      $rslt=$this->mysql_to_mysqli($stmt, $link);
      $statuses_to_print = mysqli_num_rows($rslt);
      $q=0;
      while ($statuses_to_print > $q) 
        {
        $rowx=mysqli_fetch_row($rslt);
        $complete_statuses.="'$rowx[0]',";
        $q++;
        }
      $stmt="SELECT status from vicidial_campaign_statuses where completed='Y' $LOGallowed_campaignsSQL;";
      $rslt=$this->mysql_to_mysqli($stmt, $link);
      $statuses_to_print = mysqli_num_rows($rslt);
      $q=0;
      while ($statuses_to_print > $q) 
        {
        $rowx=mysqli_fetch_row($rslt);
        $complete_statuses.="'$rowx[0]',";
        $q++;
        }
      $complete_statuses = preg_replace("/,$/","",$complete_statuses);
      if (strlen($complete_statuses) < 2) {$complete_statuses = "''";}
      $CSsql = "status IN($complete_statuses)";

      $stmt="SELECT count(*) FROM vicidial_list where ( (status IN($Dsql)) and (list_id IN($camp_lists)) and ( $CCLsql ($CSsql) ) );";
      #$DB=1;
      if ($DB) {echo "$stmt\n";}
      $rslt=$this->mysql_to_mysqli($stmt, $link);
      $rslt_rows = mysqli_num_rows($rslt);
      if ($rslt_rows)
        {
        $rowx=mysqli_fetch_row($rslt);
        $complete_leads = $rowx[0];
        }
      else {$complete_leads = '0';}

      if ($DB > 0) {echo "|$DB|\n";}
      if ($single_status > 0)
        {return $complete_leads;}
      else
        {echo $this->_QXZ("There are $complete_leads completed leads in those lists");}
      }
    else
      {
      echo $this->_QXZ("no dial statuses selected for this campaign")."\n";
      }
    }
  else
    {
    echo $this->_QXZ("no active lists selected for this campaign")."\n";
    }
  }
else
  {
  echo $this->_QXZ("no active lists selected for this campaign")."\n";
  }
}

/**
 * [get_time_options description]
 * @return [type] [description]
 */
function get_time_options()
{
    $time_options = "";
    for ($hh = 0; $hh <= 23; $hh++) {
        if (strlen($hh) == 1) {
            $hh = "0" . $hh;
        }
        for ($mm = 0; $mm <= 59; $mm += 15) {
            if (strlen($mm) == 1) {
                $mm = "0" . $mm;
            }
            /*
            if($hh == '00' && $mm == '00'){
            $mm = $mm + 15;
            }
            */
            if ($hh < 12) {
                $ampm = 'AM';
            } else {
                $ampm = 'PM';
            }
            $time_options .= "<option value=$hh:$mm:00>$hh:$mm:00 $ampm</option>";
        }
    }
    
    return $time_options;
}


public function List_reset_count($list_id)
{
  $stmtA = "SELECT COUNT(*) AS count FROM vicidial_admin_log WHERE event_type='RESET' AND event_section='LISTS' AND record_id='$list_id'";
  $rsltA = $this->mysql_to_mysqli($stmtA, $this->link);
  $reset_num_rows = mysqli_num_rows($rsltA);
  $count=0;
  if ($reset_num_rows)
  {
    $rowx=mysqli_fetch_row($rsltA);
    $count = $rowx[0];
  }
  return $count;
}


public function Islogin($user)
        {
            $query = $this->db->get_where('vicidial_live_agents', array('user' => $user));
            $result = $query->result_array();
            $res=[];
            if(sizeof($result)>0){
                $res=$result[0];
            }
            return $res;
        }

public function log_agent_out($user,$DB=""){
  $full_name=$user;
  $ip = getenv("REMOTE_ADDR");
     $PHP_AUTH_USER=$this->session->userdata('username');
        $NOW_TIME = date("Y-m-d H:i:s");
  $StarTtimE = date("U");
  $now_date_epoch = date('U');
  $inactive_epoch = ($now_date_epoch - 60);
  $stmt = "SELECT user,campaign_id,UNIX_TIMESTAMP(last_update_time),status,conf_exten,server_ip from vicidial_live_agents where user='" . mysqli_real_escape_string($this->link, $user) . "';";
  $rslt=$this->mysql_to_mysqli($stmt, $this->link);
  if ($DB) {echo "<BR>$stmt\n";}
  $vla_ct = mysqli_num_rows($rslt);
  if ($vla_ct > 0)
    {
    $row=mysqli_fetch_row($rslt);
    $VLA_user =         $row[0];
    $VLA_campaign_id =      $row[1];
    $VLA_update_time =      $row[2];
    $VLA_status =       $row[3];
    $VLA_conf_exten =     $row[4];
    $VLA_server_ip =      $row[5];

    if ($VLA_update_time > $inactive_epoch)
      {
      $lead_active=0;
      $stmt = "SELECT agent_log_id,user,server_ip,event_time,lead_id,campaign_id,pause_epoch,pause_sec,wait_epoch,wait_sec,talk_epoch,talk_sec,dispo_epoch,dispo_sec,status,user_group,comments,sub_status,dead_epoch,dead_sec from vicidial_agent_log where user='$VLA_user' order by agent_log_id desc LIMIT 1;";
      $rslt=$this->mysql_to_mysqli($stmt, $this->link);
      if ($DB) {echo "<BR>$stmt\n";}
      $val_ct = mysqli_num_rows($rslt);
      if ($val_ct > 0)
        {
        $row=mysqli_fetch_row($rslt);
        $VAL_agent_log_id =   $row[0];
        $VAL_user =       $row[1];
        $VAL_server_ip =    $row[2];
        $VAL_event_time =   $row[3];
        $VAL_lead_id =      $row[4];
        $VAL_campaign_id =    $row[5];
        $VAL_pause_epoch =    $row[6];
        $VAL_pause_sec =    $row[7];
        $VAL_wait_epoch =   $row[8];
        $VAL_wait_sec =     $row[9];
        $VAL_talk_epoch =   $row[10];
        $VAL_talk_sec =     $row[11];
        $VAL_dispo_epoch =    $row[12];
        $VAL_dispo_sec =    $row[13];
        $VAL_status =     $row[14];
        $VAL_user_group =   $row[15];
        $VAL_comments =     $row[16];
        $VAL_sub_status =   $row[17];
        $VAL_dead_epoch =   $row[18];
        $VAL_dead_sec =     $row[19];

        if ($DB) {echo "\n<BR>".$this->_QXZ("VAL VALUES").": $VAL_agent_log_id|$VAL_status|$VAL_lead_id\n";}

        if ( ($VAL_wait_epoch < 1) or ( (preg_match('/PAUSE/', $VLA_status)) and ($VAL_dispo_epoch < 1) ) )
          {
          $VAL_pause_sec = ( ($now_date_epoch - $VAL_pause_epoch) + $VAL_pause_sec);
          $stmt = "UPDATE vicidial_agent_log SET wait_epoch='$now_date_epoch', pause_sec='$VAL_pause_sec', pause_type='ADMIN' where agent_log_id='$VAL_agent_log_id';";
          }
        else
          {
          if ($VAL_talk_epoch < 1)
            {
            $VAL_wait_sec = ( ($now_date_epoch - $VAL_wait_epoch) + $VAL_wait_sec);
            $stmt = "UPDATE vicidial_agent_log SET talk_epoch='$now_date_epoch', wait_sec='$VAL_wait_sec' where agent_log_id='$VAL_agent_log_id';";
            }
          else
            {
            $lead_active++;
            $status_update_SQL='';
            if ( ( (strlen($VAL_status) < 1) or ($VAL_status == 'NULL') ) and ($VAL_lead_id > 0) )
              {
              $status_update_SQL = ", status='PU'";
              $stmt="UPDATE vicidial_list SET status='PU' where lead_id='$VAL_lead_id';";
              if ($DB) {echo "<BR>$stmt\n";}
              $rslt=$this->mysql_to_mysqli($stmt, $this->link);
              }
            if ($VAL_dispo_epoch < 1)
              {
              $VAL_talk_sec = ($now_date_epoch - $VAL_talk_epoch);
              $stmt = "UPDATE vicidial_agent_log SET dispo_epoch='$now_date_epoch', talk_sec='$VAL_talk_sec'$status_update_SQL where agent_log_id='$VAL_agent_log_id';";
              }
            else
              {
              if ($VAL_dispo_sec < 1)
                {
                $VAL_dispo_sec = ($now_date_epoch - $VAL_dispo_epoch);
                $stmt = "UPDATE vicidial_agent_log SET dispo_sec='$VAL_dispo_sec' where agent_log_id='$VAL_agent_log_id';";
                }
              }
            }
          }

        if ($DB) {echo "<BR>$stmt\n";}
        $rslt=$this->mysql_to_mysqli($stmt, $this->link);
        }
      }

    $stmt="DELETE from vicidial_live_agents where user='" . mysqli_real_escape_string($this->link, $user) . "';";
    if ($DB) {echo "<BR>$stmt\n";}
    $rslt=$this->mysql_to_mysqli($stmt, $this->link);

    if (strlen($VAL_user_group) < 1)
      {
      $stmt = "SELECT user_group FROM vicidial_users where user='$VLA_user';";
      $rslt=$this->mysql_to_mysqli($stmt, $this->link);
      if ($DB) {echo "<BR>$stmt\n";}
      $val_ct = mysqli_num_rows($rslt);
      if ($val_ct > 0)
        {
        $row=mysqli_fetch_row($rslt);
        $VAL_user_group =   $row[0];
        }
      }

    $local_DEF = 'Local/5555';
    $local_AMP = '@';
    $ext_context = 'default';
    $kick_local_channel = "$local_DEF$VLA_conf_exten$local_AMP$ext_context";
    $queryCID = "ULGH3457$StarTtimE";

    $stmtC="INSERT INTO vicidial_manager values('','','$NOW_TIME','NEW','N','$VLA_server_ip','','Originate','$queryCID','Channel: $kick_local_channel','Context: $ext_context','Exten: 8300','Priority: 1','Callerid: $queryCID','','','','','');";
    if ($DB) {echo "<BR>$stmtC\n";}
    $rslt=$this->mysql_to_mysqli($stmtC, $this->link);

    $stmtB = "INSERT INTO vicidial_user_log (user,event,campaign_id,event_date,event_epoch,user_group,extension) values('$VLA_user','LOGOUT','$VLA_campaign_id','$NOW_TIME','$now_date_epoch','$VAL_user_group','MGR LOGOUT: $PHP_AUTH_USER');";
    if ($DB) {echo "<BR>$stmtB\n";}
    $rslt=$this->mysql_to_mysqli($stmtB, $this->link);

    ### Add a record to the vicidial_admin_log
    $SQL_log = "$stmt|$stmtB|$stmtC|";
    $SQL_log = preg_replace('/;/', '', $SQL_log);
    $SQL_log = addslashes($SQL_log);
    $stmt="INSERT INTO vicidial_admin_log set event_date='$NOW_TIME', user='$PHP_AUTH_USER', ip_address='$ip', event_section='USERS', event_type='LOGOUT', record_id='$user', event_code='EMERGENCY LOGOUT FROM STATUS PAGE', event_sql=\"$SQL_log\", event_notes='agent_log_id: $VAL_agent_log_id';";
    if ($DB) {echo "$stmt\n";}
    $rslt=$this->mysql_to_mysqli($stmt, $this->link);
    $affected_rows = mysqli_affected_rows($this->link);

    #############################################
    ##### START QUEUEMETRICS LOGGING LOOKUP #####
    $stmt = "SELECT enable_queuemetrics_logging,queuemetrics_server_ip,queuemetrics_dbname,queuemetrics_login,queuemetrics_pass,queuemetrics_log_id,queuemetrics_loginout,queuemetrics_addmember_enabled,queuemetrics_pe_phone_append,queuemetrics_pause_type FROM system_settings;";
    $rslt=$this->mysql_to_mysqli($stmt, $this->link);
    if ($DB) {echo "<BR>$stmt\n";}
    $qm_conf_ct = mysqli_num_rows($rslt);
    if ($qm_conf_ct > 0)
      {
      $row=mysqli_fetch_row($rslt);
      $enable_queuemetrics_logging =    $row[0];
      $queuemetrics_server_ip =     $row[1];
      $queuemetrics_dbname =        $row[2];
      $queuemetrics_login =       $row[3];
      $queuemetrics_pass =        $row[4];
      $queuemetrics_log_id =        $row[5];
      $queuemetrics_loginout =      $row[6];
      $queuemetrics_addmember_enabled = $row[7];
      $queuemetrics_pe_phone_append =   $row[8];
      $queuemetrics_pause_type =      $row[9];
      }
    ##### END QUEUEMETRICS LOGGING LOOKUP #####
    ###########################################
    if ($enable_queuemetrics_logging > 0)
      {
      $QM_LOGOFF = 'AGENTLOGOFF';
      if ($queuemetrics_loginout=='CALLBACK')
        {$QM_LOGOFF = 'AGENTCALLBACKLOGOFF';}

      #$linkB=mysql_connect("$queuemetrics_server_ip", "$queuemetrics_login", "$queuemetrics_pass");
      #mysql_select_db("$queuemetrics_dbname", $linkB);
      $linkB=mysqli_connect("$queuemetrics_server_ip", "$queuemetrics_login", "$queuemetrics_pass", "$queuemetrics_dbname");
      if (!$linkB) {
        return ['status'=>false,'msg'=>$this->_QXZ("Could not connect: ")."$queuemetrics_server_ip|$queuemetrics_login" . mysqli_connect_error()];
        die();
      }

      $agents='@agents';
      $agent_logged_in='';
      $time_logged_in='0';

      $stmtB = "SELECT agent,time_id,data1 FROM queue_log where agent='Agent/" . mysqli_real_escape_string($this->link, $user) . "' and verb IN('AGENTLOGIN','AGENTCALLBACKLOGIN') and time_id > $check_time order by time_id desc limit 1;";

      if ($queuemetrics_loginout == 'NONE')
        {
        $pause_typeSQL='';
        if ($queuemetrics_pause_type > 0)
          {$pause_typeSQL=",data5='ADMIN'";}
        $stmt = "INSERT INTO queue_log SET `partition`='P01',time_id='$now_date_epoch',call_id='NONE',queue='NONE',agent='Agent/" . mysqli_real_escape_string($this->link, $user) . "',verb='PAUSEREASON',serverid='$queuemetrics_log_id',data1='LOGOFF'$pause_typeSQL;";
        if ($DB) {echo "$stmt\n";}
        $rslt=$this->mysql_to_mysqli($stmt, $linkB);
        $affected_rows = mysqli_affected_rows($linkB);

        $stmtB = "SELECT agent,time_id,data1 FROM queue_log where agent='Agent/" . mysqli_real_escape_string($this->link, $user) . "' and verb IN('ADDMEMBER','ADDMEMBER2') and time_id > $check_time order by time_id desc limit 1;";
        }

      $rsltB=$this->mysql_to_mysqli($stmtB, $linkB);
      if ($DB) {echo "<BR>$stmtB\n";}
      $qml_ct = mysqli_num_rows($rsltB);
      if ($qml_ct > 0)
        {
        $row=mysqli_fetch_row($rsltB);
        $agent_logged_in =    $row[0];
        $time_logged_in =   $row[1];
        $RAWtime_logged_in =  $row[1];
        $phone_logged_in =    $row[2];
        }

      $time_logged_in = ($now_date_epoch - $time_logged_in);
      if ($time_logged_in > 1000000) {$time_logged_in=1;}

      if ($queuemetrics_addmember_enabled > 0)
        {
        $queuemetrics_phone_environment='';
        $stmt = "SELECT queuemetrics_phone_environment FROM vicidial_campaigns where campaign_id='$VLA_campaign_id';";
        $rslt=$this->mysql_to_mysqli($stmt, $this->link);
        if ($DB) {echo "<BR>$stmt\n";}
        $cqpe_ct = mysqli_num_rows($rslt);
        if ($cqpe_ct > 0)
          {
          $row=mysqli_fetch_row($rslt);
          $queuemetrics_phone_environment = $row[0];
          }

        $stmt = "SELECT distinct queue FROM queue_log where time_id >= $RAWtime_logged_in and agent='$agent_logged_in' and verb IN('ADDMEMBER','ADDMEMBER2') and queue != '$VLA_campaign_id' order by time_id desc;";
        $rslt=$this->mysql_to_mysqli($stmt, $linkB);
        if ($DB) {echo "$stmt\n";}
        $amq_conf_ct = mysqli_num_rows($rslt);
        $i=0;
        while ($i < $amq_conf_ct)
          {
          $row=mysqli_fetch_row($rslt);
          $AMqueue[$i] =  $row[0];
          $i++;
          }

        ### add the logged-in campaign as well
        $AMqueue[$i] = $VLA_campaign_id;
        $i++;
        $amq_conf_ct++;

        $i=0;
        while ($i < $amq_conf_ct)
          {
          $pe_append='';
          if ( ($queuemetrics_pe_phone_append > 0) and (strlen($queuemetrics_phone_environment)>0) )
            {
            $qm_extension = explode('/',$phone_logged_in);
            $pe_append = "-$qm_extension[1]";
            }
          $stmt = "INSERT INTO queue_log SET `partition`='P01',time_id='$now_date_epoch',call_id='NONE',queue='$AMqueue[$i]',agent='$agent_logged_in',verb='REMOVEMEMBER',data1='$phone_logged_in',serverid='$queuemetrics_log_id',data4='$queuemetrics_phone_environment$pe_append';";
          $rslt=$this->mysql_to_mysqli($stmt, $linkB);
          $affected_rows = mysqli_affected_rows($linkB);
          $i++;
          }
        }

      if ($queuemetrics_loginout != 'NONE')
        {
        $stmtB = "INSERT INTO queue_log SET `partition`='P01',time_id='$now_date_epoch',call_id='NONE',queue='NONE',agent='$agent_logged_in',verb='$QM_LOGOFF',serverid='$queuemetrics_log_id',data1='$phone_logged_in',data2='$time_logged_in';";
        if ($DB) {echo "<BR>$stmtB\n";}
        $rsltB=$this->mysql_to_mysqli($stmtB, $linkB);
        }
      }

      return ['status'=>true,'msg'=>$this->_QXZ("Agent")." $user ".$this->_QXZ("has been logged out")];

   
    }
  else
    {
       return ['status'=>false,'msg'=>$this->_QXZ("Agent")." $user ".$this->_QXZ("is not logged in")];
    } 

}


public function getCustomFileds($list_id){
    $stmt="SELECT count(*) from vicidial_lists_fields where list_id='$list_id';";
    $rslt=$this->mysql_to_mysqli($stmt, $this->link);
    $fieldscount_to_print = mysqli_num_rows($rslt);
    $list_fields_count=0;
    if ($fieldscount_to_print > 0) 
      {
        $rowx=mysqli_fetch_row($rslt);
        $list_fields_count=$rowx[0];
      }
    return $list_fields_count;
}


public function GetDNCGroups($filter_phone_group_id=""){
   if(trim($filter_phone_group_id)==""){
      $stmt="SELECT filter_phone_group_id,filter_phone_group_name,filter_phone_group_description,user_group from vicidial_filter_phone_groups where 1=1 ". LOGadmin_viewable_groupsSQL." order by filter_phone_group_id;";
   }else{
    $stmt="SELECT filter_phone_group_id,filter_phone_group_name,filter_phone_group_description,user_group from vicidial_filter_phone_groups where filter_phone_group_id='$filter_phone_group_id' ". LOGadmin_viewable_groupsSQL." order by filter_phone_group_id;";
   }
   $query = $this->db->query($stmt)->result_array();
   return $query;
}


public function Update_User_Permissions($user_id,$api_only_user='0',$isUserId=false)
{
  if($isUserId)
  {
    $stmt="update vicidial_users set delete_call_times='1',modify_call_times='1',modify_users='1',modify_campaigns='1',modify_lists='1',modify_scripts='1',modify_filters='1',modify_ingroups='1',modify_usergroups='1',modify_remoteagents='1',modify_servers='1',view_reports='1',modify_timeclock_log='1',delete_timeclock_log='1',vdc_agent_api_access='1',modify_inbound_dids='1',delete_inbound_dids='1',download_lists='1',export_reports='1',delete_from_dnc='1',modify_shifts='1',modify_phones='1',modify_carriers='1',modify_labels='1',modify_statuses='1',modify_voicemail='1',modify_audiostore='1',modify_moh='1',modify_tts='1',modify_contacts='1',modify_same_user_level='1',modify_email_accounts='1',modify_custom_dialplans='1',modify_languages='1',api_list_restrict='0',access_recordings='1',modify_colors='1',api_only_user='$api_only_user',alter_agent_interface_options='1',change_agent_campaign='1',delete_users='1',delete_user_groups='1',delete_lists='1',load_leads='1',modify_leads='1',custom_fields_modify='1',campaign_detail='1',delete_campaigns='1',delete_ingroups='1',delete_remote_agents='1',delete_scripts='1',delete_filters='1',ast_admin_access='1',ast_delete_phones='1',callcard_admin='1',add_timeclock_log='1',manager_shift_enforcement_override='1',pause_code_approval='1' where user_id='$user_id'";
  }else{
    $stmt="update vicidial_users set delete_call_times='1',modify_call_times='1',modify_users='1',modify_campaigns='1',modify_lists='1',modify_scripts='1',modify_filters='1',modify_ingroups='1',modify_usergroups='1',modify_remoteagents='1',modify_servers='1',view_reports='1',modify_timeclock_log='1',delete_timeclock_log='1',vdc_agent_api_access='1',modify_inbound_dids='1',delete_inbound_dids='1',download_lists='1',export_reports='1',delete_from_dnc='1',modify_shifts='1',modify_phones='1',modify_carriers='1',modify_labels='1',modify_statuses='1',modify_voicemail='1',modify_audiostore='1',modify_moh='1',modify_tts='1',modify_contacts='1',modify_same_user_level='1',modify_email_accounts='1',modify_custom_dialplans='1',modify_languages='1',api_list_restrict='0',access_recordings='1',modify_colors='1',api_only_user='$api_only_user',alter_agent_interface_options='1',change_agent_campaign='1',delete_users='1',delete_user_groups='1',delete_lists='1',load_leads='1',modify_leads='1',custom_fields_modify='1',campaign_detail='1',delete_campaigns='1',delete_ingroups='1',delete_remote_agents='1',delete_scripts='1',delete_filters='1',ast_admin_access='1',ast_delete_phones='1',callcard_admin='1',add_timeclock_log='1',manager_shift_enforcement_override='1',pause_code_approval='1' where user='$user_id'";
  }
  
  $this->db->query($stmt);
}

}
