<?php
defined('BASEPATH') OR exit('No direct script access allowed');
class Model_gateway extends CI_Model {

    public function insert($data)
    {
       $this->db->insert('tbl_gateway', $data);
       if($this->db->affected_rows() > 0)
        {   $this->create_carrier($data['gateway_id']);
            $this->Model_lib->ServerRebuildConf();
            return true;
        }else{
            return false;
        }
    }

    function check_unique_gatway($gateway_id = '', $name) {
        $this->db->where('name', $name);
        if($gateway_id) {
            $this->db->where_not_in('gateway_id', $gateway_id);
        }
        return $this->db->get('tbl_gateway')->num_rows();
    }

    public function get($id) {
        
          $query = $this->db->get_where('tbl_gateway', array('gateway_id' => $id),1);
          $result = $query->result_array();
          return $result[0];
    }
    
    public function update($id,$data)
    {
        $this->db->where('gateway_id', $id);
        $result=$this->db->update('tbl_gateway', $data);
        $this->create_carrier($data['gateway_id']);
        $this->Model_lib->ServerRebuildConf();
        return $result;
    }
    
    public function remove($gateway_id)
    {   
        $result=$this->db->delete('tbl_gateway',array('gateway_id'=>$gateway_id));
        $this->db->delete('vicidial_server_carriers',array('carrier_id'=>$gateway_id));
        $this->Model_lib->ServerRebuildConf();
        return $result;
    }    
    
    public function create_carrier($gateway_id){
        $account_entry="";
        $dialplan_entry="";
        $query = $this->db->get_where('tbl_gateway', array('gateway_id' => $gateway_id),1);
        $result = $query->result_array();
        if(sizeof($result)>0){
            $carrier_id=$result[0]['gateway_id'];
            $carrier_name=$result[0]['name'];
            
            $random_caller_id=$result[0]['random_caller_id'];
            $random_caller_id_prefix=$result[0]['random_caller_id_prefix'];
            $random_caller_id_trim_digits=$result[0]['random_caller_id_trim_digits'];
            // $call_recording=$result[0]['call_recording'];
            $port="5060";
            $host=explode(":", $result[0]['host']);
            if(isset($host[1]))
            {
                $port=$host[1];
            }
            $registration_string='';
            $template_id='--NONE--';
            $account_entry.="[".$result[0]['name']."]"."\n";
            $account_entry.="type=friend"."\n";
            $account_entry.="qualify=yes"."\n";
            $account_entry.="host=".$host[0]."\n";
            $account_entry.="port=".$port."\n";
            $account_entry.="dtmfmode=".$result[0]['dtmf_type']."\n"; 
            if($result[0]['auth_type']=="USER"){
               $account_entry.="username=".$result[0]['username']."\n";
               $account_entry.="secret=".$result[0]['secret']."\n";
            }
            $account_entry.="context=trunkinbound"."\n";
            $account_entry.="canreinvite=no"."\n";
            $account_entry.="directmedia=no"."\n";
            $account_entry.="disallow=all"."\n";
            $account_entry.="allow=alaw"."\n";
            $account_entry.="allow=ulaw"."\n";
            $account_entry.="allow=g729"."\n";
            $account_entry.="insecure=port,invite"."\n";
            $account_entry.="nat=force_rport,comedia"."\n";
            
            $protocol="SIP";
            $globals_string="";
            $server_ip="0.0.0.0";
            $extenlen= strlen($result[0]['gateway_id']);
            $dialplan_entry.="exten => _".$result[0]['gateway_id']."X.,1,AGI(agi://127.0.0.1:4577/call_log)"."\n";
            //exten => _1007X.,n,AGI(vbrandom_cli.agi,"44",${EXTEN:4},"3")
            // if(trim($call_recording)=="YES")
            // {
            //     $dialplan_entry.="exten => _".$result[0]['id']."X.,n,AGI(agi-NVA_recording.agi,BOTH------N---N---Y---N)"."\n";
            // }
            $country_code="";
            if(trim($random_caller_id)=="YES")
            {
                if(trim($random_caller_id_prefix)=="YES"){
                    $country_code=$result[0]['tech_prefix'];
                }
                $random_caller_id_trim_digits=strval($random_caller_id_trim_digits);
                $dialplan_entry.="exten => _".$result[0]['gateway_id']."X.,n,AGI(vbrandom_cli.agi,\"$country_code\",\${EXTEN:$extenlen},\"$random_caller_id_trim_digits\")"."\n";
            }else if(trim($random_caller_id)=="ROTATING"){                
                $dialplan_entry.="exten => _".$result[0]['gateway_id']."X.,n,AGI(rotating_clis.agi,\"$carrier_id\")"."\n";
            }      
            $dialplan_entry.="exten => _".$result[0]['gateway_id']."X.,n,Dial(SIP/".$result[0]['tech_prefix']."\${EXTEN:$extenlen}@".$result[0]['name'].",,tTo)"."\n";
            $dialplan_entry.="exten => _".$result[0]['gateway_id']."X.,n,Hangup()"."\n";
            $active=$result[0]['status'];
            $carrier_description=$result[0]['name'];
            $user_group=$result[0]['user_group'];            
            $data=array('carrier_id'=>$carrier_id,
                        'carrier_name'=>$carrier_name,
                        'registration_string'=>$registration_string,
                        'template_id'=>$template_id,
                        'account_entry'=>$account_entry."\n".$result[0]['account_entry_custom'],
                        'protocol'=>$protocol,
                        'globals_string'=>$globals_string,
                        'dialplan_entry'=>$dialplan_entry."\n".$result[0]['dialplan_entry_custom'],
                        'server_ip'=>$server_ip,
                        'active'=>$active,
                        'carrier_description'=>$carrier_description,
                        'user_group'=>$user_group);           
            if($this->isCarrierFound($result[0]['gateway_id'])){
                //update vicidial server carriers;
                $this->db->where('carrier_id', $carrier_id);
                $this->db->update('vicidial_server_carriers', $data);
            }else{
                //insert vicidial server carriers;
                $this->db->insert('vicidial_server_carriers', $data);
            }    
        }
        $this->Model_lib->ServerRebuildConf();
    }
    
    public function isCarrierFound($carrier_id){
        $query = $this->db->get_where('vicidial_server_carriers', array('carrier_id' => $carrier_id),1);
        $result = $query->result_array();
        if(sizeof($result)>0){
            return true;
        }else{
            return false;
        }
    }
}