<?php
defined('BASEPATH') OR exit('No direct script access allowed');
class Voicemail extends CI_Controller {
    var $userdata = null;
    function __construct() {
        parent::__construct();
        if (!$this->Model_lib->Is_login()) {
            redirect(base_url() . 'login');
        }
        $this->Model_lib->Is_lock();
        $this->load->model('Model_login');
        $this->load->model('Model_voicemail');    
        $this->userdata=$this->Model_login->Get_loggedin_user();
    }

     public function index() {
        $userdata=$this->userdata;
        $csrf = array(
                    'name' => $this->security->get_csrf_token_name(),
                    'hash' => $this->security->get_csrf_hash()
            );
        $data=array("csrf"=>$csrf);
        $this->load->view('voicemail/view', compact('data','userdata'));
    }    
    
    public function add(){
        $userdata=$this->userdata;
        $csrf = array(
                    'name' => $this->security->get_csrf_token_name(),
                    'hash' => $this->security->get_csrf_hash()
            );
        $data=array("csrf"=>$csrf);
        $this->load->view('voicemail/add', compact('data','userdata'));
    }   


    public function edit($id)
    {   
        $id = $this->Model_lib->DecryptionId($id);
        $userdata= $this->userdata;
        $group_data = $this->Model_voicemail->get($id);
        $csrf = array(
                    'name' => $this->security->get_csrf_token_name(),
                    'hash' => $this->security->get_csrf_hash()
            );
        $data= array_merge($group_data,array("csrf"=>$csrf));
        $this->load->view('voicemail/edit', compact('data','userdata'));
    }

    public function save(){
        $this->load->library('form_validation');
        $this->form_validation->set_rules(
                'voicemail_id', 'Voicemail ID',
                'required|min_length[2]|max_length[10]|is_unique[vicidial_voicemail.voicemail_id]|regex_match[/^[_a-zA-z0-9]+$/]',
                array(
                        'required'      => 'You have not provided %s.',
                        'is_unique'     => 'This %s already exists.',
                        'regex_match'   => 'Special characters not allowed for %s.'
                )
        );
        $this->form_validation->set_rules(
                'voicemail_id', 'Voicemail ID',
                'required|min_length[2]|max_length[10]|is_unique[phones.voicemail_id]|regex_match[/^[_a-zA-z0-9]+$/]',
                array(
                        'required'      => 'You have not provided %s.',
                        'is_unique'     => 'This %s already exists into phones.',
                        'regex_match'   => 'Special characters not allowed for %s.'
                )
        );
        $this->form_validation->set_rules(
                'fullname', 'Full Name',
                'required|min_length[2]|max_length[100]',
                array(
                        'required'      => 'You have not provided %s.'
                )
        );
        $this->form_validation->set_rules(
                'user_group', 'User Group',
                'required',
                array(
                        'required'      => 'You have not provided %s.'
                )
        );

        if ($this->form_validation->run() == FALSE){
            $this->Model_lib->Is_lock();
            $csrf = array(
                            'name' => $this->security->get_csrf_token_name(),
                            'hash' => $this->security->get_csrf_hash()
                    );
            $error = array(
                    'voicemail_id' => form_error('voicemail_id'),
                    'fullname' => form_error('fullname'),
                    'user_group' => form_error('user_group')
            );            
            $data=array("csrf"=>$csrf,"error"=>$error,"status"=>false,"msg"=>"Please enter required fields.");
            exit(json_encode($data));
        }else{            
            $data=$this->Model_lib->parse_array($this->input->post());
            $insert_id=$this->Model_lib->EncryptionId($data['voicemail_id']);
            if($this->Model_voicemail->insert($data)){                     
                $result=array("status"=>true,"msg"=>"Voicemail successfully created","insert_id"=>$insert_id);
                $this->Model_lib->admin_change_log("Voicemail","Save Voicemail","");
            }else{            
                $result=array("status"=>false,"msg"=>"unable to created Voicemail.","insert_id"=>$insert_id);
            }
            exit(json_encode($result));
        }

    }


    public function update()
    {
        $this->load->library('form_validation');
        $this->form_validation->set_rules(
                'voicemail_id', 'Voicemail ID',
                'required|min_length[2]|max_length[10]|is_unique[vicidial_voicemail.voicemail_id]|regex_match[/^[_a-zA-z0-9]+$/]',
                array(
                        'required'      => 'You have not provided %s.',
                        'is_unique'     => 'This %s already exists.',
                        'regex_match'   => 'Special characters not allowed for %s.'
                )
        );
        $this->form_validation->set_rules(
                'voicemail_id', 'Voicemail ID',
                'required|min_length[2]|max_length[10]|is_unique[phones.voicemail_id]|regex_match[/^[_a-zA-z0-9]+$/]',
                array(
                        'required'      => 'You have not provided %s.',
                        'is_unique'     => 'This %s already exists into phones.',
                        'regex_match'   => 'Special characters not allowed for %s.'
                )
        );
        $this->form_validation->set_rules(
                'fullname', 'Full Name',
                'required|min_length[2]|max_length[100]',
                array(
                        'required'      => 'You have not provided %s.'
                )
        );
        $this->form_validation->set_rules(
                'user_group', 'User Group',
                'required',
                array(
                        'required'      => 'You have not provided %s.'
                )
        );
        if ($this->form_validation->run() == FALSE){
            $this->Model_lib->Is_lock();
            $csrf = array(
                            'name' => $this->security->get_csrf_token_name(),
                            'hash' => $this->security->get_csrf_hash()
                    );
            $error = array(
                    'voicemail_id' => form_error('voicemail_id'),
                    'fullname' => form_error('fullname'),
                    'user_group' => form_error('user_group')
            );            
            $data=array("csrf"=>$csrf,"error"=>$error,"status"=>false,"msg"=>"Please enter required fields.");
            exit(json_encode($data));
        }else{
             $csrf = array(
                            'name' => $this->security->get_csrf_token_name(),
                            'hash' => $this->security->get_csrf_hash()
                    );           
            $data=$this->Model_lib->parse_array($this->input->post());
            $insert_id=$this->Model_lib->EncryptionId($data['voicemail_id']);
            if($this->Model_voicemail->update($data['voicemail_id'],$data)){                     
                $result=array("status"=>true,"msg"=>"Voicemail successfully update","insert_id"=>$insert_id);
                $this->Model_lib->admin_change_log("Voicemail","Update Voicemail","");
            }else{            
                $result=array("status"=>false,"msg"=>"unable to update Voicemail.","insert_id"=>$insert_id,"csrf"=>$csrf);
            }
            exit(json_encode($result));
        }
    }

    public function delete($id)
    {            
        $id=$this->Model_lib->DecryptionId($id);
        $result=$this->Model_voicemail->remove($id);  
        if($result){
            $this->session->set_flashdata('success','Voicemail successfully deleted.');
            $this->Model_lib->admin_change_log("Voicemail","Delete Voicemail","");
            redirect(base_url('settings/voicemail'));
        }else{
            $this->session->set_flashdata('error','unable to delete Voicemail.');
            redirect(base_url('settings/voicemail'));
        }
    }
    
}