<?php
defined('BASEPATH') OR exit('No direct script access allowed');
class User extends CI_Controller {
    
        function __construct()
        {
           parent::__construct();    
           if(!$this->Model_lib->Is_login()){
               redirect(base_url().'login');
           }                    
           $this->load->model('Model_login');
           $this->load->model('Model_user');
        }
        
        public function index()
        {   
            $this->Model_lib->Is_lock();
            $data=$this->Model_user->getAllUsers();
            $userdata=$this->Model_login->Get_loggedin_user();            
            $this->load->view('users/view', compact('data','userdata'));                       
        }

        
        public function EmeegencyLogout()
        {   $user=$this->input->get('user');
            $response=$this->Model_lib->log_agent_out($user);
            $response=json_encode($response);
            exit($response);
        }

        public function create()
        {
            redirect('agents#add');
        }

        public function view()
        {
           // $this->Model_lib->Is_lock();
           // $userdata=$this->Model_login->Get_loggedin_user();
           // $csrf = array(
           //              'name' => $this->security->get_csrf_token_name(),
           //              'hash' => $this->security->get_csrf_hash()
           //          );
           // $data= array_merge(array("csrf"=>$csrf));
           // $this->load->view('users/view', compact('data','userdata'));  

            $this->Model_lib->Is_lock();
            $data=$this->Model_user->getAllUsers();
            $userdata=$this->Model_login->Get_loggedin_user();            
            $this->load->view('users/view', compact('data','userdata'));          
        }
        
        public function changepassword(){            
            if ($this->input->server('REQUEST_METHOD') == 'POST') {
                    $this->Model_lib->Is_lock();
                    $userdata=$this->Model_login->Get_loggedin_user();            
                    $csrf = array(
                                'name' => $this->security->get_csrf_token_name(),
                                'hash' => $this->security->get_csrf_hash()
                        );
                    $data=array("csrf"=>$csrf);            
                    $this->load->library('form_validation');
                    $this->form_validation->set_rules('oldpassword', 'Password', 'required|min_length[4]|max_length[50]');
                    $this->form_validation->set_rules('newpassword', 'Password', 'required|min_length[4]|max_length[50]');
                    $this->form_validation->set_rules('passconf', 'Password Confirmation', 'required|matches[newpassword]|min_length[4]|max_length[50]');                    
                   
                    if ($this->form_validation->run() == FALSE){                       
                        $this->load->view('profile', compact('data','userdata'));                        
                    }else{  
                        
                        $oldpassword=$this->input->post('oldpassword');
                        $currentPassword=$userdata['pass'];
                        if ($currentPassword!=$oldpassword){
                            $this->session->set_flashdata('error','current password is not correct.');
                            $this->load->view('profile', compact('data','userdata'));
                        }else{
                            $user_id=$userdata['user_id'];
                            $password=$this->input->post('newpassword');
                            $result=$this->Model_user->PasswordChange($user_id,$password);
                            if($result){
                                $this->logout();
                            }else{
                                $this->session->set_flashdata('error','unable to change password.');
                                $this->load->view('profile', compact('data','userdata'));
                            }
                           
                        }                               
                    }                   
            }else{
                //redirect('dashboard');
               $this->Model_lib->Is_lock();
               $userdata=$this->Model_login->Get_loggedin_user();
               $csrf = array(
                            'name' => $this->security->get_csrf_token_name(),
                            'hash' => $this->security->get_csrf_hash()
                        );
               $data= array_merge(array("csrf"=>$csrf));
               $this->load->view('profile', compact('data','userdata')); 
            }
        }

        public function bulk()
        {
            $userdata=$this->Model_login->Get_loggedin_user(); 
            $groups=$this->Model_lib->Get_usergroups();
            $csrf = array(
                        'name' => $this->security->get_csrf_token_name(),
                        'hash' => $this->security->get_csrf_hash()
                );
            $data=array("groups"=>$groups,"csrf"=>$csrf);
            $this->load->view('users/bulk', compact('data','userdata'));
        }

        public function bulk_save()
        {
            $csrf = array(
                'name' => $this->security->get_csrf_token_name(),
                'hash' => $this->security->get_csrf_hash()
            );
            $users=$this->input->post('user');
            $pass=$this->input->post('pass');
            $full_name=$this->input->post('full_name');
            $extension=$this->input->post('extension');
            $conf_secret=$this->input->post('conf_secret');            
            $sizeof=$this->input->post('user');
            $user_group=$this->input->post('user_group');
            $user_group=$this->Model_lib->DecryptionId($user_group);
            $server_ip=$this->input->post('server_ip');
            $is_webphone=$this->input->post('is_webphone');
            $template_id=$this->input->post('template_id');
            $status="ACTIVE";
            $active="Y";
            if(sizeof($sizeof)<=0)
            {
            	$errors=array("error"=>"no records founds for save.");
	            $data=array("status"=>false,"csrf"=>$csrf,"errors"=>$errors);
	            exit(json_encode($data));
            }
            $inner_message="";            
            $validation=false;
            for($i=0;$i<sizeof($sizeof);$i++)
            {   $user_message="";
                $phone_message="";
                $validation=false;
                $line_no=$i+1;
                $user_valid=$this->Model_user->user_validation($users[$i]);
                $extension_valid=$this->Model_user->phone_validation($extension[$i]);
                if($user_valid==true){
                    $user_message.="$users[$i]: existing  ";
                    $validation=true;
                }
                if($extension_valid==true){
                    $phone_message.="$extension[$i]: existing  ";
                    $validation=true;
                }

                

                if(strlen($users[$i])<2)
                {
                	$user_message.="USER: minimum 2 characters required for user  ";
                    $validation=true;
                }else{
                	if (preg_match("/^[_a-zA-z0-9]+$/", $users[$i])) 
	                {
	                	//do nothing
	                }else{
	                	$user_message.="USER: Special characters not allowed for user  ";
	                    $validation=true;
	                }
                }

                if(strlen($users[$i])>20)
                {
                	$user_message.="USER: maximum 20 characters required for user  ";
                    $validation=true;
                }


                

                if(strlen($extension[$i])<2)
                {
                	$phone_message.="PHONE: minimum 2 characters required for phone  ";
                    $validation=true;
                }else{
                	if (preg_match("/^[0-9]+$/", $extension[$i]))
	                {
	                	//do nothing
	                }else{
	                	$phone_message.="PHONE: only numbers required for phone  ";
	                    $validation=true;
	                }
                }

                if(strlen($extension[$i])>10)
                {
                	$phone_message.="PHONE: maximum 10 characters required for phone  ";
                    $validation=true;
                }

                

                if(strlen($pass[$i])<4)
                {
                	$phone_message.="PASS: minimum 4 characters required for password  ";
                    $validation=true;
                }else{

                	if (preg_match("/^[_a-zA-z0-9]+$/", $pass[$i]))
	                {
	                	//do nothing
	                }else{
	                	$phone_message.="PASS: only numbers required for password  ";
	                    $validation=true;
	                }
                }

                if(strlen($pass[$i])>50)
                {
                	$phone_message.="PASS: maximum 50 characters required for password  ";
                    $validation=true;
                }

                if($validation==true)
                {
                	$inner_message.="$line_no) ".$user_message." " .$phone_message."\n\n";
                }                
            }
            $errors=$inner_message;
            if(trim($errors)!="")
            {
            	$errors=array("error"=>$errors);
	            $data=array("status"=>false,"csrf"=>$csrf,"errors"=>$errors);
	            exit(json_encode($data));
            }
            $this->load->model('Model_phones');


            for($i=0;$i<sizeof($sizeof);$i++)
            {   
            	$pass_hash='';
                $bcrypt=0;
                $password=$pass[$i];
                if (SSpass_hash_enabled > 0){  
                    if ($bcrypt < 1)
                      {
                      $pass_hash = exec("../agent/bp.pl --pass='$password'");
                      $pass_hash = preg_replace("/PHASH: |\n|\r|\t| /",'',$pass_hash);
                      }
                    else
                      {$pass_hash = $password;}                                            
                    $vicidial_users=array("user"=>$users[$i],"pass"=>'','pass_hash'=>$pass_hash,"full_name"=>$full_name[$i],"phone_login"=>$extension[$i],"phone_pass"=>$pass[$i],"user_group"=>$user_group,"user_level"=>"1","scheduled_callbacks"=>"1","agentonly_callbacks"=>"1","agentcall_manual"=>"1","active"=>"Y");
                }else{
                    $vicidial_users=array("user"=>$users[$i],"pass"=>$pass[$i],"full_name"=>$full_name[$i],"phone_login"=>$extension[$i],"phone_pass"=>$pass[$i],"user_group"=>$user_group,"user_level"=>"1","scheduled_callbacks"=>"1","agentonly_callbacks"=>"1","agentcall_manual"=>"1","active"=>"Y");
                }
            	$this->Model_user->addUser($vicidial_users);
            	$phones=array("extension"=>$extension[$i],
            		"login"=>$extension[$i],
            		"pass"=>$pass[$i],
            		"user_group"=>$user_group,
            		"server_ip"=>$server_ip,
            		"is_webphone"=>$is_webphone,
            		"template_id"=>$template_id,
            		"conf_secret"=>$conf_secret[$i],
            		"active"=>$active,
            		"status"=>$status,
            		"full_name"=>$full_name,
            		"outbound_cid"=>"");
            	$this->Model_phones->AddPhone($phones);
            }


            $data=array("status"=>true,"csrf"=>$csrf,"message"=>$this->Model_lib->_QXZ("Bulk Users successfully created."));
                           exit(json_encode($data));

            
        }
        public function copy()
        {   
            $userdata=$this->Model_login->Get_loggedin_user();           
            $csrf = array(
                'name' => $this->security->get_csrf_token_name(),
                'hash' => $this->security->get_csrf_hash()
            );
            if ($this->input->server('REQUEST_METHOD') == 'POST'){
                $this->load->library('form_validation');
                $this->form_validation->set_rules(
                        'user',$this->Model_lib->_QXZ('Username'),
                        'required|min_length[2]|max_length[20]|is_unique[vicidial_users.user]|regex_match[/^[_a-zA-z0-9]+$/]',
                        array(
                            'required'      => $this->Model_lib->_QXZ("You have not provided").' %s.',
                            'is_unique'     => $this->Model_lib->_QXZ("This %s already exists."),
                            'regex_match'   => $this->Model_lib->_QXZ("Special characters allowed for").' %s.'
                        )
                );
                $this->form_validation->set_rules(
                        'full_name', $this->Model_lib->_QXZ("Full Name"),
                        'required|min_length[2]|max_length[100]',
                        array(
                            'required'      => $this->Model_lib->_QXZ("You have not provided").' %s.'                                    
                        )
                );
                $this->form_validation->set_rules('pass', 'Password', 'required|min_length[4]|max_length[50]|regex_match[/^[_a-zA-z0-9]+$/]',
                        array(
                                'required'      => $this->Model_lib->_QXZ("You have not provided").' %s.',
                                'regex_match'   => $this->Model_lib->_QXZ("Special characters allowed for").' %s.'
                        )
                );

                $this->form_validation->set_rules(
                        'source_user_id', $this->Model_lib->_QXZ("Source User"),
                        'required',
                        array(
                            'required'      => $this->Model_lib->_QXZ("You have not provided").' %s.'                                    
                        )
                );

                // if($this->input->post('user_level')=="1" || $this->input->post('user_level')=="2")
                // {    
                //     $this->form_validation->set_rules(
                //             'phone_login',$this->Model_lib->_QXZ('Phone Extension'),
                //             'required|min_length[4]|max_length[10]|is_unique[phones.extension]|regex_match[/^[0-9]+$/]',
                //             array(
                //                 'required'      => $this->Model_lib->_QXZ("You have not provided").' %s.',
                //                 'is_unique'     => $this->Model_lib->_QXZ("This %s already exists."),
                //                 'regex_match'   => $this->Model_lib->_QXZ("Special characters allowed for").' %s.'
                //             )
                //     );
                // }

                if ($this->form_validation->run() == FALSE)
                {
                    $errors = $this->form_validation->error_array();
                    $data=array("status"=>false,"csrf"=>$csrf,"errors"=>$errors);
                    exit(json_encode($data));
                }
                $_POST['source_user_id']=$this->Model_lib->CheckUser($this->input->post('source_user_id'),$csrf);
                $result=$this->Model_user->copyUser();
                if($result){
                    $message=$this->Model_lib->_QXZ("User Copied").": ".$this->input->post('user')." ".$this->Model_lib->_QXZ("Copied From")." ".$this->input->post('source_user_id');
                    $data=array("status"=>true,"csrf"=>$csrf,"message"=>$message);
                   exit(json_encode($data));
                }else{
                   $errors=array("error"=>$this->Model_lib->_QXZ("unable to copy user."));
                   $data=array("status"=>false,"csrf"=>$csrf,"errors"=>$errors);
                   exit(json_encode($data));
                }

            }else{
                $data=array("csrf"=>$csrf);
                $this->load->view('users/copy', compact('data','userdata'));
            }            
        }
        
        public function add(){
            $userdata=$this->Model_login->Get_loggedin_user();
            #$this->Model_lib->Is_lock();
            $groups=$this->Model_lib->Get_usergroups();
            $csrf = array(
                        'name' => $this->security->get_csrf_token_name(),
                        'hash' => $this->security->get_csrf_hash()
                );
            $data=array("groups"=>$groups,"csrf"=>$csrf);
            if ($this->input->server('REQUEST_METHOD') == 'POST') {                    
                    $this->load->library('form_validation');
                    $this->form_validation->set_rules(
                            'user',$this->Model_lib->_QXZ('Username'),
                            'required|min_length[2]|max_length[20]|is_unique[vicidial_users.user]|regex_match[/^[_a-zA-z0-9]+$/]',
                            array(
                                'required'      => $this->Model_lib->_QXZ("You have not provided").' %s.',
                                'is_unique'     => $this->Model_lib->_QXZ("This %s already exists."),
                                'regex_match'   => $this->Model_lib->_QXZ("Special characters allowed for").' %s.'
                            )
                    );
                    $this->form_validation->set_rules(
                            'full_name', $this->Model_lib->_QXZ("Full Name"),
                            'required|min_length[2]|max_length[100]',
                            array(
                                'required'      => $this->Model_lib->_QXZ("You have not provided").' %s.'                                    
                            )
                    );
                    
                    // if($this->input->post('user_level')=="1" || $this->input->post('user_level')=="2")
                    // {    
                    //     $this->form_validation->set_rules(
                    //             'phone_login',$this->Model_lib->_QXZ('Phone Extension'),
                    //             'required|min_length[4]|max_length[10]|is_unique[phones.extension]|regex_match[/^[0-9]+$/]',
                    //             array(
                    //                 'required'      => $this->Model_lib->_QXZ("You have not provided").' %s.',
                    //                 'is_unique'     => $this->Model_lib->_QXZ("This %s already exists."),
                    //                 'regex_match'   => $this->Model_lib->_QXZ("Special characters allowed for").' %s.'
                    //             )
                    //     );
                    // }

                    $this->form_validation->set_rules('pass', 'Password', 'required|min_length[4]|max_length[50]|regex_match[/^[_a-zA-z0-9]+$/]',
                         array(
                                'required'      => $this->Model_lib->_QXZ("You have not provided").' %s.',
                                'regex_match'   => $this->Model_lib->_QXZ("Special characters allowed for").' %s.'
                                )
                        );
                    $this->form_validation->set_rules('passconf', 'Password Confirmation', 'required|matches[pass]|min_length[4]|max_length[50]');
                    if ($this->form_validation->run() == FALSE){
                        $errors = $this->form_validation->error_array();
                        $data=array("status"=>false,"csrf"=>$csrf,"errors"=>$errors);
                        exit(json_encode($data));
                    }else{
                         $_POST['user_group']=$this->Model_lib->CheckGroup($this->input->post('user_group'),$csrf);
                         $data=$this->input->post();
                         unset($data['passconf']);
                         unset($data['no_of_agents']);
                         $result=$this->Model_user->AddUser($data);                        
                         if($result){
                            $this->Model_lib->Update_User_Permissions($this->input->post('user'),$this->input->post('api_only_user'));
                            $data=array("status"=>true,"csrf"=>$csrf,"message"=>$this->Model_lib->_QXZ("User successfully created."));
                           exit(json_encode($data));
                        }else{
                           $errors=array("error"=>$this->Model_lib->_QXZ("unable to created user."));
                           $data=array("status"=>false,"csrf"=>$csrf,"errors"=>$errors);
                           exit(json_encode($data));
                        }
                    }                                                 
            }else{
                $userdata=$this->Model_login->Get_loggedin_user();  
                $this->load->view('users/add', compact('data','userdata'));
            }
        }
        
        public function edit($id=""){
            #$this->Model_lib->Is_lock(); 
            $csrf = array(
                        'name' => $this->security->get_csrf_token_name(),
                        'hash' => $this->security->get_csrf_hash()
            );
            $userdata=$this->Model_login->Get_loggedin_user();
            if ($this->input->server('REQUEST_METHOD') == 'POST') {
                    $_POST['user_id']=$this->Model_lib->CheckUserId($this->input->post('user_id'),$csrf);
                    $this->load->library('form_validation');
                    
                    $this->form_validation->set_rules(
                            'full_name', $this->Model_lib->_QXZ("Full Name"),
                            'required|min_length[2]|max_length[100]',
                            array(
                                'required'      => $this->Model_lib->_QXZ("You have not provided").' %s.'                                    
                            )
                    );
                    if (SSpass_hash_enabled > 0){
                        $this->form_validation->set_rules('pass', 'Password', 'regex_match[/^[_a-zA-z0-9]+$/]',
                         array(
                                'regex_match'   => $this->Model_lib->_QXZ("Special characters allowed for").' %s.'
                                )
                        );
                    }else{
                        $this->form_validation->set_rules('pass', 'Password', 'required|min_length[4]|max_length[50]|regex_match[/^[_a-zA-z0-9]+$/]',
                         array(
                                'required'      => $this->Model_lib->_QXZ("You have not provided").' %s.',
                                'regex_match'   => $this->Model_lib->_QXZ("Special characters allowed for").' %s.'
                                )
                        );
                    }    
                    
                    $add_extension=false;
                    // if($this->input->post('user_level')=="1" || $this->input->post('user_level')=="2")
                    // {    
                    //     //get existing extension:
                    //     if($this->input->post('phone_login')!="")
                    //     {
                    //         $extension=$this->Model_user->getUser($this->input->post('user_id'));
                    //     }else{
                    //         $extension=array();
                    //     }
                    //     if(isset($extension['user_level']))
                    //     {
                    //         if($extension['user_level']=="1" || $extension['user_level']=="2")
                    //         {
                    //             if(trim($extension['phone_login'])!=$this->input->post('phone_login'))
                    //             {
                    //                 $errors=array("error"=>$this->Model_lib->_QXZ("You can't change the phone login for this account."));
                    //                 $data=array("status"=>false,"csrf"=>$csrf,"errors"=>$errors);
                    //                 exit(json_encode($data));
                    //             }
                    //         }
                    //     }
                        

                    //     if(sizeof($extension)>0)
                    //     {
                    //         $extension=$extension['phone_login'];
                    //     }else{
                    //         $extension="";
                    //     }

                    //     if(trim($extension)!=$this->input->post('phone_login') || trim($extension)=="")
                    //     {
                    //         $this->form_validation->set_rules(
                    //             'phone_login',$this->Model_lib->_QXZ('Phone Extension'),
                    //             'required|min_length[4]|max_length[10]|is_unique[phones.extension]|regex_match[/^[0-9]+$/]',
                    //             array(
                    //                 'required'      => $this->Model_lib->_QXZ("You have not provided").' %s.',
                    //                 'is_unique'     => $this->Model_lib->_QXZ("This %s already exists."),
                    //                 'regex_match'   => $this->Model_lib->_QXZ("Special characters allowed for").' %s.'
                    //             )
                    //         );
                    //         $add_extension=true;
                    //     }                        
                    // }

                    if ($this->form_validation->run() == FALSE){
                        $errors = $this->form_validation->error_array();
                        $data=array("status"=>false,"csrf"=>$csrf,"errors"=>$errors);
                        exit(json_encode($data));
                    }else{
                        $_POST['user_group']=$this->Model_lib->CheckGroup($this->input->post('user_group'),$csrf);
                         $data=$this->input->post();                        
                         unset($data['no_of_agents']);
                         $result=$this->Model_user->updateUser($data,$this->input->post('user_id'),$add_extension);
                         if($result){
                            $this->Model_lib->Update_User_Permissions($this->input->post('user_id'),$this->input->post('api_only_user'),$isUserId=true);
                            $data=array("status"=>true,"csrf"=>$csrf,"message"=>$this->Model_lib->_QXZ("User successfully updated."));
                           exit(json_encode($data));
                         }else{
                            $errors=array("error"=>$this->Model_lib->_QXZ("unable to created user."));
                           $data=array("status"=>false,"csrf"=>$csrf,"errors"=>$errors);
                           exit(json_encode($data));
                         }  
                    }
            }else{
                $id=$this->Model_lib->DecryptionId($id);                
                $groups=$this->Model_lib->Get_usergroups();                
                $user_group=array("groups"=>$groups);
                $user_info=$this->Model_user->getUser($id);
                if($user_info==FALSE){
                    $this->session->set_flashdata('error','invalid account id');
                    redirect(base_url('user/users'));
                }
                $data= array_merge($user_info,$user_group,array("csrf"=>$csrf));                
                $this->load->view('users/edit', compact('data','userdata'));
            }
        }
        
        public function delete($id=""){
            //$this->Model_lib->Is_lock();            
            $id=$this->Model_lib->DecryptionId($id);
            
            $result=$this->Model_user->deleteUser($id);  
            if($result){
                $this->session->set_flashdata('success','Account successfully deleted.');
                $this->Model_lib->admin_change_log("USER","Delete User","");   
                redirect(base_url('user/users'));
            }else{
                $this->session->set_flashdata('error','unable to delete account.');
                redirect(base_url('user/users'));
            }            
        }

        public function permissions($id="")
        {
            $csrf = array(
                        'name' => $this->security->get_csrf_token_name(),
                        'hash' => $this->security->get_csrf_hash()
            );
            $userdata=$this->Model_login->Get_loggedin_user();
            $data=array("csrf"=>$csrf);
             if ($this->input->server('REQUEST_METHOD') == 'POST') {
                    $_POST['user_id']=$this->Model_lib->CheckUserId($this->input->post('user_id'),$csrf);
                    $permissions=$this->input->post('permissions');
                    // if(sizeof($permissions)==0){
                    //     $errors=array("error"=>$this->Model_lib->_QXZ("Please select permissions."));
                    //     $data=array("status"=>false,"csrf"=>$csrf,"errors"=>$errors);
                    //     exit(json_encode($data));                    
                    // }else{

                    $permissions=$this->input->post('permissions');
                    $user_permissions="";
                    for($i=0;$i<sizeof($permissions);$i++){
                        //$user_permissions.=$this->Model_lib->DecryptionId($permissions[$i]).",";

                        $user_permissions.=$permissions[$i].",";
                    }   
                    $user_permissions=rtrim($user_permissions,",");               
                    $this->Model_user->setUserPermissions($user_permissions,$this->input->post('user_id'));
                    $data=array("status"=>true,"csrf"=>$csrf,"message"=>$this->Model_lib->_QXZ("Permissions successfully updated."));
                    exit(json_encode($data));                
                //}
            }else{
                $id=$this->Model_lib->DecryptionId($id);
                $user_info=$this->Model_user->getUser($id);
                $this->load->view('users/permissions', compact('data','user_info','userdata'));
            }            
        }
        
        
        
        public function lock(){
            $this->Model_lib->Put_session('lock',true);
            $this->load->model('Model_login');
            $userdata=$this->Model_login->Get_loggedin_user(); 
            
                $csrf = array(
                        'name' => $this->security->get_csrf_token_name(),
                        'hash' => $this->security->get_csrf_hash()
                );
                
                $userdata=array_merge($userdata,$csrf);
		            
            $this->load->view('lock', compact('userdata'));
        }
        
        public function unlock(){
            
            $current_session = $this->Model_lib->Get_session();
            $username = $current_session['username'];
            $password = $this->input->post('password');
            $this->load->model('Model_login');
            if($this->Model_login->Authenticate($username,$password)){
                $this->Model_lib->Unset_session('lock');
                redirect('dashboard');
            }else{
                $this->session->set_flashdata('error','Invalid Password, try again.');
                redirect(base_url().'user/lock');
            }
        }

        public function callbacks($id="")
        {
            $id=$this->Model_lib->DecryptionId($id);
            $this->Model_user->user_callbacks($id);            
        }

        public function user_stats($id="",$start_date="",$end_date="",$archive="")
        {
            // print_r($id);
            // print_r($start_date);
            // print_r($end_date);

            if($start_date==""){$start_date=date("Y-m-d");}
            if($end_date==""){$end_date=date("Y-m-d");}
            if($archive==""){$archive="N";}
            

            $id=$this->Model_lib->DecryptionId($id);
            $user_info=$this->Model_user->getUser($id);
            $user_info=array_merge($user_info,array("start_date"=>$start_date,"end_date"=>$end_date,"archive"=>$archive));
            $this->load->view('users/user_stats', compact('data','user_info','userdata'));
        }

        public function delete_callbacks()
        {   $csrf = array(
                            'name' => $this->security->get_csrf_token_name(),
                            'hash' => $this->security->get_csrf_hash()
                    );
            $user=$this->Model_lib->DecryptionId($this->input->post('user'));            
            $code=$this->input->post('code');     
            $this->Model_user->delete_callbacks($user,$code,$csrf);    

        }
        
        public function logout()
        {            
            $this->Model_lib->Session_unset();            
        }


public function _userRegex($user) {
  if (preg_match('/[^-_0-9a-zA-Z]/', $user ) ) 
  {
    return TRUE;
  } 
  else 
  {
    return FALSE;
  }
}
}