<?php
defined('BASEPATH') OR exit('No direct script access allowed');
class Statuses extends CI_Controller {
        var $userdata = null;
        function __construct()
        {
           parent::__construct();    
           if(!$this->Model_lib->Is_login()){
               redirect(base_url().'login');
           }                    
           $this->load->model('Model_statuses');
           $this->load->model('Model_login');
           $this->userdata=$this->Model_login->Get_loggedin_user();
        }
        
        public function index()
        {
            $userdata=$this->userdata; 
            $this->load->view('statuses/view', compact('userdata')); 
        }
        
        public function save()
        {
            $this->load->library('form_validation');
            $this->form_validation->set_rules(
                    'status', $this->Model_lib->_QXZ("Status"),
                    'required|min_length[1]|max_length[6]|regex_match[/^[_a-zA-z0-9]+$/]|is_unique[vicidial_statuses.status]',
                    array(
                        'required'      => $this->Model_lib->_QXZ("You have not provided").' %s.',
                        'min_length'    => $this->Model_lib->_QXZ("minumum required length is 1 in").' %s.',
                        'max_length'    => $this->Model_lib->_QXZ("max_length required length is 6 in").' %s.',
                        'regex_match'   => $this->Model_lib->_QXZ("Special characters are not allowed for").' %s.',
                    )
            );
            $this->form_validation->set_rules(
                    'status_name', $this->Model_lib->_QXZ("Status Name"),
                    'required|min_length[2]|max_length[30]',
                    array(
                        'required'      => $this->Model_lib->_QXZ("You have not provided").' %s.',
                        'min_length'    => $this->Model_lib->_QXZ("minumum required length is 2 in").' %s.',
                        'max_length'    => $this->Model_lib->_QXZ("maximum required length is 6 in").' %s.'
                    )
            );
            if ($this->form_validation->run() == FALSE)
            {
                $errors = $this->form_validation->error_array();
                $data=array("status"=>false,"errors"=>$errors);
                exit(json_encode($data));
            }
            $data=$this->input->post();
            if($this->Model_statuses->save($data)){                     
                $result=array("status"=>true,"msg"=>"Status successfully update");
            }else{            
                $result=array("status"=>false,"msg"=>"Unable to update status.");
            }
            exit(json_encode($result));
        }

    public function delete(){
        $status=$this->input->post('status');
        $status = $this->Model_lib->DecryptionId($status);
        if($this->Model_statuses->delete($status)){                     
            $result=array("status"=>true,"msg"=>"Status successfully deleted");
        }else{            
            $result=array("status"=>false,"msg"=>"Unable to delete status.");
        }
        exit(json_encode($result));     
    }    
        
    public function update()
    {
        $status=$this->input->post('status');
        $status = $this->Model_lib->DecryptionId($status);        
        $_POST['status']=$status;
        $this->load->library('form_validation');
        $this->form_validation->set_rules(
                'status', $this->Model_lib->_QXZ("Status"),
                'required|min_length[1]|max_length[6]|regex_match[/^[_a-zA-z0-9]+$/]',
                array(
                    'required'      => $this->Model_lib->_QXZ("You have not provided").' %s.',
                    'min_length'    => $this->Model_lib->_QXZ("minumum required length is 1 in").' %s.',
                    'max_length'    => $this->Model_lib->_QXZ("max_length required length is 6 in").' %s.',
                    'regex_match'   => $this->Model_lib->_QXZ("Special characters are not allowed for").' %s.',
                )
        );

        $this->form_validation->set_rules(
                'status_name', $this->Model_lib->_QXZ("Status Name"),
                'required|min_length[2]|max_length[30]',
                array(
                    'required'      => $this->Model_lib->_QXZ("You have not provided").' %s.',
                    'min_length'    => $this->Model_lib->_QXZ("minumum required length is 2 in").' %s.',
                    'max_length'    => $this->Model_lib->_QXZ("maximum required length is 6 in").' %s.'
                )
        );

        if ($this->form_validation->run() == FALSE)
        {
            $errors = $this->form_validation->error_array();
            $data=array("status"=>false,"errors"=>$errors);
            exit(json_encode($data));
        }

        unset($_POST['status']);
        $data=$this->input->post();
        if($this->Model_statuses->update($status,$data)){                     
            $result=array("status"=>true,"msg"=>"Status successfully update");
        }else{            
            $result=array("status"=>false,"msg"=>"Unable to update status.");
        }
        exit(json_encode($result));        
    }
}