<?php
defined('BASEPATH') OR exit('No direct script access allowed');
class Soundboard  extends CI_Controller {
        var $userdata=null;
        var $csrf=null; 
        function __construct()
        {
           parent::__construct();    
           if(!$this->Model_lib->Is_login()){
               redirect(base_url().'login');
           }                  
           $this->load->model('Model_login');
           $this->load->model('Model_soundboard');
           $this->userdata=$this->Model_login->Get_loggedin_user();           
        }
            

       public function delete_details($sound_id)
       {  

            $id=$this->Model_lib->DecryptionId($sound_id);    
            $details=$this->Model_soundboard->get_details($id);
            $avatar_id=$details['avatar_id'];
            $avatar_id=$this->Model_lib->EncryptionId($avatar_id);
            $result=$this->Model_soundboard->remove_details($id,$avatar_id);  
            if($result){
                $this->session->set_flashdata('success','Soundboard sound file successfully deleted.');             
                redirect(base_url('soundboard/files/'.$avatar_id));
            }else{
                $this->session->set_flashdata('error','unable to delete Soundboard sound file.');
                redirect(base_url('soundboard/files/'.$avatar_id));
            }
       }      

       public function popup_sounds(){
            $sounds=$this->Model_lib->Get_sounds();
            $sounds_select2=json_encode($sounds);
            exit($sounds_select2);
       }

       public function save_details(){
            $csrf = array(
                    'name' => $this->security->get_csrf_token_name(),
                    'hash' => $this->security->get_csrf_hash()
            );
            $avatar_id=$this->Model_lib->CheckSoundboardID($this->input->post('avatar_id'),$csrf);
            $_POST['avatar_id']=$avatar_id;
            $ids=$this->input->post('id');
            $audio_filename=$this->input->post('audio_filename');
            $button_type=$this->input->post('button_type');
            $font_size=$this->input->post('font_size');
            $audio_name=$this->input->post('audio_name');
            $rank=0;
            for($i=0;$i<sizeof($ids);$i++)
            {   $id="";
                if(isset($ids[$i]))
                {
                  $id=$ids[$i];
                }      
                $rank++;
                if(trim($id)==""){
                  $data=['rank'=>$rank,'avatar_id'=>$avatar_id,'audio_filename'=>$audio_filename[$i],"button_type"=>$button_type[$i],"font_size"=>$font_size[$i],"audio_name"=>$audio_name[$i],"h_ord"=>"1","level"=>"1","color"=>"#3eb4c1"];
                  $this->Model_soundboard->insert_details($data);
                }else{
                  $data=['rank'=>$rank,'avatar_id'=>$avatar_id,'audio_filename'=>$audio_filename[$i],"button_type"=>$button_type[$i],"font_size"=>$font_size[$i],"audio_name"=>$audio_name[$i]];
                  $this->Model_soundboard->update_details($data,$id);               
                }               
            }  
            $array=array("status"=>true,"csrf"=>$csrf,"message"=>$this->Model_lib->_QXZ("Soundboard files successfully updated."));
             exit(json_encode($array));          
        }

      public function index(){
          $userdata=$this->userdata; 
            $this->load->view('soundboard/view', compact('userdata')); 
      }  

      public function manage()
    	{      
            $userdata=$this->userdata; 
            $this->load->view('soundboard/view', compact('userdata')); 
    	}

     public function create()
      {
        $userdata=$this->userdata;
        $csrf = array(
                      'name' => $this->security->get_csrf_token_name(),
                      'hash' => $this->security->get_csrf_hash()
              );            
        $data=array("csrf"=>$csrf);
        $this->load->view('soundboard/add', compact('data','userdata'));
      }

      public function copy()
      {   $data=array();
          $csrf = array(
                      'name' => $this->security->get_csrf_token_name(),
                      'hash' => $this->security->get_csrf_hash()
              );
          if ($this->input->server('REQUEST_METHOD') == 'POST'){
              $this->load->library('form_validation');
              $this->form_validation->set_rules(
                        'avatar_id',$this->Model_lib->_QXZ('Soundboard ID'),
                        'required|min_length[2]|max_length[20]|is_unique[vicidial_avatars.avatar_id]|regex_match[/^[_a-zA-z0-9]+$/]',
                        array(
                            'required'      => $this->Model_lib->_QXZ("You have not provided").' %s.',
                            'is_unique'     => $this->Model_lib->_QXZ("This %s already exists."),
                            'regex_match'   => $this->Model_lib->_QXZ("Special characters allowed for").' %s.'
                        )
                );
                $this->form_validation->set_rules(
                        'avatar_name', $this->Model_lib->_QXZ("Soundboard Name"),
                        'required|min_length[2]|max_length[255]',
                        array(
                            'required'      => $this->Model_lib->_QXZ("You have not provided").' %s.'                                    
                        )
                );

                $this->form_validation->set_rules(
                        'source_id', $this->Model_lib->_QXZ("Source Soundboard"),
                        'required|min_length[2]|max_length[20]',
                        array(
                            'required'      => $this->Model_lib->_QXZ("You have not provided").' %s.'                                    
                        )
                );

                if ($this->form_validation->run() == FALSE)
                {
                    $errors = $this->form_validation->error_array();
                    $data=array("status"=>false,"csrf"=>$csrf,"errors"=>$errors);
                    exit(json_encode($data));
                }                
                $result=$this->Model_soundboard->copy_soundboard($this->input->post('avatar_id'),$this->input->post('avatar_name'),$this->input->post('source_id'));
                if($result){
                    $message=$this->Model_lib->_QXZ("Soundboard Copied").": ".$this->input->post('avatar_id')." ".$this->Model_lib->_QXZ("Copied From")." ".$this->input->post('source_id');
                    $data=array("status"=>true,"csrf"=>$csrf,"message"=>$message);
                   exit(json_encode($data));
                }else{
                   $errors=array("error"=>$this->Model_lib->_QXZ("unable to copy soundboard."));
                   $data=array("status"=>false,"csrf"=>$csrf,"errors"=>$errors);
                   exit(json_encode($data));
                }

          }else{
            $data= array_merge($data,array("csrf"=>$csrf));
            $userdata=$this->userdata;
            $this->load->view('soundboard/copy', compact('data','userdata'));
          }          
      }

      public function save(){
                $this->load->library('form_validation');
                $csrf = array(
                        'name' => $this->security->get_csrf_token_name(),
                        'hash' => $this->security->get_csrf_hash()
                );
                
                $this->form_validation->set_rules('avatar_id', 'Soundboard ID', 'required|is_unique[vicidial_avatars.avatar_id]|min_length[2]|max_length[50]|regex_match[/^[_a-zA-z0-9]+$/]',
                        array(
                                'required'      => $this->Model_lib->_QXZ("You have not provided").' %s.',
                                'regex_match'   => $this->Model_lib->_QXZ("Special characters not allowed for").' %s.'
                        )
                );

               $this->form_validation->set_rules(
                        'avatar_name', $this->Model_lib->_QXZ("Soundboard Name"),
                        'required|min_length[2]|max_length[255]',
                        array(
                            'required'      => $this->Model_lib->_QXZ("You have not provided").' %s.'                                    
                        )
                );
                

                if ($this->form_validation->run() == FALSE){            
                  $errors = $this->form_validation->error_array();
                  $data=array("status"=>false,"csrf"=>$csrf,"errors"=>$errors);
                  exit(json_encode($data));
                }else{
                    $result=$this->Model_soundboard->insert($this->input->post());
                    if($result){
                        $data=array("status"=>true,"csrf"=>$csrf,"message"=>$this->Model_lib->_QXZ("Soundboard successfully created."));
                       exit(json_encode($data));
                    }else{
                       $errors=array("error"=>$this->Model_lib->_QXZ("unable to created Soundboard."));
                       $data=array("status"=>false,"csrf"=>$csrf,"errors"=>$errors);
                       exit(json_encode($data));
                    }
                }
      }

      public function edit($id)
      { 

        $id = $this->Model_lib->DecryptionId($id);
        $queue_data = $this->Model_soundboard->get($id);
        $csrf = array(
                    'name' => $this->security->get_csrf_token_name(),
                    'hash' => $this->security->get_csrf_hash()
            );
        $data= array_merge($queue_data,array("csrf"=>$csrf));
        $userdata=$this->userdata;
        $this->load->view('soundboard/edit', compact('data','userdata'));

      }

      public function files($id)
      { 

        $id = $this->Model_lib->DecryptionId($id);
        $queue_data = $this->Model_soundboard->get($id);
        $csrf = array(
                    'name' => $this->security->get_csrf_token_name(),
                    'hash' => $this->security->get_csrf_hash()
            );
        $data= array_merge($queue_data,array("csrf"=>$csrf));
        $userdata=$this->userdata;
        $this->load->view('soundboard/files', compact('data','userdata'));

      }

      public function modify()
      {
                $this->load->library('form_validation');
                $csrf = array(
                        'name' => $this->security->get_csrf_token_name(),
                        'hash' => $this->security->get_csrf_hash()
                );
                $avatar_id=$this->Model_lib->CheckSoundboardID($this->input->post('avatar_id'),$csrf);
                $_POST['avatar_id']=$avatar_id;  

                $this->form_validation->set_rules('avatar_id', 'Soundboard ID', 'required|min_length[2]|max_length[50]|regex_match[/^[_a-zA-z0-9]+$/]',
                        array(
                                'required'      => $this->Model_lib->_QXZ("You have not provided").' %s.',
                                'regex_match'   => $this->Model_lib->_QXZ("Special characters not allowed for").' %s.'
                        )
                );

               $this->form_validation->set_rules(
                        'avatar_name', $this->Model_lib->_QXZ("Soundboard Name"),
                        'required|min_length[2]|max_length[255]',
                        array(
                            'required'      => $this->Model_lib->_QXZ("You have not provided").' %s.'                                    
                        )
                );

                if ($this->form_validation->run() == FALSE){            
                  $errors = $this->form_validation->error_array();
                  $data=array("status"=>false,"csrf"=>$csrf,"errors"=>$errors);
                  exit(json_encode($data));
                }else{
                    $result=$this->Model_soundboard->update($this->input->post(),$avatar_id);
                    if($result){
                        $data=array("status"=>true,"csrf"=>$csrf,"message"=>$this->Model_lib->_QXZ("Soundboard successfully updated."));
                       exit(json_encode($data));
                    }else{
                       $errors=array("error"=>$this->Model_lib->_QXZ("unable to update Soundboard."));
                       $data=array("status"=>false,"csrf"=>$csrf,"errors"=>$errors);
                       exit(json_encode($data));
                    }
                }
      }     

      
      public function delete($ingroup_id)
      {
            $id=$this->Model_lib->DecryptionId($ingroup_id);            
            $result=$this->Model_soundboard->remove($id);  
            if($result){
                $this->session->set_flashdata('success','Soundboard successfully deleted.');             
                redirect(base_url('soundboard/manage'));
            }else{
                $this->session->set_flashdata('error','unable to delete Soundboard.');
                redirect(base_url('soundboard/manage'));
            }
      }
        
}