<?php
defined('BASEPATH') OR exit('No direct script access allowed');
class Settings extends CI_Controller {
        var $userdata = null;
        function __construct()
        {
           parent::__construct();    
           if(!$this->Model_lib->Is_login()){
               redirect(base_url().'login');
           }                    
           $this->load->model('Model_settings');
           $this->load->model('Model_login');
           $this->userdata=$this->Model_login->Get_loggedin_user();
        }
        
        public function index(){
            $this->edit();
        }
        
        public function edit()
        {
            $this->Model_lib->Is_lock(); 
            $userdata= $this->userdata;
            $list_data = $this->Model_settings->get();
            $csrf = array(
                        'name' => $this->security->get_csrf_token_name(),
                        'hash' => $this->security->get_csrf_hash()
                );
            $data= array_merge($list_data,array("csrf"=>$csrf));
            $this->load->view('settings', compact('data','userdata'));
        }

        public function recycle(){
            $userdata= $this->userdata;
            $csrf = array(
                        'name' => $this->security->get_csrf_token_name(),
                        'hash' => $this->security->get_csrf_hash()
                );
            $data=array("csrf"=>$csrf);
            $this->load->view('recycle/index', compact('data','userdata'));
        }
        
    public function update()
    {
        $this->load->library('form_validation');
        $this->form_validation->set_rules(
                'auto_dial_limit', 'Auto Dial Limit',
                'required|min_length[1]|max_length[19]',
                array(
                        'required'      => 'You have not provided %s.',
                        'regex_match'   => 'only numbers allowed for %s.'
                )
        );
        $this->form_validation->set_rules(
                'outbound_calls_per_second', 'Outbound Calls Per Second',
                'required|min_length[1]|max_length[19]',
                array(
                        'required'      => 'You have not provided %s.',
                        'regex_match'   => 'only numbers allowed for %s.'
                )
        );
        $this->form_validation->set_rules(
                'default_phone_code', 'defaultf phone code',
                'required|min_length[1]|max_length[19]',
                array(
                        'required'      => 'You have not provided %s.',
                        'regex_match'   => 'only numbers allowed for %s.'
                )
        );
        if ($this->form_validation->run() == FALSE){
            $this->Model_lib->Is_lock();
            $csrf = array(
                            'name' => $this->security->get_csrf_token_name(),
                            'hash' => $this->security->get_csrf_hash()
                    );
            $error = array(
                    'auto_dial_limit' => form_error('auto_dial_limit'),
                    'outbound_calls_per_second' => form_error('outbound_calls_per_second'),
                    'default_phone_code' => form_error('default_phone_code')
            );            
            $data=array("csrf"=>$csrf,"error"=>$error,"status"=>false,"msg"=>"Please enter required fields.");
            exit(json_encode($data));
        }else{
             $csrf = array(
                            'name' => $this->security->get_csrf_token_name(),
                            'hash' => $this->security->get_csrf_hash()
                    );
             $data=$this->Model_lib->parse_array($this->input->post());
             $version=$this->input->post('version');
            if($this->Model_settings->update($version,$data)){                     
                $result=array("status"=>true,"msg"=>"Settings successfully update","csrf"=>$csrf);
                $this->Model_lib->admin_change_log("Settings","Update Settings","");   
            }else{            
                $result=array("status"=>false,"msg"=>"unable to update settings.","csrf"=>$csrf);
            }
            exit(json_encode($result));
        }
    }
}