<?php
defined('BASEPATH') OR exit('No direct script access allowed');
class Servers extends CI_Controller {
        var $userdata = null;
        function __construct()
        {
           parent::__construct();    
           if(!$this->Model_lib->Is_login()){
               redirect(base_url().'login');
           }                    
           $this->load->model('Model_servers');
           $this->load->model('Model_login');
           $this->userdata=$this->Model_login->Get_loggedin_user();
        }
        
        public function index()
        {
            $this->view();
        }
        
        public function view(){
            $userdata = $this->userdata;
            $this->load->view('servers/view', compact('userdata'));
        }
        
         public function add(){
            $userdata=$this->userdata;            
            $csrf = array(
                    'name' => $this->security->get_csrf_token_name(),
                    'hash' => $this->security->get_csrf_hash()
            );
            $data=array("csrf"=>$csrf);
            $this->load->view('servers/add', compact('data','userdata'));
        }
        
        public function edit($id){            
            $this->Model_lib->Is_lock(); 
            $id = $this->Model_lib->DecryptionId($id);
            $userdata= $this->userdata;
            $list_data = $this->Model_servers->get($id);
            $csrf = array(
                        'name' => $this->security->get_csrf_token_name(),
                        'hash' => $this->security->get_csrf_hash()
                );
            $data= array_merge($list_data,array("csrf"=>$csrf));
            $this->load->view('servers/edit', compact('data','userdata'));
        }
        
        public function save(){
            $this->load->library('form_validation');
            $this->form_validation->set_rules(
                    'server_id', 'Server ID',
                    'required|min_length[2]|max_length[10]|is_unique[servers.server_id]|regex_match[/^[-_a-zA-z0-9]+$/]',
                    array(
                            'required'      => 'You have not provided %s.',
                            'is_unique'     => 'This %s already exists.',
                            'regex_match'   => 'Special characters not allowed for %s.'
                    )
            );
            $this->form_validation->set_rules(
                    'server_description', 'Description',
                    'required|min_length[2]|max_length[255]',
                    array(
                            'required'      => 'You have not provided %s.'
                    )
            );

            $this->form_validation->set_rules(
                    'server_ip', 'Server IP',
                    'required|regex_match[/^([0-9]{1,3}\.){3}[0-9]{1,3}$/]',
                    array(
                            'required'      => 'You have not provided %s.',
                            'regex_match'   => 'Invalid %s address.'
                    )
            );
            
            $this->form_validation->set_rules(
                    'asterisk_version', 'Asterisk Version',
                    'required|min_length[2]|max_length[20]',
                    array(
                        'required'      => 'You have not provided %s.'
                    )
            );
            
                if ($this->form_validation->run() == FALSE){
                    $this->Model_lib->Is_lock();
                    $csrf = array(
                                    'name' => $this->security->get_csrf_token_name(),
                                    'hash' => $this->security->get_csrf_hash()
                            );
                    $error = array(
                            'server_id' => form_error('server_id'),
                            'server_description' => form_error('server_description'),
                            'server_ip' => form_error('server_ip'),
                            'asterisk_version'=> form_error('asterisk_version')
                    );            
                    $data=array("csrf"=>$csrf,"error"=>$error,"status"=>false,"msg"=>"Please enter required fields.");
                    $this->Model_lib->admin_change_log("Servers","Add Servers","");
                    exit(json_encode($data));
                }else{
                    $_POST['conf_secret']=SSdefault_server_password;
                    $_POST['local_gmt']=SSdefault_local_gmt;
                    $data=$this->Model_lib->parse_array($this->input->post());
                    $insert_id=$this->Model_lib->EncryptionId($data['server_id']);
                    if($this->Model_servers->insert($data)){                     
                        $result=array("status"=>true,"msg"=>"Gateway successfully created","insert_id"=>$insert_id);
                    }else{            
                        $result=array("status"=>false,"msg"=>"unable to created Gateway.","insert_id"=>$insert_id);
                    }
                    exit(json_encode($result));
                }
        }
        
        public function update(){
             $this->load->library('form_validation');
            $this->form_validation->set_rules(
                    'server_id', 'Server ID',
                    'required|min_length[2]|max_length[10]|regex_match[/^[-_a-zA-z0-9]+$/]',
                    array(
                            'required'      => 'You have not provided %s.',
                            'is_unique'     => 'This %s already exists.',
                            'regex_match'   => 'Special characters not allowed for %s.'
                    )
            );
            $this->form_validation->set_rules(
                    'server_description', 'Description',
                    'required|min_length[2]|max_length[255]',
                    array(
                            'required'      => 'You have not provided %s.'
                    )
            );

            $this->form_validation->set_rules(
                    'server_ip', 'Server IP',
                    'required|regex_match[/^([0-9]{1,3}\.){3}[0-9]{1,3}$/]',
                    array(
                            'required'      => 'You have not provided %s.',
                            'regex_match'   => 'Invalid %s address.'
                    )
            );
            
            $this->form_validation->set_rules(
                    'asterisk_version', 'Asterisk Version',
                    'required|min_length[2]|max_length[20]',
                    array(
                        'required'      => 'You have not provided %s.'
                    )
            );
            
                if ($this->form_validation->run() == FALSE){
                    $this->Model_lib->Is_lock();
                    $csrf = array(
                                    'name' => $this->security->get_csrf_token_name(),
                                    'hash' => $this->security->get_csrf_hash()
                            );
                    $error = array(
                            'server_id' => form_error('server_id'),
                            'server_description' => form_error('server_description'),
                            'server_ip' => form_error('server_ip'),
                            'asterisk_version'=> form_error('asterisk_version')
                    );            
                    $data=array("csrf"=>$csrf,"error"=>$error,"status"=>false,"msg"=>"Please enter required fields.");
                    exit(json_encode($data));
                }else{
                    $_POST['conf_secret']=SSdefault_server_password;
                    $_POST['local_gmt']=SSdefault_local_gmt;
                    $data=$this->Model_lib->parse_array($this->input->post());
                    $insert_id=$this->Model_lib->EncryptionId($data['server_id']);
                    if($this->Model_servers->update($data['server_id'],$data)){                     
                        $result=array("status"=>true,"msg"=>"Server successfully created","insert_id"=>$insert_id);
                        $this->Model_lib->admin_change_log("Servers","Update Servers","");
                    }else{            
                        $result=array("status"=>false,"msg"=>"unable to created Server.","insert_id"=>$insert_id);
                    }
                    exit(json_encode($result));
                }
        }
        
        
    public function delete($id)
    {
        $this->Model_lib->Is_lock();            
        $id=$this->Model_lib->DecryptionId($id);             
        $result=$this->Model_servers->remove($id);  
        if($result){
            $this->session->set_flashdata('success','Server successfully deleted.');
            $this->Model_lib->admin_change_log("Servers","Delete Servers","");
            redirect(base_url('servers'));
        }else{
            $this->session->set_flashdata('error','unable to delete Server.');
            redirect(base_url('servers'));
        }
    }
        
}