<?php
defined('BASEPATH') OR exit('No direct script access allowed');
class Script extends CI_Controller {
        var $userdata=null;
        var $csrf=null; 
        function __construct()
        {
           parent::__construct();    
           if(!$this->Model_lib->Is_login()){
               redirect(base_url().'login');
           }                  
           $this->load->model('Model_login');
           $this->load->model('Model_script');
           $this->userdata=$this->Model_login->Get_loggedin_user();
           $this->csrf = array(
                      'name' => $this->security->get_csrf_token_name(),
                      'hash' => $this->security->get_csrf_hash()
              );
        }
                
      public function index()
    	{      
            $userdata=$this->userdata; 
            $this->load->view('script/view', compact('userdata')); 
    	}

      public function add()
      {
        $userdata=$this->userdata;
        $data=array("csrf"=>$this->csrf);
        $this->load->view('script/add', compact('data','userdata'));
      }

      public function save(){
                $this->load->library('form_validation');                
                $this->form_validation->set_rules(
                        'script_id', 'Script ID',
                        'required|min_length[2]|max_length[20]|is_unique[vicidial_inbound_dids.did_pattern]|regex_match[/^[_a-zA-z0-9]+$/]',
                        array(
                                'required'      => 'You have not provided %s.',
                                'is_unique'     => 'This %s already exists.',
                                'regex_match'   => 'Special characters not allowed for %s.'
                        )
                );
                $this->form_validation->set_rules(
                        'script_name', 'Script Name',
                        'required|min_length[2]|max_length[50]',
                        array(
                                'required'      => 'You have not provided %s.'
                        )
                );
                if ($this->form_validation->run() == FALSE){            
                  $errors = $this->form_validation->error_array();
                  $data=array("status"=>false,"csrf"=>$this->csrf,"errors"=>$errors);
                  exit(json_encode($data));
                }else{
                    $result=$this->Model_script->insert($this->input->post());
                    if($result){
                        $data=array("status"=>true,"csrf"=>$this->csrf,"message"=>$this->Model_lib->_QXZ("Script successfully created."));
                       exit(json_encode($data));
                    }else{
                       $errors=array("error"=>$this->Model_lib->_QXZ("unable to created Script."));
                       $data=array("status"=>false,"csrf"=>$this->csrf,"errors"=>$errors);
                       exit(json_encode($data));
                    }
                }
      }

      public function edit($id)
      { 

        $id = $this->Model_lib->DecryptionId($id);
        $queue_data = $this->Model_script->get($id);
        $data= array_merge($queue_data,array("csrf"=>$this->csrf));
        $this->load->view('script/edit', compact('data'));

      }

      public function modify()
      {
                $this->load->library('form_validation');
                $script_id=$this->Model_lib->CheckSCRIPTID($this->input->post('script_id'),$this->csrf);
                $_POST['script_id']=$script_id;  
                $this->form_validation->set_rules(
                        'script_id', 'Script ID',
                        'required|min_length[2]|max_length[20]|regex_match[/^[_a-zA-z0-9]+$/]',
                        array(
                                'required'      => 'You have not provided %s.',
                                'regex_match'   => 'Special characters not allowed for %s.'
                        )
                );
                $this->form_validation->set_rules(
                        'script_name', 'Script Name',
                        'required|min_length[2]|max_length[50]',
                        array(
                                'required'      => 'You have not provided %s.'
                        )
                );
                if ($this->form_validation->run() == FALSE){            
                  $errors = $this->form_validation->error_array();
                  $data=array("status"=>false,"csrf"=>$this->csrf,"errors"=>$errors);
                  exit(json_encode($data));
                }else{
                    $result=$this->Model_script->update($this->input->post(),$script_id);
                    if($result){
                        $data=array("status"=>true,"csrf"=>$this->csrf,"message"=>$this->Model_lib->_QXZ("Script successfully updated."));
                       exit(json_encode($data));
                    }else{
                       $errors=array("error"=>$this->Model_lib->_QXZ("unable to update script."));
                       $data=array("status"=>false,"csrf"=>$this->csrf,"errors"=>$errors);
                       exit(json_encode($data));
                    }
                }
      }

      public function copy($script_id="")
      {
        $id = $this->Model_lib->DecryptionId($script_id);
        $queue_data = $this->Model_script->get($id);
        $data= array_merge($queue_data,array("csrf"=>$this->csrf));
        $this->load->view('script/copy', compact('data'));
      }

      public function copynow(){
                $this->load->library('form_validation');
                $this->form_validation->set_rules(
                        'script_id', 'Script ID',
                        'required|min_length[2]|max_length[20]|is_unique[vicidial_inbound_dids.did_pattern]|regex_match[/^[_a-zA-z0-9]+$/]',
                        array(
                                'required'      => 'You have not provided %s.',
                                'is_unique'     => 'This %s already exists.',
                                'regex_match'   => 'Special characters not allowed for %s.'
                        )
                );
                $this->form_validation->set_rules(
                        'script_name', 'Script Name',
                        'required|min_length[2]|max_length[50]',
                        array(
                                'required'      => 'You have not provided %s.'
                        )
                );
                $source_did=$this->Model_lib->CheckSCRIPTID($this->input->post('script_id'),$this->csrf);
                $_POST['source_did']=$source_did; 
                if ($this->form_validation->run() == FALSE){            
                  $errors = $this->form_validation->error_array();
                  $data=array("status"=>false,"csrf"=>$this->csrf,"errors"=>$errors);
                  exit(json_encode($data));
                }else{
                    $result=$this->Model_script->copy_queue($this->input->post('did_pattern'),$this->input->post('did_description'),$this->input->post('source_did'));
                    if($result){
                        $data=array("status"=>true,"csrf"=>$this->csrf,"message"=>$this->Model_lib->_QXZ("Number successfully copied."));
                       exit(json_encode($data));
                    }else{
                       $errors=array("error"=>$this->Model_lib->_QXZ("unable to copy Number."));
                       $data=array("status"=>false,"csrf"=>$this->csrf,"errors"=>$errors);
                       exit(json_encode($data));
                    }
                }
      }

      public function delete($script_id)
      {
            $id=$this->Model_lib->DecryptionId($script_id);            
            $result=$this->Model_script->remove($id);  
            if($result){
                $this->session->set_flashdata('success','Script successfully deleted.');             
                redirect(base_url('campaigns/scripts'));
            }else{
                $this->session->set_flashdata('error','unable to delete Script.');
                redirect(base_url('campaigns/scripts'));
            }

      }
        
}