<?php
defined('BASEPATH') OR exit('No direct script access allowed');
class Reports extends CI_Controller {
    var $userdata = null;
    var $csrf=null;
    function __construct() 
    {
        parent::__construct();
        if (!$this->Model_lib->Is_login()) {
            redirect(base_url() . 'login');
        }
        $this->Model_lib->Is_lock();
        $this->load->model('Model_login');
        $this->load->model('Model_reports');        
        $this->userdata=$this->Model_login->Get_loggedin_user();
        $this->csrf = array(
                    'name' => $this->security->get_csrf_token_name(),
                    'hash' => $this->security->get_csrf_hash()
            );
    }


    public function search_lead()
    {
        $userdata=$this->userdata;        
        $data=array("csrf"=>$this->csrf);
        $this->load->view('reports/search_lead', compact('data','userdata'));
    }

    public function modify_lead()
    {
        $userdata=$this->userdata;        
        $data=array("csrf"=>$this->csrf);
        $this->load->view('reports/modify_lead', compact('data','userdata'));
    }

    public function inbound()
    {
        $userdata=$this->userdata;        
        $data=array("csrf"=>$this->csrf);
        $this->load->view('reports/inbound', compact('data','userdata'));
    }

    public function inbound_did()
    {
        $userdata=$this->userdata;        
        $data=array("csrf"=>$this->csrf);
        $this->load->view('reports/inbound_did', compact('data','userdata'));
    }

    public function outbound()
    {
        $userdata=$this->userdata;        
        $data=array("csrf"=>$this->csrf);
        $this->load->view('reports/outbound', compact('data','userdata'));
    }

    public function fronter_closer()
    {
        $userdata=$this->userdata;        
        $data=array("csrf"=>$this->csrf);
        $this->load->view('reports/fronter_closer', compact('data','userdata'));
    }

    public function campaign_status_list()
    {
        $userdata=$this->userdata;        
        $data=array("csrf"=>$this->csrf);
        $this->load->view('reports/campaign_status_list', compact('data','userdata'));
    }

    public function agent_time_detail()
    {
        $userdata=$this->userdata;        
        $data=array("csrf"=>$this->csrf);
        $this->load->view('reports/agent_time_detail', compact('data','userdata'));
        
    }

    public function agent_status_detail()
    {
        $userdata=$this->userdata;        
        $data=array("csrf"=>$this->csrf);
        $this->load->view('reports/agent_status_detail', compact('data','userdata'));
        
    }

    public function agent_performance_detail()
    {
        $userdata=$this->userdata;        
        $data=array("csrf"=>$this->csrf);
        $this->load->view('reports/agent_performance_detail', compact('data','userdata'));
    }

    public function team_performance_detail()
    {
        $userdata=$this->userdata;        
        $data=array("csrf"=>$this->csrf);
        $this->load->view('reports/team_performance_detail', compact('data','userdata'));
    }


    public function call_export()
    {
        $userdata=$this->userdata;        
        $data=array("csrf"=>$this->csrf);
        $this->load->view('reports/call_export', compact('data','userdata'));
    }
    
    public function lead_export()
    {
        $userdata=$this->userdata;        
        $data=array("csrf"=>$this->csrf);
        $this->load->view('reports/lead_export', compact('data','userdata'));
    }

    public function realtime()
    {
        $userdata=$this->userdata;        
        $data=array("csrf"=>$this->csrf);
        $this->load->view('reports/realtime', compact('data','userdata'));
    }

    public function realtime_sync()
    {
        if ($this->input->server('REQUEST_METHOD') == 'GET'){
           redirect('reports/realtime');
        }
        else if ($this->input->server('REQUEST_METHOD') == 'POST'){
           $userdata=$this->userdata;        
            $data=array("csrf"=>$this->csrf);
            $this->load->view('reports/realtime_sync', compact('data','userdata'));
        }        
    }
    
    public function dashboard(){
        if ($this->input->server('REQUEST_METHOD') == 'GET'){
           //redirect('reports/dashboard');
            $userdata=$this->userdata;        
            $data=array("csrf"=>$this->csrf);
            $this->load->view('reports/dashboard', compact('data','userdata'));
        }
        else if ($this->input->server('REQUEST_METHOD') == 'POST'){
            $userdata=$this->userdata;        
            $data=array("csrf"=>$this->csrf);
            $this->load->view('reports/dashboard', compact('data','userdata'));
        } 
    }

    public function call_connectivity(){
        $userdata=$this->userdata;
        $csrf = array(
                    'name' => $this->security->get_csrf_token_name(),
                    'hash' => $this->security->get_csrf_hash()
            );
        $data=array("csrf"=>$csrf);
        $this->load->view('reports/calls_connectivites', compact('data','userdata'));
    }

    public function calls_connectivites_ajax()
    {
        $sdate=$this->input->post('start_date');
        $edate=$this->input->post('end_date');
        $campaign_id=$this->input->post('campaign_id');
        $this->Model_reports->get_calls_activities($campaign_id, $sdate, $edate);
         //echo json_encode($data);
    }
    
    
    public function index() 
    {
        redirect(base_url('reports/call_log'));
    }    
    
    public function call_log(){
        $userdata=$this->userdata;
    	$csrf = array(
                    'name' => $this->security->get_csrf_token_name(),
                    'hash' => $this->security->get_csrf_hash()
            );
    	$data=array("csrf"=>$csrf);
    	$this->load->view('reports/call_log', compact('data','userdata'));
    }
    
    public function call_log_ajax()
    {
        // POST data
        $postData = $this->input->get();
        $data = $this->Model_reports->getCall_logs($postData);
        echo json_encode($data);
    }


    public function carrier_log(){
        
    }

    public function change_log()
    {
        $userdata=$this->userdata;
        $csrf = array(
                    'name' => $this->security->get_csrf_token_name(),
                    'hash' => $this->security->get_csrf_hash()
            );
        $data=array("csrf"=>$csrf);
        $this->load->view('reports/change_log', compact('data','userdata'));
    }

    public function download(){
        // get data
        $key = $this->uri->segment(3);
	    if($key != null){
	        list($campaign_id, $list_id,$start_date,$end_date,$status,$archive,$phone_number) = explode("--", $key);
	    }
        $postData = array(
        'campaign_id'  => $campaign_id,
        'list_id'      => $list_id,
        'start_date'   => $start_date,
        'end_date'     => $end_date,
        'status'       => $status,
        'archive'      => $archive,
        'phone_number' => $phone_number
        );
        $myData = $this->Model_reports->getReportData($postData);
 
        // file name
        $filename = 'Reportdata_'.date('Ymd').'.csv';
        header("Content-Description: File Transfer");
        header("Content-Disposition: attachment; filename=$filename");
        header("Content-Type: application/csv; ");
 
        // file creation
        $file = fopen('php://output', 'w');
 
        $header = array("Call Date","Campaign","List ID","Lead ID","Phone Number","Status");
        fputcsv($file, $header);

        if(!empty($myData)) {
            foreach ($myData as $line){
                fputcsv($file,array($line['call_date'],$line['campaign_id'],$line['list_id'],$line['lead_id'],$line['phone_number'],$line['status']));
            }
        } else {
            fputcsv($file,array("No Call Log Report Data In Table"));
        }
 
        fclose($file);
        exit;
    }
}