<?php
defined('BASEPATH') OR exit('No direct script access allowed');
class Remote extends CI_Controller {
        var $userdata=null;
        var $csrf=null; 
        function __construct()
        {
           parent::__construct();    
           if(!$this->Model_lib->Is_login()){
               redirect(base_url().'login');
           }                  
           $this->load->model('Model_login');
           $this->load->model('Model_remote');
           $this->userdata=$this->Model_login->Get_loggedin_user();
           
        }
                
      public function index()
    	{      
            $userdata=$this->userdata; 
            $this->load->view('remote/view', compact('userdata')); 
    	}


      public function create(){
          redirect('inbound/remote_manage#add');
      }

      public function add()
      {
        $userdata=$this->userdata;
        $csrf = array(
                      'name' => $this->security->get_csrf_token_name(),
                      'hash' => $this->security->get_csrf_hash()
              );            
        $data=array("csrf"=>$csrf);
        $this->load->view('remote/add', compact('data','userdata'));
      }

      public function save(){
                $this->load->library('form_validation');
                $csrf = array(
                        'name' => $this->security->get_csrf_token_name(),
                        'hash' => $this->security->get_csrf_hash()
                );
                

                $this->form_validation->set_rules(
                        'user_start', 'User ID Start',
                        'required|min_length[2]|max_length[9]|is_unique[vicidial_remote_agents.user_start]|regex_match[/^[0-9]+$/]',
                        array(
                                'required'      => 'You have not provided %s.',
                                'is_unique'     => 'This %s already exists.',
                                'regex_match'   => 'only number allowed for %s.'
                        )
                );

                $this->form_validation->set_rules(
                        'conf_exten', 'External Extension',
                        'required|min_length[2]|max_length[20]',
                        array(
                                'required'      => 'You have not provided %s.'
                        )
                );


                $closer_campaigns="";                
                $closercampaigns=$this->input->post('closer_campaigns');
                for($i=0;$i<sizeof($closercampaigns);$i++){
                    $closer_campaigns.=" ".trim($closercampaigns[$i]);
                }
                if($closer_campaigns!=""){
                    $closer_campaigns.=" -";
                }
                $_POST['closer_campaigns']=$closer_campaigns;



                if ($this->form_validation->run() == FALSE){            
                  $errors = $this->form_validation->error_array();
                  $data=array("status"=>false,"csrf"=>$csrf,"errors"=>$errors);
                  exit(json_encode($data));
                }else{
                    $result=$this->Model_remote->insert($this->input->post());
                    if($result){
                        $data=array("status"=>true,"csrf"=>$csrf,"message"=>$this->Model_lib->_QXZ("Remoet Agent successfully created."));
                       exit(json_encode($data));
                    }else{
                       $errors=array("error"=>$this->Model_lib->_QXZ("unable to created Remote agent."));
                       $data=array("status"=>false,"csrf"=>$csrf,"errors"=>$errors);
                       exit(json_encode($data));
                    }
                }
      }

      public function edit($id)
      { 

        $id = $this->Model_lib->DecryptionId($id);
        $queue_data = $this->Model_remote->get($id);
        $csrf = array(
                    'name' => $this->security->get_csrf_token_name(),
                    'hash' => $this->security->get_csrf_hash()
            );
        $data= array_merge($queue_data,array("csrf"=>$csrf));
        $this->load->view('remote/edit', compact('data'));

      }

      public function modify()
      {
                $this->load->library('form_validation');
                $csrf = array(
                        'name' => $this->security->get_csrf_token_name(),
                        'hash' => $this->security->get_csrf_hash()
                );
                $remote_agent_id=$this->Model_lib->CheckRemoteID($this->input->post('remote_agent_id'),$csrf);
                $_POST['remote_agent_id']=$remote_agent_id;  
                $this->form_validation->set_rules(
                        'conf_exten', 'External Extension',
                        'required|min_length[2]|max_length[20]',
                        array(
                                'required'      => 'You have not provided %s.'
                        )
                );


                $closer_campaigns="";                
                $closercampaigns=$this->input->post('closer_campaigns');
                for($i=0;$i<sizeof($closercampaigns);$i++){
                    $closer_campaigns.=" ".trim($closercampaigns[$i]);
                }
                if($closer_campaigns!=""){
                    $closer_campaigns.=" -";
                }
                $_POST['closer_campaigns']=$closer_campaigns;
                
                if ($this->form_validation->run() == FALSE){            
                  $errors = $this->form_validation->error_array();
                  $data=array("status"=>false,"csrf"=>$csrf,"errors"=>$errors);
                  exit(json_encode($data));
                }else{
                    $result=$this->Model_remote->update($this->input->post(),$remote_agent_id);
                    if($result){
                        $data=array("status"=>true,"csrf"=>$csrf,"message"=>$this->Model_lib->_QXZ("Remoate Agent successfully updated."));
                       exit(json_encode($data));
                    }else{
                       $errors=array("error"=>$this->Model_lib->_QXZ("unable to update Remoate Agent."));
                       $data=array("status"=>false,"csrf"=>$csrf,"errors"=>$errors);
                       exit(json_encode($data));
                    }
                }
      }     

      
      public function delete($ingroup_id)
      {
            $id=$this->Model_lib->DecryptionId($ingroup_id);            
            $result=$this->Model_remote->remove($id);  
            if($result){
                $this->session->set_flashdata('success','Remote Agent successfully deleted.');             
                redirect(base_url('inbound/remote_manage'));
            }else{
                $this->session->set_flashdata('error','unable to delete Remote Agent.');
                redirect(base_url('inbound/remote_manage'));
            }
      }
        
}