<?php
defined('BASEPATH') OR exit('No direct script access allowed');
class Queue extends CI_Controller {
        var $userdata=null;
        var $csrf=null; 
        function __construct()
        {
           parent::__construct();    
           if(!$this->Model_lib->Is_login()){
               redirect(base_url().'login');
           }                  
           $this->load->model('Model_login');
           $this->load->model('Model_queue');
           $this->userdata=$this->Model_login->Get_loggedin_user();
           
        }


      public function create()
      {
        redirect('inbound/groups_manage#add');
      }  
                
      public function index()
    	{      
            $userdata=$this->userdata; 
            $this->load->view('queue/view', compact('userdata')); 
    	}

      public function add()
      {
        $userdata=$this->userdata;
        $csrf = array(
                      'name' => $this->security->get_csrf_token_name(),
                      'hash' => $this->security->get_csrf_hash()
              );            
        $data=array("csrf"=>$csrf);
        $this->load->view('queue/add', compact('data','userdata'));
      }

      public function save(){
                $this->load->library('form_validation');
                $csrf = array(
                        'name' => $this->security->get_csrf_token_name(),
                        'hash' => $this->security->get_csrf_hash()
                );
                $this->form_validation->set_rules(
                        'group_id', 'Group ID',
                        'required|min_length[2]|max_length[20]|is_unique[vicidial_inbound_groups.group_id]|regex_match[/^[_a-zA-z0-9]+$/]',
                        array(
                                'required'      => 'You have not provided %s.',
                                'is_unique'     => 'This %s already exists.',
                                'regex_match'   => 'Special characters not allowed for %s.'
                        )
                );
                $this->form_validation->set_rules(
                        'group_name', 'Group Name',
                        'required|min_length[2]|max_length[30]',
                        array(
                                'required'      => 'You have not provided %s.'
                        )
                );
                if ($this->form_validation->run() == FALSE){            
                  $errors = $this->form_validation->error_array();
                  $data=array("status"=>false,"csrf"=>$csrf,"errors"=>$errors);
                  exit(json_encode($data));
                }else{
                    $result=$this->Model_queue->insert($this->input->post());
                    if($result){
                        $data=array("status"=>true,"csrf"=>$csrf,"message"=>$this->Model_lib->_QXZ("Group successfully created."));
                       exit(json_encode($data));
                    }else{
                       $errors=array("error"=>$this->Model_lib->_QXZ("unable to created Group."));
                       $data=array("status"=>false,"csrf"=>$csrf,"errors"=>$errors);
                       exit(json_encode($data));
                    }
                }
      }

      public function edit($id)
      { 

        $id = $this->Model_lib->DecryptionId($id);
        $queue_data = $this->Model_queue->get($id);
        $csrf = array(
                    'name' => $this->security->get_csrf_token_name(),
                    'hash' => $this->security->get_csrf_hash()
            );
        $data= array_merge($queue_data,array("csrf"=>$csrf));
        $this->load->view('queue/edit', compact('data'));

      }

      public function modify()
      {
                $this->load->library('form_validation');
                $csrf = array(
                        'name' => $this->security->get_csrf_token_name(),
                        'hash' => $this->security->get_csrf_hash()
                );
                $group_id=$this->Model_lib->CheckQueueID($this->input->post('group_id'),$csrf);
                $_POST['group_id']=$group_id;  
                $this->form_validation->set_rules(
                        'group_id', 'Group ID',
                        'required|min_length[2]|max_length[20]|regex_match[/^[_a-zA-z0-9]+$/]',
                        array(
                                'required'      => 'You have not provided %s.',
                                'regex_match'   => 'Special characters not allowed for %s.'
                        )
                );
                $this->form_validation->set_rules(
                        'group_name', 'Group Name',
                        'required|min_length[2]|max_length[30]',
                        array(
                                'required'      => 'You have not provided %s.'
                        )
                );
                if ($this->form_validation->run() == FALSE){            
                  $errors = $this->form_validation->error_array();
                  $data=array("status"=>false,"csrf"=>$csrf,"errors"=>$errors);
                  exit(json_encode($data));
                }else{
                    $result=$this->Model_queue->update($this->input->post(),$group_id);
                    if($result){
                        $data=array("status"=>true,"csrf"=>$csrf,"message"=>$this->Model_lib->_QXZ("Group successfully updated."));
                       exit(json_encode($data));
                    }else{
                       $errors=array("error"=>$this->Model_lib->_QXZ("unable to update Group."));
                       $data=array("status"=>false,"csrf"=>$csrf,"errors"=>$errors);
                       exit(json_encode($data));
                    }
                }
      }

      public function copy($ingroup_id="")
      {
        $id = $this->Model_lib->DecryptionId($ingroup_id);
        $queue_data = $this->Model_queue->get($id);
        $csrf = array(
                    'name' => $this->security->get_csrf_token_name(),
                    'hash' => $this->security->get_csrf_hash()
            );
        $data= array_merge($queue_data,array("csrf"=>$csrf));
        $this->load->view('queue/copy', compact('data'));
      }

      public function copynow(){
                $this->load->library('form_validation');
                $csrf = array(
                        'name' => $this->security->get_csrf_token_name(),
                        'hash' => $this->security->get_csrf_hash()
                );                 
                $this->form_validation->set_rules(
                        'group_id', 'Group ID',
                        'required|min_length[2]|max_length[20]|is_unique[vicidial_inbound_groups.group_id]|regex_match[/^[_a-zA-z0-9]+$/]',
                        array(
                                'required'      => 'You have not provided %s.',
                                'is_unique'     => 'This %s already exists.',
                                'regex_match'   => 'Special characters not allowed for %s.'
                        )
                );
                $this->form_validation->set_rules(
                        'group_name', 'Group Name',
                        'required|min_length[2]|max_length[30]',
                        array(
                                'required'      => 'You have not provided %s.'
                        )
                );
                $source_group_id=$this->Model_lib->CheckQueueID($this->input->post('source_group_id'),$csrf);
                $_POST['source_group_id']=$source_group_id; 
                if ($this->form_validation->run() == FALSE){            
                  $errors = $this->form_validation->error_array();
                  $data=array("status"=>false,"csrf"=>$csrf,"errors"=>$errors);
                  exit(json_encode($data));
                }else{
                    $result=$this->Model_queue->copy_queue($this->input->post('group_id'),$this->input->post('group_name'),$this->input->post('source_group_id'));
                    if($result){
                        $data=array("status"=>true,"csrf"=>$csrf,"message"=>$this->Model_lib->_QXZ("Group successfully copied."));
                       exit(json_encode($data));
                    }else{
                       $errors=array("error"=>$this->Model_lib->_QXZ("unable to copy Group."));
                       $data=array("status"=>false,"csrf"=>$csrf,"errors"=>$errors);
                       exit(json_encode($data));
                    }
                }
      }

      public function delete($ingroup_id)
      {
            $id=$this->Model_lib->DecryptionId($ingroup_id);            
            $result=$this->Model_queue->remove($id);  
            if($result){
                $this->session->set_flashdata('success','Group successfully deleted.');             
                redirect(base_url('inbound/groups_manage'));
            }else{
                $this->session->set_flashdata('error','unable to delete group.');
                redirect(base_url('inbound/groups_manage'));
            }

      }
        
}