<?php
defined('BASEPATH') OR exit('No direct script access allowed');
class Phones extends CI_Controller {
         var $userdata=null;
         var $csrf=null;
        function __construct()
        {
           parent::__construct();    
           if(!$this->Model_lib->Is_login()){
               redirect(base_url().'login');
           }                    
           $this->load->model('Model_login');
           $this->load->model('Model_phones');
           $this->userdata=$this->Model_login->Get_loggedin_user();
           $this->csrf = array(
                        'name' => $this->security->get_csrf_token_name(),
                        'hash' => $this->security->get_csrf_hash()
          );
        }
        
        public function index()
        {                         
            $userdata=$this->userdata;               
            $this->load->view('phones/view', compact('userdata'));                       
        }

        public function add(){            
            $data=array("csrf"=>$this->csrf);
            $userdata=$this->userdata;  
            $this->load->view('phones/add', compact('data','userdata'));
        }

        public function edit($id){
            $id=$this->Model_lib->DecryptionId($id);                
            $phone_info=$this->Model_phones->getPhone($id);
            if(sizeof($phone_info)==0){
                $this->session->set_flashdata('error','invalid account id');
                redirect(base_url('settings/phones'));
            }
            $data= array_merge($phone_info,array("csrf"=>$this->csrf)); 
            $userdata=$this->userdata;                 
            $this->load->view('phones/edit', compact('data','userdata'));
        }


        public function update(){
              $_POST['extension']=$this->Model_lib->CheckPhoneExtension($this->input->post('extension'),$this->csrf);
              $this->load->library('form_validation');
              $this->form_validation->set_rules(
                      'extension',$this->Model_lib->_QXZ('Phone Login'),
                      'required|min_length[2]|max_length[10]|regex_match[/^[0-9]+$/]',
                      array(
                          'required'      => $this->Model_lib->_QXZ("You have not provided").' %s.',
                          'is_unique'     => $this->Model_lib->_QXZ("This %s already exists."),
                          'regex_match'   => $this->Model_lib->_QXZ("Special characters allowed for").' %s.'
                      )
              );

              $this->form_validation->set_rules('pass', 'Phone Pass', 'required|min_length[2]|max_length[50]|regex_match[/^[_a-zA-z0-9]+$/]',
                       array(
                              'required'      => $this->Model_lib->_QXZ("You have not provided").' %s.',
                              'regex_match'   => $this->Model_lib->_QXZ("Special characters allowed for").' %s.'
                              )
                      );

              $this->form_validation->set_rules('conf_secret', 'Registration Secret', 'required|min_length[4]|max_length[100]|regex_match[/^[_a-zA-z0-9]+$/]',
                       array(
                              'required'      => $this->Model_lib->_QXZ("You have not provided").' %s.',
                              'regex_match'   => $this->Model_lib->_QXZ("Special characters allowed for").' %s.'
                              )
                      );

              if ($this->form_validation->run() == FALSE){
                  $errors = $this->form_validation->error_array();
                  $data=array("status"=>false,"csrf"=>$this->csrf,"errors"=>$errors);
                  exit(json_encode($data));
              }else{
                     $result=$this->Model_phones->UpdatePhone($this->input->post(),$this->input->post('extension'));
                     if($result){
                        $data=array("status"=>true,"csrf"=>$this->csrf,"message"=>$this->Model_lib->_QXZ("Phone successfully updated."),"id"=>$this->Model_lib->EncryptionId($this->input->post('extension')));
                       exit(json_encode($data));
                    }else{
                       $errors=array("error"=>$this->Model_lib->_QXZ("unable to update phone."));
                       $data=array("status"=>false,"csrf"=>$this->csrf,"errors"=>$errors);
                       exit(json_encode($data));
                    }
              }
        }

        public function save(){

            $this->load->library('form_validation');
            $_POST['login']=$this->input->post('extension'); 

            $this->form_validation->set_rules(
                    'extension',$this->Model_lib->_QXZ('Phone Login'),
                    'required|min_length[2]|max_length[10]|is_unique[phones.extension]|regex_match[/^[0-9]+$/]',
                    array(
                        'required'      => $this->Model_lib->_QXZ("You have not provided").' %s.',
                        'is_unique'     => $this->Model_lib->_QXZ("This %s already exists."),
                        'regex_match'   => $this->Model_lib->_QXZ("Special characters allowed for").' %s.'
                    )
            );

            $this->form_validation->set_rules(
                    'login',$this->Model_lib->_QXZ('Phone Login'),
                    'required|min_length[2]|max_length[10]|is_unique[phones.login]|regex_match[/^[0-9]+$/]',
                    array(
                        'required'      => $this->Model_lib->_QXZ("You have not provided").' %s.',
                        'is_unique'     => $this->Model_lib->_QXZ("This %s already exists."),
                        'regex_match'   => $this->Model_lib->_QXZ("Special characters allowed for").' %s.'
                    )
            );

           $this->form_validation->set_rules('pass', 'Phone Pass', 'required|min_length[2]|max_length[50]|regex_match[/^[_a-zA-z0-9]+$/]',
                       array(
                              'required'      => $this->Model_lib->_QXZ("You have not provided").' %s.',
                              'regex_match'   => $this->Model_lib->_QXZ("Special characters allowed for").' %s.'
                              )
                      );

           $this->form_validation->set_rules('conf_secret', 'Registration Secret', 'required|min_length[4]|max_length[100]|regex_match[/^[_a-zA-z0-9]+$/]',
                       array(
                              'required'      => $this->Model_lib->_QXZ("You have not provided").' %s.',
                              'regex_match'   => $this->Model_lib->_QXZ("Special characters allowed for").' %s.'
                              )
                      );

              if ($this->form_validation->run() == FALSE){
                  $errors = $this->form_validation->error_array();
                  $data=array("status"=>false,"csrf"=>$this->csrf,"errors"=>$errors);
                  exit(json_encode($data));
              }else{
                    $result=$this->Model_phones->AddPhone($this->input->post());
                     if($result){
                        $data=array("status"=>true,"csrf"=>$this->csrf,"message"=>$this->Model_lib->_QXZ("Phone successfully created."),"id"=>$this->Model_lib->EncryptionId($this->input->post('extension')));
                       exit(json_encode($data));
                    }else{
                       $errors=array("error"=>$this->Model_lib->_QXZ("unable to created phone."));
                       $data=array("status"=>false,"csrf"=>$this->csrf,"errors"=>$errors);
                       exit(json_encode($data));
                    }
              }

        }


        public function delete($id="")
        {                       
            $id=$this->Model_lib->DecryptionId($id);            
            $result=$this->Model_phones->DeletePhone($id);  
            if($result){
                $this->session->set_flashdata('success','Phone successfully deleted.');
                $this->Model_lib->admin_change_log("Phone","Delete Phone","");   
                redirect(base_url('settings/phones'));
            }else{
                $this->session->set_flashdata('error','unable to delete phone.');
                redirect(base_url('settings/phones'));
            }            
        }
}