<?php
defined('BASEPATH') OR exit('No direct script access allowed');
class Numbers extends CI_Controller {
        var $userdata=null;
        var $csrf=null; 
        function __construct()
        {
           parent::__construct();    
           if(!$this->Model_lib->Is_login()){
               redirect(base_url().'login');
           }                  
           $this->load->model('Model_login');
           $this->load->model('Model_numbers');
           $this->userdata=$this->Model_login->Get_loggedin_user();
           $this->csrf = array(
                      'name' => $this->security->get_csrf_token_name(),
                      'hash' => $this->security->get_csrf_hash()
              );
        }


      public function create()
      {
        redirect('inbound/did_manage#add');
      }  
                
      public function index()
    	{      
            $userdata=$this->userdata; 
            $this->load->view('numbers/view', compact('userdata')); 
    	}

      public function add()
      {
        $userdata=$this->userdata;
        $data=array("csrf"=>$this->csrf);
        $this->load->view('numbers/add', compact('data','userdata'));
      }

      public function save(){
                $this->load->library('form_validation');                
                $this->form_validation->set_rules(
                        'did_pattern', 'Inbound Number',
                        'required|min_length[2]|max_length[50]|is_unique[vicidial_inbound_dids.did_pattern]|regex_match[/^[_a-zA-z0-9]+$/]',
                        array(
                                'required'      => 'You have not provided %s.',
                                'is_unique'     => 'This %s already exists.',
                                'regex_match'   => 'Special characters not allowed for %s.'
                        )
                );
                $this->form_validation->set_rules(
                        'did_description', 'Number Description',
                        'required|min_length[2]|max_length[50]',
                        array(
                                'required'      => 'You have not provided %s.'
                        )
                );
                if ($this->form_validation->run() == FALSE){            
                  $errors = $this->form_validation->error_array();
                  $data=array("status"=>false,"csrf"=>$this->csrf,"errors"=>$errors);
                  exit(json_encode($data));
                }else{
                    $result=$this->Model_numbers->insert($this->input->post());
                    if($result){
                        $data=array("status"=>true,"csrf"=>$this->csrf,"message"=>$this->Model_lib->_QXZ("Number successfully created."));
                       exit(json_encode($data));
                    }else{
                       $errors=array("error"=>$this->Model_lib->_QXZ("unable to created Inbound Number."));
                       $data=array("status"=>false,"csrf"=>$this->csrf,"errors"=>$errors);
                       exit(json_encode($data));
                    }
                }
      }

      public function edit($id)
      { 

        $id = $this->Model_lib->DecryptionId($id);
        $queue_data = $this->Model_numbers->get($id);
        $data= array_merge($queue_data,array("csrf"=>$this->csrf));
        $this->load->view('numbers/edit', compact('data'));

      }

      public function modify()
      {
                $this->load->library('form_validation');
                $did_id=$this->Model_lib->CheckDIDID($this->input->post('did_id'),$this->csrf);
                $_POST['did_id']=$did_id;  
                $this->form_validation->set_rules(
                        'did_pattern', 'Number',
                        'required|min_length[2]|max_length[50]|regex_match[/^[_a-zA-z0-9]+$/]',
                        array(
                                'required'      => 'You have not provided %s.',
                                'regex_match'   => 'Special characters not allowed for %s.'
                        )
                );
                $this->form_validation->set_rules(
                        'did_description', 'Number Description',
                        'required|min_length[2]|max_length[50]',
                        array(
                                'required'      => 'You have not provided %s.'
                        )
                );
                if ($this->form_validation->run() == FALSE){            
                  $errors = $this->form_validation->error_array();
                  $data=array("status"=>false,"csrf"=>$this->csrf,"errors"=>$errors);
                  exit(json_encode($data));
                }else{
                    $result=$this->Model_numbers->update($this->input->post(),$did_id);
                    if($result){
                        $data=array("status"=>true,"csrf"=>$this->csrf,"message"=>$this->Model_lib->_QXZ("Inbound Number successfully updated."));
                       exit(json_encode($data));
                    }else{
                       $errors=array("error"=>$this->Model_lib->_QXZ("unable to update Numbers."));
                       $data=array("status"=>false,"csrf"=>$this->csrf,"errors"=>$errors);
                       exit(json_encode($data));
                    }
                }
      }

      public function copy($did_id="")
      {
        $id = $this->Model_lib->DecryptionId($did_id);
        $queue_data = $this->Model_numbers->get($id);
        $data= array_merge($queue_data,array("csrf"=>$this->csrf));
        $this->load->view('numbers/copy', compact('data'));
      }

      public function copynow(){
                $this->load->library('form_validation');
                $this->form_validation->set_rules(
                        'did_pattern', 'Number',
                        'required|min_length[2]|max_length[50]|is_unique[vicidial_inbound_dids.did_pattern]|regex_match[/^[_a-zA-z0-9]+$/]',
                        array(
                                'required'      => 'You have not provided %s.',
                                'is_unique'     => 'This %s already exists.',
                                'regex_match'   => 'Special characters not allowed for %s.'
                        )
                );
                $this->form_validation->set_rules(
                        'did_description', 'Number Description',
                        'required|min_length[2]|max_length[50]',
                        array(
                                'required'      => 'You have not provided %s.'
                        )
                );
                $source_did=$this->Model_lib->CheckDIDID($this->input->post('source_did'),$this->csrf);
                $_POST['source_did']=$source_did; 
                if ($this->form_validation->run() == FALSE){            
                  $errors = $this->form_validation->error_array();
                  $data=array("status"=>false,"csrf"=>$this->csrf,"errors"=>$errors);
                  exit(json_encode($data));
                }else{
                    $result=$this->Model_numbers->copy_queue($this->input->post('did_pattern'),$this->input->post('did_description'),$this->input->post('source_did'));
                    if($result){
                        $data=array("status"=>true,"csrf"=>$this->csrf,"message"=>$this->Model_lib->_QXZ("Number successfully copied."));
                       exit(json_encode($data));
                    }else{
                       $errors=array("error"=>$this->Model_lib->_QXZ("unable to copy Number."));
                       $data=array("status"=>false,"csrf"=>$this->csrf,"errors"=>$errors);
                       exit(json_encode($data));
                    }
                }
      }

      public function delete($did_id)
      {
            $id=$this->Model_lib->DecryptionId($did_id);            
            $result=$this->Model_numbers->remove($id);  
            if($result){
                $this->session->set_flashdata('success','Inbound number successfully deleted.');             
                redirect(base_url('inbound/did_manage'));
            }else{
                $this->session->set_flashdata('error','unable to delete inbound number.');
                redirect(base_url('inbound/did_manage'));
            }

      }
        
}