<?php
defined('BASEPATH') OR exit('No direct script access allowed');
class Lists extends CI_Controller {
        var $userdata = null;
        function __construct()
        {
           parent::__construct();    
           if(!$this->Model_lib->Is_login()){
               redirect(base_url().'login');
           }                    
           $this->load->model('Model_lists');
           $this->load->model('Model_login');
           $this->userdata=$this->Model_login->Get_loggedin_user();
        }
    

        public function search(){
            exit("search");
        }

    public function index() {
        $this->view();
    }
    
    public function view()
    {           
        $userdata = $this->userdata;
        $this->load->view('lists/view', compact('userdata'));
    }
    

    public function dialler_login()
    {
        $userdata = $this->userdata;
        $VD_login=$userdata['user'];
        $VD_pass=$userdata['pass'];
        $phone_login=$userdata['phone_login'];
        $phone_pass=$userdata['phone_pass'];
        $HTTP_HOST=gethostbyname($_SERVER['HTTP_HOST']);
        $iframe="http://$HTTP_HOST/agc/vicidial.php?VD_login=$VD_login&VD_campaign=7866&phone_login=$phone_login&phone_pass=$phone_pass&VD_pass=$VD_pass";
        exit($iframe);
    }
    
    public function add() {        
        $userdata=$this->userdata;            
	$csrf = array(
                'name' => $this->security->get_csrf_token_name(),
                'hash' => $this->security->get_csrf_hash()
        );
	$data=array("csrf"=>$csrf);
	$this->load->view('lists/add', compact('data','userdata'));
    }
    
    public function save()
    {
        $this->load->library('form_validation');
        $this->form_validation->set_rules(
                'list_id', 'List ID',
                'required|min_length[2]|max_length[19]|is_unique[vicidial_lists.list_id]|regex_match[/^[_a-zA-z0-9]+$/]',
                array(
                        'required'      => 'You have not provided %s.',
                        'is_unique'     => 'This %s already exists.',
                        'regex_match'   => 'Special characters not allowed for %s.'
                )
        );
        $this->form_validation->set_rules(
                'list_name', 'List Name',
                'required|min_length[2]|max_length[30]',
                array(
                        'required'      => 'You have not provided %s.'
                )
        );
        $this->form_validation->set_rules(
                'campaign_id', 'Campaign id',
                'required',
                array(
                        'required'      => 'You have not provided %s.'
                )
        );
        if ($this->form_validation->run() == FALSE){
            $this->Model_lib->Is_lock();
            $csrf = array(
                            'name' => $this->security->get_csrf_token_name(),
                            'hash' => $this->security->get_csrf_hash()
                    );
            $error = array(
                    'list_id' => form_error('list_id'),
                    'list_name' => form_error('list_name'),
                    'campaign_id' => form_error('campaign_id')
            );            
            $data=array("csrf"=>$csrf,"error"=>$error,"status"=>false,"msg"=>"Please enter required fields.");
            exit(json_encode($data));
        }else{
            $_POST['list_description']=$this->input->post('list_name');
            $data=$this->Model_lib->parse_array($this->input->post());
            $insert_id=$this->Model_lib->EncryptionId($data['list_id']);
            if($this->Model_lists->insert($data)){                     
                $result=array("status"=>true,"msg"=>"List successfully created","insert_id"=>$insert_id);
                $this->Model_lib->admin_change_log("LIST","Save List","");
            }else{            
                $result=array("status"=>false,"msg"=>"unable to created list.","insert_id"=>$insert_id);
            }
            exit(json_encode($result));
        }
    }
    
    public function edit($id)
    {
        $this->Model_lib->Is_lock(); 
        $id = $this->Model_lib->DecryptionId($id);
        $userdata= $this->userdata;
        $list_data = $this->Model_lists->get($id);
        $csrf = array(
                    'name' => $this->security->get_csrf_token_name(),
                    'hash' => $this->security->get_csrf_hash()
            );
        $data= array_merge($list_data,array("csrf"=>$csrf));
        $this->load->view('lists/edit', compact('data','userdata'));
    }

    public function fields($id){

        $this->Model_lib->Is_lock(); 
        $id = $this->Model_lib->DecryptionId($id);
        $userdata= $this->userdata;
        $list_data = $this->Model_lists->get($id);
        $csrf = array(
                    'name' => $this->security->get_csrf_token_name(),
                    'hash' => $this->security->get_csrf_hash()
            );
        $data= array_merge($list_data,array("csrf"=>$csrf));
        $this->load->view('lists/fields', compact('data','userdata'));        
    }
    
    public function update()
    {
        $this->load->library('form_validation');
        $this->form_validation->set_rules(
                'list_id', 'List ID',
                'required|min_length[2]|max_length[19]|regex_match[/^[_a-zA-z0-9]+$/]',
                array(
                        'required'      => 'You have not provided %s.',
                        'regex_match'   => 'Special characters not allowed for %s.'
                )
        );
        $this->form_validation->set_rules(
                'list_name', 'List Name',
                'required|min_length[2]|max_length[30]',
                array(
                        'required'      => 'You have not provided %s.'
                )
        );
        $this->form_validation->set_rules(
                'campaign_id', 'Campaign id',
                'required',
                array(
                        'required'      => 'You have not provided %s.'
                )
        );
        if ($this->form_validation->run() == FALSE){
            $this->Model_lib->Is_lock();
            $csrf = array(
                            'name' => $this->security->get_csrf_token_name(),
                            'hash' => $this->security->get_csrf_hash()
                    );
            $error = array(
                    'list_id' => form_error('list_id'),
                    'list_name' => form_error('list_name'),
                    'campaign_id' => form_error('campaign_id')
            );            
            $data=array("csrf"=>$csrf,"error"=>$error,"status"=>false,"msg"=>"Please enter required fields.");
            exit(json_encode($data));
        }else{
             $csrf = array(
                            'name' => $this->security->get_csrf_token_name(),
                            'hash' => $this->security->get_csrf_hash()
                    );
            $_POST['list_description']=$this->input->post('list_name');
            $data=$this->Model_lib->parse_array($this->input->post());
            $insert_id=$this->Model_lib->EncryptionId($data['list_id']);
            if($this->Model_lists->update($data['list_id'],$data)){                     
                $result=array("status"=>true,"msg"=>"List successfully update","insert_id"=>$insert_id);
                $this->Model_lib->admin_change_log("LIST","Update List","");
            }else{            
                $result=array("status"=>false,"msg"=>"unable to update list.","insert_id"=>$insert_id,"csrf"=>$csrf);
            }
            exit(json_encode($result));
        }
    }
    
    public function delete($id)
    {
        $this->Model_lib->Is_lock();            
        $id=$this->Model_lib->DecryptionId($id);
        $this->load->model('Model_lists');        
        $result=$this->Model_lists->remove($id);  
        if($result){
            $this->session->set_flashdata('success','list successfully deleted.');
            $this->Model_lib->admin_change_log("LIST","Delete List","");
            redirect(base_url('data'));
        }else{
            $this->session->set_flashdata('error','unable to delete list.');
            redirect(base_url('data'));
        }
    }

    public function clean($id)
    {
        $this->Model_lib->Is_lock();            
        $id=$this->Model_lib->DecryptionId($id);
        $this->load->model('Model_lists');        
        $result=$this->Model_lists->clean_list($id);  
        if($result){
            $this->session->set_flashdata('success','list successfully clean.');
            $this->Model_lib->admin_change_log("LIST","Clean List","");
            redirect(base_url('data'));
        }else{
            $this->session->set_flashdata('error','unable to clean list.');
            redirect(base_url('data'));
        }
    }
    
    public function download_list($list_id,$called_count="",$status="")
    {   
        $this->Model_lib->Is_lock();
        $id=$this->Model_lib->DecryptionId($list_id);
        $this->Model_lib->admin_change_log("LIST","Download List","");
        $this->Model_lists->exports_list($id,$called_count,$status);
    }    
    
    public function data($id="") {
        $list_id=$this->Model_lib->DecryptionId($id);    
        $userdata=$this->userdata;            
	$csrf = array(
                'name' => $this->security->get_csrf_token_name(),
                'hash' => $this->security->get_csrf_hash()
        );
	$data=array("csrf"=>$csrf,"list_id"=>$list_id);
	$this->load->view('lists/leads', compact('data','userdata'));
    }


    function reset($campaign_id,$list_id)
    {
        $list_id=$this->Model_lib->DecryptionId($list_id);
        $campaign_id=$this->Model_lib->DecryptionId($campaign_id);
        $result=$this->Model_lib->reset_list($campaign_id,$list_id);
        if($result['status']){
            $this->session->set_flashdata('success',$result['message']);            
            redirect(base_url('data'));
        }else{            
            $this->session->set_flashdata('error',$result['message']);
            redirect(base_url('data'));
        }
    }

    public function Statuses($id="")
    {
        $list_id=$this->Model_lib->DecryptionId($id);    
        $userdata=$this->userdata;            
        $csrf = array(
                'name' => $this->security->get_csrf_token_name(),
                'hash' => $this->security->get_csrf_hash()
        );
        $data=array("csrf"=>$csrf,"list_id"=>$list_id);
        $this->load->view('lists/hopper', compact('data','userdata'));
    }

    public function hopper($id="")
    {
        $list_id=$this->Model_lib->DecryptionId($id);    
        $userdata=$this->userdata;            
        $csrf = array(
                'name' => $this->security->get_csrf_token_name(),
                'hash' => $this->security->get_csrf_hash()
        );
        $data=array("csrf"=>$csrf,"list_id"=>$list_id);
        $this->load->view('lists/hopper', compact('data','userdata'));
    }

    public function get_leads(){
        $postData = $this->input->get();
        $recordhtml= $this->Model_lists->get_leads_by_list_id($postData);
        echo json_encode($recordhtml);
    }

    public function archive($id)
    {
        $this->Model_lib->Is_lock();            
        $id=$this->Model_lib->DecryptionId($id);
        $this->load->model('Model_lists');        
        $result=$this->Model_lists->archive_list($id);  
        if($result){
            $this->session->set_flashdata('success','list successfully archive.');
            $this->Model_lib->admin_change_log("LIST","Archive List","");
            redirect(base_url('data'));
        }else{
            $this->session->set_flashdata('error','unable to archive list.');
            redirect(base_url('data'));
        }
    }

    public function archive_restore($id)
    {
        $this->Model_lib->Is_lock();            
        $id=$this->Model_lib->DecryptionId($id);
        $this->load->model('Model_lists');        
        $result=$this->Model_lists->archive_restore_list($id);  
        if($result){
            $this->session->set_flashdata('success','list successfully restore.');
            $this->Model_lib->admin_change_log("LIST","Archive Restore List","");
            redirect(base_url('data'));
        }else{
            $this->session->set_flashdata('error','unable to archive restore list.');
            redirect(base_url('data'));
        }
    }


    public function loadModal(){
        $list_id=$this->input->get('list_id');
        $field_id=$this->input->get('field_id');


        $stmt="SELECT field_id,field_label,field_name,field_description,field_rank,field_help,field_type,field_options,field_size,field_max,field_default,field_cost,field_required,multi_position,name_position,field_order,field_encrypt,field_show_hide,field_duplicate from vicidial_lists_fields where list_id='$list_id' and field_id='$field_id' LIMIT 1;";
        $query = $this->db->query($stmt)->result_array();
        $field_label='';
        $field_name='';
        $field_type='';
        $field_size='5';
        $field_max='100';
        $field_options='';
        $field_default='';
        $field_rank=0;
        if(sizeof($query)>0)
        {
            $field_label=$query[0]['field_label'];
            $field_name=$query[0]['field_name'];
            $field_type=$query[0]['field_type'];
            $field_size=$query[0]['field_size'];
            $field_max=$query[0]['field_max'];
            $field_options=$query[0]['field_options'];
            $field_default=$query[0]['field_default'];
            $field_rank=$query[0]['field_rank'];
        }

        $csrf = array(
                'name' => $this->security->get_csrf_token_name(),
                'hash' => $this->security->get_csrf_hash()
        );

        echo "<div class=\"modal-header\">";
            echo "<button type=\"button\" class=\"close\" data-dismiss=\"modal\" aria-hidden=\"true\"></button>";
            if(strlen($field_id)>0){
                echo "<h4 class=\"modal-title\">".$this->Model_lib->_QXZ("Modify Custom Fields")."</h4>";
            }else{
                echo "<h4 class=\"modal-title\">".$this->Model_lib->_QXZ("Add Custom Fields")."</h4>";
            }

        echo "</div>";      
          echo "<form action=".base_url('lists/fields_action')." method=\"post\" id=\"frm_modal_custom_fields\">";
            echo "<div class=\"modal-body\">";
            echo "<div class=\"row\">";
                echo "<input type=\"hidden\" id=\"field_csrf_hash_option\"  name='".$csrf['name']."' value='".$csrf['hash']."' />";
                echo "<input type=\"hidden\" id=\"field_id\"  name='field_id' value='$field_id' />";
                echo "<input type=\"hidden\" id=\"list_id\"  name='list_id' value='$list_id' />";
                echo "<input type=\"hidden\" name=\"field_default\" id=\"field_default\" size=\"50\" maxlength=\"255\" value='$field_default' \>";
                echo "<input type=\"hidden\" name=\"field_rank\" id=\"field_rank\" size=\"50\" maxlength=\"255\" value='$field_rank' \>";

                echo "<div class=\"form-group col-md-12\">";
                     echo "<label>".$this->Model_lib->_QXZ("Field Label")."</label>";
                     echo "<input type=\"text\" class=\"form-control\" name=\"field_label\" size=\"20\" maxlength=\"50\" value='$field_label' />";
                echo "</div>";
                echo "<div class=\"form-group col-md-12\">";
                     echo "<label>".$this->Model_lib->_QXZ("Field Name")."</label>";
                     echo "<input type=\"text\" class=\"form-control\" name=\"field_name\" size=\"20\" maxlength=\"50\" value='$field_name' />";
                echo "</div>"; 

                echo "<div class=\"form-group col-md-12\">";
                     echo "<label>".$this->Model_lib->_QXZ("Field Type")."</label>";
                     echo "<select class=\"form-control\" id=\"field_type\" name=\"field_type\" onchange=\"OptionChange(this)\">";
                        echo "<option value=\"TEXT\">TEXT</option>";
                        echo "<option value=\"AREA\">AREA</option>";
                        echo "<option value=\"SELECT\">SELECT</option>";
                        echo "<option value=\"MULTI\">MULTI</option>";
                        echo "<option value=\"RADIO\">RADIO</option>";
                        echo "<option value=\"CHECKBOX\">CHECKBOX</option>";
                        echo "<option value=\"DATE\">DATE</option>";
                        echo "<option value=\"TIME\">TIME</option>";
                        // echo "<option value=\"DISPLAY\">DISPLAY</option>";
                        // echo "<option value=\"SCRIPT\">SCRIPT</option>";
                        // echo "<option value=\"HIDDEN\">HIDDEN</option>";
                        // echo "<option value=\"HIDEBLOB\">HIDEBLOB</option>";
                        // echo "<option value=\"SWITCH\">SWITCH</option>";
                        // echo "<option value=\"READONLY\">READONLY</option>";
                        if($field_type!=""){
                            echo "<option SELECTED value='$field_type'>$field_type</option>";
                        }
                    echo "</select>";
                echo "</div>";
                        if($field_type=="SELECT" || $field_type=="MULTI" || $field_type=="RADIO"  || $field_type=="CHECKBOX"){
                            echo "<div class=\"form-group col-md-12\" id=\"field_options_div\">";
                        }else{
                            echo "<div class=\"form-group col-md-12 hide\" id=\"field_options_div\">";
                        }

                        echo "<label>".$this->Model_lib->_QXZ("Field Options")."</label>";
                        echo "<a title='".$this->Model_lib->_QXZ("Add Options")."' style=\"margin-bottom:10px;\" class=\"btn btn-primary pull-right\" onclick=\"addOptions();\" href='javascript:void(0);'><i class=\"fa fa-plus\" aria-hidden=\"true\"></i></a>";
                        echo "<span id=\"tag_options\">";

                            $options_ln=explode("\n",$field_options);
                 for($x=0;$x<sizeof($options_ln);$x++){
                    $options=$options_ln[$x];
                    $option=explode(",",$options);
                    $OKey='';
                    $OVal='';
                    if(isset($option[0])){
                       $OKey=$option[0]; 
                    }
                    if(isset($option[1])){
                       $OVal=$option[1]; 
                    }

                    if(trim($OVal)!="" || trim($OKey)!="")
                    {
                        echo "<div class=\"input-group\">";
                        echo "<div class=\"input-group-prepend\">";
                            echo "<div class=\"input-group-text\" style=\"background-color:transparent;\"><a title='".$this->Model_lib->_QXZ("Delete Option")."' onclick=\"deleteOption(this);\" class=\"btn btn-xs btn-danger pull-right\" href='javascript:void(0);'><i class=\"fa fa-minus\" aria-hidden=\"true\"></i></a></div>";
                            echo "</div>";
                            echo "<input type=\"text\" class=\"form-control options\" maxlength=\"100\" value='".$OVal."' />";  

                            echo "<div class=\"input-group-prepend\">";
                            echo "<div class=\"input-group-text\" style=\"background-color:transparent;\">";
                                if(trim($OKey)!=trim($field_default)){
                                    echo "<input title='".$this->Model_lib->_QXZ("Select default value")."' type=\"radio\" name=\"radion_options\"  onchange=\"setDef(this);\" onclick=\"setDef(this);\" />";
                                }else{
                                    echo "<input title='".$this->Model_lib->_QXZ("Select default value")."' checked type=\"radio\" name=\"radion_options\"  onchange=\"setDef(this);\" onclick=\"setDef(this);\" />";
                                }                            
                            echo "</div>";    
                            echo "</div>";

                        echo "</div>";
                    }
                    
                }


                        echo "</span>";
                echo "</div>";

                

                echo "<div class=\"form-group col-md-12 hide\">";
                     echo "<label>".$this->Model_lib->_QXZ("Field Options")."</label>";
                     echo "<textarea name=\"field_options\" class=\"form-control\" rows=\"5\" cols=\"60\" id=\"field_options\">$field_options</textarea>";
                echo "</div>";

                echo "<div class=\"form-group col-md-6 hide\">";
                     echo "<label>".$this->Model_lib->_QXZ("Field Size")."</label>";
                     echo "<input type=\"text\" class=\"form-control\" name=\"field_size\" size=\"5\" maxlength=\"3\" value='$field_size' />";
                echo "</div>";

                echo "<div class=\"form-group col-md-6 hide\">";
                     echo "<label>".$this->Model_lib->_QXZ("Field Max")."</label>";
                     echo "<input type=\"text\" class=\"form-control\" name=\"field_max\" size=\"5\" maxlength=\"3\" value='$field_max' />";
                echo "</div>";

                

            echo "</div>";
      echo "</div>";
      echo "<div class=\"modal-footer\">";
        echo "<button type=\"button\" class=\"btn btn-secondary\" data-dismiss=\"modal\">Close</button>";
        echo "<button type=\"submit\" id=\"btnSubmit\" class=\"btn btn-primary\">Continue</button>";
      echo "</div>";              
       echo "</form>";

    }

    public function copy_action(){
        error_reporting(0);
        $list_id=$this->input->post('list_id');
        $source_list_id=$this->input->post('source_list_id');
        $copy_option=$this->input->post('copy_option');
        $rank_select="";
        $ip = getenv("REMOTE_ADDR");
        $user=$this->userdata['user'];
        $csrf = array(
                'name' => $this->security->get_csrf_token_name(),
                'hash' => $this->security->get_csrf_hash()
        );
        $response=['status'=>true,'msg'=>$this->Model_lib->_QXZ("Action successfully completed"),'csrf'=>$csrf];
        if ($list_id=="$source_list_id")
        {            
            $response=['status'=>false,'msg'=>$this->Model_lib->_QXZ("You cannot copy fields to the same list"),'csrf'=>$csrf];
            exit(json_encode($response));
        }
    else
        {
        $table_exists=0;
        $VARDB_server=$this->Model_lib->custom->hostname;
        $VARDB_custom_user=$this->Model_lib->custom->username;
        $VARDB_custom_pass=$this->Model_lib->custom->password;
        $VARDB_database=$this->Model_lib->custom->database;
        $VARDB_port=$this->Model_lib->custom->port;

        $linkCUSTOM=mysqli_connect("$VARDB_server", "$VARDB_custom_user", "$VARDB_custom_pass", "$VARDB_database", "$VARDB_port");
        if (!$linkCUSTOM) 
        {
            $response=['status'=>false,'msg'=>$this->Model_lib->_QXZ("connect ERROR"),'csrf'=>$csrf];
            die(json_encode($response));
        }

        $stmt="SELECT count(*) from vicidial_lists_fields where list_id='$source_list_id';";
        $rslt=$this->Model_lib->mysql_to_mysqli($stmt, $this->Model_lib->link);
        $fieldscount_to_print = mysqli_num_rows($rslt);
        if ($fieldscount_to_print > 0) 
            {
            $rowx=mysqli_fetch_row($rslt);
            $source_field_exists =  $rowx[0];
            }
        
        $stmt="SELECT count(*) from vicidial_lists_fields where list_id='$list_id';";
        $rslt=$this->Model_lib->mysql_to_mysqli($stmt, $this->Model_lib->link);
        $fieldscount_to_print = mysqli_num_rows($rslt);
        if ($fieldscount_to_print > 0) 
            {
            $rowx=mysqli_fetch_row($rslt);
            $field_exists = $rowx[0];
            }
        
        $stmt="SHOW TABLES LIKE \"custom_$list_id\";";
        $rslt=$this->Model_lib->mysql_to_mysqli($stmt, $this->Model_lib->link);
        $tablecount_to_print = mysqli_num_rows($rslt);
        if ($tablecount_to_print > 0) 
            {$table_exists =    1;}
       
        
        if ($source_field_exists < 1)
            {
                $response=['status'=>false,'msg'=>$this->Model_lib->_QXZ("Source list has no custom fields"),'csrf'=>$csrf];
                exit(json_encode($response));
            }
        else
            {
            ##### REPLACE option #####
            if ($copy_option=='REPLACE')
                {                
                if ($table_exists > 0)
                    {
                    $stmt="SELECT field_id,field_label,field_duplicate,field_type from vicidial_lists_fields where list_id='$list_id' order by field_rank,field_order,field_label;";
                    $rslt=$this->Model_lib->mysql_to_mysqli($stmt, $this->Model_lib->link);
                    $fields_to_print = mysqli_num_rows($rslt);
                    $fields_list='';
                    $o=0;
                    while ($fields_to_print > $o) 
                        {
                        $rowx=mysqli_fetch_row($rslt);
                        $A_field_id[$o] =           $rowx[0];
                        $A_field_label[$o] =        $rowx[1];
                        $A_field_duplicate[$o] =    $rowx[2];
                        $A_field_type[$o] =         $rowx[3];
                        $o++;
                        }

                    $o=0;
                    while ($fields_to_print > $o) 
                        {
                        ### delete field function
                        $SQLsuccess = $this->delete_field_function("",$this->Model_lib->link,$linkCUSTOM,$ip,$user,$table_exists,$A_field_id[$o],$list_id,$A_field_label[$o],$A_field_name[$o],$A_field_description[$o],$A_field_rank[$o],$A_field_help[$o],$A_field_type[$o],$A_field_options[$o],$A_field_size[$o],$A_field_max[$o],$A_field_default[$o],$A_field_required[$o],$A_field_cost[$o],$A_multi_position[$o],$A_name_position[$o],$A_field_order[$o],$A_field_encrypt[$o],$A_field_show_hide[$o],$A_field_duplicate[$o],$vicidial_list_fields,$csrf);

                        if ($SQLsuccess > 0)
                            {
                                $response=['status'=>true,'msg'=>$this->Model_lib->_QXZ("Action successfully completed."),'csrf'=>$csrf];                                
                            }
                        $o++;
                        }
                    }
                $copy_option='APPEND';
                }
            ##### APPEND option #####
            if ($copy_option=='APPEND')
                {                
                $stmt="SELECT field_id,field_label,field_name,field_description,field_rank,field_help,field_type,field_options,field_size,field_max,field_default,field_cost,field_required,multi_position,name_position,field_order,field_encrypt,field_show_hide,field_duplicate from vicidial_lists_fields where list_id='$source_list_id' order by field_rank,field_order,field_label;";
                $rslt=$this->Model_lib->mysql_to_mysqli($stmt, $this->Model_lib->link);
                $fields_to_print = mysqli_num_rows($rslt);
                $fields_list='';
                $o=0;
                while ($fields_to_print > $o) 
                    {
                    $rowx=mysqli_fetch_row($rslt);
                    $A_field_id[$o] =           $rowx[0];
                    $A_field_label[$o] =        $rowx[1];
                    $A_field_name[$o] =         $rowx[2];
                    $A_field_description[$o] =  $rowx[3];
                    $A_field_rank[$o] =         $rowx[4];
                    $A_field_help[$o] =         $rowx[5];
                    $A_field_type[$o] =         $rowx[6];
                    $A_field_options[$o] =      $rowx[7];
                    $A_field_size[$o] =         $rowx[8];
                    $A_field_max[$o] =          $rowx[9];
                    $A_field_default[$o] =      $rowx[10];
                    $A_field_cost[$o] =         $rowx[11];
                    $A_field_required[$o] =     $rowx[12];
                    $A_multi_position[$o] =     $rowx[13];
                    $A_name_position[$o] =      $rowx[14];
                    $A_field_order[$o] =        $rowx[15];
                    $A_field_encrypt[$o] =      $rowx[16];
                    $A_field_show_hide[$o] =    $rowx[17];
                    $A_field_duplicate[$o] =    $rowx[18];

                    $o++;
                    $rank_select .= "<option>$o</option>";
                    }

                $o=0;
                while ($fields_to_print > $o) 
                    {
                    $new_field_exists=0;
                    $temp_field_label = $A_field_label[$o];
                    if ( ($table_exists > 0) or (preg_match("/\|$temp_field_label\|/i",$this->Model_lib->vicidial_list_fields)) )
                        {
                        $stmt="SELECT count(*) from vicidial_lists_fields where list_id='$list_id' and field_label='$A_field_label[$o]';";
                        $rslt=$this->Model_lib->mysql_to_mysqli($stmt, $this->Model_lib->link);
                        $fieldscount_to_print = mysqli_num_rows($rslt);
                        if ($fieldscount_to_print > 0) 
                            {
                            $rowx=mysqli_fetch_row($rslt);
                            $new_field_exists = $rowx[0];
                            }
                        }
                    if ( ($new_field_exists < 1) or ($A_field_duplicate[$o] == 'Y') )
                        {
                        if (preg_match("/\|$temp_field_label\|/i",$this->Model_lib->vicidial_list_fields))
                            {$A_field_label[$o] = strtolower($A_field_label[$o]);}

                        if ($A_field_duplicate[$o] == 'Y')
                            {
                            $duplicate_field_count=0;
                            $stmt="SELECT count(*) from vicidial_lists_fields where list_id='$list_id' and field_label LIKE \"$A_field_label[$o]%\";";
                            $rslt=$this->Model_lib->mysql_to_mysqli($stmt, $this->Model_lib->link);
                            $dupscount_to_print = mysqli_num_rows($rslt);
                            if ($dupscount_to_print > 0) 
                                {
                                $rowx=mysqli_fetch_row($rslt);
                                $duplicate_field_count =    $rowx[0];
                                }
                            $A_field_label[$o] .= "_DUPLICATE_" . sprintf('%03d', $duplicate_field_count);
                            }

                        ### add field function
                        $SQLsuccess = $this->add_field_function("",$this->Model_lib->link,$linkCUSTOM,$ip,$user,$table_exists,$A_field_id[$o],$list_id,$A_field_label[$o],$A_field_name[$o],$A_field_description[$o],$A_field_rank[$o],$A_field_help[$o],$A_field_type[$o],$A_field_options[$o],$A_field_size[$o],$A_field_max[$o],$A_field_default[$o],$A_field_required[$o],$A_field_cost[$o],$A_multi_position[$o],$A_name_position[$o],$A_field_order[$o],$A_field_encrypt[$o],$A_field_show_hide[$o],$A_field_duplicate[$o],$this->Model_lib->vicidial_list_fields,$this->Model_lib->mysql_reserved_words,$csrf);

                        if ($SQLsuccess > 0)
                            {                              
                                $response=['status'=>true,'msg'=>$this->Model_lib->_QXZ("Action successfully completed"),'csrf'=>$csrf];                               
                            }

                        if ($table_exists < 1) {$table_exists=1;}
                        }
                    else
                        {
                            //if ($DB>0) {echo _QXZ("FIELD EXISTS").": |$list_id|$A_field_label[$o]|";}
                        }
                    $o++;
                    }
                }
            ##### UPDATE option #####
            if ($copy_option=='UPDATE')
                {                
                if ( ($table_exists < 1) and (!preg_match("/\|$field_label\|/i",$this->Model_lib->vicidial_list_fields)) and ($field_duplicate=='N') )
                    {
                       $response=['status'=>false,'msg'=>$this->Model_lib->_QXZ("Table does not exist"),'csrf'=>$csrf];
                       exit($response);                      
                    }
                else
                    {
                    $stmt="SELECT field_id,field_label,field_name,field_description,field_rank,field_help,field_type,field_options,field_size,field_max,field_default,field_cost,field_required,multi_position,name_position,field_order,field_encrypt,field_show_hide,field_duplicate from vicidial_lists_fields where list_id='$source_list_id' order by field_rank,field_order,field_label;";
                    $rslt=$this->Model_lib->mysql_to_mysqli($stmt, $this->Model_lib->link);
                    $fields_to_print = mysqli_num_rows($rslt);
                    $fields_list='';
                    $o=0;
                    while ($fields_to_print > $o) 
                        {
                        $rowx=mysqli_fetch_row($rslt);
                        $A_field_id[$o] =           $rowx[0];
                        $A_field_label[$o] =        $rowx[1];
                        $A_field_name[$o] =         $rowx[2];
                        $A_field_description[$o] =  $rowx[3];
                        $A_field_rank[$o] =         $rowx[4];
                        $A_field_help[$o] =         $rowx[5];
                        $A_field_type[$o] =         $rowx[6];
                        $A_field_options[$o] =      $rowx[7];
                        $A_field_size[$o] =         $rowx[8];
                        $A_field_max[$o] =          $rowx[9];
                        $A_field_default[$o] =      $rowx[10];
                        $A_field_cost[$o] =         $rowx[11];
                        $A_field_required[$o] =     $rowx[12];
                        $A_multi_position[$o] =     $rowx[13];
                        $A_name_position[$o] =      $rowx[14];
                        $A_field_order[$o] =        $rowx[15];
                        $A_field_encrypt[$o] =      $rowx[16];
                        $A_field_show_hide[$o] =    $rowx[17];
                        $A_field_duplicate[$o] =    $rowx[18];
                        $o++;
                        }

                    $o=0;
                    while ($fields_to_print > $o) 
                        {
                        $stmt="SELECT field_id from vicidial_lists_fields where list_id='$list_id' and field_label='$A_field_label[$o]';";                   
                        $rslt=$this->Model_lib->mysql_to_mysqli($stmt, $this->Model_lib->link);
                        $fieldscount_to_print = mysqli_num_rows($rslt);
                        if ($fieldscount_to_print > 0) 
                            {
                            $rowx=mysqli_fetch_row($rslt);
                            $current_field_id = $rowx[0];

                            ### modify field function
                            $SQLsuccess = $this->modify_field_function("",$this->Model_lib->link,$linkCUSTOM,$ip,$user,$table_exists,$current_field_id,$list_id,$A_field_label[$o],$A_field_name[$o],$A_field_description[$o],$A_field_rank[$o],$A_field_help[$o],$A_field_type[$o],$A_field_options[$o],$A_field_size[$o],$A_field_max[$o],$A_field_default[$o],$A_field_required[$o],$A_field_cost[$o],$A_multi_position[$o],$A_name_position[$o],$A_field_order[$o],$A_field_encrypt[$o],$A_field_show_hide[$o],$A_field_duplicate[$o],$this->Model_lib->vicidial_list_fields,$csrf);

                            if ($SQLsuccess > 0)
                                {
                                    $response=['status'=>true,'msg'=>$this->Model_lib->_QXZ("Action successfully completed"),'csrf'=>$csrf];                                    
                                }
                            }
                        $o++;
                        }
                    }
                }
            }
        }

        exit(json_encode($response));
    }


    public function copy_fields()
    {       
            $list_id=$this->input->get('list_id');
            $stmt="SELECT list_id,list_name from vicidial_lists ".whereLOGallowed_campaignsSQL." order by list_id;";
            $rsltx=$this->Model_lib->mysql_to_mysqli($stmt, $this->Model_lib->link);
            $lists_to_print = mysqli_num_rows($rsltx);
            $lists_list='';
            $o=0;
            while ($lists_to_print > $o)
                {
                    $rowx=mysqli_fetch_row($rsltx);
                    if($list_id==$rowx[0]){
                        $lists_list .= "<option SELECTED value=\"$rowx[0]\">$rowx[0] - $rowx[1]</option>\n";
                    }else{
                        $lists_list .= "<option value=\"$rowx[0]\">$rowx[0] - $rowx[1]</option>\n";
                    }
                    
                    $o++;
                }


        $csrf = array(
                'name' => $this->security->get_csrf_token_name(),
                'hash' => $this->security->get_csrf_hash()
        );

            echo "<div class=\"modal-header\">";
                echo "<button type=\"button\" class=\"close\" data-dismiss=\"modal\" aria-hidden=\"true\"></button>";
                echo "<h4 class=\"modal-title\">".$this->Model_lib->_QXZ("Copy Custom Fields")."</h4>";
            echo "</div>";      
            echo "<form action=".base_url('lists/copy_action')." method=\"post\" id=\"frm_modal_copy_fields\">";
            echo "<div class=\"modal-body\">";
            echo "<div class=\"row\">";
                echo "<input type=\"hidden\" id=\"copy_field_csrf_hash_option\"  name='".$csrf['name']."' value='".$csrf['hash']."' />";
              

                echo "<div class=\"form-group col-md-12\">";
                     echo "<label>".$this->Model_lib->_QXZ("Source List")."</label>";
                     echo "<select class=\"form-control\" name=source_list_id>";
                     echo $lists_list;
                     echo "</select>";
                echo "</div>";


                echo "<div class=\"form-group col-md-12\">";
                     echo "<label>".$this->Model_lib->_QXZ("Target List")."</label>";
                     echo "<select class=\"form-control\" name=list_id>";
                     echo $lists_list;
                     echo "</select>";
                echo "</div>";

                echo "<div class=\"form-group col-md-12\">";
                    echo "<select class=\"form-control\" name=\"copy_option\">";
                        echo "<option value=\"APPEND\" selected>APPEND</option>";
                        echo "<option value=\"UPDATE\">UPDATE</option>";
                        echo "<option value=\"REPLACE\">REPLACE</option>";
                    echo "</select>";
                echo "</div>";
                
               
            echo "</div>";
      echo "</div>";
      echo "<div class=\"modal-footer\">";
        echo "<button type=\"button\" class=\"btn btn-secondary\" data-dismiss=\"modal\">Close</button>";
        echo "<button type=\"submit\" id=\"btnSubmit\" class=\"btn btn-primary\">Continue</button>";
      echo "</div>";              
       echo "</form>";

    }

    public function fields_action(){
        $mysql_reserved_words=$this->Model_lib->mysql_reserved_words;
        $list_id=$this->input->post('list_id');
        $field_id=$this->input->post('field_id');
        $csrf = array(
                'name' => $this->security->get_csrf_token_name(),
                'hash' => $this->security->get_csrf_hash()
        );
        if(strlen($field_id)>0){
            $this->modify_custom_field($list_id,$field_id,$csrf);
        }else{
            $this->add_custom_field($list_id,$field_id,$csrf);
        }
    }

    public function modify_custom_field($list_id,$field_id,$csrf){
        
    $mysql_reserved_words=$this->Model_lib->mysql_reserved_words;
    $field_label=$this->input->post('field_label');
    $field_name=$this->input->post('field_name');
    $field_size=$this->input->post('field_size');
    $field_type=$this->input->post('field_type');
    $field_max=$this->input->post('field_max');
    $field_size=$this->input->post('field_size');
    $field_options=$this->input->post('field_options');
    $field_default=$this->input->post('field_default');
    $field_default=trim($field_default);
    $field_rank=$this->input->post('field_rank');
    $field_cost=0;
    $field_order=1;
    $field_encrypt="N";
    $field_show_hide="DISABLED";
    $ip = getenv("REMOTE_ADDR");
    $user=$this->userdata['user'];

    $field_label = preg_replace('/[^_0-9a-zA-Z]/','',$field_label);
    $field_name = preg_replace('/[^ \.\,-\_0-9a-zA-Z]/','',$field_name);

    $field_options_ENUM='';
    $name_position="LEFT";
    $field_description="";
    $field_help="";
    $multi_position="";
    
    $field_required="N";
    $field_duplicate="N";
  
    $multi_position="HORIZONTAL";

    $VARDB_server=$this->Model_lib->custom->hostname;
    $VARDB_custom_user=$this->Model_lib->custom->username;
    $VARDB_custom_pass=$this->Model_lib->custom->password;
    $VARDB_database=$this->Model_lib->custom->database;
    $VARDB_port=$this->Model_lib->custom->port;
    
    $linkCUSTOM=mysqli_connect("$VARDB_server", "$VARDB_custom_user", "$VARDB_custom_pass", "$VARDB_database", "$VARDB_port");
    if (!$linkCUSTOM) 
        {
            $response=['status'=>false,'msg'=>'MySQL '.$this->Model_lib->_QXZ("connect ERROR").': '. mysqli_connect_error(),'csrf'=>$csrf];
            die(json_encode($response));
        }


    $stmt="SELECT count(*) from vicidial_lists_fields where list_id='$list_id' and field_id='$field_id';";
    $rslt=$this->Model_lib->mysql_to_mysqli($stmt, $this->Model_lib->link);
    $fieldscount_to_print = mysqli_num_rows($rslt);
    if ($fieldscount_to_print > 0) 
        {
        $rowx=mysqli_fetch_row($rslt);
        $field_exists = $rowx[0];
        }
    
    $stmt="SHOW TABLES LIKE \"custom_$list_id\";";
    $rslt=$this->Model_lib->mysql_to_mysqli($stmt, $this->Model_lib->link);
    $tablecount_to_print = mysqli_num_rows($rslt);
    if ($tablecount_to_print > 0) 
        {$table_exists =    1;}
    
    if ($field_duplicate=='Y')
        {$field_type='TEXT';}

    if ($field_exists < 1)
        {        
            $response=['status'=>false,'msg'=>$this->Model_lib->_QXZ("Field does not exist"),'csrf'=>$csrf];
            exit(json_encode($response));
        }
    else
        {
        if ( ($table_exists < 1) and (!preg_match("/\|$field_label\|/i",$vicidial_list_fields)) and ($field_duplicate=='N') )
            {
                $response=['status'=>false,'msg'=>$this->Model_lib->_QXZ("Table does not exist"),'csrf'=>$csrf];
                exit(json_encode($response));
            }
        else
            {
            if ( ( ($field_type=='TEXT') or ($field_type=='READONLY') or ($field_type=='HIDDEN') ) and ($field_max < strlen($field_default)) )
                {
                    $response=['status'=>false,'msg'=>$this->Model_lib->_QXZ("Default value cannot be longer than maximum field length"),'csrf'=>$csrf];
                    exit(json_encode($response));
                }
            else
                {
                $TEST_valid_options=0;
                if ( ($field_type=='SELECT') or ($field_type=='MULTI') or ($field_type=='RADIO') or ($field_type=='CHECKBOX') or ($field_type=='SWITCH') )
                    {
                    $TESTfield_options_array = explode("\n",$field_options);
                    $TESTfield_options_count = count($TESTfield_options_array);
                    $te=0;
                    $switch_list_self=0;
                    while ($te < $TESTfield_options_count)
                        {
                        if (preg_match("/,/",$TESTfield_options_array[$te]))
                            {
                            $TESTfield_options_value_array = explode(",",$TESTfield_options_array[$te]);
                            if ( (strlen($TESTfield_options_value_array[0]) > 0) and (strlen($TESTfield_options_value_array[1]) > 0) )
                                {$TEST_valid_options++;}
                            if ( ($field_type=='SWITCH') and ($TESTfield_options_value_array[0] == "$list_id") )
                                {$switch_list_self++;}
                            }
                        $te++;
                        }
                    $field_options_ENUM = preg_replace("/.$/",'',$field_options_ENUM);
                    }

                if ( ( ($field_type=='SELECT') or ($field_type=='MULTI') or ($field_type=='RADIO') or ($field_type=='CHECKBOX') ) and ( (!preg_match("/,/",$field_options)) or (!preg_match("/\n/",$field_options)) or (strlen($field_options)<6) or ($TEST_valid_options < 1) ) )
                    {
                        $response=['status'=>false,'msg'=>$this->Model_lib->_QXZ("You must enter field options when updating a SELECT, MULTI, RADIO or CHECKBOX field type"),'csrf'=>$csrf];
                        exit(json_encode($response));
                    }
                else
                    {
                    if ( ($field_type=='SWITCH') and ($switch_list_self < 1) )
                        {
                            $response=['status'=>false,'msg'=>$this->Model_lib->_QXZ("You must include the current List ID in field options when modifying a SWITCH field type"),'csrf'=>$csrf];
                            exit(json_encode($response));
                        }
                    else
                        {
                        ### modify field function
                        $SQLsuccess = $this->modify_field_function("",$this->Model_lib->link,$linkCUSTOM,$ip,$user,$table_exists,$field_id,$list_id,$field_label,$field_name,$field_description,$field_rank,$field_help,$field_type,$field_options,$field_size,$field_max,$field_default,$field_required,$field_cost,$multi_position,$name_position,$field_order,$field_encrypt,$field_show_hide,$field_duplicate,$this->Model_lib->vicidial_list_fields,$csrf);

                        if ($SQLsuccess > 0)
                            {
                                $stmt="SELECT field_id from vicidial_lists_fields where list_id='$list_id' and field_label='$field_label' LIMIT 1;";
                                $rslt=$this->Model_lib->mysql_to_mysqli($stmt,$this->Model_lib->link);
                                $count_to_print = mysqli_num_rows($rslt);
                                if ($count_to_print > 0) 
                                    {
                                        $rowx=mysqli_fetch_row($rslt);
                                        $field_id =    $rowx[0];
                                    }
                                $response=['status'=>true,"msg"=>$this->Model_lib->_QXZ("Custom Field Modified"),'csrf'=>$csrf,'field_rank'=>$field_rank,'field_label'=>$field_label,'field_name'=>$field_name,'field_type'=>$field_type,'field_id'=>$field_id,'added'=>false];
                                exit(json_encode($response));
                            }
                        }
                    }
                }
            }
        }

    }


    ##### BEGIN modify field function
function modify_field_function($DB,$link,$linkCUSTOM,$ip,$user,$table_exists,$field_id,$list_id,$field_label,$field_name,$field_description,$field_rank,$field_help,$field_type,$field_options,$field_size,$field_max,$field_default,$field_required,$field_cost,$multi_position,$name_position,$field_order,$field_encrypt,$field_show_hide,$field_duplicate,$vicidial_list_fields,$csrf)
    {
    $field_db_exists=0;
    $stmtCUSTOM="";
    if ( ($field_type=='DISPLAY') or ($field_type=='SCRIPT') or ($field_type=='SWITCH') or (preg_match("/\|$field_label\|/i",$vicidial_list_fields)) or ($field_duplicate=='Y') )
        {$field_db_exists=1;}
    else
        {
        $stmt="SHOW COLUMNS from custom_$list_id LIKE '$field_label';";
        $rslt=$this->Model_lib->mysql_to_mysqli($stmt, $this->Model_lib->link);
        $field_db_exists = mysqli_num_rows($rslt);
        }
    if ($field_db_exists > 0)
        {$field_sql = "ALTER TABLE custom_$list_id MODIFY `$field_label` ";}
    else
        {$field_sql = "ALTER TABLE custom_$list_id ADD `$field_label` ";}

    if ($field_duplicate=='Y')
        {$field_type='TEXT';}
    if ($field_encrypt=='Y')
        {
        # override encrypt setting for non-encryptable field types
        if ( ( ($field_type!='TEXT') and ($field_type!='HIDDEN') and ($field_type!='READONLY') and ($field_type!='HIDEBLOB') and ($field_type!='AREA') and ($field_type!='DATE') and ($field_type!='TIME') ) or ($field_duplicate=='Y') )
            {
            $field_encrypt='N';
            }
        }

    $field_options_ENUM='';
    $field_cost=1;
    if ( ($field_type=='SELECT') or ($field_type=='RADIO') )
        {
        $field_options_array = explode("\n",$field_options);
        $field_options_count = count($field_options_array);
        $te=0;
        while ($te < $field_options_count)
            {
            if (preg_match("/,/",$field_options_array[$te]))
                {
                $field_options_value_array = explode(",",$field_options_array[$te]);
                $field_options_ENUM .= "'$field_options_value_array[0]',";
                }
            $te++;
            }
        $field_options_ENUM = preg_replace("/.$/",'',$field_options_ENUM);
        $field_sql .= "ENUM($field_options_ENUM) ";
        $field_cost = strlen($field_options_ENUM);
        }
    if ( ($field_type=='MULTI') or ($field_type=='CHECKBOX') )
        {
        $field_options_array = explode("\n",$field_options);
        $field_options_count = count($field_options_array);
        $te=0;
        while ($te < $field_options_count)
            {
            if (preg_match("/,/",$field_options_array[$te]))
                {
                $field_options_value_array = explode(",",$field_options_array[$te]);
                $field_options_ENUM .= "'$field_options_value_array[0]',";
                }
            $te++;
            }
        $field_options_ENUM = preg_replace("/.$/",'',$field_options_ENUM);
        $field_cost = strlen($field_options_ENUM);
        $field_sql .= "VARCHAR($field_cost) ";
        }
    if ( ($field_type=='TEXT') or ($field_type=='HIDDEN') or ($field_type=='READONLY') )
        {
        if ($field_max < 1) {$field_max=1;};
        $field_maxSQL = $field_max;
        if ($field_encrypt == 'Y')
            {
            if ($field_max < 8) {$field_maxSQL=30;}
            else {$field_maxSQL = ($field_max * 4);}
            }
        $field_sql .= "VARCHAR($field_maxSQL) ";
        $field_cost = ($field_maxSQL + $field_cost);
        }
    if ($field_type=='HIDEBLOB')
        {
        $field_sql .= "BLOB ";
        $field_cost = 15;
        }
    if ($field_type=='AREA') 
        {
        $field_sql .= "TEXT ";
        $field_cost = 15;
        }
    if ($field_type=='DATE') 
        {
        if ($field_encrypt == 'Y')
            {
            $field_sql .= "VARCHAR(30) ";
            $field_cost = 31;
            }
        else
            {
            $field_sql .= "DATE ";
            $field_cost = 10;
            }
        }
    if ($field_type=='TIME') 
        {
        if ($field_encrypt == 'Y')
            {
            $field_sql .= "VARCHAR(30) ";
            $field_cost = 31;
            }
        else
            {
            $field_sql .= "TIME ";
            $field_cost = 8;
            }
        }
    $field_cost = ($field_cost * 3); # account for utf8 database

    if ( ($field_default == 'NULL') or ($field_type=='AREA') or ($field_type=='DATE') or ($field_type=='TIME') )
        {$field_sql .= ";";}
    else
        {
        if ( ($field_encrypt=='N') or ( ($field_encrypt=='Y') and ($field_type!='TEXT') and ($field_type!='HIDDEN') and ($field_type!='READONLY') and ($field_type!='HIDEBLOB') ) )
            {$field_sql .= "default '$field_default';";}
        else
            {$field_sql .= ";";}
        }

    $SQLexecuted=0;

    if ( ($field_type=='DISPLAY') or ($field_type=='SCRIPT') or ($field_type=='SWITCH') or (preg_match("/\|$field_label\|/i",$vicidial_list_fields)) or ($field_duplicate=='Y') )
        {
        if ($DB) {
            
            $response=['status'=>false,'msg'=>$this->Model_lib->_QXZ("Non-DB"). " ". $field_type. " " .$this->Model_lib->_QXZ("field type")." , ".$field_label,'csrf'=>$csrf];
            exit(json_encode($response));
        }
        $SQLexecuted++;
        }
    else
        {
        $stmtCUSTOM="$field_sql";
        $rsltCUSTOM=$this->Model_lib->mysql_to_mysqli($stmtCUSTOM, $linkCUSTOM);
        $field_update = mysqli_affected_rows($linkCUSTOM);
        if ($DB) {echo "$field_update|$stmtCUSTOM\n";}
        if (!$rsltCUSTOM) {
            $response=['status'=>false,'msg'=>$this->Model_lib->_QXZ("Could not executeB"),'csrf'=>$csrf,'stmtCUSTOM'=>$stmtCUSTOM];
            ### LOG INSERTION Admin Log Table ###
            $SQL_log = "$stmt|$stmtCUSTOM";
            $SQL_log = preg_replace('/;/', '', $SQL_log);
            $SQL_log = addslashes($SQL_log);
            $stmt="INSERT INTO vicidial_admin_log set event_date=NOW(), user='$user', ip_address='$ip', event_section='CUSTOM_FIELDS', event_type='OTHER', record_id='$list_id', event_code='ADMIN MODIFY CUSTOM LIST FIELD ERROR', event_sql=\"$SQL_log\", event_notes='MODIFY ERROR:" . mysqli_error() . "';";
            if ($DB) {echo "|$stmt|\n";}
            $rslt=$this->Model_lib->mysql_to_mysqli($stmt, $this->Model_lib->link);
            //exit(json_encode($response));
            }
        else
            {$SQLexecuted++;}
        }

    if ($SQLexecuted > 0)
        {
            $response=[];
        $stmt="UPDATE vicidial_lists_fields set field_label='$field_label',field_name='$field_name',field_description='$field_description',field_rank='$field_rank',field_help='$field_help',field_type='$field_type',field_options=\"$field_options\",field_size='$field_size',field_max='$field_max',field_default='$field_default',field_required='$field_required',field_cost='$field_cost',multi_position='$multi_position',name_position='$name_position',field_order='$field_order',field_encrypt='$field_encrypt',field_show_hide='$field_show_hide',field_duplicate='$field_duplicate' where list_id='$list_id' and field_id='$field_id';";
        $rslt=$this->Model_lib->mysql_to_mysqli($stmt, $this->Model_lib->link);
        $field_update = mysqli_affected_rows($link);
        if ($DB) {echo "$field_update|$stmt\n";}
        if (!$rslt) {
            $response=['status'=>false,'msg'=>$this->Model_lib->_QXZ("Could not executeB"),'csrf'=>$csrf];
        }

        ### LOG INSERTION Admin Log Table ###
        $SQL_log = "$stmt|$stmtCUSTOM";
        $SQL_log = preg_replace('/;/', '', $SQL_log);
        $SQL_log = addslashes($SQL_log);
        $stmt="INSERT INTO vicidial_admin_log set event_date=NOW(), user='$user', ip_address='$ip', event_section='CUSTOM_FIELDS', event_type='MODIFY', record_id='$list_id', event_code='ADMIN MODIFY CUSTOM LIST FIELD', event_sql=\"$SQL_log\", event_notes='';";
        if ($DB) {echo "|$stmt|\n";}
        $rslt=$this->Model_lib->mysql_to_mysqli($stmt, $this->Model_lib->link);
            if(sizeof($response)>0){
                //exit(json_encode($response));
            }
        }    
    return $SQLexecuted;
    }
##### END modify field function

    public function add_custom_field($list_id,$field_id,$csrf){
    $mysql_reserved_words=$this->Model_lib->mysql_reserved_words;
    $field_label=$this->input->post('field_label');
    $field_name=$this->input->post('field_name');
    $field_size=$this->input->post('field_size');
    $field_type=$this->input->post('field_type');
    $field_max=$this->input->post('field_max');
    $field_size=$this->input->post('field_size');
    $field_options=$this->input->post('field_options');
    $field_default=$this->input->post('field_default');
    $field_default=trim($field_default);
    $field_cost=0;
    $field_order=1;
    $field_encrypt="N";
    $field_show_hide="DISABLED";
    $ip = getenv("REMOTE_ADDR");
    $user=$this->userdata['user'];

    $field_label = preg_replace('/[^_0-9a-zA-Z]/','',$field_label);
    $field_name = preg_replace('/[^ \.\,-\_0-9a-zA-Z]/','',$field_name);

    $field_options_ENUM='';
    $name_position="LEFT";
    $field_description="";
    $field_help="";
    $multi_position="";
    
    $field_required="N";
    $field_duplicate="N";
    $field_rank=0;
    $multi_position="HORIZONTAL";
    $stmt="SELECT MAX(field_rank) from vicidial_lists_fields where list_id='$list_id'";
    $rslt=$this->Model_lib->mysql_to_mysqli($stmt,$this->Model_lib->link);
    $rowx=mysqli_fetch_row($rslt);
    $field_rank = $rowx[0];
    $field_rank =strval($field_rank)+1;


    $stmt="SELECT count(*) from vicidial_lists_fields where list_id='$list_id' and field_label='$field_label';";
    $rslt=$this->Model_lib->mysql_to_mysqli($stmt,$this->Model_lib->link);
    $fieldscount_to_print = mysqli_num_rows($rslt);
    if ($fieldscount_to_print > 0) 
        {
            $rowx=mysqli_fetch_row($rslt);
            $field_exists = $rowx[0];
        }
    
    if ( (strlen($field_label)<1) or (strlen($field_name)<2) or (strlen($field_size)<1) )
        {
            $response=['status'=>false,"msg"=>$this->Model_lib->_QXZ("You must enter a field label, field name and field size"),'csrf'=>$csrf];
            exit(json_encode($response));
        }
    else
        {
        if ( ( ($field_type=='TEXT') or ($field_type=='READONLY') or ($field_type=='HIDDEN') ) and ($field_max < strlen($field_default)) )
            {
                $response=['status'=>false,"msg"=>$this->Model_lib->_QXZ("You must enter a field label, field name and field size"),'csrf'=>$csrf];
                exit(json_encode($response));
            }
        else
            {
            if (preg_match("/\|$field_label\|/i",$mysql_reserved_words))
                {
                    $response=['status'=>false,"msg"=>$this->Model_lib->_QXZ("You cannot use reserved words for field labels"),'csrf'=>$csrf];
                    exit(json_encode($response));
                }
            else
                {
                $TEST_valid_options=0;
                if ( ($field_type=='SELECT') or ($field_type=='MULTI') or ($field_type=='RADIO') or ($field_type=='CHECKBOX') or ($field_type=='SWITCH') )
                    {
                    $TESTfield_options_array = explode("\n",$field_options);
                    $TESTfield_options_count = count($TESTfield_options_array);
                    $te=0;
                    $switch_list_self=0;
                    while ($te < $TESTfield_options_count)
                        {
                        if (preg_match("/,/",$TESTfield_options_array[$te]))
                            {
                            $TESTfield_options_value_array = explode(",",$TESTfield_options_array[$te]);
                            if ( (strlen($TESTfield_options_value_array[0]) > 0) and (strlen($TESTfield_options_value_array[1]) > 0) )
                                {$TEST_valid_options++;}
                            if ( ($field_type=='SWITCH') and ($TESTfield_options_value_array[0] == "$list_id") )
                                {$switch_list_self++;}
                            }
                        $te++;
                        }
                    $field_options_ENUM = preg_replace("/.$/",'',$field_options_ENUM);
                    }

                if ( ( ($field_type=='SELECT') or ($field_type=='MULTI') or ($field_type=='RADIO') or ($field_type=='CHECKBOX') ) and ( (!preg_match("/,/",$field_options)) or (!preg_match("/\n/",$field_options)) or (strlen($field_options)<6) or ($TEST_valid_options < 1) ) )
                    {
                        $response=['status'=>false,"msg"=>$this->Model_lib->_QXZ("You must enter field options when adding a SELECT, MULTI, RADIO or CHECKBOX field type"),'csrf'=>$csrf];
                        exit(json_encode($response));
                    }
                else
                    {
                    if ( ($field_type=='SWITCH') and ($switch_list_self < 1) )
                        {
                            $response=['status'=>false,"msg"=>$this->Model_lib->_QXZ("You must include the current List ID in field options when adding a SWITCH field type"),'csrf'=>$csrf];
                            exit(json_encode($response));
                        }
                    else
                        {
                        if ( ($field_exists > 0) and ($field_duplicate != 'Y') )
                            {
                       
                                $response=['status'=>false,"msg"=>$this->Model_lib->_QXZ("Field already exists for this list"),'csrf'=>$csrf];
                                exit(json_encode($response));
                            }
                        else
                            {
                            if ( ($field_exists < 1) and ($field_duplicate == 'Y') )
                                {
                                    $response=['status'=>false,"msg"=>$this->Model_lib->_QXZ("Field set to duplicate but original does not exist for this list"),'csrf'=>$csrf];
                                    exit(json_encode($response));
                                }
                            else
                                {
                                if ( ($field_type!='TEXT') and ($field_duplicate == 'Y') )
                                    {
                                        $response=['status'=>false,"msg"=>$this->Model_lib->_QXZ("Field set to duplicate but not TEXT type"),'csrf'=>$csrf];
                                        exit(json_encode($response));
                                    }
                                else
                                    {
                                    $table_exists=0;                                   
                                    $linkCUSTOM=mysqli_connect($this->Model_lib->custom->hostname, $this->Model_lib->custom->username, $this->Model_lib->custom->password, $this->Model_lib->custom->database, $this->Model_lib->custom->port);
                                    if (!$linkCUSTOM)
                                        {
                                            $response=['status'=>false,"msg"=>$this->Model_lib->_QXZ("connect ERROR").': '. mysqli_connect_error(),'csrf'=>$csrf];
                                            die(json_encode($response));
                                        }

                                    $stmt="SHOW TABLES LIKE \"custom_$list_id\";";
                                    $rslt=$this->Model_lib->mysql_to_mysqli($stmt, $this->Model_lib->link);
                                    $tablecount_to_print = mysqli_num_rows($rslt);
                                    if ($tablecount_to_print > 0) 
                                        {$table_exists =    1;}
                                  
                                    if (preg_match("/\|$field_label\|/i",$this->Model_lib->vicidial_list_fields))
                                        {$field_label = strtolower($field_label);}

                                    if ($field_duplicate == 'Y')
                                        {
                                        $duplicate_field_count=0;
                                        $stmt="SELECT count(*) from vicidial_lists_fields where list_id='$list_id' and field_label LIKE \"$field_label%\";";
                              
                                        $rslt=$this->Model_lib->mysql_to_mysqli($stmt,$this->Model_lib->link);
                                        $dupscount_to_print = mysqli_num_rows($rslt);
                                        if ($dupscount_to_print > 0) 
                                            {
                                            $rowx=mysqli_fetch_row($rslt);
                                            $duplicate_field_count =    $rowx[0];
                                            }
                                        $field_label .= "_DUPLICATE_" . sprintf('%03d', $duplicate_field_count);
                                        }
                                    ### add field function
                                    $SQLsuccess = $this->add_field_function("",$this->Model_lib->link,$linkCUSTOM,$ip,$user,$table_exists,$field_id,$list_id,$field_label,$field_name,$field_description,$field_rank,$field_help,$field_type,$field_options,$field_size,$field_max,$field_default,$field_required,$field_cost,$multi_position,$name_position,$field_order,$field_encrypt,$field_show_hide,$field_duplicate,$this->Model_lib->vicidial_list_fields,$mysql_reserved_words,$csrf);
                                    if ($SQLsuccess > 0)
                                        {   

                                            $stmt="SELECT field_id from vicidial_lists_fields where list_id='$list_id' and field_label='$field_label' LIMIT 1;";
                                            $rslt=$this->Model_lib->mysql_to_mysqli($stmt,$this->Model_lib->link);
                                            $count_to_print = mysqli_num_rows($rslt);
                                            if ($count_to_print > 0) 
                                                {
                                                    $rowx=mysqli_fetch_row($rslt);
                                                    $field_id =    $rowx[0];
                                                }

                                            $response=['status'=>true,"msg"=>$this->Model_lib->_QXZ("Custom Field Added"),'csrf'=>$csrf,'field_rank'=>$field_rank,'field_label'=>$field_label,'field_name'=>$field_name,'field_type'=>$field_type,'field_id'=>$field_id,'added'=>true];
                                            exit(json_encode($response));
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
  


    }




    ##### BEGIN add field function
private function add_field_function($DB="",$link,$linkCUSTOM,$ip,$user,$table_exists,$field_id,$list_id,$field_label,$field_name,$field_description,$field_rank,$field_help,$field_type,$field_options,$field_size,$field_max,$field_default,$field_required,$field_cost,$multi_position,$name_position,$field_order,$field_encrypt,$field_show_hide,$field_duplicate,$vicidial_list_fields,$mysql_reserved_words,$csrf)
    {
    $table_exists=0;
    $stmtCUSTOM="";
    $stmt="SHOW TABLES LIKE \"custom_$list_id\";";
    $rslt=$this->Model_lib->mysql_to_mysqli($stmt,$this->Model_lib->link);
    $tablecount_to_print = mysqli_num_rows($rslt);
    if ($tablecount_to_print > 0)
        {$table_exists =    1;}
    if ($table_exists < 1)
        {$field_sql = "CREATE TABLE custom_$list_id (lead_id INT(9) UNSIGNED PRIMARY KEY NOT NULL, $field_label ";}
    else
        {$field_sql = "ALTER TABLE custom_$list_id ADD `$field_label` ";}

    if ($field_encrypt=='Y')
        {
        # override encrypt setting for non-encryptable field types
        if ( ( ($field_type!='TEXT') and ($field_type!='HIDDEN') and ($field_type!='READONLY') and ($field_type!='HIDEBLOB') and ($field_type!='AREA') and ($field_type!='DATE') and ($field_type!='TIME') ) or ($field_duplicate=='Y') )
            {
            $field_encrypt='N';
            }
        }

    $field_options_ENUM='';
    $field_cost=1;
    if ( ($field_type=='SELECT') or ($field_type=='RADIO') )
        {
        $field_options_array = explode("\n",$field_options);
        $field_options_count = count($field_options_array);
        $te=0;
        while ($te < $field_options_count)
            {
            if (preg_match("/,/",$field_options_array[$te]))
                {
                $field_options_value_array = explode(",",$field_options_array[$te]);
                $field_options_ENUM .= "'$field_options_value_array[0]',";
                }
            $te++;
            }
        $field_options_ENUM = preg_replace("/.$/",'',$field_options_ENUM);
        $field_sql .= "ENUM($field_options_ENUM) ";
        $field_cost = strlen($field_options_ENUM);
        }
    if ( ($field_type=='MULTI') or ($field_type=='CHECKBOX') )
        {
        $field_options_array = explode("\n",$field_options);
        $field_options_count = count($field_options_array);
        $te=0;
        while ($te < $field_options_count)
            {
            if (preg_match("/,/",$field_options_array[$te]))
                {
                $field_options_value_array = explode(",",$field_options_array[$te]);
                $field_options_ENUM .= "'$field_options_value_array[0]',";
                }
            $te++;
            }
        $field_options_ENUM = preg_replace("/.$/",'',$field_options_ENUM);
        $field_cost = strlen($field_options_ENUM);
        if ($field_cost < 1) {$field_cost=1;};
        $field_sql .= "VARCHAR($field_cost) ";
        }
    if ( ($field_type=='TEXT') or ($field_type=='HIDDEN') or ($field_type=='READONLY') )
        {
        if ($field_max < 1) {$field_max=1;};
        $field_maxSQL = $field_max;
        if ($field_encrypt == 'Y')
            {
            if ($field_max < 8) {$field_maxSQL=30;}
            else {$field_maxSQL = ($field_max * 4);}
            }
        $field_sql .= "VARCHAR($field_maxSQL) ";
        $field_cost = ($field_maxSQL + $field_cost);
        }
    if ($field_type=='HIDEBLOB')
        {
        $field_sql .= "BLOB ";
        $field_cost = 15;
        }
    if ($field_type=='AREA') 
        {
        $field_sql .= "TEXT ";
        $field_cost = 15;
        }
    if ($field_type=='DATE') 
        {
        if ($field_encrypt == 'Y')
            {
            $field_sql .= "VARCHAR(30) ";
            $field_cost = 31;
            }
        else
            {
            $field_sql .= "DATE ";
            $field_cost = 10;
            }
        }
    if ($field_type=='TIME') 
        {
        if ($field_encrypt == 'Y')
            {
            $field_sql .= "VARCHAR(30) ";
            $field_cost = 31;
            }
        else
            {
            $field_sql .= "TIME ";
            $field_cost = 8;
            }
        }
    $field_cost = ($field_cost * 3); # account for utf8 database

    if ( ($field_default != 'NULL') and ($field_type!='AREA') and ($field_type!='DATE') and ($field_type!='TIME') )
        {
        if ( ($field_encrypt=='N') or ( ($field_encrypt=='Y') and ($field_type!='TEXT') and ($field_type!='HIDDEN') and ($field_type!='READONLY') and ($field_type!='HIDEBLOB') ) )
            {$field_sql .= "default '$field_default'";}
        }

    if ($table_exists < 1)
        {$field_sql .= ");";}
    else
        {$field_sql .= ";";}

    $SQLexecuted=0;

    if ( ($field_type=='DISPLAY') or ($field_type=='SCRIPT') or ($field_type=='SWITCH') or (preg_match("/\|$field_label\|/i",$vicidial_list_fields)) or ($field_duplicate=='Y') )
        {
        if ($DB) {echo "Non-DB $field_type field type, $field_label\n";}

        if ($table_exists < 1)
            {$field_sql = "CREATE TABLE custom_$list_id (lead_id INT(9) UNSIGNED PRIMARY KEY NOT NULL);";}
        else
            {$SQLexecuted++;}
        }
    if ($SQLexecuted < 1)
        {
        $stmtCUSTOM="$field_sql";
        //echo $stmtCUSTOM;
        //exit();
        $rsltCUSTOM=$this->Model_lib->mysql_to_mysqli($stmtCUSTOM, $linkCUSTOM);
        $table_update = mysqli_affected_rows($linkCUSTOM);
        if (!$rsltCUSTOM) 
            {
            $response=['status'=>false,'msg'=>$this->Model_lib->_QXZ("Could not execute").': ' . mysqli_error(),'csrf'=>$csrf,'stmtCUSTOM'=>$stmtCUSTOM];        
            ### LOG INSERTION Admin Log Table ###
            $SQL_log = "$stmt|$stmtCUSTOM";
            $SQL_log = preg_replace('/;/', '', $SQL_log);
            $SQL_log = addslashes($SQL_log);
            $stmt="INSERT INTO vicidial_admin_log set event_date=NOW(), user='$user', ip_address='$ip', event_section='CUSTOM_FIELDS', event_type='OTHER', record_id='$list_id', event_code='ADMIN ADD CUSTOM LIST FIELD ERROR', event_sql=\"$SQL_log\", event_notes='ADD ERROR:" . mysqli_error() . "';";        
            $rslt=$this->Model_lib->mysql_to_mysqli($stmt, $this->Model_lib->link);            
            //exit(json_encode($response));
            }
        else
            {$SQLexecuted++;}
        }

    if ($SQLexecuted > 0)
        {
        $stmt="INSERT INTO vicidial_lists_fields set field_label='$field_label',field_name='$field_name',field_description='$field_description',field_rank='$field_rank',field_help='$field_help',field_type='$field_type',field_options=\"$field_options\",field_size='$field_size',field_max='$field_max',field_default='$field_default',field_required='$field_required',field_cost='$field_cost',list_id='$list_id',multi_position='$multi_position',name_position='$name_position',field_order='$field_order',field_encrypt='$field_encrypt',field_show_hide='$field_show_hide',field_duplicate='$field_duplicate';";
        $rslt=$this->Model_lib->mysql_to_mysqli($stmt,$this->Model_lib->link);
        $field_update = mysqli_affected_rows($this->Model_lib->link);
        $response=[];
        if (!$rslt) 
        {
            $response=['status'=>false,'msg'=>$this->Model_lib->_QXZ("Could not execute").': ' . mysqli_error(),'csrf'=>$csrf];            
        }
        ### LOG INSERTION Admin Log Table ###
        $SQL_log = "$stmt|$stmtCUSTOM";
        $SQL_log = preg_replace('/;/', '', $SQL_log);
        $SQL_log = addslashes($SQL_log);
        $stmt="INSERT INTO vicidial_admin_log set event_date=NOW(), user='$user', ip_address='$ip', event_section='CUSTOM_FIELDS', event_type='ADD', record_id='$list_id', event_code='ADMIN ADD CUSTOM LIST FIELD', event_sql=\"$SQL_log\", event_notes='';";
        $rslt=$this->Model_lib->mysql_to_mysqli($stmt,$this->Model_lib->link);
            if(sizeof($response)>0){
                //exit(json_encode($response));
            }
        
        }
    
    return $SQLexecuted;
    }
##### END add field function



    public function delete_custom_field(){
        $table_exists=0;

    $ip = getenv("REMOTE_ADDR");
    $user=$this->userdata['user'];
    $list_id=$this->input->get('list_id');
    $field_id=$this->input->get('field_id');

    $stmt="SELECT field_id,field_label,field_name,field_description,field_rank,field_help,field_type,field_options,field_size,field_max,field_default,field_cost,field_required,multi_position,name_position,field_order,field_encrypt,field_show_hide,field_duplicate from vicidial_lists_fields where list_id='$list_id' and field_id='$field_id' LIMIT 1;";
        $query = $this->db->query($stmt)->result_array();
        $field_label='';
        $field_name='';
        $field_type='';
        $field_size='5';
        $field_max='100';
        $field_options='';
        $field_default='';
        $field_description='';
        $field_rank='';
        $field_help='';
        $field_required='';
        $field_cost='';
        $multi_position='';
        $name_position='';
        $field_order='';
        $field_encrypt='';
        $field_show_hide='';
        $field_duplicate='';
        if(sizeof($query)>0)
        {
            $field_label=$query[0]['field_label'];
            $field_name=$query[0]['field_label'];
            $field_type=$query[0]['field_type'];
            $field_size=$query[0]['field_size'];
            $field_max=$query[0]['field_max'];
            $field_options=$query[0]['field_options'];
            $field_default=$query[0]['field_default'];
            $field_description=$query[0]['field_description'];
            $field_rank=$query[0]['field_rank'];
            $field_help=$query[0]['field_help'];
            $field_required=$query[0]['field_required'];
            $field_cost=$query[0]['field_cost'];
            $multi_position=$query[0]['multi_position'];
            $name_position=$query[0]['name_position'];
            $field_order=$query[0]['field_order'];
            $field_encrypt=$query[0]['field_encrypt'];
            $field_show_hide=$query[0]['field_show_hide'];
            $field_duplicate=$query[0]['field_duplicate'];
        }

    $VARDB_server=$this->Model_lib->custom->hostname;
    $VARDB_custom_user=$this->Model_lib->custom->username;
    $VARDB_custom_pass=$this->Model_lib->custom->password;
    $VARDB_database=$this->Model_lib->custom->database;
    $VARDB_port=$this->Model_lib->custom->port;

    $linkCUSTOM=mysqli_connect("$VARDB_server", "$VARDB_custom_user", "$VARDB_custom_pass", "$VARDB_database", "$VARDB_port");
    if (!$linkCUSTOM) 
        {
            //die('MySQL '._QXZ("connect ERROR").': '. mysqli_connect_error());
            $response=['status'=>false,'msg'=>'MySQL '._QXZ("connect ERROR").': '. mysqli_connect_error()];
            die(json_encode($response));
        }


    $stmt="SELECT count(*) from vicidial_lists_fields where list_id='$list_id' and field_label='$field_label';";
    $rslt=$this->Model_lib->mysql_to_mysqli($stmt, $this->Model_lib->link);
    $fieldscount_to_print = mysqli_num_rows($rslt);
    if ($fieldscount_to_print > 0) 
        {
        $rowx=mysqli_fetch_row($rslt);
        $field_exists = $rowx[0];
        }
    
    $stmt="SHOW TABLES LIKE \"custom_$list_id\";";
    $rslt=$this->Model_lib->mysql_to_mysqli($stmt, $this->Model_lib->link);
    $tablecount_to_print = mysqli_num_rows($rslt);
    if ($tablecount_to_print > 0) 
        {$table_exists =    1;}
      
    if ($field_exists < 1)
        {
            $response=['status'=>false,'msg'=>$this->Model_lib->_QXZ("Field does not exist")];
            exit(json_encode($response));
        }
    else
        {
        if ( ($table_exists < 1) and (!preg_match("/\|$field_label\|/i",$this->Model_lib->vicidial_list_fields)) )
            {
                $response=['status'=>false,'msg'=>$this->Model_lib->_QXZ("Table does not exist")];
                exit(json_encode($response));
            }
        else
            {
            ### delete field function
            $SQLsuccess = $this->delete_field_function("",$this->Model_lib->link,$linkCUSTOM,$ip,$user,$table_exists,$field_id,$list_id,$field_label,$field_name,$field_description,$field_rank,$field_help,$field_type,$field_options,$field_size,$field_max,$field_default,$field_required,$field_cost,$multi_position,$name_position,$field_order,$field_encrypt,$field_show_hide,$field_duplicate,$this->Model_lib->vicidial_list_fields);

            if ($SQLsuccess > 0)
                {
                    $response=['status'=>true,'msg'=>$this->Model_lib->_QXZ("Custom Field Deleted")];
                    exit(json_encode($response));
                }
            }
        }
    }

    function delete_field_function($DB,$link,$linkCUSTOM,$ip,$user,$table_exists,$field_id,$list_id,$field_label,$field_name,$field_description,$field_rank,$field_help,$field_type,$field_options,$field_size,$field_max,$field_default,$field_required,$field_cost,$multi_position,$name_position,$field_order,$field_encrypt,$field_show_hide,$field_duplicate,$vicidial_list_fields,$csrf="")
    {
    $SQLexecuted=0;
    $stmtCUSTOM="";
    if ( ($field_type=='DISPLAY') or ($field_type=='SCRIPT') or ($field_type=='SWITCH') or (preg_match("/\|$field_label\|/i",$vicidial_list_fields)) or ($field_duplicate=='Y') )
        {        
        $SQLexecuted++;
        }
    else
        {
        $stmtCUSTOM="ALTER TABLE custom_$list_id DROP `$field_label`;";
        $rsltCUSTOM=$this->Model_lib->mysql_to_mysqli($stmtCUSTOM, $linkCUSTOM);
        $table_update = mysqli_affected_rows($linkCUSTOM);
        if (!$rsltCUSTOM) {
            $response=['status'=>false,'msg'=>$this->Model_lib->_QXZ("Could not execute").': ' . mysqli_error(),'stmtCUSTOM'=>$stmtCUSTOM,'csrf'=>$csrf];
            ### LOG INSERTION Admin Log Table ###
            $SQL_log = "$stmt|$stmtCUSTOM";
            $SQL_log = preg_replace('/;/', '', $SQL_log);
            $SQL_log = addslashes($SQL_log);
            $stmt="INSERT INTO vicidial_admin_log set event_date=NOW(), user='$user', ip_address='$ip', event_section='CUSTOM_FIELDS', event_type='OTHER', record_id='$list_id', event_code='ADMIN DELETE CUSTOM LIST FIELD ERROR', event_sql=\"$SQL_log\", event_notes='DELETE ERROR:" . mysqli_error() . "';";
             $rslt=$this->Model_lib->mysql_to_mysqli($stmt, $this->Model_lib->link);
             //exit(json_encode($response));
            }
        else
            {$SQLexecuted++;}
        }

    if ($SQLexecuted > 0)
        {
            $stmt="DELETE FROM vicidial_lists_fields WHERE field_label='$field_label' and field_id='$field_id' and list_id='$list_id' LIMIT 1;";
            $rslt=$this->Model_lib->mysql_to_mysqli($stmt, $this->Model_lib->link);
            $field_update = mysqli_affected_rows($link);
            $response=[];
            if (!$rslt) 
            {
                $response=['status'=>false,'msg'=>$this->Model_lib->_QXZ("Could not execute").': ' . mysqli_error(),'csrf'=>$csrf];
            }
            ### LOG INSERTION Admin Log Table ###
            $SQL_log = "$stmt|$stmtCUSTOM";
            $SQL_log = preg_replace('/;/', '', $SQL_log);
            $SQL_log = addslashes($SQL_log);
            $stmt="INSERT INTO vicidial_admin_log set event_date=NOW(), user='$user', ip_address='$ip', event_section='CUSTOM_FIELDS', event_type='DELETE', record_id='$list_id', event_code='ADMIN DELETE CUSTOM LIST FIELD', event_sql=\"$SQL_log\", event_notes='';";
            $rslt=$this->Model_lib->mysql_to_mysqli($stmt, $this->Model_lib->link);
            if(sizeof($response)>0){
                //exit(json_encode($response));
            }
        }    
        return $SQLexecuted;
    }

    
}