<?php
defined('BASEPATH') OR exit('No direct script access allowed');
class Inbound_dnc extends CI_Controller {
    var $userdata = null;
    function __construct() {
        parent::__construct();
        if (!$this->Model_lib->Is_login()) {
            redirect(base_url() . 'login');
        }
        $this->Model_lib->Is_lock();
        $this->load->model('Model_login');
        $this->load->model('Model_inbounddnc');
        $this->load->library('csvimport');
        $this->userdata=$this->Model_login->Get_loggedin_user();
    }

     public function index() {
        $userdata=$this->userdata;
        $csrf = array(
                    'name' => $this->security->get_csrf_token_name(),
                    'hash' => $this->security->get_csrf_hash()
            );
        $data=array("csrf"=>$csrf);
        $this->load->view('inbound_dnc/view', compact('data','userdata'));
    }    
    
    public function add(){
        $userdata=$this->userdata;
        $csrf = array(
                    'name' => $this->security->get_csrf_token_name(),
                    'hash' => $this->security->get_csrf_hash()
            );
        $data=array("csrf"=>$csrf);
        $this->load->view('inbound_dnc/add', compact('data','userdata'));
    }   


    public function edit($id)
    {   
        $id = $this->Model_lib->DecryptionId($id);
        $userdata= $this->userdata;
        $group_data = $this->Model_inbounddnc->get($id);
        $csrf = array(
                    'name' => $this->security->get_csrf_token_name(),
                    'hash' => $this->security->get_csrf_hash()
            );
        $data= array_merge($group_data,array("csrf"=>$csrf));
        $this->load->view('inbound_dnc/edit', compact('data','userdata'));
    }

    public function save(){
        $this->load->library('form_validation');
        $this->form_validation->set_rules(
                'filter_phone_group_id', 'Group ID',
                'required|min_length[2]|max_length[20]|is_unique[vicidial_filter_phone_groups.filter_phone_group_id]|regex_match[/^[_a-zA-z0-9]+$/]',
                array(
                        'required'      => 'You have not provided %s.',
                        'is_unique'     => 'This %s already exists.',
                        'regex_match'   => 'Special characters not allowed for %s.'
                )
        );
        $this->form_validation->set_rules(
                'filter_phone_group_name', 'Group Name',
                'required|min_length[2]|max_length[40]',
                array(
                        'required'      => 'You have not provided %s.'
                )
        );
        $this->form_validation->set_rules(
                'user_group', 'User Group',
                'required',
                array(
                        'required'      => 'You have not provided %s.'
                )
        );

        if ($this->form_validation->run() == FALSE){
            $this->Model_lib->Is_lock();
            $csrf = array(
                            'name' => $this->security->get_csrf_token_name(),
                            'hash' => $this->security->get_csrf_hash()
                    );
            $error = array(
                    'filter_phone_group_id' => form_error('filter_phone_group_id'),
                    'filter_phone_group_name' => form_error('filter_phone_group_name'),
                    'user_group' => form_error('user_group')
            );            
            $data=array("csrf"=>$csrf,"error"=>$error,"status"=>false,"msg"=>"Please enter required fields.");
            exit(json_encode($data));
        }else{            
            $data=$this->Model_lib->parse_array($this->input->post());
            $insert_id=$this->Model_lib->EncryptionId($data['filter_phone_group_id']);
            if($this->Model_inbounddnc->insert($data)){                     
                $result=array("status"=>true,"msg"=>"Inbound DNC Group successfully created","insert_id"=>$insert_id);
                $this->Model_lib->admin_change_log("Inbound DNC Group","Save Inbound DNC Group","");
            }else{            
                $result=array("status"=>false,"msg"=>"unable to created Inbound DNC Group.","insert_id"=>$insert_id);
            }
            exit(json_encode($result));
        }

    }


    public function update()
    {
        $this->load->library('form_validation');
        $this->form_validation->set_rules(
                'filter_phone_group_id', 'Group ID',
                'required|min_length[2]|max_length[20]|regex_match[/^[_a-zA-z0-9]+$/]',
                array(
                        'required'      => 'You have not provided %s.',
                        'regex_match'   => 'Special characters not allowed for %s.'
                )
        );
        $this->form_validation->set_rules(
                'filter_phone_group_name', 'Group Name',
                'required|min_length[2]|max_length[40]',
                array(
                        'required'      => 'You have not provided %s.'
                )
        );
        $this->form_validation->set_rules(
                'user_group', 'User Group',
                'required',
                array(
                        'required'      => 'You have not provided %s.'
                )
        );
        if ($this->form_validation->run() == FALSE){
            $this->Model_lib->Is_lock();
            $csrf = array(
                            'name' => $this->security->get_csrf_token_name(),
                            'hash' => $this->security->get_csrf_hash()
                    );
            $error = array(
                    'filter_phone_group_id' => form_error('filter_phone_group_id'),
                    'filter_phone_group_name' => form_error('filter_phone_group_name'),
                    'user_group' => form_error('user_group')
            );            
            $data=array("csrf"=>$csrf,"error"=>$error,"status"=>false,"msg"=>"Please enter required fields.");
            exit(json_encode($data));
        }else{
             $csrf = array(
                            'name' => $this->security->get_csrf_token_name(),
                            'hash' => $this->security->get_csrf_hash()
                    );           
            $data=$this->Model_lib->parse_array($this->input->post());
            $insert_id=$this->Model_lib->EncryptionId($data['filter_phone_group_id']);
            if($this->Model_inbounddnc->update($data['filter_phone_group_id'],$data)){                     
                $result=array("status"=>true,"msg"=>"Inbound DNC Group successfully update","insert_id"=>$insert_id);
                $this->Model_lib->admin_change_log("LIST","Update List","");
            }else{            
                $result=array("status"=>false,"msg"=>"unable to update Inbound DNC Group.","insert_id"=>$insert_id,"csrf"=>$csrf);
            }
            exit(json_encode($result));
        }
    }

    public function delete($id)
    {            
        $id=$this->Model_lib->DecryptionId($id);
        $result=$this->Model_inbounddnc->remove($id);  
        if($result){
            $this->session->set_flashdata('success','Inbound DNC Group successfully deleted.');
            $this->Model_lib->admin_change_log("Inbound DNC Group","Delete Inbound DNC Group","");
            redirect(base_url('inbound/dnc_groups'));
        }else{
            $this->session->set_flashdata('error','unable to delete Inbound DNC Group.');
            redirect(base_url('inbound/dnc_groups'));
        }
    }

    public function clean($id)
    {          
        $id=$this->Model_lib->DecryptionId($id);               
        $result=$this->Model_inbounddnc->clean($id);  
        if($result){
            $this->session->set_flashdata('success','Inbound DNC Group successfully clean.');
            $this->Model_lib->admin_change_log("Inbound DNC Group","Clean Inbound DNC Group","");
            redirect(base_url('inbound/dnc_groups'));
        }else{
            $this->session->set_flashdata('error','unable to clean Inbound DNC Group.');
            redirect(base_url('inbound/dnc_groups'));
        }
    }

    public function download($id)
    {   
        $id=$this->Model_lib->DecryptionId($id);
        $this->Model_lib->admin_change_log("Inbound DNC Group","Download Inbound DNC Group","");
        $this->Model_inbounddnc->exports($id);
    }  

    public function numbers($id)
    {
        $id=$this->Model_lib->DecryptionId($id);        
        $userdata=$this->userdata;
        $csrf = array(
                    'name' => $this->security->get_csrf_token_name(),
                    'hash' => $this->security->get_csrf_hash()
            );
        $data=array("csrf"=>$csrf);
        $this->load->view('inbound_dnc/numbers', compact('data','userdata'));
    }

    public function edit_number($phone_number,$filter_phone_group_id)
    {
        $filter_phone_group_id=$this->Model_lib->DecryptionId($filter_phone_group_id);

        exit($filter_phone_group_id ." = ". $phone_number);
    }

    public function delete_number($phone_number,$filter_phone_group_id){
        $id=$this->Model_lib->DecryptionId($filter_phone_group_id);
        $result=$this->Model_inbounddnc->remove_number($id,$phone_number);
        if($result){
            $this->session->set_flashdata('success','Inbound DNC Number successfully deleted.');
            $this->Model_lib->admin_change_log("Inbound DNC Number","Delete Inbound DNC Number","");
            redirect(base_url('inbound/dnc_groups/numbers/'.$filter_phone_group_id));
        }else{
            $this->session->set_flashdata('error','unable to clean Inbound DNC Number.');
            redirect(base_url('inbound/dnc_groups/numbers/'.$filter_phone_group_id));
        }
    }
}