<?php
defined('BASEPATH') OR exit('No direct script access allowed');
class Import extends CI_Controller {
    var $userdata = null;
    function __construct() {
        parent::__construct();
        if (!$this->Model_lib->Is_login()) {
            redirect(base_url() . 'login');
        }
        $this->Model_lib->Is_lock();
        $this->load->model('Model_login');
        $this->load->model('Model_import');
        $this->load->library('csvimport');
        $this->userdata=$this->Model_login->Get_loggedin_user();
    }

    public function index() {
        $this->import();
    }
    
    public function import()
    {
        $userdata=$this->userdata;            
    	$csrf = array(
                    'name' => $this->security->get_csrf_token_name(),
                    'hash' => $this->security->get_csrf_hash()
            );
    	$data=array("csrf"=>$csrf);
    	$this->load->view('import/import', compact('data','userdata'));
    }

    public function datauploader(){
        $userdata=$this->userdata;            
        $csrf = array(
                    'name' => $this->security->get_csrf_token_name(),
                    'hash' => $this->security->get_csrf_hash()
            );
        $data=array("csrf"=>$csrf);
        $this->load->view('import/listloader', compact('data','userdata'));
    }

    public function listloader(){
        $userdata=$this->userdata;            
        $csrf = array(
                    'name' => $this->security->get_csrf_token_name(),
                    'hash' => $this->security->get_csrf_hash()
            );
        $data=array("csrf"=>$csrf);
        $this->load->view('import/listloader', compact('data','userdata'));
    }

    
   
    
    public function save()
    {   
        $success=0;
        $fail=0;
        $total=0;
        $valid_number=0;
        $duplicate_number=0;
        $chkduplicate=$this->input->post('duplicate');
        $duplicate_data=array();
        $invalid_data=array();        
        $csrf = array(
                'name' => $this->security->get_csrf_token_name(),
                'hash' => $this->security->get_csrf_hash()
        );
	$supported=true;
        $data=array();
        if(!empty($_FILES['csv_file']['name'])){
            $file_data = $this->csvimport->get_array($_FILES["csv_file"]["tmp_name"]);
	    foreach($file_data as $row)
		{   if(isset($row["phone_number"]))
                    {   
                        $phone_number=preg_replace('/[^0-9]/i', '', $row['phone_number']);
                        if ( (strlen($phone_number)<5) || (strlen($phone_number)>18) ){
                            $valid_number=strval($valid_number)+1;
                                $first_name="";
                                if(isset($row['first_name'])){
                                    $first_name=$row['first_name'];
                                }
                                $last_name="";
                                if(isset($row['last_name'])){
                                    $last_name=$row['last_name'];
                                }    
                                $email="";
                                if(isset($row['email'])){
                                    $email=$row['email'];
                                } 
                                $invalid_data[] = array(
                                    'phone_number'=>$phone_number,
                                    'list_id'=>$this->input->post('list_id'),
                                    'first_name'=>$first_name,
                                    'last_name'=>$last_name,
                                    'email'=>$email
                                );
                        }else{
                            $isfound=false;
                            if($chkduplicate=="Enabled"){
                                $isfound=$this->Model_import->isduplicate($phone_number, $this->input->post('list_id'));
                            }                            
                            if($isfound){
                                $duplicate_number=strval($duplicate_number)+1;
                                $first_name="";
                                if(isset($row['first_name'])){
                                    $first_name=$row['first_name'];
                                }
                                $last_name="";
                                if(isset($row['last_name'])){
                                    $last_name=$row['last_name'];
                                }    
                                $email="";
                                if(isset($row['email'])){
                                    $email=$row['email'];
                                } 
                                $duplicate_data[] = array(
                                    'phone_number'=>$phone_number,
                                    'list_id'=>$this->input->post('list_id'),
                                    'first_name'=>$first_name,
                                    'last_name'=>$last_name,
                                    'email'=>$email
                                );
                            }else{
                                $first_name="";
                                if(isset($row['first_name'])){
                                    $first_name=$row['first_name'];
                                }
                                $last_name="";
                                if(isset($row['last_name'])){
                                    $last_name=$row['last_name'];
                                }    
                                $email="";
                                if(isset($row['email'])){
                                    $email=$row['email'];
                                } 
                                $data= array(
                                    'phone_number'=>$phone_number,
                                    'list_id'=>$this->input->post('list_id'),
                                    'first_name'=>$first_name,
                                    'last_name'=>$last_name,
                                    'email'=>$email,
                                    'status'=>'NEW'
                                );
                                $this->Model_import->insert($data);
                                $success++;
                            }
                        }
                    }else{
                        $supported=false;
                        break;
                    }
                        $total=strval($total)+1;
		} 
            /*if($supported){
                if(sizeof($data)>0){
                   $success=$this->Model_import->insert($data);
                }                
            }*/
            $fail= strval($total)-strval($success);
            if($supported){
                $response=array("status"=>true,"csrf"=>$csrf,"msg"=>"data successfully uploaded.\n (Total: $total) (Success:$success) (Fail:$fail) (Duplicate:$duplicate_number) (Invalid:$valid_number)","duplicate_data"=>$duplicate_data,"invalid_data"=>$invalid_data);
            }else{
                $response=array("status"=>false,"csrf"=>$csrf,"msg"=>"please recheck file structure not correct");
            }
        }else{
            $response=array("status"=>false,"csrf"=>$csrf,"msg"=>"unable to upload file");
        }        
        exit(json_encode($response));
    }
    
    public function download(){
        $filename = "sample.csv"; 
        $delimiter=",";
        $array[]=array("phone_number","first_name","last_name","email");
        $array[]=array("1222222222","ABC","XYX","abc@example.com");
        $array[]=array("1222222222","XYZ","ABC","xyz@example.com");
        // open raw memory as file so no temp files needed, you might run out of memory though
    $f = fopen('php://memory', 'w'); 
    // loop over the input array
    foreach ($array as $line) { 
        // generate csv lines from the inner arrays
        fputcsv($f, $line, $delimiter); 
    }
    // reset the file pointer to the start of the file
    fseek($f, 0);
    // tell the browser it's going to be a csv file
    header('Content-Type: application/csv');
    // tell the browser we want to save it instead of displaying it
    header('Content-Disposition: attachment; filename="'.$filename.'";');
    // make php send the generated csv lines to the browser
    fpassthru($f);
    }
    
    public function add(){
        $this->load->library('form_validation');
        $this->form_validation->set_rules(
                'list_id', 'List ID',
                'required|min_length[2]|max_length[19]|regex_match[/^[_a-zA-z0-9]+$/]',
                array(
                        'required'      => 'You have not provided %s.',                        
                        'regex_match'   => 'Special characters not allowed for %s.'
                )
        );
        $this->form_validation->set_rules(
                'phone_number', 'Phone Number',
                'required|min_length[2]|max_length[19]|regex_match[/^[0-9]+$/]',
                array(
                        'required'      => 'You have not provided %s.',                        
                        'regex_match'   => 'invalid %s.'
                )
        );
        $csrf = array(
                            'name' => $this->security->get_csrf_token_name(),
                            'hash' => $this->security->get_csrf_hash()
                    );
        if ($this->form_validation->run() == FALSE){            
            $error = array(
                    'list_id' => form_error('list_id'),
                    'phone_number' => form_error('phone_number')
            );            
            $data=array("csrf"=>$csrf,"error"=>$error,"status"=>false,"msg"=>"Please enter required fields.");
            exit(json_encode($data));
        }else{
            $_POST['status']='NEW';
            $data=$this->Model_lib->parse_array($this->input->post());
            if($this->Model_import->add_lead($data)){                     
                $result=array("status"=>true,"csrf"=>$csrf,"msg"=>"Lead successfully created");
            }else{
                $error = array(
                    'error' => "unable to add lead"
                );
                $result=array("status"=>false,"error"=>$error,"csrf"=>$csrf,"msg"=>"unable to created list.");
            }
            exit(json_encode($result));
        }
    }
}