<?php
defined('BASEPATH') OR exit('No direct script access allowed');
class Groups extends CI_Controller {
        var $userInfo=null;
        function __construct()
        {
           parent::__construct();    
           if(!$this->Model_lib->Is_login()){
               redirect(base_url().'login');
           }
           $this->Model_lib->Is_lock();           
           $this->load->model('Model_login');
           $this->load->model('Model_groups');
           $this->userInfo=$this->Model_login->Get_loggedin_user();
        }
        
        public function create()
        {
            redirect('groups#add');
        }

        public  function view(){
            $this->index();
        }

        public function index()
    	{            

                //$this->Model_lib->Is_lock("User Groups_View");
                $userdata=$this->Model_login->Get_loggedin_user();  

                

                $this->load->model('Model_groups');
                $data=$this->Model_groups->getGroups($userdata['user_group']);
                $this->load->view('user_group/view', compact('data','userdata')); 
    	}
        
        public function add(){
                //$this->Model_lib->Is_lock("User Groups_Add");
                $userdata=$this->Model_login->Get_loggedin_user();
                $csrf = array(
                            'name' => $this->security->get_csrf_token_name(),
                            'hash' => $this->security->get_csrf_hash()
                    );
                $data=array("csrf"=>$csrf);
                $campaigns=$this->Model_lib->GetCampaigns($userdata['user_group']);                
            if ($this->input->server('REQUEST_METHOD') == 'POST') {              
                $user_group=$this->Model_lib->cleanID($this->input->post('user_group'));                
                $group_name= $this->Model_lib->cleanNames($this->input->post('group_name'));
                $group_shifts=$this->input->post('group_shifts');
                $forced_timeclock_login=$this->input->post('forced_timeclock_login');
                $shift_enforcement=$this->input->post('shift_enforcement');
                $admin_viewable_call_times=$this->input->post('admin_viewable_call_times');
                $allowed_campaigns=$this->input->post('allowed_campaigns');
                $agent_call_log_view=$this->input->post('agent_call_log_view');
                $concurrent=$this->input->post('concurrent');
                $concurrent=(int)$concurrent;

                //$permissions=$this->input->post('permissions');
                // $allowpermissions="";
                // for($i=0;$i<sizeof($permissions);$i++){
                //     $allowpermissions.=$permissions[$i].",";
                // }
                // $allowpermissions=rtrim($allowpermissions,",");
                // for($i=0;$i<sizeof($campaigns);$i++){
                //     $allowed_campaigns.=" ".$campaigns[$i]." ";
                // }
                // if($allowed_campaigns!=""){
                //     $allowed_campaigns.=" -";
                // }

                if( strval($this->userInfo['user_level'])>=9 ){
                    $tabledata=array("user_group"=>$user_group,"group_name"=>$group_name,"group_shifts"=>$group_shifts,"admin_viewable_call_times"=>$admin_viewable_call_times,"allowed_campaigns"=>$allowed_campaigns,"shift_enforcement"=>$shift_enforcement,"forced_timeclock_login"=>$forced_timeclock_login,"agent_call_log_view"=>$agent_call_log_view,'concurrent'=>$concurrent);
                }else{
                    $tabledata=array("user_group"=>$user_group,"group_name"=>$group_name,"group_shifts"=>$group_shifts,"admin_viewable_call_times"=>$admin_viewable_call_times,"allowed_campaigns"=>$allowed_campaigns,"shift_enforcement"=>$shift_enforcement,"forced_timeclock_login"=>$forced_timeclock_login,"agent_call_log_view"=>$agent_call_log_view);
                }
                
                    
                    $this->load->library('form_validation');
                    $this->form_validation->set_rules(
                            'user_group', 'Group ID',
                            'required|min_length[2]|max_length[50]|is_unique[vicidial_user_groups.user_group]|regex_match[/^[_a-zA-z0-9]+$/]',
                            array(
                                    'required'      => $this->Model_lib->_QXZ("You have not provided").' %s.',
                                    'is_unique'     => $this->Model_lib->_QXZ("This %s already exists."),
                                    'regex_match'   => $this->Model_lib->_QXZ("Special characters not allowed for") .' %s.'
                            )
                    );
                    $this->form_validation->set_rules(
                            'group_name', $this->Model_lib->_QXZ("Group Name"),
                            'required|min_length[2]|max_length[50]',
                            array(
                                    'required'=>$this->Model_lib->_QXZ("You have not provided").'%s.'                                  
                            )
                    );                    
                    if ($this->form_validation->run() == FALSE){
                        $errors = $this->form_validation->error_array();
                        $data=array("status"=>false,"csrf"=>$csrf,"errors"=>$errors);
                        exit(json_encode($data));
                    }else{                
                        if($this->Model_groups->insert($tabledata)){
                           $this->Model_lib->admin_change_log("USER GROUP","Add User Group","");
                           $data=array("status"=>true,"csrf"=>$csrf,"message"=>$this->Model_lib->_QXZ("User Group successfully created."));
                           exit(json_encode($data));     
                        }else{
                           $errors=array("error"=>$this->Model_lib->_QXZ("unable to created user group."));
                           $data=array("status"=>false,"csrf"=>$csrf,"errors"=>$errors);
                           exit(json_encode($data));
                        } 
                    }
            }else{               
                $this->load->view('user_group/add', compact('data','userdata','campaigns'));
            }
        }
        
        
        public function edit($id=""){
            //$this->Model_lib->Is_lock("User Groups_Edit");
            $user_code=$id;             
            $id=$this->Model_lib->DecryptionId($id);
            $groups=$this->Model_groups->getGroup($id);
            if(sizeof($groups)>0)
            {
                $userdata=$this->Model_login->Get_loggedin_user();
                $csrf = array(
                            'name' => $this->security->get_csrf_token_name(),
                            'hash' => $this->security->get_csrf_hash()
                    );
                $data=array("csrf"=>$csrf);
                $campaigns=$this->Model_lib->GetCampaigns($userdata['user_group']);
                $groups=$groups[0];
                $this->load->view('user_group/edit', compact('data','userdata','campaigns','groups','user_code'));
            }else{
                redirect(base_url('user/groups'));
            }       
        }

        public function update(){
                //$this->Model_lib->Is_lock("User Groups_Edit");
                $userdata=$this->Model_login->Get_loggedin_user();
                $csrf = array(
                            'name' => $this->security->get_csrf_token_name(),
                            'hash' => $this->security->get_csrf_hash()
                    );
                $data=array("csrf"=>$csrf);
                $campaigns=$this->Model_lib->GetCampaigns($userdata['user_group']);
                
            if ($this->input->server('REQUEST_METHOD') == 'POST') {
                $user_group=$this->Model_lib->DecryptionId($this->input->post('user_group'));      
                $user_group=$this->Model_lib->cleanID($user_group);

                $groups=$this->Model_groups->getGroup($user_group);
                if(sizeof($groups)==0)
                {
                    $errors=array("error"=>"User Group not found!");
                    $data=array("status"=>false,"csrf"=>$csrf,"errors"=>$errors);
                    exit(json_encode($data));
                }

                $group_name= $this->Model_lib->cleanNames($this->input->post('group_name'));
                $forced_timeclock_login=$this->input->post('forced_timeclock_login');
                $shift_enforcement=$this->input->post('shift_enforcement');
                $agent_call_log_view=$this->input->post('agent_call_log_view');
                $concurrent=$this->input->post('concurrent');
                $concurrent=(int)$concurrent;


                // $permissions=$this->input->post('permissions');
                // $allowpermissions="";
                // for($i=0;$i<sizeof($permissions);$i++){
                //     $allowpermissions.=$permissions[$i].",";
                // }
                // $allowpermissions=rtrim($allowpermissions,",");  

                $allowed_campaigns="";
                $campaigns=$this->input->post('campaigns');
                for($i=0;$i<sizeof($campaigns);$i++){
                    $allowed_campaigns.=" ".trim($campaigns[$i])." ";
                }
                if($allowed_campaigns!=""){
                    $allowed_campaigns.=" -";
                }

                $agent_status_viewable_groups="";
                $agent_status_viewable_groups_array=$this->input->post('agent_status_viewable_groups');
                for($i=0;$i<sizeof($agent_status_viewable_groups_array);$i++)
                {
                    $agent_status_viewable_groups.=" ".trim($agent_status_viewable_groups_array[$i])." ";
                }
                if($agent_status_viewable_groups!=""){
                    $agent_status_viewable_groups.=" -";
                }

                $admin_viewable_groups="";
                $admin_viewable_groups_array=$this->input->post('admin_viewable_groups');
                for($i=0;$i<sizeof($admin_viewable_groups_array);$i++)
                {
                    $admin_viewable_groups.=" " .trim($admin_viewable_groups_array[$i]). " ";
                }
                if($admin_viewable_groups!=""){
                    $admin_viewable_groups.=" -";
                }

                $agent_allowed_chat_groups="";
                $agent_allowed_chat_groups_array=$this->input->post('agent_allowed_chat_groups');
                for($i=0;$i<sizeof($agent_allowed_chat_groups_array);$i++)
                {
                    $agent_allowed_chat_groups.= " ".trim($agent_allowed_chat_groups_array[$i]). " ";
                }
                if($agent_allowed_chat_groups!=""){
                    $agent_allowed_chat_groups.=" -";
                }

                
                if( strval($this->userInfo['user_level'])>=9 ){
                    $tabledata=array("user_group"=>$user_group,"group_name"=>$group_name,"allowed_campaigns"=>$allowed_campaigns,"forced_timeclock_login"=>$forced_timeclock_login,"shift_enforcement"=>$shift_enforcement,"agent_status_viewable_groups"=>$agent_status_viewable_groups,"admin_viewable_groups"=>$admin_viewable_groups,"agent_allowed_chat_groups"=>$agent_allowed_chat_groups,"agent_call_log_view"=>$agent_call_log_view,'concurrent'=>$concurrent);
                }else{
                    $tabledata=array("user_group"=>$user_group,"group_name"=>$group_name,"allowed_campaigns"=>$allowed_campaigns,"forced_timeclock_login"=>$forced_timeclock_login,"shift_enforcement"=>$shift_enforcement,"agent_status_viewable_groups"=>$agent_status_viewable_groups,"admin_viewable_groups"=>$admin_viewable_groups,"agent_allowed_chat_groups"=>$agent_allowed_chat_groups,"agent_call_log_view"=>$agent_call_log_view);
                }


                    $this->load->library('form_validation');
                    $this->form_validation->set_rules(
                            'user_group', $this->Model_lib->_QXZ("Group ID"),
                            'required|min_length[2]|max_length[50]',
                            array(
                                    'required'      => $this->Model_lib->_QXZ("You have not provided").' %s.',
                                    'is_unique'     => $this->Model_lib->_QXZ("This %s already exists.")
                            )
                    );
                    $this->form_validation->set_rules(
                            'group_name', $this->Model_lib->_QXZ("Group Name"),
                            'required|min_length[2]|max_length[50]',
                            array(
                                    'required'      => $this->Model_lib->_QXZ("You have not provided").' %s.'                                    
                            )
                    );
                    $groups=$this->Model_groups->getGroup($user_group);
                    $groups=$groups[0];
                    if ($this->form_validation->run() == FALSE){                        
                        $errors = $this->form_validation->error_array();
                        $data=array("status"=>false,"csrf"=>$csrf,"errors"=>$errors);
                        exit(json_encode($data));
                    }else{
                        if($this->Model_groups->change($tabledata,$user_group)){                           
                           $this->Model_lib->admin_change_log("USER GROUP","Update User Group","");
                           $data=array("status"=>true,"csrf"=>$csrf,"message"=>$this->Model_lib->_QXZ("User Group successfully updated."));
                           exit(json_encode($data));     
                        }else{
                           $errors=array("error"=>$this->Model_lib->_QXZ("unable to update user group."));
                           $data=array("status"=>false,"csrf"=>$csrf,"errors"=>$errors);
                           exit(json_encode($data));
                        } 
                    }
            }else{               
                $this->load->view('user_group/edit', compact('data','userdata','campaigns'));
            }
        }
        
        
        public function delete($id="")
        {   //$this->Model_lib->Is_lock("User Groups_Delete");                      
            $id=$this->Model_lib->DecryptionId($id);          
            $result=$this->Model_groups->remove($id);  
            if($result){
                $this->session->set_flashdata('success',$this->Model_lib->_QXZ("Account successfully deleted."));
                $this->Model_lib->admin_change_log("USER GROUP","Delete User Group","");
                redirect(base_url('user/groups'));
            }else{
                $this->session->set_flashdata('error',$this->Model_lib->_QXZ("Unable to delete account."));
                redirect(base_url('user/groups'));
            }            
        }

        public function callbacks($id="")
        {
            $id=$this->Model_lib->DecryptionId($id);
            $this->Model_groups->group_callbacks($id);            
        }

        public function delete_callbacks()
        {   $csrf = array(
                            'name' => $this->security->get_csrf_token_name(),
                            'hash' => $this->security->get_csrf_hash()
                    );
            $user_group=$this->Model_lib->DecryptionId($this->input->post('user_group'));
            $user_group=$this->Model_lib->cleanID($user_group);
            $code=$this->input->post('code');
                $groups=$this->Model_groups->getGroup($user_group);
                if(sizeof($groups)==0)
                {
                    $errors=array("error"=>"User Group not found!");
                    $data=array("status"=>false,"csrf"=>$csrf,"errors"=>$errors);
                    exit(json_encode($data));
                }
            $this->Model_groups->delete_callbacks($user_group,$code,$csrf);    

        }

        public function export_users($user_group)
        {   $user_group=$this->Model_lib->DecryptionId($user_group);
            $this->Model_groups->export_users($user_group);
        }
}