<?php
defined('BASEPATH') OR exit('No direct script access allowed');
class Gateway extends CI_Controller {
        var $userdata = null;
        function __construct()
        {
           parent::__construct();    
           if(!$this->Model_lib->Is_login()){
               redirect(base_url().'login');
           }                    
           $this->load->model('Model_gateway');
           $this->load->model('Model_login');
           $this->userdata=$this->Model_login->Get_loggedin_user();
        }
        
        public function index()
        {
            $this->view();
        }
        
        public function view(){
            $userdata = $this->userdata;
            $this->load->view('gateway/view', compact('userdata'));
        }
        
        public function add(){
            $userdata=$this->userdata;            
            $csrf = array(
                    'name' => $this->security->get_csrf_token_name(),
                    'hash' => $this->security->get_csrf_hash()
            );
            $data=array("csrf"=>$csrf);
            $this->load->view('gateway/add', compact('data','userdata'));
        }
        
        public function edit($id){
            $this->Model_lib->Is_lock(); 
            $id = $this->Model_lib->DecryptionId($id);
            $userdata= $this->userdata;
            $list_data = $this->Model_gateway->get($id);
            $csrf = array(
                        'name' => $this->security->get_csrf_token_name(),
                        'hash' => $this->security->get_csrf_hash()
                );
            $data= array_merge($list_data,array("csrf"=>$csrf));
            $this->load->view('gateway/edit', compact('data','userdata'));
        }
        
        public function save(){
            $this->load->library('form_validation');
            $this->form_validation->set_rules(
                    'gateway_id', 'Gateway ID',
                    'required|min_length[2]|max_length[15]|is_unique[tbl_gateway.gateway_id]|regex_match[/^[_0-9]+$/]',
                    array(
                            'required'      => 'You have not provided %s.',
                            'is_unique'     => 'This %s already exists.',
                            'regex_match'   => 'Special characters not allowed for %s.'
                    )
            );
            $this->form_validation->set_rules(
                    'name', 'Name',
                    'required|min_length[2]|max_length[30]|is_unique[tbl_gateway.name]|regex_match[/^[_a-zA-z0-9]+$/]|differs[gateway_id]',
                    array(
                            'required'      => 'You have not provided %s.',
                            'is_unique'     => 'This %s already exists.',
                            'regex_match'   => 'Special characters not allowed for %s.'
                    )
            );
            //|regex_match[/^([0-9]{1,3}\.){3}[0-9]{1,3}$/]
        $this->form_validation->set_rules(
                'host', 'Host',
                'required',
                array(
                        'required'      => 'You have not provided %s.',
                        'regex_match'   => 'Invalid %s address.'
                )
        );
        
            if($this->input->post('auth_type')=="USER")
            {
                $this->form_validation->set_rules(
                        'username', 'Username',
                        'required|min_length[2]|max_length[100]',
                        array(
                                'required'      => 'You have not provided %s.'
                        )
                );
                $this->form_validation->set_rules(
                        'secret', 'Secret',
                        'required|min_length[2]|max_length[100]',
                        array(
                                'required'      => 'You have not provided %s.'
                        )
                );
            }
            
        if ($this->form_validation->run() == FALSE){
                $this->Model_lib->Is_lock();
                $csrf = array(
                                'name' => $this->security->get_csrf_token_name(),
                                'hash' => $this->security->get_csrf_hash()
                        );
                $error = array(
                        'gateway_id' => form_error('gateway_id'),
                        'name' => form_error('name'),
                        'host' => form_error('host'),
                        'username'=> form_error('username'),
                        'secret' => form_error('secret')
                );            
                $data=array("csrf"=>$csrf,"error"=>$error,"status"=>false,"msg"=>"Please enter required fields.");
                exit(json_encode($data));
            }else{
                $data=$this->Model_lib->parse_array($this->input->post());
                $insert_id=$this->Model_lib->EncryptionId($data['gateway_id']);
                if($this->Model_gateway->insert($data)){                     
                    $result=array("status"=>true,"msg"=>"Gateway successfully created","insert_id"=>$insert_id);
                    $this->Model_lib->admin_change_log("Gateway","Add Gateway","");
                }else{            
                    $result=array("status"=>false,"msg"=>"unable to created Gateway.","insert_id"=>$insert_id);
                }
                exit(json_encode($result));
            }
        }

        function check_gateway($name) {        
        if($this->input->post('gateway_id'))
            $gateway_id = $this->input->post('gateway_id');
        else
            $gateway_id = '';
        $result = $this->Model_gateway->check_unique_gatway($gateway_id, $name);
        if($result == 0)
            $response = true;
        else {
            $this->form_validation->set_message('check_gateway', 'Gateway must be unique');
            $response = false;
        }
        return $response;
    }
        
        public function update(){
            $data=$this->Model_lib->parse_array($this->input->post());
            $gateway_id=$data['gateway_id'];


            $this->load->library('form_validation');
            $this->form_validation->set_rules(
                    'gateway_id', 'Gateway ID',
                    'required|min_length[2]|max_length[15]|regex_match[/^[_0-9]+$/]',
                    array(
                            'required'      => 'You have not provided %s.',                            
                            'regex_match'   => 'Special characters not allowed for %s.'
                    )
            );
            $this->form_validation->set_rules(
                    'name', 'Name',
                    'required|min_length[2]|max_length[30]|callback_check_gateway|regex_match[/^[_a-zA-z0-9]+$/]|differs[gateway_id]',
                    array(
                            'required'      => 'You have not provided %s.',
                            'is_unique'     => 'This %s already exists.',
                            'regex_match'   => 'Special characters not allowed for %s.'
                    )
            );
            //|regex_match[/^([0-9]{1,3}\.){3}[0-9]{1,3}$/]
        $this->form_validation->set_rules(
                'host', 'Host',
                'required',
                array(
                        'required'      => 'You have not provided %s.',
                        'regex_match'   => 'Invalid %s address.'
                )
        );
        
            if($this->input->post('auth_type')=="USER")
            {
                $this->form_validation->set_rules(
                        'username', 'Username',
                        'required|min_length[2]|max_length[100]',
                        array(
                                'required'      => 'You have not provided %s.'
                        )
                );
                $this->form_validation->set_rules(
                        'secret', 'Secret',
                        'required|min_length[2]|max_length[100]',
                        array(
                                'required'      => 'You have not provided %s.'
                        )
                );
            }
        if ($this->form_validation->run() == FALSE){
            $this->Model_lib->Is_lock();
            $csrf = array(
                            'name' => $this->security->get_csrf_token_name(),
                            'hash' => $this->security->get_csrf_hash()
                    );
            $error = array(
                        'gateway_id' => form_error('gateway_id'),
                        'name' => form_error('name'),
                        'host' => form_error('host'),
                        'username'=> form_error('username'),
                        'secret' => form_error('secret')
                );            
            $data=array("csrf"=>$csrf,"error"=>$error,"status"=>false,"msg"=>"Please enter required fields.");
            exit(json_encode($data));
        }else{
             $csrf = array(
                            'name' => $this->security->get_csrf_token_name(),
                            'hash' => $this->security->get_csrf_hash()
                    );            
            $data=$this->Model_lib->parse_array($this->input->post());
            $insert_id=$this->Model_lib->EncryptionId($data['gateway_id']);
            if($this->Model_gateway->update($data['gateway_id'],$data)){                     
                $result=array("status"=>true,"msg"=>"Gateway successfully update","insert_id"=>$insert_id);
                $this->Model_lib->admin_change_log("Gateway","Update Gateway","");
            }else{            
                $result=array("status"=>false,"msg"=>"unable to update Gateway.","insert_id"=>$insert_id,"csrf"=>$csrf);
            }
            exit(json_encode($result));
        }
    }

     
    
    public function delete($id)
    {
        $this->Model_lib->Is_lock();            
        $id=$this->Model_lib->DecryptionId($id);
        $this->load->model('Model_gateway');        
        $result=$this->Model_gateway->remove($id);  
        if($result){
            $this->session->set_flashdata('success','Gateway successfully deleted.');
            $this->Model_lib->admin_change_log("Gateway","Delete Gateway","");
            redirect(base_url('settings/gateway'));
        }else{
            $this->session->set_flashdata('error','unable to delete Gateway.');
            redirect(base_url('settings/gateway'));
        }
    }
        
}