<?php
defined('BASEPATH') OR exit('No direct script access allowed');
class Firewall extends CI_Controller {
        var $userdata = null;
        function __construct()
        {
           parent::__construct();    
           if(!$this->Model_lib->Is_login()){
               redirect(base_url().'login');
           }                    
           $this->load->model('Model_firewall');
           $this->load->model('Model_login');
           $this->userdata=$this->Model_login->Get_loggedin_user();
        }
        
        public function index()
        {
            $this->view();
        }
        
        public function view(){
            $userdata = $this->userdata;
            $this->load->view('firewall/view', compact('userdata'));
        }
        
         public function add(){
            $userdata=$this->userdata;            
            $csrf = array(
                    'name' => $this->security->get_csrf_token_name(),
                    'hash' => $this->security->get_csrf_hash()
            );
            $data=array("csrf"=>$csrf);
            $this->load->view('firewall/add', compact('data','userdata'));
        }
        
        
        public function save(){
            $this->load->library('form_validation');
             $this->form_validation->set_rules(
                    'ip', 'Server IP',
                    'required|regex_match[/^([0-9]{1,3}\.){3}[0-9]{1,3}$/]',
                    array(
                            'required'      => 'You have not provided %s.',
                            'regex_match'   => 'Invalid %s address.'
                    )
            );
            $this->form_validation->set_rules(
                    'notes', 'Description',
                    'required|min_length[2]|max_length[255]',
                    array(
                            'required'      => 'You have not provided %s.'
                    )
            );
            
            
                if ($this->form_validation->run() == FALSE){
                    $this->Model_lib->Is_lock();
                    $csrf = array(
                                    'name' => $this->security->get_csrf_token_name(),
                                    'hash' => $this->security->get_csrf_hash()
                            );
                    $error = array(
                            'ip' => form_error('ip'),
                            'notes' => form_error('notes')
                    );            
                    $data=array("csrf"=>$csrf,"error"=>$error,"status"=>false,"msg"=>"Please enter required fields.");
                    exit(json_encode($data));
                }else{
                    $username = $_SESSION['username'];
                    $_POST['portal_user'] = $username;
                    $data=$this->Model_lib->parse_array($this->input->post());
                    $isduplicate = $this->Model_firewall->checkDuplicateIP($data['ip']);
                    $error = array(
                            'ip' => "Server ip already exist"
                    );
                    if($isduplicate == FALSE) {
                        $csrf = array(
                                    'name' => $this->security->get_csrf_token_name(),
                                    'hash' => $this->security->get_csrf_hash()
                            );
                        $data=array("csrf"=>$csrf,"error"=>$error,"status"=>false,"msg"=>"Please enter required fields.");
                        exit(json_encode($data));
                    } else {
                        if($this->Model_firewall->insert($data)){                     
                            $result=array("status"=>true,"msg"=>"IP successfully added");
                            $this->Model_lib->admin_change_log("Firewall","Add Firewall","");
                        }else{            
                            $result=array("status"=>false,"msg"=>"unable to add IP.");
                        }
                        exit(json_encode($result));
                    }
                }
        }
        
        
    public function delete($id)
    {
        $this->Model_lib->Is_lock();            
        $id=$this->Model_lib->DecryptionId($id);             
        $result=$this->Model_firewall->remove($id);  
        if($result){
            $this->session->set_flashdata('success','Firewall IP successfully deleted.');
            $this->Model_lib->admin_change_log("Firewall","Delete Firewall","");
            redirect(base_url('settings/firewall'));
        }else{
            $this->session->set_flashdata('error','unable to delete Firewall IP.');
            redirect(base_url('settings/firewall'));
        }
    }
        
}