<?php
defined('BASEPATH') OR exit('No direct script access allowed');
class Filter  extends CI_Controller {
        var $userdata=null;
        var $csrf=null; 
        function __construct()
        {
           parent::__construct();    
           if(!$this->Model_lib->Is_login()){
               redirect(base_url().'login');
           }                  
           $this->load->model('Model_login');
           $this->load->model('Model_filter');
           $this->userdata=$this->Model_login->Get_loggedin_user();           
        }       

      public function index(){
        $userdata=$this->userdata;
        $csrf = array(
                      'name' => $this->security->get_csrf_token_name(),
                      'hash' => $this->security->get_csrf_hash()
              );            
        $data=array("csrf"=>$csrf);
        $this->load->view('filter/index', compact('data','userdata'));
      }  


      public function add(){
      	$userdata=$this->userdata;
        $csrf = array(
                      'name' => $this->security->get_csrf_token_name(),
                      'hash' => $this->security->get_csrf_hash()
              );            
        $data=array("csrf"=>$csrf);
        $this->load->view('filter/add', compact('data','userdata'));
      }

      public function edit($id)
      {
        $id = $this->Model_lib->DecryptionId($id);
        $queue_data = $this->Model_filter->get($id);
        $csrf = array(
                    'name' => $this->security->get_csrf_token_name(),
                    'hash' => $this->security->get_csrf_hash()
            );
        $data= array_merge($queue_data,array("csrf"=>$csrf));
        $userdata=$this->userdata;
        $this->load->view('filter/edit', compact('data','userdata'));

      }

       public function modify()
      {
                $this->load->library('form_validation');
                $csrf = array(
                        'name' => $this->security->get_csrf_token_name(),
                        'hash' => $this->security->get_csrf_hash()
                );
                $lead_filter_id=$this->Model_lib->CheckFilterID($this->input->post('lead_filter_id'),$csrf);
                $_POST['lead_filter_id']=$lead_filter_id;  

                $this->form_validation->set_rules('lead_filter_id', 'Filter ID', 'required|min_length[2]|max_length[20]|regex_match[/^[_a-zA-z0-9]+$/]',
                        array(
                                'required'      => $this->Model_lib->_QXZ("You have not provided").' %s.',
                                'regex_match'   => $this->Model_lib->_QXZ("Special characters not allowed for").' %s.'
                        )
                );

               $this->form_validation->set_rules(
                        'lead_filter_name', $this->Model_lib->_QXZ("Filter Name"),
                        'required|min_length[2]|max_length[30]',
                        array(
                            'required'      => $this->Model_lib->_QXZ("You have not provided").' %s.'                                    
                        )
                );

                if ($this->form_validation->run() == FALSE){            
                  $errors = $this->form_validation->error_array();
                  $data=array("status"=>false,"csrf"=>$csrf,"errors"=>$errors);
                  exit(json_encode($data));
                }else{
                    $result=$this->Model_filter->update($this->input->post(),$lead_filter_id);
                    if($result){
                        $data=array("status"=>true,"csrf"=>$csrf,"message"=>$this->Model_lib->_QXZ("Filter successfully updated."));
                       exit(json_encode($data));
                    }else{
                       $errors=array("error"=>$this->Model_lib->_QXZ("Unable to update Filter."));
                       $data=array("status"=>false,"csrf"=>$csrf,"errors"=>$errors);
                       exit(json_encode($data));
                    }
                }
      }     

      public function save(){
	      	$this->load->library('form_validation');
	        $csrf = array(
	                'name' => $this->security->get_csrf_token_name(),
	                'hash' => $this->security->get_csrf_hash()
	        );
	        
	        $this->form_validation->set_rules('lead_filter_id', 'Filter ID', 'required|is_unique[vicidial_lead_filters.lead_filter_id]|min_length[2]|max_length[20]|regex_match[/^[_a-zA-z0-9]+$/]',
	                array(
	                        'required'      => $this->Model_lib->_QXZ("You have not provided").' %s.',
	                        'regex_match'   => $this->Model_lib->_QXZ("Special characters not allowed for").' %s.'
	                )
	        );

	       $this->form_validation->set_rules(
	                'lead_filter_name', $this->Model_lib->_QXZ("Filer Name"),
	                'required|min_length[2]|max_length[30]',
	                array(
	                    'required'      => $this->Model_lib->_QXZ("You have not provided").' %s.'                                    
	                )
	        );	        

	        if ($this->form_validation->run() == FALSE){            
	          $errors = $this->form_validation->error_array();
	          $data=array("status"=>false,"csrf"=>$csrf,"errors"=>$errors);
	          exit(json_encode($data));
	        }else{
	            $result=$this->Model_filter->insert($this->input->post());
	            if($result){
	                $data=array("status"=>true,"csrf"=>$csrf,"message"=>$this->Model_lib->_QXZ("Filter successfully created."));
	               exit(json_encode($data));
	            }else{
	               $errors=array("error"=>$this->Model_lib->_QXZ("unable to created Filter."));
	               $data=array("status"=>false,"csrf"=>$csrf,"errors"=>$errors);
	               exit(json_encode($data));
	            }
	        }
      }
}