<?php
defined('BASEPATH') OR exit('No direct script access allowed');
class Dnc extends CI_Controller {
    var $userdata = null;
    function __construct() {
        parent::__construct();
        if (!$this->Model_lib->Is_login()) {
            redirect(base_url() . 'login');
        }
        $this->Model_lib->Is_lock();
        $this->load->model('Model_login');
        $this->load->model('Model_dnc');
        $this->load->library('csvimport');
        $this->userdata=$this->Model_login->Get_loggedin_user();
    }

    public function index() {
        $this->import();
    }
    
    public function import()
    {
        $userdata=$this->userdata;        
        
	$csrf = array(
                'name' => $this->security->get_csrf_token_name(),
                'hash' => $this->security->get_csrf_hash()
        );
	$data=array("csrf"=>$csrf);
	$this->load->view('dnc/index', compact('data','userdata'));
    }
    
    public function save()
    {   
        $success=0;
        $fail=0;
        $total=0;
        $valid_number=0;
        $duplicate_number=0;
        $chkduplicate="Enabled";//$this->input->post('duplicate');
        $duplicate_data=array();
        $invalid_data=array();        
        $csrf = array(
                'name' => $this->security->get_csrf_token_name(),
                'hash' => $this->security->get_csrf_hash()
        );
	$supported=true;
        $data=array();
        if(!empty($_FILES['csv_file']['name'])){
            $file_data = $this->csvimport->get_array($_FILES["csv_file"]["tmp_name"]);
	    foreach($file_data as $row)
		{   if(isset($row["phone_number"]))
                    {   
                        $phone_number=preg_replace('/[^0-9]/i', '', $row['phone_number']);
                        if ( (strlen($phone_number)<5) || (strlen($phone_number)>18) ){
                            $valid_number=strval($valid_number)+1;
                                $first_name="";
                                if(isset($row['first_name'])){
                                    $first_name=$row['first_name'];
                                }
                                $last_name="";
                                if(isset($row['last_name'])){
                                    $last_name=$row['last_name'];
                                }    
                                $email="";
                                if(isset($row['email'])){
                                    $email=$row['email'];
                                } 
                                $invalid_data[] = array(
                                    'phone_number'=>$phone_number,
                                    'campaign_id'=>$this->input->post('dnc_campaign'),
                                    'user'=>$this->userdata['user']
                                );
                        }else{
                            $isfound=false;
                            if($chkduplicate=="Enabled"){
                                $isfound=$this->Model_dnc->isduplicate($phone_number, $this->input->post('dnc_campaign'));
                            }                            
                            if($isfound){
                                $duplicate_number=strval($duplicate_number)+1;
                                $first_name="";
                                if(isset($row['first_name'])){
                                    $first_name=$row['first_name'];
                                }
                                $last_name="";
                                if(isset($row['last_name'])){
                                    $last_name=$row['last_name'];
                                }    
                                $email="";
                                if(isset($row['email'])){
                                    $email=$row['email'];
                                } 
                                $duplicate_data[] = array(
                                    'phone_number'=>$phone_number,
                                    'campaign_id'=>$this->input->post('dnc_campaign'),
                                    'user'=>$this->userdata['user']
                                );
                            }else{
                                $first_name="";
                                if(isset($row['first_name'])){
                                    $first_name=$row['first_name'];
                                }
                                $last_name="";
                                if(isset($row['last_name'])){
                                    $last_name=$row['last_name'];
                                }    
                                $email="";
                                if(isset($row['email'])){
                                    $email=$row['email'];
                                } 
                                $data= array(
                                    'phone_number'=>$phone_number,
                                    'campaign_id'=>$this->input->post('dnc_campaign'),
                                    'user'=>$this->userdata['user']
                                );
                                $this->Model_dnc->insert($data);
                                $success++;
                            }
                        }
                    }else{
                        $supported=false;
                        break;
                    }
                    $total=strval($total)+1;
		}
            $fail= strval($total)-strval($success);
            if($supported){
                $response=array("status"=>true,"csrf"=>$csrf,"msg"=>"dnc numbers successfully uploaded.\n (Total: $total) (Success:$success) (Fail:$fail) (Duplicate:$duplicate_number) (Invalid:$valid_number)","duplicate_data"=>$duplicate_data,"invalid_data"=>$invalid_data);
            }else{
                $response=array("status"=>false,"csrf"=>$csrf,"msg"=>"please recheck file structure not correct");
            }
        }else{
            $response=array("status"=>false,"csrf"=>$csrf,"msg"=>"unable to upload file");
        }        
        exit(json_encode($response));
    }
    
    public function download(){
        $filename = "sample.csv"; 
        $delimiter=",";
        $array[]=array("phone_number");
        $array[]=array("1222222222");
        $array[]=array("1222222222");
        // open raw memory as file so no temp files needed, you might run out of memory though
    $f = fopen('php://memory', 'w'); 
    // loop over the input array
    foreach ($array as $line) { 
        // generate csv lines from the inner arrays
        fputcsv($f, $line, $delimiter); 
    }
    // reset the file pointer to the start of the file
    fseek($f, 0);
    // tell the browser it's going to be a csv file
    header('Content-Type: application/csv');
    // tell the browser we want to save it instead of displaying it
    header('Content-Disposition: attachment; filename="'.$filename.'";');
    // make php send the generated csv lines to the browser
    fpassthru($f);
    }
    
    public function add(){
        $this->load->library('form_validation');
        $this->form_validation->set_rules(
                'phone_number', 'Phone Number',
                'required|min_length[2]|max_length[19]|regex_match[/^[0-9]+$/]',
                array(
                        'required'      => 'You have not provided %s.',                        
                        'regex_match'   => 'invalid %s.'
                )
        );
        $csrf = array(
                            'name' => $this->security->get_csrf_token_name(),
                            'hash' => $this->security->get_csrf_hash()
                    );
        if ($this->form_validation->run() == FALSE){            
            $error = array(
                    'phone_number' => form_error('phone_number')
            );            
            $data=array("csrf"=>$csrf,"error"=>$error,"status"=>false,"msg"=>"Please enter required fields.");
            exit(json_encode($data));
        }else{
            $_POST['user']=$this->userdata['user'];
            $data=$this->Model_lib->parse_array($this->input->post());            
            $isfound=$this->Model_dnc->isduplicate($data['phone_number'], $this->input->post('campaign_id'));
            if($isfound){
                $error = array(
                        'error' => "number already exist"
                );
                $result=array("status"=>false,"error"=>$error,"csrf"=>$csrf,"msg"=>"number already exist.");
            }else{
                if($this->Model_dnc->add_lead($data,$this->input->post('campaign_id'))){                     
                    $result=array("status"=>true,"csrf"=>$csrf,"msg"=>"phone number successfully added into dnc");
                }else{
                    $error = array(
                        'error' => "unable to add lead"
                    );
                    $result=array("status"=>false,"error"=>$error,"csrf"=>$csrf,"msg"=>"unable to add number into dnc.");
                }
            }            
            exit(json_encode($result));
        }
    }
    
    public function search(){
        $csrf = array(
                            'name' => $this->security->get_csrf_token_name(),
                            'hash' => $this->security->get_csrf_hash()
                    );
        $recordhtml= $this->Model_dnc->search_dnc($this->input->post('phone_number'),$this->input->post('campaign_id'));
        $result=array("status"=>true,"csrf"=>$csrf,"msg"=>"phone number successfully added into dnc","recordhtml"=>$recordhtml);
        exit(json_encode($result));
    }
    
    public function search_get(){
        $csrf = array(
                            'name' => $this->security->get_csrf_token_name(),
                            'hash' => $this->security->get_csrf_hash()
                    );
        $recordhtml= $this->Model_dnc->search_dnc($this->input->get('phone_number'),$this->input->get('campaign_id'));
        $result=array("status"=>true,"csrf"=>$csrf,"msg"=>"phone number successfully added into dnc","recordhtml"=>$recordhtml);
        exit(json_encode($result));
    }
    
    
    public function delete($campaign_id,$phone_number){
        $this->Model_lib->Is_lock();            
        $phone_number=$this->Model_lib->DecryptionId($phone_number);              
        $result=$this->Model_dnc->remove_dnc($campaign_id,$phone_number);  
        if($result){
            $array=array("status"=>true,"msg"=>'phone number successfully deleted.');
            
        }else{
            $array=array("status"=>true,"msg"=>'unable to delete phone number from dnc list.');
            
        }        
        exit(json_encode($array));
    }
}