<?php
defined('BASEPATH') OR exit('No direct script access allowed');
class Dashboard extends CI_Controller {
    
        function __construct()
        {
           parent::__construct();    
           if(!$this->Model_lib->Is_login()){
               redirect(base_url().'login');
           }                     
           $this->load->model('Model_login');
           $this->load->model('Model_dashboard');
        }

    	public function index()
    	{            
                $userdata=$this->Model_login->Get_loggedin_user();
                $csrf = array(
                                'name' => $this->security->get_csrf_token_name(),
                                'hash' => $this->security->get_csrf_hash()
                        );
                $this->load->view('dashboard', compact('userdata','csrf'));
    	}

        public function search(){
            $csrf = array(
                        'name' => $this->security->get_csrf_token_name(),
                        'hash' => $this->security->get_csrf_hash()
                        );
            $search_query=$this->input->post('search_query');
            $this->Model_dashboard->quick_search($search_query,$csrf);
        }

        public function lead_info($id="")
        {
            $userdata=$this->Model_login->Get_loggedin_user();
            $csrf = array(
                            'name' => $this->security->get_csrf_token_name(),
                            'hash' => $this->security->get_csrf_hash()
                        );
            $data=array("lead_id"=>$this->input->get('lead_id'),'list_id'=>$this->input->get('list_id'));
            $this->load->view('lead_info', compact('userdata','csrf','data'));
        }
        
        public function change_status()
        {
            $campaign_id=$this->input->get('campaign_id');
            $active=$this->input->get('active');
            $campaign_id=$this->Model_lib->DecryptionId($campaign_id);              
            $result=$this->Model_lib->update_campaign_status($campaign_id,$active);
            if($result){
                $array=array("status"=>true,"msg"=>"Campaign Status Changed");
            }else{
                $array=array("status"=>false,"msg"=>"Unable to change status.");
            }
            $this->Model_lib->admin_change_log("CAMPAIGN","CHANGESTATUS","");
            exit(json_encode($array));
        }
        
        public function active_calls()
        {
            $campaign_id=$this->input->get('campaign_id');
            $active_calls=$this->Model_lib->get_active_calls($campaign_id,"");
            $active_calls=json_encode($active_calls);
            print_r($active_calls);
            exit();
        }
        
        public function realtime_campaigns()
        {   
            
            $camp_refresh=$this->input->get('camp_refresh');
            $campaign_id=$this->input->get('campaign_id');
            
            $camp_refresh = $camp_refresh === 'true'? true: false;
            
            if($camp_refresh){
                $campaigns=$this->Model_dashboard->get_campaigns();
            }else{
                $campaigns="";
            }
            
            $call_stats=$this->Model_dashboard->get_carrier_stats($campaign_id);
            $digit_stats=$this->Model_dashboard->get_digit_press_stats($campaign_id);
            //$channels_total=$this->Model_dashboard->get_channels_total();        
            $channels_total=$this->Model_dashboard->calls_ringing_today($campaign_id);
            $channels_total=array("channels_total"=>$channels_total,"timenow"=>date("h:i A", time()));
            $array=array("campaigns"=>$campaigns,"call_stats"=>$call_stats,"digit_stats"=>$digit_stats,"channels_total"=>$channels_total);
            exit(json_encode($array));
        }
        
        public function carriers_stats()
        {   
            $campaign_id=$this->input->get('campaign_id');
            $this->Model_lib->get_carriers_stats($campaign_id);            
        }

        public function remove_live()
        {
            $call_date=$this->input->get('call_date');
            $lead_id=$this->input->get('lead_id');
            $campaign_id=$this->input->get('campaign_id');
            $stmt="UPDATE vicidial_log set stage='HANGUP',xfer_end_date=NOW() where call_date='$call_date' and uniqueid='$lead_id'";
            $query = $this->db->query($stmt);
            $this->Model_dashboard->get_live_transfer($campaign_id);
        }

        public function header_stats()
        {
            $campaign_id=$this->input->get('campaign_id');
            $headid=$this->input->get('headid');
            if($headid=="Channels"){
                $this->Model_dashboard->get_channels();
            }elseif ($headid=="Total_Calls"){
                # code...
            }elseif ($headid=="Connected"){
                # code...
            }elseif ($headid=="Answer_Machines"){
                # code...
            }elseif ($headid=="Ringing"){                
                $this->Model_dashboard->get_ringing($campaign_id);
            }elseif ($headid=="IVR"){
                $this->Model_dashboard->get_ivr($campaign_id);
            }elseif ($headid=="Total_Xfer"){
                $this->Model_dashboard->get_total_transfer($campaign_id);
            }elseif ($headid=="Live_Xfer"){
                $this->Model_dashboard->get_live_transfer($campaign_id);
            }
        }
}