<?php
defined('BASEPATH') OR exit('No direct script access allowed');
class Calltimes extends CI_Controller {
    var $userdata = null;
    function __construct() {
        parent::__construct();
        if (!$this->Model_lib->Is_login()) {
            redirect(base_url() . 'login');
        }
        $this->Model_lib->Is_lock();
        $this->load->model('Model_login');
        $this->load->model('Model_calltimes');    
        $this->userdata=$this->Model_login->Get_loggedin_user();
    }

     public function index() {
        $userdata=$this->userdata;
        $csrf = array(
                    'name' => $this->security->get_csrf_token_name(),
                    'hash' => $this->security->get_csrf_hash()
            );
        $data=array("csrf"=>$csrf);
        $this->load->view('calltimes/view', compact('data','userdata'));
    }    
    
    public function add(){
        $userdata=$this->userdata;
        $csrf = array(
                    'name' => $this->security->get_csrf_token_name(),
                    'hash' => $this->security->get_csrf_hash()
            );
        $data=array("csrf"=>$csrf);
        $this->load->view('calltimes/add', compact('data','userdata'));
    }   


    public function edit($id)
    {   
        $id = $this->Model_lib->DecryptionId($id);
        $userdata= $this->userdata;
        $group_data = $this->Model_calltimes->get($id);
        $csrf = array(
                    'name' => $this->security->get_csrf_token_name(),
                    'hash' => $this->security->get_csrf_hash()
            );
        $data= array_merge($group_data,array("csrf"=>$csrf));
        $this->load->view('calltimes/edit', compact('data','userdata'));
    }

    public function save(){
        $this->load->library('form_validation');
        $this->form_validation->set_rules(
                'call_time_id', 'CallTime ID',
                'required|min_length[2]|max_length[10]|is_unique[vicidial_call_times.call_time_id]|regex_match[/^[-_a-zA-z0-9]+$/]',
                array(
                        'required'      => 'You have not provided %s.',
                        'is_unique'     => 'This %s already exists.',
                        'regex_match'   => 'Special characters not allowed for %s.'
                )
        );
      
        $this->form_validation->set_rules(
                'call_time_name', 'CallTime Name',
                'required|min_length[2]|max_length[100]',
                array(
                        'required'      => 'You have not provided %s.'
                )
        );
        $this->form_validation->set_rules(
                'user_group', 'User Group',
                'required',
                array(
                        'required'      => 'You have not provided %s.'
                )
        );

        if ($this->form_validation->run() == FALSE){
            $this->Model_lib->Is_lock();
            $csrf = array(
                            'name' => $this->security->get_csrf_token_name(),
                            'hash' => $this->security->get_csrf_hash()
                    );
            $error = array(
                    'call_time_id' => form_error('call_time_id'),
                    'call_time_name' => form_error('call_time_name'),
                    'user_group' => form_error('user_group')
            );            
            $data=array("csrf"=>$csrf,"error"=>$error,"status"=>false,"msg"=>"Please enter required fields.");
            exit(json_encode($data));
        }else{            
            $data=$this->Model_lib->parse_array($this->input->post());
            $insert_id=$this->Model_lib->EncryptionId($data['call_time_id']);
            if($this->Model_calltimes->insert($data)){                     
                $result=array("status"=>true,"msg"=>"CallTime successfully created","insert_id"=>$insert_id);
                $this->Model_lib->admin_change_log("CallTime","Save CallTime","");
            }else{            
                $result=array("status"=>false,"msg"=>"unable to created CallTime.","insert_id"=>$insert_id);
            }
            exit(json_encode($result));
        }

    }


    public function update()
    {
        $this->load->library('form_validation');
        $this->form_validation->set_rules(
                'call_time_id', 'CallTime ID',
                'required|min_length[2]|max_length[10]|regex_match[/^[-_a-zA-z0-9]+$/]',
                array(
                        'required'      => 'You have not provided %s.',
                        'is_unique'     => 'This %s already exists.',
                        'regex_match'   => 'Special characters not allowed for %s.'
                )
        );

        $this->form_validation->set_rules(
                'call_time_name', 'CallTime Name',
                'required|min_length[2]|max_length[100]',
                array(
                        'required'      => 'You have not provided %s.'
                )
        );
        $this->form_validation->set_rules(
                'user_group', 'User Group',
                'required',
                array(
                        'required'      => 'You have not provided %s.'
                )
        );
        if ($this->form_validation->run() == FALSE){
            $this->Model_lib->Is_lock();
            $csrf = array(
                            'name' => $this->security->get_csrf_token_name(),
                            'hash' => $this->security->get_csrf_hash()
                    );
            $error = array(
                    'call_time_id' => form_error('call_time_id'),
                    'call_time_name' => form_error('call_time_name'),
                    'user_group' => form_error('user_group')
            );            
            $data=array("csrf"=>$csrf,"error"=>$error,"status"=>false,"msg"=>"Please enter required fields.");
            exit(json_encode($data));
        }else{
             $csrf = array(
                            'name' => $this->security->get_csrf_token_name(),
                            'hash' => $this->security->get_csrf_hash()
                    );

            $ct_default_start = preg_replace('/\D/', '', $this->input->post('ct_default_start'));
            $ct_default_stop = preg_replace('/\D/', '', $this->input->post('ct_default_stop'));
            $ct_sunday_start = preg_replace('/\D/', '', $this->input->post('ct_sunday_start'));
            $ct_sunday_stop = preg_replace('/\D/', '', $this->input->post('ct_sunday_stop'));
            $ct_monday_start = preg_replace('/\D/', '', $this->input->post('ct_monday_start'));
            $ct_monday_stop = preg_replace('/\D/', '', $this->input->post('ct_monday_stop'));
            $ct_tuesday_start = preg_replace('/\D/', '', $this->input->post('ct_tuesday_start'));
            $ct_tuesday_stop = preg_replace('/\D/', '', $this->input->post('ct_tuesday_stop'));
            $ct_wednesday_start = preg_replace('/\D/', '', $this->input->post('ct_wednesday_start'));
            $ct_wednesday_stop = preg_replace('/\D/', '', $this->input->post('ct_wednesday_stop'));
            $ct_thursday_start = preg_replace('/\D/', '', $this->input->post('ct_thursday_start'));
            $ct_thursday_stop = preg_replace('/\D/', '', $this->input->post('ct_thursday_stop'));
            $ct_friday_start = preg_replace('/\D/', '', $this->input->post('ct_friday_start'));
            $ct_friday_stop = preg_replace('/\D/', '', $this->input->post('ct_friday_stop'));
            $ct_saturday_start = preg_replace('/\D/', '', $this->input->post('ct_saturday_start'));
            $ct_saturday_stop = preg_replace('/\D/', '', $this->input->post('ct_saturday_stop'));

            $data=$this->Model_lib->parse_array($this->input->post());
            $insert_id=$this->Model_lib->EncryptionId($data['call_time_id']);
            if($this->Model_calltimes->update($data['call_time_id'],$data)){                     
                $result=array("status"=>true,"msg"=>"CallTime successfully update","insert_id"=>$insert_id);
                $this->Model_lib->admin_change_log("CallTime","Update CallTime","");
            }else{            
                $result=array("status"=>false,"msg"=>"unable to update CallTime.","insert_id"=>$insert_id,"csrf"=>$csrf);
            }
            exit(json_encode($result));
        }
    }

    public function delete($id)
    {            
        $id=$this->Model_lib->DecryptionId($id);
        $result=$this->Model_calltimes->remove($id);  
        if($result){
            $this->session->set_flashdata('success','CallTime successfully deleted.');
            $this->Model_lib->admin_change_log("CallTime","Delete CallTime","");
            redirect(base_url('calltimes'));
        }else{
            $this->session->set_flashdata('error','unable to delete CallTime.');
            redirect(base_url('calltimes'));
        }
    }
    
}