<?php
defined('BASEPATH') OR exit('No direct script access allowed');
class Callmenu extends CI_Controller {
    var $userdata = null;
    function __construct() {
        parent::__construct();
        if (!$this->Model_lib->Is_login()) {
            redirect(base_url() . 'login');
        }
        $this->Model_lib->Is_lock();
        $this->load->model('Model_login');
        $this->load->model('Model_survey');
        $this->userdata = $this->Model_login->Get_loggedin_user();
        $this->link=mysqli_connect($this->db->hostname,$this->db->username,$this->db->password,$this->db->database);
    }
    
   
    public function dialplan(){
        $this->Model_survey->rebuild_survey_custom_dialplan("Press1");
    }

    public function index() {
        $this->view();
    }
    
    public function view()
    {
        $userdata = $this->userdata;
        $this->load->view('survey/view', compact('userdata'));
    }

    public function add() {        
        $userdata=$this->userdata;            
	$csrf = array(
                'name' => $this->security->get_csrf_token_name(),
                'hash' => $this->security->get_csrf_hash()
        );
	$data=array("csrf"=>$csrf);
	$this->load->view('survey/add', compact('data','userdata'));
    }
    
    public function edit($id)
    {
        $this->Model_lib->Is_lock(); 
        $id = $this->Model_lib->DecryptionId($id);
        $userdata=$this->Model_login->Get_loggedin_user();
        $survey_data = $this->Model_survey->get($id);
        $csrf = array(
                    'name' => $this->security->get_csrf_token_name(),
                    'hash' => $this->security->get_csrf_hash()
            );
        $data= array_merge($survey_data,array("csrf"=>$csrf));
        $this->load->view('survey/edit', compact('data','userdata'));
    }
    
    public function save(){
        $this->load->library('form_validation');
        $this->form_validation->set_rules(
                'menu_id', 'Menu ID',
                'required|min_length[2]|max_length[50]|is_unique[vicidial_call_menu.menu_id]|regex_match[/^[_a-zA-z0-9]+$/]',
                array(
                        'required'      => 'You have not provided %s.',
                        'is_unique'     => 'This %s already exists.',
                        'regex_match'   => 'Special characters not allowed for %s.'
                )
        );
        $this->form_validation->set_rules(
                'menu_name', 'Menu Name',
                'required|min_length[2]|max_length[100]',
                array(
                        'required'      => 'You have not provided %s.'
                )
        );                    
        if ($this->form_validation->run() == FALSE){
            $this->Model_lib->Is_lock();
            $userdata=$this->userdata;            
            $csrf = array(
                            'name' => $this->security->get_csrf_token_name(),
                            'hash' => $this->security->get_csrf_hash()
                    );
            $error = array(
                    'menu_id' => form_error('menu_id'),
                    'menu_name' => form_error('menu_name')
            );
            $result=array("status"=>false,"msg"=>"Please enter required fields.");
            $data=array("csrf"=>$csrf,"error"=>$error,"status"=>false,"msg"=>"Please enter required fields.");
            exit(json_encode($data));
    }else{
        $data=$this->Model_lib->parse_array($this->input->post());
        $insert_id=$this->Model_lib->EncryptionId($data['menu_id']);
        if($this->Model_survey->insert($data)){
            $this->Model_survey->rebuild_survey_custom_dialplan($data['menu_id']);
            $this->Model_lib->ServerRebuildConf();
            $result=array("status"=>true,"msg"=>"Menu successfully created","insert_id"=>$insert_id);
            $this->Model_lib->admin_change_log("Menu","ADD Menu","");
        }else{            
            $result=array("status"=>false,"msg"=>"unable to created Menu.","insert_id"=>$insert_id);
        }
        exit(json_encode($result));
        
    }    
    
    }
    
    
    public function update(){
        $this->load->library('form_validation');
        $this->form_validation->set_rules(
                'menu_id', 'Menu ID',
                'required|min_length[2]|max_length[50]|regex_match[/^[_a-zA-z0-9]+$/]',
                array(
                        'required'      => 'You have not provided %s.',
                        'is_unique'     => 'This %s already exists.',
                        'regex_match'   => 'Special characters not allowed for %s.'
                )
        );
        $this->form_validation->set_rules(
                'menu_name', 'Menu Name',
                'required|min_length[2]|max_length[100]',
                array(
                        'required'      => 'You have not provided %s.'
                )
        );                    
        if ($this->form_validation->run() == FALSE){
            $this->Model_lib->Is_lock();
            $userdata=$this->userdata;            
            $csrf = array(
                            'name' => $this->security->get_csrf_token_name(),
                            'hash' => $this->security->get_csrf_hash()
                    );
            $error = array(
                    'menu_id' => form_error('menu_id'),
                    'menu_name' => form_error('menu_name')
            );
            $result=array("status"=>false,"msg"=>"Please enter required fields.");
            $data=array("csrf"=>$csrf,"error"=>$error,"status"=>false,"msg"=>"Please enter required fields.");
            exit(json_encode($data));
        }else{
            $data=$this->Model_lib->parse_array($this->input->post());
            $insert_id=$this->Model_lib->EncryptionId($data['menu_id']);
            if($this->Model_survey->update($data,$data['menu_id'])){     
                $this->Model_lib->ServerRebuildConf();
                $result=array("status"=>true,"msg"=>"Menu successfully updated","insert_id"=>$insert_id,"updated"=>true);
                $this->Model_lib->admin_change_log("SURVEY","Update SURVEY","");
            }else{
                $this->Model_survey->rebuild_survey_custom_dialplan($data['menu_id']);
                $this->Model_lib->ServerRebuildConf();
                $result=array("status"=>true,"msg"=>"nothing changed into Menu.","insert_id"=>$insert_id,"updated"=>false);
            }
            exit(json_encode($result));
        }    
    }
    
    public function add_survey_options()
    {        
        $this->load->library('form_validation');
        unset($_POST['current_menu_id']);
        unset($_POST['current_option_value']);
        $csrf = array(
               'name' => $this->security->get_csrf_token_name(),
               'hash' => $this->security->get_csrf_hash()
            );
        
        $this->form_validation->set_rules(
                'option_value', 'Option',
                'required',
                array(
                        'required'      => 'You have not provided %s.'
                )
        );
        $this->form_validation->set_rules(
                'option_route', 'Route',
                'required',
                array(
                        'required'      => 'You have not provided %s.'
                )
        );
        if($this->unique_survey_options()===true)
        {                       
            $error = array(
                'menu_id' =>'Option & Route alerady exist.'
            );
            $data=array("csrf"=>$csrf,"error"=>$error,"status"=>false,"msg"=>"Please enter required fields-lucky.");
            exit(json_encode($data));
        }
        
         
        if ($this->form_validation->run() == FALSE){
            
            $error = array(
                'option_value' => form_error('option_value'),
                'option_route' => form_error('option_route')
            );
            $result=array("status"=>false,"msg"=>"Please enter required fields.");
            $data=array("csrf"=>$csrf,"error"=>$error,"status"=>false,"msg"=>"Please enter required fields.");
            exit(json_encode($data));
        }else{
            $data=$this->Model_lib->parse_array($this->input->post());
            $insert_id=$this->Model_lib->EncryptionId($data['menu_id']);
            if($this->Model_survey->insert_options($data)){
                $surveyBox=$this->Model_survey->getSurveyBox($data['menu_id'],$data['option_value']);
                $this->Model_survey->rebuild_survey_custom_dialplan($data['menu_id']);
                $this->Model_lib->ServerRebuildConf();
                $result=array("status"=>true,"csrf"=>$csrf,"msg"=>"Menu Option successfully created","insert_id"=>$insert_id,"surveyBox"=>$surveyBox);
                $this->Model_lib->admin_change_log("Menu","Add Menu Option","");
            }else{
                $result=array("status"=>false,"csrf"=>$csrf,"msg"=>"unable to created Menu option.","insert_id"=>$insert_id);
            }        
            exit(json_encode($result));
        }        
    }    
    
    
    public function update_survey_options(){
        $this->load->library('form_validation');
        
        $csrf = array(
               'name' => $this->security->get_csrf_token_name(),
               'hash' => $this->security->get_csrf_hash()
            );
        
        $this->form_validation->set_rules(
                'option_value', 'Option',
                'required',
                array(
                        'required'      => 'You have not provided %s.'
                )
        );
        $this->form_validation->set_rules(
                'option_route', 'Route',
                'required',
                array(
                        'required'      => 'You have not provided %s.'
                )
        );
        if($this->unique_survey_options($this->input->post('current_menu_id'),$this->input->post('current_option_value'))===true)
        {                       
            $error = array(
                'menu_id' =>'Option & Route alerady exist.'
            );
            $data=array("csrf"=>$csrf,"error"=>$error,"status"=>false,"msg"=>"Please enter required fields-lucky.");
            exit(json_encode($data));
        }
        
         
        if ($this->form_validation->run() == FALSE){
            
            $error = array(
                'option_value' => form_error('option_value'),
                'option_route' => form_error('option_route')
            );
            $result=array("status"=>false,"msg"=>"Please enter required fields.");
            $data=array("csrf"=>$csrf,"error"=>$error,"status"=>false,"msg"=>"Please enter required fields.");
            exit(json_encode($data));
        }else{
            $data=$this->Model_lib->parse_array($this->input->post());
            $insert_id=$this->Model_lib->EncryptionId($data['menu_id']);
            $current_menu_id=$this->input->post('current_menu_id');
            $current_option_value=$this->input->post('current_option_value');
            unset($_POST['current_option_value']);
            unset($_POST['current_menu_id']);
            unset($data['current_option_value']);
            unset($data['current_menu_id']);
            
            if($this->Model_survey->update_options($data,$current_menu_id,$current_option_value)){
                $surveyBox=$this->Model_survey->getSurveyBoxInner($data['menu_id'],$data['option_value']);
                $this->Model_survey->rebuild_survey_custom_dialplan($data['menu_id']);
                $this->Model_lib->ServerRebuildConf();
                $result=array("status"=>true,"csrf"=>$csrf,"msg"=>"Menu Option successfully created","insert_id"=>$insert_id,"surveyBox"=>$surveyBox);
                $this->Model_lib->admin_change_log("Menu","Update Menu Option","");
            }else{
                $result=array("status"=>false,"csrf"=>$csrf,"msg"=>"unable to created Menu option.","insert_id"=>$insert_id);
            }        
            exit(json_encode($result));
        }
    }
    
    public function unique_survey_options($current_menu_id="",$current_option_value="")
    {
        $menu_id = $this->input->post('menu_id');
        $option_value = $this->input->post('option_value');
        if($current_menu_id===$menu_id && $current_option_value==$option_value){
            return false;
        }
        $query = $this->db->get_where('vicidial_call_menu_options', array('menu_id' => $menu_id,'option_value'=> $option_value),1);
        $result = $query->result_array();
        if(sizeof($result)>0){
            return TRUE;
        }
        return FALSE;
     }
     
    public function delete_survey_options(){
        $id=$this->input->get('id');
        $id=$this->Model_lib->DecryptionId($id);
        $menu_id=$this->input->get('menu_id');
        $status=$this->Model_survey->delete_option($menu_id,$id);
        if($status){
            $this->Model_survey->rebuild_survey_custom_dialplan($menu_id);
            $this->Model_lib->ServerRebuildConf();
            $array=array("status"=>true,"msg"=>"Menu Option deleted");
            $this->Model_lib->admin_change_log("Menu","Delete Menu Option","");
        }else{
            $array=array("status"=>false,"msg"=>"Unable to deleted Menu Option");
        }
        exit(json_encode($array));
    }
    
    public function delete($menu_id,$id){
        $this->Model_lib->Is_lock();            
        $id=$this->Model_lib->DecryptionId($id);
        $this->load->model('Model_survey');        
        $result=$this->Model_survey->remove_survey($menu_id,$id);  
        if($result){
            $this->Model_survey->rebuild_survey_custom_dialplan($menu_id);
            $this->Model_lib->ServerRebuildConf();
            $this->session->set_flashdata('success','Menu successfully deleted.');
            $this->Model_lib->admin_change_log("Menu","Delete Menu","");
            redirect(base_url('inbound/ivr_manage'));
        }else{
            $this->session->set_flashdata('error','unable to delete Menu.');
            redirect(base_url('inbound/ivr_manage'));
        }
    }
    
    public function get_option(){
        $menu_id=$this->input->get('menu_id');
        $option_value=$this->input->get('option_value');
        $result=$this->Model_survey->get_menu_option($menu_id,$option_value);
        if(sizeof($result)>0){
            $array=array("status"=>true,"result"=>$result);
        }else{
            $array=array("status"=>false,"result"=>$result);
        }        
        exit(json_encode($array));
    }
}
