<?php
defined('BASEPATH') OR exit('No direct script access allowed');
class Branding extends CI_Controller
{
    var $userdata = null;
    function __construct()
    {
        parent::__construct();
        if (!$this->Model_lib->Is_login()) {
            redirect(base_url() . 'login');
        }
        $this->load->model('Model_branding');
        $this->load->model('Model_login');
        $this->userdata = $this->Model_login->Get_loggedin_user();
    }
    
    public function index()
    {
        $this->view();
    }
    
    public function view()
    {
        $userdata = $this->userdata;
        $this->load->view('branding/view', compact('userdata'));
    }
    
    public function add()
    {
        $userdata = $this->userdata;
        $csrf     = array(
            'name' => $this->security->get_csrf_token_name(),
            'hash' => $this->security->get_csrf_hash()
        );
        $data     = array(
            "csrf" => $csrf
        );
        $this->load->view('branding/add', compact('data', 'userdata'));
    }
    
    public function edit($id)
    {
        $this->Model_lib->Is_lock();
        $id        = $this->Model_lib->DecryptionId($id);
        $userdata  = $this->userdata;
        $list_data = $this->Model_branding->get($id);
        $csrf      = array(
            'name' => $this->security->get_csrf_token_name(),
            'hash' => $this->security->get_csrf_hash()
        );
        $data      = array_merge($list_data, array(
            "csrf" => $csrf
        ));
        $this->load->view('branding/edit', compact('data', 'userdata'));
    }
    
    public function save()
    {
        $userdata = $this->userdata;
        $postdata = $this->input->post();
        
        $this->load->library('form_validation');
        $this->form_validation->set_rules('company_name', 'Company Name', 'trim|required|min_length[2]|max_length[30]', array(
            'required' => 'You have not provided %s.'
        ));
        
        $this->form_validation->set_rules('domain_name', 'Domain Name', 'trim|required|min_length[2]|max_length[30]|is_unique[tbl_branding.domain_name]', array(
            'required' => 'You have not provided %s.'
        ));
        
        $this->form_validation->set_rules('phone_number', 'Phone Number', 'trim|required|min_length[5]|max_length[18]|numeric', array(
            'required' => 'You have not provided %s.',
            'numeric' => 'You have not provided valid %s.'
        ));
        
        $this->form_validation->set_rules('company_email', 'Company Email', 'trim|required|valid_email', array(
            'required' => 'You have not provided %s.'
        ));
        
        $this->form_validation->set_rules('slogan', 'Slogan', 'trim|required|min_length[2]|max_length[255]', array(
            'required' => 'You have not provided %s.'
        ));
        
        
        
        if ($this->form_validation->run() == FALSE) {
            $this->Model_lib->Is_lock();
            $csrf     = array(
                'name' => $this->security->get_csrf_token_name(),
                'hash' => $this->security->get_csrf_hash()
            );
            $response = array(
                "status" => false,
                "csrf" => $csrf,
                "msg" => strip_tags(form_error('company_name')) . "\n" . strip_tags(form_error('domain_name')) . "\n" . strip_tags(form_error('company_email')) . "\n" . strip_tags(form_error('slogan')) . "\n" . strip_tags(form_error('phone_number'))
            );
            exit(json_encode($response));
            
        } else {
            $csrf = array(
                'name' => $this->security->get_csrf_token_name(),
                'hash' => $this->security->get_csrf_hash()
            );
            if (!empty($_FILES['favicon']['name'])) {
                $target_file   = basename($_FILES["favicon"]["name"]);
                $imageFileType = strtolower(pathinfo($target_file, PATHINFO_EXTENSION));
                if ($imageFileType != "jpg" && $imageFileType != "png" && $imageFileType != "jpeg" && $imageFileType != "ico") {
                    $response = array(
                        "status" => false,
                        "csrf" => $csrf,
                        "msg" => "Sorry, only JPG, JPEG & PNG files are allowed."
                    );
                    exit(json_encode($response));
                } else {
                    $favicon = base64_encode(file_get_contents(addslashes($_FILES['favicon']['tmp_name'])));
                }
            } else {
                $response = array(
                    "status" => false,
                    "csrf" => $csrf,
                    "msg" => "please select favicon file to upload."
                );
                exit(json_encode($response));
            }
            if (!empty($_FILES['logo']['name'])) {
                $logo_file    = basename($_FILES["logo"]["name"]);
                $logoFileType = strtolower(pathinfo($logo_file, PATHINFO_EXTENSION));
                if ($logoFileType != "jpg" && $logoFileType != "png" && $logoFileType != "jpeg" && $imageFileType != "ico") {
                    $response = array(
                        "status" => false,
                        "csrf" => $csrf,
                        "msg" => "Sorry, only JPG, JPEG & PNG files are allowed."
                    );
                    exit(json_encode($response));
                } else {
                    $logo = base64_encode(file_get_contents(addslashes($_FILES['logo']['tmp_name'])));
                }
            } else {
                $response = array(
                    "status" => false,
                    "csrf" => $csrf,
                    "msg" => "please select logo file to upload."
                );
                exit(json_encode($response));
            }
            
            if ($this->Model_branding->insert($favicon, $logo)) {
                $response = array(
                    "status" => true,
                    "csrf" => $csrf,
                    "msg" => "Branding successfully Added"
                );
                $this->Model_lib->admin_change_log("Branding","Add Branding","");
                exit(json_encode($response));
            } else {
                $response = array(
                    "status" => false,
                    "csrf" => $csrf,
                    "msg" => "Unable to Add Branding"
                );
                exit(json_encode($response));
            }
        }
    }
    
    public function update()
    {
        $this->load->library('form_validation');
        $this->form_validation->set_rules('company_name', 'Company Name', 'trim|required|min_length[2]|max_length[30]', array(
            'required' => 'You have not provided %s.'
        ));
        
        $this->form_validation->set_rules('domain_name', 'Domain Name', 'trim|required|min_length[2]|max_length[30]', array(
            'required' => 'You have not provided %s.'
        ));
        
        $this->form_validation->set_rules('phone_number', 'Phone Number', 'trim|required|min_length[5]|max_length[18]|numeric', array(
            'required' => 'You have not provided %s.',
            'numeric' => 'You have not provided valid %s.'
        ));
        
        $this->form_validation->set_rules('company_email', 'Company Email', 'trim|required|valid_email', array(
            'required' => 'You have not provided %s.'
        ));
        
        $this->form_validation->set_rules('slogan', 'Slogan', 'trim|required|min_length[2]|max_length[255]', array(
            'required' => 'You have not provided %s.'
        ));
        
        if ($this->form_validation->run() == FALSE) {
            $this->Model_lib->Is_lock();
            $csrf     = array(
                'name' => $this->security->get_csrf_token_name(),
                'hash' => $this->security->get_csrf_hash()
            );
            $response = array(
                "status" => false,
                "csrf" => $csrf,
                "msg" => strip_tags(form_error('company_name')) . "\n" . strip_tags(form_error('domain_name')) . "\n" . strip_tags(form_error('company_email')) . "\n" . strip_tags(form_error('slogan')) . "\n" . strip_tags(form_error('phone_number'))
            );
            exit(json_encode($response));
            
        } else {
            $csrf          = array(
                'name' => $this->security->get_csrf_token_name(),
                'hash' => $this->security->get_csrf_hash()
            );
            $branding_id   = $this->input->post('branding_id');
            $domain_name   = $this->input->post('domain_name');
            $unique_domain = $this->Model_branding->check_unique_domain($branding_id, $domain_name);
            if ($unique_domain == true) {
                $response = array(
                    "status" => false,
                    "csrf" => $csrf,
                    "msg" => "Domain Name already exist! Please Try Another"
                );
                exit(json_encode($response));
            }
            if (!empty($_FILES['favicon']['name'])) {
                $target_file   = basename($_FILES["favicon"]["name"]);
                $imageFileType = strtolower(pathinfo($target_file, PATHINFO_EXTENSION));
                if ($imageFileType != "jpg" && $imageFileType != "png" && $imageFileType != "jpeg" && $imageFileType != "ico") {
                    $response = array(
                        "status" => false,
                        "csrf" => $csrf,
                        "msg" => "Sorry, only JPG, JPEG & PNG files are allowed."
                    );
                    exit(json_encode($response));
                } else {
                    $favicon = base64_encode(file_get_contents(addslashes($_FILES['favicon']['tmp_name'])));
                }
            } else {
                $favicon = '';
            }
            if (!empty($_FILES['logo']['name'])) {
                $logo_file    = basename($_FILES["logo"]["name"]);
                $logoFileType = strtolower(pathinfo($logo_file, PATHINFO_EXTENSION));
                if ($logoFileType != "jpg" && $logoFileType != "png" && $logoFileType != "jpeg") {
                    $response = array(
                        "status" => false,
                        "csrf" => $csrf,
                        "msg" => "Sorry, only JPG, JPEG & PNG files are allowed."
                    );
                    exit(json_encode($response));
                } else {
                    $logo = base64_encode(file_get_contents(addslashes($_FILES['logo']['tmp_name'])));
                }
            } else {
                $logo = '';
            }
            if ($this->Model_branding->update($favicon, $logo)) {
                $response = array(
                    "status" => true,
                    "csrf" => $csrf,
                    "msg" => "Branding successfully Updated."
                );
                $this->Model_lib->admin_change_log("Branding","Update Branding","");
                exit(json_encode($response));
            } else {
                $response = array(
                    "status" => false,
                    "csrf" => $csrf,
                    "msg" => "unable to update Branding."
                );
                exit(json_encode($response));
            }
        }
    }
    
    
    public function delete($id)
    {
        $this->Model_lib->Is_lock();
        $id     = $this->Model_lib->DecryptionId($id);
        $result = $this->Model_branding->remove($id);
        if ($result) {
            $this->session->set_flashdata('success', 'Branding successfully deleted.');
            $this->Model_lib->admin_change_log("Branding","Delete Branding","");
            redirect(base_url('settings/branding'));
        } else {
            $this->session->set_flashdata('error', 'unable to delete Branding.');
            redirect(base_url('settings/branding'));
        }
    }
    
    
}