<?php
defined('BASEPATH') OR exit('No direct script access allowed');

/*
| -------------------------------------------------------------------------
| URI ROUTING
| -------------------------------------------------------------------------
| This file lets you re-map URI requests to specific controller functions.
|
| Typically there is a one-to-one relationship between a URL string
| and its corresponding controller class/method. The segments in a
| URL normally follow this pattern:
|
|	example.com/class/method/id/
|
| In some instances, however, you may want to remap this relationship
| so that a different class/function is called than the one
| corresponding to the URL.
|
| Please see the user guide for complete details:
|
|	https://codeigniter.com/user_guide/general/routing.html
|
| -------------------------------------------------------------------------
| RESERVED ROUTES
| -------------------------------------------------------------------------
|
| There are three reserved routes:
|
|	$route['default_controller'] = 'welcome';
|
| This route indicates which controller class should be loaded if the
| URI contains no data. In the above example, the "welcome" class
| would be loaded.
|
|	$route['404_override'] = 'errors/page_missing';
|
| This route will tell the Router which controller/method to use if those
| provided in the URL cannot be matched to a valid route.
|
|	$route['translate_uri_dashes'] = FALSE;
|
| This is not exactly a route, but allows you to automatically route
| controller and method names that contain dashes. '-' isn't a valid
| class or method name character, so it requires translation.
| When you set this option to TRUE, it will replace ALL dashes with
| underscores in the controller and method URI segments.
|
| Examples:	my-controller/index	-> my_controller/index
|		my-controller/my-method	-> my_controller/my_method
*/
$route['default_controller'] = 'login';

#campaigns node:
$route["campaigns"]="campaigns";
$route["campaigns/scripts"]="script";

// $route["campaigns/create"]="campaigns/create";
// $route["campaigns/manage"]="campaigns";
// $route["campaigns/queue"]="campaigns/queue";
// $route["campaigns/scripts"]="script";

$route["user"]="user";
$route["user/groups"]="groups";
$route['user/users'] = 'user';
$route['user/groups/export_users/(:any)'] = 'groups/export_users/$1';

// $route['agents/changepassword'] = 'user/changepassword';
// $route['agents/logout'] = 'user/logout';


#datasets node:
$route['data/add'] = 'lists/add';
$route['data'] = 'lists';
$route["data/edit/(:any)"]="lists/edit/$1";
$route["data/download_list/(:any)"]="lists/download_list/$1";
$route["data/clean/(:any)"]="lists/clean/$1";
$route["data/data/(:any)"]="lists/data/$1";
$route["data/hopper/(:any)"]="lists/hopper/$1";
$route['data/import'] = 'datauploader';
$route['data/search'] = 'reports/search_lead';
$route['data/search/(:any)'] = 'reports/search_lead/$i';
$route['data/modify_lead'] = 'reports/modify_lead';
$route["data/fields/(:any)"]="lists/fields/$1";

#agents / users
$route["agents"]="user";
$route["agents/manage"]="user";
$route['agents/create'] = 'user/create';
$route['agents/changepassword'] = 'user/changepassword';
$route['agents/logout'] = 'user/logout';

#groups
$route["groups/create"]="groups/create";
$route["groups/manage"]="groups";




#inbound Groups
// $route["inbound"]="groups_manage";
$route["inbound/groups_create"]="queue/create";
$route["inbound/groups_manage"]="queue";

#inbound DID
$route["inbound/did_create"]="numbers/create";
$route["inbound/did_manage"]="numbers";

#inbound ivr
$route["inbound/ivr_create"]="callmenu/add";
$route["inbound/ivr_edit/(:any)"]="callmenu/edit/$1";
$route["inbound/ivr_manage"]="callmenu";

#inbound remote agents
$route["inbound/remote_create"]="remote/create";
$route["inbound/remote_manage"]="remote";

$route["inbound/dnc_groups"]="inbound_dnc";
$route["inbound/dnc_groups/add"]="inbound_dnc/add";
$route["inbound/dnc_groups/edit/(:any)"]="inbound_dnc/edit/$1";
$route["inbound/dnc_groups/numbers/(:any)"]="inbound_dnc/numbers/$1";
$route["inbound/dnc_groups/edit_number/(:any)/(:any)"]="inbound_dnc/edit_number/$1/$2";
$route["inbound/dnc_groups/delete_number/(:any)/(:any)"]="inbound_dnc/delete_number/$1/$2";

#settings
$route["settings"]="phones";
$route["settings/phones"]="phones";
$route["settings/outbound_dnc"]="dnc";
$route["settings/inbound_dnc"]="dncin";

$route["settings/audio_files"]="sounds";
$route["settings/audio_files/manage"]="sounds";
$route["settings/audio_files/create"]="sounds/add";
$route["settings/statuses"]="statuses";

$route["settings/branding"]="branding";
$route["settings/branding/add"]="branding/add";
$route["settings/branding/edit/(:any)"]="branding/edit/$1";

$route["settings/gateway"]="gateway";
$route["settings/gateway/add"]="gateway/add";
$route["settings/gateway/edit/(:any)"]="gateway/edit/$1";

$route["settings/firewall"]="firewall";
$route["settings/firewall/add"]="firewall/add";
$route["settings/firewall/edit/(:any)"]="firewall/edit/$1";

$route["settings/voicemail"]="voicemail";
$route["settings/voicemail/add"]="voicemail/add";
$route["settings/voicemail/edit/(:any)"]="voicemail/edit/$1";
$route["settings/voicemail/delete/(:any)"]="voicemail/delete/$1";

#Agent Reports
$route["agent_reports/realtime"]="reports/realtime";
$route["agent_reports/agent_time_detail"]="reports/agent_time_detail";
$route["agent_reports/agent_status_detail"]="reports/agent_status_detail";
$route["agent_reports/agent_performance_detail"]="reports/agent_performance_detail";
$route["agent_reports/team_performance_detail"]="reports/team_performance_detail";

#Data Reports
$route["data_reports/recordings"]="reports/call_log";
$route["data_reports/outbound"]="reports/outbound";
$route["data_reports/lead_export"]="reports/lead_export";
$route["data_reports/call_connectivity"]="reports/call_connectivity";

#Contact Reports
$route["contact_reports/call_export"]="reports/call_export";
$route["contact_reports/inbound"]="reports/inbound";
$route["contact_reports/campaign_status_list"]="reports/campaign_status_list";


$route['404_override'] = '';
$route['translate_uri_dashes'] = FALSE;