<?php
/**
 * Vici WebRTC Phone - Dropdown Speaker Selection Test
 * 
 * This file demonstrates the new dropdown speaker selection interface
 * that has been added directly to viciphone.php
 */

// Example parameters (replace with your actual values)
$phone_login = base64_encode("1001");
$phone_pass = base64_encode("password123");
$server_ip = base64_encode("192.168.1.100");
$options = base64_encode("DEBUG"); // Enable debug mode to see speaker changes
?>

<!DOCTYPE html>
<html>
<head>
    <title>Vici WebRTC Phone - Dropdown Speaker Selection Test</title>
    <style>
        body { 
            font-family: Arial, sans-serif; 
            margin: 20px; 
            background-color: #f5f5f5;
        }
        .container {
            max-width: 900px;
            margin: 0 auto;
            background: white;
            padding: 20px;
            border-radius: 8px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
        }
        .test-info {
            background: #e8f4fd;
            padding: 15px;
            border-radius: 5px;
            margin-bottom: 20px;
        }
        .phone-frame {
            border: 2px solid #ddd;
            border-radius: 8px;
            overflow: hidden;
            margin: 20px 0;
            text-align: center;
        }
        .instructions {
            background: #f9f9f9;
            padding: 15px;
            border-radius: 5px;
            margin: 20px 0;
        }
        .feature-list {
            background: #fff3cd;
            padding: 15px;
            border-radius: 5px;
            margin: 20px 0;
        }
        h2 { color: #333; border-bottom: 2px solid #007bff; padding-bottom: 5px; }
        .highlight { background: #fff3cd; padding: 2px 5px; border-radius: 3px; }
    </style>
</head>
<body>
    <div class="container">
        <h1>Vici WebRTC Phone - Dropdown Speaker Selection Test</h1>
        
        <div class="test-info">
            <h3>Test Information</h3>
            <p>This page demonstrates the new dropdown speaker selection interface that has been added directly to <code>viciphone.php</code>.</p>
            <ul>
                <li><strong>Phone Login:</strong> 1001</li>
                <li><strong>Server IP:</strong> 192.168.1.100</li>
                <li><strong>Options:</strong> DEBUG (enabled to show speaker changes)</li>
            </ul>
        </div>
        
        <div class="feature-list">
            <h3>New Features Added</h3>
            <ul>
                <li><span class="highlight">Dropdown Interface:</span> A speaker selection dropdown appears at the top of the phone interface</li>
                <li><span class="highlight">Real-time Changes:</span> Speaker configuration changes immediately when dropdown selection changes</li>
                <li><span class="highlight">Parameter Preservation:</span> All existing URL parameters are preserved when speaker selection changes</li>
                <li><span class="highlight">Dual Interface:</span> Both the main dropdown and the phone interface dropdown work together</li>
                <li><span class="highlight">Default Setting:</span> Both speakers are selected by default</li>
            </ul>
        </div>
        
        <div class="instructions">
            <h3>How to Test</h3>
            <ol>
                <li>Look for the <strong>"Speaker Configuration"</strong> dropdown at the top of the phone interface</li>
                <li>Select different speaker options:
                    <ul>
                        <li><strong>Both Speakers</strong> - Audio plays through both left and right speakers</li>
                        <li><strong>Left Speaker Only</strong> - Audio plays through left speaker only</li>
                        <li><strong>Right Speaker Only</strong> - Audio plays through right speaker only</li>
                    </ul>
                </li>
                <li>Notice that the selection changes immediately and the page reloads with the new configuration</li>
                <li>Check the debug output (if enabled) to see speaker configuration changes</li>
                <li>Test the speaker dropdown inside the phone interface as well</li>
            </ol>
        </div>
        
        <div class="phone-frame">
            <iframe src="viciphone.php?phone_login=<?php echo $phone_login; ?>&phone_pass=<?php echo $phone_pass; ?>&server_ip=<?php echo $server_ip; ?>&options=<?php echo $options; ?>" 
                    width="424" height="320" 
                    frameborder="0"
                    allow="microphone; camera">
            </iframe>
        </div>
        
        <div class="instructions">
            <h3>Technical Details</h3>
            <ul>
                <li><strong>URL Parameters:</strong> The dropdown preserves all existing URL parameters when changing speaker configuration</li>
                <li><strong>Form Submission:</strong> Uses GET method to submit speaker selection changes</li>
                <li><strong>Validation:</strong> Only accepts valid speaker options (LEFT, RIGHT, BOTH)</li>
                <li><strong>Integration:</span> Works seamlessly with existing phone functionality</li>
                <li><strong>Styling:</strong> Clean, professional interface that matches the phone design</li>
            </ul>
        </div>
        
        <div style="margin-top: 20px; padding: 15px; background: #d4edda; border-radius: 5px;">
            <h3>Usage in Production</h3>
            <p>To use this in your ViciDial environment:</p>
            <ol>
                <li>Simply call <code>viciphone.php</code> with your existing parameters</li>
                <li>The speaker selection dropdown will automatically appear</li>
                <li>Users can change speaker configuration without modifying URL parameters</li>
                <li>All existing functionality remains unchanged</li>
            </ol>
        </div>
    </div>
</body>
</html> 