<?php
// Example of how to use the new speaker options in Vici WebRTC Phone
// This file demonstrates the different speaker configurations available

// Base64 encoded parameters (you would normally get these from your ViciDial system)
$phone_login = base64_encode("1001");
$phone_pass = base64_encode("password123");
$server_ip = base64_encode("192.168.1.100");

// Speaker configuration options:
// - SPEAKERBOTH (default) - Audio plays through both left and right speakers
// - SPEAKERLEFT - Audio plays through left speaker only
// - SPEAKERRIGHT - Audio plays through right speaker only

// Example 1: Both speakers (default)
$options_both = base64_encode("SPEAKERBOTH");

// Example 2: Left speaker only
$options_left = base64_encode("SPEAKERLEFT");

// Example 3: Right speaker only
$options_right = base64_encode("SPEAKERRIGHT");

// Example 4: Combine with other options
$options_combined = base64_encode("SPEAKERLEFT--DEBUG--AUTOANSWER_Y");
?>

<!DOCTYPE html>
<html>
<head>
    <title>Vici WebRTC Phone - Speaker Options Test</title>
    <style>
        body { font-family: Arial, sans-serif; margin: 20px; }
        .example { margin: 20px 0; padding: 15px; border: 1px solid #ccc; border-radius: 5px; }
        .phone-frame { border: 2px solid #333; border-radius: 5px; margin: 10px 0; }
        h2 { color: #333; }
        code { background: #f4f4f4; padding: 2px 5px; border-radius: 3px; }
    </style>
</head>
<body>
    <h1>Vici WebRTC Phone - Speaker Options Test</h1>
    
    <p>This page demonstrates the new speaker options available in the Vici WebRTC Phone system.</p>
    
    <h2>Available Speaker Configurations:</h2>
    <ul>
        <li><strong>BOTH</strong> (default) - Audio plays through both left and right speakers</li>
        <li><strong>LEFT</strong> - Audio plays through left speaker only</li>
        <li><strong>RIGHT</strong> - Audio plays through right speaker only</li>
    </ul>
    
    <h2>Test Examples:</h2>
    
    <div class="example">
        <h3>1. Both Speakers (Default)</h3>
        <p>Audio will play through both left and right speakers.</p>
        <code>Options: SPEAKERBOTH</code>
        <div class="phone-frame">
            <iframe src="viciphone.php?phone_login=<?php echo $phone_login; ?>&phone_pass=<?php echo $phone_pass; ?>&server_ip=<?php echo $server_ip; ?>&options=<?php echo $options_both; ?>" 
                    width="424" height="260" frameborder="0"></iframe>
        </div>
    </div>
    
    <div class="example">
        <h3>2. Left Speaker Only</h3>
        <p>Audio will play through the left speaker only.</p>
        <code>Options: SPEAKERLEFT</code>
        <div class="phone-frame">
            <iframe src="viciphone.php?phone_login=<?php echo $phone_login; ?>&phone_pass=<?php echo $phone_pass; ?>&server_ip=<?php echo $server_ip; ?>&options=<?php echo $options_left; ?>" 
                    width="424" height="260" frameborder="0"></iframe>
        </div>
    </div>
    
    <div class="example">
        <h3>3. Right Speaker Only</h3>
        <p>Audio will play through the right speaker only.</p>
        <code>Options: SPEAKERRIGHT</code>
        <div class="phone-frame">
            <iframe src="viciphone.php?phone_login=<?php echo $phone_login; ?>&phone_pass=<?php echo $phone_pass; ?>&server_ip=<?php echo $server_ip; ?>&options=<?php echo $options_right; ?>" 
                    width="424" height="260" frameborder="0"></iframe>
        </div>
    </div>
    
    <div class="example">
        <h3>4. Combined Options</h3>
        <p>Left speaker only with debug mode and auto-answer enabled.</p>
        <code>Options: SPEAKERLEFT--DEBUG--AUTOANSWER_Y</code>
        <div class="phone-frame">
            <iframe src="viciphone.php?phone_login=<?php echo $phone_login; ?>&phone_pass=<?php echo $phone_pass; ?>&server_ip=<?php echo $server_ip; ?>&options=<?php echo $options_combined; ?>" 
                    width="424" height="260" frameborder="0"></iframe>
        </div>
    </div>
    
    <h2>How to Use:</h2>
    <ol>
        <li>Add the speaker option to your options parameter when calling viciphone.php</li>
        <li>Use <code>SPEAKERBOTH</code>, <code>SPEAKERLEFT</code>, or <code>SPEAKERRIGHT</code></li>
        <li>You can combine speaker options with other existing options using <code>--</code> as separator</li>
        <li>The speaker selection dropdown in the phone interface allows users to change the setting dynamically</li>
    </ol>
    
    <h2>Technical Details:</h2>
    <ul>
        <li>The system uses Web Audio API to route audio to specific channels</li>
        <li>Left/Right speaker selection works by manipulating the stereo audio channels</li>
        <li>The default "BOTH" setting maintains normal stereo audio output</li>
        <li>Changes take effect immediately when the speaker selection is changed</li>
    </ul>
    
    <p><em>Note: Make sure to replace the example credentials with your actual ViciDial system credentials.</em></p>
</body>
</html> 