# Vici WebRTC Phone - Speaker Options

This document describes the new speaker options functionality added to the Vici WebRTC phone system, allowing users to control which speakers (left, right, or both) are used for audio output.

## Overview

The speaker options feature allows you to:
- Route audio to the left speaker only
- Route audio to the right speaker only  
- Route audio to both speakers (default behavior)
- Change speaker configuration dynamically through the web interface

## Features

### 1. Server-Side Configuration
- Configure default speaker behavior via URL parameters
- Support for combining speaker options with existing phone options
- Backward compatibility with existing installations

### 2. Client-Side Controls
- Dropdown menu in the phone interface for speaker selection
- Real-time speaker configuration changes
- Visual feedback for current speaker setting

### 3. Audio Processing
- Uses Web Audio API for precise channel routing
- Maintains audio quality while routing to specific channels
- Supports all existing audio features (volume control, mute, etc.)

## Usage

### URL Parameters

Add speaker configuration to your `options` parameter when calling `viciphone.php`:

```
viciphone.php?phone_login=...&phone_pass=...&server_ip=...&options=SPEAKERBOTH
```

### Available Speaker Options

| Option | Description |
|--------|-------------|
| `SPEAKERBOTH` | Audio plays through both left and right speakers (default) |
| `SPEAKERLEFT` | Audio plays through left speaker only |
| `SPEAKERRIGHT` | Audio plays through right speaker only |

### Combining Options

You can combine speaker options with other existing options using `--` as a separator:

```
SPEAKERLEFT--DEBUG--AUTOANSWER_Y
```

This example sets left speaker only, enables debug mode, and enables auto-answer.

## Implementation Details

### Files Modified

1. **viciphone.php** - Added speaker configuration parsing
2. **vp_template.php** - Added speaker selection UI and JavaScript variables
3. **js/vici_phone.js** - Added speaker control functionality and Web Audio API integration
4. **css/default.css** - Added styling for speaker control interface

### Key Functions

#### `applySpeakerConfiguration(speakerConfig)`
Handles the Web Audio API setup for routing audio to specific channels:
- Creates audio context and nodes for channel manipulation
- Routes audio based on selected configuration
- Maintains audio quality and performance

#### `speakerSelectionChanged()`
Handles user interface changes:
- Updates speaker configuration when dropdown selection changes
- Provides debug output for troubleshooting
- Applies new configuration immediately

### Web Audio API Integration

The system uses the following Web Audio API components:
- **AudioContext** - Main audio processing context
- **MediaElementSource** - Connects HTML audio element to Web Audio API
- **ChannelSplitter** - Separates stereo audio into left/right channels
- **ChannelMerger** - Combines channels for output
- **GainNode** - Controls volume for individual channels

## Browser Compatibility

The speaker options feature requires browsers that support:
- Web Audio API
- WebRTC
- Modern JavaScript features

**Supported Browsers:**
- Chrome 14+
- Firefox 23+
- Safari 6+
- Edge 12+

## Testing

Use the provided `speaker_test_example.php` file to test different speaker configurations:

1. Open `speaker_test_example.php` in your web browser
2. Test each speaker configuration option
3. Verify audio routing works correctly
4. Test dynamic speaker selection changes

## Troubleshooting

### Common Issues

1. **No audio output**
   - Check browser permissions for microphone access
   - Verify Web Audio API is supported
   - Check browser console for errors

2. **Speaker selection not working**
   - Ensure JavaScript is enabled
   - Check for Web Audio API support
   - Verify audio context is properly initialized

3. **Audio quality issues**
   - Check browser audio settings
   - Verify system audio drivers
   - Test with different browsers

### Debug Mode

Enable debug mode to see detailed information about speaker configuration:

```
SPEAKERLEFT--DEBUG
```

This will show debug output in the phone interface when speaker changes occur.

## Configuration Examples

### Basic Usage
```php
// Both speakers (default)
$options = base64_encode("SPEAKERBOTH");

// Left speaker only
$options = base64_encode("SPEAKERLEFT");

// Right speaker only  
$options = base64_encode("SPEAKERRIGHT");
```

### Advanced Usage
```php
// Left speaker with debug and auto-answer
$options = base64_encode("SPEAKERLEFT--DEBUG--AUTOANSWER_Y");

// Right speaker with custom layout
$options = base64_encode("SPEAKERRIGHT--WEBPHONELAYOUTcustom");

// Both speakers with all debug features
$options = base64_encode("SPEAKERBOTH--DEBUG--AUTOANSWER_Y--WEBSOCKETURLwss://server:8089");
```

## Migration Guide

### For Existing Installations

1. **Backup your current files**
2. **Update the modified files** (viciphone.php, vp_template.php, js/vici_phone.js, css/default.css)
3. **Test the new functionality** using the test example
4. **Update any custom integrations** to use the new speaker options

### Default Behavior

- Existing installations will continue to work without changes
- Default speaker configuration is "BOTH" (same as original behavior)
- All existing options continue to work as before

## Support

For issues or questions regarding the speaker options feature:
1. Check the browser console for error messages
2. Enable debug mode for detailed logging
3. Test with different browsers to isolate browser-specific issues
4. Verify Web Audio API support in your browser

## License

This feature is part of the Vici WebRTC Phone system and follows the same GNU Affero General Public License v3.0. 