<?php 
require_once "../../../theme.php";
header("Content-type: text/css; charset:UTF-8"); 
?>
@font-face {
    font-family: 'Roboto';
    src: url('fonts/roboto-thin-webfont.woff2') format('woff2'),
         url('fonts/roboto-thin-webfont.woff') format('woff'),
         url('fonts/roboto-thin-webfont.svg#robotothin') format('svg');
    font-weight: 200;
    font-style: normal;

}


@font-face {
    font-family: 'Roboto';
    src: url('fonts/roboto-light-webfont.woff2') format('woff2'),
         url('fonts/roboto-light-webfont.woff') format('woff'),
         url('fonts/roboto-light-webfont.svg#robotolight') format('svg');
    font-weight: 300;
    font-style: normal;

}


@font-face {
    font-family: 'Roboto';
    src: url('fonts/roboto-regular-webfont.woff2') format('woff2'),
         url('fonts/roboto-regular-webfont.woff') format('woff'),
         url('fonts/roboto-regular-webfont.svg#robotoregular') format('svg');
    font-weight: 400;
    font-style: normal;

}


@font-face {
    font-family: 'Roboto';
    src: url('fonts/roboto-medium-webfont.woff2') format('woff2'),
         url('fonts/roboto-medium-webfont.woff') format('woff'),
         url('fonts/roboto-medium-webfont.svg#robotomedium') format('svg');
    font-weight: 500;
    font-style: normal;

}

@font-face {
    font-family: 'Roboto';
    src: url('fonts/roboto-black-webfont.woff2') format('woff2'),
         url('fonts/roboto-black-webfont.woff') format('woff'),
         url('fonts/roboto-black-webfont.svg#robotoblack') format('svg');
    font-weight: 600;
    font-style: normal;

}

@font-face {
    font-family: 'Roboto';
    src: url('fonts/roboto-bold-webfont.woff2') format('woff2'),
         url('fonts/roboto-bold-webfont.woff') format('woff'),
         url('fonts/roboto-bold-webfont.svg#robotobold') format('svg');
    font-weight: 700;
    font-style: normal;

}

/* flat-icon */


@font-face {
  font-family: "Flaticon";
  src: url("flat-icon/Flaticon.eot");
  src: url("flat-icon/Flaticon.eot?#iefix") format("embedded-opentype"),
       url("flat-icon/Flaticon.woff2") format("woff2"),
       url("flat-icon/Flaticon.woff") format("woff"),
       url("flat-icon/Flaticon.ttf") format("truetype"),
       url("flat-icon/Flaticon.svg#Flaticon") format("svg");
  font-weight: normal;
  font-style: normal;
}



@media screen and (-webkit-min-device-pixel-ratio:0) {
  @font-face {
    font-family: "Flaticon";
    src: url("./Flaticon.svg#Flaticon") format("svg");
  }
}


[class^="flaticon-"]:before, [class*=" flaticon-"]:before,
[class^="flaticon-"]:after, [class*=" flaticon-"]:after {   
  font-family: Flaticon;
      
font-style: normal;

}

.flaticon-mail-black-envelope-symbol:before { content: "\f100"; }
.flaticon-support:before { content: "\f101"; }
.flaticon-microphone-of-voice:before { content: "\f102"; }
.flaticon-play-button:before { content: "\f103"; }
.flaticon-volume-up-interface-symbol:before { content: "\f104"; }
.flaticon-house-black-silhouette-without-door:before { content: "\f105"; }
.flaticon-stop:before { content: "\f106"; }
.flaticon-quaver-outline:before { content: "\f107"; }
.flaticon-tiles:before { content: "\f108"; }
.flaticon-telephone-handle-silhouette:before { content: "\f109"; }
.flaticon-power:before { content: "\f10a"; }
.flaticon-search:before { content: "\f10b"; }
.flaticon-programming-code:before { content: "\f10c"; }
.flaticon-speak:before { content: "\f10d"; }
.flaticon-user:before { content: "\f10e"; }
.flaticon-checked:before { content: "\f10f"; }
.flaticon-settings-work-tool:before { content: "\f110"; }
.flaticon-restore-screen:before { content: "\f111"; }
.flaticon-full-screen:before { content: "\f112"; }
.flaticon-clock:before { content: "\f113"; }
.flaticon-phone-receiver:before { content: "\f114"; }
.flaticon-phone-receiver-1:before { content: "\f115"; }
.flaticon-call:before { content: "\f116"; }
.flaticon-call-1:before { content: "\f117"; }
.flaticon-telephone:before { content: "\f118"; }
.flaticon-phone-receiver-2:before { content: "\f119"; }
.flaticon-call-2:before { content: "\f11a"; }
.flaticon-transfer:before { content: "\f11b"; }
.flaticon-phone-receiver-3:before { content: "\f11c"; }
.flaticon-phone:before { content: "\f11d"; }
.flaticon-telephone-1:before { content: "\f11e"; }
.flaticon-call-3:before { content: "\f11f"; }
.flaticon-call-4:before { content: "\f120"; }
.flaticon-cancel:before { content: "\f121"; }
.flaticon-phone-1:before { content: "\f122"; }
.flaticon-call-5:before { content: "\f123"; }
.flaticon-phone-2:before { content: "\f124"; }
.flaticon-copy:before { content: "\f125"; }
.flaticon-document:before { content: "\f126"; }

/* new */

.flaticon1-refresh:before { content: "\f100"; }
.flaticon1-pause-sign:before { content: "\f101"; }
.flaticon1-mic:before { content: "\f102"; }
.flaticon1-mic-1:before { content: "\f103"; }
.flaticon1-info:before { content: "\f104"; }
.flaticon1-customer-service:before { content: "\f105"; }
.flaticon1-call:before { content: "\f106"; }
.flaticon1-call-1:before { content: "\f107"; }
.flaticon1-phone:before { content: "\f108"; }
.flaticon1-call-2:before { content: "\f109"; }
.flaticon1-headset:before { content: "\f10a"; }
.flaticon1-support:before { content: "\f10b"; }
.flaticon1-call-3:before { content: "\f10c"; }
.flaticon1-call-4:before { content: "\f10d"; }
.flaticon1-phone-1:before { content: "\f10e"; }
.flaticon1-external-link:before { content: "\f10f"; }
.flaticon1-call-5:before { content: "\f110"; }
.flaticon1-support-1:before { content: "\f111"; }
.flaticon1-support-2:before { content: "\f112"; }
.flaticon1-call-6:before { content: "\f113"; }
.flaticon1-call-7:before { content: "\f114"; }
.flaticon1-call-8:before { content: "\f115"; }
.flaticon1-telephone-call:before { content: "\f116"; }
.flaticon1-end-call:before { content: "\f117"; }
.flaticon1-call-9:before { content: "\f118"; }
.flaticon1-end:before { content: "\f119"; }
.flaticon1-ringtone:before { content: "\f11a"; }
.flaticon1-telephone:before { content: "\f11b"; }
.flaticon1-close:before { content: "\f11c"; }
.flaticon1-problem:before { content: "\f11d"; }
.flaticon1-insect:before { content: "\f11e"; }
.flaticon1-error:before { content: "\f11f"; }
.flaticon1-error-1:before { content: "\f120"; }
@font-face {
  font-family: "Flaticon1";
  src: url("flat-icon/icon1/Flaticon.eot");
  src: url("flat-icon/icon1/Flaticon.eot?#iefix") format("embedded-opentype"),
       url("flat-icon/icon1/Flaticon.woff2") format("woff2"),
       url("flat-icon/icon1/Flaticon.woff") format("woff"),
       url("flat-icon/icon1/Flaticon.ttf") format("truetype"),
       url("flat-icon/icon1/Flaticon.svg#Flaticon") format("svg");
  font-weight: normal;
  font-style: normal;
}

@media screen and (-webkit-min-device-pixel-ratio:0) {
  @font-face {
    font-family: "Flaticon1";
    src: url("flat-icon/1/Flaticon.svg#Flaticon") format("svg");
  }
}

[class^="flaticon1-"]:before, [class*=" flaticon1-"]:before,
[class^="flaticon1-"]:after, [class*=" flaticon1-"]:after {   
  font-family: Flaticon1;
font-style: normal;
/*font-size: 20px;*/
/*margin-left: 20px;*/
}

/* icomoon */

@font-face {
  font-family: 'icomoon';
  src:  url('flat-icon/icomoon/icomoon.eot?o0sqt0');
  src:  url('flat-icon/icomoon/icomoon.eot?o0sqt0#iefix') format('embedded-opentype'),
    url('flat-icon/icomoon/icomoon.ttf?o0sqt0') format('truetype'),
    url('flat-icon/icomoon/icomoon.woff?o0sqt0') format('woff'),
    url('flat-icon/icomoon/icomoon.svg?o0sqt0#icomoon') format('svg');
  font-weight: normal;
  font-style: normal;
  font-display: block;
}

[class^="icon-"], [class*=" icon-"] {
  /* use !important to prevent issues with browser extensions that change fonts */
  font-family: 'icomoon' !important;
  speak: none;
  font-style: normal;
  font-weight: normal;
  font-variant: normal;
  text-transform: none;
  line-height: 1;

  /* Better Font Rendering =========== */
  -webkit-font-smoothing: antialiased;
  -moz-osx-font-smoothing: grayscale;
}



.icon-park-call:before {
  content: "\e900";
}

/* icomoon */

/* new flat icons */

@font-face {
  font-family: "Flaticon5";
  src: url("flat-icon/5/Flaticon.eot");
  src: url("flat-icon/5/Flaticon.eot?#iefix") format("embedded-opentype"),
       url("flat-icon/5/Flaticon.woff2") format("woff2"),
       url("flat-icon/5/Flaticon.woff") format("woff"),
       url("flat-icon/5/Flaticon.ttf") format("truetype"),
       url("flat-icon/5/Flaticon.svg#Flaticon") format("svg");
  font-weight: normal;
  font-style: normal;
}

@media screen and (-webkit-min-device-pixel-ratio:0) {
  @font-face {
    font-family: "Flaticon5";
    src: url("flat-icon/5/Flaticon.svg#Flaticon") format("svg");
  }
}

[class^="flaticon5-"]:before, [class*=" flaticon5-"]:before,
[class^="flaticon5-"]:after, [class*=" flaticon5-"]:after {   
  font-family: Flaticon5;
/*        font-size: 20px;*/
font-style: normal;
/*margin-left: 20px;*/
}

.flaticon5-documents-symbol:before { content: "\f100"; }
.flaticon5-turn-off:before { content: "\f101"; }
.flaticon5-link-break:before { content: "\f102"; }
.flaticon5-connections:before { content: "\f103"; }
.flaticon5-dial:before { content: "\f104"; }
.flaticon5-dial-pad:before { content: "\f105"; }
.flaticon5-phone-call:before { content: "\f106"; }
.flaticon5-interlocking:before { content: "\f107"; }
.flaticon5-telephone:before { content: "\f108"; }
.flaticon5-user:before { content: "\f109"; }
.flaticon5-globe:before { content: "\f10a"; }
.flaticon5-signal:before { content: "\f10b"; }
.flaticon5-globe-1:before { content: "\f10c"; }
.flaticon5-globe-2:before { content: "\f10d"; }
.flaticon5-share:before { content: "\f10e"; }
.flaticon5-radio:before { content: "\f10f"; }
.flaticon5-signal-tower:before { content: "\f110"; }
.flaticon5-search:before { content: "\f111"; }
.flaticon5-radio-antenna:before { content: "\f112"; }
.flaticon5-followers:before { content: "\f113"; }
.flaticon5-add-user:before { content: "\f114"; }
.flaticon5-user-1:before { content: "\f115"; }
.flaticon5-add-group:before { content: "\f116"; }
.flaticon5-play-button-arrowhead:before { content: "\f117"; }
.flaticon5-stop-button:before { content: "\f118"; }
.flaticon5-stop:before { content: "\f119"; }
.flaticon5-musical-note:before { content: "\f11a"; }
.flaticon5-transfer:before { content: "\f11b"; }
.flaticon5-database:before { content: "\f11c"; }
.flaticon5-email:before { content: "\f11d"; }
.flaticon5-calendar:before { content: "\f11e"; }
.flaticon5-call-back:before { content: "\f11f"; }
.flaticon5-call-back-1:before { content: "\f120"; }
.flaticon5-messenger:before { content: "\f121"; }
.flaticon5-chat:before { content: "\f122"; }
.flaticon5-speech-bubble-with-text-lines:before { content: "\f123"; }
.flaticon5-speech-bubble:before { content: "\f124"; }
.flaticon5-music-player:before { content: "\f125"; }
.flaticon5-microphone:before { content: "\f126"; }
.flaticon5-button:before { content: "\f127"; }
.flaticon5-microphone-1:before { content: "\f128"; }
.flaticon5-feedback:before { content: "\f129"; }
.flaticon5-voice-recorder:before { content: "\f12a"; }
.flaticon5-microphone-2:before { content: "\f12b"; }
.flaticon5-mute:before { content: "\f12c"; }
.flaticon5-microphone-3:before { content: "\f12d"; }
.flaticon5-volume:before { content: "\f12e"; }
.flaticon5-loud-speaker:before { content: "\f12f"; }
.flaticon5-speaker-filled-audio-tool:before { content: "\f130"; }
.flaticon5-volume-1:before { content: "\f131"; }
.flaticon5-mute-1:before { content: "\f132"; }
.flaticon5-web-development:before { content: "\f133"; }
.flaticon5-web-development-1:before { content: "\f134"; }
.flaticon5-code:before { content: "\f135"; }
.flaticon5-chat-1:before { content: "\f136"; }
.flaticon5-chat-2:before { content: "\f137"; }
.flaticon5-menu:before { content: "\f138"; }
.flaticon5-menu-1:before { content: "\f139"; }
.flaticon5-menu-2:before { content: "\f13a"; }
.flaticon5-notification:before { content: "\f13b"; }
.flaticon5-group:before { content: "\f13c"; }
.flaticon5-maximize:before { content: "\f13d"; }
.flaticon5-minimize:before { content: "\f13e"; }
.flaticon5-minimize-1:before { content: "\f13f"; }
.flaticon5-minimize-2:before { content: "\f140"; }
.flaticon5-rectangle:before { content: "\f141"; }
.flaticon5-square:before { content: "\f142"; }
.flaticon5-group-1:before { content: "\f143"; }
.flaticon5-telephone-1:before { content: "\f144"; }
.flaticon5-call:before { content: "\f145"; }
.flaticon5-phone-call-1:before { content: "\f146"; }
.flaticon5-phone-call-2:before { content: "\f147"; }
.flaticon5-end-call:before { content: "\f148"; }
.flaticon5-phone-call-3:before { content: "\f149"; }
.flaticon5-phone-call-4:before { content: "\f14a"; }
.flaticon5-phone-call-5:before { content: "\f14b"; }
.flaticon5-call-1:before { content: "\f14c"; }
.flaticon5-phone-call-6:before { content: "\f14d"; }
.flaticon5-incoming-call:before { content: "\f14e"; }
.flaticon5-call-2:before { content: "\f14f"; }
.flaticon5-outgoing-call:before { content: "\f150"; }
.flaticon5-phone-call-7:before { content: "\f151"; }
.flaticon5-service-call:before { content: "\f152"; }
.flaticon5-phone-call-8:before { content: "\f153"; }
.flaticon5-telephone-call:before { content: "\f154"; }
.flaticon5-international-call-symbol-of-earth-grid-with-a-phone-auricular-on-top:before { content: "\f155"; }
.flaticon5-phone-call-9:before { content: "\f156"; }
.flaticon5-phone-call-10:before { content: "\f157"; }
.flaticon5-phone-call-11:before { content: "\f158"; }
.flaticon5-merge-call:before { content: "\f159"; }
.flaticon5-missed-call:before { content: "\f15a"; }
.flaticon5-missed-call-1:before { content: "\f15b"; }
.flaticon5-call-3:before { content: "\f15c"; }
.flaticon5-call-4:before { content: "\f15d"; }
.flaticon5-call-5:before { content: "\f15e"; }
.flaticon5-phone:before { content: "\f15f"; }
.flaticon5-split-call:before { content: "\f160"; }
.flaticon5-call-6:before { content: "\f161"; }
.flaticon5-international-call-symbol-for-interface-of-half-earth-grid-with-a-phone-auricular:before { content: "\f162"; }
.flaticon5-phone-call-12:before { content: "\f163"; }
.flaticon5-call-7:before { content: "\f164"; }
.flaticon5-call-8:before { content: "\f165"; }
.flaticon5-facebook:before { content: "\f166"; }
.flaticon5-facebook-circular-logo:before { content: "\f167"; }
.flaticon5-whatsapp:before { content: "\f168"; }
.flaticon5-whatsapp-1:before { content: "\f169"; }
.flaticon5-twitter:before { content: "\f16a"; }
.flaticon5-youtube:before { content: "\f16b"; }
.flaticon5-youtube-1:before { content: "\f16c"; }
.flaticon5-instagram:before { content: "\f16d"; }
.flaticon5-instagram-1:before { content: "\f16e"; }
.flaticon5-add:before { content: "\f16f"; }
.flaticon5-add-1:before { content: "\f170"; }
.flaticon5-google-plus:before { content: "\f171"; }
.flaticon5-google-plus-logo-on-black-background:before { content: "\f172"; }
.flaticon5-checked:before { content: "\f173"; }
.flaticon5-tick:before { content: "\f174"; }
.flaticon5-tick-1:before { content: "\f175"; }
.flaticon5-double-tick-indicator:before { content: "\f176"; }
.flaticon5-exchange:before { content: "\f177"; }
.flaticon5-transfer-1:before { content: "\f178"; }
.flaticon5-transfer-2:before { content: "\f179"; }
.flaticon5-queue:before { content: "\f17a"; }
.flaticon5-phone-1:before { content: "\f17b"; }
.flaticon5-smartphone:before { content: "\f17c"; }
.flaticon5-chat-3:before { content: "\f17d"; }




/***
Tools
***/
.debug { border: 1px solid red; }
.inline { display: inline; }

.display-none, .display-hide { display: none; }
.visible-ie9 {display: none;}
.visible-ie8 {display: none;}

.no-border { border:0 !important; }

.no-space { margin: 0px !important; padding: 0px !important; }
.no-margin { margin:0 !important; }
.margin-bottom-5 { margin-bottom: 5px; }
.margin-bottom-10 { margin-bottom: 10px !important; }
.margin-top-10 { margin-top: 10px !important; }
.margin-bottom-15 { margin-bottom: 15px !important; }
.margin-bottom-20 { margin-bottom: 20px !important; }
.margin-top-20 { margin-top: 20px !important; }
.margin-bottom-25 { margin-bottom: 25px !important; }
.margin-right-10 { margin-right: 10px !important; }
.fix-margin { margin-left: 0px !important }

/* start html */


body {
    margin: 0;
    padding: 0;
    font-family: 'Roboto';
    font-weight: 400;
    min-width: 320px;
	/* 14.5.2020 html */
	overflow: hidden;
}

h1,
h2,
h3,
h4,
h5,
h6,
li,
ul,
p {
    margin: 0;
    padding: 0;
    list-style: none;
    font-weight: normal;
}

h1 {
    font-size: 18px;
}
h2 {
    font-size: 17px;
}

h3 {
    font-size: 16px;
}

h4 {
    font-size: 15px;
}
h5 {
    font-size: 14px;
}
h6 {
    font-size: 13px;
}

p {
    font-size: 14px;
}

a:focus,
a:hover {
    color: inherit;
   
    text-decoration: none;
}
a:focus, a:active, button, input[type="submit"] {
     outline: none !important;
}
a {
    color: inherit;
}
#wrapper {
    position: relative;
    overflow: hidden;
}
img {
    outline: none;
    border: none;
    margin: 0;
    padding: 0;
}

a {
    text-decoration: none;
}

.clear {
    clear: both;
}
.clears {
    clear: both;overflow: hidden;
}

.left {
    float: left;
}

.right {
    float: right;
}
.logo{
	
	display: block;

	
}
.main-wrapper{
	position: relative;
	
}
.banners{
	    display: block;
    clear: both;
    overflow: hidden;
}
.banners .slider-container .slider__item div {
    position: absolute;
    left: 0;
    top: 0;
    right: 0;
    bottom: 0;
    background-size: cover;
    background-position: 50% 50%;
    background-repeat: repeat;
}
.banners .slider-container .slider__item {
    position: relative;
    min-height: 100vh;
}
.login-wrp{
	position: absolute;
/*	 99999;*/
	width: 390px;
	background-color: rgba(255,255,255, 1);
	border: 1px solid #e9e9e9;
	left: 35.8%;
	padding: 30px 20px 30px 20px;
}
.logo {
/*
	height: 53px;
	margin-bottom: 30px;
*/
}
/* input */

.login-form .input {
	position: relative;
/*	 1;*/
	display: inline-block;

	max-width: 100%;
	width: 100%;
	vertical-align: top;
/*	margin-bottom: 20px;*/
/*	border: 1px solid #d8ebde;*/
}

.input__field {
	position: relative;
	display: block;
	float: right;
/*	padding: 0.8em;*/
	width: 60%;
	border: none;
	border-radius: 0;
	background: #f0f0f0;
	color: #aaa;
	font-weight: 300;

	-webkit-appearance: none; /* for box shadows to show on iOS */
}

.input__field:focus {
	outline: none;
}

.input__label {
	display: inline-block;
	float: right;
	padding: 0 1em;
	width: 40%;
	color: #696969;
	font-weight: bold;
	font-size: 70.25%;
	-webkit-font-smoothing: antialiased;
    -moz-osx-font-smoothing: grayscale;
	-webkit-touch-callout: none;
	-webkit-user-select: none;
	-khtml-user-select: none;
	-moz-user-select: none;
	-ms-user-select: none;
	user-select: none;
}

.input__label-content {
	position: relative;
	display: block;
	font-weight: 400;
	width: 100%;
	font-size: 13px;
}

.login-form .graphic {
	position: absolute;
	top: 0;
	left: 0;
	fill: none;

}

.login-form .icon {
	color: #ddd;
	font-size: 150%;
}
/* Nao */
/*
.input--nao {
	overflow: hidden;
	padding-top: 1em;
}
*/

.input__field--nao {
	padding: 16px 39px 16px 10px;
	width: 100%;
	background: transparent;
	color: #9da8b2;
	font-size: 13px;
	border: 1px solid #d8ebde;
	margin-bottom: 20px;
}

.input__label--nao {
	position: absolute;
    font-size: 15px;
	color: #477780;
	font-weight: 400;
    left: 0;
    display: block;
    width: 100%;
    text-align: left;
    /* width: 129px; */
    top: -11px;
    background-color: #fff;
    left: 9px;
    padding: 0;
    padding-left: 9px;
    /* float: left; */
    width: 119px;
 
/*
	padding: 0em;
	pointer-events: none;
	-webkit-transform-origin: 0 0;
	transform-origin: 0 0;
	-webkit-transition: -webkit-transform 0.2s 0.15s, color 1s;
	transition: transform 0.2s 0.15s, color 1s;
	-webkit-transition-timing-function: ease-out;
	transition-timing-function: ease-out;
*/
}
/*

.graphic--nao {
	stroke: #cfcfcf;
	pointer-events: none;
	-webkit-transition: -webkit-transform 0.7s, stroke 0.7s;
	transition: transform 0.7s, stroke 0.7s;
	-webkit-transition-timing-function: cubic-bezier(0, 0.25, 0.5, 1);
	transition-timing-function: cubic-bezier(0, 0.25, 0.5, 1);
} 

.input__field--nao:focus + .input__label--nao,
.input--filled .input__label--nao {
	color: #77c700;
	-webkit-transform: translate3d(0, -1.25em, 0) scale3d(0.75, 0.75, 1);
	transform: translate3d(0, -1.25em, 0) scale3d(0.75, 0.75, 1);
}

.input__field--nao:focus ~ .graphic--nao,
.input--filled .graphic--nao {
	stroke: #77c700;
	-webkit-transform: translate3d(-66.6%, 0, 0);
	transform: translate3d(-66.6%, 0, 0);
}


.input__field--fumi:focus + .input__label--fumi .input__label-content--fumi,
.input--filled .input__label-content--fumi {
	-webkit-animation: anim-fumi-1 0.3s forwards;
	animation: anim-fumi-1 0.3s forwards;
}
*/
.inputnao1{
	margin-top: 20px;
}
.inputnao{
	margin-top: 8px;
}
.inputnao .form-group select{
	width: 100%;
	border: none;
padding-bottom: 10px;
	color: #696969;
    font-size: 13px;
	border-bottom: 1px solid rgba(207,207,207, 0.7);
	background: transparent;
}
.input-btns{
	float: right;
overflow: hidden;
}
.input-btns button{
		margin-left: 12px;
	text-align: center;
	height: 40px;
	padding: 0 20px;
	color: #fff;
	background-color: #77c700;
	border: none;
	
	text-transform: uppercase;
	cursor: pointer;
	vertical-align: top;
	overflow: hidden;
}
.input-btns button:last-child{
	background: url(../images/refrest.png) center 8px no-repeat #303030;
}
/* other */

/* Global Button Styles */
/*
.input-btns a.animated-button:link, a.animated-button:visited {
	position: relative;
	
	padding: 5px 5px;
	color: #fff;
	font-size:14px;
	font-weight: bold;
	text-align: center;
	text-decoration: none;
	text-transform: uppercase;
	overflow: hidden;
	letter-spacing: .08em;
	border-radius: 2px;

	-webkit-transition: all 1s ease;
	-moz-transition: all 1s ease;
	-o-transition: all 1s ease;
	transition: all 1s ease;
	
}
.input-btns a.animated-button:link:after, a.animated-button:visited:after {
	content: "";
	position: absolute;
	height: 0%;
	left: 50%;
	top: 50%;
	width: 150%;
	 -1;
	-webkit-transition: all 0.75s ease 0s;
	-moz-transition: all 0.75s ease 0s;
	-o-transition: all 0.75s ease 0s;
	transition: all 0.75s ease 0s;
}
.input-btns a.animated-button:link:hover, .input-btns a.animated-button:visited:hover {
	color: #FFF;
	text-shadow: none;
}
.input-btns a.animated-button:link:hover:after, .input-btns a.animated-button:visited:hover:after {
	height: 450%;
}
.input-btns a.animated-button:link, .input-btns a.animated-button:visited {
	position: relative;
	
	padding: 8px 13px;
	color: #fff;
	font-size:14px;
	border-radius: 2px;
	font-weight: bold;
	text-align: center;
	text-decoration: none;
	text-transform: uppercase;
	overflow: hidden;
	letter-spacing: .08em;
	text-shadow: 0 0 1px rgba(0, 0, 0, 0.2), 0 1px 0 rgba(0, 0, 0, 0.2);
	-webkit-transition: all 1s ease;
	-moz-transition: all 1s ease;
	-o-transition: all 1s ease;
	transition: all 1s ease;
}

.input-btns a.animated-button.victoria-three {

}

.input-btns a.animated-button.victoria-three:before{
	position: absolute;
	background-color: green;
	content: "";
}
.input-btns a.animated-button.victoria-three:after {
	background: #303030;
	opacity: .5;
	-moz-transform: translateX(-50%) translateY(-50%);
	-ms-transform: translateX(-50%) translateY(-50%);
	-webkit-transform: translateX(-50%) translateY(-50%);
	transform: translateX(-50%) translateY(-50%);
}
.input-btns a.animated-button.victoria-three:hover:after {
	height: 140%;
	opacity: 1;
}
*/


.input-btns .sul {
	position: relative;
	display: inline-block;
	
	padding: 10px 20px;
	color: #fff;
	font-size:14px;
	font-weight: bold;
	text-align: center;
	z-index: 60;
	text-decoration: none;
	text-transform: uppercase;
	overflow: hidden;
	letter-spacing: .08em;

	text-shadow: 0 0 1px rgba(0, 0, 0, 0.2), 0 1px 0 rgba(0, 0, 0, 0.2);
	-webkit-transition: all 1s ease;
	-moz-transition: all 1s ease;
	text-decoration: none;
	-o-transition: all 1s ease;
	transition: all 1s ease;
	text-decoration: none;
	margin-left: 10px;
	
	
}

.input-btns .sul:hover:after {
	opacity: 1;
	height: 140%;
}
.input-btns .sul:before {
	position: absolute;
	left: 0;
	right: 0;
	top: 0;
	bottom: 0;
	content: '';
	z-index: -2;
	background: #77c700;
}
.input-btns .sul:after {
	content: "";
	position: absolute;
	height: 0;
	left: 50%;
	top: 50%;
	width: 150%;
	z-index: -1;
	-webkit-transition: all 0.75s ease 0s;
	-moz-transition: all 0.75s ease 0s;
	-o-transition: all 0.75s ease 0s;
	transition: all 0.75s ease 0s;
	background: #303030;
	opacity: 0.5;
	content: '';
	z-index: -1;
	transition: all 1s ease;
	-moz-transform: translateX(-50%) translateY(-50%);
	-ms-transform: translateX(-50%) translateY(-50%);
	-webkit-transform: translateX(-50%) translateY(-50%);
	transform: translateX(-50%) translateY(-50%);
	
}
.slider-nav{
	display: none;
}






.input-btns .sul1 {
	position: relative;
	display: inline-block;
	
	padding: 10px 20px;
	color: #fff;
	font-size:14px;
	font-weight: bold;
	text-align: center;
	z-index: 60;
	text-decoration: none;
	text-transform: uppercase;
	overflow: hidden;
	letter-spacing: .08em;
	
	text-shadow: 0 0 1px rgba(0, 0, 0, 0.2), 0 1px 0 rgba(0, 0, 0, 0.2);
	-webkit-transition: all 1s ease;
	-moz-transition: all 1s ease;
	text-decoration: none;
	-o-transition: all 1s ease;
	transition: all 1s ease;
	text-decoration: none;
	margin-left: 10px;
	vertical-align: top;
	height: 40px;
	
}

.input-btns .sul1:hover:after {
	opacity: 1;
	height: 100%;
}
.input-btns .sul1:before {
	position: absolute;
	left: 0;
	right: 0;
	top: 0;
	bottom: 0;
	content: '';
	z-index: -2;
	
	background: url(../images/refrest.png) center 10px no-repeat #303030;
	height: 40px;
}
.sul1:after {
	content: "";
	position: absolute;
	height: 0;
	left: 50%;
	top: 50%;
	width: 150%;
	z-index: -1;
	-webkit-transition: all 0.75s ease 0s;
	-moz-transition: all 0.75s ease 0s;
	-o-transition: all 0.75s ease 0s;
	transition: all 0.75s ease 0s;
	background: url(../images/refrest.png) center 10px no-repeat #77c700;
	opacity: 0.5;
	content: '';
	z-index: -1;
	transition: all 1s ease;
	-moz-transform: translateX(-50%) translateY(-50%);
	-ms-transform: translateX(-50%) translateY(-50%);
	-webkit-transform: translateX(-50%) translateY(-50%);
	transform: translateX(-50%) translateY(-50%);
	
}
.main-sidebar{
	background-color: #222e3a;
<!--	box-shadow: inset -20px 20px 25px 0px rgb(0 0 0 / 90%);-->
}
.logo{
/*	background-color: #f1f2f7;*/
	    position: relative;
/*    right: -8px;*/
    z-index: 99999999999999999999;
}
.content {
    /* min-height: 250px; */
    padding: 15px 15px 15px 15px;
    margin-right: auto;
    margin-left: auto;
    padding-left: 15px;
    padding-right: 15px;
    background-color: transparent !important;overflow: hidden;
}


/* tabs */
.navbar-static-top .nav-tabs .nav-item{
	margin-bottom: 0;
	border-left: 0;
	
}
.navbar-static-top .nav-tabs .nav-item:last-child{
	border-right: 0;
}

.navbar-static-top .nav-tabs .nav-link{
	border-radius: 0;
	border: none;
	
}
.navbar-static-top .nav-tabs .nav-link{
	font-size: 20px !important;
	font-weight: 500;
	opacity: 0.6;padding: 0 !important;
}
.navbar-static-top .nav-tabs .nav-link p{
	line-height: 0;
}
.navbar-static-top .nav-tabs .nav-link i{
	font-size: 21px;
	padding-right: 20px;
    padding-left: 20px;
	border-right: 1px solid rgba(0,0,0,0.20);
	
}
.navbar-static-top .nav-tabs .nav-link:hover{
	color: <?= $brandColor; ?>;opacity: 1;
	border: none;background-color: #fff !important;
}
.navbar-static-top .nav-tabs .nav-link.active{
	border: none;
color: <?= $brandColor; ?>;
	opacity: 1;
	border: none;
}
.navbar-static-top .navbar-static-top .nav-tabs {
    border: none;
}
.navbar-static-top .nav-link {
    display: block;
    padding: 14px 15px;
    text-align: center;
}

/* other tabs */

.box-wrp {
    position: relative;
    border-radius: 3px;
    background: #ffffff;
    margin-bottom: 0px;
/*    margin-bottom: 20px;*/
    width: 100%;
/*    box-shadow: 0 1px 1px rgba(0, 0, 0, 0.1);*/
	border: 1px solid #e0e4e9;
    /* overflow-y: auto; */
}
.box-hd {
    background-color: #222e3a;
    padding: 4px 10px;
   
    overflow: hidden;
    /* position: fixed; */
    width: 100%;
    z-index: 1;
    position: absolute;    border-radius: 3px 3px 0 0;
}
.box-hd h2 {
        color: #fff;
    font-size: 15px;
    font-weight: 500;
    float: left;
    line-height: 21px;
}
.extend {
    float: right;
    color: #fff;
    overflow: hidden;
}

.extend ul li:first-child a{
	    padding-top: 4px;
	font-size: 17px;
}
.extend ul li{
	
	float: left;
    padding: 0 0 0 12px;
}
.extend a {
    color: #fff;
    display: block;
    overflow: hidden;
}
.form-peding {
    width: 46.7%;
    display: inline-block;
    margin:0 0 12px 2%;
    position: relative;
	vertical-align: top;
}
.form-peding input {
    width: 100%;
    padding: 4px 12px 4px 12px;
    border: 1px solid #ededed;
    border-radius: inherit;
	font-size: 13px;
	height: 35px;
	color: #6e6e6e;
}

.form-peding textarea{
	width: 100%;
    padding: 4px 12px 4px 12px;
    border: 1px solid #ededed;
    border-radius: inherit;
	font-size: 13px;
	height: 50px;
}
.form-peding1 {
    width: 96%;
}


.fade {
  -webkit-transition: right 0.1s ease-in-out;
  -o-transition: right 0.1s ease-in-out;
  transition: right 0.1s ease-in-out;
}

.working-area-wrp {
    padding-top: 49px;
    max-height: calc(100vh - 135px);
    overflow-y: auto;
}
.content-wrapper .tab-pane .row {
    display: flex;
    min-height: calc(100vh - 130px);
    width: calc(100% + 30px);
    flex-flow: row wrap;
}

.content-wrapper .tab-pane .row > div {
  display: flex;
	
	
}
.form-txt{
	background-color: #f0f0f0;
	color: rgba(34,34,34, 0.7);
	font-size: 13px;
	height: 34px;
	padding: 0 12px;
	line-height: 33px;
	font-weight: 400;
}
.form-peding .form-control{
	  border: 1px solid #ededed;
	border-radius: 0 !important;
	font-size: 13px;
	color: #6e6e6e;
}
.logo-img{
/*width: 70%;*/
/*	margin-top: 10px;*/
	height: 34px;
    margin: 8px auto 0 auto;
    text-align: center;
    display: block;
}
.sidbr-mini{
	padding: 0 0 0 0;
}
.main-tabs .nav-tabs {
    
    background-color: #fff;
	border: 1px solid #e3e3e3 !important;
	border-radius: 3px;
	    margin-bottom: 15px;
	overflow: hidden;
}
.main-tabs .nav-tabs .nav-link.active {
    color: #fff;
    background-color: <?= $brandColor; ?>;
   border: none;
	font-size: 14px;
	 font-weight: 500;
	border-radius: 3px 0 0 3px !important;
	     padding: 9px 22px 10px 22px;
}
.dial-number ul{
	display: block;
	overflow: hidden;
/*	background-color: #2a3948;*/
/*	border: 1px solid #222e3a;*/
	margin-bottom: 6px;

}
.main-tabs .nav-tabs .nav-link i{
	margin-right: 10px;
}
.main-tabs .nav-tabs .nav-link {
    border-right: 1px solid rgba(227,227,227, 0.6);
    border-radius: 0 !important;
/*
	transform: skew(20deg);
transform-origin: bottom left;
*/
	color: #c1c1c1;
	font-size: 14px;
	 font-weight: 500;
	    padding: 9px 22px 9px 22px;
}
.main-tabs .nav-tabs .nav-link:focus, .nav-tabs .nav-link:hover{
	  background-color: <?= $brandColor; ?>;
	color: #fff;
	border-color: <?= $brandColor; ?>  
		;border-bottom: none !important;
}


.main-tabs .nav-tabs .nav-link p{
/*	transform: skew(-20deg);*/
}
.dial-number ul {
		margin-right: -2px;
	margin-left: -2px;
	overflow: hidden;
}
.dial-number ul li{
	width: 14.8%;
	text-align: center;
	float: left;
/*
	border-bottom: 1px solid #222e3a;
	border-right: 1px solid #222e3a;
*/

	background-color: #2a3948;
	margin-left: 2px;
    margin-right: 2px;
	border-radius: 3px;
    margin-bottom: 4px;
}
/*
.dial-number ul li:nth-child(3){
	border-right: none;
}
.dial-number ul li:nth-child(6){
	border-right: none;
}
.dial-number ul li:nth-child(9){
	border-right: none;
	
}
.dial-number ul li:nth-child(12){
	border-right: none;border-bottom: none;
}
.dial-number ul li:nth-child(10){
	border-bottom: none;
}
.dial-number ul li:nth-child(11){
	border-bottom: none;
}
*/

.dial-number ul li a:hover{
	background-color: <?= $brandColor; ?>;
}
.dial-number ul li a{
	text-align: center;
    font-size: 16px;
    font-weight: 500;
    padding: 5px 0;
    color: #fff;
    display: block;
    overflow: hidden;
	border-radius: 3px;
}
.dial-number p{
	text-align: center;
	font-weight: 500;
	font-size: 12px;
	color: #fff;
}

/* onoff */

.microph-wrp{
	overflow: hidden;
	clear: both;
	width: 100%;
	    padding: 3px 20px 0 20px;
	margin-bottom: 0;
}
.microph-wrp h3{
	float: left;
	font-size: 15px;
	font-weight: 300;
	color: #fff;
	
	
}
.microph-wrp .switch {
  position: relative;
  display: inline-block;
  width: 38px;
  height: 12px;
	float: right;
}

/* Hide default HTML checkbox */
.microph-wrp .switch input {
  opacity: 0;
  width: 0;
  height: 0;
}

/* The slider */
.microph-wrp .slider {
  position: absolute;
  cursor: pointer;
  top: 0;
  left: 0;
  right: 0;
  bottom: 0;
  background-color: #374b5e;
  -webkit-transition: .4s;
  transition: .4s;border-radius: 93px;
}

.microph-wrp .slider:before {
  position: absolute;
  content: "";
  height: 17px;
  width: 17px;
  left: 0;
  bottom: -2px;
  background-color: white;
  -webkit-transition: .4s;
  transition: .4s;border-radius: 93px;
}

.microph-wrp input:checked + .slider {
  background-color:<?= $brandColorHover; ?>;
 
}

.microph-wrp input:focus + .slider {
  box-shadow: 0 0 1px <?= $brandColorHover; ?>;
}

.microph-wrp input:checked + .slider:before {
  -webkit-transform: translateX(26px);
  -ms-transform: translateX(26px);
  transform: translateX(26px);
}

/* Rounded sliders */
.microph-wrp .slider.round {
  border-radius: 34px;
}

.microph-wrp .slider.round:before {
  border-radius: 50%;
}



.microph-wrp input:checked + .slider:before {
	left: 0;
	right: 4px;border-radius: 93px;
}
.dial-number{
	margin:0 0 5px 0;
	overflow: hidden;
	padding: 0 20px;

}

.dtmf{
/*	border: 1px solid #d2d6de;*/
	clear: both;
	width: 100%;
	overflow: hidden;
	background-color: #fff;
	margin-top: 10px;
	border-radius: 3px;
}
.dtmf input
{
	border: none;
	height: 39px;
	float: left;
	font-size: 13px;
	color: #222d32;
	font-weight: 300;
	padding:0 10px 0 10px;
    width: 81%;
}
.dtmf input:focus{
	  outline: none;
	box-shadow: 0 0 5px rgba(255, 255, 255, 0.1);
}
.dtmf button{
	width: 39px;
	height: 39px;
	background-color: <?= $brandColor; ?>;
	color: #fff;
	border: none;
	float: right;
	    margin-left: 1px;
}
.st-call span{
	float: left;
}

.second-line-status{
	margin-left: 10px;
}
.animation-icons i{
	    text-shadow: 0px 1px 0px rgba(0, 0, 0, 0.18);
	height: 30px;
	display: flex;
	align-items: center;
	justify-content: center;
	width: 30px;
}
.animation-icons{
	float: right;    text-shadow: 0px 1px 0px rgba(0, 0, 0, 0.18);
}
.st-call{
	height: 15px;
    width: 15px;
    float: left;
    border-radius: 90px;margin-top: 7px;
}
#st_call{
	margin-left: 10px;
	
	    font-size: 14px;
    color: rgb(255, 255, 255);
    text-shadow: 0px 1px 0px rgb(0 0 0 / 18%);
      float: left;
    font-weight: 500;
    line-height: 28px;
}

.sidebar-menus{
/*	overflow: hidden;*/
/*	display: inline-block;*/
	display: block;
}
.sidebar-menus ul
{
/*margin-left: -5px;*/
/*margin-right: -4px;*/
	
/*
	margin-left: -5px;
	margin-right: -5px;  
*/
    border-top: 1px solid rgba(255,255,255,0.05);
}
.sidebar-menus ul li
{
	    border-right: 1px solid rgba(255,255,255,0.05);
	display: inline-block;
	width: 50%;
/*	cursor: pointer;*/
/*	margin-bottom: 8px;*/
	float: left;
	
	position: relative;
/*	overflow: hidden;*/
	text-align: center;
}
/*
.sidebar-menus ul li:first-child{
	background-color: #1dd85f;
}
.sidebar-menus ul li:nth-child(2){
	background-color: #ec5451;
}
.sidebar-menus ul li:nth-child(3){
	background-color: #f99e35;
}
.sidebar-menus ul li:nth-child(4){
	background-color: #00aeff;
}
*/
.recording-btns li a p{
	font-size: 10px;
/*	color: #fff;*/
	font-weight: 400;
    text-align: center;
    margin-top: -5px;
}
.sidebar-menus ul li a i{
	 
/*
        position: absolute;
        top: 50%;
        left: 50%;
        margin-right: -50%;
        transform: translate(-50%, -50%);
	display: block;
*/
	display: flex;
    align-items: center;
    justify-content: center;
/*    padding-top: 9px;*/
    min-height: 25px;
    max-height: 27px;
	width: 100%;
	margin: 0 auto;
/*	border-radius: 3px;*/
	
	
	
<!--    min-height: 47px;-->
}
.sidebar-menus ul li a{
	
	width: 100%;
/*	height: 46px;*/
	color: #fff;
	display: block;
/*	overflow: hidden;*/
/*	position: relative;*/
/*	cursor: pointer;*/
/*	margin-bottom: 10px;*/
	text-align: center;
	    cursor: default ;
    color: rgba(255,255,255, 0.4);
	min-height: 50px;
	
    padding: 2px 0 0 0;
	    border-bottom: 1px solid rgba(255,255,255,0.05);
}


.sidebar-menus ul li a p{
	font-weight: 400;
    text-align: center;
    font-size: 11px !important;
   
   display: block !important;
}
.sidebar-menus ul li a:hover p
{
	display: block !important;
}
.dialcontrol-btn{
	background-color: #1dd85f;
}
.dialnext-btn{
	
	background-color: #1dd85f;
}
.hangup-btn{
	
	background-color: #ec5451;
}
.pausecode-btn{
	background-color: #f99e35;
}
.transfer-btn{
	background-color: #00aeff;
}
.leads{
	position: absolute;
	width: 100%;
	bottom: 0;
	background-color: <?= $brandColor; ?>;
	height: 22px;
}
.leads ul li{
	float: left;
	border-right: 1px solid #67aa01;
	width: 50%;
	height: 22px;
	
}
.leads ul li:last-child{
	border-left: 1px solid #82d702;
	border-right: none;
}
.leads ul li a{
	font-size: 12px;
	font-weight: 500;
	color: #fff;
	display: block;
	overflow: hidden;
	text-align: center;
	padding-top: 2px;
}
.sidemenus{
	display: block;
	overflow: hidden;
	position: absolute;
	bottom: 22px;
	width: 100%;
	
}

.sidemenus ul li{
	/* Permalink - use to edit and share this gradient: http://colorzilla.com/gradient-editor/#1d2021+0,303030+100,303030+100 */
background: rgb(29,32,33); /* Old browsers */
background: -moz-linear-gradient(left, rgba(29,32,33,1) 0%, rgba(48,48,48,1) 100%, rgba(48,48,48,1) 100%); /* FF3.6-15 */
background: -webkit-linear-gradient(left, rgba(29,32,33,1) 0%,rgba(48,48,48,1) 100%,rgba(48,48,48,1) 100%); /* Chrome10-25,Safari5.1-6 */
background: linear-gradient(to right, rgba(29,32,33,1) 0%,rgba(48,48,48,1) 100%,rgba(48,48,48,1) 100%); /* W3C, IE10+, FF16+, Chrome26+, Opera12+, Safari7+ */
filter: progid:DXImageTransform.Microsoft.gradient( startColorstr='#1d2021', endColorstr='#303030',GradientType=1 ); /* IE6-9 */
	
	border-top: 1px solid #3b3b3b;
}
.sidemenus ul li a{
	height: 47px;
	font-weight: 300;
	color: #f6fafb;
	font-size: 15px;
	display: block;
	padding: 0 10px;
	    line-height: 45px;
}

.sidemenus ul li a i{
	margin-right: 7px;
	font-size: 22px;
	
}
.warningclr2{
        position: absolute;
   top: 9px;
    right: 30px;
/*    text-align: center;*/
    font-size: 11px;
    height: 17px;
    width: 17px;
    border-radius: 50px;
    background-color: #ec5451;
/*    line-height: normal;*/
/*    padding-left: 2px;*/
    font-weight: 500;
	color: #fff;
   display: flex;align-items: center;justify-content: center;
   left: inherit;
	
}

.blink{  animation: blink 1s linear infinite;
overflow: hidden;
}

@keyframes blink{
0%{opacity: 0;}
50%{opacity: .5;}
100%{opacity: 1;}
}

/* top drop down menu */

.top-menu-bar {
	float: right;
	    margin-top: -1px;
}
.top-menu-bar ul {
 	display: block;
}

.top-menu-bar li {
	color: #fff;
  margin-top: 1px;
	display: block;
	float: left;
	
	position: relative;
	text-decoration: none;
  transition-duration: 0.5s;
	height: 51px;
	overflow: inherit;
	
/*	    margin-left: 8px;*/
	
/*	    border-left: 1px solid #e2e6eb;*/
/*    transform: skew(-20deg);*/
/*    transform-origin: bottom right;*/
}
  
.top-menu-bar li a {
  color: #fff;
	border: none;
	color: rgba(0,0,0,0.5);
	display: block;
	text-align: center;
	font-size: 18px;
/*	transform: skew(20deg);*/
	height: 51px;
	display: flex;
	align-items: center;
	justify-content: center;
}
.top-menu-bar li a i{
/*	margin-right: 10px;*/

	display: flex;
	align-items: center;
	justify-content: center;
/*	border-left: 1px solid rgba(219,219,219, 0.3);*/
	border-left: 1px solid rgba(0,0,0, 0.10);
	padding: 0 19px;
}
.top-menu-bar li:hover {
	 
	cursor: pointer;
}
.top-menu-bar li:hover a{
	color: <?= $brandColor; ?>;cursor: pointer;
}

.top-menu-bar ul li ul {
	background: #161f27;
	visibility: hidden;
  opacity: 0;
  min-width: 351px;
	position: absolute;
  transition: all 0.5s ease;
  margin-top: 1px;
	left: 0;
  display: none;
	text-align: left;
/*	border: 1px solid #e9e8ef;*/
	border-top: none;
	padding-bottom: 0px;
/*	transform: skew(20deg);*/
	overflow: hidden;
	border-bottom: none;
/*	margin-left: -42px;*/
	top: 50px;
/*	padding: 10px 5px 10px 10px;*/
	height: 400px;
    overflow-y: auto;border-radius: 0 0 5px 5px;
}

.top-menu-bar ul li:hover > ul,
.top-menu-bar ul li ul:hover {
  visibility: visible;
  opacity: 1;
  display: block;
}

.top-menu-bar ul li ul li {
	clear: both;
  	width: 100%;
	transform: matrix(1, 0, 0, 1, 0, 0);
}
.top-menu-bar li:last-child a{
/*	background-color: #2f2f2f;*/

	text-align: center;
	font-size: 21px;
    color: #bdc1c4 ;
/*    padding: 9px 21px 7px 15px;*/
	
}
/*
.top-menu-bar li:last-child a:hover{
	
	background-color: <?= $brandColor; ?>;
}
*/
.top-menu-bar li:last-child a i{
		margin-right: 0;
}
.compaign-wrp{
	background-color: <?= $brandColor; ?>;
	color: #fff;
	
	padding-left: 62px !important;
    padding-right: 26px !important;
	text-align: left;
	position: relative;
/*	transform: skew(-20deg);*/
}

.top-menu-bar li:last-child:hover a{
	color: <?= $brandColor; ?> !important;
}
.compaign-wrp::before{
	background: url(../images/compaign-icons.png) left top no-repeat;
left: 15px;
    top: 10px;
    position: absolute;
    content: "";
    height: 27px;
    width: 27px;
    transform: skew(20deg);
}
.compaign-wrp h2{
	font-size: 12px;
	color: #fff;
	text-align: left;
/*	transform: skew(20deg);*/
}
.compaign-wrp h3{
	
	color: #fff;
	font-size: 11px;
	text-align: left;
/*	transform: skew(20deg);*/
}
.top-menu-bar li:last-child a h6{
	color: #bdc1c4;
	float: left;
	padding-top: 8px;
    margin-right: 10px;
}

.user-pic{
	float: left;
	margin-right: 10px;
	margin-left: 16px;
	width: 42px;
    height: 42px;
	margin-top: 3px;
}
.user-pic img{
	border-radius: 100px;
	border: 1px solid #c7c7c7;
	width: 100%;
}

.user-informa{
	margin-top: 1px;
	cursor: default !important;
	width: 172px;
}
.user-txt{
	overflow: hidden;
	padding-right: 12px;
}

.user-txt h2{
	font-size: 14px;
	color: #2f2f2f;
	font-weight: 600;
	padding-bottom: 0;
	margin-bottom: 0;
}
.user-txt h3{
	font-size: 14px;
	color: #2f2f2f;
	font-weight: 400;
	padding-bottom: 0;
	margin-bottom: 0;
	margin-top: -2px;
	opacity: 0.8;
}
.user-txt p{
	font-size: 13px;
	color: #a8a8a8;
	font-weight: 400;
	background: url(../images/arrow-compaign.png) left 5px no-repeat;
	padding-left: 20px;
	line-height: normal;
	padding-top: 0;
	margin: 0;
	
	padding-bottom: 0;
margin-top: -4px;
}



/*
.modal.show  {
 position: absolute;
    left: 50%;
    top: 50%;
    box-shadow: 0px 0px 40px rgba(0,0,0,0.02);
    -moz-transform: translate(-50%, -50%);
    -webkit-transform: translate(-50%, -50%);
    -o-transform: translate(-50%, -50%);
    transform: translate(-50%, -50%);
 
    height: auto;
}
*/
.modal {
  text-align: center;
  padding: 0!important;
}

.modal:before {
  content: '';
  display: inline-block;
  height: 100%;
  vertical-align: middle;
  margin-right: -4px;
}

.modal-dialog {
  display: inline-block;
  text-align: left;
  vertical-align: middle;
}
.modal-header1{
	/* Permalink - use to edit and share this gradient: http://colorzilla.com/gradient-editor/#1d2021+0,303030+100 */
background: rgb(29,32,33); /* Old browsers */
background: -moz-linear-gradient(left, rgba(29,32,33,1) 0%, rgba(48,48,48,1) 100%); /* FF3.6-15 */
background: -webkit-linear-gradient(left, rgba(29,32,33,1) 0%,rgba(48,48,48,1) 100%); /* Chrome10-25,Safari5.1-6 */
background: linear-gradient(to right, rgba(29,32,33,1) 0%,rgba(48,48,48,1) 100%); /* W3C, IE10+, FF16+, Chrome26+, Opera12+, Safari7+ */
filter: progid:DXImageTransform.Microsoft.gradient( startColorstr='#1d2021', endColorstr='#303030',GradientType=1 ); /* IE6-9 */
	padding: 5px 14px;border-radius: 0;
}
.modal-title{
	font-size: 14px;
	color: #fff;
	font-weight: 500;
}
.modal-content1{
	border: none;
	border-radius: 0;
	padding: 0 !important;
}

.close{
	float: right;
    font-size: 1.5rem;
    font-weight: 400;
    line-height: 1;
    color: #fff;
    text-shadow:inherit !important; 
    opacity: 1;
}
.close:hover{
	color: #fff;
}
.modal-title {
   
    margin-top: 1px;
}
.modal-header .close-1{
	padding: 22px 28px 0 10px;}

.modal-footer{
	border-radius: 0;
	border: none;
}
/* dialler css with orignal IDS */

.tabs-wrappers{
	    border: 1px solid #e0e4e9;
	width: 100%;
	background-color: #FFF;
	
}

#DeactivateDOlDSessioNSpan table::before {
    position: absolute;
    width: 505px;
    height: 160px;
    content: "";
    left: 10px;
    top: 10px;
    border: 1px solid #e5e5e5;
}
#DeactivateDOlDSessioNSpan .sh_text{
	font-size: 16px;
    color: rgba(0,0,0, 0.8);
    text-align: left;
    font-weight: 400;
	float:left; 
}
#DeactivateDOlDSessioNSpan{
	right: 0 !important;
    bottom: 0 !important;
    top: 0 !important;
	background-color: rgba(34,46,58, 0.9);
	height: 100vh;
}
#AgenTDisablEBoX table::before {
    position: absolute;
    width: 505px;
    height: 160px;
    content: "";
    left: 10px;
    top: 10px;
    border: 1px solid #e5e5e5;
}
#AgenTDisablEBoX .sd_text p{
	min-height: 50px;
    display: flex;
    align-items: center;
	font-size: 16px;
}
#AgenTDisablEBoX .sd_text{
	font-size: 16px;
    color: rgba(0,0,0, 0.8);
    text-align: left;
    font-weight: 400;
	float:left;
	width: 100%;
}
#AgenTDisablEBoX a:hover{
	background-color: <?= $brandColorHover; ?>;
}
#AgenTDisablEBoX a{
    display: inline-block;
    height: 38px;
    border: none;
    border-radius: 0;
    text-transform: uppercase;
    font-size: 12px;
    font-weight: 400;
    color: #fff;
/*    margin-right: 10px;*/
/*    width: 105px;*/
    background-color: <?= $brandColorHover; ?>;
    /* margin-top: 10px; */
    margin-bottom: 10px;
    text-decoration: none;
    box-sizing: border-box;
    align-items: center;
    justify-content: center;
    line-height: 39px;
    cursor: pointer;
    position: relative;
    z-index: 1;
    text-align: center;
	padding-left: 10px;
	padding-right: 10px;
    margin-top: 10px;
    float: right;
}
#DeactivateDOlDSessioNSpan a:hover{
	
	background-color: <?= $brandColorHover; ?>;
}
#DeactivateDOlDSessioNSpan a{
    display: inline-block;
    height: 38px;
    border: none;
    border-radius: 0;
    text-transform: uppercase;
    font-size: 12px;
    font-weight: 400;
    color: #fff;
    margin-right: 10px;
    width: 105px;
    background-color: <?= $brandColorHover; ?>;
    /* margin-top: 10px; */
    margin-bottom: 10px;
    text-decoration: none;
    box-sizing: border-box;
    align-items: center;
    justify-content: center;
    line-height: 39px;
    cursor: pointer;
    position: relative;
    z-index: 1;
    text-align: center;	
	
    margin-top: 10px;
    float: right;
}
#AgenTDisablEBoX{
	
	right: 0 !important;
    bottom: 0 !important;
    top: 0 !important;
	background-color: rgba(34,46,58, 0.9);
	height: 100vh;
}
#AgenTDisablEBoX table {
    width: 525px;
    height: 180px;
    margin: 20% auto 0 auto;
    background-color: #fff;
    position: relative;
    overflow: hidden;
    padding: 30px 30px 0 160px;
    color: #6e6e6e;
	display: block;
}
#DeactivateDOlDSessioNSpan table {
    width: 525px;
    height: 180px;
    margin: 20% auto 0 auto;
    background-color: #fff;
    position: relative;
    overflow: hidden;
    padding: 30px 20px 0 160px;
    color: #6e6e6e;
	display: block;
}
#MainPanelCustInfo input{
    border: 1px solid #dfdfdf;
    font-size: 13px;
    color: #6e6e6e;
	min-height: 23px;
    margin-bottom: 5px;
}
#MainPanelCustInfo select{
    border: 1px solid #dfdfdf;
    font-size: 13px;
    color: #6e6e6e;
	min-height: 23px;
    margin-bottom: 5px;
}
#MainPanelCustInfo textarea{
    border: 1px solid #dfdfdf;
    font-size: 13px;
    color: #6e6e6e;
	min-height: 23px;
    margin-bottom: 5px;
}
#MainPanelCustInfo .body_text {
    color: #6e6e6e !important;
}

#DeactivateDOlDSessioNSpan br{
	display: none;
}
#AgenTDisablEBoX br{
	display: none;
}
#AgenTDisablEBoX tbody{
	display: block;
	width: 100%;
}
#AgenTDisablEBoX tbody tr{
	display: block;
	width: 100%;
}
#AgenTDisablEBoX tbody tr td{
	display: block;
	width: 100%;
}
#LogouTBox br{
	display: none;
}
#LogouTBox{
	right: 0 !important;
    bottom: 0 !important;
    top: 0 !important;
    background-color: rgba(34,46,58, 0.9);
    height: 100vh;
}

#LogouTBox table {
    width: 525px;
    height: 180px;
    margin: 12% auto 0 auto;
    background-color: #fff;
    position: relative;
    overflow: hidden;
    padding: 30px 20px 0 160px;
    color: #6e6e6e;
    display: block;
}
#LogouTBox table::before {
    position: absolute;
    width: 505px;
    height: 160px;
    content: "";
    left: 10px;
    top: 10px;
    border: 1px solid #e5e5e5;
}
#LogouTProcess{
	font-size: 16px;
    color: rgba(0,0,0, 0.8);
    text-align: left;
    font-weight: 400;
	clear: both;
	width: 100%;
	float: left;
	padding-top: 15px;
}
.loading_text{
	
	font-size: 16px;
    text-align: left;
    color: rgba(0,0,0, 0.8);
    font-weight: 400;
}
#LogouTProcess img{
	display: none;
}
#LogouTBoxLink a{
	 display: inline-block;
    height: 38px;
    border: none;
    border-radius: 0;
    text-transform: uppercase;
    font-size: 12px;
    font-weight: 400;
    color: #fff;
/*    margin-right: 10px;*/
/*    width: 105px;*/
    background-color: #303030;
    /* margin-top: 10px; */
    margin-bottom: 10px;
    text-decoration: none;
    box-sizing: border-box;
    align-items: center;
    justify-content: center;
    line-height: 39px;
    cursor: pointer;
    position: relative;
    z-index: 1;
    text-align: center;
	padding-left: 10px;
	padding-right: 10px;
    margin-top: 10px;
    float: right;
}

#LogouTBoxLink a:hover{
	
	background-color: <?= $brandColorHover; ?>;
}
#CallBacKsLisTBox{
	right: 0 !important;
    bottom: 0 !important;
    top: 0 !important;
    background-color: rgba(34,46,58, 0.9);
    height: 100vh;
}

#CallBacKsLisTBox p{
	clear: both;
	width: 100%;
	font-size: 13px;
    text-align: left;
    color: rgba(0,0,0, 0.8);
    font-weight: 400;
	display: block;
    padding: 11px 14px 0 14px;
}
#CallBacKsLisTBox h2 span{
	text-transform: uppercase;
	
}
#CallBacKsLisTBox h2{
/*
	background: rgb(29,32,33);
    background: -moz-linear-gradient(left, rgba(29,32,33,1) 0%, rgba(48,48,48,1) 100%);
    background: -webkit-linear-gradient(left, rgba(29,32,33,1) 0%,rgba(48,48,48,1) 100%);
    background: linear-gradient(to right, rgba(29,32,33,1) 0%,rgba(48,48,48,1) 100%);
    filter: progid:DXImageTransform.Microsoft.gradient( startColorstr='#1d2021', endColorstr='#303030',GradientType=1 );
*/
/*	background-color: <?= $brandColor; ?>;*/
	
	background-color: rgba(34,46,58, 1) !important;
/*    padding: 5px 14px;*/
    border-radius: 0;
	color: #fff;
	text-align: left;
	font-size: 15px;
}
#CallBacKsLisTBox br{
	display: none;
}
#CallBacKsLisTBox table{
/*
	background-color: #fff !important;
	margin: 0 auto;
	    width: 90%;    margin-top: 3%;
*/
}
#CallBacKsLisT{
/*	margin-top: 10px;*/
/*	padding: 0 10px;*/
	width: 100% !important;
	overflow-x: hidden;height: auto;max-height: 400px;
}
#CallBacKsLisT table{
/*
	width: 100% !important;
    background-color: #fff;
    border: 1px solid #e9e9e9 !important;
*/
	margin-top: 0;
}
.paging_bootstrap .pagination .disabled:hover{
	background-color: transparent !important;
}
.paging_bootstrap .pagination .disabled{
	background-color: transparent !important;
}

#CallBacKsLisT table tr td a {
/*
    border-radius: 2px;
    text-align: center;
    width: 100% !important;
    color: #fff;
    background-color: #222e3a;
    padding: 2px 3px;
    display: block;
    text-transform: uppercase;
    margin: 0 auto;
    position: relative;
*/
    /* width: 23px !important; */
    /* height: 23px; */
/*    text-align: center;*/
}
#CallBacKsLisT table tr {
/*
    border-top: 1px solid #e9e9e9 ;
	background-color: #fff !important;	
*/
}

#CallBacKsLisT table tr:nth-child(odd) {
/*    background-color: #f7f7f7;*/
}
#CallBacKsLisT table tr:first-child {
/*    background-color: <?= $brandColor; ?> !important;*/
}
#CallBacKsLisT table tr td {
/*
    font-size: 12px;
    color: #4c4c4c;
    line-height: 1.4;
    text-transform: lowercase;
    padding: 5px;
    color: rgba(0,0,0, 0.5);
*/
/*	border: 1px solid #e9e9e9 !important;*/    
/*	border: 1px solid rgba(209,209,209, .8);*/
}
#DispoSelectContent table tr td{
	height: auto !important;
	vertical-align: top;
}
#CallBacKsLisT table td, th {
    /* border: 1px solid #e9e9e9 !important; */
/*
    text-align: left;
    padding: 5px 5px 5px 5px;
    font-size: 13px;
    font-weight: 300;
*/
}
#CallBacKsLisT table tbody tr:first-child td {
/*    font-weight: 500;*/
/*    font-size: 13px;*/
/*    color: #fff;*/
/*    padding-bottom: 7px;*/
    /* text-transform: uppercase; */
}

#CallBacKsLisT table tr td .log_title{
	font-size: 12px !important;
	font-weight: 400 !important;
    font-family: 'Roboto';
	text-transform: uppercase;
}
.callbacklst{
	margin-top: 10px;
}

/* new css  3.10.2020 */


.btn-clr{
	background-color: <?= $brandColor; ?>;
}
.btn-clr1{
	background-color: #303030;
}

.footer-btns .btn-secondary.focus, .btn-secondary:focus{
	box-shadow: inherit !important;
}
.footer-btns button{
	height: 38px;
	    border: none !important;
    border-radius: 0 !important;
	text-transform: uppercase;
	font-size: 14px;
	font-weight: 400;
	color: #fff;
	margin-left: 10px;
	width: 112px;
	
}
.footer-btns button:first-child:hover{
	background-color: <?= $brandColor; ?>;
}
.footer-btns button:hover{
	color: #fff;
	background-color: #303030;
}
.footer-btns{
	float: right;
	width: 60%;
	text-align: right;
}
.footer-checkbx{
	float: left;
	width: 100%;
}

.microph-wrp1 h3{
	color: #797979;
	font-size: 14px;
	font-weight: 400;
	margin-top: -3px;
}


.microph-wrp1 .slider:before{
	    border: 1px solid #d5d5d5;
}

.dispostion-wrp{
	display: block;
	overflow: hidden;
}
.dispostion-wrp ul {
	margin-left: -5px;
	margin-right: -5px;
}
.dispostion-wrp ul li{
	margin-left: 5px;
	margin-right: 5px;
	width: 31.3%;
	background-color: #f0f0f0;
	border: 1px solid #e6e6e6;
	overflow: hidden;
	display: inline-block;
	    margin-bottom: 8px;
}

.dispostion-left{
	width: 38px;
	height: 38px;
	background-color: <?= $brandColor; ?>;
	padding:0 2px;
	float: left;
	text-align: center;
	font-weight: 500;
	color: #fff;
	font-size: 12px;
	
	
	
	
	
  display: flex;
  align-items: center;
  justify-content: center
}
.dispostion-right{
	
	text-align: left;
	color: #797979;
	font-size: 13px;
	font-weight: 400;
	padding-left: 9px;
	float: left;
	line-height: 37px;
	
	
}

.modal-dialog1{
	    max-width: 660px;
}

.microph-wrp1 .switch{
	float: left;
	margin-left: 15px;
} 
.dispostion-wrp ul li a{
	display: block;
	overflow: hidden;
	cursor: pointer;
}
.dispostion-wrp ul li:hover .dispostion-left{
	background-color: #303030;
}

.dispostion-wrp ul li:hover {
	background-color: <?= $brandColor; ?>;
}

.dispostion-wrp ul li:hover .dispostion-right{
	color: #fff;
}



.modal-dialog2{
	    max-width: 680px;
}


.Schedule-wrp-left{
	float: left;
	width: 40%;
	
}
.Schedule-wrp-right{
	float: left;
	width: 60%;
	padding-left: 20px;
	
}
.form-group label{
	font-size: 14px;
	color: #797979;
	font-weight: 400;
	clear: both;
	width: 100%;
}
.form-control
{
	height: 35px;
	border: 1px solid #e7e7e7 !important;
	border-radius: 0;
	font-size: 13px;
	color: #6e6e6e;
	font-weight: 400;
	   box-shadow: inherit !important;
}
.form-group .time-bx{
	width: 28.5%;
	display: inline-block;
		height: 35px;
/*	border: 1px solid #e7e7e7;*/
	border-radius: 0;
	font-size: 13px;
	color: #6e6e6e;
	font-weight: 400;
	margin-right: 9px;
	
}
.form-group .time-bx .form-control{
	padding: 0;
}
.form-group .time-bx:last-child{
	margin-right: 0;
}
.form-control:focus{
	box-shadow: inherit;
	    border-color: <?= $brandColor; ?>;
}


/* claneder */


.pignose-calendar .pignose-calendar-top .pignose-calendar-top-date{
	padding: 5px 0;
}
.pignose-calendar .pignose-calendar-top{
	padding: 5px 0;
	box-shadow: inherit;
	    background-color: #fff;
			;border-bottom: 1px solid #f3f3f3;
}
.pignose-calendar{
	border: 1px solid #eaeaea;
}
.pignose-calendar .pignose-calendar-body {
    padding: 5px;
}
.pignose-calendar .pignose-calendar-unit.pignose-calendar-unit-active a{
	background-color: #003b77;
}
.pignose-calendar .pignose-calendar-unit a{
	color: #003b77;
	box-shadow: inherit !important;
}
.pignose-calendar .pignose-calendar-unit{
	height: auto;
}
.pignose-calendar .pignose-calendar-header .pignose-calendar-week {
    float: left;
	height: 1.8em;
font-size: 12px;
    font-weight: 500;}

.pignose-calendar .pignose-calendar-header{
	    padding-top: 0;
    margin-top: 0;
}
.pignose-calendar .pignose-calendar-header{
	padding: 0;
}

.pignose-calendar .pignose-calendar-unit{
	line-height: normal;
}
.pignose-calendar .pignose-calendar-unit a{
	line-height: normal;
}
.pignose-calendar .pignose-calendar-unit.pignose-calendar-unit-active.pignose-calendar-unit-sat a, .pignose-calendar .pignose-calendar-unit.pignose-calendar-unit-active.pignose-calendar-unit-sun a{
/*	line-height: 25px;*/
}
.pignose-calendar .pignose-calendar-unit a{
/*
	height: 25px;
	width: 25px;
	    line-height: 25px;
*/
	line-height: 32px;
	    font-size: 13px;
}

.pignose-calendar {
    width: 100%;
	 max-width: 100%;
box-shadow: inherit !important;}

.pignose-calendar-top-month, .pignose-calendar-top-year{
	display: inline-block !important; 
}
.pignose-calendar .pignose-calendar-unit a{
	border-radius: 0;
}
.pignose-calendar .pignose-calendar-unit.pignose-calendar-unit-active a {
    background-color: <?= $brandColor; ?>;
}
.pignose-calendar .pignose-calendar-top .pignose-calendar-top-month{
	font-size: 18px;
	font-weight: 500;
	color: #7d7d7d;
}
.pignose-calendar .pignose-calendar-top .pignose-calendar-top-year{
	font-size: 18px;
	font-weight: 400;
	color: #7d7d7d;
}
.pignose-calendar .pignose-calendar-unit a {
	color: <?= $brandColor; ?>;}

.footer-btns1{
	width: 100%;
	margin-top: 15px;
}
.box11{
	background-color: #f0f0f0;
	height: 35px;
	color: #252728;

	line-height: 30px;
	margin-bottom: 10px;
	font-weight: 500;
	font-size: 16px;
	display: flex;
	align-items: center;
	justify-content: center;
}
.modal-dialog3{
width: 550px;	
}

.modal-header2{
	padding: 0 ;
}

.modal-content1 .nav-item:last-child{
	border: none;
}
.modal-content1 .nav-tabs .nav-item {
   
    border: none;
	background-color: #212424;
}
.modal-content1  .nav-tabs .nav-link.active{
	color: <?= $brandColor; ?>;
	border: none;
	border-top: 2px solid <?= $brandColor; ?>;
	border-radius: 0;
	
}
.modal-content1 .nav-tabs .nav-link {
    font-size: 14px;
    font-weight: 500;
    opacity: 1;
    color: #fff ;
		border: none;
	border-top: 2px solid #2c2c2c;
	border-radius: 0;

}

.modal-content1 .nav-link {
    display: block;
    padding: .5rem 90px;
}
.modal-content1 .nav-tabs-popup{
/*	background-color: #212424;*/
	border: none;
	overflow: hidden;
	    margin-top: 1px;
    background-color: #fff;
}
.close-1 {
    padding: 23px 29px 0 10px;
}
.modal-content1 .modal-header2{
		background-color: #303030;
	border-radius: 0;
	border: none;

}
.tab-content1{
	height: 235px;
}
.Schedule-wrp-left1{
	width: 50%; 
	float: left;
}

.Schedule-wrp-right1{
	width: 50%;
	float: left;
	padding-left: 20px;
}
.microph-wrp2{
	margin-bottom: 22px;
    margin-top: 33px;
	overflow: hidden;
}	
.btnslocal{
	height: 38px;
    border: none !important;
    border-radius: 0 !important;
    text-transform: uppercase;
    font-size: 14px;
    font-weight: 400;
    color: #fff;
   
    width: 112px;
	background-color: <?= $brandColor; ?>;
	width: 100%;
	margin-top:20px; 
}
.sehedule-menu{
	display: block;
	overflow: hidden;
}
.sehedule-menu li{
	display: block;
	margin-bottom: 7px;
	width: 100%;
	clear: both;
}


.sehedule-menu li a{
	border: 1px solid #d2d6de;
	display: block;
	font-size: 13px;
	color: #777777;
	font-weight: 400;
	overflow: hidden;
	    line-height: 35px;
	
}

.sehedule-menu li a i{
	background-color: <?= $brandColor; ?>;
	width: 38px;
	height: 38px;
	color: #fff;
	display: flex;
	align-items: center;
	justify-content: center;
	float: left;
	font-size: 18px;
	margin-right: 10px;
}
.sehedule-menu li:hover{
	background-color: <?= $brandColor; ?>;
}
.sehedule-menu li:hover a{
	color: #fff;
}

.sehedule-menu li:hover a i{
	background-color: #222425;
}
.form-group-margin{
	margin-bottom: 0;
}



.d-wrp li{

    display: inline-block;
    margin-right: 4px;
    margin-top: 8px;
}
.d-wrp ul li a {
    display: block;
   color: #fff;
    background-color: #292a2a;
    height: 39px;
    width: 39px;
    text-align: center;
    display: flex;
	align-items: center;
	justify-content: center;
}
/*
.sehedule-menu li:last-child{
	margin-bottom: 0;
}
*/

.sehedule-menu1 li{
	margin-bottom: 22px;
}

.microph-wrp4 .microph-wrp1 .switch {
    float: left;
/*    margin-left: 15px; */
/*    margin-right: 15px;*/
}
.microph-wrp4 {
	    float: left;
    width: auto;    margin-left: -5px;
}
.microph-wrp3 {
    margin-bottom: 20px;
    margin-top: 26px;
    overflow: hidden;
}

/* chat */


.chat-sections {
  overflow: hidden;
  display: block;
/*	padding-top: 71px;*/
/*	padding-top: 51px;*/
}

.chat-sections h2 {
  font-size: 20px;
  color: #454545;
font-weight: 300;
  border-bottom: 1px solid #efefef;
background-color: #fff;
  padding-bottom: 20px;
  margin-bottom: 0;
	padding-top: 20px;
	text-align: center;
}

.chat-bx {
  border-bottom: 1px solid #efefef;

  overflow: hidden;
}

.chat-bx a {
  padding: 12px 20px;
  display: block;
  overflow: hidden;
}

.user-pict {
  background-size: cover;
  width: 46px;
  height: 46px;

 
  border-radius: 50px;
  border: 1px solid #e2e6eb;
	display: block;
margin: 0 auto;
	position: relative;
}

.user-data {
  overflow: hidden;
  margin-top: 13px;
}

.user-data h3 {
  color: #000;
  font-size: 16px;
font-weight: 300;
  float: left;
  margin: 0;
}

.circle-online {
  width: 10px;
    height: 10px;
    border-radius: 30px;
    background-color: #0ac282;
    float: left;
    margin-top: 10px;
    border: 2px solid #fff;
	position: absolute;
    bottom: 5px;
    left: -2px;
}

.cirlceoffline {
  width: 7px;
  height: 7px;
  border-radius: 30px;
  background-color: #a4a4a4;
  float: right;
  margin-top: 6px;
}

a.closee {
  width: 42px;
  height: 36px;
  
  display: block;
  overflow: hidden;
  border-right: none;
  position: absolute;
  right: 12px;
/*  background-color: #fff;*/
	    background-color: rgba(34,46,58,1);
	background-color: #161f27;

  text-align: center;
  padding-top: 13px;
  margin-top: 0;
color: rgba(166,166,166, 1);
z-index: 2;

}
a.closee:hover{
	color: rgba(255,255,255, 0.9);
}
.nav-tabs{
	border: none;
}
.chat-agent-wrapper{
	
}
.chat-agent{
	
	width: 92px;
	float: left;
	border-right: 1px solid #efefef;
		background-color: #f1f1f1;
	
	    overflow-y: auto;
 max-height: calc(100vh - 51px);
/*   min-height: calc(100vh - 51px);*/
	
	    position: relative;
   
    
}

.chat-agent ul li{
	display: block;

	
}

.chat-agent ul li a{
	padding: 5px;
	display: block;
	    border-bottom: 1px solid #efefef;
	height: 95px;
	padding-top: 10px;
}

.chat-agent ul li a h3{
	text-align: center;
	font-size: 14px;
	    height: 35px;
	align-items: center;
	justify-content: center;
	display: flex;
	color: gray;
}
.msg-sectin{
/*
	    position: absolute;
    top: 5px;
    left: 20px;
*/
    text-align: center;
    font-size: 12px;
    height: 19px;
    width: 19px;
    border-radius: 50px;
    background-color: #ff627d ;
    line-height: normal;
    padding-left: 2px;
    font-weight: 500;

	color: #fff;
	position: absolute;
    right: -8px;
    top: -2px;
}
.cirlceoffline {
    width: 10px;
    height: 10px;
    border-radius: 30px;
    background-color: #a4a4a4;
    float: left;
    margin-top: 10px;
    border: 2px solid #fff;
    position: absolute;
    bottom: 5px;
    left: -2px;
}
.chat-agent ul li.active{
	    margin-right: -1px;
	background-color: #fff;
}


.chat-agent ul li.active a h3{
	color: #0ac282;
}

/* only chat */
.chat-history {
	padding: 20px 15px 20px 15px;
	overflow-y: auto;
	    max-height: calc(100vh - 58px);
} 
	.message-data { margin-bottom: 15px;
}
.message-data-time {
	color: rgba(128,128,128, 0.7);
	padding-left: 6px;
	font-size: 12px;
}
.message {
	color: white;
    padding: 10px 10px;
    line-height: normal;
    font-size: 13px;
    border-radius: 3px;
    margin-bottom: 20px;
    width: 95%;
    position: relative;}
	.message::after { bottom: 100%;
	left: 26px;
	border: solid transparent;
	content: " ";
	height: 0;
	width: 0;
	position: absolute;
	pointer-events: none;
	border-bottom-color: #86bb71;
	border-width: 10px;
	margin-left: -10px;
}

	.my-message {
		background: #86bb71;
	}

		.chat-message {
			padding: 5px 10px 0 10px;}
			
.other-message {
	background: #94c2ed;}
.other-message::after { border-bottom-color: #94c2ed;
	    left: 85%;
			}
.fa-file-o {
	font-size: 16px;
	color: gray;
	cursor: pointer;
}
.fa-file-image-o {
	font-size: 16px;
	color: gray;
	cursor: pointer;
}
.other-message button {
	float: right;
	color: blue;
	font-size: 16px;
	text-transform: uppercase;
	border: none;
	cursor: pointer;
	font-weight: bold;
	background: #F2F5F8;

}

.chat-with-customer{
	   
   
/*
    float: left;
    width: 228px;
*/
   background-color: #fff;
}
.message-data-name{
	font-size: 12px;
}
.chat-history .align-right{
	text-align: right;
}
.message-data i{
	color: #86bb71;
}
.align-right i{
	color: #94c2ed;
}
.chat-message{
	    position: absolute;
   background-color: #fff;
	overflow: hidden;
	display: block;
    bottom: 0;
	width: 100%;
    
}
#message-to-send{
	background-color: #f1f1f4;
	
	width: 100%;
			border: none;
			padding:10px 34px 10px 10px;
			font-size: 12px;
			
			border-radius: 5px;
			resize: none;
	margin-top: 5px;
	
}

.chatsubmit{
	background: url(../images/send-msg.png) 0px 12px no-repeat #f1f1f4;
    
    position: absolute;
    right: 12px;
    border: none;
    top: 10px;
    height: 39px;
    border-radius: 0 5px 5px 0;
    display: flex;
    align-items: center;
    justify-content: center;
    width: 27px;
	padding-top: 5px
}


.chat-sections{
	background-color: #fff;
	overflow: hidden;
}






.pause-reason-select {
	display: block;
}



.pause-reason-select ul li{
	float: left;
    width: 49%;
    border: 1px solid #e6e6e6;
    overflow: hidden;
    
	    margin-bottom: 15px;
}
.pause-reason-select ul li:nth-child(even){
	float: right;
}
.pause-reason-select ul li a .box-pause{
	height: 38px;
	width: 38px;
	background-color: <?= $brandColor; ?>;
	padding-top: 9px;
	margin-right: 15px;
	float: left;
	
}
.pause-reason-select ul li a .box-pause span{
	width: 20px;
    height: 20px;
    position: relative;
    border: 1px solid #fff;
    margin: 0 auto;
    display: block;
}
.pause-reason-select ul li a{
	display: block;
	cursor: pointer;
	overflow: hidden;
}

.pause-reason-select ul li a p{
	font-size: 14px;
	font-weight: 400;
	color: #797979;
	float: left;
	    line-height: 37px;

}

.pause-reason-select ul li:hover a .box-pause span::before{
	 font-family: Flaticon;
    position: absolute;
    font-style: normal;
    content: "\f10f";
    color: #fff;
    font-size: 12px;
    top: 0;
    left: 3px;
}
.pause-reason-select ul li:hover{
	background-color: <?= $brandColor; ?>;
}
.pause-reason-select ul li:hover a p{
	color: #fff;
}
.pause-reason-select ul li:hover .box-pause{
	background-color: #262828;
}




/* popup */

.modal-window {
  position: fixed;
  background-color: rgba(62, 73, 91, 0.95);
  top: 0;
  right: 0;
  bottom: 0;
/*  left: 0;*/
  z-index: 7;
  opacity: 0;
  pointer-events: none;
  -webkit-transition: all 0.3s;
  -moz-transition: all 0.3s;
  transition: all 0.3s;
	width: 230px;
}

.modal-window:target {
  opacity: 1;
  pointer-events: auto;
}

.modal-window>div {
  width: 100%;
  position: relative;
/*  margin: 10% auto;*/
  padding: 10px;
  height: 100vh;
  color: #444;
}

.modal-window header {
  font-weight: bold;
}

.modal-close {
  width: 42px;
	height: 42px;
/*	background-color: <?= $brandColor; ?>;*/
	display: block;
/*	border-radius: 60px;*/
	text-align: center;
	color: #fff;
	font-size: 23px;
	padding-top: 4px;
background: url(../images/cross1.png) center 14px no-repeat <?= $brandColor; ?>;
	 position: absolute;
    right: 10px;
    bottom: 10px;
    z-index: 1;
	border-radius: 50px;
}

.modal-close:hover {
  color: #000;
}

.modal-window h1 {
  font-size: 150%;
  margin: 0 0 15px;
}

/*
.new-menu{
    position: absolute;
    right: 10px;
    bottom: 10px;
    z-index: 999;
}

.new-menu a{
	width: 42px;
	height: 42px;
	background-color: <?= $brandColor; ?>;
	display: block;
	border-radius: 60px;
	text-align: center;
	color: #fff;
	font-size: 23px;
	padding-top: 4px;
}
*/

.new-menu{
	display: block;
	
}

a.open-model-btn{
	width: 42px;
	height: 42px;
	background-color: <?= $brandColor; ?>;
	display: block;
	border-radius: 0;
	text-align: center;
	color: #fff;
	font-size: 23px;
	padding-top: 4px;
	border-radius: 50px;
	 position: absolute;
    right: 10px;
    bottom: 10px;
    z-index: 5;

}

.right-menu
{
	position: absolute;
    left: 0;
    top: 0;
    width: 230px;
}

.right-menu li{
	display: block;
	clear: both;
	overflow: hidden;
	-webkit-transition: right 0.1s ease-in-out;
    -o-transition: right 0.1s ease-in-out;
    transition: right 0.1s ease-in-out;
	cursor: pointer;
	border-bottom: 1px solid rgba(81,93,113, 0.7);
	
}

.right-menu li a{
	display: block;
	color: #fff;
	font-size: 14px;
	font-weight: 300;
	padding: 18px 0 18px 0;
	padding-left: 24px;
}
.right-menu li a i{
	color: rgba(255,255,255, 0.7);
	margin-right: 15px;
}


.right-menu li:hover{
	padding: 9px 0 9px 9px;
}
.right-menu li:hover a{
	padding: 9px 0 9px 15px;
	background-color: <?= $brandColor; ?>;
	border-radius: 50px 0 0 50px;
}
.right-menu li:hover a i{
	    margin-right: 12px;
}
/*
.right-menu li a span{
	width: 35px;
	height: 35px;
	background-color: <?= $brandColor; ?>;
	color: #fff;
	font-size: 15px;
	display: block;
	float: right;
border-radius: 60px;
	
	align-items: center;
	display: flex;
	justify-content: center;

}
.right-menu li a span i{
	align-items: center;
	display: flex;
	justify-content: center;
}
*/

.chat-agent ul {
    overflow: hidden;
    height: calc(100vh - 116px); 
/*    max-height: calc(100vh - 71px);*/
    overflow-y: auto;
}
/* end */

/* scorall */
/* Let's get this party started */
::-webkit-scrollbar {
    width: 8px;
	height: 8px;
}
 
/* Track */
::-webkit-scrollbar-track {
/*    -webkit-box-shadow: inset 0 0 6px rgba(0,0,0,0.3); */
	-webkit-border-radius: 0px;
    border-radius: 0px;
}
 
/* Handle */
::-webkit-scrollbar-thumb {
    -webkit-border-radius: 0px;
    border-radius: 0px;
/*	background: rgba(69,92,115,1);*/
	background: rgba(206,206,206,1);
	border-radius: 50px;
/*    -webkit-box-shadow: inset 0 0 6px rgba(72,179,148,0.6);*/
}
::-webkit-scrollbar-thumb:window-inactive {
	background: rgba(206,206,206,1);
	border-radius: 50px;
}
.modal-lg-container{
	max-width: 100%;
 width: 90%;
}





.table-container tbody{
	width: 100%;
/*	display: block;*/
}

.table-container table {
  width: 100%;
  background-color: #fff;
	border: 1px solid #e9e9e9 !important;

}


 .table-container td {
    
    font-size: 12px;
    color: #4c4c4c;
    line-height: 1.4;
	text-transform: lowercase;
	 padding: 5px;
	 color: rgba(0,0,0, 0.7);
}
.table-container td::first-letter{
    text-transform: uppercase;}



/*
tr:nth-child(odd) {
    background-color: #f2f2f2;
}
*/

.table-container .table-hover > tbody > tr:hover {
    background-color: rgba(127,205,0, 0.1);
}




.table-container table tr td a{
	border-radius: 2px;
text-align: center;
width: 100% !important;
color: #fff;
background-color: <?= $brandColor; ?>;
	padding: 2px 3px;
display: block;
text-transform: uppercase;
	margin: 0 auto;
	position: relative;
	width: 23px !important;
	height: 23px;
	text-align: center; 
	
}
.table-container table tr td a::before{
	    font-family: Flaticon;
    position: absolute;
    font-style: normal;
    content: "\f109";
    color: #fff;
    font-size: 12px;
      top: 4px;
    left: 5px;
}


.table-container table tr td a:hover{
	background-color: #263238;
}

.table-container table tbody tr:first-child{
	background-color: <?= $brandColor; ?> !important;
}
.table-container table tbody tr:first-child td{
  font-weight: 500;
	font-size: 13px;
	color: #fff;
	
	padding-bottom: 7px;
/*	text-transform: uppercase;*/
	
}



 .table-container td, th {
/*    border: 1px solid #e9e9e9 !important;*/
    text-align: left;
   padding: 5px 5px 5px 5px;
	 font-size: 13px;
	 font-weight:300; 
}
.table-container tr{
	border-top: 1px solid #e9e9e9 !important;
}

.table-container{
	
	min-height: 530px;
	max-height: 530px;
	overflow-y: auto;
}


.modal-body-bx
{
	overflow: hidden;
}



.chat-history li:last-child .message{
/*	margin-bottom: 60px;*/
}

.iframe-chat{
	height: 91vh;
	width: 100%;
	border: none;
}
.online-agents-wrapper{
	display: block;
	overflow: hidden;
position: relative;  
   /*   max-height: calc(100vh - 110px);
    overflow-y: auto;*/
}

.online-agent-hd {
		padding: 0 23px;
}
.online-agent-hd h2 {
    font-size: 20px;
    color: #fff;
    font-weight: 300;
   
/*    background-color: #fff;*/
  
    text-align: left;
	float: left;
}
.online-agent-hd{
	 border-bottom: 1px solid rgba(255,255,255,0.10);
	  padding-bottom: 8px;
    padding-top: 8px;
	position: fixed;
	margin-bottom: 23px;
<!--	overflow: hidden;-->
	display: block;
/*	width: 100%;*/
	width: 470px;
	background-color: #161f27;
	z-index: 1;
}
.online-agent-hd ul {

	float: right;
    position: absolute;
    right: 25px;
    top: 55px;
    display: none;
}

.online-agent-hd ul li {
	width: 0;
      height: 0;
      border-bottom: 100px solid red;
      border-left: 100px solid transparent;
}
.online-agent-hd ul li{
	display: inline-block;
	margin-left: 12px;
	border: 1px solid #e3e3e3;
	
	font-weight: 300;
	color: #fff;
	font-size: 12px;
	text-transform: uppercase;
	text-align: left;
	padding-left: 5px;
	width: 72px;
	height: 25px;
	    padding-top: 3px;
	position: relative;
}

.online-agent-hd ul li::before{
	width: 0;
      height: 0;
      border-bottom: 25px solid #add8e6;
      border-left: 25px solid transparent;
	right: 0;
	bottom: 0;
	position: absolute;
	content: "";
}

.online-agent-hd ul li:nth-child(1){
	border: 1px solid #add8e6;
/*
	background-color: #add8e6;
    color: #161f27;
*/
}
.online-agent-hd ul li:nth-child(1)::before{

	
      border-bottom: 25px solid #add8e6;
  
	
}

.online-agent-hd ul li:nth-child(2){
	border: 1px solid #d8bfd8;
/*
	background-color: #d8bfd8;
    color: #161f27;
*/
}
.online-agent-hd ul li:nth-child(2)::before{

	
      border-bottom: 25px solid #d8bfd8;
  
	
}
.online-agent-hd ul li:nth-child(3){
	border: 1px solid #e8c04e;
/*
	background-color: #e8c04e;
    color: #161f27;
*/
}
.online-agent-hd ul li:nth-child(3)::before{

	
      border-bottom: 25px solid #e8c04e;
  
	
}
.online-agents-box {
   
   overflow: hidden;
/*   background-color: #f3f3f3;*/
	background-color: #222e3a;
   margin-bottom: 8px;
	display: block;
	width: 100%;
	clear: both;
}
.online-agents-box a{
	padding: 3px 12px 3px 14px;
	display: block;
	overflow: hidden;
	
}
.online-agents-time{
	width: 115px;
	float: right;
}
.online-agents-name{
	overflow: hidden;
	float: left;
}

.online-agents-name h3{
font-size: 15px;
	color: #fff;
	font-weight: 400;
	float: left;
}
.online-agents-name h4{
font-size: 15px;
	    color: rgba(255,255,255,0.7);
	font-weight: 400;
	float: left;
	text-align: left;
	margin-left: 10px;
}
.online-agents-time h6{
	
font-size: 13px;
	    color: rgba(255,255,255,0.7);
	font-weight: 400;
	text-align: right;
	float: right;
	
}
.online-agents-box h5{
	
font-size: 14px;
	
	font-weight: 400;
	text-align: left;
	float: left;
	position: relative;
}

.online-agents-box h5::before{
width: 11px;
    height: 11px;
    content: "";
    position: absolute;
    top: 3px;
    left: -15px;
    border-radius: 50px;
    border: 2px solid #fff;
}

.ready-clr{
	border-left: 4px solid #add8e6;
}
.ready-clr h5{
	
	color: #82aebc;
}

.ready-clr h5::before{
	
    background-color: #add8e6;
	left: -15px;
}

.incall-clr{
	border-left: 4px solid #d8bfd8;
}
.incall-clr h5{
	
	color: #c8a4c8;
}

.incall-clr h5::before{
	
    background-color: #d8bfd8;
}

.paused-clr{
	border-left: 4px solid #e8c04e;
}
.paused-clr h5{
	

	color: #e8c04e;
}

.paused-clr h5::before{

    background-color: #e8c04e;
}
.online-agent-main-container{
	padding: 0 23px;
    margin-top: 55px;

	    overflow-y: auto;
    max-height: calc(100vh - 170px);

}

/* 26.7.2019*/

/*
.webform-btn{
	background-color: <?= $brandColor; ?>;
    width: 100%;
    padding: 3px 0;
    text-align: center;
    font-size: 15px;
    color: #fff;
    border: none;
    margin-bottom: 7px;
}
*/
.modal-window-top-fade{
	    position: fixed;
    background-color: rgba(255, 255, 255, 0.70);
    top: 0;
    right: 0;
    bottom: 0;
    left: 0;
    -webkit-transition: all 0.3s;
    -moz-transition: all 0.3s;
    transition: all 0.3s;
}
.modal-window-top-white{
	    position: fixed;
    background-color: rgba(255, 255, 255, 1);
    top: 0;
    right: 0;
    bottom: 0;
    left: 0;
    -webkit-transition: all 0.3s;
    -moz-transition: all 0.3s;
    transition: all 0.3s;
}
.navbar-static-top .nav-link {
    padding: 14px 8px;
}

.user-informa {
    width: 154px;
}
.user-pic {
	margin-left: 13px;}



/*
.model-container{
	right: 0;
	bottom: 0;
	position: fixed !important;
	left: 0px;
    top: 0px;
	width: 100%;
}

.model-container table{
	width: 100%;
	background-color: rgba(34,46,58, 0.9);
	height: 100%;
}

.model-container table tr td tabel{

	background-color: #fff;
}
.model-container table tr td font span table{

	background-color: #fff;
}
.model-container table tr td font span table tbody{

	background-color: #fff;
}
.model-container table tr td tabel tbody{
	width: 100%;
}
.model-container table tr td{

	background-color: #fff;
}
*/
/*

.model-container table tbody{
	    width: 90%;
    margin: 0 auto;
    display: block;
    background-color: #fff;
	margin-top: 8%;
}
*/
.model-container br{
	display: none;
}
.modal-sm1 table tbody{
	    width: 500px;
}
.modal-md1 table tbody{
	    width: 800px;
}
.modal-headers1
{
	display: -ms-flexbox;
    display: flex;
    align-items: flex-start;
    justify-content: space-between;
	padding: 0;
   padding-left: 10px;
/*	background-color: <?= $brandColor; ?> !important;*/
/*	background: <?= $brandColor; ?> !important;*/
	
/*	background-color: #3e4a56;*/
	    background-color: rgba(34,46,58, 1) !important;
	height: 39px;
	display: block;
	clear: both;
	width: 100%;
}
.modal-headers1 h2{
	font-size: 14px;
    text-transform: uppercase;
    font-weight: 500;
	float: left;
	color: #fff;
	padding-top: 10px;padding-left: 6px;
}
.modal-headers1 .closed i{
	color: rgba(255,255,255,0.70);
}
.modal-headers1 .closed
{
/*	background-color: <?= $brandColor; ?>;*/
	background-color: #3e4a56;
	width: 47px;
	height: 39px;
	float: right;
	text-align: center;
	position: relative;
	cursor: pointer;color: #fff;
	display: flex;
	align-items: center;
	justify-content: center;  font-size: 13px;
	margin-left: 2px;color: rgba(255,255,255,0.70);
	
}
.modal-headers1 .closed:hover i{
	color: rgba(255,255,255,1);
}
.modal-headers1 .closed:hover{
	color: rgba(255,255,255,1);
}
/*
.modal-headers1 .closed::before{
	    font-family: "Font Awesome 5 Free";
    font-weight: 900;
    content: "\f00d";
    text-align: center;
    font-size: 13px;
    color: #fff;
    top: 10px;
    position: absolute;
    left: 20px;
}
*/

.model-container{
	display: table;
/*    position: absolute;*/
/*    top: 0;*/
/*    left: 0;*/
    height: 100%;
    width: 100%;
/*	background-color: rgba(34,46,58, 0.9);*/
/*	z-index: 9999;*/
	
}
.model-container .model-wrp{
  
    display: table-cell;
    vertical-align: middle;
	
}

.model-container .model-wrp .model-wrp-centre{

	  margin-left: auto;
    margin-right: auto;
    width: 500px;
	background-color: #fff;
/*	animation: fadeIn 1s ease-in both;*/
}

.model-contents{
	padding: 15px;
	overflow: hidden;
	background-color: #fff;

}
.model-footerss{
	padding: 10px;
	border-top: 1px solid #efefef;
	
	clear: both;
	display: block;
		float: right;
	background-color: #fff;
	width: 100%;
	text-align: right;
}
.model-footerss button {
    height: 38px;
    border: none !important;
    border-radius: 0 !important;
    text-transform: uppercase;
    font-size: 14px;
    font-weight: 400;
    color: #fff;
    margin-left: 10px;
    width: 112px;
}
.model-footerss .btn-clr {
    background-color: <?= $brandColor; ?>;
}
.model-footerss .btn-clr:hover {
    background-color: <?= $brandColor; ?>;
	color: #fff;
}

.modal-small .model-wrp .model-wrp-centre{
	    width: 400px;
/*	animation: fadeIn 1s ease-in both;*/
}
.modal-medium .model-wrp .model-wrp-centre{
	    width: 800px;
/*	animation: fadeIn 1s ease-in both;*/
}
.modal-large .model-wrp .model-wrp-centre{
	    width: 90%;
/*	animation: fadeIn 0.3s ease-in both;*/
/*	border: 1px solid rgba(255,255,255,0.3);*/
	border: 1px solid #a6a6a6;
}

.graphic--nao{
	display: none;
}
#input-1{
	background: url(../images/login-ico/icon4.png) 96% 13px no-repeat;
}
#input-2{
	background: url(../images/login-ico/icon1.png) 97% 11px no-repeat;
}
#input-3{
	background: url(../images/login-ico/icon2.png) 96% 13px no-repeat;
}
#input-4{
	background: url(../images/login-ico/icon3.png) 96% 13px no-repeat;
}
/* new login */

.login-container {
/*    background-size: cover;*/
    width: 100%;
    height: 100vh;
	background-color: rgba(34,46,58, 1);
}
.login-wrapper {
    display: table;
    position: absolute;
    top: 0;
    left: 0;
    height: 100%;
    width: 100%;
	z-index: 9;
}
.login-wrp-middle {
    display: table-cell;
    vertical-align: middle;
}
.login-wrp-inner {
    margin-left: auto;
    margin-right: auto;
    width: 300px;
	background-color: transparent !important;
/*	background-color: #2a3948;*/
/*	background-color: rgba(42,57,72,0.90);*/
/*	background-color: rgba(34,46,58, 0.90);*/
	padding: 0;
/*	border: 1px solid #e9e9e9;*/
}
.login-wrp-inner h2{
	font-size: 25px;
	color: #fff;
	font-weight: 300;
	text-align: center;
	margin-bottom: 25px;
	text-transform: uppercase;
}
.logos{
	margin: 0 auto;
	margin-bottom: 15px;
	text-align: center;
}
.form-grp{
	display: block;
	clear: both;
	width: 100%;
	position: relative;
}
.form-grp label{
	font-size: 14px;
    color: #477780;
    background-color: #fff;
    width: 125px;
    position: absolute;
    z-index: 9999;
    left: 10px;
    top: -10px;
    padding-left: 9px;
	display: none;
}
.form-grp input:-webkit-autofill,
.form-grp input:-webkit-autofill:hover, 
.form-grp input:-webkit-autofill:focus {
  border: 1px solid <?= $brandColor; ?>;
  -webkit-text-fill-color: #fff;
  -webkit-box-shadow: 0 0 0px 1000px <?= $brandColor; ?> inset;
  transition: background-color 5000s ease-in-out 0s;
	background-color: #fff !important;
}
.form-grp input:focus { 
/*    outline:  !important;*/
	 outline-color: <?= $brandColor; ?>;
    border-color: <?= $brandColor; ?>;
/*    box-shadow: 0 0 10px <?= $brandColor; ?>;*/
}
.form-grp input{
<!--    background-color: #FFFFFF !important;-->
    background-image: none;
    border: 1px solid #e5e6e7;
    border-radius: 1px;
    color: inherit;
    display: block;
<!--    padding: 6px 12px;-->
    transition: border-color 0.15s ease-in-out 0s, box-shadow 0.15s ease-in-out 0s;
    width: 100%;
	color: rgba(0,0,0, 0.7);    font-size: 0.9rem;color: #495057 !important;
	
	border-radius: 3px;
    padding: 12px 12px;
    background-color: #e0e7ee !important;
    
}
.form-grp select{
	width: 100%;
<!--    padding: 6px 12px;-->
	clear: both;  border-radius: 1px;
	color: rgba(71,119,128, 1);
	font-size: 0.9rem;
	border: 1px solid #e5e6e7;
<!--    background-color: #FFFFFF !important;-->
 	border-radius: 10px !important;
    padding: 12px 12px;
    background-color: #e0e7ee !important;
	 transition: border-color 0.15s ease-in-out 0s, box-shadow 0.15s ease-in-out 0s;color: #495057 !important;
	 	border-radius: 3px !important;
}
.form-grp {
    margin-bottom: 1rem;
}
.form-grp input::placeholder{
	color: rgba(0,0,0, 0.7);
/*	font-style: italic;*/
/*	font-size: 13px;*/
}
.bg-white{
	
}
.form-comg{
	width: 86%;
	float: left;
}
.refresh{
	width:34px;
	float: right;
}
.refresh-btn{
	height:34px;
	width: 100%;
	float: right;
	background: url(../images/refrest.png) center 7px no-repeat <?= $brandColor; ?>;
	border: none;
	cursor: pointer;   
/*	background-size: 16px;*/
}
.refresh-btn:hover{
	   color: #fff;
    background-color: <?= $brandColorHover; ?> !important;
    outline: 0;
}
.login-ico1{
	background: url(../images/login-ico/icon1.png) 96% 10px no-repeat;
/*    background-size: 19px;*/
}
.login-ico2{
	background: url(../images/login-ico/icon2.png) 96% 10px no-repeat;
/*	background-size: 19px;*/
}
.login-ico3{
	background: url(../images/login-ico/icon3.png) 96% 13px no-repeat;
/*    background-size: 15px;*/
}
.login-ico4{
	background: url(../images/login-ico/icon4.png) 96% 13px no-repeat;
/*    background-size: 15px;*/
}
.loginbtn{
	width: 100%;
	color: #fff !important;
	border: none;
	cursor: pointer;
    background-color: <?= $brandColor; ?>!important;
    border: none;
	    letter-spacing: normal;
    word-spacing: normal;    line-height: 1.5;font-weight: 400;
    text-align: center;
    white-space: nowrap;    color: #fff;transition: 0.3s ease all !important;
	
	font-size: 13px;font-weight: 400;
	border-radius: 10px !important;
	padding:12px 0 12px 0;
/*	margin-left: 15px;*/
    margin-top: 20px;
}
.loginbtn:hover{
	    color: #fff;
    background-color: <?= $brandColorHover; ?> !important;
    outline: 0;
/*    -webkit-box-shadow: inset 0 3px 5px rgb(0 0 0 / 13%);*/
/*    box-shadow: inset 0 3px 5px rgb(0 0 0 / 13%);*/
}
.user-com-info{
	background-color: #2a3948;
	height: 53px;
	margin-bottom: 16px;
	position: relative;
	width: 100%;
}
.user-pics{
	background-size: cover;
    height: 35px;
    width: 35px;
    float: left;
    border-radius: 50px;
    margin-left: 0;
    margin-top: 7px;
    margin-right: 6px;
    border: 1px solid rgba(0,0,0, 0.10);
    background-color: #fff;
    background-position: center top;background-repeat: no-repeat;    position: relative;
    z-index: 9;
}
.user-name{
	padding-top: 6px;padding-right: 15px;    padding-left: 5px;  position: relative;
    z-index: 9;
}
.campaign-container{
	    
    
}
.user-name h1{
	color: <?= $brandColor; ?>;
	font-size: 13px;
	font-weight: 500;
	margin-top: 3px;
}
.user-name p{
	color: #000;
	font-size: 11px;
	font-weight: 500;    opacity: 0.8;
}
.campaign-name{
	float: right;    
}
.campaign-name h2{
/*	background: url(../images/login-ico/compaign1.png) center 5px no-repeat;*/
	padding-top: 31px;
	color: #000;
	font-size: 12px;
	font-weight: 500;
/*	margin-left: -16px;*/
	text-align: center;
	position: relative;
	}
.campaign-name h2::before{
	position: absolute;
	top: 5px;
	left: 0px;color: #00a8eb;
	font-size: 21px;
	text-align: center;   font-family: "Flaticon5";
	content: "\f12f";width: 100%;
}

.user-sip{
	float: left;
	height: 51px;background-color: #ebebeb;padding:0;position: relative;
	
}
.user-sip::after{
	background-color: #ebebeb;
	  right: 0px;
	height: 51px;width: 50px;
	  top: 0;
	  content: "";position: absolute;display: none;
}
  .user-sip::before {
      width: 0;
      height: 0;
      border-bottom: 51px solid #ebebeb;
      border-left: 35px solid transparent;
	  position: absolute;
	  left: -35px;
	  top: 0;
	  content: "";
/*	  display: none;*/
    }
.microph-wrp2{
	margin-left: 0 !important;
	margin-right: 15px;
	width: auto !important;
}
.campaign-name{
	float: left;
/*
	right: 0;
	top: 0;
*/
/*	width: 74px;*/
/*	background-color: #1d2936;*/
/*	height: 53px;*/
	
	height: 51px;position: relative;z-index: 999;margin-right: 40px;
}
.diable-ld{
	    border-left: 1px solid #e3e3e3;
/*    transform: skew(20deg);*/
    transform-origin: bottom left;
   	padding-top: 8px;
	height: 51px;
    
}
.diable-ld a{
	display: block;
	 color: #c1c1c1;
    font-size: 14px;
    font-weight: 400;
/*	background-color: #eeeeee;*/
	padding-left: 15px;
	padding-right: 15px;
	padding-top: 5px;
	padding-bottom: 5px;
	color: #787878;
}

.diable-ld a p{
/*	transform: skew(-20deg);*/
}

.top-menu-bar li a .queue_text{
	display: block;
    font-size: 13px;
    font-weight: 400;
    /* background-color: #eeeeee; */
    color: #787878;
/*	transform: skew(20deg);*/
}
.top-menu-bar li:first-child {
/*
    padding-top: 9px;
	    margin-right: 9px;
*/
}
.search-gp{
	width: 48%;
	float: left;
}
.search-gp:nth-child(even){
	width: 48%;
	float: right;
}
.search-gp label{
	font-size: 13px;
	font-weight: 500;
}
.search-gp input{
	width: 100%;
	border: 1px solid #e3e3e3;
	height: 35px;
	margin-bottom: 17px;font-size: 13px;
	font-weight: 400;
	padding: 0 10px;
}
.search-grpu-lg{
	clear: both;
	width: 100%;
}

/* check box design */

.chkbox {
  display: block;
  position: relative;
  padding-left: 30px;
/*  margin-bottom: 12px;*/
  cursor: pointer;
  -webkit-user-select: none;
  -moz-user-select: none;
  -ms-user-select: none;
  user-select: none;
	color: #6e6e6e;
	font-size: 13px;
	font-weight: 300;
}

/* Hide the browser's default checkbox */
.chkbox input {
  position: absolute;
  opacity: 0;
  cursor: pointer;
  height: 0;
  width: 0;
}

/* Create a custom checkbox */
.checkmark {
  position: absolute;
  top: 0;
  left: 0;
  height: 20px;
  width: 20px;
background-color: #fff;
	border: 1px solid #e3e3e3;
}

/* On mouse-over, add a grey background color */
.chkbox:hover input ~ .checkmark {
  background-color: <?= $brandColor; ?>;
	border: 1px solid #e3e3e3;
}

/* When the checkbox is checked, add a blue background */
.chkbox input:checked ~ .checkmark {
  background-color: <?= $brandColor; ?>;
}

/* Create the checkmark/indicator (hidden when not checked) */
.checkmark:after {
  content: "";
  position: absolute;
  display: none;
}

/* Show the checkmark when checked */
.chkbox input:checked ~ .checkmark:after {
  display: block;
}

/* Style the checkmark/indicator */
.chkbox .checkmark:after {
  left: 6px;
  top: 3px;
  width: 5px;
  height: 10px;
  border: solid white;
  border-width: 0 2px 2px 0;
  -webkit-transform: rotate(45deg);
  -ms-transform: rotate(45deg);
  transform: rotate(45deg);
}
.section-check label{
	    font-size: 13px;
    font-weight: 400 !important;
	display: inline-block;
	margin-bottom: 15px;
	margin-right: 15px;
}
.notif{
	padding: 13px;
	background-color: #d4edda;
	overflow: hidden;
	border-radius: 3px;
	margin-top: 20px;
}
.notif i {
	float: left;
	border: 2px solid #648a6b;
	height: 26px;
	width: 26px;
	color: #648a6b;
	border-radius: 50px;
	font-size: 11px;
	text-align: center;
	padding-top: 2px;
	margin-right: 15px;
}
.notif p{
	color: #155724;
	font-weight: 400;
	font-size: 13px;
	text-align: left;
/*	float: left;*/
	overflow: hidden;
}
/*end  check box design */

.footer-checkbx-lg{
	width: 100%;
}
.model-contents-pding{
	padding: 0;
	border: 1px solid #e2e2e2;
	border-bottom: none;
}
.group-selt{
	width: 50%;
	float: left;
	height: 300px;
}

.group-selt .group-select-box{
	font-size: 12px;
	color: #777777;
	font-weight: 400;
	min-height: 30px;
	 display: flex;
  align-items: center;
  justify-content: center;
	border-bottom: 1px solid #ededed;
}
.group-selt .group-select-box:first-child{
	min-height: 40px !important;
	color: <?= $brandColor; ?> !important;
	font-weight: 500;
}
.group-selt .group-select-box a{
	display: block;
	overflow: hidden;
}
.group-selt .group-select-box:nth-child(odd){
	background-color: #f3f3f3;
	
}
.group-selt h2{
	padding: 12px 0;
	text-align: center;
	color: #fff;
	font-size: 14px;
	text-transform: uppercase;
	background-color: #222e3a;
}
.group-border{
	border-right: 1px solid rgba(232,232,232, 0.8);
}
.microph-wrps1 .switch{
	margin-left: 0;
	margin-right: 10px;
}
.microph-wrps1{
	margin-bottom: 15px;
}

/* table */


/*
 table {
	 width: 100%;
}
*/
 table th {
/*	 text-align: left;*/
/*	 border-bottom: 1px solid #ccc;*/
}
 table th, table td {
/*	 padding: 0.4em;*/
}
.fold-table{
	border: 1px solid #e3e3e3 !important;
	border-top: none !important;
}
 table.fold-table > tbody > tr.view td, table.fold-table > tbody > tr.view th {
	 cursor: pointer;
	 font-size: 11px;
    color: #6e6e6e;
}
 table.fold-table > tbody > tr.view td:first-child, table.fold-table > tbody > tr.view th:first-child {
	 position: relative;
	 padding-left: 20px;
}
 table.fold-table > tbody > tr.view td:first-child:before, table.fold-table > tbody > tr.view th:first-child:before {
	 position: absolute;
	 top: 61%;
	 left: 5px;
	 width: 9px;
	 height: 16px;
	 margin-top: -8px;
	 font: 12px fontawesome;
	 color: #999;
	 content: "\f067";
	 transition: all 0.3s ease;
}
 table.fold-table > tbody > tr.view:nth-child(4n-1) {
	 background: #eee;
}
 table.fold-table > tbody > tr.view:hover {
	 background: <?= $brandColor; ?>;
}
 table.fold-table > tbody > tr.view:hover td{
	 color: #fff !important;
}
 table.fold-table > tbody > tr.view.open {
/*	 background: tomato;*/
	 background-color: <?= $brandColor; ?>;
	 color: white;
}
 table.fold-table > tbody > tr.view.open td {

	 color: white;
}
 table.fold-table > tbody > tr.view.open td:first-child:before, table.fold-table > tbody > tr.view.open th:first-child:before {
/*	 transform: rotate(-180deg);*/
	 color: #333;
}
 table.fold-table > tbody > tr.fold {
	 display: none;
}
 table.fold-table > tbody > tr.fold.open {
	 display: table-row;
}
 .fold-content {
	 padding: 0.5em;
}
 .fold-content h3 {
	 margin-top: 0;
}
 .fold-content > table {
	 border: 2px solid #ccc;
}
 .fold-content > table > tbody tr:nth-child(even) {
	 background: #eee;
}
/*
.fold-table table tbody{
	width: 100%; 
	display: inherit;
}
*/



.fold-table > tbody > tr > td {
	border-right: 1px solid #efefef;
}
.fold-table > tbody{
	padding: 0 !important;
	margin: 0 !important;
/*	display: inherit !important;*/
	width: 100% !important;
}

.fold-table > thead{
	background-color: #222e3a;
	font-size: 11px;
	font-weight: 400;
}
.fold-table > thead > tr > th {
	border-right: 1px solid #5c6977;
	font-size: 11px;
}
.fold-table > thead > tr{
	font-size: 11px;
	color: #fff;
	font-weight: 400;
	text-transform: uppercase;
}
table.fold-table > tbody > tr.view:nth-child(4n-1) td{
	border-right: 1px solid #ffffff;
}
/*

table.fold-table > tbody > tr.view:hover 
*/
table.fold-table > tbody > tr.view td:first-child:before:hover{
	color: #fff !important;
}
table.fold-table > tbody > tr.view td:first-child:before:hover{
	color: #fff !important;
}


table.fold-table > tbody > tr.view:hover td, table.fold-table > tbody > tr.view.open td{
	border-right: 1px solid #50d1b7;
}
table.fold-table > tbody > tr.view:hover td:first-child:before,
table.fold-table > tbody > tr.view.open td:first-child:before{
	color: #fff !important;
}

.old-calls-data  > table > thead{
	background-color: #58595d;
	border-bottom: 1px solid #edefec;
	border-top: 1px solid #edefec;
}
.old-calls-data  > table > thead tr th{
	color: #fff;
	font-size: 11px;
	font-weight: 500;
	
}

.old-calls-data  > table > thead tr{
border-bottom: 1px solid #fff;
	border-top: 1px solid #fff;
	
}
.old-calls-data  > table > tbody tr td{
		color: #6e6e6e;
	font-size: 11px;
	font-weight: 400;
}

.old-calls-data  > table > tbody tr{
background-color: #fff;
	border-bottom: 1px solid #ddd;
}
.agent-call-wrp-clender button{
	background-color: <?= $brandColor; ?>;
	border: 1px solid <?= $brandColor; ?>;    vertical-align: top;
}
.agent-call-wrp-clender input{
	  height: 31px;
    border: 1px solid #e3e3e3;
    vertical-align: top;
    margin-right: -4px;
}
.fold-content{
	background-color: #edefec;
}

.agent-call-wrp{
	margin-bottom: 15px;
}
.agent-call-wrp button{
	background-color: #222e3a;
	border: none;
	font-size: 12px;
	color: #fff;
	padding: 5px ;
}
.agent-call-wrp button i{
	margin-right: 5px;
}
.agent-call-wrp-clender{
	float: right;
}
.fold-content table > tbody > tr label{
font-size: 12px;
	color: #797e84;
	font-weight: 400;
}


.fold-content > table{
	border: none;
}
.fold-content > table tbody tr{
	width: 100%;
/*	display: table;*/
}
.fold-content > table tbody tr .inr_bnr{
	border: 1px solid #ddd;
	border-radius: 2px;
	height: 26px;
	background-color: #fff;
	padding: 0 10px;
	line-height: 24px;
	font-size: 11px;
	font-weight: 400;
	color: #797e84;
} 
.fold-content > table tbody tr label{
	font-size: 11px;
	font-weight: 400;
	color: #797e84;
	margin-bottom: 3px;
}
.top-menu-bar li:last-child{
/*	background-color: #f1f2f7;*/
	border: none;
	border-radius: 0px 0 0 0;
}
.main-header .navbar{
	
	border-radius: 0 0 0 0;
}
.dropdwon-hotkeys li:last-child{
	background-color: #fff;
}

.top-menu-bar li:last-child:hover{
	
/*	    background-color: <?= $brandColor; ?>;border-radius: 0px 20px 0 0;*/
}

/* other */
.form-grp{
	position: relative;
}
.usertick {
  text-align: center;
 	border: 1px solid #d8ebde;
	height: 43px;
	width: 43px;
	position: absolute;
	right: 0;
	top: 0;
	padding-top: 10px;
	
	
}


.usertick #m-check-mark {

  width: 20px;
  height: auto;
  display: inline;
}

.usertick #checkmark {
  stroke-dasharray: 640;
    stroke-dashoffset: 0;
  -webkit-transform-origin: center;
      -ms-transform-origin: center;
          transform-origin: center;
  -webkit-animation: draw-around 1s infinite;
      -ms-animation: draw-around 1s infinite;
          animation: draw-around 1s infinite;
	
}
@-ms-keyframes draw-around {
  0% {
    stroke-dashoffset: 640;
  }
  10% {
    stroke-dashoffset: 640;
  }
  100% {
    stroke-dashoffset: 0;
  }
}
@-webkit-keyframes draw-around {
  0% {
    stroke-dashoffset: 640;
  }
  10% {
    stroke-dashoffset: 640;
  }
  100% {
    stroke-dashoffset: 0;
  }
}
@keyframes draw-around {
  0% {
    stroke-dashoffset: 640;
  }
  10% {
    stroke-dashoffset: 640;
  }
  100% {
    stroke-dashoffset: 0;
  }
}

.animation-icon{
	text-align: center;
/* 	border: 1px solid #d8ebde;*/
/*	border-left: 1px solid #495663;*/
/*	border-bottom: 1px solid <?= $brandColor; ?>;*/
	height: 32px;
	width: 32px;
	position: absolute;
	right: 7px;
	top: 6px;
	padding-top: 0;
	background-color: #e0e7ee;
}
.animation-icon svg {
  width: 30px;
  display: block;
	margin: 0 auto;
	text-align: center;
}
.animation-icon .path {
  stroke-dasharray: 1000;
  stroke-dashoffset: 0;
}
.animation-icon .path.circle {
  -webkit-animation: dash 0.9s ease-in-out;
  animation: dash 0.9s ease-in-out;
}
.path.line {
  stroke-dashoffset: 1000;
  -webkit-animation: dash 0.9s 0.35s ease-in-out forwards;
  animation: dash 0.9s 0.35s ease-in-out forwards;
}
.animation-icon .path.check {
  stroke-dashoffset: -100;
  -webkit-animation: dash-check 0.9s 0.35s ease-in-out forwards;
  animation: dash-check 0.9s 0.35s ease-in-out forwards;stroke: <?= $brandColor; ?> !important;
}
.animation-icon p {
  text-align: center;
  margin: 20px 0 60px;
  font-size: 1.25em;
}
.animation-icon p.success {
  color: #73af55;
}
.animation-icon p.error {
  color: #d06079;
}

@-webkit-keyframes dash {
  0% {
    stroke-dashoffset: 1000;
  }
  100% {
    stroke-dashoffset: 0;
  }
}

@keyframes dash {
  0% {
    stroke-dashoffset: 1000;
  }
  100% {
    stroke-dashoffset: 0;
  }
}

@-webkit-keyframes dash-check {
  0% {
    stroke-dashoffset: -100;
  }
  100% {
    stroke-dashoffset: 900;
  }
}

@keyframes dash-check {
  0% {
    stroke-dashoffset: -100;
  }
  100% {
    stroke-dashoffset: 900;
  }
}

/* loader */


.spinner {
text-align: center;
 	
	    height: 32px;
    width: 32px;
    position: absolute;
    right: 7px;
    top: 6px;
    padding-top: 10px;
    text-align: center;
    background-color: #e0e7ee;
}

.spinner > div {
  width: 7px;
  height: 7px;
  background-color: #333;

  border-radius: 100%;
  display: inline-block;
  -webkit-animation: sk-bouncedelay 1.4s infinite ease-in-out both;
  animation: sk-bouncedelay 1.4s infinite ease-in-out both;
}

.spinner .bounce1 {
  -webkit-animation-delay: -0.32s;
  animation-delay: -0.32s;
	background-color: <?= $brandColor; ?>;
}

.spinner .bounce2 {
  -webkit-animation-delay: -0.16s;
  animation-delay: -0.16s;
	
	background-color: <?= $brandColor; ?>;
}

.spinner .bounce3 {
	
	background-color: <?= $brandColor; ?>;
}

@-webkit-keyframes sk-bouncedelay {
  0%, 80%, 100% { -webkit-transform: scale(0) }
  40% { -webkit-transform: scale(1.0) }
}

@keyframes sk-bouncedelay {
  0%, 80%, 100% { 
    -webkit-transform: scale(0);
    transform: scale(0);
  } 40% { 
    -webkit-transform: scale(1.0);
    transform: scale(1.0);
  }
}

.refresh-btn:hover{
	background-color: #3dd1b3;
}
.btn:hover {
    transition: all .3s;
}
	/* code */



.model-box-alert{

	
	border: 1px solid #e5e5e5;
	width: 100%;
	padding: 10px;
	text-align: center;
}


.model-box-icon{
	margin: 40px auto;
	text-align: center;
	
}
.model-box-alert h3{
	font-size: 30px;
	color: #464747;
	font-weight: 400;
	margin-bottom: 20px;
}
.model-box-alert p{
	font-size: 14px;
	color: #464747;
	font-weight: 400;
	margin-bottom: 30px;
}
.model-box-alert button{
	height: 38px;
    border: none !important;
    border-radius: 0 !important;
    text-transform: uppercase;
    font-size: 14px;
    font-weight: 400;
    color: #fff;
    margin-left: 10px;
    background-color: <?= $brandColor; ?>;
	margin: 0 auto 30px;
	min-width: 121px;
	
}

/* loader */

@-webkit-keyframes line-scale-pulse-out {
  0% {
    -webkit-transform: scaley(1);
            transform: scaley(1); }
  50% {
    -webkit-transform: scaley(0.4);
            transform: scaley(0.4); }
  100% {
    -webkit-transform: scaley(1);
            transform: scaley(1); } }

@keyframes line-scale-pulse-out {
  0% {
    -webkit-transform: scaley(1);
            transform: scaley(1); }
  50% {
    -webkit-transform: scaley(0.4);
            transform: scaley(0.4); }
  100% {
    -webkit-transform: scaley(1);
            transform: scaley(1); } }

.line-scale-pulse-out > div {
  background-color: <?= $brandColor; ?>;
  width: 4px;
  height: 35px;
  border-radius: 2px;
  margin: 2px;
  -webkit-animation-fill-mode: both;
          animation-fill-mode: both;
  display: inline-block;
  -webkit-animation: line-scale-pulse-out 0.9s -0.6s infinite cubic-bezier(0.85, 0.25, 0.37, 0.85);
          animation: line-scale-pulse-out 0.9s -0.6s infinite cubic-bezier(0.85, 0.25, 0.37, 0.85); }
  .line-scale-pulse-out > div:nth-child(2), .line-scale-pulse-out > div:nth-child(4) {
    -webkit-animation-delay: -0.4s !important;
            animation-delay: -0.4s !important; }
  .line-scale-pulse-out > div:nth-child(1), .line-scale-pulse-out > div:nth-child(5) {
    -webkit-animation-delay: -0.2s !important;
            animation-delay: -0.2s !important; }

@-webkit-keyframes line-scale-pulse-out-rapid {
  0% {
    -webkit-transform: scaley(1);
            transform: scaley(1); }
  80% {
    -webkit-transform: scaley(0.3);
            transform: scaley(0.3); }
  90% {
    -webkit-transform: scaley(1);
            transform: scaley(1); } }

@keyframes line-scale-pulse-out-rapid {
  0% {
    -webkit-transform: scaley(1);
            transform: scaley(1); }
  80% {
    -webkit-transform: scaley(0.3);
            transform: scaley(0.3); }
  90% {
    -webkit-transform: scaley(1);
            transform: scaley(1); } }

.line-scale-pulse-out-rapid > div {
  background-color: <?= $brandColor; ?>;
  width: 4px;
  height: 35px;
  border-radius: 2px;
  margin: 2px;
  -webkit-animation-fill-mode: both;
          animation-fill-mode: both;
  display: inline-block;
  vertical-align: middle;
  -webkit-animation: line-scale-pulse-out-rapid 0.9s -0.5s infinite cubic-bezier(0.11, 0.49, 0.38, 0.78);
          animation: line-scale-pulse-out-rapid 0.9s -0.5s infinite cubic-bezier(0.11, 0.49, 0.38, 0.78); }
  .line-scale-pulse-out-rapid > div:nth-child(2), .line-scale-pulse-out-rapid > div:nth-child(4) {
    -webkit-animation-delay: -0.25s !important;
            animation-delay: -0.25s !important; }
  .line-scale-pulse-out-rapid > div:nth-child(1), .line-scale-pulse-out-rapid > div:nth-child(5) {
    -webkit-animation-delay: 0s !important;
            animation-delay: 0s !important; }


#vicidial_form{
/*position: relative;*/
/*	overflow: hidden;*/
}
#SysteMDisablEBoX{
	right: 0 !important;
    bottom: 0 !important;
    top: 0 !important;
    background-color: rgba(34,46,58, 0.9);
    height: 100vh;
}
#SysteMDisablEBoX table {
    width: 525px;
    height: 180px;
    margin: 12% auto 0 auto;
    background-color: #fff;
    position: relative;
    overflow: hidden;
    padding: 30px 20px 0 160px;
    color: #6e6e6e;
    display: block;
}
#SysteMDisablEBoX table::before {
    position: absolute;
    width: 505px;
    height: 160px;
    content: "";
    left: 10px;
    top: 10px;
    border: 1px solid #e5e5e5;
}
#SysteMDisablEBoX table::after {
    width: 116px;
    height: 116px;
    background-color: <?= $brandColor; ?>;
    background: url(../images/tim_sy.png) center 24px no-repeat <?= $brandColorHover; ?>;
    position: absolute;
    left: 30px;
    top: 32px;
    content: "";border-radius: 3px;
}
#SysteMDisablEBoX .sh_text p{
	padding-top: 20px;
}
#SysteMDisablEBoX .sh_text {
    font-size: 16px;
    color: rgba(0,0,0, 0.8);
    text-align: left;
    font-weight: 400;
    float: left;
}
#SysteMDisablEBoX a {
    display: inline-block;
    height: 38px;
    border: none;
    border-radius: 0;
    text-transform: uppercase;
    font-size: 12px;
    font-weight: 400;
    color: #fff;
    margin-right: 10px;
    width: 105px;
    background-color: #303030;
    /* margin-top: 10px; */
    margin-bottom: 10px;
    text-decoration: none;
    box-sizing: border-box;
    align-items: center;
    justify-content: center;
    line-height: 39px;
    cursor: pointer;
    position: relative;
    z-index: 1;
    text-align: center;
    margin-top: 10px;
    float: right;
}
#SysteMDisablEBoX br {
    display: none;
}
#SysteMDisablEBoX a:hover {
    background-color: <?= $brandColorHover; ?>;
}
#LogouTProcess .loading_text{
	text-transform: lowercase;	
}

#LogouTProcess .loading_text p{
	text-transform: uppercase !important;
	float: left;
	    font-size: 16px;
    text-align: left;
    color: rgba(0,0,0, 0.8);
    font-weight: 400;
    font-family: sans-serif;
}


#LoadingBox .loading_text{
	position: absolute;
	top: 330px;
}
#LoadingBox table{
	background-color: #fefefe !important;
}
/*
.Agent-chatting{background-color: #ff0000;}
.Agent-email{background-color: #ffa500;}
.Agent-waiting{background-color: #add8e6;}
.Agent-waiting-call-one-minute{background-color: #0000ff;}
.Agent-waiting-call-five-minutes{background-color: #191970;}
.Agent-on-call-ten-second{background-color: #d8bfd8;}
.Agent-on-call-one-minute{background-color: #ee82ee;}
.Agent-on-call-five-minutes{background-color: #800080;}
.Agent-Paused-ten-second{background-color: #f0e68c;}
.Agent-Paused-one-minute{background-color: #ffff00;}
.Agent-Paused-five-minutes{background-color: #808000;}
.Agent-3-way{background-color: #006600;}
.Agent-dead-call{background-color: #000000;}
*/
#LoadingBox{
	right: 0px !important;
    bottom: 0px !important;
    top: 0px !important;
   background-color: rgba(255,255,255, 1);
/*    height: 100vh;*/
	overflow: hidden;
	
}
#LoadingBox table{
	margin: 0 auto;
	width: 100% !important;
}
.wrapper-tabs{
	padding:0 15px 15px 15px;
}
.wrapper-tabs table{
	width: 100% !important;
}
.working-area-wrp .noscroll_script{
	width: 100% !important;
	background-color: #fff;
	font-size: 13px;
 font-family: 'Roboto';
/*	max-height: calc(100vh - 209px);*/
   
}
.dispoSelection-bottom a:hover{
	color: #fff !important;
}
/*BUTTONS*/

.btn.full{width:100%;}
.btn.default {background-color: #29abfd!important; color: #FFF;}
.btn.default {background-color: #29abfd!important; color: #FFF;}
	.btn.default:hover {color: #29abfd; background-color: #FFF!important; }
.btn.blue {background-color: #29abfd!important; color: #FFF;}
	.btn.blue:hover, .btn.blue.active {color: #29abfd; background-color: #FFF!important;}
.btn.orange {background-color: #ed6952!important; color: #FFF;}
	.btn.orange:hover {color: #ed6952; background-color: #FFF!important; }
.btn.red {background-color: #ed5252!important; color: #FFF;}
	.btn.red:hover {color: #ed5252; background-color: #FFF!important; }
.btn.green {background-color: #55dc55!important; color: #FFF;}
	.btn.green:hover {color: #55dc55; background-color: #FFF!important; }
.btn.yellow {background-color: #ee9948!important; color: #FFF;}
	.btn.yellow:hover {color: #ee9948; background-color: #FFF!important;}
.btn.purple {background-color: #7e047d!important; color: #FFF;}
	.btn.purple:hover {color: #7e047d; background-color: #FFF!important;}
.btn.grey {background-color: #666!important; color: #FFF;}
	.btn.grey:hover {color: #666; background-color: #FFF; }
.btn.btn-sm{font-size:18px; padding:3px 12px;}


/* TEXT COLORS ***/

.text-default {color: #787878!important;}
.text-white {color: #fff!important;}
.text-blue {color: #29abfd!important;}
.text-orange {color: #ed6952!important;}
.text-red {color: #ed5252!important;}
.text-green {color: #55dc55!important;}
.text-yellow {color: #ee9948!important;}
.text-purple{color: #6912c2!important;}
.text-grey {color: #666!important;}
.text-black {color: #000!important;}

/*controls button colors */

.hold_on{color:#f3a34e !important; background-color: #222e3a !important;cursor: pointer !important;border-left: 2px solid #222e3a;}
.hold_off{
/*	background-color:#455c73;*/
	cursor: default !important;color: rgba(255,255,255, 0.4) !important;}
.transfer_on{color:#b300b2 !important;background-color: #222e3a !important;cursor: pointer !important;border-left: 2px solid #222e3a;}
.transfer_off{
/*	background-color:#455c73;*/
	cursor: default !important;color: rgba(255,255,255, 0.4) !important;}
.pause_on{color:#ff7b33 !important;background-color: #222e3a !important;cursor: pointer !important;border-left: 2px solid #222e3a;}
.pause_off{
/*	background:#455c73;*/
	cursor: default !important;color: rgba(255,255,255, 0.4) !important;}
.hangup_on{color:#fff !important;background-color: #222e3a !important;cursor: pointer !important;border-left: 2px solid #222e3a;}
#DtmfControl .hangup_on{color:#F33 !important;background-color: #222e3a !important;cursor: pointer !important;border-left: 2px solid #222e3a;}
#DtmfControl .hangup_off{
/*	background-color:#455c73;*/
	cursor: default !important;color: rgba(255,255,255, 0.4) !important;}
.hangup_off{
/*	background-color:#455c73;*/
	cursor: default !important;color: rgba(255,255,255, 0.4) !important;}
.dial_next_on{color:#0487bf !important;background-color: #222e3a !important;cursor: pointer !important; border-left: 2px solid #222e3a;}
.dial_next_off{
/*	background-color:#455c73;*/
	cursor: default !important;color: rgba(255,255,255, 0.4) !important;}
.recording_on{color:#47a3da !important;background-color: #222e3a !important;cursor: pointer !important; border-left: 2px solid #222e3a;}
.recording_off{
/*	background:#455c73;*/
	cursor: default !important;color: rgba(255,255,255, 0.4) !important;}
.manual_dial_on{color:#47a3da !important;background-color: #222e3a !important;cursor: pointer !important;border-left: 2px solid #222e3a;}
.manual_dial_off{
/*	background:#455c73;*/
	cursor: default !important;color: rgba(255,255,255, 0.4) !important;}
.start_call_on{color:#55dc55 !important;background-color: #222e3a !important;cursor: pointer !important; border-left: 2px solid #222e3a;}
.start_call_off{
/*	background-color:#455c73;*/
	cursor: default !important;color: rgba(255,255,255, 0.4) !important;}




/*controls button hover colors */

.hold_on:hover{color:#f3a34e;}
.transfer_on:hover {color:#b300b2;}
.pause_on:hover{color:#ff7b33;}
.hangup_on:hover {color:#F33;}
.dial_next_on:hover{color:#0487bf;}
.recording_on:hover{color:#47a3da;}
.manual_dial_on:hover {color:#47a3da;}
.start_call_on:hover {color:#55dc55;}


.hold_on:hover{border-left: 2px solid #222e3a;background-color: #222e3a;cursor: pointer !important;}
.transfer_on:hover{border-left: 2px solid #222e3a;background-color: #222e3a;cursor: pointer !important;}
.pause_on:hover{border-left: 2px solid #222e3a;background-color: #222e3a;cursor: pointer !important;}
.hangup_on:hover{border-left: 2px solid #222e3a;background-color: #222e3a;cursor: pointer !important;}
.dial_next_on:hover{border-left: 2px solid #222e3a;background-color: #222e3a;cursor: pointer !important;}
.recording_on:hover{border-left: 2px solid #222e3a;background-color: #222e3a;cursor: pointer !important;}
.manual_dial_on:hover{border-left: 2px solid #222e3a;background-color: #222e3a;cursor: pointer !important;}
.start_call_on:hover{border-left: 2px solid #222e3a;background-color: #222e3a;cursor: pointer !important;}
/*

.hold_on:hover{background-color:#f08f28}
.transfer_on:hover{background-color:#f821f6;}
.pause_on:hover{background:#ff6a1a;}
.hangup_on:hover{background-color:#ff1a1a;}
.dial_next_on:hover{background-color:#1eb8fa;}
.recording_on:hover{background:#409fd9;}
.manual_dial_on:hover{background:#409fd9;}
.start_call_on:hover{background-color:#41d841;}
*/

/*** Status Colors ***/

.bg_wait{background:#99ddf9; color:#FFF !important;}
.bg_wait_1m{background:#0387bd; color:#FFF !important;}
.bg_wait_5m{background:#095998; color:#FFF !important;}
.bg_oncall{background:#94f494; color:#FFF !important;}
.bg_oncall_1m{background:#6C6; color:#FFF !important;}
.bg_oncall_5m{background:#079e06; color:#FFF !important;}
.bg_pause{background:#fbc199; color:#FFF !important;}
.bg_pause_1m{background:#f3a34f; color:#FFF !important;}
.bg_pause_5m{background:#f76e00; color:#FFF !important;}
.bg_dispo{background:#ff2424; color:#FFF !important;}
.bg_dispo_1m{background:#ce2424; color:#FFF !important;}
.bg_dispo_5m{background:#900; color:#FFF !important;}
.bg_queuee{background:#fc0; color:#FFF !important;}
.bg_way3{background:#7d047d; color:#FFF !important;}
.bg_dead{background:#bdbcbc; color:#FFF !important;}

.btn_textarea {
    position: absolute;
    background-color: <?= $brandColor; ?>;
    height: 50px;
    right: 0;
    top: 0;
    padding: 0 15px;
    display: flex;
    align-items: center;
    justify-content: center;
    float: right;
    color: #fff;
	text-transform: uppercase;
	font-size: 13px;
}
.btn_input {
    position: absolute;
    background-color: <?= $brandColor; ?>;
    height: 35px;
    right: 0;
    top: 0;
    padding: 0 15px;
    display: flex;
    align-items: center;
    justify-content: center;
    float: right;
    color: #fff;
	text-transform: uppercase;
	font-size: 13px;
}

.btn_textarea:hover{
	background-color: #232f3b;
	color: #fff;
}.btn_input:hover{
	background-color: #232f3b;
	color: #fff;
}
#ParkCounterSpan{
	    position: absolute;
    text-align: center;
/*    width: 42px;*/
	width: 100%;
    overflow: hidden;
    font-size: 7px;
    color: #fff;
    /* padding-top: 31px; */
    bottom: 1px;
    padding: 0;
    margin: 0;
    line-height: normal;
}

/*

.start_call_on, .start_call_off {
	margin-left: 0 !important;
	margin-right: 0 !important;
}
.dial_next_on, .dial_next_off{
	margin-left: 5px !important;
}
.hangup_off, .hangup_on{
	margin-left: 5px !important;
}
*/


.ivr_park_on i{color:#4ecdc4; font-size: 20px !important;}
/*.ivr_park_off i{background-color:#455c73;cursor: default !important;color: rgba(255,255,255, 0.4) !important;font-size: 21px !important;}*/

.quick_transfer_on i{color:#f05326; font-size: 20px !important;}
/*.quick_transfer_off i{background-color:#455c73;cursor: default !important;color: rgba(255,255,255, 0.4) !important;font-size: 21px !important;}*/

.re_queue_on i{color:#bc63f4; font-size: 20px !important;}
/*.re_queue_off i{background-color:#455c73;cursor: default !important;color: rgba(255,255,255, 0.4) !important;font-size: 21px !important;}*/

.custom_transfer_on i{color:#8fc13e; font-size: 20px !important;}
/*.custom_transfer_off i{background-color:#455c73;cursor: default !important;color: rgba(255,255,255, 0.4) !important;font-size: 21px !important;}*/




.ivr_park_on:hover{background-color: #161f27;cursor: pointer !important;border-left: 2px solid #4ecdc4;}
.quick_transfer_on:hover{background-color: #161f27;cursor: pointer !important;border-left: 2px solid #f05326;}
.re_queue_on:hover{background-color: #161f27;cursor: pointer !important;border-left: 2px solid #ca76ff;}
.custom_transfer_on:hover{background-color: #161f27;cursor: pointer !important;border-left: 2px solid #bef369;}

.ivr_park_on{background-color: #161f27;cursor: pointer !important;border-left: 2px solid #4ecdc4;cursor: pointer !important;}
.quick_transfer_on{background-color: #161f27;cursor: pointer !important;border-left: 2px solid #f05326;cursor: pointer !important;}
.re_queue_on{background-color: #161f27;cursor: pointer !important;border-left: 2px solid #ca76ff;cursor: pointer !important;}
.custom_transfer_on{background-color: #161f27;cursor: pointer !important;border-left: 2px solid #bef369;cursor: pointer !important;}

#DtmfControl .hangup_on:hover{color:#F33 !important;background-color: #222e3a !important;cursor: pointer !important;border-left: 2px solid #222e3a;}
#DtmfControl .hangup_on:hover i{color:#F33 !important;}
#ivrParkControl a{font-size: 21px;}
#QuickXfer a{font-size: 20px;}
#ReQueueCall a{font-size: 20px;}
#CustomXfer a{font-size: 20px;}
#DiaLControl a{
	    font-size: 16px;
}
#HangupControl a{
	    font-size: 15px;
}
#XferControl a{
	font-size: 20px;
}
#ParkControl a{
	    font-size: 20px;
}
#ParkCounterSpan a{
	    font-size: 20px;
}
/* new */

.webform-buttons li{
	
   float: none;
    display: block;
    width: 100%;
    position: relative;
    text-align: center;
    border-bottom: 1px solid rgba(255,255,255,0.05);
}
.webform-buttons ul{
	text-align: center;
}
.webform-buttons{
/*	    margin: -10px;*/
	display: block;
	width: 100%;
/*	overflow: hidden;*/
}
.webform-buttons li a{
	    width: 100%;
    color: #fff;
    display: block;
    /* margin-bottom: 7px; */
    text-align: center;
    color: rgba(255,255,255, 0.4);
    min-height: 47px;
    border-left: 2px solid #222e3a;
    padding: 2px 0;
}
.webform-buttons li a p{
	font-weight: 400;
    min-height: 51px;
    background-color: #161f27;
    position: absolute;
    right: -119px;
    width: 119px;
    top: 0px;
    /* color: <?= $brandColor; ?>; */
    padding-top: 14px;
    padding-left: 11px;
    text-align: left;
    font-size: 14px !important;
    border-radius: 0px 5px 5px 0px;
    display: none;
}

.webform-buttons li a:hover p{
	display: block !important;
}
.webform-btn.disabled p{
    color: rgba(255,255,255, 0.4) !important;
}
.webform-buttons li a i{
	display: flex;
    align-items: center;
    justify-content: center;
    width: 100%;
    min-height: 47px;
    margin: 0 auto;
    font-size: 21px;
}
.recording-btns li{
	float: none;
    display: block;
    width: 100%;
    position: relative;
    text-align: center;
    border-bottom: 1px solid rgba(255,255,255,0.05);
}
.recording-btns ul{
	
/*
    display: flex;
    flex-flow: row wrap;
    align-items: flex-start;
*/
	margin:0;
}
.recording-btns{
/*	    margin: -10px;*/
/*	margin: -10px; */
    display: block;
    width: 100%; 
    overflow: hidden;
/*    background-color: #1c2630;*/
/*	margin-top: 15px;*/
/*    position: fixed;*/
/*    width: 230px;*/
/*    bottom: 0;*/
/*    left: 0;*/
}
.recording-btns li a{
	width: 100%;
    color: #fff;
    display: block;
    /* margin-bottom: 7px; */
    text-align: center;
    color: rgba(255,255,255, 0.4);
    min-height: 47px;
    border-left: 2px solid #222e3a;
    padding: 2px 0;
	
}
.recording-btns li a p{
	font-weight: 400;
    min-height: 51px;
    background-color: #161f27;
    position: absolute;
    right: -119px;
    width: 119px;
    top: 0px;
    /* color: <?= $brandColor; ?>; */
    padding-top: 14px;
    padding-left: 11px;
    text-align: left;
    font-size: 14px !important;
    border-radius: 0px 5px 5px 0px;
    display: none;
}
.recording-btns li a:hover p{
	display: block;
}
.recording-btns li a i{
display: flex;
    align-items: center;
    justify-content: center;
    /* padding-top: 9px; */
    width: 100%;
    margin: 0 auto;
    /* border-radius: 3px; */
    min-height: 47px;
	
}
.recording-btns li:nth-child(2){
/*	border-left: 2px solid #182028;*/
/*	border-left: 3px solid #222e3a;*/
}
.recording-btns li:first-child{
/*border-right: 2px solid #273543;*/
/*	border-left: 3px solid #222e3a;*/
}

.recording_start_active{background-color: #222e3a;color: <?= $brandColorHover; ?> !important;cursor: pointer;cursor: pointer;}
.recording_start_active i{background-color: #222e3a;color: <?= $brandColorHover; ?> !important;}
.recording_start_active:hover{background-color: #222e3a;color:<?= $brandColorHover; ?>  !important;color: <?= $brandColorHover; ?>;cursor: pointer;}
.recording_start_on{/*	background-color: #00aeff;*/ 	background-color: #222e3a;border-left: 2px solid #222e3a;color: <?= $brandColorHover; ?> !important;cursor: pointer;}
.recording_start_on:hover i{
	color: <?= $brandColorHover; ?> !important;
}
.recording_start_on:hover{background-color: #222e3a;color: <?= $brandColorHover; ?> !important;border-left: 2px solid #222e3a;cursor: pointer;}
.recording_start_off{
/*	background-color: #222e3a;*/
	color: #fff !important;border-left: 2px solid #222e3a;cursor: pointer;}
.recording_start_off:hover{	
/*	background-color: #222e3a;*/
	color: #fff !important;border-left: 2px solid #222e3a;cursor: pointer;}


.recording_mute_active i{
	color: #fff !important;
}
.recording_mute_active{	background-color: #222e3a;border-left: 2px solid #222e3a;color: <?= $brandColorHover; ?> !important;cursor: pointer;}
.recording_mute_active:hover{	background-color: #222e3a;border-left: 2px solid #222e3a;color: <?= $brandColorHover; ?> !important;cursor: pointer;}
.recording_mute_on i{color: <?= $brandColorHover; ?> !important;}
.recording_mute_on{	background-color: #222e3a!important;border-left: 2px solid #222e3a;color: <?= $brandColorHover; ?> !important; cursor: pointer;}
.recording_mute_on:hover{	background-color: #222e3a!important;color: <?= $brandColorHover; ?> !important;border-left: 2px solid #222e3a;cursor: pointer;}
.recording_mute_off{	
/*	background-color: #222e3a;*/
	color: rgba(255,255,255, 0.4) !important;cursor: pointer;}
.recording_mute_off:hover{	
/*	background-color: #222e3a;*/
	color: #fff;cursor: pointer;}

.recording_start_disabled{
/*	background-color:#222e3a;*/
	cursor: default !important;color: rgba(255,255,255, 0.4) !important; }
.recording_mute_disabled
/*{background-color:#222e3a;*/
	cursor: default !important;color: rgba(255,255,255, 0.4) !important; }
/* end code */

@keyframes blinks{
0%{opacity: 0;}
50%{opacity: .5;}
100%{opacity: 1;}
}

.webform-buttons li:hover a{
		color: <?= $brandColor; ?>;
	
/*	border: 1px solid <?= $brandColor; ?>;*/
}
.webform-buttons li:hover{
	color: <?= $brandColor; ?>;
/*	background-color: #222e3a;*/
}

.webform-buttons .disabled{
/*	border: 1px solid #455c73;*/
/*	border-radius: 3px;*/
}
.webform-buttons .disabled:hover{
/*	border: 1px solid #455c73;*/
}

.wrapper-tabs iframe{
/*
	width: 100% !important;
	max-height: calc(100vh - 145px) !important;
	height: calc(100vh - 145px) !important;
    overflow-y: auto;
*/
}


/* models */

#TimerSpan {
    right: 0 !important;
    bottom: 0 !important;
    top: 0 !important;
    background-color: rgba(34,46,58, 0.9);
    height: 100vh;
	left: 0px !important;
}
#TimerSpan table {
    width: 525px;
    height: 180px;
    margin: 12% auto 0 auto;
    background-color: #fff;
    position: relative;
    overflow: hidden;
    padding: 30px 30px 0 160px;
    color: #6e6e6e;
    display: block;
}
#TimerSpan table::before {
    position: absolute;
    width: 505px;
    height: 160px;
    content: "";
    left: 10px;
    top: 10px;
    border: 1px solid #e5e5e5;
}
#TimerSpan tbody {
    display: block;
    width: 100%;
}
#TimerSpan table::after {
    width: 116px;
    height: 116px;
    background-color: <?= $brandColor; ?>;
    background: url(../images/call-alert.png) center 26px no-repeat <?= $brandColor; ?>;
    position: absolute;
    left: 30px;
    top: 32px;
    content: "";
	border-radius: 3px;
}
#TimerSpan tbody tr {
    display: block;
    width: 100%;
}
#TimerSpan tbody tr td {
    display: block;
    width: 100%;
}

#TimerSpan br {
    display: none;
}
#TimerContentSpan b{
	    font-size: 16px;
    color: rgba(0,0,0, 0.8);
    text-align: left;
    font-weight: 400;
    float: left;
    width: 100%;
}
#TimerContentSpan br{
	display: block;
}
#TimerSpan .sh_text a:hover {
    background-color: <?= $brandColorHover; ?>;
}
#TimerSpan .sh_text a {
    display: inline-block;
    height: 38px;
    border: none;
    border-radius: 0;
    text-transform: uppercase;
    font-size: 12px;
    font-weight: 400;
    color: #fff;
    /* margin-right: 10px; */
    /* width: 105px; */
    background-color: #303030;
    /* margin-top: 10px; */
    margin-bottom: 10px;
    text-decoration: none;
    box-sizing: border-box;
    align-items: center;
    justify-content: center;
    line-height: 39px;
    cursor: pointer;
    position: relative;
    z-index: 1;
    text-align: center;
    padding-left: 10px;
    padding-right: 10px;
    margin-top: 10px;
    float: right;
	border-radius: 3px;
}
#TimerContentSpan br:first-child{
	display: none;
}

/* end models */

/* models */

#CustomerGoneBox {
    right: 0 !important;
    bottom: 0 !important;
    top: 0 !important;
    background-color: rgba(34,46,58, 0.9);
    height: 100vh;
}
#CustomerGoneBox table {
    width: 525px;
    height: 180px;
    margin: 12% auto 0 auto;
    background-color: #fff;
    position: relative;
    overflow: hidden;
    padding: 30px 30px 0 160px;
    color: #6e6e6e;
    display: block;
}
#CustomerGoneBox table::before {
    position: absolute;
    width: 505px;
    height: 160px;
    content: "";
    left: 10px;
    top: 10px;
    border: 1px solid #e5e5e5;
}
#CustomerGoneBox tbody {
    display: block;
    width: 100%;
}
#CustomerGoneBox table::after {
    width: 116px;
    height: 116px;
    background-color: <?= $brandColor; ?>;
    background: url(../images/hangup.png) center 30px no-repeat <?= $brandColor; ?>;
    position: absolute;
    left: 30px;
    top: 32px;border-radius: 3px;
    content: "";
}
#CustomerGoneBox tbody tr {
    display: block;
    width: 100%;
}
#CustomerGoneBox tbody tr td {
    display: block;
    width: 100%;
}

#CustomerGoneBox br {
    display: none;
}
#CustomerGoneBox .sd_text{
	    font-size: 16px;
    color: rgba(0,0,0, 0.8);
    text-align: left;
    font-weight: 400;
    float: left;
    width: 100%;
}
#CustomerGoneBox a:hover {
    background-color: <?= $brandColorHover; ?>;
}
#CustomerGoneBox a {
    display: inline-block;
    height: 38px;
    border: none;
    border-radius: 0;
    text-transform: uppercase;
    font-size: 12px;
    font-weight: 400;
    color: #fff;
    /* margin-right: 10px; */
    /* width: 105px; */
    background-color: #303030;
    /* margin-top: 10px; */
    margin-bottom: 10px;
    text-decoration: none;
    box-sizing: border-box;
    align-items: center;
    justify-content: center;
    line-height: 39px;
    cursor: pointer;
    position: relative;
    z-index: 1;
    text-align: center;
    padding-left: 10px;
    padding-right: 10px;
    margin-top: 10px;
    float: left;
	margin-left: 60px;
}

.dtmf button:hover{
	background-color: <?= $brandColorHover; ?>;
}
#CustomerGoneChanneL{
	display: block;
	clear: both;
	 font-size: 16px;
    color: rgba(0,0,0, 0.8);
    text-align: left;
    font-weight: 400;
    float: left;
    width: 100%;
}
#CustomerGoneBox a:last-child{
	margin-left: 12px !important;
	background-color: <?= $brandColor; ?>;
}

/* end models */









@media only screen and (max-width: 1199px) {
}

@media only screen and (max-width: 992px) {
}

@media only screen and (max-width: 767px) {
}
@media (max-width: 480px) {
	.login-wrp{
		width: 100% !important;
		background-color: rgba(255,255,255, 0.95);
	}
		
}

.disabled{
/*	    pointer-events: none !important;*/
/*	opacity: .40 !important;*/
/*	background-color: #5a6e83 !important;*/
/*	background: rgba(255,255,255, 0.5);*/
	/* other color*/
/*
	background-color: #e0e0e0 !important;
    color: #b8b8b8 !important;
*/
	
	cursor: default !important;
/*	background-color:#222e3a !important;*/
	color: rgba(255,255,255, 0.4) !important;
}
.webform-btn.disabled:hover{

	background-color:#222e3a !important;
}
.webform-btn.disabled{border-left: 2px solid #222e3a; color: rgba(255,255,255, 0.4) !important;}
.webform-btn.disabled i{color: rgba(255,255,255, 0.4) !important;}
.disabled:hover{
	cursor: default !important;
/*	background-color:#222e3a !important;*/
	color: rgba(255,255,255, 0.4) !important;
}
#MainStatuSSpan br{
	display: none;
}
#MainStatuSSpan b{

    margin-right: 10px;

    padding: 2px 6px 2px 0;
    background-color: rgba(0,0,0,0.10);
    border-radius: 3px;
    font-size:13px;
}
#MainStatuSSpan{


    font-size: 11px;
    color: #fff;
 display: block;
 width: 100%; 

	font-weight: 400;        overflow: hidden; 

	
}
#MainStatuSSpan a .preview_text {
     font-size: 11px;
    padding: 1px 10px;
    border-radius: 2px !important;
    background-color: transparent !important;
    display: block;
	font-weight: 400;
    font-family: 'Roboto';
}


.lead-perview-state{
	clear: both;
	width: 100%;
	display: block;overflow: hidden;
}
.lead-perview-state p{

    margin-bottom: 0;
    }
.lead-perview-state a:nth-child(odd){
float: right;
}
.lead-perview-state a{
	float: left;
/*	overflow: hidden;*/
	font-weight: 400;
    font-family: 'Roboto';
    border-radius: 3px !important;
    
    font-size: 11px;	
	background-color: <?= $brandColor; ?>;
	    padding: 0px;
    border-radius: 2px !important;
	display: inline-block;
	margin: 0;
  box-shadow: inset 0px 0px 18px 0px rgba(0, 0, 0, 0.10);
	    line-height: normal;
   text-align:center;
   
padding: 0 5px;
    margin-bottom: 0;
    
	width: 49%;
}

.lead-perview-state a:hover{
/*	opacity: 0.80;*/
/*	box-shadow: inset 0px 0px 18px 0px rgba(0, 0, 0, 0.20);*/
}

.lead-perview-state a:nth-child(2){
	background-color: #8fc13e;
}
.lead-perview-state a:nth-child(3){
	background-color: <?= $brandColor; ?>;
}
.lead-perview-state a:nth-child(4){
	background-color: #f99e35;
}
.lead-perview-state a:nth-child(5) {
	background-color: #bc63f4;
}

.lead-perview-state a:hover:nth-child(2){
	background-color: #78af1f !important;
}
.lead-perview-state a:hover:nth-child(3){
	background-color: <?= $brandColorHover; ?> !important;
}

.lead-perview-state a:hover:nth-child(4){
	background-color: #dd7e11;
}
.lead-perview-state a:hover:nth-child(5) {
	background-color: #a347de;
}

#PauseCodeSelectBox table{
	    height: auto;
}
#PauseCodeSelectContent table{
	height: auto;
}
#PauseCodeSelectBox {
	    background-color: rgba(34,46,58, 0.9);
	top: 0px !important;
	bottom: 0px !important;
	left: 0px !important;
	right: 0px !important;
}
#PauseCodeSelectBox br{
	display: none;
}
#PauseCodeSelectContent br{
	display: none;
}
.pauseback_btn a {
	    display: inline-block;
    height: 38px;
    border: none;
    border-radius: 0;
    text-transform: uppercase;
    font-size: 12px;
    font-weight: 400;
    color: #fff;
    margin-right: 10px;
    width: 140px;
    background-color: #303030;
    /* margin-top: 10px; */
    margin-bottom: 10px;
    text-decoration: none;
    box-sizing: border-box;
    align-items: center;
    justify-content: center;
    line-height: 39px;
    cursor: pointer;
    position: relative;
    z-index: 1;
    text-align: center;
	float: right;
}
.pauseback_btn{
	background-color: #fff;
    width: 100%;
    overflow: hidden;
    display: block;
	
}
#PauseCodeSelectContent table tr:nth-child(2){
	
    display: block;
	max-height: 400px;
	overflow-y: auto;
}

#SearcHForMDisplaYBox table{
	margin: 0 auto;
	margin-top: 45px;
	background-color: #fff;
}
#SearcHForMDisplaYBox {
	    background-color: rgba(34,46,58, 0.9);
	top: 0px !important;
	bottom: 0px !important;
	left: 0px !important;
	right: 0px !important;
}

#SearcHForMDisplaYBox br{
	display: none;
}
.search-lead-form input {
	width: 100%;
    padding: 4px 12px 4px 12px;
    border: 1px solid #fff;
    border-radius: inherit;
    font-size: 13px;
    height: 35px;
    color: #6e6e6e;    
/*	margin-bottom: 12px;*/
/*    margin-left: 12px;*/
	background-color: #f0f0f0;
}
.search-lead-form .sh_text{
	font-size: 14px;
    font-weight: 500;
    opacity: 0.6;
    width: 131px;
    display: block;
    text-align: right;
    padding-right: 15px;
    height: 35px;
    padding-top: 7px;
}
.heading-lead-search{
/*	    background-color: <?= $brandColor; ?> !important;*/
	background-color: rgba(34,46,58, 1) !important;
    height: 35px;
	    padding: 0 0 0 16px;
	display: block;
    width: 100%;
}
.heading-lead-search a{
	float: right;
/*    background-color: rgba(34,46,58, 1);*/
/*    background-color: rgba(34,46,58, 0.2);*/
	
background-color: #3e4a56;	
	color: rgba(255,255,255, 0.8);
/*    color: #fff;*/
    display: flex;
    align-items: center;
    justify-content: center;
    height: 35px;
    width: 35px;
    font-size: 11px;
}
.heading-lead-search a:hover{
		color: rgba(255,255,255, 1);
}
.heading-lead-search p{
	float: left;
	text-align: left;
	color: #fff;
	font-size: 13px;
    text-transform: uppercase;
    font-weight: 300;height: 35px;
    display: flex;
    align-items: center;
}
.lead-search-txt{
	padding-top: 20px;
	display: block;
}
.lead-search-txt p{
	text-align: left;
	padding-left: 15px;
}
.microph-wrp-search .switch{
	    float: left !important;
/*    margin-left: 12px !important;*/
    margin-right: 12px !important;
}
.microph-wrp-search .slider:before{
	border: 1px solid #374b5e;
}
.microph-wrp-search h6{
	float: left;
}
.search-lead-form table{
	width: 100% !important;    margin-top: 15px !important;
}

.search-lead-form table tr{
	float: left;
	width: 49%;border: 1px solid #ededed;    margin-bottom: 10px;
}
.search-lead-form table td{
	padding: 6px 0
}
.search-lead-form{
	    overflow: hidden;
    display: block;
    padding:0 15px;
}
.btn-leadsearch a{
	display: inline-block;
    height: 38px;
    border: none;
    border-radius: 0;
    text-transform: uppercase;
    font-size: 12px;
    font-weight: 400;
    color: #fff;
    margin-left: 10px;
    width: 140px;
    background-color: <?= $brandColor; ?>;
    /* margin-top: 10px; */
    margin-bottom: 10px;
    text-decoration: none;
    box-sizing: border-box;
    align-items: center;
    justify-content: center;
    line-height: 39px;
    cursor: pointer;
    position: relative;
    z-index: 1;
	
	float: right;
}
.btn-leadsearch {
	    display: block;
    margin-top: 35px;
}
.btn-leadsearch a:last-child{
	
    background-color: #303030;
}
.search-lead-form table tr:nth-child(even){
	float: right;
}
.notic-lead-search{
	padding:0 15px;
	display: block;
	overflow: hidden;
	
}
.notic-lead-search p{
	padding: 10px;
	
/*	background-color: #F0F0F0;*/
	background-color: #eafbf7;
	color: #146b59;
	font-size: 13px;
	display: block;
	text-align: left;
	font-weight: 500;
}

.sh_text-search{
	width: 156px !important; 
}
.search-lead-form table tr:last-child{
	border: none;
}
.search-lead-form table tr td:nth-child(2){
	width: 221px;
}
.search-lead-form table tr:nth-child(9){
	border: none;
}
#SearcHResultSDisplaYBox{
	    background-color: rgba(34,46,58, 0.9);
    top: 0px !important;
    bottom: 0px !important;
    left: 0px !important;
    right: 0px !important;
}

#SearcHResultSDisplaYBox br{
	display: none !important;
}


#SearcHResultSSpan{
/*	margin-top: 10px;*/
/*    padding: 0 10px;*/
    width: 100% !important;
	height: auto !important;
	max-height: 400px !important;
	overflow-y: auto;
	overflow-x: hidden;
}

.heading-lead-search-result {
	background-color: rgba(34,46,58, 1) !important;
}

.heading-lead-search-result a{
background-color: #3e4a56;	
}

#CloserSelectContent h6{
	    padding:15px 10px;
    display: block;
    overflow: hidden;
}

#CloserSelectContent h6 span{
	padding: 10px;
    /* background-color: #F0F0F0; */
    background-color: #f0f0f0;
    color: rgba(0,0,0, 0.7);
    font-size: 15px;
    display: block;
    text-align: left;
    font-weight: 500;
}
#LeaDInfOBox{
	    background-color: rgba(34,46,58, 0.9);
    top: 0px !important;
    bottom: 0px !important;
    left: 0px !important;
    right: 0px !important;
}
#LeaDInfOBox table{
	background-color: #fff;
    margin: 0 auto;
    margin-top: 45px;
}
#CalLLoGDisplaYBox{
	    background-color: rgba(34,46,58, 0.9);
    top: 0px !important;
    bottom: 0px !important;
    left: 0px !important;
    right: 0px !important;
}
#CalLLoGDisplaYBox table{
	    background-color: #fff;
    margin: 0 auto;
/*
    margin-top: 45px;
    width: 90%;
*/
}


#CallLogSpan{
/*	margin-top: 10px;*/
/*    padding: 0 10px;*/
    width: 100% !important;
	height: auto !important;
	max-height: 400px !important;
	overflow-y: auto;
	overflow-x: hidden;
}

#CallLogSpan br{
	display: none !important;
}


/* 24.3.2020 */
.webform-btn a{
	display: block;
	width: 100%;
}
.call-lg-header h2{
	color: #fff;
	font-size: 14px;
	padding: 8px 0 6px 0;
	float: left;
}
.call-lg-header a{
	padding: 7px 10px 7px 10px;
	background-color: rgba(0,0,0, 0.1);
	color: rgba(255,255,255, 0.6);
	font-size: 10px;
	float: right;
}
.call-lg-header{
	background-color: <?= $brandColor; ?>;
	padding: 0 0 0 18px;
	overflow: hidden;
}
.call-log-wrp a i{
	height: 30px;
	font-size: 12px;
	display: flex;
	align-items: center;
	justify-content: center;
	margin-right: 4px;
}
.call-log-wrp a{
	height: 30px;
	background-color: <?= $brandColor; ?>;
	color: rgba(255,255,255, 0.8);
	border: 1px solid <?= $brandColor; ?>;
	float: left;
	text-align: center;
	margin-right: 13px;
	padding-left: 15px;
	padding-right: 15px;
	display: flex;
	align-items: center;
	justify-content: center;
	font-size: 12px;
}
.call-log-wrp input{
	float: left;height: 30px;background-color: #fff;
	color: rgba(0,0,0, 0.7);
	border: 1px solid #e8e8e8;font-size: 13px;
/*	color: #4e4e4e;*/
	
	color: rgba(78,78,78, 0.7);
	text-align: center;
/*	margin-right: 13px;*/
	padding-left: 6px;
	padding-right: 6px;
}
.call-log-wrp{
	margin-bottom: 15px;
	overflow: hidden;
	display: block;
}
.call-log-wrp a:last-child{
	background-color: #222e3a;
	border: 1px solid #222e3a;
	color: #fff !important;
}
.call-log-wrp .form-inline{
	float: right;
}
.call-log-wrp h6{
	margin-right: 12px;
	font-size: 13px;
	color: rgba(78,78,78, 0.7);
}
.call-log-wrp a:nth-child(4){
	
	background-color: <?= $brandColor; ?>;
	border: 1px solid <?= $brandColor; ?>;
	color: #fff !important;margin-left: 0;
margin-right: 0;
}
.table-stuchers{
	padding:0 15px;
}

.footable{
/*	border: 1px solid #e8e8e8;*/
}
.table-stuchers .table thead th{
	background-color: #e8e8e8;
	border-bottom: none;
	color: #666666;
	font-weight: 500;
	font-size: 12px;
}
.footable.breakpoint > tbody > tr > td > span.footable-toggle{
	font-size: 12px;
}
.table-stuchers  .table td, .table th {
	padding:2px 3px;}
.table-stuchers{
    margin-bottom: 20px;
    overflow: hidden;
    max-height: 400px;
    overflow-y: auto;
	
}
.pagination>li>a, .pagination>li>span {
    position: relative;
    float: left;
    padding: 0 9px;
    margin-left: -1px;
    line-height: 1.42857143;
    color: rgba(0,0,0, 0.7);
    text-decoration: none;
    background-color: #fff;
    border: 1px solid #ddd;    height: 30px;
    display: flex;
    align-items: center;
    justify-content: center;
}
.pagination-split li:first-child {
    margin-left: 0;
}
.pagination-split li {
    margin-left: 5px;
    display: inline-block;
    float: left;
}
.pagination > li:first-child > a, .pagination > li:first-child > span {
    border-bottom-left-radius: 3px;
    border-top-left-radius: 3px;
}
.pagination>li:first-child>a, .pagination>li:first-child>span {
    margin-left: 0;
    border-top-left-radius: 4px;
    border-bottom-left-radius: 4px;
}
/*

.table-stuchers .table > thead > tr > th, .table > tbody > tr > th, .table > tfoot > tr > th, .table > thead > tr > td, .table > tbody > tr > td, .table > tfoot > tr > td, .table > thead > tr > th, .table-bordered {
    border-top: 1px solid #ebeff2;
}
*/
.table-stuchers .table td {
	font-size: 12px;
	color: #808080;
}

.footable-odd {
    background-color: #ffffff;
}
.footable-odd {
    background-color: #f7f7f7;
}
.footable-detail-show {
    background-color: #ebeff2;
}
.expend-wrps{
	background-color: #f4f8fb;
	overflow: hidden;
	padding: 10px 10px 10px 10px;
/*	padding-bottom: 10px;*/
}
.table-wrps-call-logs h3{
	font-size: 15px;
	font-weight: 500;
	color: #32a48d;
	margin-bottom: 10px;
	margin-top: 15px;
}
.table-wrps-call-logs table{
	width: 100%;
	background-color: #fff;
	border: 1px solid #d0d0d0;
}
.table-wrps-call-logs table tr td{
	font-size: 11px;
	color: #808080;
	border: 1px solid rgba(208,208,208, 0.5);
	text-align: center;
}
.table-wrps-call-logs table tr th{
	padding:2px 3px;
	text-align: center;
	font-size: 13px;
	background-color:  <?= $brandColor; ?>;
	color: #fff;
}
.table-wrps-call-logs{
	display: block;
	width: 100%;
}
.footable-row-detail {
    background-color: #f4f8fb !important;
/*	display: block;*/
/*	padding: 10px;*/
}
.footable-row-detail-inner {
    display: block !important;
}
.footable-row-detail-row {
	display: block !important;}
.footable-row-detail-value {
	display: block !important;}

.cal-cmt{
	border: 1px solid #d0d0d0;
	background-color: #fff;
	resize: none;
	min-height: 118px;
	width: 100%;margin-top: 5px;
}
.cal-log-top-section table tr td{
	border: none !important;
}
.cal-log-top-section table tr th{
	border: none !important;
}
.cal-log-top-section table tr td table {
	border-collapse: separate !important;
}
.cal-log-top-section table tr td table tr td {
	border: 1px solid #d0d0d0 !important;
	background-color: #fff;
	padding: 3px !important;
}

.cal-log-top-section table tr td table p{
	float: left;
	font-size: 12px;
	color: #808080;
	width: 30%;	padding: 5px;
	overflow: hidden;
	
}
.cal-log-top-section table tr td table span{
	float: right;
	width: 69%;
	color: #616161;	padding: 5px 5px 5px 10px !important;
	font-size: 12px;
	overflow: hidden;
	background-color: #f3f3f3;
}
.footable tbody a{
/*	background-color: <?= $brandColor; ?>;*/
	color: <?= $brandColor; ?>;
}
.footable tbody a:hover{
	color: #000;
}
.table-stuchers .table-striped > tbody > tr:nth-of-type(odd), .table-hover > tbody > tr:hover, .table > thead > tr > td.active, .table > tbody > tr > td.active, .table > tfoot > tr > td.active, .table > thead > tr > th.active, .table > tbody > tr > th.active, .table > tfoot > tr > th.active, .table > thead > tr.active > td, .table > tbody > tr.active > td, .table > tfoot > tr.active > td, .table > thead > tr.active > th, .table > tbody > tr.active > th, .table > tfoot > tr.active > th {
    background-color: #fff !important;
}
.table-stuchers table tfoot .text-right{
	float: right;
	margin-top: 40px;
}
.table-stuchers table tfoot tr td {
	border: none !important;
}
.main_container{
	    background-color: rgba(34,46,58, 0.9);
    top: 0px !important;
    bottom: 0px !important;
    left: 0px !important;
    right: 0px !important;
}
.main_container table{
	background-color: #fff;
	margin: 0 auto;
}
.sh_txt-design{
	padding: 12px 0;
	overflow: hidden;
}
#sample_1_info{
	top: 0;    font-size: 12px;
}
#sample_1_filter .form-control{
	display: inline-block;
    width: auto;margin-left: 10px;
}
#sample_1_length .input-small{
	margin-right: 10px
}
.table-bordered tbody tr td{
	font-size: 14px;
    color: #808080;
	padding: 7px 3px 6px 3px;
	font-weight: 400;
}


.lead_information{
	width: 100%;
	border-top: none !important;
    border-left: none !important;
}

.lead_information tbody{
	float:left;
	width: 100%;
}
.lead_information tbody tr{
	width: 50%;
	float: left;
	
}
.lead_information tbody tr{
	width: 25%;
	float: left;
	border-bottom: none !important;
	border-top: none !important;
}
.lead_information tbody tr td{
	width: 50%;
	float: left;
	border-bottom: none !important;
	min-height: 32px;
		text-align: right;
}

.lead_information tbody tr td:nth-child(even)
{
/*	    background-color: #f7f7f7 !important;*/
/*	    background-color: rgba(247,247,247,0.50);*/
    border-left: none;
    border-right: none;
}
.lead_information tbody tr:nth-of-type(odd) {
	 background-color: rgba(247,247,247,0.50);
}
.table-bordered{
	border: 1px solid #e9e9e9 ;
    margin-top: 0;
	background-color: #fff !important;
    margin: 0 auto;
	width: 100%;
}
.table-bordered h3{
	margin-bottom: 12px;
	font-size: 15px;
	font-weight: 500;
	color: <?= $brandColor; ?>;
}
.table-bordered tbody tr td {
	font-size: 12px;

}
.table-bordered tbody tr td  a {
	color: <?= $brandColor; ?>;
}
/*
.details{
	
}
*/
.details{
	padding: 15px 15px !important;
}
.lead_information tbody tr:last-child{
	border-right: 1px solid #dee2e6;
} 
.lead_information tbody tr:nth-child(23){
	border-bottom: 1px solid #dee2e6  !important;
}
.lead_information tbody tr:nth-child(24){
	border-bottom: 1px solid #dee2e6 !important;
}
#TransferMain{
	    left: 0 !important;
	    right: 0 !important;
    bottom: 0 !important;
    top: 0 !important;
    background-color: rgba(34,46,58, 0.9);
    height: 100vh;
}
.modal-content1 .nav-tabs .nav-link.active:hover{
	color: <?= $brandColor; ?>;
    border: none;
    border-top: 2px solid <?= $brandColor; ?>;
    border-radius: 0;
	background-color: #fff;
}
#callsinqueuedisplay{
	background-color: rgba(34,46,58, 0.9);
top: 0px !important;
bottom: 0px !important;
left: 0px !important;
right: 0px !important;
}
/* quea tabkle */

.table-bordered thead th{
	background: <?= $brandColor; ?>;
color: #fff;
font-weight: 500;
/*font-size: 12px;*/
}

#callsinqueuelist{
/*
	margin-top: 10px;
    padding: 0 10px;
*/
    width: 100% !important;
	height: auto !important;
	max-height: 400px !important;
	overflow-y: auto;
}
#callsinqueuelist table {
    width: 100% !important;
    background-color: #fff;
/*    border: 1px solid #e9e9e9 !important;*/
}

#logoutFade .modal-content{
	width: 490px;
/*height: 180px;*/
background-color: #fff;
position: relative;
overflow: hidden;
padding: 12px;
color: #6e6e6e;
display: block;
	border-radius: 0 !important;
}
#logoutFade .modal-body{
	
padding: 20px 15px 20px 160px !important;
height: 160px;
border: 1px solid #e5e5e5;
	
	
		position: relative;
}

#logoutFade .modal-body::before{

background-color: <?= $brandColor; ?>;
background: url(images/logouts-org.png) center 50px no-repeat <?= $brandColorHover; ?>;
    position: absolute;
    left: -11px;
    top: -11px;
    content: "";
    border-radius: 0;
    width: 149px;
    height: 180px;
	
}
#id_agcPAGE input{
	display: inline-block;
height: 38px;
border: none;
border-radius: 0;
text-transform: uppercase;
font-size: 12px;
font-weight: 400;
color: #fff;
width: 105px;
background-color: <?= $brandColorHover; ?> !important;
text-decoration: none;
box-sizing: border-box;
align-items: center;
justify-content: center;
cursor: pointer;
text-align: center;
float: right;
}
#id_agcPAGE input:hover{
	background-color: <?= $brandColorHover; ?> !important;
}
#id_logout_content{
	font-size: 16px;
margin-top: -18px;
text-align: left;min-height: 71px;
}
.microph-wrp-3{
	margin-top: 0 !important;
}
.top-menu-bar ul li ul li:last-child:hover{
background-color: #fff;
}
.top-menu-bar ul li ul li{
	padding: 0 !important;
}
.top-menu-bar ul li:hover > ul{
/*	padding: 10px;*/
/*	position: relative;*/position: absolute;
}


.top-menu-bar ul li ul li {
		font-size: 12px;
line-height: 31px;
}
.top-menu-bar ul li ul li .skb_text{
	height: 25px;
	width: 25px;
	display: flex;
	align-items: center;
	justify-content: center;
	font-size: 13px;
	float: left;
	border: 1px solid rgba(0,0,0,0.1);
	margin-left: 12px;
	margin-right: 10px;
	margin-bottom: 5px;
	margin-top: 5px;
	background-color:rgba(0,0,0,0.02);
	
}


.top-menu-bar ul li ul li span{
	width: 100%;
	background-color:rgba(0,0,0,0.1);
	height: 1px;
	margin:5px 0 0 0;
	overflow: hidden;
	display: block;
	
}


.notification-small{
	border: 1px solid #fff;
	background-color: #222e3a;
	height: 38px;
	padding-left: 50px;
	padding-right: 23px;
	position: absolute;
	z-index: 9;
	overflow: hidden;
	top: 50%;
    right: 5%;
}
.notification-small::after{
	left: 32px;
	top: 0;
	position: absolute;
	  width: 0;
      height: 0;
      border-bottom: 36px solid <?= $brandColor; ?>;
      border-right: 11px solid transparent;content: "";
}
.notification-small::before{
	content: "";
	height: 36px;
	width: 32px;
	background-color: <?= $brandColor; ?>;
	background: url(../images/info-icons.png) center 7px no-repeat <?= $brandColor; ?>;
	left: 0;
	top: 0;
	position: absolute;
	
}
.notification-small p{
	color: #fff;
	font-size: 13px;
	height: 36px;
	display: flex;
	align-items: center;
}
.notification-callback{
	border: 1px solid #38c0a4;
/*	display: block;*/
	overflow: hidden;
	position: absolute;
	z-index: 9;
	width: 500px;
	background-color: #fff;
	top: 40%;
    left: 40%;
}
.notfication-head{
	background-color: #38c0a4;
	position: relative;
	height: 27px;
}
.notfication-head::before{
	
	left: -1;
	top: 0;
	position: absolute;
	  width: 0;
      height: 0;
      border-bottom: 27px solid #222e3a;
      border-right: 13px solid transparent;content: "";
}
.notfication-head h2{
	font-size: 13px;
	color: #fff;
	float: left;
	height: 27px;
	display: flex;
	align-items: center;
	padding-left: 16px;
	
}
.notfication-head a{
	float: right;
	background-color: rgba(0,0,0, 0.10);
	height: 27px;
	width: 27px;
	color: rgba(255,255,255, 0.7);
	display: flex;
	align-items: center;
	justify-content: center;
	font-size: 10px;
}
.notfication-head a:hover{
	color: rgba(255,255,255, 1);
	background-color: rgba(0,0,0, 0.20);
}
.noti-content{
	padding:6px 6px 6px 6px;
	overflow: hidden;
}
.noti-txt p{
	font-size: 12px;
	color: #777777;
    margin-bottom: -1px;
}
.noti-comment{
	float: right;
	width: 250px;
	background-color: #f8f8f8;
	min-height: 50px;
	padding:5px 10px;
	font-size: 12px;
	color: #a3a3a3;
}
.noti-txt{
	float: left;
	padding-left: 10px;
	
}
.notification-call-wrp{
	height: 90px;
	width: 375px;
	border: 1px solid #e5e5e5;
	position: absolute;
	z-index: 9;
	background-color: #fff;
	top: 30%;
	left: 40%;
}
.notfication-call-bk{
	overflow: hidden;
	padding-left: 15px;
}
.notfication-icon-main::after{
	left: 0px;
	top: 0;
	position: absolute;
	  width: 0;
      height: 0;
      border-bottom: 90px solid <?= $brandColor; ?>;
      border-right: 33px solid transparent;content: "";
}
.notfication-icon-main{
	height: 90px;
	width: 90px;
	background-color: #222e3a;
	position: relative;
	float: left;padding-left: 24px;
    padding-top: 20px;
	
}
.cal-wrp-head{
	display: block;
	padding-top: 5px;
	padding-right: 6px;
	position: relative;
	
}

.cal-wrp-head h2{
	font-size: 16px;
	font-weight: 500;
	color: #38c0a4;
	float: left;
	display: flex;
	align-items: center;
	
}
.cal-wrp-head a{
	float: right;
	background-color: #e5e5e5;
	height: 23px;
	width: 22px;
	color: #222e3a;
	display: flex;
	align-items: center;
	justify-content: center;
	font-size: 10px;position: absolute;
    right: 6px;
}
.noti-call-wrp{
	width: 100%;
    clear: both;
	display: block;
	padding-right: 6px;
}
.noti-call-wrp a{
	color: #fff;
	font-size: 11px;
	text-transform: uppercase;
	padding: 2px 6px;
	margin-top: 10px;
	background-color: #38c0a4;
}
.noti-call-wrp p{
	font-size: 12px;
	color: #777777;
}
.notification-wrappers{
	
	overflow: hidden;
background-color: rgba(16, 68, 125, 0.95);
	
  box-shadow: 0px 0px 5px 0px rgba(0, 0, 0, 0.2);
	width: 480px;
height: 180px;
	padding: 12px;
	
	position: absolute;
	z-index: 9;
	top: 15%;
	left: 15px;border-radius: 5px;
}

.notif-icons img{

	margin: 0 auto;
}
.notif-icons{
	height: 180px;
	float: left;
	width: 110px;
	display: flex;
	align-items: center;

    position: relative;
    left: -12px;
    background-color: <?= $brandColorHover; ?>;
    top: -12px;
    border-radius: 5px 0 0 5px;
	
}
.notif-txt{
	overflow: hidden;    
<!--	width: 83%;-->
<!--	display: block;-->
}
.noti-txt-hd{
	overflow: hidden;
	display: block;
}
.noti-txt-hd h2{
	font-weight: 500;
	color: #fff;
	font-size: 15px;
	float: left;
	
}
.noti-txt-hd a{
	float: right;
	font-size: 11px;
	color: #fff;
	display: block;
}
.noti-txt-info{
	float: none;
    width: 100%;
<!--    margin-top: 10px;-->
    clear: both;
    display: block;
	
}
.noti-cmt{
	float: none;
    width: 100%;
    margin-top: 10px;
    clear: both;
    display: block;
}
.noti-cmt textarea{
	width: 100%;
	    height: 53px;
    font-size: 13px;
    border: 1px solid rgba(255,255,255,0.1);
    background-color: rgba(16, 68, 125, 0.95);
    border-radius: 3px;
	color: #fff;
}
.noti-txt-hd{
	margin-bottom: 10px;
}
.noti-txt-info p{
	color: #fff;
	font-size: 13px;
}

.noti-txt-info p span{
	color: #fff;
}
#PresetsSelectBox{
	right: 0 !important;
bottom: 0 !important;
top: 0 !important;
left: 0 !important;
background-color: rgba(34,46,58, 0.9);
height: 100vh;
}
#PresetsSelectBoxContent{
	width: 100% !important;
	height: auto !important;
	max-height: 400px;
	overflow-y: auto;
	overflow-x: hidden;
}
/* dispo */


.dispo-wrapper{
	position: relative;
	position: absolute;
bottom: 0;
    z-index: 9;
    width: 100%;
    left: 0px;
	animation: fadeUp 1s ease-in both;
}

@keyframes fadeUp {
	from {
		opacity: 0;
		transform: translate3d(0, 100%, 0);
	}
	to {
		opacity: 1;
		transform: translate3d(0, 0, 0);
	}
}

.dispo-wrapper a{
	
	padding: 0 37px 0 15px;
	height: 42px;
	font-size: 15px;
	color: #fff;
	display: block;
	border-radius: 2px;
	background-color: #222e3a;
	line-height: 40px;
}

.dispo-wrapper a::before{
	height: 42px;
	width: 42px;
	border-radius: 2px;
	background: url(../images/disposition.png) center 14px no-repeat #141e29;
	right: 0;
	top: 0;
	position: absolute;
	content: "";
}
.green-clr a{
		background-color: <?= $brandColor; ?>;
}
.green-clr a::before{background: url(../images/disposition.png) center 12px no-repeat #0b8b71;

}
.sidebar-disable{
	    opacity: 0.2;
	cursor: default !important;
	pointer-events: none !important;

}
.sidebar-disable li a{
	cursor: default !important;
	pointer-events: none !important;
}
.sidebar-disable li{
	cursor: default !important;
	pointer-events: none !important;
}
.sidebar-disable a{
	cursor: default !important;
	pointer-events: none !important;
  
}


.sidebar-disable ul li a{
	cursor: default !important;
	pointer-events: none !important;
 
}
.iframe-container {
 position: relative;
    padding-bottom: 3%;
    height: 0;
    overflow: hidden;
}
.iframe-container iframe{
	position: absolute;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
	border: none;
}
.phone-cl-grp a{
	font-size: 21px !important;
}
#PauseCodeLinkSpan a{
	font-size: 21px !important;;
}
#CBstatusSpan a{
	font-size: 21px !important;
}
#AgentViewLink a{
	font-size: 17px !important;
}
#CallLogLinkSpan a{
	font-size: 22px !important;
}
.dialer_datetime{
float: left;
    text-align: right;
    font-size: 9px;
    margin-top: -15px;
    /* padding-right: 17px; */
    /* opacity: 0.8; */
/*    background-color: #232f3b;*/
    margin-right: 0;
    display: block;
/*    padding: 12px 11px 12px 36px;*/
        padding: 0;
    /* font-weight: 500; */
    border-radius: 0;
/*     position: relative; */
/*    color: #fff;*/
	border-radius: 3px !important;
}
#status{
	 font-size: 10px !important;
	    position: absolute;
    left: -135px;
    top: 34px;
    z-index: 999;
    color: rgba(0,0,0,0.70);
}
.dialer_datetime::before{
	width: 0;
    height: 0;
      border-top: 42px solid #fff;
    border-right: 30px solid transparent;
    position: absolute;
    left: 0;
    top: 0;
    content: "";
	display: none;
}
.main-header .logo{
	    background-color: #fff;
	    height: 51px;    
/*	margin-left: 9px;*/
/*	border-bottom: 1px solid rgba(255,255,255,0.08);*/
	border-right: 1px solid rgba(0,0,0,0.10);
}
/*
.main-header .navbar{
	background-color: #2a3948;
}
*/
/*
.top-menu-bar li a {
	color: rgba(255,255,255,0.8) !important; }
.top-menu-bar li a {
    color: rgba(255,255,255,0.8) !important;
}
.diable-ld {
	border-left: 1px solid rgba(255,255,255, 0.1);}*/

.footers {
    background-color: #2a3948;
    position: absolute;
    z-index: 999;
    width: 100%;
    overflow: hidden;
    bottom: 0;
    height: 40px;
	padding: 5px 20px 0 20px;
}.footer-info {
    float: left;
    border-right: 1px solid rgba(71,88,104, 0.1);
/*    padding: 14px 19px 13px 19px;*/
    overflow: hidden;
/*	margin-top: 5px;*/
	margin-right: 15px;
}
.footer-info span img{
	text-align: center;
	display: block;
	margin: 0 auto;
	display: block;
	align-items: center;
	justify-content: center;
}
.footer-info-img{
	padding-top: 9px !important;
}
.footer-info span {
    float: left;
	padding-top: 6px;
    margin-right: 13px;
	background-color: #222e3a;
	height: 30px;
	width: 30px;
		
}.footer-info p a{
	   color: #fff !important;
    font-size: 14px;
	display: block;
	overflow: hidden;

}.footer-info p {
    float: left;
    color: #fff !important;
    font-size: 13px;
	margin: 0;line-height: 30px;
}
.footer-info1{
	float: right;
}
.footr-link{
	color: #fff;
	float: left;
	display: block;
	font-size: 13px;line-height: 30px;
}
.header-wrp{
	 background-color: #fff;
    position: fixed;
    z-index: 999;
    width: 100%;
    overflow: hidden;
    top: 0;
    height: 55px;
	width: 100%;
	left: 0;
	padding: 6px 20px 0 20px;
	display: block;
}
.logo-tp{
	margin: 0 auto;
	text-align: center;
/*	width: 200px;*/
}


.logo-tp {
  text-align: center;
}

.logo-tp img {
  /* Allow image to scale to its container */
  max-width: 100%;
  height: auto;
  display: inline-block;
}


.language-wrp{
	float: right;
	margin-top: 14px;
}
.login-top-section{
	text-align: center;
}

.login-top-section h3{
	    margin-top: 5px;
    font-weight: 600;margin-bottom:30px;line-height: 1.2;color: #676a6c;text-align: center!important;
}
.login-top-section p{
	    margin-top: 0;
    margin-bottom: 1rem;text-align: center!important;
       font-size: 13px;
    color: #676a6c;
    font-weight: 400;
    line-height: 1.5;
}
/* slider */
#fade{
width: 100%;
  height: 100vh;
 /*a width should be defined for transition to work*/

}   
		.slider-bnr{
			background-size: cover;
			width: 100%;
			height: 100vh;
		}

.header-links{
	float: right;
	margin-top: 4px;
}

.header-links ul{
	padding: 0;
	margin: 0;
	text-align: right;
}

.header-links ul li{
	float: left;
	margin-left: 15px;
	cursor: pointer;
}

.header-links ul li:last-child a{
	background-color: <?= $brandColor; ?>;
	display: block;
	color: #fff;
}
.header-links ul li a:hover{
	background-color: #3dd1b3;
	color: #fff;
}
.header-links ul li a p{
	float: left;
	font-size: 15px;
	font-weight: 300;    line-height: 33px;	float: left;
}
.header-links ul li a{
	height: 36px;
	cursor: pointer;
	background-color: #fff;
	width: 141px;	display: block;
	color: #2a3948;
	text-align: left;
}
.header-links ul li a span{
	background-color: <?= $brandColor; ?>;
	height: 36px;
	width: 36px;	display: block;
	text-align: center;
	padding-top: 8px;
	line-height: 27px;
	margin-right: 8px;
	float: left;
	
}
.modal-dialog-wrp{
	width:380px;
	margin: 0;
}
.modal-dialog-wrp .modal-content{
	border-radius: 0 !important;
  background-color: rgb(42, 57, 72, 0.95) !important;
/*	border: 1px solid rgba(255,255,255, 0.3);*/
	    border: 1px solid #a6a6a6;

}

.modal-dialog-wrp .modal-body{
	padding: 15px 15px 10px 15px;
}
.modal-dialog-wrp .modal-header{
	border: none;
/*	background-color: #24ba9b;*/
	    background-color: rgba(34,46,58, 1) !important;
    height: 39px;
    border-radius: 0;
	padding: 0;
}
.modal-header h2{
	font-size: 14px;
    text-transform: uppercase;
    font-weight: 500;
    float: left;
    color: #fff;
  padding-left: 15px;
    padding-top: 10px;
}
/*
.model-dropdown{
	position: absolute !important;
	width: inherit !important;
	left: inherit !important;
	right: 0;
	height: inherit;
	top: 55px;
}
*/
.timeclock-wrapper p{
	font-size: 12px;
	color: #fff !important;
	opacity: 0.8;
	margin-bottom: 10px;
}
.timeclock-wrapper input{
/*border: 1px solid #495663 !important;	*/
}
#timeclock_content iframe{
	width: 100%;
	border: none;
	min-height: 230px;
    overflow: hidden;
}
/*
.timeclock-wrapper {
	    display: block;
    clear: both;
    width: 100%;
    position: inherit;
    height: 100vh;
    overflow-y: auto;
}
*/
.timeclockbtn{
	margin-bottom: 0 !important;
}
.header-links ul li:last-child a:hover{
	background-color: #3dd1b3 !important;
}
.header-links ul li a:hover span{
	background-color: #3dd1b3 !important;
}
.close-btn-login{
	padding: 0 !important;
    margin: 0 !important;
    float: right;
    height: 38px;
    width: 38px;
    background-color: #3e4a56 !important;
}
/* loader new */


  .m-blockui > span {
    display: table-cell;
    vertical-align: middle;
    padding: 8px 15px;
    font-size: 14px;
    font-weight: 400; 
	    width: 100%;
    clear: both;
    margin: 0 auto;
    display: block;box-shadow: none !important;
}
    .m-blockui > span > .m-loader,
    .m-blockui > span > .m-spinner {
      margin-right: 10px; }

.m-blockui {
  background: #ffffff;box-shadow: none !important;
/*
  -webkit-box-shadow: 0px 1px 15px 1px rgba(69, 65, 78, 0.1) ;
  box-shadow: 0px 1px 15px 1px rgba(69, 65, 78, 0.1) ;
*/
}

.m-blockui > span p{
	margin-top: 10px;
}
  .m-blockui > span {
    color: #6f727d; box-shadow: none !important;}
.loader-mg{
/*	margin-right: 60px !important; */
}
.m-loader {
  position: relative; }
  .m-loader:before {
    content: '';
    -webkit-box-sizing: border-box;
    box-sizing: border-box;
    position: absolute;
    top: 50%;
    left: 50%;
    border-top: 1px solid <?= $brandColor; ?>;
    border-right: 1px solid transparent;
	border-bottom: 1px solid <?= $brandColor; ?>;
    border-radius: 50%;
    -webkit-animation: m-loader-rotate 0.9s linear infinite;
    animation: m-loader-rotate 0.9s linear infinite;
	border-left: 1px solid <?= $brandColor; ?>;
}
  .m-loader:before {
    width: 3.6rem;
    height: 3.6rem;
    margin-top: 1px;
    margin-left: 1px;
    border-top-width: 3px;
    border-right-width: 3px;
    border-left-width: 3px;
    border-bottom-width: 3px; }
  .m-loader.m-loader--lg:before {
    width: 2rem;
    height: 2rem;
    margin-top: -1rem;
    margin-left: -1rem;
    border-top-width: 3px;
    border-right-width: 3px; }
  .m-loader.m-loader--sm:before {
    width: 1rem;
    height: 1rem;
    margin-top: -0.5rem;
    margin-left: -0.5rem;
    border-top-width: 1px;
    border-right-width: 1px; }
  .m-loader.m-loader--right:before {
    left: auto;
    right: 0.7rem; }
  .m-loader.m-loader--right.m-loader--lg:before {
    right: 1rem; }
  .m-loader.m-loader--right.m-loader--sm:before {
    right: 0.5rem; }
  .m-loader.m-loader--right.btn {
    padding-right: 3.25rem; }
    .m-loader.m-loader--right.btn.m-loader--lg {
      padding-right: 4.65rem; }
    .m-loader.m-loader--right.btn.m-loader--sm {
      padding-right: 2.3rem; }
  .m-loader.m-loader--left:before {
    left: 1.4rem; }
  .m-loader.m-loader--left.m-loader--lg:before {
    left: 2rem; }
  .m-loader.m-loader--left.m-loader--sm:before {
    left: 1rem; }
  .m-loader.m-loader--left.btn {
    padding-left: 3.25rem; }
    .m-loader.m-loader--left.btn.m-loader--lg {
      padding-left: 4.65rem; }
    .m-loader.m-loader--left.btn.m-loader--sm {
      padding-left: 2.3rem; }

@-webkit-keyframes m-loader-rotate {
  to {
    -webkit-transform: rotate(360deg);
    transform: rotate(360deg); } }

@keyframes m-loader-rotate {
  to {
    -webkit-transform: rotate(360deg);
    transform: rotate(360deg); } }

.m-loader:before {
  border-top-color: #dfe2ea; }

.m-loader.m-loader--skin-dark:before {
  border-top-color: #acafba; }

.m-loader.m-loader--brand:before {
  border-top-color: <?= $brandColor; ?>; }

.m-loader.m-loader--metal:before {
  border-top-color: #c4c5d6; }

.m-loader.m-loader--light:before {
  border-top-color: #ffffff; }

.m-loader.m-loader--accent:before {
  border-top-color: #00c5dc; }

.m-loader.m-loader--focus:before {
  border-top-color: #9816f4; }

.m-loader.m-loader--primary:before {
  border-top-color: #5867dd; }

.m-loader.m-loader--success:before {
  border-top-color: #34bfa3; }

.m-loader.m-loader--info:before {
  border-top-color: #36a3f7; }

.m-loader.m-loader--warning:before {
  border-top-color: #ffb822; }

.m-loader.m-loader--danger:before {
  border-top-color: #f4516c; }


.model-loader::-webkit-scrollbar {
  display: none;width: 0 !important
}
.model-loader{
	-ms-overflow-style: none;
    overflow-y: hidden; /* Hide vertical scrollbar */
  overflow-x: hidden; /* Hide horizontal scrollbar */
	   
	position: fixed;
    top: 0;
    left: 0;
	bottom: 0;
	right: 0;
    height: 100%;
    width: 100%;
	z-index: 9999999999999999;
	
background-color: rgba(255,255,255, 1.00);

	
}
.bg-transparent{
	
	background-color: rgba(255,255,255, 0.80) !important;
}
.model-loader .model-wrps{
  display: table;
   
	position: fixed;
    height: 100%;
    width: 100%;
}

.model-loader .model-wrps .model-wrp-loader{
 display: table-cell;
    vertical-align: middle;
}


.m-blockui {
  border-radius: 4px;
  display: table;

	  margin-left: auto;
    margin-right: auto;
    /*width: 180px;*/
	background-color: #fff;
}
/*
select:focus{
	outline: inherit !important;	
}
input:focus{
	outline: inherit !important;
}*/

*, input, select, textarea, option, button {
    outline: none !important;
}
*:focus {
     outline: none !important;
}
option:hover{
	 outline: none !important;
}
option:focus{
	 outline: none !important;
}
.option:hover{
	 outline: none !important;
}
.option:focus{
	 outline: none !important;
}
.gray-bg{
	background-color: #f3f3f4 !important; 
}.fadeInDown {
    -webkit-animation-name: fadeInDown;
    animation-name: fadeInDown;
}
.animated {
    -webkit-animation-duration: 1s;
    animation-duration: 1s;
    -webkit-animation-fill-mode: both;
    animation-fill-mode: both;
}
.loginscreen.middle-box {
    width: 300px;
}

.text-center {
    text-align: center!important;
}
.loginscreen.middle-box {
    width: 400px;
	background-color: #fff;
	border-radius: 10px;
  box-shadow: 0px 0px 15px 0px rgba(35, 31, 32, 0.1);
	margin: 0 auto;
padding: 0;border-radius: 10px !important;
	margin:0 autoa;
/*	overflow: hidden;*/

}


.login-containers {
  /* Constrain and center the container */
  max-width: 400px;
  width: 100%;
  margin: 60px auto;

  /* Clean background and subtle border */
  background-color: #ffffff;
  border: 1px solid #e0e0e0;
  border-radius: 0.5rem;

  /* Spacious padding */
  padding: 40px 30px;

  /* Soft shadow for depth */
  box-shadow: 0 4px 12px rgba(0, 0, 0, 0.05);

  /* Stacking context */
  position: relative;
  z-index: 10;
}

.left-area{
	height: 430px;
	width: 80px;
	right: -80px;
	position: absolute;
	top: 30px;
	border-radius: 0px 10px 10px 0px;
	background-color: <?= $brandColor; ?>;
/*	padding-top: 50%;*/
	cursor: pointer;overflow: hidden;
}
.left-area a{
/*	height: 100%;*/
    width: 100%;
    color: #fff;
    font-size: 20px;
    text-transform: uppercase;
    text-align: center;
    font-weight: 600;
    z-index: 999;
    cursor: pointer;
    display: block;
    overflow: hidden;
    /* padding-top: 45%; */
    writing-mode: vertical-rl;
    letter-spacing: 30px;
   display: flex;
	align-items: center;
	justify-content: center;
    height: 430px;
	text-orientation: upright;
}
.left-area:hover{
		width: 88px;
	right: -88px;
	background-color: <?= $brandColorHover; ?>;
/*	  transition-delay: 0.1s;*/
/*	animation: mymove 5s infinite;*/
	
}
/*
@keyframes mymove {
  from {right: -88px;}
  to {right: -88px;}
}
*/
@media (max-width: 1199px) {
			
		
}
@media (max-width: 992px) {
			
		
}
@media (max-width: 767px) {
			
		#DispoSelectContent {
    height: 300px;
    overflow-y: auto;
}
}
@media (max-width: 480px) {
		#DispoSelectContent {
    height: 300px;
    overflow-y: auto;
}	
		
}
.btn {
    box-shadow: 0 2px 6px 0 rgb(0 0 0 / 20%);
}
.btn-warning {
    box-shadow: 0 2px 6px 0 rgb(253 196 94 / 50%) !important;
}
.btn-danger {
    box-shadow: 0 2px 6px 0 rgb(247 89 100 / 50%)!important;
}
.btn.red {
    box-shadow: 0 2px 6px 0 rgb(247 89 100 / 50%)!important;
}
.btn-success {
    box-shadow: 0 2px 6px 0 rgb(90 208 146 / 50%)!important;
}
.btn-primary {
    box-shadow: 0 2px 6px 0 rgb(<?= $brandColorShadow; ?> / 20%)!important;
}
.right-sidebar-toggle {
    box-shadow: 0 2px 6px 0 rgb(<?= $brandColorShadow; ?> / 20%)!important;
}
.btn.green {
    box-shadow: 0 2px 6px 0 rgb(<?= $brandColorShadow; ?> / 20%)!important;
}
.choos-reports a {
    box-shadow: 0 2px 6px 0 rgb(<?= $brandColorShadow; ?> / 20%)!important;
}
.btn-info {
     box-shadow: 0 2px 6px 0 rgb(79 198 225 / 950%) !important; 
}
.left-area{
	box-shadow: 0 2px 6px 0 rgb(<?= $brandColorShadow; ?> / 20%)!important;
}
.loginbtn, #AgenTDisablEBoX a, #id_agcPAGE input {
    box-shadow: 0 2px 6px 0 rgb(<?= $brandColorShadow; ?> / 20%)!important;
	border-radius: 3px !important;
}
#CloserSelectBox .sh_text a{
	 box-shadow: 0 2px 6px 0 rgb(0 0 0 / 20%) !important;	border-radius: 3px !important;
}
#CloserSelectAdd a:nth-child(even) {
    box-shadow: inherit !important;
}
#NoneInSessionBox a, .btnsubmit-calender{
	 box-shadow: 0 2px 6px 0 rgb(0 0 0 / 20%) !important;	border-radius: 3px !important;
}
#NoneInSessionBox a:first-child{
	 box-shadow: 0 2px 6px 0 rgb(<?= $brandColorShadow; ?> / 20%)!important; border-radius: 3px !important;
}
.dispoSelection-bottom a, #AlertBox button{
	 box-shadow: 0 2px 6px 0 rgb(<?= $brandColorShadow; ?> / 20%)!important; border-radius: 3px !important;
}





.btn-leadsearch a:last-child {
    box-shadow: 0 2px 6px 0 rgb(<?= $brandColorShadow; ?> / 20%)!important;
}

.btn-leadsearch a{
	 box-shadow: 0 2px 6px 0 rgb(0 0 0 / 20%);
}
.dialableleadsspan{
	padding-top: 9px;
    margin-right: 9px;
}
.dialableleadsspan {
	border: none !important;
}
.dialableleadsspan a p{
	color: #787878;
}
.dialableleadsspan a{
    padding-left: 15px;
    padding-right: 15px;padding-top: 6px !important;
    padding-bottom: 6px !important;
    border-radius: 3px;
    height: auto !important;box-shadow: 0px 0px 27px 0px rgb(0 0 0 / 5%);
	
}
.top-menu-bar li:first-child{
	border: none;
}

.main-tabs{
/*
	margin-bottom: 11px;
    margin-top: 15px;
*/
}
/*
.microph-wrp{
	padding-right: 8px;
}
.dtmf{
	padding-right: 8px;
}
#ManuaLDiaLButtons{
	padding-right: 8px;
}
.dial-number{
	padding-right: 8px;
}
*/




body{
/*	background-color: #222e3a !important;*/
}

.content-wrapper{
	
/*	border-radius: 0px;*/
}

.main-header {
/*   border-radius: 0px;*/
}
.nav-tabs .nav-item.show .nav-link, .nav-tabs .nav-link.active{
/*	background-color: #f1f2f7;*/
	background-color: #fff;
}
.logo-lg{
	background-color: #fff;
    display: block;
    border-radius: 0 0 0 0;overflow: hidden;
}
.microph-wrp22{
	    background-color: #f1f2f7;overflow: hidden;
	padding-right: 0;padding-top: 0;position: relative;
    right: -8px;
/*    top: -5px;*/
/*	margin-bottom: 15px;*/
	overflow: inherit !important;
}
.microph-num{
	  display: block;
/*	overflow: hidden;*/
	background-color: #222e3a;
    display: block;
    border-radius: 0 20px 0  0;
	padding-top: 20px;    padding-right: 13px;min-height: 40px;
}
.left-menu-links{
	display: block;
	overflow: hidden;
	margin-top: 15px;
}
.left-menu-links li{
	margin-bottom: 10px;
}
.left-menu-links li a{
	background: rgb(42,57,72);
background: linear-gradient(90deg, rgba(42,57,72,1) 10%, rgba(34,46,58,1) 100%);
	display: block;
	color: #fff;
	border-radius: 90px;overflow: hidden;
	padding: 5px;position: relative;line-height: 35px;
}
.left-menu-links li a i{
	height: 35px;
	width: 35px;
	margin-right: 10px;display: flex;
	align-items: center;
	justify-content: center;
	font-size: 18px;
	background: linear-gradient(90deg, rgba(42,57,72,1) 0%, rgba(34,46,58,1) 100%);
	border-radius: 90px;
	float: left;
}
.warningclr22 {
    position: absolute;
    top: 8px;
    right: 5px;
/*    text-align: center;*/
    font-size: 12px;
    height: 25px;
    width: 25px;
    border-radius: 50px;
    background-color: #eb253d;
/*    line-height: normal;*/
/*    padding-left: 2px;*/
    font-weight: 500;
	display: flex;align-items: center;justify-content: center;
}

.blinkss{  animation: blinkss 1s linear infinite;
overflow: hidden;
}

@keyframes blinkss{
0%{opacity: 0;}
50%{opacity: .5;}
100%{opacity: 1;}
}

.microph-wrp22 h3{
	    margin-left: -8px;
}
.sidebar-menus{
	clear: both;
	width: 100%;
}
.top-menu-bar {
    position: relative;
}
#Manual_Dial_Box{
	top: 103px !important;

/*	background-color: #222e3a;*/
	background-color: rgba(34,46,58,1);
	background-color: #161f27;
	border: none;
}



#Manual_Dial_Box .control-sidebar.control-sidebar-open, .control-sidebar.control-sidebar-open + .control-sidebar-bg {
    right: 80px !important;
    /* padding-top: 71px; */
}
.dialbox-left{
	overflow: hidden;
	padding: 5px 0 5px 0;
	clear: both;
	width: 100%;
}
.navbar-right ul ul h2{
	color: #fff !important;
    margin-bottom: 8px;
    padding: 16px 20px;
    background-color: #222e3a;
}


.dial-number ul li {
    width: 32.8%;
    text-align: center;
    float: left;
    background-color: transparent !important;
    margin-left: 0;
    margin-right: 0;
    border-radius: 0;
    margin-bottom: 0;
    border-right: 1px solid rgba(255,255,255,0.1);
    border-bottom: 1px solid rgba(255,255,255,0.1);
}

.dial-number ul li:nth-child(3){
	border-right: none;
}
.dial-number ul li:nth-child(6){
	border-right: none;
}
.dial-number ul li:nth-child(9){
	border-right: none;
}
.dial-number ul li:nth-child(10){
	border-bottom: none;
}
.dial-number ul li:nth-child(11){
	border-bottom: none;
}
.dial-number ul li:nth-child(12){
	border: none;
}
.dial-btn{
	position: absolute;
	top: 150px;
	right: -10px;
	z-index: 9;
}
.dial-btn a{
	
	border-radius: 90px 0 0 90px;
    padding: 10px 35px 10px 25px;
    display: block;
    overflow: hidden;
    background-color: #2a3948;
    color: rgba(255,255,255,0.70);
    font-size: 21px;
}
.dial-btn:hover{
		right: 0px;
}
.manual-dial-options{
	
	padding: 0 10px;   
   /*  background-color: #161f27; */
    display: block;
    overflow: hidden;
}
.manual_dial_btn i{
	margin-right: 10px;
}
.manual_dial_btn.pull-right{
background-color: <?= $brandColorHover; ?>;
}
.manual_dial_btn:hover{
		opacity: 0.8;
}
.manual_dial_btn{
	width: 48%;
	float:left;
	padding:2px 0;

 background-color: <?= $brandColorHover; ?>;
	color: #fff;
	border: none;
	border-radius: 3px;
	    font-size: 14px;
	        margin-bottom: 5px;

}

.manual_dial_btn:hover{
	
}



.dial-btn a:hover{
<!--	background-color: <?= $brandColorHover; ?>;-->
}
.dial-number ul li a {
    text-align: center;
    font-size: 16px;
    font-weight: 500;
    padding: 10px 0;
    color: #fff;
    display: block;
    overflow: hidden;
    border-radius: 0;
	opacity: 0.7;
}
.dial-number ul li a:hover{
	opacity: 1;
}
.pull-right{
	float: right !important;
}
.close-btn-right{
	    float: right;
    margin-top: 17px;
    font-size: 18px;
    opacity: 0.7;
    margin-right: 20px;
}

#MDPhonENumbeR::placeholder{
color: rgba(255,255,255, 0.5);
}
#MDPhonENumbeR{
	width: 100%;
    border: none;
	background-color: transparent;
    color: #fff ;
	text-align: center;
    font-size:16px;
    font-weight: 300;
    
}

#MDLeadIDEntry::placeholder{
color: rgba(255,255,255, 0.5);
}
#MDLeadIDEntry{
	    width: 100%;
    border: none;
	background-color: transparent;
    color: #fff ;
	text-align: center;
    font-size: 16px;
    font-weight: 300;
    
}

.button-remove::before{

      width: 0;
    height: 0;
    border-top: 11px solid transparent;
    border-right: 11px solid #1f2b37;
    border-bottom: 11px solid transparent;
    position: absolute;
    content: "";
    left: -11px;
    top: 0;
 
}
.button-remove{
	background-color: #1f2b37;
/*    padding: 5px 6px;*/
    border: none;
    color: #fff;
    font-size: 10px !important;
    float: right;
    margin-top: -42px;
    z-index: 9999;
/*    overflow: hidden;*/
/*    display: block;*/
	position: relative;
	    display: flex;
    align-items: center;
    justify-content: center;
	height: 21px;
	width: 23px;
}
.button-remove i{
	opacity: 0.6;
}
.button-remove:hover i{
	opacity: 1;
}
.close-btn-right:hover{
	opacity: 1;
}
#Manual_Dial_Box h2{
	float: left;
	margin: 0;
	padding: 0;
	margin-top: 17px;
    font-size: 16px;font-weight: 500;
    opacity: 0.9;
    margin-left: 25px;color: #fff;
}
.fixed-menu{
	    position: absolute;
/*    overflow: hidden;*/
    left: 0;
    bottom: 0;
}
.st-call{
	position: relative;
}
#status {
   
    right: 16px;
    top: 16px;

    color: #fff;
}
.span_1{
	width: 100%;
	display: block;
	clear: both;
}
.span_1 {
	    margin: 0 auto;
    text-align: center;
    display: block;
    padding: 0;
    width: 60px;
    height: 60px;
}
.m-loader:before{
	    left: 0 !important;
}
.loader-mg{
	margin: 0 auto;
    text-align: center;
    display: block;
    position: relative;
}
.m-loader:before{
	margin: 0 auto;
	text-align: center;
	display: block;
}
.span_1{
	width: 56px !important;
	padding: 0 !important;
}
.content-wrapper, .main-footer{
	padding-right: 270px;
}

/* new */


.navbar-right {

    background-color: #222e3a;
    margin: 0 0 0 0;
    /* float: left; */
    position: fixed;
    bottom: 0;
    left: 0;
    border-radius: 0;
    /* min-height: calc(100vh - 50px); */
    z-index: 20;
    /* box-shadow: inset 20px 20px 25px 0px rgb(0 0 0 / 10%); */
    /* box-shadow: inset 20px 20px 25px 0px rgb(0 0 0 / 90%); */
    width: 100%;
    height: 50px; z-index: 6;
}
.navbar-right ul{
	list-style: none;
	text-align: right;
	padding: 0;
	margin: 0;
	   
}

.navbar-right ul li{

	display: block;
}



.navbar-right ul li {
float: left;
    /* display: inline-block; */
    /* width: 100%; */
    position: relative;
    text-align: center;
    border-bottom: 1px solid rgba(255,255,255,0.05);
    /* width: 11%; */
    border-right: 1px solid rgba(255,255,255,0.05);
	}
	



.navbar-right ul li a{
	width: 100%;
    color: #fff;
    display: block;
    /* margin-bottom: 7px; */
    text-align: center;
    color: rgba(255,255,255, 0.4);
    /* min-height: 47px; */
    border-top: 2px solid #222e3a;
    padding: 2px 25px;
	}
.navbar-right ul li a i{
	   text-align: center;
	font-size: 21px;
}
.navbar-right ul li a p{
 margin-top: -6px;
    text-align: center;
    font-size: 12px !important;
    
}

.navbar-right ul li a:hover p{
	
	display: block;
}
.navbar-right ul li a:hover {
	color: <?= $brandColorHover; ?>;
	background-color: #161f27;
    border-top: 2px solid <?= $brandColorHover; ?>;

}

.topmenu-active{
	color: <?= $brandColorHover; ?> !important;border-top: 2px solid <?= $brandColorHover; ?> !important;background-color: #161f27 !important;

}

.navbar-right ul li ul li a:hover{
	font-size: 13px;
	text-align: left;
	color: <?= $brandColorHover; ?>;
}

.navbar-right ul ul {
	position: absolute;
	top: 0;
	right: 70px;
	display:none;
	width: 321px;
/*	padding: 10px;*/
	overflow: hidden;
	text-align: left !important;
	background-color: #161f27;
}

.navbar-right ul li:hover ul{
<!--	display: block;-->
	right:70px;
	z-index: 9999;
	text-align: left;
	background-color: #161f27;
}
.single-menu li{

/*	background:rgba(34,46,58, 0.95) !important;
	background-color: #161f27;
	
	
}
.single-menu li a{
	font-size: 16px !important;
	padding-left: 25px;
	border: none !important;
	color: #fff !important;
	    padding: 15px 12px 15px 20px !important;
	
}

.navbar-right ul ul h2{
/*	background-color: #222e3a;*/
	border-radius: 0;
	color: #fff;
	padding:0;
	font-size: 18px;margin: 0 0 10px 0;
}
.large-menu li a i{
	margin-right: 6px;
}
.large-menu li a{
	font-size: 16px !important;
	color: #8f9dab !important;
	padding: 11px 22px 11px 15px !important;
}


#HotKeyEntriesBox p{
	font-size: 11px;
color: rgba(255,255,255,0.80);
text-align: left;margin: 0 0 10px 0;
}


/* notification */

#hotkeysdisplay .text-red{
	color: #1999cc !important;
	color: #1999cc;border-right: 2px solid #1999cc;background-color: #161f27 !important;
}

.navbar-right ul li ul li{
	    background: #222e3a !important;
    text-align: left !important;
    overflow: hidden;
    color: #fff !important;
    font-weight: 500;
    font-size: 14px !important;
    border-left: 2px solid <?= $brandColor; ?>;
	}

.navbar-right ul li ul li span{
	clear: both;
	width: 110%;overflow: hidden;
	padding: 3px 0;
	display: block;
	border-bottom: 1px solid #161f27;
	margin-left: -11px;
}







.pause-code{
	background-color: <?= $brandColor; ?>;
	height: 61px;
	width: 61px;
	color: #fff !important;
	border-radius: 0;
	display: flex;
	align-items: center;
	justify-content: center;
	padding: 14px 0 0 0 !important;text-align: center;
}



.dropdwon-hotkeys li{
	font-size: 14px;
	color: #9d9d9d;
	font-weight: 400;
	border-left: none;
	padding-left: 10px !important;
	margin: 0;
	padding: 0;
	height: auto;
	display: block;
	clear: both;
	cursor: default !important;
/*	background-color: #161f27 !important;*/
}





.control-sidebar.control-sidebar-open, .control-sidebar.control-sidebar-open + .control-sidebar-bg {
    right: 70px;
}
#main_sidebar{
	z-index: 7 !important;
}
#Header {
 
    z-index: 8 !important;
}
.sidebar-menus ul ul {
    position: absolute;
    top: 0;
    left: -134px;
    display: none;
    width: 270px;
  padding: 0 10px 10px 10px;

    overflow: hidden;
    text-align: left !important;
    background-color: #161f27;
	z-index: 1;
}
.sidebar-menus ul ul li a{
	text-align: center;
    font-size: 16px;
    font-weight: 500;
    padding: 22px 0;
    color: #fff;
    display: block;
    overflow: hidden;
    border-radius: 0;
    opacity: 0.7;
	border: none;
	cursor: pointer;
}
.sidebar-menus ul ul li
{width: 32.8%;
    text-align: center;
    float: left;
    background-color: transparent !important;
    margin-left: 0;
    margin-right: 0;
    border-radius: 0;
    margin-bottom: 0;
    border-right: 1px solid rgba(255,255,255,0.1);
    border-bottom: 1px solid rgba(255,255,255,0.1);}
.sidebar-menus ul ul li:nth-child(5){
	border-right: none;
}
.sidebar-menus ul ul li:nth-child(8){
	border-right: none;
}
.sidebar-menus ul ul li:nth-child(11){
	border-right: none;
}

.sidebar-menus ul ul li:nth-child(12){
	border-bottom: none;
}
.sidebar-menus ul ul li:nth-child(13){
	border-bottom: none;
}
.sidebar-menus ul ul li:nth-child(14){
	border: none;
}

.sidebar-menus ul ul h3{
font-size: 15px;
    color: #fff;
    font-weight: 500;
    width: 108%;
    clear: both;
    display: block;
    color: #fff !important;
    margin-bottom: 0;
    padding: 17px 20px;
    background-color: <?= $brandColorHover; ?>;
    margin-left: -10px;
}
.sidebar-menus ul ul h6{
	font-size: 14px;
	color: #fff;
	font-weight: 400;
	opacity: 0.7;
	width: 100%;
	clear: both;display: block;
	margin: 8px 0;overflow: hidden;
}
.sidebar-menus ul ul li a:hover {
    opacity: 1; background-color: <?= $brandColorHover; ?>;
}
#DtmfControl:hover ul{
	display: block !important;
}
.top-menu-bar li:last-child a{
	background-color: #ec5451;    color: #fff;
}
.top-menu-bar li:last-child a i {
/*    margin-right: 0;*/
    padding: 0 24px;
}
.top-menu-bar li:last-child:hover a{
	background-color: #cb413e;  color: #fff !important;
}
.user-name{
	float: left;
}
.user-name p {
    color: #000;
    font-size: 11px;
    font-weight: 500;
}
#liAgentStatusCalls a{
	background-color: #ebebeb !important;
}
.dialable-leads a{
/*	background-color: #ec5451 !important;*/
/*	color: #ec5451 !important;*/
}


.dialable-leads a span{
	    position: absolute;
    top: 9px;
    left: 28px;
    /* text-align: center; */
    font-size: 11px;
    height: 17px;
    width: auto;
    border-radius: 50px;
    background-color: #ec5451;
    /* line-height: normal; */
    /* padding-left: 2px; */
    padding-left: 5px;
    padding-right: 5px;
    font-weight: 500;
    color: #fff;
    display: flex;
    align-items: center;;
	border: 1px solid #fff;
    justify-content: center;
}
.warning-wrapper a{
/*	background-color: #ec5451 !important;*/
/*	color: #00a65a !important;*/
}


.warning-wrapper a span{
	    position: absolute;
    top: 9px;
    left: 28px;
    /* text-align: center; */
    font-size: 11px;
    height: 17px;
    width: auto;
    border-radius: 50px;
    background-color: #00a65a;
    /* line-height: normal; */
    /* padding-left: 2px; */
    padding-left: 5px;
    padding-right: 5px;
    font-weight: 500;
    color: #fff;
    display: flex;
    align-items: center;
    justify-content: center;
	border: 1px solid #fff;
}

.dialable-box{
	    padding: 0 0 10px 10px;
    background-color: #222e3a;
    border-left: 2px solid <?= $brandColor; ?>;
    margin-bottom: 15px;position: relative;border-radius: 4px;
}
.dialable-box span{
	margin: 8px 10px 0 0;
    width: 44%;
    display: inline-block;
}
.dialable-box span label{
	    font-size: 11px;
    color: #fff;
    opacity: 0.6;
    margin: 0;
}
.dialable-box span h6{
font-size: 12px;
	color: #fff;
}
.top-menu-bar ul ul h2{
	color: #fff !important;
    margin-bottom: 0;
    padding: 10px 20px;
    background-color: #222e3a;
}
.dialbox-btn i{
	padding: 0 !important;
	    height: inherit !important;
    width: inherit !important;
}
.dialbox-btn{
	    background-color: #161f27 !important;
    border: 1px solid rgba(255,255,255,0.10) !important;
    display: inline-block !important;
    font-size: 14px !important;
    padding: 3px 5px!important;
    cursor: pointer !important;
 right: 3px;
    top: 3px;
    color: #1999D0 !important;
    position: absolute;
    height: inherit !important;
    width: inherit !important;
    border-radius: 7px !important;
	
}
.callinqueu{
	padding: 15px 15px 0 15px;
}
.call_in_queu_box {
	
}
/* scorall */
/* Let's get this party started */
.call_in_queu_box::-webkit-scrollbar {
    width: 8px;
	height: 8px;
}
 
/* Track */
.call_in_queu_box::-webkit-scrollbar-track {
/*    -webkit-box-shadow: inset 0 0 6px rgba(0,0,0,0.3); */
	-webkit-border-radius: 0px;
    border-radius: 0px;
}
 
/* Handle */
.call_in_queu_box::-webkit-scrollbar-thumb {
    -webkit-border-radius: 0px;
    border-radius: 0px;
/*	background: rgba(69,92,115,1);*/
	background: rgba(255,255,255,0.30) !important;
	border-radius: 50px;
    -webkit-box-shadow: inset 0 0 6px rgba(0,0,0,0.8);
	
	
	
}
.call_in_queu_box::-webkit-scrollbar-thumb:window-inactive {
	background: rgba(255,255,255,0.30) !important;
	border-radius: 50px;
}

/* right-nav-large */
.right-nav-large .navbar-right ul li a i{
	 margin-right: 15px !important;
    float: right;
    width: 40px;
}
.right-nav-large .navbar-right ul li a:hover p{
	color: #1ab394;
}
.right-nav-large .navbar-right ul li a p{
	display: block;
	position: inherit;
	width: auto;
	float: right;
    text-align: right;
	background-color: inherit !important;
    color: rgba(255,255,255, 0.4);
	    min-height: 45px;
}
.right-nav-large .navbar-right ul ul{
	position: inherit;
	transition: 0;
	right: 0;

}
.right-nav-large .navbar-right ul li:hover ul{

	right: 0;
	transition: 2s;

}
.right-nav-large .navbar-right ul li a{
	cursor: pointer;
}
.right-nav-large .warningclr2 {
    top: 15px;
	left: 20px;}
.right-nav-large .content-wrapper, .main-footer {
    padding-right: 325px !important;
}
.right-nav-large .navbar-right ul ul h2 {
    
    background-color: #0a131a;
}
.right-nav-large .navbar-right{
	    width: 321px;
	box-shadow: inherit !important;
}


/* end right-nav-large */


.manual_dial_hangupon{
	display: block;
	width: 100%;
	background-color: #d9534f;

    padding: 5px 0;
    color: #fff;
    border: none;
    border-radius: 3px;
    margin-bottom: 10px;
}

.manual_dial_hangupoff{
		width: 100%;
	background-color: #d9534f;

    padding: 5px 0;
    color: #fff;
    border: none;
    border-radius: 3px;
    margin-bottom: 10px;
pointer-events: none ;
	opacity: 0.65;
	
}
.top-line-status{
	background-color: #161f27;
	padding: 5px 10px;
	overflow: hidden;display: block;
}


/* new hangup */

#HangupControl a p{
	font-weight: 400;
    text-align: center;
    font-size: 13px !important;
    display: block !important;
}
#HangupControl .hangup_on:hover{

    background-color: #d63a37;
}

#HangupControl .hangup_off:hover{
background-color: #455c73 !important;
cursor: defult !important;
opacity: 0.5;
}
#HangupControl .hangup_off{

background-color: #455c73 !important;
cursor: defult !important;  border-radius: 3px;
opacity: 0.5;
}
#HangupControl .hangup_on{
 color: #fff !important;
  background-color: #ec5451 !important;
cursor: pointer !important;  border-radius: 7px;
}
#HangupControl a{
	border: none;
	font-size: 15px;
    color: #fff !important;
    min-height: auto;
    overflow: hidden;
    padding: 8px 55px;
    text-align: center;
    display: inline-block;
    float: none;	
  
}
#HangupControl i{
	display: none !important;
}
#HangupControl{
	display: block;
    width: 100%;
    border: none;
    position: inherit;
    text-align: center;
	padding:6px 0; overflow: hidden;

}


.button-remove{
	display: none;
}

/* web form */


.div-webforms{
	    overflow: hidden;
    position: fixed;
    bottom: 0;
    width: 270px;
    z-index: 9999999999;
    right: 268px;
    border-left: 1px solid rgba(255,255,255,0.05);
}
.div-webforms ul li a i{
	min-height: inherit;
    max-height: inherit;
}
.div-webforms ul li a{
	    display: block;
    width: 100%;
	display: block;
    width: 100%;
    border-bottom: none;
    min-height: inherit;
    /* padding: 0; */
    padding: 4px 0 4px 0;
}
.div-webforms ul li{
	flex-grow: 1;
    flex-basis: 0;
    min-width: 33.333%;
    /* background-color: #23ba9b; */
    /* margin: 0 2px; */
    width: inherit;
    position: inherit;
    float: none;
    display: inherit;
	text-align: center;
}
.div-webforms ul{
	display: flex;
    flex-flow: row wrap;
    align-items: flex-start;
}
.div-webforms ul li a p{
	margin-top: -2px;
}
/*
.div-webforms{
	display: none;
}

*/
#RecorDControl i{
font-size:25px;}


.btn-brand {
    display: inline-block;
    padding: 0.5rem 1rem;
    font-size: 1rem;
    line-height: 1.25;
    background-color: <?= $brandColor ?>;
    border: 1px solid <?= $brandColor ?>;
    color: #ffffff;
    text-decoration: none;
    border-radius: 0.25rem;
    cursor: pointer;
    transition: background-color 0.15s ease, border-color 0.15s ease;
}

.btn-brand:hover {
    background-color: <?= $brandColorHover ?>;
    border-color: <?= $brandColorHover ?>;
    color: #ffffff;
    text-decoration: none;
}

.btn-brand:focus,
.btn-brand:active {
    outline: none;
    box-shadow: 0 0 0 0.2rem rgba(<?= hexdec(substr($brandColor,1,2)) ?>, <?= hexdec(substr($brandColor,3,2)) ?>, <?= hexdec(substr($brandColor,5,2)) ?>, 0.5);
}